/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgControlSchemeInfo;
import com.kingdee.eas.ma.budget.BgCtrlException;
import com.kingdee.eas.ma.budget.BgCtrlTypeEnum;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.client.AbstractBgSchemeVerifyResultUI;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgSchemeVerifyResultUI
extends AbstractBgSchemeVerifyResultUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BgSchemeVerifyResultUI.class);
    private static final String RESORRCE = "com.kingdee.eas.ma.budget.BgSchemeResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.buildKDTable();
        this.toolBar.setVisible(true);
        this.menuBar.setVisible(false);
        this.btnPrint.setEnabled(true);
        this.btnPrintPreview.setEnabled(true);
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
    }

    protected void buildKDTable() throws EASBizException, BOSException {
        Map msg = (Map)this.getUIContext().get("MSG");
        String orgUnitId = (String)this.getUIContext().get("orgUnitId");
        String value = null;
        this.tblMain.getScriptManager().setAutoRun(false);
        this.tblMain.setRefresh(true);
        this.tblMain.checkParsed(true);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.setDefaultRowHeight(20);
        this.tblMain.setDefaultColumnWidth(120);
        this.tblMain.addHeadRow();
        this.tblMain.addColumns(6);
        this.tblMain.getColumn(4).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getFormatStringForTable(2));
        IRow titleRow = this.tblMain.addRow();
        this.tblMain.getMergeManager().mergeBlock(titleRow.getRowIndex(), 0, titleRow.getRowIndex(), 5, 4);
        IRow operatorRow = this.tblMain.addRow();
        this.tblMain.getMergeManager().mergeBlock(operatorRow.getRowIndex(), 0, operatorRow.getRowIndex(), 5, 4);
        IRow timeRow = this.tblMain.addRow();
        this.tblMain.getMergeManager().mergeBlock(timeRow.getRowIndex(), 0, timeRow.getRowIndex(), 5, 4);
        titleRow.getCell(0).setValue((Object)EASResource.getString((String)RESORRCE, (String)"ctrl1"));
        operatorRow.getCell(0).setValue((Object)MessageFormat.format(EASResource.getString((String)RESORRCE, (String)"ctrl2"), SysContext.getSysContext().getCurrentUserInfo().getName()));
        timeRow.getCell(0).setValue((Object)MessageFormat.format(EASResource.getString((String)RESORRCE, (String)"ctrl3"), BgNationalFormatUIUtil.getNationalDateTimeFormat().format(new Date())));
        IRow row = this.tblMain.addRow();
        this.tblMain.getMergeManager().mergeBlock(row.getRowIndex(), 0, row.getRowIndex(), 5, 4);
        row = this.tblMain.addRow();
        this.tblMain.getMergeManager().mergeBlock(row.getRowIndex(), 0, row.getRowIndex(), 5, 4);
        row.getCell(0).setValue((Object)EASResource.getString((String)RESORRCE, (String)"ctrl4"));
        row = this.tblMain.addRow();
        this.tblMain.getMergeManager().mergeBlock(row.getRowIndex(), 0, row.getRowIndex(), 5, 4);
        row.getCell(0).setValue((Object)((String)msg.get("FORMAL")));
        row = this.tblMain.addRow();
        this.tblMain.getMergeManager().mergeBlock(row.getRowIndex(), 0, row.getRowIndex(), 5, 4);
        row = this.tblMain.addRow();
        this.tblMain.getMergeManager().mergeBlock(row.getRowIndex(), 0, row.getRowIndex(), 5, 4);
        row.getCell(0).setValue((Object)EASResource.getString((String)RESORRCE, (String)"ctrl7"));
        Map.Entry entry2 = null;
        if (msg.get("CTRL") != null) {
            Map ctrlMap = (Map)msg.get("CTRL");
            BgControlSchemeInfo ctrlSchemeInfo = null;
            for (Map.Entry entry2 : ctrlMap.entrySet()) {
                row = this.tblMain.addRow();
                this.tblMain.getMergeManager().mergeBlock(row.getRowIndex(), 0, row.getRowIndex(), 5, 4);
                ctrlSchemeInfo = (BgControlSchemeInfo)entry2.getValue();
                value = ctrlSchemeInfo.getNumber() + " " + ctrlSchemeInfo.getName() + " " + ctrlSchemeInfo.getSubSystemAlias() + " " + ctrlSchemeInfo.getBoAlias() + " " + EASResource.getString((String)RESORRCE, (String)"ctrl9");
                row.getCell(0).setValue((Object)value);
            }
        } else {
            row = this.tblMain.addRow();
            this.tblMain.getMergeManager().mergeBlock(row.getRowIndex(), 0, row.getRowIndex(), 5, 4);
            row.getCell(0).setValue((Object)EASResource.getString((String)RESORRCE, (String)"ctrl10"));
        }
        row = this.tblMain.addRow();
        this.tblMain.getMergeManager().mergeBlock(row.getRowIndex(), 0, row.getRowIndex(), 5, 4);
        row = this.tblMain.addRow();
        this.tblMain.getMergeManager().mergeBlock(row.getRowIndex(), 0, row.getRowIndex(), 5, 4);
        row.getCell(0).setValue((Object)EASResource.getString((String)RESORRCE, (String)"ctrl11"));
        row = this.tblMain.addRow();
        this.tblMain.getMergeManager().mergeBlock(row.getRowIndex(), 0, row.getRowIndex(), 5, 4);
        row.getCell(0).setValue((Object)((String)msg.get("ISCTRL")));
        row = this.tblMain.addRow();
        this.tblMain.getMergeManager().mergeBlock(row.getRowIndex(), 0, row.getRowIndex(), 5, 4);
        row = this.tblMain.addRow();
        this.tblMain.getMergeManager().mergeBlock(row.getRowIndex(), 0, row.getRowIndex(), 5, 4);
        row.getCell(0).setValue((Object)EASResource.getString((String)RESORRCE, (String)"ctrl15"));
        if (msg.get("FORM") != null) {
            Map formMap = (Map)msg.get("FORM");
            Iterator ite = formMap.entrySet().iterator();
            while (ite.hasNext()) {
                row = this.tblMain.addRow();
                this.tblMain.getMergeManager().mergeBlock(row.getRowIndex(), 0, row.getRowIndex(), 5, 4);
                entry2 = ite.next();
                row.getCell(0).setValue((Object)((String)entry2.getValue()));
            }
        }
        row = this.tblMain.addRow();
        this.tblMain.getMergeManager().mergeBlock(row.getRowIndex(), 0, row.getRowIndex(), 5, 4);
        row = this.tblMain.addRow();
        row.getCell(0).setValue((Object)EASResource.getString((String)RESORRCE, (String)"ctrl18"));
        if (msg.get("ITEM") != null) {
            Map itemMap = (Map)msg.get("ITEM");
            Hashtable ctrlModeMap = (Hashtable)itemMap.get("ctrlModeMap");
            Vector itemAndElement = (Vector)itemMap.get("itemAndElement");
            row = this.tblMain.addRow();
            row.getCell(0).setValue((Object)EASResource.getString((String)RESORRCE, (String)"ctrl19"));
            row.getCell(1).setValue((Object)EASResource.getString((String)RESORRCE, (String)"ctrl20"));
            row.getCell(2).setValue((Object)EASResource.getString((String)RESORRCE, (String)"ctrl21"));
            row.getCell(3).setValue((Object)EASResource.getString((String)RESORRCE, (String)"ctrl27"));
            row.getCell(4).setValue((Object)EASResource.getString((String)RESORRCE, (String)"ctrl22"));
            row.getCell(5).setValue((Object)EASResource.getString((String)RESORRCE, (String)"ctrl25"));
            this.initItem(ctrlModeMap, itemAndElement, orgUnitId);
        }
    }

    private void initItem(Hashtable ctrlModeMap, Vector itemAndElement, String orgUnitId) throws EASBizException, BOSException {
        if (ctrlModeMap == null || itemAndElement == null) {
            return;
        }
        IBgItem iBgItem = BgItemFactory.getRemoteInstance();
        IBgElement iBgE = BgElementFactory.getRemoteInstance();
        BgElementInfo ele = null;
        BigDecimal one = new BigDecimal("1");
        Object obj = null;
        HashMap<String, String> bgElementMap = new HashMap<String, String>();
        HashMap<String, String> queryBgItemMap = new HashMap<String, String>();
        for (int i = 0; i < itemAndElement.size(); ++i) {
            String key = (String)itemAndElement.get(i);
            if (key == null) continue;
            String[] temp = key.split("_");
            String itemCombin = temp[0];
            String element = temp[1];
            if (itemCombin == null) continue;
            temp = itemCombin.split(",");
            for (int j = 0; j < temp.length; ++j) {
                queryBgItemMap.put(temp[j], null);
            }
        }
        if (!queryBgItemMap.isEmpty()) {
            String orgId = BgSHelper.getIsolateOrg(orgUnitId);
            int maxBatch = 1000;
            HashSet<Object> numberSet = new HashSet<Object>();
            Object[] numbers = queryBgItemMap.keySet().toArray();
            queryBgItemMap.clear();
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("name");
            evi.getSelector().add("number");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgId));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
            int batchCount = BgNSQLHelper.getBatchCount((int)numbers.length, (int)maxBatch);
            for (int i = 0; i < batchCount; ++i) {
                BgItemCollection col;
                int index;
                numberSet.clear();
                for (int in = 0; in < maxBatch && (index = i * maxBatch + in) < numbers.length; ++in) {
                    numberSet.add(numbers[index]);
                }
                if (numberSet.isEmpty() || (col = iBgItem.getBgItemCollection(evi)) == null || col.isEmpty()) continue;
                for (int in = 0; in < col.size(); ++in) {
                    queryBgItemMap.put(col.get(in).getNumber(), col.get(in).getName());
                }
            }
        }
        HashMap<String, String> itemMap = new HashMap<String, String>();
        for (int i = 0; i < itemAndElement.size(); ++i) {
            String name = "";
            String key = (String)itemAndElement.get(i);
            if (key == null) continue;
            if (itemMap.containsKey(key)) {
                name = (String)itemMap.get(key);
            } else {
                String[] temp = key.split("_");
                String itemCombin = temp[0];
                String element = temp[1];
                if (itemCombin == null) continue;
                temp = itemCombin.split(",");
                for (int j = 0; j < temp.length; ++j) {
                    if (!(queryBgItemMap.get(temp[j]) instanceof String)) {
                        throw new BgCtrlException(BgCtrlException.NOTEXISTBGITEM, new Object[]{temp[j]});
                    }
                    name = name + queryBgItemMap.get(temp[j]) + "_";
                }
                name = name.substring(0, name.length() - 1);
                if (bgElementMap.containsKey(element)) {
                    name = name + "(" + bgElementMap.get(element) + ")";
                } else {
                    try {
                        ele = iBgE.getBgElementInfo("select name where number='" + element + "'");
                    }
                    catch (ObjectNotFoundException e) {
                        throw new BgCtrlException(BgCtrlException.NOTEXISTBGELEMENT, new Object[]{element});
                    }
                    if (ele == null) continue;
                    name = name + "(" + ele.getName() + ")";
                    bgElementMap.put(element, ele.getName());
                }
                itemMap.put(key, name);
            }
            IRow row = this.tblMain.addRow();
            Hashtable map = null;
            if (ctrlModeMap.containsKey(key)) {
                map = (Hashtable)ctrlModeMap.get(key);
            }
            if (map == null) {
                map = new Hashtable();
            }
            Boolean isFlexCtrl = map.get("isFlexCtrl") == null ? Boolean.FALSE : (Boolean)map.get("isFlexCtrl");
            Boolean isAllowAccess = map.get("isAllowAccess") instanceof Boolean ? (Boolean)map.get("isAllowAccess") : Boolean.FALSE;
            BigDecimal flexCtrlParam = map.get("flexCtrlParam") == null ? one : (BigDecimal)map.get("flexCtrlParam");
            int periodCtrlPolicy = map.get("periodCtrlPolicy") == null ? -1 : (Integer)map.get("periodCtrlPolicy");
            int groupNo = map.get("groupCtrlNo") == null ? -1 : (Integer)map.get("groupCtrlNo");
            row.getCell(0).setValue((Object)key.replaceAll(",", "_"));
            row.getCell(1).setValue((Object)name);
            if (periodCtrlPolicy == 10) {
                row.getCell(2).setValue((Object)EASResource.getString((String)RESORRCE, (String)"ctrl28"));
            } else if (periodCtrlPolicy == 11) {
                row.getCell(2).setValue((Object)EASResource.getString((String)RESORRCE, (String)"ctrl29"));
            } else if (periodCtrlPolicy == 12) {
                row.getCell(2).setValue((Object)EASResource.getString((String)RESORRCE, (String)"ctrl30"));
            } else if (periodCtrlPolicy == 20) {
                row.getCell(2).setValue((Object)BgCtrlTypeEnum.ThisYearCtrl.getAlias());
            }
            row.getCell(3).setValue((Object)isAllowAccess);
            row.getCell(4).setValue((Object)flexCtrlParam);
            row.getStyleAttributes().setLocked(true);
            if (groupNo == -1) continue;
            row.getCell(5).setValue((Object)new Integer(groupNo));
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
        this.tblMain.getIOManager().exportExcelToTempFile(false);
    }
}

