/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.AssignSolutionCollection;
import com.kingdee.eas.ma.budget.AssignSolutionFactory;
import com.kingdee.eas.ma.budget.AssignSolutionInfo;
import com.kingdee.eas.ma.budget.AssignSolutionTypeEnum;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.IAssignSolution;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.OrgUnitUtils;
import com.kingdee.eas.ma.budget.client.AbstractBgSubOrgUnitSelectUIForForm;
import com.kingdee.eas.ma.budget.client.AssignSolutionInterface;
import com.kingdee.eas.ma.budget.client.AssignSolutionUI;
import com.kingdee.eas.ma.budget.client.BgFormActualListUI;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.budget.client.NewAssignSolutionUI;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgOrgTypeViewEnum;
import com.kingdee.eas.ma.nbudget.SheetInfo;
import com.kingdee.eas.ma.nbudget.client.BgFormSheetDialog;
import com.kingdee.eas.ma.nbudget.client.BgNActualRecordListUI;
import com.kingdee.eas.ma.nbudget.client.BgNActualRecordProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFormActualProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgNFormAdjustListUI;
import com.kingdee.eas.ma.nbudget.client.BgNFormAdjustProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgNFormListUI;
import com.kingdee.eas.ma.nbudget.client.BgNFormProcessUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BgSubOrgUnitSelectUIForForm
extends AbstractBgSubOrgUnitSelectUIForForm
implements AssignSolutionInterface {
    private static final long serialVersionUID = 7073110391229502348L;
    private static final Logger logger = CoreUIObject.getLogger(BgSubOrgUnitSelectUIForForm.class);
    private boolean hasCancel = true;
    private Set financeOrgSet;
    private Set costCenterIDSet;
    private Set<String> solOrgUnitIds = null;
    private static final Color NOFINANCE = Color.GRAY;
    private static final Color NO_DISPATCHED = Color.BLACK;
    private TreeWillExpandListener listener = new TreeWillExpandListener(){

        @Override
        public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)e.getPath().getLastPathComponent();
            try {
                OrgUnitUtils.addChildNode(node, BgSubOrgUnitSelectUIForForm.this.solOrgUnitIds, true);
            }
            catch (Exception ex) {
                ExceptionHandler.handle((String)"add node error", (Throwable)ex);
            }
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
        }
    };
    public static final String RES_PATH = "com.kingdee.eas.ma.nbudget.BgSchemeUnAssignResource";
    KDPopupMenu popMenu = new KDPopupMenu();

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        if (this.getUIContext().get("PANELUI") instanceof NewAssignSolutionUI) {
            Rectangle rect = this.getBounds();
            NewAssignSolutionUI ui = (NewAssignSolutionUI)this.getUIContext().get("PANELUI");
            rect.width = 430;
            this.setBounds(rect);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        Rectangle rect = this.getBounds();
        if (this.getUIContext().get("PANELUI") instanceof AssignSolutionUI) {
            AssignSolutionUI ui = (AssignSolutionUI)((Object)this.getUIContext().get("PANELUI"));
            Rectangle uiRect = ui.getBounds();
            Rectangle panelRect = ui.kDPanel4.getBounds();
            Window window = (Window)ui.getUIWindow();
            Rectangle diaRect = window.getBounds();
            rect.width = 430;
            uiRect.width -= 400;
            panelRect.x -= 400;
            diaRect.width -= 400;
            this.setBounds(rect);
            ui.setBounds(uiRect);
            ui.kDPanel4.setBounds(panelRect);
            window.setBounds(diaRect);
        }
    }

    protected IBgForm getInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    protected IAssignSolution getSoluationInterface() throws Exception {
        return AssignSolutionFactory.getRemoteInstance();
    }

    public boolean isHasCancel() {
        return this.hasCancel;
    }

    public void setHasCancel(boolean hasCancel) {
        this.hasCancel = hasCancel;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnMoveAllRight.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnMoveRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnMoveLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnMoveAllLeft.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnMoveToTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnMoveTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveBotton.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnMoveToBotton.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
    }

    protected void init() throws Exception {
        this.initBase();
        this.initOrgUnitInfo();
        this.initSheetName();
        this.iniPoppMenu();
        this.orgComboBox.addItem((Object)BgOrgTypeViewEnum.All);
        this.orgComboBox.addItem((Object)BgOrgTypeViewEnum.company);
        this.orgComboBox.addItemListener((ItemListener)new OrgListener());
    }

    private void selectedAllOrg(DefaultKingdeeTreeNode root) {
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            node.setTextColor(NO_DISPATCHED);
            node.setCheckBoxVisible(true);
            node.setCheckBoxEnabled(true);
            if (node.getChildCount() <= 0) continue;
            this.selectedAllOrg(node);
        }
    }

    private void selectedFinanceOrg(DefaultKingdeeTreeNode root) {
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            if (!(node.getUserObject() instanceof OrgStructureInfo)) continue;
            OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
            if (!this.getFinanceOrgSet().contains(oui.getUnit().getId().toString())) {
                node.setTextColor(NOFINANCE);
                node.setCheckBoxVisible(false);
                node.setCheckBoxEnabled(false);
            }
            if (node.getChildCount() <= 0) continue;
            this.selectedFinanceOrg(node);
        }
    }

    protected void initBase() throws Exception {
        this.comOrgType.addItem((Object)OrgViewType.COSTCENTER);
        this.comOrgType.setSelectedItem((Object)OrgViewType.COSTCENTER);
        this.comOrgType.setEnabled(false);
        this.treeOrgUnit.setShowCheckBox(true);
        if (this.getUIContext().get("FIXEDFORM") != null) {
            this.isGatherOther.setSelected(false);
            this.isGatherOther.setVisible(true);
        } else if (this.getUIContext().get("VIEWDFORM") != null) {
            this.isGatherOther.setSelected(false);
            this.isGatherOther.setVisible(false);
            this.kDLabel1.setVisible(false);
            this.raGatherAllSheet.setVisible(false);
            this.raGatherSelSheet.setVisible(false);
            this.prmtSelectSheet.setVisible(false);
        } else {
            this.isGatherOther.setSelected(false);
            this.isGatherOther.setVisible(false);
        }
        this.initSetParameter();
        this.treeOrgUnit.setShowPopMenuDefaultItem(false);
    }

    protected void selectSubOrgUnitMenuItem_actionPerformed(ActionEvent e) {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (root != null) {
            DefaultKingdeeTreeNode _node = null;
            int in = root.getChildCount();
            for (int i = 0; i < in; ++i) {
                _node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                if (_node == null) continue;
                _node.setChecked(true);
            }
        }
    }

    protected void initSetParameter() throws Exception {
        Object ui = this.getUIContext().get("Owner");
        if (ui != null) {
            this.isGatherByPeriod.setEnabled(false);
            this.isGatherByPeriod.setVisible(false);
            this.isGatherByPeriod.setSelected(false);
            if (ui instanceof BgNFormListUI || ui instanceof BgNFormProcessUI) {
                this.setUITitle(BgNFCHelper.getMessageStr((String)"title_Gather_Budget"));
                this.isGatherByPeriod.setVisible(false);
            } else if (ui instanceof BgFormActualListUI || ui instanceof BgNFormActualProcessUI) {
                this.setUITitle(BgNFCHelper.getMessageStr((String)"title_Gather_Actual"));
                this.btnShowOrg.setVisible(false);
                this.isGatherAdjust.setSelected(false);
                this.isGatherAdjust.setEnabled(false);
                this.isGatherAdjust.setVisible(false);
                this.raGatherFormula.setSelected(true);
                this.raGatherFormula.setEnabled(false);
                this.raGatherFormula.setVisible(false);
                this.raGatherEnumErate.setSelected(false);
                this.raGatherEnumErate.setEnabled(false);
                this.raGatherEnumErate.setVisible(false);
                Rectangle rectangle = this.isShowMsg.getBounds();
                rectangle.x = 10;
                this.isShowMsg.setBounds(rectangle);
                Rectangle rectangle1 = this.isClearFormula.getBounds();
                rectangle1.y = rectangle.y;
                rectangle1.x += 15;
                this.isClearFormula.setBounds(rectangle1);
            } else if (ui instanceof BgNFormAdjustListUI || ui instanceof BgNFormAdjustProcessUI) {
                this.setUITitle(BgNFCHelper.getMessageStr((String)"title_Gather_Adjust"));
                this.isGatherAdjust.setSelected(true);
            } else if (ui instanceof BgNActualRecordListUI || ui instanceof BgNActualRecordProcessUI) {
                this.setUITitle(BgNFCHelper.getMessageStr((String)"title_Gather_Add"));
                this.btnShowOrg.setVisible(false);
                this.isGatherAdjust.setSelected(false);
                this.isGatherAdjust.setEnabled(false);
                this.isGatherAdjust.setVisible(false);
                this.raGatherFormula.setSelected(true);
                this.raGatherFormula.setEnabled(false);
                this.raGatherFormula.setVisible(false);
                this.raGatherEnumErate.setSelected(false);
                this.raGatherEnumErate.setEnabled(false);
                this.raGatherEnumErate.setVisible(false);
                Rectangle rectangle = this.isShowMsg.getBounds();
                rectangle.x = 10;
                this.isShowMsg.setBounds(rectangle);
                Rectangle rectangle1 = this.isClearFormula.getBounds();
                rectangle1.y = rectangle.y;
                rectangle1.x += 15;
                this.isClearFormula.setBounds(rectangle1);
                this.isGatherOther.setSelected(false);
                this.isGatherOther.setVisible(true);
                this.isGatherByPeriod.setEnabled(true);
                this.isGatherByPeriod.setVisible(true);
                this.isGatherByPeriod.setSelected(false);
            }
        }
        this.raGatherFormula.setVisible(false);
        this.raGatherEnumErate.setVisible(false);
    }

    protected void initOrgUnitInfo() throws Exception {
        TreeModel _model = null;
        String CURR_ORGUNIT_ID = (String)this.getUIContext().get("ORGUNIT_CU");
        try {
            _model = OrgUnitUtils.getOrgTreeModel(this.treeOrgUnit, CURR_ORGUNIT_ID, this.listener);
        }
        catch (Exception err) {
            this.handUIException(err);
        }
        this.initOrgUnitTree(_model);
        this.initOrgUnitTable(_model);
    }

    protected void initOrgUnitTree(TreeModel model) throws Exception {
        if (model == null) {
            return;
        }
        this.treeOrgUnit.setModel(model);
        DefaultKingdeeTreeNode _node = (DefaultKingdeeTreeNode)model.getRoot();
        if (_node != null) {
            _node.setCheckBoxVisible(false);
            _node.setCheckBoxEnabled(false);
        }
    }

    protected void initOrgUnitTable(TreeModel model) throws Exception {
        this.tblOrgUnit.checkParsed();
        this.tblOrgUnit.getSelectManager().setSelectMode(2);
        if (model == null) {
            return;
        }
        IRow row = null;
        OrgStructureInfo _osi = null;
        FullOrgUnitInfo _unitInfo = null;
        DefaultKingdeeTreeNode _node = null;
        DefaultKingdeeTreeNode _root = (DefaultKingdeeTreeNode)model.getRoot();
        int in = _root.getChildCount();
        for (int i = 0; i < in; ++i) {
            row = this.tblOrgUnit.addRow();
            _node = (DefaultKingdeeTreeNode)_root.getChildAt(i);
            _osi = (OrgStructureInfo)_node.getUserObject();
            _unitInfo = _osi.getUnit();
            row.setUserObject((Object)_unitInfo);
            row.getCell(0).setValue((Object)Boolean.FALSE);
            row.getCell(1).setValue((Object)_unitInfo.getNumber());
            row.getCell(2).setValue((Object)_unitInfo.getName());
        }
        this.tblOrgUnit.getColumn(1).getStyleAttributes().setLocked(true);
        this.tblOrgUnit.getColumn(2).getStyleAttributes().setLocked(true);
    }

    private void initSheetName() throws Exception {
        Object obj = this.getUIContext().get("BGFORM_ID");
        if (obj != null && obj instanceof String) {
            String bgFormId = obj.toString();
            String bgFormName = (String)this.getUIContext().get("BGFORM_NAME");
            String[] sheetStr = null;
            SheetInfo sheetInfo = null;
            SheetInfo[] sheetsInfo = null;
            BgFormSheetDialog bgFormSheetDialog = null;
            obj = this.getUIContext().get("BGFORM_SHEET");
            boolean isAdjustSheet = false;
            Object adjustId = this.getUIContext().get("GATHER_ADJ_FORM_ID");
            if (adjustId != null) {
                isAdjustSheet = true;
            }
            if (obj == null) {
                List sheets = null;
                sheets = isAdjustSheet ? this.getInterface().getSheetName(adjustId.toString()) : this.getInterface().getSheetName(bgFormId);
                if (sheets != null && !sheets.isEmpty()) {
                    sheetStr = (String[])sheets.get(0);
                    sheetInfo = new SheetInfo();
                    sheetInfo.setBgFormId(bgFormId);
                    sheetInfo.setSheetId(sheetStr[0]);
                    sheetInfo.setSheetName(sheetStr[1]);
                    this.prmtSelectSheet.setData((Object)new SheetInfo[]{sheetInfo});
                }
            } else {
                sheetsInfo = (SheetInfo[])obj;
                this.prmtSelectSheet.setData((Object)new SheetInfo[]{sheetsInfo[0]});
            }
            bgFormSheetDialog = new BgFormSheetDialog((IUIObject)this);
            if (isAdjustSheet) {
                bgFormSheetDialog.setBgFormId(adjustId.toString());
            } else {
                bgFormSheetDialog.setBgFormId(bgFormId);
            }
            bgFormSheetDialog.setBgFormName(bgFormName);
            bgFormSheetDialog.setSheets(sheetsInfo);
            this.prmtSelectSheet.setSelector((KDPromptSelector)bgFormSheetDialog);
        }
    }

    @Override
    public boolean conferm(Object invokeUi) throws Exception {
        this.btnSubmit_actionPerformed(null);
        return true;
    }

    @Override
    protected void btnSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyData();
    }

    @Override
    public boolean cancel() throws Exception {
        this.btnCancel_actionPerformed(null);
        return true;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setHasCancel(true);
    }

    @Override
    public void verifyData() throws Exception {
        List sort;
        Map solution = this.getSolutionInfo();
        Set orgUnits = (Set)solution.get("GATHER_ORGUNIT");
        if (orgUnits.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"selectOrgUnit"));
            SysUtil.abort();
        }
        if (this.raGatherSelSheet.isSelected() && this.prmtSelectSheet.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"selectSheetError"));
            SysUtil.abort();
        }
        if (!(sort = (List)solution.get("GATHER_SORT")).isEmpty()) {
            int sortSize = sort.size();
            int orgSize = orgUnits.size();
            if (orgSize != sortSize) {
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"amountError"));
                SysUtil.abort();
            }
            String orgUnitId = null;
            int in = sort.size();
            for (int i = 0; i < in; ++i) {
                orgUnitId = (String)sort.get(i);
                if (orgUnits.contains(orgUnitId)) continue;
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"selectOrgUnitError"));
                SysUtil.abort();
            }
        }
        this.setHasCancel(false);
    }

    @Override
    protected void raAllOrgUnit_actionPerformed(ActionEvent e) throws Exception {
        super.raAllOrgUnit_actionPerformed(e);
        if (this.raAllOrgUnit.isSelected()) {
            this.tblOrgUnit.setVisible(false);
            this.treeViewOrgUnit.setVisible(true);
            this.kdOrgUnitSort.removeAllElements();
        }
    }

    @Override
    protected void raImmOrgUnit_actionPerformed(ActionEvent e) throws Exception {
        super.raImmOrgUnit_actionPerformed(e);
        if (this.raImmOrgUnit.isSelected()) {
            this.tblOrgUnit.setVisible(true);
            this.treeViewOrgUnit.setVisible(false);
            this.kdOrgUnitSort.removeAllElements();
        }
    }

    @Override
    protected void isShowMsg_stateChanged(ChangeEvent e) throws Exception {
        super.isShowMsg_stateChanged(e);
        if (this.isShowMsg.isSelected()) {
            this.isGatherOther.setSelected(false);
        }
    }

    @Override
    protected void isGatherOther_stateChanged(ChangeEvent e) throws Exception {
        super.isGatherOther_stateChanged(e);
        if (this.isGatherOther.isSelected()) {
            this.isGatherByPeriod.setSelected(false);
            this.isShowMsg.setSelected(false);
        }
    }

    @Override
    protected void isGatherByPeriod_stateChanged(ChangeEvent e) throws Exception {
        super.isGatherByPeriod_stateChanged(e);
        if (this.isGatherByPeriod.isSelected()) {
            this.isGatherOther.setSelected(false);
        }
    }

    protected boolean hasShowSort() throws Exception {
        Rectangle rect = this.getBounds();
        return rect.getWidth() == 830.0;
    }

    @Override
    protected void btnShowOrg_actionPerformed(ActionEvent e) throws Exception {
        Object ui;
        Object _ui = this.getUIContext().get("Owner");
        if (_ui != null && (_ui instanceof BgFormActualListUI || _ui instanceof BgNFormActualProcessUI || _ui instanceof BgNActualRecordListUI || _ui instanceof BgNActualRecordProcessUI)) {
            return;
        }
        Rectangle rect = this.getBounds();
        if (this.getUIContext().get("PANELUI") instanceof NewAssignSolutionUI) {
            ui = (NewAssignSolutionUI)this.getUIContext().get("PANELUI");
            rect.width = 830;
            this.setBounds(rect);
            ((NewAssignSolutionUI)ui).refreshWindow();
        }
        if (this.getUIContext().get("PANELUI") instanceof AssignSolutionUI) {
            ui = (AssignSolutionUI)((Object)this.getUIContext().get("PANELUI"));
            Rectangle uiRect = ui.getBounds();
            Rectangle panelRect = ((AssignSolutionUI)((Object)ui)).kDPanel4.getBounds();
            Window window = (Window)ui.getUIWindow();
            Rectangle diaRect = window.getBounds();
            if (rect.getWidth() == 830.0) {
                rect.width = 430;
                uiRect.width -= 400;
                panelRect.x -= 400;
                diaRect.width -= 400;
            } else {
                rect.width = 830;
                uiRect.width += 400;
                panelRect.x += 400;
                diaRect.width += 400;
            }
            this.setBounds(rect);
            ui.setBounds(uiRect);
            ((AssignSolutionUI)((Object)ui)).kDPanel4.setBounds(panelRect);
            window.setBounds(diaRect);
        }
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnSelectAll_actionPerformed(e);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        if (this.treeOrgUnit.getSelectionPath() != null) {
            root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getSelectionPath().getLastPathComponent();
        }
        this.treeOrgUnitView(root, true);
        ((DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot()).setChecked(false);
        this.treeOrgUnit.repaint();
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnClearAll_actionPerformed(e);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        if (this.treeOrgUnit.getSelectionPath() != null) {
            root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getSelectionPath().getLastPathComponent();
        }
        this.treeOrgUnitView(root, false);
        this.treeOrgUnit.repaint();
    }

    private void treeOrgUnitView(DefaultKingdeeTreeNode root, boolean isSelected) throws Exception {
        if (root == null) {
            return;
        }
        final DefaultKingdeeTreeNode tmpRoot = root;
        final boolean tmpSelected = isSelected;
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                BgSubOrgUnitSelectUIForForm.this.treeOrgUnitSelectAllNode(tmpRoot, tmpSelected);
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
    }

    private void treeOrgUnitSelectAllNode(DefaultKingdeeTreeNode root, boolean selected) throws Exception {
        block6: {
            DefaultKingdeeTreeNode node;
            block5: {
                if (root == null) {
                    return;
                }
                if (this.canTheNodeBeSelected(root)) {
                    root.setChecked(selected);
                }
                node = null;
                if (!this.chkIncludeChildren.isSelected()) break block5;
                int count = root.getChildCount();
                for (int index = 0; index < count; ++index) {
                    node = (DefaultKingdeeTreeNode)root.getChildAt(index);
                    if (this.canTheNodeBeSelected(node)) {
                        node.setChecked(selected);
                    }
                    if (node.isLeaf()) continue;
                    BgNFSHelper.addChildNode((DefaultKingdeeTreeNode)node);
                    this.treeOrgUnitSelectAllNode(node, selected);
                }
                break block6;
            }
            if (root.getParent() == null) break block6;
            for (int i = 0; i < root.getParent().getChildCount(); ++i) {
                node = (DefaultKingdeeTreeNode)root.getParent().getChildAt(i);
                if (!this.canTheNodeBeSelected(node)) continue;
                node.setChecked(selected);
            }
        }
    }

    private void treeOrgUnitClearAllNode() throws Exception {
        this.solOrgUnitIds = null;
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        DefaultKingdeeTreeNode node = null;
        Enumeration nodeEnum = root.breadthFirstEnumeration();
        while (nodeEnum.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
            node.setChecked(false);
        }
    }

    private boolean canTheNodeBeSelected(DefaultKingdeeTreeNode node) {
        return node.isCheckBoxVisible() && node.isCheckBoxEnabled();
    }

    @Override
    protected void raGatherAllSheet_actionPerformed(ActionEvent e) throws Exception {
        if (this.raGatherAllSheet.isSelected()) {
            this.prmtSelectSheet.setEnabled(false);
        }
    }

    @Override
    protected void raGatherSelSheet_actionPerformed(ActionEvent e) throws Exception {
        if (this.raGatherSelSheet.isSelected()) {
            this.prmtSelectSheet.setEnabled(true);
        }
    }

    @Override
    protected void btnMoveAllRight_actionPerformed(ActionEvent e) throws Exception {
        TreeModel model;
        if (this.raImmOrgUnit.isSelected()) {
            OrgUnitInfo unitInfo = null;
            int in = this.tblOrgUnit.getBody().size();
            for (int i = 0; i < in; ++i) {
                if (!((Boolean)this.tblOrgUnit.getRow(i).getCell(0).getValue()).booleanValue() || this.checkHasUnitInfo(unitInfo = (OrgUnitInfo)this.tblOrgUnit.getRow(i).getUserObject())) continue;
                this.kdOrgUnitSort.addElement((Object)unitInfo);
            }
        } else if (this.raAllOrgUnit.isSelected() && (model = this.treeOrgUnit.getModel()) != null) {
            this.moveSelectToRigth((DefaultKingdeeTreeNode)model.getRoot());
        }
    }

    protected void moveSelectToRigth(DefaultKingdeeTreeNode root) throws Exception {
        if (root == null) {
            return;
        }
        DefaultKingdeeTreeNode node = null;
        OrgStructureInfo osi = null;
        FullOrgUnitInfo unitInfo = null;
        int in = root.getChildCount();
        for (int i = 0; i < in; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (node.isChecked() && !this.checkHasUnitInfo((OrgUnitInfo)(unitInfo = (osi = (OrgStructureInfo)node.getUserObject()).getUnit()))) {
                this.kdOrgUnitSort.addElement((Object)unitInfo);
            }
            this.moveSelectToRigth(node);
        }
    }

    protected boolean checkHasUnitInfo(OrgUnitInfo unitInfo) throws Exception {
        if (unitInfo == null) {
            return false;
        }
        OrgUnitInfo _unitInfo = null;
        int in = this.kdOrgUnitSort.getElementCount();
        for (int i = 0; i < in; ++i) {
            _unitInfo = (OrgUnitInfo)this.kdOrgUnitSort.getElement(i);
            if (!unitInfo.equals((Object)_unitInfo)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void btnMoveRight_actionPerformed(ActionEvent e) throws Exception {
        OrgStructureInfo osi;
        FullOrgUnitInfo unitInfo;
        DefaultKingdeeTreeNode node;
        Object obj;
        if (this.raImmOrgUnit.isSelected()) {
            int rowIndex = this.tblOrgUnit.getSelectManager().getActiveRowIndex();
            if (rowIndex >= 0) {
                OrgUnitInfo unitInfo2 = null;
                if (((Boolean)this.tblOrgUnit.getRow(rowIndex).getCell(0).getValue()).booleanValue() && !this.checkHasUnitInfo(unitInfo2 = (OrgUnitInfo)this.tblOrgUnit.getRow(rowIndex).getUserObject())) {
                    this.kdOrgUnitSort.addElement((Object)unitInfo2);
                }
            }
        } else if (this.raAllOrgUnit.isSelected() && (obj = this.treeOrgUnit.getLastSelectedPathComponent()) != null && obj instanceof DefaultKingdeeTreeNode && (node = (DefaultKingdeeTreeNode)obj).isChecked() && (obj = node.getUserObject()) != null && obj instanceof OrgStructureInfo && !this.checkHasUnitInfo((OrgUnitInfo)(unitInfo = (osi = (OrgStructureInfo)obj).getUnit()))) {
            this.kdOrgUnitSort.addElement((Object)unitInfo);
        }
    }

    @Override
    protected void btnMoveLeft_actionPerformed(ActionEvent e) throws Exception {
        Object[] objs = this.kdOrgUnitSort.getSelectedValues();
        int in = objs.length;
        for (int i = 0; i < in; ++i) {
            this.kdOrgUnitSort.removeElement(objs[i]);
        }
    }

    @Override
    protected void btnMoveAllLeft_actionPerformed(ActionEvent e) throws Exception {
        this.kdOrgUnitSort.removeAllElements();
    }

    @Override
    protected void btnMoveToTop_actionPerformed(ActionEvent e) throws Exception {
        int index = this.kdOrgUnitSort.getSelectedIndex();
        Object obj = this.kdOrgUnitSort.getSelectedValue();
        if (index > 0 && obj != null) {
            this.kdOrgUnitSort.removeElementAt(index);
            this.kdOrgUnitSort.insertElement(obj, 0);
            this.kdOrgUnitSort.setSelectedIndex(0);
        }
    }

    @Override
    protected void btnMoveTop_actionPerformed(ActionEvent e) throws Exception {
        int index = this.kdOrgUnitSort.getSelectedIndex();
        Object obj = this.kdOrgUnitSort.getSelectedValue();
        if (index > 0 && obj != null) {
            this.kdOrgUnitSort.removeElementAt(index);
            this.kdOrgUnitSort.insertElement(obj, index - 1);
            this.kdOrgUnitSort.setSelectedIndex(index - 1);
        }
    }

    @Override
    protected void btnMoveBotton_actionPerformed(ActionEvent e) throws Exception {
        int index = this.kdOrgUnitSort.getSelectedIndex();
        int size = this.kdOrgUnitSort.getElementCount();
        Object obj = this.kdOrgUnitSort.getSelectedValue();
        if (index < size - 1 && obj != null) {
            this.kdOrgUnitSort.removeElementAt(index);
            this.kdOrgUnitSort.insertElement(obj, index + 1);
            this.kdOrgUnitSort.setSelectedIndex(index + 1);
        }
    }

    @Override
    protected void btnMoveToBotton_actionPerformed(ActionEvent e) throws Exception {
        int index = this.kdOrgUnitSort.getSelectedIndex();
        int size = this.kdOrgUnitSort.getElementCount();
        Object obj = this.kdOrgUnitSort.getSelectedValue();
        if (index < size - 1 && obj != null) {
            this.kdOrgUnitSort.removeElementAt(index);
            this.kdOrgUnitSort.insertElement(obj, size - 1);
            this.kdOrgUnitSort.setSelectedIndex(size - 1);
        }
    }

    @Override
    public Map getReturnData() throws Exception {
        if (!this.isHasCancel()) {
            return this.getSolutionInfo();
        }
        return null;
    }

    @Override
    public void clear() throws Exception {
        this.kdOrgUnitSort.removeAllElements();
        this.treeOrgUnitClearAllNode();
        Object _obj = this.getUIContext().get("GATHER_TYPE");
        if (_obj != null && _obj instanceof Boolean) {
            boolean type = (Boolean)_obj;
            if (type) {
                this.raGatherEnumErate.setSelected(true);
            } else {
                this.raGatherFormula.setSelected(true);
            }
        }
        this.raGatherAllSheet.setSelected(false);
        this.raGatherSelSheet.setSelected(true);
        this.prmtSelectSheet.setEnabled(true);
        Object ui = this.getUIContext().get("Owner");
        if (ui != null) {
            if (ui instanceof BgNFormAdjustListUI || ui instanceof BgNFormAdjustProcessUI) {
                this.isGatherAdjust.setSelected(true);
            } else {
                this.isGatherAdjust.setSelected(false);
            }
        }
        this.isShowMsg.setSelected(false);
        this.isClearFormula.setSelected(false);
        this.raGatherFormula.setVisible(false);
        this.raGatherEnumErate.setVisible(false);
        this.isGatherByPeriod.setSelected(false);
    }

    @Override
    public Object saveSolution() throws Exception {
        return this.getSolutionInfo();
    }

    protected Map getSolutionInfo() throws Exception {
        HashMap<String, Object> solution = new HashMap<String, Object>();
        if (this.raAllOrgUnit.isSelected()) {
            solution.put("GATHER_TYPE", Boolean.TRUE);
        } else {
            solution.put("GATHER_TYPE", Boolean.FALSE);
        }
        solution.put("GATHER_ORGUNIT", this.querySolutionOrgUnitInfo());
        if (this.raGatherFormula.isSelected()) {
            solution.put("GATHER_FORMULA", Boolean.TRUE);
            solution.put("GATHER_ENUMERATE", Boolean.FALSE);
            solution.put("GATHER_CELL", Boolean.FALSE);
        } else if (this.raGatherEnumErate.isSelected()) {
            solution.put("GATHER_ENUMERATE", Boolean.TRUE);
            solution.put("GATHER_FORMULA", Boolean.FALSE);
            solution.put("GATHER_CELL", Boolean.FALSE);
        } else {
            solution.put("GATHER_ENUMERATE", Boolean.FALSE);
            solution.put("GATHER_FORMULA", Boolean.FALSE);
            solution.put("GATHER_CELL", Boolean.TRUE);
        }
        solution.put("GATHER_TMPDATA", new Boolean(this.isGatherAdjust.isSelected()));
        solution.put("GATHER_SHOW_MSG", new Boolean(this.isShowMsg.isSelected()));
        solution.put("GATHER_CLEAR_FORMULA", new Boolean(this.isClearFormula.isSelected()));
        solution.put("GATHER_SCHEME_FORMULA", new Boolean(this.isGatherOther.isSelected()));
        solution.put("GATHER_PERIOD", new Boolean(this.isGatherByPeriod.isSelected()));
        if (this.raGatherAllSheet.isSelected()) {
            solution.put("GATHER_SHEET", Boolean.FALSE);
        } else {
            solution.put("GATHER_SHEET", Boolean.TRUE);
            solution.put("GATHER_SHEET_ID", this.prmtSelectSheet.getData());
        }
        solution.put("GATHER_SORT", this.queryOrgUnitSortInfo());
        return solution;
    }

    protected Set<String> querySolutionOrgUnitInfo() throws Exception {
        HashSet<String> orgUnits = new HashSet<String>();
        if (this.raAllOrgUnit.isSelected()) {
            this.queryOrgUnitByTree(orgUnits);
        } else if (this.raImmOrgUnit.isSelected()) {
            this.queryOrgUnitByTable(orgUnits);
        }
        return orgUnits;
    }

    protected void queryOrgUnitByTable(Set<String> orgUnits) {
        if (orgUnits != null && this.solOrgUnitIds != null) {
            orgUnits.addAll(this.solOrgUnitIds);
        }
        for (int i = 0; i < this.tblOrgUnit.getRowCount(); ++i) {
            if (((Boolean)this.tblOrgUnit.getRow(i).getCell(0).getValue()).booleanValue()) {
                orgUnits.add(((OrgUnitInfo)this.tblOrgUnit.getRow(i).getUserObject()).getId().toString());
                continue;
            }
            orgUnits.remove(((OrgUnitInfo)this.tblOrgUnit.getRow(i).getUserObject()).getId().toString());
        }
    }

    protected void queryOrgUnitByTree(Set<String> orgUnits) throws Exception {
        if (orgUnits != null && this.solOrgUnitIds != null) {
            orgUnits.addAll(this.solOrgUnitIds);
        }
        this.queryOrgUnitByTree(orgUnits, (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot());
    }

    protected void queryOrgUnitByTree(Set<String> orgUnits, DefaultKingdeeTreeNode root) throws Exception {
        if (orgUnits == null || root == null) {
            return;
        }
        DefaultKingdeeTreeNode _node = null;
        OrgStructureInfo _osi = null;
        FullOrgUnitInfo unitInfo = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            _node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (_node.getUserObject() instanceof OrgStructureInfo) {
                _osi = (OrgStructureInfo)_node.getUserObject();
                unitInfo = _osi.getUnit();
                if (_node.isChecked()) {
                    orgUnits.add(unitInfo.getId().toString());
                } else {
                    orgUnits.remove(unitInfo.getId().toString());
                }
            }
            this.queryOrgUnitByTree(orgUnits, _node);
        }
    }

    protected List<String> queryOrgUnitSortInfo() throws Exception {
        ArrayList<String> sort = new ArrayList<String>();
        OrgUnitInfo unitInfo = null;
        int size = this.kdOrgUnitSort.getElementCount();
        for (int i = 0; i < size; ++i) {
            unitInfo = (OrgUnitInfo)this.kdOrgUnitSort.getElement(i);
            sort.add(unitInfo.getId().toString());
        }
        return sort;
    }

    @Override
    public void reloadSolution(Object o) throws Exception {
        if (o == null || !(o instanceof Map)) {
            return;
        }
        this.loadSolution((Map)o);
    }

    protected void loadSolution(Map solution) throws Exception {
        HashMap orgUnitMap = new HashMap();
        Object _obj = solution.get("GATHER_TYPE");
        if (((Boolean)_obj).booleanValue()) {
            this.raAllOrgUnit.setSelected(true);
            this.raAllOrgUnit_actionPerformed(null);
            this.setOrgUnitByTree((Set)solution.get("GATHER_ORGUNIT"), orgUnitMap);
        } else {
            this.raImmOrgUnit.setSelected(true);
            this.raImmOrgUnit_actionPerformed(null);
            this.setOrgUnitByTable((Set)solution.get("GATHER_ORGUNIT"), orgUnitMap);
        }
        if (!((Boolean)solution.get("GATHER_CELL")).booleanValue()) {
            if (((Boolean)solution.get("GATHER_FORMULA")).booleanValue()) {
                this.raGatherFormula.setSelected(true);
            } else if (((Boolean)solution.get("GATHER_ENUMERATE")).booleanValue()) {
                this.raGatherEnumErate.setSelected(true);
            }
        }
        if ((_obj = solution.get("GATHER_TMPDATA")) instanceof Boolean) {
            this.isGatherAdjust.setSelected(((Boolean)_obj).booleanValue());
        } else {
            this.isGatherAdjust.setSelected(false);
        }
        _obj = solution.get("GATHER_SHOW_MSG");
        if (_obj instanceof Boolean) {
            this.isShowMsg.setSelected(((Boolean)_obj).booleanValue());
        } else {
            this.isShowMsg.setSelected(false);
        }
        _obj = solution.get("GATHER_CLEAR_FORMULA");
        if (_obj instanceof Boolean) {
            this.isClearFormula.setSelected(((Boolean)_obj).booleanValue());
        } else {
            this.isClearFormula.setSelected(false);
        }
        _obj = solution.get("GATHER_SCHEME_FORMULA");
        if (_obj instanceof Boolean) {
            this.isGatherOther.setSelected(((Boolean)_obj).booleanValue());
        } else {
            this.isGatherOther.setSelected(false);
        }
        _obj = solution.get("GATHER_PERIOD");
        if (_obj instanceof Boolean) {
            this.isGatherByPeriod.setSelected(((Boolean)_obj).booleanValue());
        } else {
            this.isGatherByPeriod.setSelected(false);
        }
        _obj = solution.get("GATHER_SHEET");
        if (_obj != null) {
            if (((Boolean)_obj).booleanValue()) {
                this.raGatherAllSheet.setSelected(false);
                this.raGatherSelSheet.setSelected(true);
                this.prmtSelectSheet.setEnabled(true);
                SheetInfo[] sheetInfos = (SheetInfo[])solution.get("GATHER_SHEET_ID");
                if (sheetInfos != null) {
                    this.prmtSelectSheet.setData((Object)sheetInfos);
                }
            } else {
                this.raGatherAllSheet.setSelected(true);
                this.raGatherSelSheet.setSelected(false);
                this.prmtSelectSheet.setEnabled(false);
            }
        } else {
            this.raGatherAllSheet.setSelected(true);
            this.raGatherSelSheet.setSelected(false);
            this.prmtSelectSheet.setEnabled(false);
        }
        _obj = solution.get("GATHER_SORT");
        if (_obj != null && _obj instanceof List && !((List)_obj).isEmpty()) {
            if (!this.hasShowSort()) {
                this.btnShowOrg_actionPerformed(null);
            }
            this.setOrgUnitSortInfo((List)_obj, orgUnitMap);
        }
        orgUnitMap.clear();
        this.treeOrgUnit.requestFocus();
    }

    protected void setOrgUnitByTable(Set orgUnits, Map orgUnitMap) {
        String _unitId = null;
        OrgUnitInfo _unitInfo = null;
        for (int i = 0; i < this.tblOrgUnit.getRowCount(); ++i) {
            _unitInfo = (OrgUnitInfo)this.tblOrgUnit.getRow(i).getUserObject();
            _unitId = _unitInfo.getId().toString();
            orgUnitMap.put(_unitId, _unitInfo);
            if (orgUnits.contains(_unitId)) {
                this.tblOrgUnit.getRow(i).getCell(0).setValue((Object)Boolean.TRUE);
                continue;
            }
            this.tblOrgUnit.getRow(i).getCell(0).setValue((Object)Boolean.FALSE);
        }
    }

    protected void setOrgUnitByTree(Set orgUnits, Map orgUnitMap) throws Exception {
        this.solOrgUnitIds = orgUnits != null ? orgUnits : null;
        this.setOrgUnitByTree(orgUnits, orgUnitMap, (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot());
    }

    protected void setOrgUnitByTree(Set orgUnits, Map orgUnitMap, DefaultKingdeeTreeNode root) throws Exception {
        if (orgUnits == null || root == null) {
            return;
        }
        DefaultKingdeeTreeNode _node = null;
        OrgStructureInfo _osi = null;
        FullOrgUnitInfo _unitInfo = null;
        String _unitId = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            _node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (_node != null && (_osi = (OrgStructureInfo)_node.getUserObject()) != null && (_unitInfo = _osi.getUnit()) != null) {
                _unitId = _unitInfo.getId().toString();
            }
            orgUnitMap.put(_unitId, _unitInfo);
            if (orgUnits.contains(_unitId)) {
                _node.setChecked(true);
            } else {
                _node.setChecked(false);
            }
            this.setOrgUnitByTree(orgUnits, orgUnitMap, _node);
        }
    }

    protected void setOrgUnitSortInfo(List sort, Map orgUnits) {
        if (sort == null || orgUnits == null) {
            return;
        }
        String orgUnitId = null;
        OrgUnitInfo unitInfo = null;
        this.kdOrgUnitSort.removeAllElements();
        int in = sort.size();
        for (int i = 0; i < in; ++i) {
            orgUnitId = (String)sort.get(i);
            if (!orgUnits.containsKey(orgUnitId)) continue;
            unitInfo = (OrgUnitInfo)orgUnits.get(orgUnitId);
            this.kdOrgUnitSort.addElement((Object)unitInfo);
        }
    }

    public void setConfermLabel(String confermLabel) {
    }

    @Override
    public AssignSolutionInfo getDefaultSoltuion() throws Exception {
        return null;
    }

    @Override
    public String getNewConfermLabel() {
        return null;
    }

    @Override
    public void clearSolutionList() throws Exception {
    }

    @Override
    public AssignSolutionCollection solutionList(AssignSolutionTypeEnum typeEnum) throws Exception {
        StringBuffer oql = new StringBuffer(" where solutionType = " + typeEnum.getValue());
        String schemeId = null;
        String operateType = null;
        if (this.getUIContext().get("ID") != null) {
            schemeId = (String)this.getUIContext().get("ID");
        }
        if (this.getUIContext().get("operateType") != null) {
            operateType = (String)this.getUIContext().get("operateType");
        }
        if (typeEnum.getValue() == 0) {
            String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            oql.append(" and cuid='" + cuid + "'");
        } else if (typeEnum.getValue() == 2) {
            String orgId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            oql.append(" and orgId='" + orgId + "'");
        } else if (typeEnum.getValue() == 1) {
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            oql.append(" and userId='" + userId + "' ");
        }
        if (schemeId != null) {
            oql.append(" and relativeObjId = '" + schemeId + "' ");
        }
        if (operateType != null) {
            oql.append(" and oprateObjType='" + operateType + "' ");
        }
        oql.append(" and uiname ='" + this.getMetaDataPK().getFullName() + "'");
        oql.append(" order by isDefaultsolution desc");
        return this.getSoluationInterface().getAssignSolutionCollection(oql.toString());
    }

    public void iniPoppMenu() {
        this.treeOrgUnit.addMouseListener((MouseListener)new TreePopupMenuListener());
        KDMenuItem menu = new KDMenuItem();
        menu.setText(EASResource.getString((String)RES_PATH, (String)"selectSon"));
        menu.addActionListener((ActionListener)new TreeMenuListener());
        this.popMenu.add((JMenuItem)menu);
    }

    private ArrayList productArrayList(Object[] obj) {
        if (obj.length == 0) {
            return null;
        }
        ArrayList<Object> array = new ArrayList<Object>();
        for (int i = 0; i < obj.length; ++i) {
            array.add(obj[i]);
        }
        return array;
    }

    private void treeSonSelected(DefaultKingdeeTreeNode root, ArrayList list) {
        if (list.isEmpty()) {
            return;
        }
        if (list.get(list.size() - 1).toString().equals(root.getText()) || list.get(list.size() - 1).toString() == root.getText()) {
            this.selectDowmTree(root);
            return;
        }
        list.remove(0);
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            if (list.get(0).toString() != node.getText() && !list.get(0).toString().equals(node.getText())) continue;
            if (list.isEmpty()) {
                this.selectDowmTree(node);
                return;
            }
            this.treeSonSelected(node, list);
        }
    }

    private void selectDowmTree(DefaultKingdeeTreeNode root) {
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            if (!node.isCheckBoxEnabled()) continue;
            node.setChecked(true);
        }
    }

    public Set getFinanceOrgSet() {
        if (this.financeOrgSet == null) {
            this.costCenterIDSet = new HashSet();
            BgNFSHelper.getAllCostCenterIDs((Set)this.costCenterIDSet, (DefaultKingdeeTreeNode)((DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot()));
            try {
                this.financeOrgSet = BgNFSHelper.getFinanceOrgID((Set)this.costCenterIDSet);
            }
            catch (BOSException e) {
                this.financeOrgSet = new HashSet();
            }
        }
        return this.financeOrgSet;
    }

    class TreePopupMenuListener
    extends MouseAdapter {
        TreePopupMenuListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                BgSubOrgUnitSelectUIForForm.this.popMenu.show((Component)BgSubOrgUnitSelectUIForForm.this.treeOrgUnit, e.getX(), e.getY());
            }
        }
    }

    class TreeMenuListener
    implements ActionListener {
        TreeMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath path = BgSubOrgUnitSelectUIForForm.this.treeOrgUnit.getSelectionPath();
            if (path == null) {
                return;
            }
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)BgSubOrgUnitSelectUIForForm.this.treeOrgUnit.getModel().getRoot();
            Object[] obj = path.getPath();
            ArrayList pathList = BgSubOrgUnitSelectUIForForm.this.productArrayList(obj);
            BgSubOrgUnitSelectUIForForm.this.treeSonSelected(root, pathList);
            BgSubOrgUnitSelectUIForForm.this.treeOrgUnit.repaint();
        }
    }

    class OrgListener
    implements ItemListener {
        OrgListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)BgSubOrgUnitSelectUIForForm.this.treeOrgUnit.getModel().getRoot();
            String select = null;
            if (e.getStateChange() == 1) {
                select = e.getItem().toString();
                if (BgOrgTypeViewEnum.company.toString() == select || BgOrgTypeViewEnum.company.toString().equals(select)) {
                    BgSubOrgUnitSelectUIForForm.this.selectedFinanceOrg(root);
                } else {
                    BgSubOrgUnitSelectUIForForm.this.selectedAllOrg(root);
                }
            }
            BgSubOrgUnitSelectUIForForm.this.treeOrgUnit.repaint();
        }
    }
}

