/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.AssignSolutionCollection;
import com.kingdee.eas.ma.budget.AssignSolutionFactory;
import com.kingdee.eas.ma.budget.AssignSolutionInfo;
import com.kingdee.eas.ma.budget.AssignSolutionTypeEnum;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgSubOrgUnitSelectUIForScheme;
import com.kingdee.eas.ma.budget.client.AssignSolutionInterface;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgSchemeTreeListUI;
import com.kingdee.eas.ma.budget.client.SearchKeyEnum;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgOrgTypeViewEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BgSubOrgUnitSelectUIForScheme
extends AbstractBgSubOrgUnitSelectUIForScheme
implements AssignSolutionInterface {
    private static final long serialVersionUID = -7097593562272624469L;
    private int direct_Org_Select_Int = -1;
    public static final String DIRECT = "direct";
    public static final String INDIRECT = "inDirect";
    private TreeModel treeModelOld = null;
    private static final Logger logger = CoreUIObject.getLogger(BgSubOrgUnitSelectUIForScheme.class);
    private static final String RESOURCE = "com.kingdee.eas.ma.budget.client.BgSchemeResource";
    private boolean isOk = false;
    private ArrayList returnValue = null;
    private String selectType = "inDirect";
    private Hashtable temMap = new Hashtable();
    private OrgUnitInfo org = null;
    private Map scriptMap = new HashMap();
    private Map specialMap = new HashMap();
    private static final Color NO_DISPATCHED = Color.BLACK;
    private static final Color NOFINANCE = Color.GRAY;
    private static boolean isFinSelected = false;
    public static final String RES_PATH = "com.kingdee.eas.ma.nbudget.BgSchemeUnAssignResource";
    KDPopupMenu popMenu = new KDPopupMenu();

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAllSel.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnAllClr.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnAllSel.setVisible(true);
        this.btnAllClr.setVisible(true);
        this.btnOnlyUpdateAddFormulaToAuditFormAndActualForm.setVisible(false);
        this.btnOnlyUpdateAddFormulaToAuditFormAndActualForm.setEnabled(false);
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    BgSubOrgUnitSelectUIForScheme.this.action_search();
                }
                catch (Exception e) {
                    BgSubOrgUnitSelectUIForScheme.this.handUIException(e);
                }
            }
        });
        this.btnSelectNow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BgSubOrgUnitSelectUIForScheme.this.action_selectNowTemp(arg0);
            }
        });
        this.treeViewOrgUnit.setShowButton(false);
        this.setIcons();
        this.initComBoxOrgType();
        this.refreshOrgUnitTree();
        this.initTable(null, null);
        this.initTempTable(null, null, null);
        this.initLabel1Visual();
        this.iniPoppMenu();
        this.orgComboBox.addItem((Object)BgOrgTypeViewEnum.All);
        this.orgComboBox.addItem((Object)BgOrgTypeViewEnum.company);
        this.orgComboBox.addItemListener((ItemListener)new OrgListener());
    }

    private void selectedAllOrg(DefaultKingdeeTreeNode root) {
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            node.setTextColor(NO_DISPATCHED);
            node.setCheckBoxVisible(true);
            node.setCheckBoxEnabled(true);
            if (node.getChildCount() <= 0) continue;
            this.selectedAllOrg(node);
        }
    }

    private void selectedFinanceOrg(DefaultKingdeeTreeNode root) {
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
            if (!oui.getUnit().isIsCompanyOrgUnit()) {
                node.setTextColor(NOFINANCE);
                node.setCheckBoxVisible(false);
                node.setCheckBoxEnabled(false);
            }
            if (node.getChildCount() <= 0) continue;
            this.selectedFinanceOrg(node);
        }
    }

    @Override
    protected void btnOnlyUpdateAddFormulaToAuditFormAndActualForm_stateChanged(ChangeEvent e) throws Exception {
        this.initLabel1Visual();
    }

    private void initLabel1Visual() {
        if (this.btnOnlyUpdateAddFormulaToAuditFormAndActualForm.isSelected()) {
            this.kDLabel1.setVisible(true);
        } else {
            this.kDLabel1.setVisible(false);
        }
    }

    private void action_search() throws Exception {
        if (this.txtKey.getText() == null || this.txtKey.getText().trim().length() < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"please.input.condition"));
            this.txtKey.requestFocus();
            return;
        }
        String value = this.txtKey.getText();
        SearchKeyEnum keyEnum = (SearchKeyEnum)((Object)this.comboSearchKey.getSelectedItem());
        if (keyEnum.getValue() == 10) {
            if (this.raDirect.isSelected()) {
                this.initTable("name", value);
            } else {
                TreeModel model = null;
                model = NewOrgUtils.clipAndCloneTreeModel((TreeModel)this.treeModelOld, (String)"name", (String)value, (boolean)true);
                if (isFinSelected) {
                    this.selectedFinanceOrg((DefaultKingdeeTreeNode)model.getRoot());
                }
                this.treeOrgUnit.setModel(model);
            }
        } else if (keyEnum.getValue() == 0) {
            if (this.raDirect.isSelected()) {
                this.initTable("number", value);
            } else {
                TreeModel model = null;
                model = NewOrgUtils.clipAndCloneTreeModel((TreeModel)this.treeModelOld, (String)"number", (String)value, (boolean)true);
                if (isFinSelected) {
                    this.selectedFinanceOrg((DefaultKingdeeTreeNode)model.getRoot());
                }
                this.treeOrgUnit.setModel(model);
            }
        } else if (keyEnum.getValue() == 20) {
            this.initTempTable(null, "number", value);
        } else if (keyEnum.getValue() == 30) {
            this.initTempTable(null, "name", value);
        }
    }

    private void action_selectNowTemp(ActionEvent arg0) {
        if (!this.checkedIsSelectOrg()) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"please.choose.org"));
            return;
        }
        KDTSelectBlock sb = null;
        int size = this.temTable.getSelectManager().size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            sb = this.temTable.getSelectManager().get(i);
            int bottom = sb.getBottom();
            for (int j = sb.getTop(); j <= bottom; ++j) {
                this.temTable.getRow(j).getCell("select").setValue((Object)true);
                this.selectTem(j, 1);
            }
        }
    }

    private void initTempTable(String bgSchemeId, String searchKey, String searchValue) throws Exception {
        this.temTable.checkParsed();
        this.temTable.removeRows();
        bgSchemeId = (String)this.getUIContext().get("ID");
        BgTemplateCollection coll = this.getBgTemColl(bgSchemeId, searchKey, searchValue);
        for (int i = 0; i < coll.size(); ++i) {
            BgTemplateInfo info = coll.get(i);
            IRow row = this.temTable.addRow();
            row.getCell("id").setValue((Object)info.getId().toString());
            row.getCell("select").setValue((Object)Boolean.FALSE);
            row.getCell("number").setValue((Object)info.getNumber());
            row.getCell("name").setValue((Object)info.getName());
            row.getCell("creator").setValue((Object)info.getCreator().getName());
            row.getCell("createtime").setValue((Object)info.getCreateTime());
        }
    }

    public String getSelectType() {
        return this.selectType;
    }

    public void setSelectType(String selectType) {
        this.selectType = selectType;
    }

    public void initTable(String searchKey, String searchValue) throws Exception {
        this.table.checkParsed();
        this.table.removeRows();
        this.table.getSelectManager().setSelectMode(2);
        ArrayList orgList = new ArrayList();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        this.traceNodeDirectAll(root, orgList);
        for (int i = 0; i < orgList.size(); ++i) {
            String trueValue;
            OrgUnitInfo orgInfo = (OrgUnitInfo)orgList.get(i);
            if (searchKey != null && searchKey.equalsIgnoreCase("number") && (trueValue = orgInfo.getNumber()).indexOf(searchValue) < 0 || searchKey != null && searchKey.equalsIgnoreCase("name;") && (trueValue = orgInfo.getName()).indexOf(searchValue) < 0) continue;
            IRow row = this.table.addRow();
            row.setUserObject((Object)orgInfo);
            row.getCell("select").setValue((Object)Boolean.FALSE);
            row.getCell("select").getStyleAttributes().setLocked(false);
            row.getCell("number").setValue((Object)orgInfo.getNumber());
            row.getCell("number").getStyleAttributes().setLocked(true);
            row.getCell("name").setValue((Object)orgInfo.getName());
            row.getCell("name").getStyleAttributes().setLocked(true);
        }
    }

    private void setIcons() {
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    private void initComBoxOrgType() {
        this.comBoxOrgType.addItem((Object)OrgViewType.COSTCENTER);
        this.comBoxOrgType.setSelectedItem((Object)OrgViewType.COSTCENTER);
        this.comBoxOrgType.setEditable(false);
        this.comBoxOrgType.setEnabled(false);
    }

    private void refreshOrgUnitTree() throws EASBizException, BOSException, SQLException {
        this.treeOrgUnit.setModel(null);
        OrgViewType orgViewType = (OrgViewType)this.comBoxOrgType.getSelectedItem();
        if (orgViewType == null) {
            return;
        }
        try {
            String rootUnitID = (String)this.getUIContext().get("CUID");
            this.treeModelOld = BgNFSHelper.getOrgTreeModel((String)rootUnitID, (KDTree)this.treeOrgUnit);
            this.treeOrgUnit.setShowCheckBox(true);
            this.treeOrgUnit.setModel(this.treeModelOld);
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeModelOld.getRoot();
            root.setCheckBoxVisible(false);
            root.setCheckBoxEnabled(false);
        }
        catch (Exception err) {
            this.handUIException(err);
        }
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        if (this.returnValue == null) {
            this.returnValue = new ArrayList();
        } else {
            this.returnValue.clear();
        }
        if (this.raIndirect.isSelected()) {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
            this.traceNode(root, this.returnValue);
        } else if (this.raDirect.isSelected()) {
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                if (!((Boolean)this.table.getRow(i).getCell("select").getValue()).booleanValue()) continue;
                this.returnValue.add(this.table.getRow(i).getUserObject());
            }
        }
        if (this.returnValue.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"pleaseSelectOrg"));
            SysUtil.abort();
        } else {
            for (int i = 0; i < this.returnValue.size(); ++i) {
                String id = ((FullOrgUnitInfo)this.returnValue.get(i)).getId().toString();
                if (!this.temMap.containsKey(id)) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"pleaseSelectTem"));
                    SysUtil.abort();
                    continue;
                }
                Vector vec = (Vector)this.temMap.get(id);
                if (!vec.isEmpty()) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"pleaseSelectTem"));
                SysUtil.abort();
            }
        }
        Object ui = this.getUIContext().get("Owner");
        if (ui instanceof BgSchemeTreeListUI) {
            BgSchemeTreeListUI bGui = (BgSchemeTreeListUI)((Object)ui);
            String id = (String)this.getUIContext().get("CUID");
            FullOrgUnitInfo org = null;
            if (id != null) {
                org = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
            }
            int scriptType = this.getScriptType(this.getTemMap());
            int specialType = this.getSpecialType(this.getTemMap());
            bGui.assignDetail(this, this.returnValue, org, this.getTemMap(), this.btnOnlyUpdateAddFormulaToAuditFormAndActualForm.isSelected(), scriptType, specialType);
        }
        this.clear();
    }

    private int getScriptType(Hashtable map) {
        String key2 = null;
        String key12 = null;
        HashMap selectMap = new HashMap();
        for (String key2 : map.keySet()) {
            Vector vec = (Vector)map.get(key2);
            for (String key12 : vec) {
                selectMap.put(key12, null);
            }
        }
        int scriptType = -1;
        for (String key2 : selectMap.keySet()) {
            if (this.scriptMap.containsKey(key2)) {
                if (scriptType == -1) {
                    scriptType = 3;
                    continue;
                }
                if (scriptType != 1) continue;
                scriptType = 2;
                continue;
            }
            if (scriptType == -1) {
                scriptType = 1;
                continue;
            }
            if (scriptType != 3) continue;
            scriptType = 2;
        }
        return scriptType;
    }

    private int getSpecialType(Hashtable map) {
        String key2 = null;
        String key12 = null;
        HashMap selectMap = new HashMap();
        for (String key2 : map.keySet()) {
            Vector vec = (Vector)map.get(key2);
            for (String key12 : vec) {
                selectMap.put(key12, null);
            }
        }
        int specialType = -1;
        for (String key2 : selectMap.keySet()) {
            if (this.specialMap.containsKey(key2)) {
                if (specialType == -1) {
                    specialType = 3;
                    continue;
                }
                if (specialType != 1) continue;
                specialType = 2;
                break;
            }
            if (specialType == -1) {
                specialType = 1;
                continue;
            }
            if (specialType != 3) continue;
            specialType = 2;
            break;
        }
        return specialType;
    }

    private void traceNode(DefaultKingdeeTreeNode root, ArrayList list) throws Exception {
        if (list == null) {
            list = new ArrayList<FullOrgUnitInfo>();
        }
        if (root.isChecked()) {
            OrgStructureInfo oui = (OrgStructureInfo)root.getUserObject();
            FullOrgUnitInfo info = oui.getUnit();
            info.setLongNumber(oui.getLongNumber());
            list.add(info);
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.traceNode(node, list);
        }
    }

    private void traceNodeDirectAll(DefaultKingdeeTreeNode root, ArrayList list) throws Exception {
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
            FullOrgUnitInfo info = oui.getUnit();
            info.setLongNumber(oui.getLongNumber());
            list.add(info);
        }
    }

    void initNoSelect() {
        int rowCount = this.temTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.temTable.getCell(i, 1).setValue((Object)false);
        }
        KingdeeTreeModel tree = (KingdeeTreeModel)this.treeOrgUnit.getModel();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)tree.getRoot();
        this.setTreeNodeSelected(root, false);
        rowCount = this.table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.table.getCell(i, 1).setValue((Object)false);
        }
    }

    protected FullOrgUnitInfo getInDirectOrgUnit() {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        if (!node.isCheckBoxVisible()) {
            return null;
        }
        if (OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
            return null;
        }
        OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
        if (oui == null || oui.getUnit() == null) {
            return null;
        }
        boolean isCkecked = node.isChecked();
        if (!isCkecked) {
            return null;
        }
        FullOrgUnitInfo info = oui.getUnit();
        String id = info.getId().toString();
        try {
            FullOrgUnitInfo info1 = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo("select CU.id where id='" + id + "'");
            info.setCU(info1.getCU());
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        info.setLongNumber(oui.getLongNumber());
        info.put("bg_isChecked", (Object)new Boolean(isCkecked));
        return info;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.returnValue = null;
        this.destroyWindow();
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnSelectAll_actionPerformed(e);
        if (this.raIndirect.isSelected()) {
            this.org = this.getInDirectOrgUnit();
        } else if (this.raDirect.isSelected()) {
            this.org = this.getDirectOrgUnit(this.table.getSelectManager().getActiveRowIndex());
        }
        if (this.org == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"please.choose.org"));
            return;
        }
        int selectIndex = this.temTable.getColumnIndex("select");
        for (int i = 0; i < this.temTable.getRowCount(); ++i) {
            this.temTable.getCell(i, selectIndex).setValue((Object)Boolean.TRUE);
            this.selectTem(i, selectIndex);
        }
    }

    private boolean checkedIsSelectOrg() {
        boolean isSelect = false;
        if (this.selectType.equals(INDIRECT)) {
            this.org = this.getInDirectOrgUnit();
        } else if (this.selectType.equals(DIRECT)) {
            this.org = this.getDirectOrgUnit(this.table.getSelectManager().getActiveRowIndex());
        }
        if (this.org != null) {
            isSelect = true;
        }
        return isSelect;
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        if (this.raIndirect.isSelected()) {
            this.org = this.getInDirectOrgUnit();
        } else if (this.raDirect.isSelected()) {
            this.org = this.getDirectOrgUnit(this.table.getSelectManager().getActiveRowIndex());
        }
        if (this.org == null) {
            return;
        }
        int selectIndex = this.temTable.getColumnIndex("select");
        for (int i = 0; i < this.temTable.getRowCount(); ++i) {
            this.temTable.getCell(i, selectIndex).setValue((Object)Boolean.FALSE);
            this.selectTem(i, selectIndex);
        }
    }

    @Override
    protected void raDirect_actionPerformed(ActionEvent e) throws Exception {
        super.raDirect_actionPerformed(e);
        this.selectType = DIRECT;
        this.table.setVisible(true);
        this.treeViewOrgUnit.setVisible(false);
    }

    @Override
    protected void raIndirect_actionPerformed(ActionEvent e) throws Exception {
        super.raIndirect_actionPerformed(e);
        this.selectType = INDIRECT;
        this.table.setVisible(false);
        this.treeViewOrgUnit.setVisible(true);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public boolean isOk() {
        return this.isOk;
    }

    public void setOk(boolean isOk) {
        this.isOk = isOk;
    }

    public ArrayList getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(ArrayList returnValue) {
        this.returnValue = returnValue;
    }

    @Override
    protected void treeOrgUnit_valueChanged(TreeSelectionEvent e) throws Exception {
        FullOrgUnitInfo org1;
        int i;
        this.temTable.getEditManager().editingStopped();
        if (this.temTable.getRowCount() > 0) {
            this.temTable.getSelectManager().select(0, 0, 0, 0);
        }
        super.treeOrgUnit_valueChanged(e);
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (!node.isCheckBoxVisible()) {
            this.temTable.getColumn("select").getStyleAttributes().setLocked(true);
            for (i = 0; i < this.temTable.getRowCount(); ++i) {
                this.temTable.getRow(i).getCell("select").setValue((Object)Boolean.FALSE);
            }
        } else {
            this.temTable.getColumn("select").getStyleAttributes().setLocked(false);
            for (i = 0; i < this.temTable.getRowCount(); ++i) {
                this.temTable.getRow(i).getCell("select").setValue((Object)Boolean.FALSE);
            }
        }
        if ((org1 = this.getInDirectOrgUnit()) == null) {
            return;
        }
        this.localSelectTem((OrgUnitInfo)org1);
        if (this.selectType.equals(INDIRECT)) {
            this.org = this.getInDirectOrgUnit();
        } else if (this.selectType.equals(DIRECT)) {
            this.org = this.getDirectOrgUnit(this.direct_Org_Select_Int);
        }
    }

    void setTreeNodeSelected(DefaultKingdeeTreeNode parent, boolean selected) {
        parent.setChecked(selected);
        DefaultKingdeeTreeNode node = null;
        Enumeration children = parent.children();
        while (children.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)children.nextElement();
            this.setTreeNodeSelected(node, selected);
        }
    }

    @Override
    protected void table_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.table_tableSelectChanged(e);
        OrgUnitInfo org = this.getDirectOrgUnit(this.table.getSelectManager().getActiveRowIndex());
        this.localSelectTem(org);
    }

    private void localSelectTem(OrgUnitInfo org) {
        if (org == null) {
            for (int i = 0; i < this.temTable.getRowCount(); ++i) {
                this.temTable.getRow(i).getCell("select").setValue((Object)false);
            }
            return;
        }
        for (int i = 0; i < this.temTable.getRowCount(); ++i) {
            this.temTable.getRow(i).getCell("select").setValue(null);
        }
        String orgId = org.getId().toString();
        if (this.temMap.containsKey(orgId)) {
            Vector vec = (Vector)this.temMap.get(orgId);
            for (int i = 0; i < this.temTable.getRowCount(); ++i) {
                String id = (String)this.temTable.getRow(i).getCell("id").getValue();
                if (vec.contains(id)) {
                    this.temTable.getRow(i).getCell("select").setValue((Object)Boolean.TRUE);
                    continue;
                }
                this.temTable.getRow(i).getCell("select").setValue((Object)Boolean.FALSE);
            }
        } else {
            for (int i = 0; i < this.temTable.getRowCount(); ++i) {
                this.temTable.getRow(i).getCell("select").setValue((Object)Boolean.FALSE);
            }
        }
    }

    protected BgTemplateCollection getBgTemColl(String schemeId, String searchKey, String searchValue) throws Exception {
        BgTemplateCollection result = new BgTemplateCollection();
        String locale = SysContext.getSysContext().getLocale().toString();
        String sql = "select a.fid,a.fnumber,a.fname,a.fcreatorid,a.fcreatetime,c.fname_" + locale + " ,a.FFormType from t_bg_bgtemplate a ,t_bg_bgschemenode b ,t_pm_user c  where a.fcreatorid=c.fid and a.fid = b.fbgtemplateid and b.fbgschemeid='" + schemeId + "' ";
        if (searchKey != null && searchKey.trim().length() > 0 && searchValue != null && searchValue.trim().length() > 0) {
            if (searchKey.equalsIgnoreCase("number")) {
                searchKey = "a.fnumber";
            } else if (searchKey.equalsIgnoreCase("name")) {
                searchKey = "a.fname";
            }
            sql = sql + " and " + searchKey + " like '%" + searchValue + "%'  order by a.fnumber";
        } else {
            sql = sql + " order by a.fnumber";
        }
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = null;
        try {
            rs = sqlExe.executeSQL();
            while (rs.next()) {
                BgTemplateInfo info = new BgTemplateInfo();
                info.setId(BOSUuid.read((String)rs.getString(1)));
                info.setNumber(rs.getString(2));
                info.setName(rs.getString(3));
                UserInfo user = new UserInfo();
                user.setId(BOSUuid.read((String)rs.getString(4)));
                user.setName(rs.getString(6));
                info.setCreator(user);
                info.setCreateTime(rs.getTimestamp(5));
                info.setFormType(BgTemFormTypeEnum.getEnum(rs.getInt(7)));
                if (2 == rs.getInt(7)) {
                    this.scriptMap.put(rs.getString(1), null);
                }
                if (3 == rs.getInt(7)) {
                    this.specialMap.put(rs.getString(1), null);
                }
                result.add(info);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        return result;
    }

    @Override
    protected void temTable_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (this.org == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"please.choose.org"));
            this.temTable.getCell(rowIndex, colIndex).setValue((Object)false);
            return;
        }
        this.selectTem(rowIndex, colIndex);
    }

    private void selectTem(int rowIndex, int colIndex) {
        ICell cell = this.temTable.getCell(rowIndex, colIndex);
        if (this.temTable.getColumnIndex("select") == colIndex && cell.getValue() instanceof Boolean && this.org != null) {
            String orgId = this.org.getId().toString();
            String temId = (String)this.temTable.getRow(rowIndex).getCell("id").getValue();
            Vector vec = null;
            vec = this.temMap.get(orgId) != null ? (Vector)this.temMap.get(orgId) : new Vector();
            if (((Boolean)cell.getValue()).booleanValue()) {
                if (!vec.contains(temId)) {
                    vec.add(temId);
                }
            } else {
                vec.remove(temId);
            }
            this.temMap.put(orgId, vec);
        }
    }

    @Override
    protected void temTable_editStarted(KDTEditEvent e) throws Exception {
        this.direct_Org_Select_Int = this.table.getSelectManager().getActiveRowIndex();
        if (this.selectType.equals(INDIRECT)) {
            this.org = this.getInDirectOrgUnit();
        } else if (this.selectType.equals(DIRECT)) {
            this.org = this.getDirectOrgUnit(this.direct_Org_Select_Int);
        }
    }

    private OrgUnitInfo getDirectOrgUnit(int rowIndex) {
        if (rowIndex < 0 || rowIndex > this.table.getRowCount() - 1) {
            return null;
        }
        boolean isChecked = (Boolean)this.table.getRow(rowIndex).getCell("select").getValue();
        if (!isChecked) {
            return null;
        }
        this.org = (OrgUnitInfo)this.table.getRow(rowIndex).getUserObject();
        return this.org;
    }

    public Hashtable getTemMap() {
        return this.temMap;
    }

    public void setTemMap(Hashtable temMap) {
        this.temMap = temMap;
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        if (this.selectType.equals(INDIRECT) || this.selectType.equals(DIRECT)) {
            // empty if block
        }
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
    }

    public boolean destroyWindow() {
        boolean isDestroy = super.destroyWindow();
        if (isDestroy && this.getUIContext().get("ID") != null) {
            BgClientHelper.releaseMutexService(this.getUIContext().get("ID").toString());
        }
        return isDestroy;
    }

    @Override
    public void clear() throws Exception {
        if (this.temMap != null) {
            this.temMap.clear();
        }
        if (this.returnValue != null) {
            this.returnValue.clear();
        }
        int rowCount = this.temTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.temTable.getRow(i).getCell("select").setValue((Object)false);
        }
        DefaultTreeModel node = (DefaultTreeModel)this.treeOrgUnit.getModel();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)node.getRoot();
        this.setTreeNodeSelected(root, false);
        this.treeOrgUnit.updateUI();
        rowCount = this.table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.table.getRow(i).getCell("select").setValue((Object)false);
        }
    }

    @Override
    public Object saveSolution() throws Exception {
        HashMap<String, Serializable> objMap = new HashMap<String, Serializable>();
        objMap.put("raIndirect", Boolean.valueOf(this.raIndirect.isSelected()));
        objMap.put("raDirect", Boolean.valueOf(this.raDirect.isSelected()));
        objMap.put("OnlyUpdateAddFormulaToAuditFormAndActualForm", Boolean.valueOf(this.btnOnlyUpdateAddFormulaToAuditFormAndActualForm.isSelected()));
        if (this.returnValue == null) {
            this.returnValue = new ArrayList();
        }
        if (this.raIndirect.isSelected()) {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
            this.traceNode(root, this.returnValue);
        }
        if (this.raDirect.isSelected()) {
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                if (!((Boolean)this.table.getRow(i).getCell("select").getValue()).booleanValue()) continue;
                this.returnValue.add(this.table.getRow(i).getUserObject());
            }
        }
        ArrayList<String> newList = new ArrayList<String>();
        int size = this.returnValue.size();
        for (int i = 0; i < size; ++i) {
            if (this.returnValue.get(i) == null) continue;
            newList.add(((FullOrgUnitInfo)this.returnValue.get(i)).getId().toString());
        }
        this.returnValue.clear();
        this.returnValue = newList;
        objMap.put("returnValue", this.returnValue);
        objMap.put("temMap", this.temMap);
        return objMap;
    }

    @Override
    public void reloadSolution(Object o) throws Exception {
        Map objMap = (Map)o;
        if (objMap == null) {
            return;
        }
        boolean raIndirectValue = false;
        boolean raDirectValue = false;
        boolean OnlyUpdateAddFormulaToAuditFormAndActualForm = false;
        if (objMap.get("raIndirect") != null && objMap.get("raIndirect") instanceof Boolean) {
            raIndirectValue = (Boolean)objMap.get("raIndirect");
            this.raIndirect.setSelected(raIndirectValue);
        }
        if (objMap.get("raDirect") != null && objMap.get("raDirect") instanceof Boolean) {
            raDirectValue = (Boolean)objMap.get("raDirect");
            this.raDirect.setSelected(raDirectValue);
        }
        if (objMap.get("OnlyUpdateAddFormulaToAuditFormAndActualForm") != null && objMap.get("OnlyUpdateAddFormulaToAuditFormAndActualForm") instanceof Boolean) {
            OnlyUpdateAddFormulaToAuditFormAndActualForm = (Boolean)objMap.get("OnlyUpdateAddFormulaToAuditFormAndActualForm");
            this.btnOnlyUpdateAddFormulaToAuditFormAndActualForm.setSelected(OnlyUpdateAddFormulaToAuditFormAndActualForm);
        } else {
            this.btnOnlyUpdateAddFormulaToAuditFormAndActualForm.setSelected(false);
        }
        this.initLabel1Visual();
        IFullOrgUnit iFull = FullOrgUnitFactory.getRemoteInstance();
        ArrayList newList = (ArrayList)objMap.get("returnValue");
        this.returnValue = new ArrayList();
        int size = newList.size();
        for (int i = 0; i < size; ++i) {
            if (newList.get(i) == null) continue;
            this.returnValue.add(iFull.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK((String)newList.get(i))));
        }
        newList.clear();
        this.temMap = (Hashtable)objMap.get("temMap");
        if (this.returnValue != null) {
            int rowCount;
            if (raIndirectValue) {
                this.raIndirect_actionPerformed(null);
                DefaultTreeModel node = (DefaultTreeModel)this.treeOrgUnit.getModel();
                DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)node.getRoot();
                FullOrgUnitInfo orgReturnValue2 = null;
                boolean haveChoosed = false;
                for (FullOrgUnitInfo orgReturnValue2 : this.returnValue) {
                    if (haveChoosed) {
                        this.setSelectOrgNodeOrg(orgReturnValue2, root, false);
                        continue;
                    }
                    haveChoosed = this.setSelectOrgNodeOrg(orgReturnValue2, root, true);
                }
                this.treeOrgUnit.updateUI();
                rowCount = this.table.getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    this.table.getRow(i).getCell("select").setValue((Object)false);
                }
            }
            if (this.raDirect.isSelected()) {
                this.raDirect_actionPerformed(null);
                FullOrgUnitInfo orgReturnValue3 = null;
                boolean haveChecked = false;
                for (FullOrgUnitInfo orgReturnValue3 : this.returnValue) {
                    rowCount = this.table.getRowCount();
                    for (int i = 0; i < rowCount; ++i) {
                        if (!((FullOrgUnitInfo)this.table.getRow(i).getUserObject()).getId().equals((Object)orgReturnValue3.getId())) continue;
                        this.table.getRow(i).getCell("select").setValue((Object)true);
                        if (haveChecked) continue;
                        this.table.getSelectManager().select(i, 0, i, this.table.getColumnCount());
                        if (this.temMap == null) continue;
                        Vector vec = (Vector)this.temMap.get(orgReturnValue3.getId().toString());
                        block5: for (String temId : vec) {
                            int rowCountTem = this.temTable.getRowCount();
                            for (int j = 0; j < rowCountTem; ++j) {
                                if (!this.temTable.getRow(j).getCell("id").getValue().equals(temId)) continue;
                                this.temTable.getRow(j).getCell("select").setValue((Object)true);
                                continue block5;
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean setSelectOrgNodeOrg(FullOrgUnitInfo orgReturnValue, DefaultKingdeeTreeNode nodeTem, boolean isChooseTem) {
        boolean isFind = false;
        if (nodeTem != null && nodeTem.getUserObject() != null && nodeTem.getUserObject() instanceof OrgStructureInfo) {
            OrgStructureInfo orgStructure = (OrgStructureInfo)nodeTem.getUserObject();
            FullOrgUnitInfo org1 = orgStructure.getUnit();
            if (orgReturnValue != null && orgReturnValue.getId().equals((Object)org1.getId())) {
                Vector vec;
                nodeTem.setChecked(true);
                if (isChooseTem && this.temMap != null && (vec = (Vector)this.temMap.get(orgReturnValue.getId().toString())) != null) {
                    int rowCount = this.temTable.getRowCount();
                    block0: for (String temId : vec) {
                        for (int i = 0; i < rowCount; ++i) {
                            if (!this.temTable.getRow(i).getCell("id").getValue().equals(temId)) continue;
                            this.temTable.getRow(i).getCell("select").setValue((Object)true);
                            continue block0;
                        }
                    }
                }
                isFind = true;
                return isFind;
            }
        }
        Enumeration children = nodeTem.children();
        while (children.hasMoreElements()) {
            isFind = this.setSelectOrgNodeOrg(orgReturnValue, (DefaultKingdeeTreeNode)children.nextElement(), isChooseTem);
            if (!isFind) continue;
            return isFind;
        }
        return isFind;
    }

    @Override
    public void clearSolutionList() throws Exception {
    }

    @Override
    public AssignSolutionCollection solutionList(AssignSolutionTypeEnum typeEnum) throws Exception {
        StringBuffer oql = new StringBuffer("where solutionType=" + typeEnum.getValue());
        String objId = null;
        String operateType = null;
        Map uicontext = this.getUIContext();
        if (uicontext.get("ID") != null) {
            objId = (String)uicontext.get("ID");
        }
        if (uicontext.get("operateType") != null) {
            operateType = (String)uicontext.get("operateType");
        }
        if (typeEnum.getValue() == 0) {
            String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            oql.append(" and cuid='" + cuid + "'");
        } else if (typeEnum.getValue() == 2) {
            String orgId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            oql.append(" and orgId='" + orgId + "'");
        } else if (typeEnum.getValue() == 1) {
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            oql.append(" and userId='" + userId + "' ");
        }
        if (objId != null) {
            oql.append(" and relativeObjId='" + objId + "' ");
        }
        if (operateType != null) {
            oql.append(" and oprateObjType='" + operateType + "' ");
        }
        oql.append(" order by isDefaultsolution desc");
        AssignSolutionCollection asSolutionCol = AssignSolutionFactory.getRemoteInstance().getAssignSolutionCollection(oql.toString());
        return asSolutionCol;
    }

    @Override
    public boolean conferm(Object invokeUi) throws Exception {
        this.btnConfirm_actionPerformed(null);
        return false;
    }

    @Override
    public boolean cancel() throws Exception {
        this.btnCancel_actionPerformed(null);
        return true;
    }

    @Override
    public Map getReturnData() throws Exception {
        return null;
    }

    @Override
    public AssignSolutionInfo getDefaultSoltuion() throws Exception {
        String objId = null;
        String operateType = null;
        Map uicontext = this.getUIContext();
        if (uicontext.get("ID") != null) {
            objId = (String)uicontext.get("ID");
        }
        if (uicontext.get("operateType") != null) {
            operateType = (String)uicontext.get("operateType");
        }
        StringBuffer oql = new StringBuffer("where isDefaultsolution =1 ");
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        oql.append(" and userId='" + userId + "' ");
        if (objId != null) {
            oql.append(" and relativeObjId='" + objId + "' ");
        }
        if (operateType != null) {
            oql.append(" and oprateObjType='" + operateType + "' ");
        }
        AssignSolutionInfo assignSolutionInfo = null;
        AssignSolutionCollection assignSolutionCol = AssignSolutionFactory.getRemoteInstance().getAssignSolutionCollection(oql.toString());
        if (assignSolutionCol.size() > 0) {
            assignSolutionInfo = assignSolutionCol.get(0);
        }
        return assignSolutionInfo;
    }

    @Override
    protected void btnAllClr_actionPerformed(ActionEvent e) throws Exception {
        this.doAllSelAndAllClr(false);
    }

    @Override
    protected void btnAllSel_actionPerformed(ActionEvent e) throws Exception {
        this.doAllSelAndAllClr(true);
    }

    private void doAllSelAndAllClr(boolean selected) throws Exception {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        if (this.treeOrgUnit.getSelectionPath() != null) {
            root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getSelectionPath().getLastPathComponent();
        }
        if (root == null) {
            return;
        }
        if (this.chkIncludeChildren.isSelected()) {
            Enumeration nodeEnum = root.breadthFirstEnumeration();
            DefaultKingdeeTreeNode node = null;
            while (nodeEnum.hasMoreElements()) {
                node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
                if (!this.canTheNodeBeSelected(node)) continue;
                node.setChecked(selected);
            }
        } else {
            root.setChecked(selected);
            if (root.getParent() != null) {
                DefaultKingdeeTreeNode node = null;
                for (int i = 0; i < root.getParent().getChildCount(); ++i) {
                    node = (DefaultKingdeeTreeNode)root.getParent().getChildAt(i);
                    if (!this.canTheNodeBeSelected(node)) continue;
                    node.setChecked(selected);
                }
            }
        }
        this.treeOrgUnit.repaint();
    }

    private boolean canTheNodeBeSelected(DefaultKingdeeTreeNode node) {
        return node.isCheckBoxVisible() && node.isCheckBoxEnabled();
    }

    @Override
    public String getNewConfermLabel() {
        return EASResource.getString((String)RESOURCE, (String)"re.assign");
    }

    public boolean verify() throws Exception {
        return false;
    }

    public void iniPoppMenu() {
        this.treeOrgUnit.addMouseListener((MouseListener)new TreePopupMenuListener());
        KDMenuItem menu = new KDMenuItem();
        menu.setText(EASResource.getString((String)RES_PATH, (String)"selectSon"));
        menu.addActionListener((ActionListener)new TreeMenuListener());
        this.popMenu.add((JMenuItem)menu);
    }

    private ArrayList productArrayList(Object[] obj) {
        if (obj.length == 0) {
            return null;
        }
        ArrayList<Object> array = new ArrayList<Object>();
        for (int i = 0; i < obj.length; ++i) {
            array.add(obj[i]);
        }
        return array;
    }

    private void treeSonSelected(DefaultKingdeeTreeNode root, ArrayList list) {
        if (list.isEmpty()) {
            return;
        }
        if (list.get(list.size() - 1).toString().equals(root.getText()) || list.get(list.size() - 1).toString() == root.getText()) {
            this.selectDowmTree(root);
            return;
        }
        list.remove(0);
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            if (list.get(0).toString() != node.getText() && !list.get(0).toString().equals(node.getText())) continue;
            if (list.isEmpty()) {
                this.selectDowmTree(node);
                return;
            }
            this.treeSonSelected(node, list);
        }
    }

    private void selectDowmTree(DefaultKingdeeTreeNode root) {
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            if (!node.isCheckBoxEnabled()) continue;
            node.setChecked(true);
        }
    }

    class TreePopupMenuListener
    extends MouseAdapter {
        TreePopupMenuListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                BgSubOrgUnitSelectUIForScheme.this.popMenu.show((Component)BgSubOrgUnitSelectUIForScheme.this.treeOrgUnit, e.getX(), e.getY());
            }
        }
    }

    class TreeMenuListener
    implements ActionListener {
        TreeMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath path = BgSubOrgUnitSelectUIForScheme.this.treeOrgUnit.getSelectionPath();
            if (path == null) {
                return;
            }
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)BgSubOrgUnitSelectUIForScheme.this.treeOrgUnit.getModel().getRoot();
            Object[] obj = path.getPath();
            ArrayList pathList = BgSubOrgUnitSelectUIForScheme.this.productArrayList(obj);
            BgSubOrgUnitSelectUIForScheme.this.treeSonSelected(root, pathList);
            BgSubOrgUnitSelectUIForScheme.this.treeOrgUnit.repaint();
        }
    }

    class OrgListener
    implements ItemListener {
        OrgListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            BgSubOrgUnitSelectUIForScheme.this.txtKey.setText("");
            TreeModel model = null;
            model = NewOrgUtils.clipAndCloneTreeModel((TreeModel)BgSubOrgUnitSelectUIForScheme.this.treeModelOld, (String)"name", (String)"", (boolean)true);
            ((DefaultKingdeeTreeNode)model.getRoot()).setCheckBoxVisible(false);
            BgSubOrgUnitSelectUIForScheme.this.treeOrgUnit.setModel(model);
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)BgSubOrgUnitSelectUIForScheme.this.treeOrgUnit.getModel().getRoot();
            BgSubOrgUnitSelectUIForScheme.this.treeOrgUnit.expandAllNodes(true, (TreeNode)root);
            String select = null;
            if (e.getStateChange() == 1) {
                select = e.getItem().toString();
                if (BgOrgTypeViewEnum.company.toString() == select || BgOrgTypeViewEnum.company.toString().equals(select)) {
                    BgSubOrgUnitSelectUIForScheme.this.selectedFinanceOrg(root);
                    isFinSelected = true;
                } else {
                    BgSubOrgUnitSelectUIForScheme.this.selectedAllOrg(root);
                    isFinSelected = false;
                }
            }
            BgSubOrgUnitSelectUIForScheme.this.treeOrgUnit.repaint();
        }
    }
}

