/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.IBgTemplate;
import com.kingdee.eas.ma.budget.client.AbstractBgTemplateImportUI;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class BgTemplateImportUI
extends AbstractBgTemplateImportUI {
    private static final Logger logger = CoreUIObject.getLogger(BgTemplateImportUI.class);
    private FullOrgUnitInfo orgUnitInfo = null;
    private Hashtable selectedTemplates = new Hashtable();
    private boolean isConfirm = true;
    private BgTemplateCollection colls = new BgTemplateCollection();

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDLabelTemplate.setIcon(EASResource.getIcon((String)"imgLableword_btn"));
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.btnAll_actionPerformed(null);
        this.getColls();
    }

    private void getColls() throws Exception {
        this.selectedTemplates = (Hashtable)this.getUIContext().get("templates");
        this.orgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("EditOrg");
        String orgUnitID = this.orgUnitInfo.getId().toString();
        IBgScheme iBgScheme = BgSchemeFactory.getRemoteInstance();
        BgTemplateCollection coll = new BgTemplateCollection();
        if (BgSHelper.isBgPermissionUsed()) {
            try {
                String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                HashSet<String> org = new HashSet<String>();
                org.add(SysContext.getSysContext().getCurrentCostUnit().getId().toString());
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitID));
                filter.setMaskString("#0");
                filter = BgPermissionHelper.addBgTemplatePermission((String)userId, org, (FilterInfo)filter);
                IBgTemplate iBgTemp = BgTemplateFactory.getRemoteInstance();
                view.setFilter(filter);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("creator.name");
                sic.add("name");
                sic.add("number");
                sic.add("createTime");
                sic.add("isAllowChange");
                sic.add("templateStatus");
                view.getSelector().addObjectCollection((IObjectCollection)sic);
                coll = iBgTemp.getBgTemplateCollection(view);
            }
            catch (Exception e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
        } else {
            coll = iBgScheme.getTemplate(orgUnitID);
        }
        for (int i = 0; i < coll.size(); ++i) {
            if (!this.selectedTemplates.containsKey(coll.get(i).getId().toString())) continue;
            this.colls.add(coll.get(i));
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.setConfirm(false);
        this.getUIWindow().close();
        SysUtil.abort();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        this.selectedTemplates = (Hashtable)this.getUIContext().get("templates");
        this.setConfirm(true);
        int rowCount = this.tblMain.getRowCount();
        Hashtable<String, BgTemplateInfo> selectedBefore = new Hashtable<String, BgTemplateInfo>();
        String selectedTemplatesName = "";
        for (int i = 0; i < rowCount; ++i) {
            IRow iRow = this.tblMain.getRow(i);
            if (!iRow.getCell("select").getValue().equals(Boolean.TRUE)) continue;
            BgTemplateInfo bgTemplateInfo = (BgTemplateInfo)iRow.getUserObject();
            String bgTempID = iRow.getCell("id").getValue().toString();
            if (this.selectedTemplates.containsKey(bgTempID)) {
                selectedBefore.put(bgTempID, bgTemplateInfo);
                iRow.getCell("select").setValue((Object)Boolean.FALSE);
                continue;
            }
            this.selectedTemplates.put(bgTempID, bgTemplateInfo);
            this.colls.add(bgTemplateInfo);
        }
        if (!selectedBefore.isEmpty()) {
            Iterator iter = selectedBefore.keySet().iterator();
            while (iter.hasNext()) {
                BgTemplateInfo template = (BgTemplateInfo)selectedBefore.get(iter.next());
                selectedTemplatesName = selectedTemplatesName + " " + template.getName();
            }
            MsgBox.showWarning((Component)((Object)this), (String)(selectedTemplatesName + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"TemplateNotReselected")));
        }
        this.getUIWindow().close();
    }

    @Override
    protected void btnAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnAll_actionPerformed(e);
        this.orgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("EditOrg");
        String orgUnitID = this.orgUnitInfo.getId().toString();
        IBgScheme iBgScheme = BgSchemeFactory.getRemoteInstance();
        BgTemplateCollection coll = new BgTemplateCollection();
        if (BgSHelper.isBgPermissionUsed()) {
            try {
                String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                HashSet<String> org = new HashSet<String>();
                org.add(SysContext.getSysContext().getCurrentCostUnit().getId().toString());
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitID));
                filter.setMaskString("#0");
                filter = BgPermissionHelper.addBgTemplatePermission((String)userId, org, (FilterInfo)filter);
                IBgTemplate iBgTemp = BgTemplateFactory.getRemoteInstance();
                view.setFilter(filter);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("creator.name");
                sic.add("name");
                sic.add("number");
                sic.add("createTime");
                sic.add("isAllowChange");
                sic.add("templateStatus");
                SorterItemCollection sort = new SorterItemCollection();
                sort.add(new SorterItemInfo("number"));
                view.getSelector().addObjectCollection((IObjectCollection)sic);
                view.getSorter().addObjectCollection((IObjectCollection)sort);
                coll = iBgTemp.getBgTemplateCollection(view);
            }
            catch (Exception e1) {
                logger.error((Object)"budget error:", (Throwable)e1);
            }
        } else {
            coll = iBgScheme.getTemplate(orgUnitID);
        }
        this.loadTemplates(coll);
    }

    @Override
    protected void btnNotSelected_actionPerformed(ActionEvent e) throws Exception {
        super.btnNotSelected_actionPerformed(e);
        this.orgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("EditOrg");
        String orgUnitID = this.orgUnitInfo.getId().toString();
        IBgScheme iBgScheme = BgSchemeFactory.getRemoteInstance();
        BgTemplateCollection bgTempColls = new BgTemplateCollection();
        if (BgSHelper.isBgPermissionUsed()) {
            try {
                String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                HashSet<String> org = new HashSet<String>();
                org.add(SysContext.getSysContext().getCurrentCostUnit().getId().toString());
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitID));
                filter.setMaskString("#0");
                filter = BgPermissionHelper.addBgTemplatePermission((String)userId, org, (FilterInfo)filter);
                IBgTemplate iBgTemp = BgTemplateFactory.getRemoteInstance();
                view.setFilter(filter);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("creator.name");
                sic.add("name");
                sic.add("number");
                sic.add("createTime");
                sic.add("isAllowChange");
                sic.add("templateStatus");
                view.getSelector().addObjectCollection((IObjectCollection)sic);
                bgTempColls = iBgTemp.getBgTemplateCollection(view);
            }
            catch (Exception e1) {
                logger.error((Object)"budget error:", (Throwable)e1);
            }
        } else {
            bgTempColls = iBgScheme.getTemplate(orgUnitID);
        }
        BgTemplateInfo info = new BgTemplateInfo();
        BgTemplateCollection coll = new BgTemplateCollection();
        String id = "";
        Hashtable selectedTemplates = (Hashtable)this.getUIContext().get("templates");
        for (int i = 0; i < bgTempColls.size(); ++i) {
            info = bgTempColls.get(i);
            id = info.getId().toString();
            if (selectedTemplates.get(id) != null) continue;
            coll.add(info);
        }
        this.loadTemplates(coll);
    }

    private Hashtable translateToHashtable(BgTemplateCollection bgTempColls) {
        Hashtable<String, BgTemplateInfo> hashColls = new Hashtable<String, BgTemplateInfo>();
        if (bgTempColls == null) {
            hashColls = null;
        }
        if (bgTempColls != null) {
            Iterator iter = bgTempColls.iterator();
            while (iter.hasNext()) {
                BgTemplateInfo template = (BgTemplateInfo)iter.next();
                if (hashColls == null) continue;
                hashColls.put(template.getNumber().toString(), template);
            }
        }
        return hashColls;
    }

    @Override
    protected void btnSeleted_actionPerformed(ActionEvent e) throws Exception {
        super.btnSeleted_actionPerformed(e);
        if ((Hashtable)this.getUIContext().get("templates") != null) {
            Hashtable selectedTemplates = (Hashtable)this.getUIContext().get("templates");
            this.loadTemplates(selectedTemplates);
        }
    }

    private void loadTemplates(Hashtable coll) {
        this.tblMain.removeRows();
        BgTemplateCollection temColl = new BgTemplateCollection();
        BgTemplateInfo info = new BgTemplateInfo();
        if (coll != null && coll.size() > 0) {
            Iterator iterator = coll.keySet().iterator();
            while (iterator.hasNext()) {
                BgTemplateInfo bgTemplateInfo = (BgTemplateInfo)coll.get(iterator.next());
                temColl.add(bgTemplateInfo);
            }
            BgHelper.sortCollection(temColl, new String[]{"number"});
            for (int i = 0; i < temColl.size(); ++i) {
                info = temColl.get(i);
                IRow iRow = this.tblMain.addRow();
                iRow.setUserObject((Object)info);
                iRow.getCell("select").setValue((Object)Boolean.FALSE);
                iRow.getCell("number").setValue((Object)info.getNumber());
                iRow.getCell("name").setValue((Object)info.getName());
                iRow.getCell("creator").setValue((Object)info.getCreator().getName());
                iRow.getCell("createTime").setValue((Object)info.getCreateTime());
                iRow.getCell("id").setValue((Object)info.getId().toString());
            }
        }
        this.tblMain.getColumn("createTime").getStyleAttributes().setLocked(true);
    }

    private void loadTemplates(BgTemplateCollection coll) {
        this.tblMain.removeRows();
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                BgTemplateInfo bgTemplateInfo = coll.get(i);
                IRow iRow = this.tblMain.addRow();
                iRow.setUserObject((Object)bgTemplateInfo);
                iRow.getCell("select").setValue((Object)Boolean.FALSE);
                iRow.getCell("number").setValue((Object)bgTemplateInfo.getNumber());
                iRow.getCell("name").setValue((Object)bgTemplateInfo.getName());
                iRow.getCell("creator").setValue((Object)bgTemplateInfo.getCreator().getName());
                iRow.getCell("createTime").setValue((Object)bgTemplateInfo.getCreateTime());
                iRow.getCell("id").setValue((Object)bgTemplateInfo.getId().toString());
            }
        }
        this.tblMain.getColumn("createTime").getStyleAttributes().setLocked(true);
    }

    public Hashtable getSelectedTemplates() {
        return this.selectedTemplates;
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getType() != 0 && e.getClickCount() == 2 && e.getRowIndex() >= 0 && e.getColIndex() >= 0) {
            int row = this.tblMain.getSelectManager().getActiveRowIndex();
            IRow irow = this.tblMain.getRow(row);
            irow.getCell("select").setValue((Object)Boolean.TRUE);
            this.btnConfirm_actionPerformed(null);
        }
    }

    public boolean isConfirm() {
        return this.isConfirm;
    }

    public void setConfirm(boolean isConfirm) {
        this.isConfirm = isConfirm;
    }
}

