/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.ma.budget.client.BgCompareAndAnalysisFormProcessUI;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BgTendencyAnalysisProcessUI
extends BgCompareAndAnalysisFormProcessUI {
    private static final long serialVersionUID = 744661793055965117L;
    private static List selectedBgItemList = null;

    @Override
    public void onLoad() throws Exception {
        this.clearCache();
        super.onLoad();
    }

    @Override
    protected boolean isAnalysisCol(Sheet sheet, int columnIndex) {
        int rowCount = sheet.getMaxRowIndex() + 1;
        boolean returnFlag = false;
        for (int i = 0; i < rowCount; ++i) {
            Cell cell = sheet.getCell(i, columnIndex, false);
            String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
            if (bgItem == null || "".equals(bgItem)) continue;
            returnFlag = true;
            break;
        }
        return returnFlag;
    }

    @Override
    protected void confirm() {
        Book book = this.getBook();
        HashMap temMap = new HashMap();
        if (analysisColIndexMap != null && !analysisColIndexMap.isEmpty()) {
            temMap.putAll(analysisColIndexMap);
        }
        Set set = analysisColIndexMap.keySet();
        HashSet filter = new HashSet();
        boolean isSelectCol = false;
        int num = book.getSheetCount();
        for (int i = 0; i < num; ++i) {
            Sheet currentSheet = book.getSheet(i);
            String id = this.specialID(currentSheet.getSheetName(), currentSheet.getID());
            if (!set.contains(id)) continue;
            ArrayList<Integer> list = new ArrayList<Integer>();
            Range range = currentSheet.getSelectionRange();
            for (int j = range.size() - 1; j >= 0; --j) {
                CellBlock block = (CellBlock)range.getAt(j);
                if (!block.isCol()) continue;
                if (!isSelectCol) {
                    isSelectCol = true;
                }
                for (int k = block.getCol2(); k >= block.getCol(); --k) {
                    if (!this.isAnalysisCol(currentSheet, k)) continue;
                    list.add(new Integer(k));
                    this.storeSelectedBgItem(filter, currentSheet, k);
                }
            }
            if (list.size() != 0) {
                analysisColIndexMap.put(id, list);
            } else {
                analysisColIndexMap.remove(id);
            }
            selectedBgItemList = new ArrayList(filter);
        }
        if (!isSelectCol) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgAnalyseResource", (String)"selectFullRow"));
            analysisColIndexMap.clear();
            analysisColIndexMap.putAll(temMap);
            SysUtil.abort();
        }
    }

    @Override
    protected void clearCache() {
        super.clearCache();
        if (selectedBgItemList != null) {
            selectedBgItemList.clear();
        }
    }

    private void storeSelectedBgItem(Set set, Sheet sheet, int colIndex) {
        int rowCount = sheet.getMaxRowIndex() + 1;
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            Cell cell = sheet.getCell(rowIndex, colIndex, false);
            String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
            if (bgItem == null || "".equals(bgItem)) continue;
            set.add(bgItem);
        }
    }

    public static List getSelectedBgItemList() {
        return selectedBgItemList;
    }
}

