/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.core.IMouseController;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.state.mouse.TableMouseController;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgAnalyseBaseFilterParam;
import com.kingdee.eas.ma.budget.BgCompareAndAnalysisDoForBook;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFillHelper;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgIOHelper;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTendencyAnalysisDataTypeEnum;
import com.kingdee.eas.ma.budget.BgTendencyAnalysisFacadeFactory;
import com.kingdee.eas.ma.budget.BgTendencyAnalysisWayEnum;
import com.kingdee.eas.ma.budget.BgTendencyFilterParam;
import com.kingdee.eas.ma.budget.IBgTendencyAnalysisFacade;
import com.kingdee.eas.ma.budget.NewBgCompareAndAnalysisSimpleObjFilterParam;
import com.kingdee.eas.ma.budget.analysiscolumn.IDataDealCenter;
import com.kingdee.eas.ma.budget.analysiscolumn.impls.FetchAndDealDataAnalysisSystemFacade;
import com.kingdee.eas.ma.budget.analysiscolumn.impls.TendencyDataDealCenter;
import com.kingdee.eas.ma.budget.analysiscolumn.util.AnalysisColumnTool;
import com.kingdee.eas.ma.budget.analysiscolumn.util.BgFormulaHelper;
import com.kingdee.eas.ma.budget.analysiscolumn.util.BgTendencyUtil;
import com.kingdee.eas.ma.budget.client.AbstractBgTendencyMainUI;
import com.kingdee.eas.ma.budget.client.BgAnalyseFilterBaseUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgTendencyAnalysisFilter2UI;
import com.kingdee.eas.ma.budget.client.BgTendencyAnalysisFilterUI;
import com.kingdee.eas.ma.budget.client.BudgetUserCellDisplayProvider;
import com.kingdee.eas.ma.budget.client.NewBgCompareAndAnalysisMainUI;
import com.kingdee.eas.ma.budget.client.NumberExpandInfo;
import com.kingdee.eas.ma.budget.client.OrgUnitRender;
import com.kingdee.eas.ma.nbudget.BgExportHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNFormException;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.ExcelFileFilter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgTendencyMainUI
extends AbstractBgTendencyMainUI {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.client.BgTendencyMainUI");
    private static final long serialVersionUID = 1520163841325685427L;
    private IBgTendencyAnalysisFacade iBgTendencyAnalysisFacade;
    protected SpreadContext sc;
    protected Book book;
    private OrgUnitRender render;
    private static final String BASE_COL_KEY = "BaseColKey";
    private static final String BASE_COL_KEY_VALUE = "BaseColKeyValue";
    private BgTendencyAnalysisFilterUI filterUI;
    private BgTendencyAnalysisFilter2UI filter2UI;
    private List periodNumberList;
    private FetchAndDealDataAnalysisSystemFacade fetchAndDealDataFacade = new FetchAndDealDataAnalysisSystemFacade();

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    protected String getQueryMainName() {
        return this.getMetaDataPK().getFullName();
    }

    @Override
    protected boolean hasSpreadContext() {
        return true;
    }

    @Override
    protected SpreadContext getSpreadContext() {
        return this.sc;
    }

    protected final FetchAndDealDataAnalysisSystemFacade getAnalysisSysFacade() {
        return this.fetchAndDealDataFacade;
    }

    @Override
    protected boolean getDefaultFilterParam() throws Exception {
        if (this.getFilterParam() != null) {
            return true;
        }
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        QuerySolutionInfo ds = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), this.mainQueryPk.getFullName());
        if (ds != null && ds.getSolutionType().equals((Object)SolutionTypeEnum.CUSTOMER_SOLUTION)) {
            this.setSolutionId(ds.getId());
            int size = ds.getQueryPanelInfo().size();
            for (int i = 0; i < size; ++i) {
                QueryPanelInfo info = ds.getQueryPanelInfo().get(i);
                CustomerParams cp = new CustomerParams().getCustomerParams(info.getCustomerParams());
                this.setFilterParam(cp, info.getPanelClassName());
            }
        }
        return this.getFilterParam() != null;
    }

    private void setFilterParam(CustomerParams cp, String filterUIKey) {
        if (cp == null) {
            return;
        }
        BgAnalyseFilterBaseUI filterUI = this.getFilterUIByFilterUIKey(filterUIKey);
        if (filterUI instanceof BgTendencyAnalysisFilterUI) {
            BgTendencyAnalysisFilterUI filter1UI = (BgTendencyAnalysisFilterUI)filterUI;
            BgTendencyFilterParam filter1Param = filter1UI.getOwnFilterParam();
            CostCenterOrgUnitInfo[] ccouiAry = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeCostCenterOrgUnit(cp.getCustomerParam("OrgUnitKey"));
            filter1Param.setCostCenterOrgUnitInfoAry(ccouiAry);
            BgSchemeInfo scheme = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeBgSchemeInfo(cp.getCustomerParam("BgSchemeID"));
            filter1Param.setBgSchemeInfo(scheme);
            String bgFormId = cp.getCustomerParam("BgFormID");
            filter1Param.setBgFormID(bgFormId);
            Map titleMap = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeAnalysisAndTitleColKey(cp.getCustomerParam("BgTitleColKey"));
            filter1Param.setTitleColsMap(titleMap);
            Map analysisMap = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeAnalysisAndTitleColKey(cp.getCustomerParam("BgAnalysisColKey"));
            filter1Param.setAnalysisColsMap(analysisMap);
            BgPeriodInfo sInfo = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeBgPeriodInfo(cp.getCustomerParam("BeginPeriodID"));
            filter1Param.setBeginPeriod(sInfo);
            BgPeriodInfo eInfo = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeBgPeriodInfo(cp.getCustomerParam("EndPeriodID"));
            filter1Param.setEndPeriod(eInfo);
            BgTendencyAnalysisDataTypeEnum dataTypeEnum = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeAnalysisDataType(cp.getCustomerParam("AnalysisDataType"));
            filter1Param.setAnalysisDataType(dataTypeEnum.getValue());
            String bgItemListStr = cp.getCustomerParam("SelectedBgItemList");
            filter1Param.setBgItemList(NewBgCompareAndAnalysisSimpleObjFilterParam.decodeSelectedBgItemList(bgItemListStr));
        } else if (filterUI instanceof BgTendencyAnalysisFilter2UI) {
            BgTendencyAnalysisFilter2UI filter2UI = (BgTendencyAnalysisFilter2UI)filterUI;
            BgTendencyFilterParam filter2Param = filter2UI.getOwnFilterParam();
            List analysisEleList = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeAnalysisElement(cp.getCustomerParam("BgSimpleAnalysisElement"));
            filter2Param.setAnalysisElement(analysisEleList);
            BgTendencyAnalysisWayEnum enumWay = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeAnalysisDataWay(cp.getCustomerParam("AnalysisDataWay"));
            filter2Param.setAnalysisDataWay(enumWay.getValue());
        }
        this.defaultFilterParam = new BgAnalyseBaseFilterParam();
    }

    private BgAnalyseFilterBaseUI getFilterUIByFilterUIKey(String filterUIKey) {
        if (BgTendencyAnalysisFilterUI.FILTER_UI_KEY.equals(filterUIKey)) {
            try {
                if (this.filterUI == null) {
                    this.filterUI = new BgTendencyAnalysisFilterUI();
                }
            }
            catch (Exception e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            return this.filterUI;
        }
        if (BgTendencyAnalysisFilter2UI.FILTER_UI_KEY.equals(filterUIKey)) {
            try {
                if (this.filter2UI == null) {
                    this.filter2UI = new BgTendencyAnalysisFilter2UI();
                }
            }
            catch (Exception e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            return this.filter2UI;
        }
        return null;
    }

    @Override
    protected void executeQuery() {
        this.clearCache();
        BgTendencyFilterParam filter1Params = this.getFilterUIParams();
        BgTendencyFilterParam filter2Params = this.getFilterUI2Params();
        this.initPeriodNumberList(filter1Params);
        this.book = this.addAndInitTable(filter1Params);
        try {
            this.getAnalysisSysFacade().initDataDealCenter(new TendencyDataDealCenter(this.isBudgetVal(filter1Params), this.isBaseAnalysisWay(filter2Params)));
        }
        catch (ClassNotFoundException e) {
            this.handleException(e);
            SysUtil.abort();
        }
        int sheetNum = this.book.getSheetCount();
        for (int i = 0; i < sheetNum; ++i) {
            Sheet sheet = this.book.getSheet(i);
            int addRowIndex = this.constructSheet(filter1Params, filter2Params, this.getPeriodNumberList(), sheet);
            if (i == 0) {
                this.rebuildFilter1Params(filter1Params, new CostCenterOrgUnitInfo[]{filter1Params.getCostCenterOrgUnitInfoAry()[0]});
                try {
                    this.getAnalysisSysFacade().getDataDealCenter().getFetchDataFactory().initDataFactory(filter1Params, filter2Params);
                }
                catch (EASBizException e) {
                    this.handleException((Exception)((Object)e));
                    SysUtil.abort();
                }
                catch (BOSException e) {
                    this.handleException((Exception)((Object)e));
                    SysUtil.abort();
                }
            }
            this.fillDataToTable(sheet, filter1Params, filter2Params, addRowIndex);
        }
        this.sc.setBook(this.book);
        this.addTableListener();
        NewBgCompareAndAnalysisMainUI.setAllNumberRightA(this.sc.getBook().getActiveSheet());
    }

    protected void onSheetActive(Sheet sheet) {
        NewBgCompareAndAnalysisMainUI.setAllNumberRightA(this.sc.getBook().getActiveSheet());
    }

    private void addTableListener() {
        this.sc.getSpread().setMouseController(3, (IMouseController)new MyTableMouseController(this.sc));
        this.sc.getBook().addBookChangeListener(new BookChangeListener(){

            public void changed(BookChangeEvent e) {
                BgTendencyMainUI.this.sc.getSpread().scrollCellVisible(0, 0);
            }
        });
    }

    protected void setTreeDisplayStyle(Cell cell, NumberExpandInfo expandInfo, Sheet sheet) {
        this.expandTable(cell, expandInfo, sheet);
        NewBgCompareAndAnalysisMainUI.setAllNumberRightA(this.sc.getBook().getActiveSheet());
        this.sc.getSpread().repaint();
    }

    private void expandTable(Cell cell, NumberExpandInfo parentExpandInfo, Sheet sheet) {
        Row childRow = null;
        String longnumber = null;
        String plongnumber = null;
        plongnumber = parentExpandInfo.getLongNumber();
        if (parentExpandInfo.isExpandStatus()) {
            parentExpandInfo.setExpandStatus(false);
            BgNFCHelper.setNumberExpandInfo((Cell)cell, (NumberExpandInfo)parentExpandInfo);
            int beginRowIndex = cell.getRow() + 1;
            int rowCount = sheet.getMaxRowIndex() + 1;
            ArrayList<Integer> delList = new ArrayList<Integer>();
            for (int rowIndex = beginRowIndex; rowIndex < rowCount; ++rowIndex) {
                childRow = sheet.getRow(rowIndex, false);
                NumberExpandInfo childExpandInfo = BgNFCHelper.getNumberExpandInfo((Cell)childRow.getCell(0, false));
                if (childExpandInfo == null) continue;
                longnumber = childExpandInfo.getLongNumber();
                if (!longnumber.startsWith(plongnumber + "!")) break;
                delList.add(new Integer(childRow.getRow()));
            }
            this.deleteUnvisibleRows(sheet, delList, beginRowIndex);
        } else {
            int rowIndex;
            parentExpandInfo.setExpandStatus(true);
            BgNFCHelper.setNumberExpandInfo((Cell)cell, (NumberExpandInfo)parentExpandInfo);
            int rowCount = sheet.getMaxRowIndex() + 1;
            if (rowIndex >= rowCount - 1) {
                this.addChildRowByOrgUnitParentInfo(sheet, rowIndex, parentExpandInfo);
            } else {
                for (rowIndex = cell.getRow(); rowIndex < rowCount - 1; ++rowIndex) {
                    childRow = sheet.getRow(rowIndex, false);
                    NumberExpandInfo childExpandInfo = BgNFCHelper.getNumberExpandInfo((Cell)childRow.getCell(0, false));
                    if (childExpandInfo != null) {
                        longnumber = childExpandInfo.getLongNumber();
                        if (rowIndex != cell.getRow()) break;
                        this.addChildRowByOrgUnitParentInfo(sheet, rowIndex, parentExpandInfo);
                        break;
                    }
                    if (rowIndex != cell.getRow()) continue;
                    this.addChildRowByOrgUnitParentInfo(sheet, rowIndex, parentExpandInfo);
                }
            }
        }
    }

    private void deleteUnvisibleRows(Sheet sheet, List rowIndexList, int endRowIndex) {
        int rowIndex;
        for (int i = rowIndexList.size() - 1; i > -1 && (rowIndex = Integer.valueOf(rowIndexList.get(i).toString()).intValue()) >= endRowIndex; --i) {
            BgNFSHelper.removeRow((Sheet)sheet, (int)rowIndex);
        }
    }

    private void addChildRowByOrgUnitParentInfo(Sheet sheet, int beginRow, NumberExpandInfo parentExpandInfo) {
        String parentLN;
        BgTendencyFilterParam filter1Params = this.getFilterUIParams();
        CostCenterOrgUnitInfo[] orgUnitInfoAry = filter1Params.getCostCenterOrgUnitInfoAry();
        Map map = AnalysisColumnTool.dealWithOrgUnit((OrgUnitInfo[])orgUnitInfoAry);
        Object obj = map.get(parentLN = parentExpandInfo.getLongNumber());
        if (obj == null) {
            return;
        }
        AnalysisColumnTool.SubNode subNode = (AnalysisColumnTool.SubNode)obj;
        List subNodeList = this.getSubNodeList(subNode.getSubNodeList(), orgUnitInfoAry);
        Object[] ary = new CostCenterOrgUnitInfo[subNodeList.size()];
        int num = subNodeList.size();
        for (int i = 0; i < num; ++i) {
            ary[i] = (CostCenterOrgUnitInfo)subNodeList.get(i);
        }
        this.rebuildFilter1Params(filter1Params, ary);
        BgTendencyFilterParam filter2Params = this.getFilterUI2Params();
        List analysisElementList = filter2Params.getAnalysisElement();
        List analysisColIndexList = this.getAnalysisColIndexList(sheet);
        int num2 = subNodeList.size();
        for (int i = 0; i < num2; ++i) {
            CostCenterOrgUnitInfo info = (CostCenterOrgUnitInfo)subNodeList.get(i);
            String orgUnitId = info.getId().toString();
            NumberExpandInfo expandInfo = this.copyOrgUnitInfoToExpendInfo(info, map);
            int rowIndex = beginRow + i + 1;
            Row row = BgNFSHelper.addRow((Sheet)sheet, (int)rowIndex);
            BgNFCHelper.setNumberExpandInfo((Cell)row.getCell(0, true), (NumberExpandInfo)expandInfo);
            int _num = analysisColIndexList.size();
            String[] formulaAry = new String[_num];
            for (int j = 0; j < _num; ++j) {
                int analysisColIndex = Integer.valueOf(analysisColIndexList.get(j).toString());
                Cell cell = sheet.getCell(beginRow, analysisColIndex, false);
                String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
                String bgFormula = BgNFSHelper.getExpression((Cell)cell);
                if (bgItem != null && !"".equals(bgItem)) {
                    formulaAry[j] = bgItem;
                    BgNFSHelper.setFormulaOfCell((Cell)sheet.getCell(rowIndex, analysisColIndex, true), (String)bgItem, (boolean)true);
                    continue;
                }
                if (bgFormula == null || "".equals(bgFormula) || !BgFormulaHelper.isSingleBgFormula(bgFormula)) continue;
                BgNFSHelper.setExpression((Cell)sheet.getCell(rowIndex, analysisColIndex, true), (String)bgFormula);
            }
            try {
                this.getAnalysisSysFacade().getDataDealCenter().getFetchDataFactory().initSubOrgDataFactory(filter1Params, filter2Params, formulaAry);
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
                SysUtil.abort();
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
                SysUtil.abort();
            }
            this.fillSubOrgDataToTable(sheet, analysisElementList, rowIndex, orgUnitId);
        }
    }

    private List getSubNodeList(List subNodeLNList, CostCenterOrgUnitInfo[] ary) {
        ArrayList<CostCenterOrgUnitInfo> subNodeList = new ArrayList<CostCenterOrgUnitInfo>();
        for (CostCenterOrgUnitInfo tempInfo : ary) {
            String tempLN = tempInfo.getLongNumber();
            if (!subNodeLNList.contains(tempLN)) continue;
            subNodeList.add(tempInfo);
        }
        return subNodeList;
    }

    private NumberExpandInfo copyOrgUnitInfoToExpendInfo(CostCenterOrgUnitInfo orgUnitInfo, Map map) {
        NumberExpandInfo expandInfo = new NumberExpandInfo();
        expandInfo.setId(orgUnitInfo.getId().toString());
        expandInfo.setName(orgUnitInfo.getName());
        expandInfo.setNumber(orgUnitInfo.getNumber());
        expandInfo.setLevel(orgUnitInfo.getLevel());
        String longNumber = orgUnitInfo.getLongNumber();
        expandInfo.setLongNumber(longNumber);
        if (map.get(longNumber) != null) {
            expandInfo.setLeaf(false);
        } else {
            expandInfo.setLeaf(true);
        }
        return expandInfo;
    }

    protected void fillDataToTable(Sheet sheet, BgTendencyFilterParam filter1Params, BgTendencyFilterParam filter2Params, int addRowIndex) {
        CostCenterOrgUnitInfo[] orgUnitAry = filter1Params.getCostCenterOrgUnitInfoAry();
        String rootOrgUnitId = orgUnitAry[0].getId().toString();
        List list = filter2Params.getAnalysisElement();
        this.fillDataToTable(sheet, list, addRowIndex + 1, rootOrgUnitId);
    }

    protected void fillDataToTable(Sheet sheet, List analysisColsList, int initRowIndex, String orgUnitId) {
        List analysisColIndexList = this.getAnalysisColIndexList(sheet);
        int rowCount = sheet.getMaxRowIndex() + 1;
        BigDecimal amountUnit = NewBgCompareAndAnalysisMainUI.ONE;
        for (int rowIndex = initRowIndex; rowIndex < rowCount; ++rowIndex) {
            int colNum = analysisColIndexList.size();
            block7: for (int colIndex = 0; colIndex < colNum; ++colIndex) {
                int analysisColIndex = Integer.valueOf(analysisColIndexList.get(colIndex).toString());
                Cell cell = sheet.getCell(rowIndex, analysisColIndex, false);
                String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
                if (bgItem == null || "".equals(bgItem)) continue;
                Column analysisCol = sheet.getColumn(analysisColIndex, false);
                Object baseColKey = BgNFSHelper.getColObject((Column)analysisCol, (String)BASE_COL_KEY);
                int num = analysisColsList.size();
                for (int j = 0; j <= num; ++j) {
                    int addedColIndex = analysisColIndex + j;
                    Column col = sheet.getColumn(addedColIndex, false);
                    Object colKey = BgNFSHelper.getColObject((Column)col, (String)"bgCompareAndAnalysisColKey");
                    if (colKey instanceof String) {
                        Object val = null;
                        try {
                            val = this.getAnalysisSysFacade().getDataDealCenter().getDataFactory(bgItem, colKey.toString(), orgUnitId, amountUnit);
                        }
                        catch (SecurityException e) {
                            this.handleException(e);
                            SysUtil.abort();
                        }
                        catch (IllegalArgumentException e) {
                            this.handleException(e);
                            SysUtil.abort();
                        }
                        catch (NoSuchMethodException e) {
                            this.handleException(e);
                            SysUtil.abort();
                        }
                        catch (IllegalAccessException e) {
                            this.handleException(e);
                            SysUtil.abort();
                        }
                        catch (InvocationTargetException e) {
                            this.handleException(e);
                            SysUtil.abort();
                        }
                        this.setCellValue(sheet, rowIndex, addedColIndex, val, null);
                    }
                    if (BASE_COL_KEY_VALUE.equals(baseColKey)) continue block7;
                }
            }
        }
    }

    protected void fillSubOrgDataToTable(Sheet sheet, List analysisColsList, int initRowIndex, String orgUnitId) {
        List analysisColIndexList = this.getAnalysisColIndexList(sheet);
        BigDecimal amountUnit = NewBgCompareAndAnalysisMainUI.ONE;
        int colNum = analysisColIndexList.size();
        block6: for (int k = 0; k < colNum; ++k) {
            int analysisColIndex = Integer.valueOf(analysisColIndexList.get(k).toString());
            Cell cell = sheet.getCell(initRowIndex, analysisColIndex, false);
            String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
            if (bgItem == null || "".equals(bgItem)) continue;
            Column analysisCol = sheet.getColumn(analysisColIndex, false);
            Object baseColKey = BgNFSHelper.getColObject((Column)analysisCol, (String)BASE_COL_KEY);
            int num = analysisColsList.size();
            for (int j = 0; j <= num; ++j) {
                int addedColIndex = analysisColIndex + j;
                Column col = sheet.getColumn(addedColIndex, false);
                Object colKey = BgNFSHelper.getColObject((Column)col, (String)"bgCompareAndAnalysisColKey");
                if (colKey instanceof String) {
                    Object val = null;
                    try {
                        val = this.getAnalysisSysFacade().getDataDealCenter().getDataFactory(bgItem, colKey.toString(), orgUnitId, amountUnit);
                    }
                    catch (SecurityException e) {
                        this.handleException(e);
                        SysUtil.abort();
                    }
                    catch (IllegalArgumentException e) {
                        this.handleException(e);
                        SysUtil.abort();
                    }
                    catch (NoSuchMethodException e) {
                        this.handleException(e);
                        SysUtil.abort();
                    }
                    catch (IllegalAccessException e) {
                        this.handleException(e);
                        SysUtil.abort();
                    }
                    catch (InvocationTargetException e) {
                        this.handleException(e);
                        SysUtil.abort();
                    }
                    this.setCellValue(sheet, initRowIndex, addedColIndex, val, null);
                }
                if (BASE_COL_KEY_VALUE.equals(baseColKey)) continue block6;
            }
        }
    }

    void rebuildFilter1Params(BgTendencyFilterParam filter1Params, Object[] ary) {
        filter1Params.setLazyLoadDataCostCenterOrgUnitInfoAry((CostCenterOrgUnitInfo[])ary);
    }

    private boolean isBudgetVal(BgTendencyFilterParam filter1Params) {
        String dataType = filter1Params.getAnalysisDataType();
        return "BgData".equals(dataType);
    }

    private boolean isBaseAnalysisWay(BgTendencyFilterParam filter2Params) {
        String analysisWay = filter2Params.getAnalysisDataWay();
        return "BaseAnalysisWay".equals(analysisWay);
    }

    private void initPeriodNumberList(BgTendencyFilterParam filterParam) {
        try {
            this.periodNumberList = this.getRemoteInstance().getBgItemNumber(filterParam.getBeginPeriod(), filterParam.getEndPeriod());
            filterParam.setPeriodNumList(this.periodNumberList);
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
    }

    protected List getPeriodNumberList() {
        return this.periodNumberList;
    }

    private void clearCache() {
        IDataDealCenter ddc = this.getAnalysisSysFacade().getDataDealCenter();
        if (ddc != null) {
            ddc.getFetchDataFactory().clearAllCache();
        }
        if (this.book != null) {
            this.book = null;
        }
    }

    protected int constructSheet(BgTendencyFilterParam filter1Param, BgTendencyFilterParam filter2Param, List bgItemNumerList, Sheet sheet) {
        Map analysisColsMap = filter1Param.getAnalysisColsMap();
        String sheetID = sheet.getID();
        String sheetName = sheet.getSheetName();
        String key = sheetID + "&" + sheetName;
        List analysisColsList = (List)analysisColsMap.get(key);
        if (analysisColsList == null) {
            return 0;
        }
        Map titleColsMap = filter1Param.getTitleColsMap();
        List titleColsList = null;
        if (titleColsMap != null) {
            titleColsList = (List)titleColsMap.get(key);
        }
        if (titleColsList != null && titleColsList.size() != 0) {
            this.removeUnRequiredCols(titleColsList, analysisColsList, sheet);
        } else {
            this.removeUnRequiredCols(analysisColsList, sheet);
        }
        int rowIndex = this.locateAddedNewRowIndex(sheet);
        BgNFSHelper.addRowWithFreeze((Sheet)sheet, (int)rowIndex);
        this.addNewAnalysisCols(bgItemNumerList, rowIndex, sheet, filter1Param);
        this.addAnalysisElementCols(filter2Param.getAnalysisElement(), rowIndex, sheet);
        this.addOrgUnitByCol(filter1Param, rowIndex + 1, sheet);
        return rowIndex;
    }

    private void addOrgUnitByCol(BgTendencyFilterParam filter1Param, int beginRow, Sheet sheet) {
        CostCenterOrgUnitInfo[] orgInfoAry = filter1Param.getCostCenterOrgUnitInfoAry();
        int num = orgInfoAry.length;
        String[] companyIds = new String[num];
        for (int i = 0; i < num; ++i) {
            companyIds[i] = orgInfoAry[i].getId().toString();
        }
        if (companyIds != null && companyIds.length != 0) {
            FullOrgUnitInfo baseOrgUnit = null;
            try {
                baseOrgUnit = (FullOrgUnitInfo)this.getFullOrgUnitInterface().getOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyIds[0])));
            }
            catch (Exception exception) {
                // empty catch block
            }
            Column column = BgNFSHelper.addColWithFreeze((Sheet)sheet, (int)0);
            int colIndex = column.getCol();
            sheet.getColRange(colIndex, colIndex).setColumnWidth(200);
            if (companyIds.length > 1) {
                this.render = new OrgUnitRender();
                BudgetUserCellDisplayProvider dp = new BudgetUserCellDisplayProvider();
                dp.addRenderProvider(this.render);
                this.sc.getRenderManager().setUserCellDisplayProvider((ICellDisplayProvider)dp);
            }
            int rowCount = sheet.getMaxRowIndex() + 1;
            for (int rowIndex = beginRow; rowIndex < rowCount; ++rowIndex) {
                if (!this.checkHasBgItem(sheet, rowIndex)) continue;
                this.addExpandInfo(sheet.getCell(rowIndex, column.getCol(), true), baseOrgUnit, companyIds.length);
            }
        }
    }

    private boolean checkHasBgItem(Sheet sheet, int rowIndex) {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int colIndex = colNum - 1; colIndex >= 0; --colIndex) {
            Cell cell;
            String bgItem;
            Column col = sheet.getColumn(colIndex, false);
            Object colKey = BgNFSHelper.getColObject((Column)col, (String)"AnalysisColKey");
            if (colKey == null || !"analysis_col".equals(colKey) || (bgItem = BgNFSHelper.getFormulaOfCell((Cell)(cell = sheet.getCell(rowIndex, colIndex, false)))) == null || "".equals(bgItem)) continue;
            return true;
        }
        return false;
    }

    protected void addExpandInfo(Cell cell, FullOrgUnitInfo orgUnitInfo, int orgNum) {
        NumberExpandInfo expandInfo = new NumberExpandInfo();
        expandInfo.setId(orgUnitInfo.getId().toString());
        expandInfo.setName(orgUnitInfo.getName());
        expandInfo.setNumber(orgUnitInfo.getNumber());
        expandInfo.setLongNumber(orgUnitInfo.getLongNumber());
        expandInfo.setLevel(0);
        expandInfo.setExpandStatus(false);
        expandInfo.setLeaf(false);
        BgNFCHelper.setNumberExpandInfo((Cell)cell, (NumberExpandInfo)expandInfo);
        if (orgNum == 1) {
            BgNFSHelper.setValue((Cell)cell, (Object)orgUnitInfo.getName());
        }
    }

    private void addAnalysisElementCols(List analysisElementList, int rowIndex, Sheet sheet) {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            Column col = sheet.getColumn(i, false);
            Object colKey = BgNFSHelper.getColObject((Column)col, (String)"AnalysisColKey");
            Object isBaseCol = BgNFSHelper.getColObject((Column)col, (String)BASE_COL_KEY);
            if (!"analysis_col".equals(colKey) || BASE_COL_KEY_VALUE.equals(isBaseCol)) continue;
            int num = analysisElementList.size();
            for (int j = 0; j < num; ++j) {
                int colIndex = i + j + 1;
                Column column = BgNFSHelper.addColWithFreeze((Sheet)sheet, (int)colIndex);
                String proName = analysisElementList.get(j).toString();
                BgNFSHelper.setColObject((Column)column, (String)"bgCompareAndAnalysisColKey", (Object)proName);
                sheet.getColRange(column.getCol(), column.getCol()).setColumnWidth(110);
                try {
                    BgNFSHelper.setValue((Cell)sheet.getCell(rowIndex, colIndex, true), (Object)AnalysisColumnTool.getProValByProName(proName, this.getAnalysisSysFacade().getDataDealCenter().getFetchDataFactory().getAnalysisEleClass()));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.handleException(e);
                    SysUtil.abort();
                    continue;
                }
                catch (IllegalAccessException e) {
                    this.handleException(e);
                    SysUtil.abort();
                    continue;
                }
                catch (ClassNotFoundException e) {
                    this.handleException(e);
                    SysUtil.abort();
                }
            }
        }
    }

    private void addNewAnalysisCols(List bgItemNumerList, int addRowIndex, Sheet sheet, BgTendencyFilterParam filter1Param) {
        String analysisDataType = filter1Param.getAnalysisDataType();
        BgPeriodEnum periodTypeEnum = filter1Param.getBeginPeriod().getPeriodType();
        String elementColKey = "";
        elementColKey = "BgData".equals(analysisDataType) ? "col10" : "col11";
        int rowCount = sheet.getMaxRowIndex() + 1;
        int colNum = sheet.getMaxColIndex() + 1;
        for (int colIndex = colNum - 1; colIndex >= 0; --colIndex) {
            Column col = sheet.getColumn(colIndex, false);
            Object colKey = BgNFSHelper.getColObject((Column)col, (String)"AnalysisColKey");
            if (!"analysis_col".equals(colKey)) continue;
            int num = bgItemNumerList.size();
            for (int j = 0; j < num; ++j) {
                int newColIndex = colIndex + j + 1;
                Column column = BgNFSHelper.addColWithFreeze((Sheet)sheet, (int)newColIndex);
                BgNFSHelper.setColObject((Column)column, (String)"bgCompareAndAnalysisColKey", (Object)elementColKey);
                BgNFSHelper.setColObject((Column)column, (String)"AnalysisColKey", (Object)"analysis_col");
                sheet.getColRange(column.getCol(), column.getCol()).setColumnWidth(110);
                String bgItemPeriodNum = bgItemNumerList.get(j).toString();
                this.copyBgItemToNewCol(sheet, colIndex, newColIndex, rowCount, bgItemPeriodNum);
                BgNFSHelper.setValue((Cell)sheet.getCell(addRowIndex, newColIndex, true), (Object)BgTendencyUtil.getPeriodStrByPeriodTypeAndNum(periodTypeEnum, bgItemPeriodNum));
                if (j != 0) continue;
                BgNFSHelper.setColObject((Column)column, (String)BASE_COL_KEY, (Object)BASE_COL_KEY_VALUE);
            }
            this.accessorizeNewTable(sheet, colIndex);
        }
    }

    private void accessorizeNewTable(Sheet sheet, int delColIndex) {
        int copyColIndex = delColIndex + 1;
        int num = sheet.getMaxRowIndex() + 1;
        for (int i = 0; i < num; ++i) {
            Object obj;
            Cell oldCell = sheet.getCell(i, delColIndex, false);
            if (oldCell == null || BgNFSHelper.checkHasFormulaOfCell((Cell)oldCell) || (obj = BgNFSHelper.getValue((Cell)oldCell)) == null) continue;
            Cell cell = sheet.getCell(i, copyColIndex, true);
            cell.setValue(new Variant(obj));
        }
        BgNFSHelper.removeColumn((Sheet)sheet, (int)delColIndex);
    }

    private void copyBgItemToNewCol(Sheet sheet, int oldAnalysisColIndex, int newAnalysisColIndex, int rowCount, String bgItemPeriodNum) {
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            Cell oldCell = sheet.getCell(rowIndex, oldAnalysisColIndex, false);
            if (!BgNFSHelper.checkHasFormulaOfCell((Cell)oldCell)) continue;
            String bgItem = BgNFSHelper.getFormulaOfCell((Cell)oldCell);
            String[] array = BgFillHelper.parseStrFormulaToArray(bgItem);
            String newBgItem = AnalysisColumnTool.rebuildFormulaWithPeriodParam(array, bgItemPeriodNum);
            Cell newCell = sheet.getCell(rowIndex, newAnalysisColIndex, true);
            BgNFSHelper.setFormulaOfCell((Cell)newCell, (String)newBgItem, (boolean)true);
        }
    }

    private int locateAddedNewRowIndex(Sheet sheet) {
        int rowCount = sheet.getMaxRowIndex() + 1;
        int colCount = sheet.getMaxColIndex() + 1;
        boolean continueFlag = true;
        int rowIndex = 0;
        block0: for (int i = 0; i < rowCount && continueFlag; ++i) {
            for (int j = 0; j < colCount && continueFlag; ++j) {
                Cell cell = sheet.getCell(i, j, false);
                String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
                if (bgItem == null || "".equals(bgItem)) continue;
                rowIndex = cell.getRow();
                continueFlag = false;
                continue block0;
            }
        }
        return rowIndex;
    }

    private void removeUnRequiredCols(List analysisList, Sheet sheet) {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            if (analysisList.contains(new Integer(i))) {
                BgNFSHelper.setColObject((Column)sheet.getColumn(i, false), (String)"AnalysisColKey", (Object)"analysis_col");
                continue;
            }
            BgNFSHelper.setColObject((Column)sheet.getColumn(i, false), (String)"AnalysisColKey", (Object)"title_col");
        }
    }

    private void removeUnRequiredCols(List titleList, List analysisList, Sheet sheet) {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            if (titleList.contains(new Integer(i))) {
                BgNFSHelper.setColObject((Column)sheet.getColumn(i, false), (String)"AnalysisColKey", (Object)"title_col");
                continue;
            }
            if (analysisList.contains(new Integer(i))) {
                BgNFSHelper.setColObject((Column)sheet.getColumn(i, false), (String)"AnalysisColKey", (Object)"analysis_col");
                continue;
            }
            try {
                BgNFSHelper.removeColumn((Sheet)sheet, (int)i);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected final List getAnalysisColIndexList(Sheet sheet) {
        ArrayList<Integer> analysisColIndexList = new ArrayList<Integer>();
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            String colKey;
            Column col = sheet.getColumn(i, false);
            Object obj = BgNFSHelper.getColObject((Column)col, (String)"AnalysisColKey");
            if (!(obj instanceof String) || !"analysis_col".equals(colKey = obj.toString())) continue;
            analysisColIndexList.add(new Integer(i));
        }
        return analysisColIndexList;
    }

    protected Book addAndInitTable(BgTendencyFilterParam filter1Params) {
        if (this.book != null) {
            return this.book;
        }
        if (this.sc != null) {
            this.TabPaneMain.remove((Component)this.sc);
        }
        String bgFormID = filter1Params.getBgFormID();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)bgFormID));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("currency"));
        selector.add(new SelectorItemInfo("data"));
        selector.add(new SelectorItemInfo("currency.precision"));
        selector.add("bgTemplate.id");
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        Book book = null;
        int precision = 0;
        try {
            BgFormInfo bgFormInfo = BgFormFactory.getRemoteInstance().getBgFormCollection(viewInfo).get(0);
            BgIOHelper bih = new BgIOHelper();
            bih.setIDoForBook(new BgCompareAndAnalysisDoForBook());
            book = bih.getBook(bgFormInfo.getData());
            try {
                BgClientHelper.procesSheetPremission(book, bgFormInfo.getBgTemplate().getId().toString(), null);
            }
            catch (BgException ex) {
                book = null;
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSpecialFormResource", (String)"hasnotPermissionSheet"));
                SysUtil.abort();
            }
            BgNFSHelper.disableCal((Book)book);
            BgNFSHelper.disableUndo((Book)book);
            precision = bgFormInfo.getCurrency().getPrecision();
        }
        catch (Exception ex) {
            if (book != null) {
                book = null;
            }
            SysUtil.abort();
        }
        if (book != null && book.getSheet(0) != null) {
            this.sc = new SpreadContext();
            this.sc.addBookChangeListener(new BookChangeListener(){

                public void changed(BookChangeEvent e) {
                    if (e.isSheetActive()) {
                        BgTendencyMainUI.this.onSheetActive(e.getSheet());
                    }
                }
            });
            this.TabPaneMain.add((Component)this.sc, (Object)"Center");
            this.TabPaneMain.setTitleAt(0, EASResource.getString((String)"com.kingdee.eas.ma.budget.client.NewAnalysisResource", (String)"TendencyAnalysis"));
        }
        this.formatBook(book, precision);
        return book;
    }

    private void formatBook(Book book, int precision) {
        if (book != null) {
            Sheet sheet = null;
            Cell cell = null;
            BigDecimal value = null;
            StyleAttributes numSsa = Styles.getEmptySA();
            String numberFormat = "#,##0";
            if (precision != 0) {
                numberFormat = "#,##0." + BgNFSHelper.getNumberFormat((String)"0", (int)precision);
            }
            numSsa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            numSsa.setNumberFormat(numberFormat);
            int n = book.getSheetCount();
            for (int i = 0; i < n; ++i) {
                sheet = book.getSheet(i);
                if (sheet == null) continue;
                int rowM = sheet.getMaxRowIndex() + 1;
                int colM = sheet.getMaxColIndex() + 1;
                for (int k = 0; k < rowM; ++k) {
                    for (int j = 0; j < colM; ++j) {
                        cell = sheet.getCell(k, j, false);
                        if (cell == null || cell.getValue() == null || cell.getValue().getValue() == null) continue;
                        try {
                            value = new BigDecimal(cell.getValue().getValue().toString().trim().replaceAll(",", ""));
                            BgNFSHelper.setValue((Cell)cell, (Object)value);
                            Range r = sheet.getRange(cell);
                            r.setStyle(numSsa, Styles.getEmptySA());
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    @Override
    protected BgAnalyseFilterBaseUI getFilterUI() {
        try {
            if (this.filterUI == null) {
                this.filterUI = new BgTendencyAnalysisFilterUI((Object)this);
            }
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return this.filterUI;
    }

    @Override
    protected boolean hasOtherFilterUI() {
        return true;
    }

    @Override
    protected KDPanel[] getOtherFilterUI() {
        try {
            if (this.filter2UI == null) {
                this.filter2UI = new BgTendencyAnalysisFilter2UI();
            }
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return new KDPanel[]{this.filter2UI};
    }

    protected BgAnalyseFilterBaseUI getFilter2UI() {
        KDPanel[] ary = this.getOtherFilterUI();
        BgTendencyAnalysisFilter2UI filter2UI = (BgTendencyAnalysisFilter2UI)ary[0];
        return filter2UI;
    }

    protected BgTendencyFilterParam getFilterUIParams() {
        BgTendencyAnalysisFilterUI tempFilterUI = (BgTendencyAnalysisFilterUI)this.getFilterUI();
        BgTendencyFilterParam filterParam = tempFilterUI.getOwnFilterParam();
        return filterParam;
    }

    protected BgTendencyFilterParam getFilterUI2Params() {
        KDPanel[] panels = this.getOtherFilterUI();
        this.filter2UI = (BgTendencyAnalysisFilter2UI)panels[0];
        return this.filter2UI.getOwnFilterParam();
    }

    private IBgTendencyAnalysisFacade getRemoteInstance() {
        if (this.iBgTendencyAnalysisFacade == null) {
            try {
                this.iBgTendencyAnalysisFacade = BgTendencyAnalysisFacadeFactory.getRemoteInstance();
            }
            catch (BOSException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
        }
        return this.iBgTendencyAnalysisFacade;
    }

    private IFullOrgUnit getFullOrgUnitInterface() throws Exception {
        return FullOrgUnitFactory.getRemoteInstance();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.sc != null) {
            this.sc.getPrintManager().print();
        }
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (this.sc != null) {
            this.sc.getPrintManager().printPreview();
        }
        this.setPrintConfigInfo();
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        File file;
        KDFileChooser fc = new KDFileChooser();
        fc.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"322_BgTendencyMainUI"));
        fc.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
        fc.setAcceptAllFileFilterUsed(false);
        String fileName = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.NewAnalysisResource", (String)"excelFileName");
        fc.setSelectedFile(new File(BgExportHelper.getDefaultDirtory() + File.separator + fileName));
        if (fc.showSaveDialog((Component)((Object)this)) == 0 && (file = fc.getSelectedFile()) != null) {
            if (file.exists()) {
                int re = MsgBox.showConfirm3((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"existsFile"));
                if (re == 1 || re == 2) {
                    return;
                }
                file.delete();
            }
            try {
                this.exportBookContent(file);
            }
            catch (Exception ex) {
                throw new BgNFormException(BgNFormException.FILEEXPORTERROR);
            }
        }
    }

    protected void exportBookContent(File file) throws Exception {
        Book _book = this.sc.getBook();
        Sheet _sheet = null;
        Cell _cell = null;
        String numFormater = this.getNumberFormat(null);
        KDSBook _kdsBook = null;
        KDSSheet _kdsSheet = null;
        KDSCell _kdsCell = null;
        int _sheetIndex = 0;
        int _sheetSize = _book.getSheetCount();
        int _rowIndex = 0;
        int _rowCount = 0;
        int _colIndex = 0;
        int _colCount = 0;
        String _filename = file.getPath();
        _kdsBook = new KDSBook(_filename);
        for (_sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
            _sheet = _book.getSheet(_sheetIndex);
            _kdsSheet = new KDSSheet(_kdsBook, _sheet.getSheetName());
            _kdsBook.addSheet(null, _kdsSheet);
            _rowCount = _sheet.getMaxRowIndex();
            _colCount = _sheet.getMaxColIndex();
            for (_rowIndex = 0; _rowIndex <= _rowCount; ++_rowIndex) {
                for (_colIndex = 0; _colIndex <= _colCount; ++_colIndex) {
                    _cell = _sheet.getCell(_rowIndex, _colIndex, false);
                    if (_cell == null) {
                        _kdsCell = _kdsSheet.getCell(_rowIndex, _colIndex, true);
                        continue;
                    }
                    StyleAttributes ssa = Styles.getEmptySA();
                    _cell.getSheet().getRange(_cell).getStyle(ssa);
                    if (_cell == null || _cell.getValue() == Variant.nullVariant) continue;
                    Variant value = _cell.getValue();
                    if (value.getValue() instanceof BigDecimal) {
                        if (StringUtils.isEmpty((String)ssa.getNumberFormat())) {
                            ssa.setNumberFormat(numFormater);
                        }
                        ssa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    }
                    _kdsCell = _kdsSheet.setCell(_rowIndex, _colIndex, (Object)value, (ShareStyleAttributes)ssa);
                }
            }
        }
        ExportManager em = new ExportManager();
        em.exportToExcel(_kdsBook, _filename);
    }

    public void setUITitle(String title) {
        title = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.NewAnalysisResource", (String)"TendencyAnalysis");
        super.setUITitle(title);
    }

    @Override
    protected int getWidthOfDialog() {
        return 300;
    }

    private class MyTableMouseController
    extends TableMouseController {
        public MyTableMouseController(SpreadContext context) {
            super(context);
        }

        public void mouseClicked(MouseEvent e) {
            Sheet activeSheet = BgTendencyMainUI.this.sc.getBook().getActiveSheet();
            Cell cell = activeSheet.getActiveCell();
            if (BgTendencyMainUI.this.render != null && cell != null) {
                OrgUnitRender.NumberExpendRender numRender = (OrgUnitRender.NumberExpendRender)BgTendencyMainUI.this.render.getRender(cell, -1);
                if (numRender == null) {
                    return;
                }
                NumberExpandInfo numberExpandInfo = BgNFCHelper.getNumberExpandInfo((Cell)cell);
                if (numberExpandInfo != null && numRender.inRect(numberExpandInfo, e.getX(), e.getY())) {
                    BgTendencyMainUI.this.setTreeDisplayStyle(cell, numberExpandInfo, activeSheet);
                }
            }
        }
    }
}

