/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgControlRuleInfo;
import com.kingdee.eas.ma.budget.BgControlSchemeInfo;
import com.kingdee.eas.ma.budget.BgCtrlException;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.BgTraceFindBudgetMsg;
import com.kingdee.eas.ma.budget.BudgetCtrlFacadeFactory;
import com.kingdee.eas.ma.budget.IBudgetCtrlFacade;
import com.kingdee.eas.ma.budget.client.AbstractBgTraceFindBudgetUI;
import com.kingdee.eas.ma.budget.client.ReportDetailUI;
import com.kingdee.eas.util.client.EASResource;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgTraceFindBudgetUI
extends AbstractBgTraceFindBudgetUI {
    private static final Logger logger = CoreUIObject.getLogger(BgTraceFindBudgetUI.class);
    Map bgElementMap = new HashMap();
    public static final String DETAIL_MSG_OPEN = "DETAIL_MSG_OPEN";

    public void onLoad() throws Exception {
        super.onLoad();
        IObjectValue billInfo = (IObjectValue)this.getUIContext().get("billInfo");
        if (billInfo == null) {
            return;
        }
        IBudgetCtrlFacade iBudgetCtrlFacade = BudgetCtrlFacadeFactory.getRemoteInstance();
        Map returnMap = iBudgetCtrlFacade.processTraceFindBudget(billInfo);
        this.initTable(returnMap);
    }

    private void initTable(Map returnMap) {
        BgControlSchemeInfo controlScheme = (BgControlSchemeInfo)returnMap.get("bgControlScheme");
        List traceFindBudgetMsgList = (List)returnMap.get("traceFindBudgetMsg");
        if (controlScheme == null) {
            this.message.setText(new BgCtrlException(BgCtrlException.NOTACROSS, new String[]{EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"323_BgTraceFindBudgetUI")}).getMessage());
            return;
        }
        this.txtBgControlScheme.setText(controlScheme.getName());
        StringBuffer sb = new StringBuffer();
        BgTraceFindBudgetMsg traceFindBudgetMsg = null;
        int mergeStart = 0;
        int mergeEnd = 0;
        int controlRuleIndex = 0;
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        this.tblMain.getGroupManager().group();
        DateFormat dateFormat = BgNationalFormatUIUtil.getNationalDateFormat();
        if (traceFindBudgetMsgList != null) {
            for (int i = 0; i < traceFindBudgetMsgList.size(); ++i) {
                traceFindBudgetMsg = (BgTraceFindBudgetMsg)traceFindBudgetMsgList.get(i);
                IRow row = this.tblMain.addRow();
                row.getCell("controlRule").setValue((Object)new Integer(traceFindBudgetMsg.getBgControlRuleIndex() + 1));
                row.getCell("orgUnit").setValue((Object)traceFindBudgetMsg.getOrgUnitName());
                row.getCell("bizItem").setValue((Object)traceFindBudgetMsg.getBizItemName());
                row.getCell("bgItem").setValue((Object)traceFindBudgetMsg.getBgItemName());
                if (traceFindBudgetMsg.getBizDate() instanceof Date) {
                    row.getCell("bizDate").setValue((Object)dateFormat.format(traceFindBudgetMsg.getBizDate()));
                } else {
                    row.getCell("bizDate").setValue(null);
                }
                row.getCell("bgPeriod").setValue((Object)traceFindBudgetMsg.getBgPeriodName());
                row.getCell("currency").setValue((Object)traceFindBudgetMsg.getCurrencyName());
                row.getCell("bgElement").setValue((Object)traceFindBudgetMsg.getBgElementName());
                row.setUserObject((Object)traceFindBudgetMsg.getBgControlRuleInfo());
                if (traceFindBudgetMsg.getBgControlRuleIndex() != controlRuleIndex) {
                    this.tblMain.getMergeManager().mergeBlock(mergeStart, 0, mergeEnd - 1, 0);
                    mergeStart = mergeEnd;
                    controlRuleIndex = traceFindBudgetMsg.getBgControlRuleIndex();
                }
                ++mergeEnd;
                if (StringUtils.isEmpty((String)traceFindBudgetMsg.getMsg())) continue;
                sb.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"324_BgTraceFindBudgetUI") + Integer.toString(traceFindBudgetMsg.getBgControlRuleIndex() + 1) + ": ").append(traceFindBudgetMsg.getMsg());
                sb.append("\n");
            }
            if (mergeStart != mergeEnd) {
                this.tblMain.getMergeManager().mergeBlock(mergeStart, 0, mergeEnd - 1, 0);
            }
            if (!StringUtils.isEmpty((String)sb.toString())) {
                this.message.setText(sb.toString());
            }
        }
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getClickCount() < 2) {
            return;
        }
        int rowIndex = e.getRowIndex();
        BgControlRuleInfo controlRuleInfo = (BgControlRuleInfo)this.tblMain.getRow(rowIndex).getUserObject();
        BgElementInfo bgElementInfo = null;
        if (controlRuleInfo == null) {
            return;
        }
        if (this.bgElementMap.containsKey(controlRuleInfo.getElementNumber())) {
            bgElementInfo = (BgElementInfo)this.bgElementMap.get(controlRuleInfo.getElementNumber());
        } else {
            bgElementInfo = BgElementFactory.getRemoteInstance().getBgElementInfo("select id, name, number where number = '" + controlRuleInfo.getElementNumber() + "'");
            this.bgElementMap.put(controlRuleInfo.getElementNumber(), bgElementInfo);
        }
        StringBuffer msg = new StringBuffer();
        msg.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"325_BgTraceFindBudgetUI")).append("\n\n");
        msg.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"326_BgTraceFindBudgetUI")).append(controlRuleInfo.getAliasOrgUnit()).append("\n");
        msg.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"327_BgTraceFindBudgetUI")).append(controlRuleInfo.getAliasItemCombination()).append("\n");
        msg.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"328_BgTraceFindBudgetUI")).append(controlRuleInfo.getAliasCurrency()).append("\n");
        msg.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"329_BgTraceFindBudgetUI")).append(controlRuleInfo.getAliasBizDate()).append("\n");
        msg.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"330_BgTraceFindBudgetUI")).append((Object)controlRuleInfo.getPeriodCycle()).append("\n");
        msg.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"331_BgTraceFindBudgetUI")).append(StringUtils.isEmpty((String)controlRuleInfo.getAliasPeriod()) ? "" : controlRuleInfo.getAliasPeriod()).append("\n");
        msg.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"332_BgTraceFindBudgetUI")).append(bgElementInfo.getName()).append("\n");
        msg.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"333_BgTraceFindBudgetUI")).append(StringUtils.isEmpty((String)controlRuleInfo.getAliasRuleCondition()) ? "" : controlRuleInfo.getAliasRuleCondition()).append("\n");
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)DETAIL_MSG_OPEN, (Object)msg.toString());
        uiContext.put((Object)"reportTitle", (Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"334_BgTraceFindBudgetUI"));
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReportDetailUI.class.getName(), (Map)uiContext);
            uiWindow.show();
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
    }
}

