/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.budget.BgTypeCollection;
import com.kingdee.eas.ma.budget.BgTypeInfo;
import com.kingdee.eas.ma.budget.client.BgTypeListUI;

public class BgTypeF7ListUI
extends BgTypeListUI {
    private boolean isDisplaySelf = true;

    @Override
    protected boolean isF7Query() {
        return true;
    }

    public BgTypeCollection getSelectedBgType() {
        this.checkSelected();
        BgTypeCollection col = null;
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range != null && range.size() > 0) {
            int rangeCount = range.size();
            col = new BgTypeCollection();
            for (int i = 0; i < rangeCount; ++i) {
                KDTSelectBlock block = (KDTSelectBlock)range.get(i);
                int start = block.getBeginRow();
                int end = block.getEndRow();
                for (int j = start; j <= end; ++j) {
                    String id = this.getCellValue(j, "id");
                    if (id == null) continue;
                    BgTypeInfo info = new BgTypeInfo();
                    info.setId(BOSUuid.read((String)id));
                    info.setNumber(this.getCellValue(j, "number"));
                    info.setName(this.getCellValue(j, "name"));
                    col.add(info);
                }
            }
        }
        return col;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK arg0, EntityViewInfo view) {
        if (!this.isDisplaySelf()) {
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)"BV/FQwEUEADgABtLwKgSXv9s2OA=", CompareType.NOTEQUALS));
        }
        return super.getQueryExecutor(arg0, view);
    }

    public String getCellValue(int rowIndex, String colName) {
        ICell cell = this.tblMain.getCell(rowIndex, colName);
        if (cell != null && cell.getValue() != null) {
            return cell.getValue().toString();
        }
        return null;
    }

    public KDWorkButton getQueryBtn() {
        return this.btnQuery;
    }

    public boolean isDisplaySelf() {
        return this.isDisplaySelf;
    }

    public void setDisplaySelf(boolean isDisplaySelf) {
        this.isDisplaySelf = isDisplaySelf;
    }
}

