/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.client.AbstractBgVersionUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgVersionUI
extends AbstractBgVersionUI {
    private static final Logger logger = CoreUIObject.getLogger(BgVersionUI.class);
    private static String BG_ADJUSTID = "ADJUSTID";
    private String value = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.fillTable();
        this.tblMain.setEditable(false);
    }

    private void fillTable() throws EASBizException, BOSException {
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        String adjustId = (String)this.getUIContext().get(BG_ADJUSTID);
        IBgForm iBgForm = BgFormFactory.getRemoteInstance();
        HashSet<Integer> state = new HashSet<Integer>();
        state.add(new Integer(15));
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("adjust.id", (Object)adjustId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", state, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        viewInfo.getSorter().add(new SorterItemInfo("versionNo"));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("versionNo"));
        selector.add(new SelectorItemInfo("auditTime"));
        selector.add(new SelectorItemInfo("creator.name"));
        selector.add(new SelectorItemInfo("adjust.id"));
        selector.add(new SelectorItemInfo("dataSource"));
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        BgFormCollection adjustFormColl = iBgForm.getBgFormCollection(viewInfo);
        IRow row = null;
        for (int i = 0; i < adjustFormColl.size(); ++i) {
            row = this.tblMain.addRow();
            BigDecimal verNo = adjustFormColl.get(i).getVersionNo().setScale(1);
            row.getCell(0).setValue((Object)verNo);
            row.getCell(2).setValue((Object)adjustFormColl.get(i).getAuditTime());
            row.getCell(3).setValue((Object)adjustFormColl.get(i).getCreator().getName());
            row.getCell(1).setValue((Object)adjustFormColl.get(i).getDataSource().getAlias());
            row.setUserObject((Object)adjustFormColl.get(i));
        }
        if (adjustFormColl != null) {
            adjustFormColl.clear();
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static String showDialogWindow(Component ui, String adjustId, String flag) throws Exception {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)BG_ADJUSTID, (Object)adjustId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgVersionUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        String bgFormId = ((BgVersionUI)uiWindow.getUIObject()).getValue();
        return bgFormId;
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        super.btnOK_actionPerformed(e);
        List rowList = BgClientHelper.getAllSelectedRow(this.tblMain);
        if (rowList.size() > 0 && (row = (IRow)rowList.get(0)) != null) {
            BgFormInfo bgForm = (BgFormInfo)row.getUserObject();
            this.setValue(bgForm.getId().toString());
        }
        this.destroyWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }
}

