/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.analysiscolumn.BgCompareAndAnalysisObjInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgViewActualCtrlUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class BgViewActualCtrlUI
extends AbstractBgViewActualCtrlUI {
    private static final long serialVersionUID = -5145328890731264582L;
    private String orgUnitId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();

    public void onLoad() throws Exception {
        super.onLoad();
        String formulaString = String.valueOf(this.getUIContext().get("formula"));
        this.inputItemAndElement(formulaString);
        List recordList = (List)this.getUIContext().get("records");
        this.fillDataToTable(recordList);
    }

    private void inputItemAndElement(String formulaString) {
        Vector itemAndElement = BgClientHelper.getItemAndElement(formulaString, this.orgUnitId);
        String itemNum = new String();
        String itemName = new String();
        String element = new String();
        Map visItemsMap = new HashMap();
        Map bgElementMap = new HashMap();
        visItemsMap = (Map)itemAndElement.get(0);
        bgElementMap = (Map)itemAndElement.get(1);
        itemNum = visItemsMap.keySet().toString();
        itemName = visItemsMap.values().toString();
        element = bgElementMap.values().toString();
        this.kDTextField1.setText(itemNum.substring(itemNum.indexOf("[") + 1, itemNum.indexOf("]")));
        this.kDTextField2.setText(itemName.substring(itemName.indexOf("[") + 1, itemName.indexOf("]")));
        this.kDTextField3.setText(element.substring(element.indexOf("[") + 1, element.indexOf("]")));
    }

    private void fillDataToTable(List recordList) {
        this.tblMain.setEditable(false);
        this.tblMain.checkParsed();
        int size = recordList.size();
        BigDecimal sum = new BigDecimal("0.00");
        for (int i = 0; i < size; ++i) {
            BgCompareAndAnalysisObjInfo.ActualAdjustRecordDataObj info = (BgCompareAndAnalysisObjInfo.ActualAdjustRecordDataObj)recordList.get(i);
            this.tblMain.addRow(i);
            this.tblMain.getCell(i, 0).setValue((Object)info.getPeriodNum());
            this.tblMain.getCell(i, 1).setValue((Object)info.getBillType());
            this.tblMain.getCell(i, 2).setValue((Object)info.getBillNum());
            this.tblMain.getCell(i, 3).setValue((Object)info.getBizDate());
            BigDecimal actualVal = info.getActualVal().setScale(2);
            sum = sum.add(actualVal);
            this.tblMain.getCell(i, 4).setValue((Object)actualVal);
        }
        if (size != 0) {
            IRow row = this.tblMain.addRow(size);
            row.getStyleAttributes().setBackground(Color.YELLOW);
            this.tblMain.getCell(size, 0).setValue((Object)"SUM");
            this.tblMain.getCell(size, 4).setValue((Object)sum);
        }
    }
}

