/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.newrpt.client.designer.IDisplayValueProvider;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.client.BgColForPeriodEditUI;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import java.util.Map;

public class BudgetColPeriodDisplayValueProvider
implements IDisplayValueProvider {
    private BgColForPeriodEditUI ui = null;

    public BudgetColPeriodDisplayValueProvider(Component component) {
        if (component != null && component instanceof BgColForPeriodEditUI) {
            this.ui = (BgColForPeriodEditUI)((Object)component);
        }
    }

    public BigDecimal getCoefficient() {
        return this.ui.getBgFormInfo(this.ui).getMeasureUnit() != null ? this.ui.getBgFormInfo(this.ui).getMeasureUnit().getCoefficient() : BgNConstants.ONE;
    }

    public int getPrecision() {
        return this.ui.getBgFormInfo(this.ui).getCurrency().getPrecision();
    }

    public Map getMeasureUnitMap() {
        return this.ui.getMeasreUnitMap();
    }

    public Map getCurrencyMap() {
        return this.ui.getCurrencyMap();
    }

    public Map getFormulaMap() {
        return this.ui.getFormulaMap();
    }

    public Object getDisplayValue(Cell cell, int viewMode) {
        if (cell != null && !BgNFSHelper.checkIsEmptyValue((Cell)cell)) {
            if (cell.getValue().getValue() instanceof GregorianCalendar) {
                return cell.getText();
            }
            String _text = cell.getText();
            if (!StringUtils.isEmpty((String)_text)) {
                if (BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) {
                    if (this.getMeasureUnitMap().isEmpty()) {
                        return this.getMeasureUnitDisplayValue(cell, _text, false);
                    }
                    return this.getMeasureUnitDisplayValue(cell, _text, true);
                }
                if (cell.getUserObject("BG_COLLECT") != null && cell.getUserObject("BG_FORMULA") != null) {
                    if (this.getMeasureUnitMap().isEmpty()) {
                        return this.getMeasureUnitValue(cell, _text, false);
                    }
                    return this.getMeasureUnitValue(cell, _text, true);
                }
                return this.getDefMeasureUnitDisplayValue(cell, _text);
            }
        }
        return null;
    }

    private Object getMeasureUnitValue(Cell cell, Object obj, boolean useMeasureUnit) {
        String showStr;
        if ("0".equals(obj) && (showStr = BgNFSHelper.checkShowStrByNumberic((Cell)cell)) != null) {
            return showStr;
        }
        String _formulaStr = null;
        String[] _parameter = null;
        BigDecimal _coefficient = this.getCoefficient();
        int _precision = this.getPrecision();
        CurrencyInfo _currencyInfo = null;
        _formulaStr = cell.getUserObject("BG_FORMULA").getValue().toString();
        _parameter = BgNFSHelper.parseFormulaPara((Map)this.getFormulaMap(), (String)_formulaStr);
        if (_parameter != null) {
            if (useMeasureUnit && !StringUtils.isEmpty((String)_parameter[2]) && this.getMeasureUnitMap().containsKey(_parameter[2])) {
                _coefficient = (BigDecimal)this.getMeasureUnitMap().get(_parameter[2]);
            }
            if (!StringUtils.isEmpty((String)_parameter[5]) && this.getCurrencyMap().containsKey(_parameter[5])) {
                _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[5]);
                _precision = _currencyInfo.getPrecision();
            }
        }
        return this.getDisplayValue(obj, _coefficient, _precision);
    }

    protected Object getMeasureUnitDisplayValue(Cell cell, Object obj, boolean useMeasureUnit) {
        String showStr;
        if ("0".equals(obj) && (showStr = BgNFSHelper.checkShowStrByNumberic((Cell)cell)) != null) {
            return showStr;
        }
        String _formulaStr = null;
        String[] _parameter = null;
        BigDecimal _coefficient = this.getCoefficient();
        int _precision = this.getPrecision();
        CurrencyInfo _currencyInfo = null;
        _formulaStr = BgNFSHelper.getFormulaOfCell((Cell)cell);
        _parameter = BgNFSHelper.parseFormulaPara((Map)this.getFormulaMap(), (String)_formulaStr);
        if (_parameter != null) {
            if (useMeasureUnit && !StringUtils.isEmpty((String)_parameter[2]) && this.getMeasureUnitMap().containsKey(_parameter[2])) {
                _coefficient = (BigDecimal)this.getMeasureUnitMap().get(_parameter[2]);
            }
            if (!StringUtils.isEmpty((String)_parameter[5]) && this.getCurrencyMap().containsKey(_parameter[5])) {
                _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[5]);
                _precision = _currencyInfo.getPrecision();
            }
        }
        _precision = BgNFSHelper.getDigitOfNumber((Cell)cell, (int)_precision);
        return this.getDisplayValue(obj, _coefficient, _precision);
    }

    protected Object getDefMeasureUnitDisplayValue(Cell cell, Object obj) {
        if (!BgNFSHelper.checkHasNumbericOfCell((Cell)cell) || !BgNFSHelper.checkIsNumericOfCell((Cell)cell)) {
            return obj;
        }
        String _text = null;
        int _precision = this.getPrecision();
        try {
            _precision = BgNFSHelper.getDigitOfNumber((Cell)cell, (int)_precision);
            _text = this.getDisplayValue(obj, this.getCoefficient(), _precision);
        }
        catch (Exception ex) {
            _text = obj.toString();
        }
        return _text;
    }

    protected String getDisplayValue(Object obj, BigDecimal coefficient, int precision) {
        String _text = null;
        BigDecimal _value = null;
        DecimalFormat _decFormat = null;
        try {
            _value = BgNationalFormatUIUtil.parseToBigDecimal(obj).divide(coefficient, precision, 4);
            _decFormat = BgNationalFormatUIUtil.getDecimalFormat(precision);
            _text = _decFormat.format(_value.doubleValue());
        }
        catch (Exception ex) {
            _text = obj.toString();
        }
        return _text;
    }
}

