/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.newrpt.client.designer.IDisplayValueProvider;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.client.BgDecomposerFormEditUI;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import java.util.Map;

public final class BudgetDecDisplayValueProvider
implements IDisplayValueProvider {
    private BgDecomposerFormEditUI ui = null;

    public BudgetDecDisplayValueProvider(Component component) {
        if (component != null && component instanceof BgDecomposerFormEditUI) {
            this.ui = (BgDecomposerFormEditUI)((Object)component);
        }
    }

    public BigDecimal getCoefficient() {
        return this.ui.getBgFormInfo(this.ui).getMeasureUnit().getCoefficient();
    }

    public int getPrecision() {
        return this.ui.getBgFormInfo(this.ui).getCurrency().getPrecision();
    }

    public Map getMeasureUnitMap() {
        return this.ui.getMeasreUnitMap();
    }

    public Map getCurrencyMap() {
        return this.ui.getCurrencyMap();
    }

    public Map getFormulaMap() {
        return this.ui.getFormulaMap();
    }

    public Object getDisplayValue(Cell cell, int viewMode) {
        if (cell != null && !BgNFSHelper.checkIsEmptyValue((Cell)cell)) {
            if (cell.getValue().getValue() instanceof GregorianCalendar) {
                return cell.getText();
            }
            BigDecimal value = BgNationalFormatUIUtil.getBigDecimal(cell);
            if (value != null) {
                if (BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) {
                    if (this.getMeasureUnitMap().isEmpty()) {
                        return this.getMeasureUnitDisplayValue(cell, value, false);
                    }
                    return this.getMeasureUnitDisplayValue(cell, value, true);
                }
                if (cell.getUserObject("BG_COLLECT") != null && cell.getUserObject("BG_FORMULA") != null) {
                    if (this.getMeasureUnitMap().isEmpty()) {
                        return this.getMeasureUnitValue(cell, value, false);
                    }
                    return this.getMeasureUnitValue(cell, value, true);
                }
                return this.getDefMeasureUnitDisplayValue(cell, value);
            }
        }
        return null;
    }

    private Object getMeasureUnitValue(Cell cell, BigDecimal obj, boolean useMeasureUnit) {
        String showStr;
        if ("0".equals(obj) && (showStr = BgNFSHelper.checkShowStrByNumberic((Cell)cell)) != null) {
            return showStr;
        }
        String _formulaStr = null;
        String[] _parameter = null;
        BigDecimal _coefficient = this.getCoefficient();
        int _precision = this.getPrecision();
        CurrencyInfo _currencyInfo = null;
        _formulaStr = cell.getUserObject("BG_FORMULA").getValue().toString();
        _parameter = BgNFSHelper.parseFormulaPara((Map)this.getFormulaMap(), (String)_formulaStr);
        if (_parameter != null) {
            if (useMeasureUnit && !StringUtils.isEmpty((String)_parameter[2]) && this.getMeasureUnitMap().containsKey(_parameter[2])) {
                _coefficient = (BigDecimal)this.getMeasureUnitMap().get(_parameter[2]);
            }
            if (!StringUtils.isEmpty((String)_parameter[5]) && this.getCurrencyMap().containsKey(_parameter[5])) {
                _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[5]);
                _precision = _currencyInfo.getPrecision();
            }
        }
        return this.getDisplayValue(obj, _coefficient, _precision);
    }

    protected Object getMeasureUnitDisplayValue(Cell cell, BigDecimal obj, boolean useMeasureUnit) {
        String showStr;
        if ("0".equals(obj) && (showStr = BgNFSHelper.checkShowStrByNumberic((Cell)cell)) != null) {
            return showStr;
        }
        String _formulaStr = null;
        String[] _parameter = null;
        BigDecimal _coefficient = this.getCoefficient();
        int _precision = this.getPrecision();
        CurrencyInfo _currencyInfo = null;
        _formulaStr = BgNFSHelper.getFormulaOfCell((Cell)cell);
        _parameter = BgNFSHelper.parseFormulaPara((Map)this.getFormulaMap(), (String)_formulaStr);
        if (_parameter != null) {
            if (useMeasureUnit && !StringUtils.isEmpty((String)_parameter[2]) && this.getMeasureUnitMap().containsKey(_parameter[2])) {
                _coefficient = (BigDecimal)this.getMeasureUnitMap().get(_parameter[2]);
            }
            if (!StringUtils.isEmpty((String)_parameter[5]) && this.getCurrencyMap().containsKey(_parameter[5])) {
                _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[5]);
                _precision = _currencyInfo.getPrecision();
            }
        }
        _precision = BgNFSHelper.getDigitOfNumber((Cell)cell, (int)_precision);
        return this.getDisplayValue(obj, _coefficient, _precision);
    }

    protected Object getDefMeasureUnitDisplayValue(Cell cell, BigDecimal obj) {
        if (!BgNFSHelper.checkHasNumbericOfCell((Cell)cell) || !BgNFSHelper.checkIsNumericOfCell((Cell)cell)) {
            return obj;
        }
        String _text = null;
        int _precision = this.getPrecision();
        try {
            _precision = BgNFSHelper.getDigitOfNumber((Cell)cell, (int)_precision);
            _text = this.getDisplayValue(obj, this.getCoefficient(), _precision);
        }
        catch (Exception ex) {
            _text = obj.toString();
        }
        return _text;
    }

    protected String getDisplayValue(BigDecimal _value, BigDecimal coefficient, int precision) {
        String _text = null;
        DecimalFormat _decFormat = null;
        try {
            _decFormat = BgNationalFormatUIUtil.getDecimalFormat(precision);
            _text = _decFormat.format(_value.doubleValue());
        }
        catch (Exception ex) {
            _text = _value.toString();
        }
        return _text;
    }
}

