/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.newrpt.designer.comment.CommentUtil;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.PostilCollection;
import com.kingdee.eas.fi.rpt.PostilInfo;
import com.kingdee.eas.fi.rpt.PostilTypeEnum;
import com.kingdee.eas.fi.rpt.Rect;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptComment;
import com.kingdee.eas.fi.rpt.RptCommentTank;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.ma.budget.BgTemplateComment;
import com.kingdee.eas.ma.budget.BgTemplateCommentTank;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.BgTemplatePostilCollection;
import com.kingdee.eas.ma.budget.BgTemplatePostilInfo;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class BudgetUtilForClient
extends RptUtilForClient {
    public static void prepareReportInfo4Save(ReportBaseInfo info, Book book) {
        int i;
        ReportVariables variables = ReportVariables.loadFromBook((Book)book);
        PostilInfo _postilInfo = null;
        PostilCollection _postils = new PostilCollection();
        PostilCollection postils = info.getPostils();
        Comment _comment = book.getComment();
        if (_comment != null) {
            if (_comment instanceof RptCommentTank) {
                int size = ((RptCommentTank)_comment).getSize();
                for (int i2 = 0; i2 < size; ++i2) {
                    _postilInfo = ((RptCommentTank)_comment).getEntry(i2).getTrueSource();
                    _postilInfo.setPostilType(PostilTypeEnum.REPORT);
                    _postilInfo.setReport(info);
                    if (StringUtils.isEmpty((String)_postilInfo.getDescription())) {
                        _postilInfo.setDescription(" ");
                    }
                    if (_postilInfo.getId() != null) {
                        _postilInfo.setStatus(2);
                    }
                    _postils.add(_postilInfo);
                }
            } else {
                _postilInfo = new PostilInfo();
                _postilInfo.setPostilType(PostilTypeEnum.REPORT);
                _postilInfo.setReport(info);
                _postilInfo.setDescription(_comment.getText());
                if (StringUtils.isEmpty((String)_postilInfo.getDescription())) {
                    _postilInfo.setDescription(" ");
                }
                _postilInfo.setStatus(1);
                _postils.add(_postilInfo);
            }
        } else if (postils != null) {
            int in = postils.size();
            for (i = 0; i < in; ++i) {
                _postilInfo = postils.get(i);
                if (_postilInfo.getPostilType().getValue() != 1) continue;
                _postilInfo.setStatus(3);
                _postils.add(_postilInfo);
            }
        }
        for (i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            String name = sheet.getSheetName();
            RptSheetParamInfo pinfo = VariablesHelper.variables2SheetParams((ReportVariables)variables, (String)name, (boolean)true, null);
            pinfo.setSheetID(sheet.getID());
            pinfo.setRelaType(ReportTypeEnum.REPORT);
            if (info.getSheetParam().get(i) != null) {
                for (int m = 0; m < info.getSheetParam().size(); ++m) {
                    if (!info.getSheetParam().get(m).getSheetID().equals(sheet.getID())) continue;
                    pinfo.setId(info.getSheetParam().get(m).getId());
                    info.getSheetParam().set(m, pinfo);
                    break;
                }
            } else {
                info.getSheetParam().add(pinfo);
            }
            BudgetUtilForClient.pickPostil(info, sheet, _postils, pinfo);
        }
        info.put("postils", (Object)_postils);
    }

    public static void prepareTemplateInfo4Save(BgTemplateInfo info, Book book) {
        int i;
        ReportVariables variables = ReportVariables.loadFromBook((Book)book);
        BgTemplatePostilInfo _postilInfo = null;
        BgTemplatePostilCollection _postils = new BgTemplatePostilCollection();
        BgTemplatePostilCollection postils = info.getPostils();
        Comment _comment = book.getComment();
        if (_comment != null) {
            int i2;
            int size;
            if (_comment instanceof BgTemplateCommentTank) {
                size = ((BgTemplateCommentTank)_comment).getSize();
                for (i2 = 0; i2 < size; ++i2) {
                    _postilInfo = ((BgTemplateCommentTank)_comment).getEntry(i2).getTrueSource();
                    _postilInfo.setPostilType(PostilTypeEnum.REPORT);
                    _postilInfo.setTemplate(info);
                    if (StringUtils.isEmpty((String)_postilInfo.getDescription())) {
                        _postilInfo.setDescription(" ");
                    }
                    if (_postilInfo.getId() != null) {
                        _postilInfo.setStatus(2);
                    }
                    _postils.add(_postilInfo);
                }
            } else if (_comment instanceof RptCommentTank) {
                size = ((RptCommentTank)_comment).getSize();
                for (i2 = 0; i2 < size; ++i2) {
                    _postilInfo = new BgTemplatePostilInfo();
                    _postilInfo.setPostilType(PostilTypeEnum.REPORT);
                    _postilInfo.setTemplate(info);
                    _postilInfo.setDescription(((RptCommentTank)_comment).getEntry(i2).getContent());
                    if (StringUtils.isEmpty((String)_postilInfo.getDescription())) {
                        _postilInfo.setDescription(" ");
                    }
                    _postilInfo.setStatus(1);
                    _postils.add(_postilInfo);
                }
            } else {
                _postilInfo = new BgTemplatePostilInfo();
                _postilInfo.setPostilType(PostilTypeEnum.REPORT);
                _postilInfo.setTemplate(info);
                _postilInfo.setDescription(_comment.getText());
                if (StringUtils.isEmpty((String)_postilInfo.getDescription())) {
                    _postilInfo.setDescription(" ");
                }
                _postilInfo.setStatus(1);
                _postils.add(_postilInfo);
            }
        } else if (postils != null) {
            int in = postils.size();
            for (i = 0; i < in; ++i) {
                _postilInfo = postils.get(i);
                if (_postilInfo.getPostilType().getValue() != 1) continue;
                _postilInfo.setStatus(3);
                _postils.add(_postilInfo);
            }
        }
        for (i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            String name = sheet.getSheetName();
            RptSheetParamInfo pinfo = VariablesHelper.variables2SheetParams((ReportVariables)variables, (String)name, (boolean)true, null);
            pinfo.setSheetID(sheet.getID());
            pinfo.setRelaType(ReportTypeEnum.REPORT);
            if (info.getSheetParam().get(i) != null) {
                for (int m = 0; m < info.getSheetParam().size(); ++m) {
                    if (!info.getSheetParam().get(m).getSheetID().equals(sheet.getID())) continue;
                    pinfo.setId(info.getSheetParam().get(m).getId());
                    info.getSheetParam().set(m, pinfo);
                    break;
                }
            } else {
                info.getSheetParam().add(pinfo);
            }
            BudgetUtilForClient.pickTempaltePostil(info, sheet, _postils, pinfo);
        }
        info.put("postils", (Object)_postils);
    }

    public static ReportVariables sheetParams2Variables(RptSheetParamInfo p) {
        String sheetName = p.getSheetName();
        ReportVariables variables = null;
        variables = VariablesHelper.initTemplateSheetReservedVariables((String)sheetName, (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
        VariableEntry variableEntry = null;
        variableEntry = variables.get("IncludePosted", sheetName);
        variableEntry.setValue(String.valueOf(p.isIsIncludingUnposted()));
        variableEntry.setType(1);
        CSLReportGroupEnum reportClass = p.getReportClass();
        if (reportClass == null) {
            reportClass = CSLReportGroupEnum.COMMON;
        }
        variables.get("SheetClass", sheetName).setValue(String.valueOf(reportClass.getValue()));
        return variables;
    }

    public static void prepareTemplateInfo4Display(BgTemplateInfo info, Book book) {
        BookProperties properties = BookProperties.loadFromBook((Book)book);
        ReportVariables variables = properties.getVariables();
        RptSheetParamCollection sheetParam = info.getSheetParam();
        for (int i = 0; sheetParam != null && i < sheetParam.size(); ++i) {
            RptSheetParamInfo p = sheetParam.get(i);
            ReportVariables sheetV = BudgetUtilForClient.sheetParams2Variables(p);
            sheetV.remove("StartYear", p.getSheetName());
            sheetV.remove("StartPeriod", p.getSheetName());
            sheetV.remove("EndYear", p.getSheetName());
            sheetV.remove("EndPeriod", p.getSheetName());
            variables.remove("StartYear", p.getSheetName());
            variables.remove("StartPeriod", p.getSheetName());
            variables.remove("EndYear", p.getSheetName());
            variables.remove("EndPeriod", p.getSheetName());
            variables.addAll(sheetV, false);
        }
        properties.restoreToBook(book);
        BgTemplatePostilInfo postil = null;
        BgTemplatePostilCollection postils = null;
        Sheet sheet = null;
        Cell cell = null;
        BgTemplateCommentTank ct = null;
        postils = info.getPostils();
        if (postils != null) {
            int i;
            HashSet<String> pCellSet = new HashSet<String>();
            book.setComment(null);
            int in2 = book.getSheetCount();
            for (i = 0; i < in2; ++i) {
                book.getSheet(i).setComment(null);
            }
            for (i = 0; i < postils.size(); ++i) {
                postil = postils.get(i);
                postil.setLastUpdateTime(postil.getCreateTime());
                if (postil.getPostilType() == PostilTypeEnum.REPORT) {
                    ct = (BgTemplateCommentTank)book.getComment();
                    if (ct == null) {
                        ct = new BgTemplateCommentTank();
                        book.setComment((Comment)ct);
                    }
                    try {
                        ct.addEntry(new BgTemplateComment(postil));
                    }
                    catch (Exception in2) {}
                    continue;
                }
                if (postil.getPostilType() == PostilTypeEnum.SHEET) {
                    sheet = book.getSheetByID(postil.getSheet().getSheetID());
                    ct = (BgTemplateCommentTank)sheet.getComment();
                    if (ct == null) {
                        ct = new BgTemplateCommentTank();
                        sheet.setComment((Comment)ct);
                    }
                    try {
                        ct.addEntry(new BgTemplateComment(postil));
                    }
                    catch (Exception in2) {}
                    continue;
                }
                if (postil.getPostilType() != PostilTypeEnum.CELL) continue;
                String _key = postil.getSheet().getSheetID() + "_" + postil.getCellName();
                Rect rect = TableToolkit.range2xy((String)postil.getCellName());
                sheet = book.getSheetByID(postil.getSheet().getSheetID());
                cell = sheet.getCell(rect.y1, rect.x1, true);
                ct = BudgetUtilForClient.getReportComment(cell);
                if (ct == null) {
                    ct = new BgTemplateCommentTank();
                    cell.setComment((Comment)ct);
                } else if (!pCellSet.contains(_key)) {
                    pCellSet.add(_key);
                    int jn = ct.getSize();
                    for (int j = 0; j < jn; ++j) {
                        ct.deletEntry(0);
                    }
                }
                pCellSet.add(_key);
                try {
                    ct.addEntry(new BgTemplateComment(postil));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            pCellSet.clear();
        }
    }

    public static void prepareReportInfo4Display(ReportBaseInfo info, Book book) {
        BookProperties properties = BookProperties.loadFromBook((Book)book);
        ReportVariables variables = properties.getVariables();
        RptSheetParamCollection sheetParam = info.getSheetParam();
        RptPeriodTypeEnum periodType = info.getPeriodType();
        if (periodType == null) {
            periodType = RptPeriodTypeEnum.MONTHLY;
        }
        for (int i = 0; sheetParam != null && i < sheetParam.size(); ++i) {
            RptSheetParamInfo p = sheetParam.get(i);
            if (periodType == null) {
                periodType = RptPeriodTypeEnum.MONTHLY;
            }
            ReportVariables sheetV = VariablesHelper.sheetParams2Variables((RptSheetParamInfo)p, (RptPeriodTypeEnum)periodType);
            sheetV.remove("StartYear", p.getSheetName());
            sheetV.remove("StartPeriod", p.getSheetName());
            sheetV.remove("EndYear", p.getSheetName());
            sheetV.remove("EndPeriod", p.getSheetName());
            variables.remove("StartYear", p.getSheetName());
            variables.remove("StartPeriod", p.getSheetName());
            variables.remove("EndYear", p.getSheetName());
            variables.remove("EndPeriod", p.getSheetName());
            variables.addAll(sheetV, false);
        }
        properties.restoreToBook(book);
        PostilInfo postil = null;
        PostilCollection postils = null;
        Sheet sheet = null;
        Cell cell = null;
        RptCommentTank ct = null;
        postils = info.getPostils();
        if (postils != null) {
            int i;
            HashSet<String> pCellSet = new HashSet<String>();
            book.setComment(null);
            int in2 = book.getSheetCount();
            for (i = 0; i < in2; ++i) {
                book.getSheet(i).setComment(null);
            }
            for (i = 0; i < postils.size(); ++i) {
                postil = postils.get(i);
                postil.setLastUpdateTime(postil.getCreateTime());
                if (postil.getPostilType() == PostilTypeEnum.REPORT) {
                    ct = (RptCommentTank)book.getComment();
                    if (ct == null) {
                        ct = new RptCommentTank();
                        book.setComment((Comment)ct);
                    }
                    try {
                        ct.addEntry(new RptComment(postil));
                    }
                    catch (Exception in2) {}
                    continue;
                }
                if (postil.getPostilType() == PostilTypeEnum.SHEET) {
                    sheet = book.getSheetByID(postil.getSheet().getSheetID());
                    if (sheet == null) continue;
                    ct = (RptCommentTank)sheet.getComment();
                    if (ct == null) {
                        ct = new RptCommentTank();
                        sheet.setComment((Comment)ct);
                    }
                    try {
                        ct.addEntry(new RptComment(postil));
                    }
                    catch (Exception in2) {}
                    continue;
                }
                if (postil.getPostilType() != PostilTypeEnum.CELL) continue;
                String _key = postil.getSheet().getSheetID() + "_" + postil.getCellName();
                Rect rect = TableToolkit.range2xy((String)postil.getCellName());
                sheet = book.getSheetByID(postil.getSheet().getSheetID());
                if (sheet == null) continue;
                cell = sheet.getCell(rect.y1, rect.x1, true);
                ct = CommentUtil.getReportComment((Cell)cell);
                if (ct == null) {
                    ct = new RptCommentTank();
                    cell.setComment((Comment)ct);
                } else if (!pCellSet.contains(_key)) {
                    pCellSet.add(_key);
                    int jn = ct.getSize();
                    for (int j = 0; j < jn; ++j) {
                        ct.deletEntry(0);
                    }
                }
                pCellSet.add(_key);
                try {
                    ct.addEntry(new RptComment(postil));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            pCellSet.clear();
        }
    }

    private static void pickTempaltePostil(BgTemplateInfo info, Sheet sheet, BgTemplatePostilCollection postils, RptSheetParamInfo p) {
        BgTemplatePostilInfo _postilInfo = null;
        Comment _comment = null;
        BgTemplateCommentTank _ct = null;
        _comment = sheet.getComment();
        if (_comment != null) {
            if (_comment instanceof BgTemplateCommentTank) {
                _ct = (BgTemplateCommentTank)_comment;
                int in = _ct.getSize();
                for (int i = 0; i < in; ++i) {
                    _postilInfo = _ct.getEntry(i).getSource();
                    _postilInfo.setPostilType(PostilTypeEnum.SHEET);
                    _postilInfo.setSheet(p);
                    _postilInfo.setTemplate(info);
                    if (StringUtils.isEmpty((String)_postilInfo.getDescription())) {
                        _postilInfo.setDescription(" ");
                    }
                    postils.add(_postilInfo);
                }
            } else {
                _postilInfo = new BgTemplatePostilInfo();
                _postilInfo.setPostilType(PostilTypeEnum.SHEET);
                _postilInfo.setSheet(p);
                _postilInfo.setTemplate(info);
                _postilInfo.setDescription(_comment.getText());
                if (StringUtils.isEmpty((String)_postilInfo.getDescription())) {
                    _postilInfo.setDescription(" ");
                }
                postils.add(_postilInfo);
            }
        }
        Sheet.ICellsIterator it = sheet.getCellsIterator(null, false, true);
        while (it.hasNext()) {
            Cell cell = it.next();
            _ct = BudgetUtilForClient.getReportComment(cell);
            if (_ct == null) continue;
            int in = _ct.getSize();
            for (int i = 0; i < in; ++i) {
                _postilInfo = _ct.getEntry(i).getTrueSource();
                _postilInfo.setPostilType(PostilTypeEnum.CELL);
                _postilInfo.setSheet(p);
                _postilInfo.setCellName(cell.getName(false, false));
                _postilInfo.setTemplate(info);
                if (StringUtils.isEmpty((String)_postilInfo.getDescription())) {
                    _postilInfo.setDescription(" ");
                }
                postils.add(_postilInfo);
                ItemFormula f = (ItemFormula)cell.getUserObjectValue("ITEM");
                if (f == null) continue;
                String num = f.getItemNumber();
                if (num == null || num.trim().length() < 1) {
                    num = f.getDItemNumber();
                }
                _postilInfo.setItemNumber(num);
            }
        }
    }

    public static BgTemplateCommentTank getReportComment(Cell cell) {
        return BudgetUtilForClient.getReportComment(cell, null, true);
    }

    public static BgTemplateCommentTank getReportComment(Cell cell, UserInfo defaultAuthor, boolean convert) {
        if (cell == null) {
            return null;
        }
        Comment comment = cell.getComment();
        if (comment == null) {
            return null;
        }
        BgTemplateCommentTank ct = null;
        if (comment instanceof BgTemplateCommentTank) {
            ct = (BgTemplateCommentTank)comment;
        } else if (convert) {
            ct = BudgetUtilForClient.convertComment(comment, defaultAuthor != null ? defaultAuthor : SysContext.getSysContext().getCurrentUserInfo());
            cell.setComment((Comment)ct);
        }
        return ct;
    }

    public static BgTemplateCommentTank convertComment(Comment c, UserInfo author, Timestamp date) {
        if (c == null) {
            return null;
        }
        if (c instanceof BgTemplateCommentTank) {
            return (BgTemplateCommentTank)c;
        }
        if (c instanceof RptCommentTank) {
            BgTemplateCommentTank ct = new BgTemplateCommentTank();
            try {
                for (int i = 0; i < ((RptCommentTank)c).getSize(); ++i) {
                    BgTemplatePostilInfo postil = new BgTemplatePostilInfo();
                    postil.setCreator(author);
                    postil.setDescription(((RptCommentTank)c).getEntry(i).getContent());
                    postil.setCreateTime(((RptCommentTank)c).getEntry((int)i).date);
                    BgTemplateComment rptComment = new BgTemplateComment(postil);
                    rptComment.setContent(((RptCommentTank)c).getEntry(i).getContent());
                    rptComment.date = ((RptCommentTank)c).getEntry((int)i).date;
                    rptComment.author = author;
                    ct.addEntry(rptComment);
                }
            }
            catch (Exception e) {
                Logger.getLogger(BudgetUtilForClient.class).debug((Object)e.getStackTrace(), (Throwable)e);
            }
            return ct;
        }
        String text = c.getText();
        BgTemplateCommentTank ct = BudgetUtilForClient.createRptCommentTank(author, date, text);
        return ct;
    }

    public static BgTemplateCommentTank createRptCommentTank(UserInfo author, Timestamp date, String text) {
        BgTemplateCommentTank ct = new BgTemplateCommentTank();
        try {
            BgTemplatePostilInfo postil = new BgTemplatePostilInfo();
            postil.setCreator(author);
            postil.setDescription(text);
            postil.setLastUpdateTime(date);
            BgTemplateComment rptComment = new BgTemplateComment(postil);
            rptComment.content = text;
            rptComment.date = date == null ? new Timestamp(Calendar.getInstance().getTimeInMillis()) : date;
            rptComment.author = author;
            ct.addEntry(rptComment);
        }
        catch (Exception e) {
            Logger.getLogger(BudgetUtilForClient.class).debug((Object)e.getStackTrace(), (Throwable)e);
        }
        return ct;
    }

    public static BgTemplateCommentTank convertComment(Comment c, UserInfo author) {
        return BudgetUtilForClient.convertComment(c, author, null);
    }

    private static void pickPostil(ReportBaseInfo info, Sheet sheet, PostilCollection postils, RptSheetParamInfo p) {
        PostilInfo _postilInfo = null;
        Comment _comment = null;
        RptCommentTank _ct = null;
        _comment = sheet.getComment();
        if (_comment != null) {
            if (_comment instanceof RptCommentTank) {
                _ct = (RptCommentTank)_comment;
                int in = _ct.getSize();
                for (int i = 0; i < in; ++i) {
                    _postilInfo = _ct.getEntry(i).getSource();
                    _postilInfo.setPostilType(PostilTypeEnum.SHEET);
                    _postilInfo.setSheet(p);
                    _postilInfo.setReport(info);
                    if (StringUtils.isEmpty((String)_postilInfo.getDescription())) {
                        _postilInfo.setDescription(" ");
                    }
                    postils.add(_postilInfo);
                    p.getPostils().add(_postilInfo);
                }
            } else {
                _postilInfo = new PostilInfo();
                _postilInfo.setPostilType(PostilTypeEnum.SHEET);
                _postilInfo.setSheet(p);
                _postilInfo.setReport(info);
                _postilInfo.setDescription(_comment.getText());
                if (StringUtils.isEmpty((String)_postilInfo.getDescription())) {
                    _postilInfo.setDescription(" ");
                }
                postils.add(_postilInfo);
                p.getPostils().add(_postilInfo);
            }
        }
        Sheet.ICellsIterator it = sheet.getCellsIterator(null, false, true);
        while (it.hasNext()) {
            Cell cell = it.next();
            _ct = CommentUtil.getReportComment((Cell)cell);
            if (_ct == null) continue;
            int in = _ct.getSize();
            for (int i = 0; i < in; ++i) {
                _postilInfo = _ct.getEntry(i).getTrueSource();
                _postilInfo.setPostilType(PostilTypeEnum.CELL);
                _postilInfo.setSheet(p);
                _postilInfo.setCellName(cell.getName(false, false));
                _postilInfo.setReport(info);
                if (StringUtils.isEmpty((String)_postilInfo.getDescription())) {
                    _postilInfo.setDescription(" ");
                }
                postils.add(_postilInfo);
                p.getPostils().add(_postilInfo);
                ItemFormula f = (ItemFormula)cell.getUserObjectValue("ITEM");
                if (f == null) continue;
                String num = f.getItemNumber();
                if (num == null || num.trim().length() < 1) {
                    num = f.getDItemNumber();
                }
                _postilInfo.setItemNumber(num);
            }
        }
    }
}

