/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.budget.AbstractBgPeriodInfo;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgFormCollectFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.NewBgCompareAndAnalysisFilterParam;
import com.kingdee.eas.ma.budget.NewBgCompareAndAnalysisSimpleObjFilterParam;
import com.kingdee.eas.ma.budget.analysiscolumn.listener.CustomerQueryConditionObserver;
import com.kingdee.eas.ma.budget.client.AbstractNewBgCompareAndAnalysisFilterUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgCompareAndAnalysisFormForTitleProcessUI;
import com.kingdee.eas.ma.budget.client.BgCompareAndAnalysisFormProcessUI;
import com.kingdee.eas.ma.budget.client.BgOrgViewF7;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.budget.client.BgTableF7;
import com.kingdee.eas.ma.budget.client.BgTitleColF7;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class NewBgCompareAndAnalysisFilterUI
extends AbstractNewBgCompareAndAnalysisFilterUI {
    private static final long serialVersionUID = 890826879878748001L;
    private static final Logger logger = CoreUIObject.getLogger(NewBgCompareAndAnalysisFilterUI.class);
    protected static final String resourcePath = "com.kingdee.eas.ma.budget.client.BgRptResource";
    private static final String this_orgunit_is_set_by_form = "this.orgunit.is.set.by.form";
    private OrgUnitInfo currCU;
    private CostCenterOrgUnitInfo currCCOrgUnit;
    private NewBgCompareAndAnalysisFilterParam ownFilterParam;
    private boolean hasUseFund = false;
    private KDTEditListener kdUnitEditListener = null;
    private MeasureUnitInfo unitInfo = null;
    static final String FILTER_UI_KEY = NewBgCompareAndAnalysisFilterUI.class.getName();

    public NewBgCompareAndAnalysisFilterUI() throws Exception {
        this.btnUpdateOrg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    NewBgCompareAndAnalysisFilterUI.this.updateOrgArrayByForm();
                }
                catch (Exception e1) {
                    NewBgCompareAndAnalysisFilterUI.this.handUIException(e1);
                }
            }
        });
    }

    private void updateOrgArrayByForm() throws Exception {
        if (this.bgForm.getSelectedItem() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"currentFormIsNul"));
            return;
        }
        Object obj = this.bgForm.getSelectedItem();
        if (obj == null || "".equals(obj.toString())) {
            return;
        }
        BgFormInfo info = (BgFormInfo)obj;
        CostCenterOrgUnitInfo[] org = BgFormCollectFacadeFactory.getRemoteInstance().getsourceOrgArray(info.getId().toString(), true);
        this.getUIContext().put(this_orgunit_is_set_by_form, Boolean.TRUE);
        HashSet<String> setOrgSel = new HashSet<String>();
        int length = org.length;
        for (int i = 0; i < length; ++i) {
            setOrgSel.add(org[i].getId().toString());
        }
        this.reInitOrgUnit(setOrgSel);
        this.prmtOrgUnit.setValue((Object)org);
        this.getUIContext().put(this_orgunit_is_set_by_form, Boolean.FALSE);
    }

    public void setPanelName(String panelName) {
        panelName = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAnalyseLableResource", (String)"AnalysisCondition");
        super.setPanelName(panelName);
    }

    @Override
    public void onLoad() throws Exception {
        this.currCU = SysContext.getSysContext().getCurrentOrgUnit();
        this.currCCOrgUnit = SysContext.getSysContext().getCurrentCostUnit();
        this.currCCOrgUnit = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.currCCOrgUnit.getId()));
        if (BgParamCHelper.isFodian()) {
            this.initCurrency();
            this.hasUseFund = true;
        } else {
            this.hasUseFund = false;
        }
        this.initOrgUnit();
        this.initBgPeriod();
        this.initMeasureUnit();
        this.initComboBox();
        this.unitAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.unitRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnUpdateOrg.setBounds(new Rectangle(266, 58, 25, 21));
        this.btnUpdateOrg.setText("");
        this.btnUpdateOrg.setIcon(EASResource.getIcon((String)"imgTbtn_syncpurview"));
        this.analysisColumnF7.setEditable(false);
        this.titleColumnF7.setEditable(false);
        this.initMyListener();
        try {
            MeasureUnitCollection unitCollection = MeasureUnitFactory.getRemoteInstance().getMeasureUnitCollection("select id,number,name,coefficient where measureUnitGroup.number='BUDGET' and isBaseUnit = 1");
            if (unitCollection != null && unitCollection.size() > 0) {
                this.unitInfo = unitCollection.get(0);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private void initMyListener() {
        this.kdUnitEditListener = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    NewBgCompareAndAnalysisFilterUI.this.tblMain_editStopped(e);
                }
                catch (Exception e1) {
                    NewBgCompareAndAnalysisFilterUI.this.handUIException(e1);
                }
            }
        };
        this.KDUnit.addKDTEditListener(this.kdUnitEditListener);
    }

    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String colName = this.KDUnit.getColumnKey(colIndex);
        if ("BgElement".equals(colName)) {
            KDTRange range = this.KDUnit.getSelectManager().toRange();
            KDTSelectBlock block = (KDTSelectBlock)range.get(0);
            int firstInsertRow = block.getBeginRow();
            Object object = this.KDUnit.getCell(rowIndex, colIndex).getValue();
            if (object instanceof Object[]) {
                int i;
                Object[] result = (Object[])object;
                int size = result.length;
                int maxRow = this.KDUnit.getRowCount();
                int leftRow = maxRow - (firstInsertRow + 1);
                if (size > leftRow) {
                    for (i = leftRow; i < size - 1; ++i) {
                        this.KDUnit.addRow();
                    }
                }
                int length = result.length;
                for (i = 0; i < length; ++i) {
                    BgElementInfo info = (BgElementInfo)result[i];
                    this.KDUnit.getCell(firstInsertRow, "BgElement").setValue((Object)info);
                    if (this.unitInfo != null) {
                        this.KDUnit.getCell(firstInsertRow, "AmountUnit").setValue((Object)this.unitInfo);
                    }
                    ++firstInsertRow;
                }
            }
        }
    }

    public boolean isHasUseFund() {
        return this.hasUseFund;
    }

    private void initComboBox() throws Exception {
        this.bgForm.setLimitedSize(false);
        this.bgForm.setComboPopupWidth(400);
        this.bgScheme.setLimitedSize(true);
    }

    private void initMeasureUnit() throws Exception {
        this.KDUnit.checkParsed();
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        prmtSelect.setQueryInfo("com.kingdee.eas.ma.budget.F7BgElementQuery");
        prmtSelect.setVisible(true);
        prmtSelect.setEditable(false);
        prmtSelect.setEnabledMultiSelection(true);
        prmtSelect.setEditFormat("$number$");
        prmtSelect.setDisplayFormat("$name$");
        this.KDUnit.getColumn("BgElement").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
        KDBizPromptBox prmtSelect2 = null;
        prmtSelect2 = new KDBizPromptBox();
        prmtSelect2.setEditable(false);
        prmtSelect2.setDisplayFormat("$name$");
        prmtSelect2.setEnabledMultiSelection(false);
        prmtSelect2.setQueryInfo("com.kingdee.eas.ma.budget.BgMeasureUnitQuery");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = null;
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
        view.setFilter(filterInfo);
        view.getSorter().add(new SorterItemInfo("coefficient"));
        prmtSelect2.setEntityViewInfo(view);
        this.KDUnit.getColumn("AmountUnit").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect2));
    }

    private void initOrgUnit() throws Exception {
        BgOrgViewF7 orgView = new BgOrgViewF7((IUIObject)this);
        orgView.setCuID(SysContext.getSysContext().getCurrentOrgUnit().toString());
        orgView.setTitle(BgAnalyseHelper.getMessage("orgUnitTitle"));
        orgView.setRootUnitID(this.currCU.getId().toString());
        orgView.setMultiSelect(true);
        orgView.setReturnSuperior(true);
        if (this.ui != null) {
            orgView.setUIActionPK((IMetaDataPK)new MetaDataPK(this.ui.getClass().getName()), (IMetaDataPK)new MetaDataPK("ActionOnLoad"));
        }
        this.prmtOrgUnit.setSelector((KDPromptSelector)orgView);
        this.prmtOrgUnit.setData((Object)this.currCCOrgUnit);
    }

    private void initBgPeriod() throws Exception {
        BgPeriodDialog bgPeriodDialog = null;
        bgPeriodDialog = new BgPeriodDialog((CoreUIObject)this);
        this.prmtBeginPeriod.setSelector((KDPromptSelector)bgPeriodDialog);
        this.prmtEndPeriod.setSelector((KDPromptSelector)bgPeriodDialog);
        this.prmtBeginPeriod.setEditable(false);
        this.prmtEndPeriod.setEditable(false);
    }

    private void initCurrency() throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"BB01"));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        CurrencyCollection cols = CurrencyFactory.getRemoteInstance().getCurrencyCollection(viewInfo);
        if (cols.size() > 0) {
            this.currencyBox.setValue((Object)cols.get(0));
        }
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        if (this.getUIContext().get(this_orgunit_is_set_by_form) != null && this.getUIContext().get(this_orgunit_is_set_by_form) instanceof Boolean && ((Boolean)this.getUIContext().get(this_orgunit_is_set_by_form)).booleanValue()) {
            return;
        }
        Object orgUnitObj = this.prmtOrgUnit.getData();
        this.bgScheme.removeAllItems();
        if (orgUnitObj != null) {
            HashSet<BOSUuid> subOrgUnits = null;
            OrgUnitInfo[] orgUnits = null;
            CostCenterOrgUnitInfo cCOrgUnit = null;
            CostCenterOrgUnitInfo currCCOrgUnitInfo = null;
            if (orgUnitObj instanceof OrgUnitInfo) {
                orgUnits = new OrgUnitInfo[]{(CostCenterOrgUnitInfo)orgUnitObj};
            } else if (orgUnitObj instanceof OrgUnitInfo[]) {
                orgUnits = (OrgUnitInfo[])orgUnitObj;
            } else if (orgUnitObj instanceof Object[]) {
                Object[] obj = (Object[])orgUnitObj;
                orgUnits = new OrgUnitInfo[obj.length];
                for (int index = 0; index < obj.length; ++index) {
                    if (!(obj[index] instanceof CostCenterOrgUnitInfo)) continue;
                    orgUnits[index] = (CostCenterOrgUnitInfo)obj[index];
                }
            }
            subOrgUnits = new HashSet<BOSUuid>();
            if (orgUnits != null) {
                if (orgUnits.length > 1) {
                    currCCOrgUnitInfo = this.getCurrCostCenterOrgUnit();
                    if (!currCCOrgUnitInfo.getId().equals((Object)orgUnits[0].getId())) {
                        currCCOrgUnitInfo = (CostCenterOrgUnitInfo)orgUnits[0];
                    }
                    int n = orgUnits.length;
                    for (int i = 0; i < n; ++i) {
                        cCOrgUnit = (CostCenterOrgUnitInfo)orgUnits[i];
                        if (cCOrgUnit.getId().equals((Object)currCCOrgUnitInfo.getId())) continue;
                        subOrgUnits.add(cCOrgUnit.getId());
                    }
                } else {
                    currCCOrgUnitInfo = (CostCenterOrgUnitInfo)orgUnits[0];
                }
            }
            BgSchemeCollection bgSchemeCol = null;
            try {
                if (currCCOrgUnitInfo != null) {
                    bgSchemeCol = this.getInterface().getCommonBgScheme(currCCOrgUnitInfo.getId(), subOrgUnits, this.isHasUseFund(), false, true);
                }
                if (bgSchemeCol != null && bgSchemeCol.size() == 0) {
                    this.bgForm_itemStateChanged(null);
                    this.bgScheme.addItems(bgSchemeCol.toArray());
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                throw ex;
            }
        }
    }

    @Override
    protected void prmtOrgUnit_willShow(SelectorEvent e) throws Exception {
        super.prmtOrgUnit_willShow(e);
        if (this.prmtOrgUnit.getData() != null) {
            BgOrgViewF7 orgView = (BgOrgViewF7)this.prmtOrgUnit.getSelector();
            OrgUnitInfo unitInfo2 = null;
            OrgUnitInfo[] unitInfos = null;
            Object obj = this.prmtOrgUnit.getData();
            if (obj instanceof OrgUnitInfo) {
                unitInfo2 = (OrgUnitInfo)obj;
                HashSet<String> checked = new HashSet<String>();
                checked.add(unitInfo2.getId().toString());
                orgView.setCheckedOrgIDs(checked);
                orgView.refresh();
            } else if (obj instanceof OrgUnitInfo[]) {
                unitInfos = (OrgUnitInfo[])obj;
                HashSet<String> checked = new HashSet<String>();
                for (OrgUnitInfo unitInfo2 : unitInfos) {
                    checked.add(unitInfo2.getId().toString());
                }
                orgView.setCheckedOrgIDs(checked);
                orgView.refresh();
            } else {
                orgView.setCheckedOrgIDs(null);
            }
        }
    }

    @Override
    protected void prmtEndPeriod_stateChanged(ChangeEvent e) throws Exception {
        Object period;
        Object obj = this.prmtEndPeriod.getValue();
        if (obj == null && this.prmtBeginPeriod.getValue() != null && ((AbstractBgPeriodInfo)(period = (BgPeriodInfo)this.prmtBeginPeriod.getValue())).getPeriodType().getValue() == 8) {
            this.prmtBeginPeriod.setValue(null);
        }
        period = new BgPeriodInfo[2];
        if (obj != null) {
            BgPeriodInfo endPeriod = (BgPeriodInfo)obj;
            int periodType = endPeriod.getPeriodType().getValue();
            if (periodType == 8) {
                this.prmtBeginPeriod.setValue((Object)endPeriod);
            }
            period[0] = (BgPeriodInfo)this.prmtBeginPeriod.getValue();
            period[1] = (BgPeriodInfo)this.prmtEndPeriod.getValue();
            CustomerQueryConditionObserver.getIntance().notifyForUpdate(period);
        } else {
            Object beginPeriodObj = this.prmtBeginPeriod.getValue();
            period[0] = (BgPeriodInfo)this.prmtBeginPeriod.getValue();
            period[1] = (BgPeriodInfo)this.prmtEndPeriod.getValue();
            CustomerQueryConditionObserver.getIntance().notifyForUpdate(period);
        }
    }

    @Override
    protected void prmtBeginPeriod_stateChanged(ChangeEvent e) throws Exception {
        Object period;
        Object obj = this.prmtBeginPeriod.getValue();
        if (obj == null && this.prmtEndPeriod.getValue() != null && ((AbstractBgPeriodInfo)(period = (BgPeriodInfo)this.prmtEndPeriod.getValue())).getPeriodType().getValue() == 8) {
            this.prmtEndPeriod.setValue(null);
        }
        period = new BgPeriodInfo[2];
        if (obj != null) {
            BgPeriodInfo beginPeriod = (BgPeriodInfo)obj;
            int periodType = beginPeriod.getPeriodType().getValue();
            if (periodType == 8) {
                this.prmtEndPeriod.setValue((Object)beginPeriod);
                this.prmtEndPeriod.setEnabled(false);
            } else {
                this.prmtEndPeriod.setEnabled(true);
            }
            period[0] = (BgPeriodInfo)this.prmtBeginPeriod.getValue();
            period[1] = (BgPeriodInfo)this.prmtEndPeriod.getValue();
            CustomerQueryConditionObserver.getIntance().notifyForUpdate(period);
        } else {
            period[0] = (BgPeriodInfo)this.prmtBeginPeriod.getValue();
            period[1] = (BgPeriodInfo)this.prmtEndPeriod.getValue();
            CustomerQueryConditionObserver.getIntance().notifyForUpdate(period);
        }
    }

    public CostCenterOrgUnitInfo getCurrCostCenterOrgUnit() {
        return this.currCCOrgUnit;
    }

    @Override
    protected void bgScheme_actionPerformed(ActionEvent e) throws Exception {
        this.bgForm.removeAllItems();
        if (this.prmtOrgUnit.getData() != null && this.bgScheme.getSelectedItem() != null) {
            HashSet<Object> subOrgUnits = null;
            OrgUnitInfo[] orgUnits = null;
            CostCenterOrgUnitInfo cCOrgUnit = null;
            CostCenterOrgUnitInfo currCCOrgUnitInfo = null;
            Object obj = this.prmtOrgUnit.getData();
            Object schemeObj = this.bgScheme.getSelectedItem();
            if (schemeObj == null || "".equals(schemeObj.toString())) {
                return;
            }
            BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)schemeObj;
            if (obj instanceof OrgUnitInfo) {
                orgUnits = new OrgUnitInfo[]{(CostCenterOrgUnitInfo)obj};
            } else if (obj instanceof OrgUnitInfo[]) {
                orgUnits = (OrgUnitInfo[])obj;
            }
            subOrgUnits = new HashSet<Object>();
            if (orgUnits != null && orgUnits.length > 1) {
                currCCOrgUnitInfo = this.getCurrCostCenterOrgUnit();
                if (!currCCOrgUnitInfo.getId().equals((Object)orgUnits[0].getId())) {
                    currCCOrgUnitInfo = (CostCenterOrgUnitInfo)orgUnits[0];
                }
                int n = orgUnits.length;
                for (int i = 0; i < n; ++i) {
                    cCOrgUnit = (CostCenterOrgUnitInfo)orgUnits[i];
                    subOrgUnits.add(cCOrgUnit.getId());
                }
            }
            if (orgUnits != null && orgUnits.length == 1) {
                subOrgUnits.add(orgUnits[0].getId().toString());
            }
            BgFormCollection bgFormCol = null;
            try {
                bgFormCol = this.getInterface().getCommonBgForm(bgSchemeInfo.getId(), subOrgUnits, this.isHasUseFund(), false, true);
                for (int i = bgFormCol.size() - 1; i >= 0; --i) {
                    if (bgFormCol.get(i).getBgTemplate() == null || !BgTemFormTypeEnum.VIEWFORM.equals((Object)bgFormCol.get(i).getBgTemplate().getFormType())) continue;
                    bgFormCol.removeObject(i);
                }
                if (bgFormCol.size() == 0) {
                    this.bgForm_itemStateChanged(null);
                }
                this.bgForm.addItems(bgFormCol.toArray());
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                throw ex;
            }
        }
    }

    @Override
    protected void bgForm_itemStateChanged(ItemEvent e) throws Exception {
        this.analysisColumnF7.setText("");
        this.titleColumnF7.setText("");
        Object obj = this.bgForm.getSelectedItem();
        if (obj instanceof BgFormInfo) {
            BgTableF7 f7 = new BgTableF7((IUIObject)this, null, (BgFormInfo)obj);
            BgTitleColF7 tilteF7 = new BgTitleColF7((IUIObject)this, (BgFormInfo)obj);
            this.analysisColumnF7.setSelector((KDPromptSelector)f7);
            this.titleColumnF7.setSelector((KDPromptSelector)tilteF7);
        } else {
            BgTableF7 f7 = new BgTableF7((IUIObject)this, null, null);
            BgTitleColF7 tilteF7 = new BgTitleColF7((IUIObject)this, null);
            this.analysisColumnF7.setSelector((KDPromptSelector)f7);
            this.titleColumnF7.setSelector((KDPromptSelector)tilteF7);
        }
    }

    String fillSelectedColNamesToAnalysisComp(Map analysisMap, boolean isSerialize) {
        this.analysisColumnF7.setText("");
        StringBuffer colNamesBuff = new StringBuffer();
        Map map = null;
        if (isSerialize) {
            map = analysisMap;
            if (map != null) {
                BgCompareAndAnalysisFormProcessUI.setAnalysisColIndexMap(map);
            } else {
                BgCompareAndAnalysisFormProcessUI.setAnalysisColIndexMap(new HashMap());
            }
        } else {
            map = BgCompareAndAnalysisFormProcessUI.getAnalysisColIndexMap();
        }
        if (map == null) {
            return "";
        }
        ArrayList keyList = new ArrayList(map.keySet());
        int iNum = keyList.size();
        for (int i = 0; i < iNum; ++i) {
            String key = keyList.get(i).toString();
            List tempList = (List)map.get(key);
            if (tempList.size() == 0) continue;
            String name = key.split("&")[1];
            colNamesBuff.append(name);
            colNamesBuff.append("(");
            int jNum = tempList.size();
            for (int j = 0; j < jNum; ++j) {
                int index = Integer.valueOf(tempList.get(j).toString());
                colNamesBuff.append(TableToolkit.int2pos((int)index));
                if (j == jNum - 1) break;
                colNamesBuff.append(",");
            }
            colNamesBuff.append(")");
            if (i == iNum - 1) break;
            colNamesBuff.append(",");
        }
        return colNamesBuff.toString();
    }

    String fillSelectedColNamesToTitleComp(Map titleMap, boolean isSerialize) {
        this.titleColumnF7.setText("");
        StringBuffer colNamesBuff = new StringBuffer();
        Map map = null;
        if (isSerialize) {
            map = titleMap;
            if (map != null) {
                BgCompareAndAnalysisFormForTitleProcessUI.setTitleColIndexMap(map);
            } else {
                BgCompareAndAnalysisFormForTitleProcessUI.setTitleColIndexMap(new HashMap());
            }
        } else {
            map = BgCompareAndAnalysisFormForTitleProcessUI.getTitleColIndexMap();
        }
        if (map == null) {
            return "";
        }
        ArrayList keyList = new ArrayList(map.keySet());
        int iNum = keyList.size();
        for (int i = 0; i < iNum; ++i) {
            String key = keyList.get(i).toString();
            List tempList = (List)map.get(key);
            String name = key.split("&")[1];
            colNamesBuff.append(name);
            colNamesBuff.append("(");
            int jNum = tempList.size();
            for (int j = 0; j < jNum; ++j) {
                int index = Integer.valueOf(tempList.get(j).toString());
                colNamesBuff.append(TableToolkit.int2pos((int)index));
                if (j == jNum - 1) break;
                colNamesBuff.append(",");
            }
            colNamesBuff.append(")");
            if (i == iNum - 1) break;
            colNamesBuff.append(",");
        }
        return colNamesBuff.toString();
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        String isSum;
        super.setCustomerParams(cp);
        CostCenterOrgUnitInfo[] ccouiAry = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeCostCenterOrgUnit(cp.getCustomerParam("OrgUnitKey"));
        if (ccouiAry != null) {
            this.prmtOrgUnit.setData((Object)ccouiAry);
        }
        try {
            this.prmtOrgUnit_dataChanged(null);
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        String schemeId = cp.getCustomerParam("BgSchemeID");
        int num = this.bgScheme.getItemCount();
        for (int i = 0; i < num; ++i) {
            String tempId = ((BgSchemeInfo)this.bgScheme.getItemAt(i)).getId().toString();
            if (!tempId.equals(schemeId)) continue;
            this.bgScheme.setSelectedIndex(i);
        }
        try {
            this.bgScheme_actionPerformed(null);
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        String bgFormId = cp.getCustomerParam("BgFormID");
        int num2 = this.bgForm.getItemCount();
        for (int i = 0; i < num2; ++i) {
            String tempId = ((BgFormInfo)this.bgForm.getItemAt(i)).getId().toString();
            if (!tempId.equals(bgFormId)) continue;
            this.bgForm.setSelectedIndex(i);
        }
        try {
            this.bgForm_itemStateChanged(null);
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        Map titleMap = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeAnalysisAndTitleColKey(cp.getCustomerParam("BgTitleColKey"));
        this.titleColumnF7.setText(this.fillSelectedColNamesToTitleComp(titleMap, true));
        Map analysisMap = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeAnalysisAndTitleColKey(cp.getCustomerParam("BgAnalysisColKey"));
        this.analysisColumnF7.setText(this.fillSelectedColNamesToAnalysisComp(analysisMap, true));
        this.prmtBeginPeriod.setValue((Object)NewBgCompareAndAnalysisSimpleObjFilterParam.decodeBgPeriodInfo(cp.getCustomerParam("BeginPeriodID")));
        this.prmtEndPeriod.setValue((Object)NewBgCompareAndAnalysisSimpleObjFilterParam.decodeBgPeriodInfo(cp.getCustomerParam("EndPeriodID")));
        try {
            this.prmtBeginPeriod_stateChanged(null);
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        this.currencyBox.setValue((Object)NewBgCompareAndAnalysisSimpleObjFilterParam.decodeCurrencyInfo(cp.getCustomerParam("CurrencyID")));
        Map map = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeMeasureUnit(cp.getCustomerParam("BgMeasureUnitKey"));
        this.KDUnit.removeRows();
        this.KDUnit.checkParsed();
        if (map != null && map.size() > 0) {
            Set set = map.keySet();
            ArrayList list = new ArrayList(set);
            int num3 = list.size();
            for (int i = 0; i < num3; ++i) {
                Object element = list.get(i);
                Object measureUnit = map.get(element);
                IRow row = this.KDUnit.addRow(i);
                row.getCell("AmountUnit").setValue(measureUnit);
                row.getCell("BgElement").setValue(element);
            }
        }
        if ((isSum = cp.getCustomerParam("IsSum")) != null && Boolean.TRUE.toString().equals(isSum.trim())) {
            this.chkIsSum.setSelected(true);
        } else {
            this.chkIsSum.setSelected(false);
        }
        String isDisplayZero = cp.getCustomerParam("IsDisplayZero");
        if (isDisplayZero != null && Boolean.TRUE.toString().equals(isDisplayZero.trim())) {
            this.chkIsDisplayZero.setSelected(true);
        } else {
            this.chkIsDisplayZero.setSelected(false);
        }
        Object beginPeriodObj = this.prmtBeginPeriod.getValue();
        BgPeriodInfo[] period = new BgPeriodInfo[]{(BgPeriodInfo)this.prmtBeginPeriod.getValue(), (BgPeriodInfo)this.prmtEndPeriod.getValue()};
        CustomerQueryConditionObserver.getIntance().clearOldObj();
        CustomerQueryConditionObserver.getIntance().notifyForUpdate(period);
    }

    @Override
    public CustomerParams getCustomerParams() {
        Object endPeriodObj;
        Object bgFormObj;
        CustomerParams cp = super.getCustomerParams();
        this.ownFilterParam = this.getOwnFilterParam();
        Object orgObj = this.prmtOrgUnit.getData();
        if (orgObj != null) {
            if (orgObj instanceof OrgUnitInfo[]) {
                OrgUnitInfo[] array = (OrgUnitInfo[])orgObj;
                int length = array.length;
                CostCenterOrgUnitInfo[] costAry = null;
                if (length > 0) {
                    costAry = new CostCenterOrgUnitInfo[length];
                    System.arraycopy(array, 0, costAry, 0, length);
                }
                this.ownFilterParam.setCostCenterOrgUnitInfoAry(costAry);
            } else if (orgObj instanceof CostCenterOrgUnitInfo) {
                this.ownFilterParam.setCostCenterOrgUnitInfoAry(new CostCenterOrgUnitInfo[]{(CostCenterOrgUnitInfo)orgObj});
            }
            this.setFilterObject(cp, NewBgCompareAndAnalysisSimpleObjFilterParam.getCostCenterUnitIDs(this.ownFilterParam.getCostCenterOrgUnitInfoAry()), "OrgUnitKey");
        }
        if (this.chkIsDisplayZero.isSelected()) {
            this.ownFilterParam.setDisplayZero(true);
        } else {
            this.ownFilterParam.setDisplayZero(false);
        }
        this.setFilterObject(cp, Boolean.valueOf(this.ownFilterParam.isDisplayZero()).toString(), "isDisplayZero");
        Object shemeObj = this.bgScheme.getSelectedItem();
        if (shemeObj != null) {
            BgSchemeInfo info = (BgSchemeInfo)shemeObj;
            this.ownFilterParam.setBgSchemeInfo(info);
            this.setFilterObject(cp, info.getId().toString(), "BgSchemeID");
        }
        if ((bgFormObj = this.bgForm.getSelectedItem()) != null) {
            BgFormInfo info = (BgFormInfo)bgFormObj;
            this.ownFilterParam.setBgFormID(info.getId().toString());
            this.setFilterObject(cp, info.getId().toString(), "BgFormID");
        }
        this.ownFilterParam.setAnalysisColsMap(this.getAnalysisColsMap());
        this.setFilterObject(cp, NewBgCompareAndAnalysisSimpleObjFilterParam.getAnalysisOrTitleColKey(this.getAnalysisColsMap()), "BgAnalysisColKey");
        this.ownFilterParam.setTitleColsMap(this.getTitleColsMap());
        this.setFilterObject(cp, NewBgCompareAndAnalysisSimpleObjFilterParam.getAnalysisOrTitleColKey(this.getTitleColsMap()), "BgTitleColKey");
        Object currencyObj = this.currencyBox.getValue();
        if (currencyObj != null && currencyObj instanceof CurrencyInfo) {
            CurrencyInfo info = (CurrencyInfo)currencyObj;
            this.ownFilterParam.setCurrencyInfo(info);
            this.setFilterObject(cp, info.getId().toString(), "CurrencyID");
        }
        if ((endPeriodObj = this.prmtEndPeriod.getValue()) != null) {
            BgPeriodInfo info = (BgPeriodInfo)endPeriodObj;
            this.ownFilterParam.setEndPeriod(info);
            this.setFilterObject(cp, info.getId().toString(), "EndPeriodID");
        } else {
            this.ownFilterParam.setEndPeriod(null);
            cp.removeCustomerParam("EndPeriodID");
        }
        Object beginPeriodObj = this.prmtBeginPeriod.getValue();
        if (beginPeriodObj != null) {
            BgPeriodInfo info = (BgPeriodInfo)beginPeriodObj;
            this.ownFilterParam.setBeginPeriod(info);
            this.setFilterObject(cp, info.getId().toString(), "BeginPeriodID");
        } else {
            this.ownFilterParam.setEndPeriod(null);
            cp.removeCustomerParam("BeginPeriodID");
        }
        int rowNum = this.KDUnit.getRowCount();
        if (rowNum > 0) {
            HashMap<BgElementInfo, MeasureUnitInfo> map = new HashMap<BgElementInfo, MeasureUnitInfo>();
            for (int i = 0; i < rowNum; ++i) {
                IRow row = this.KDUnit.getRow(i);
                MeasureUnitInfo measureInfo = (MeasureUnitInfo)row.getCell("AmountUnit").getValue();
                BgElementInfo elementInfo = (BgElementInfo)row.getCell("BgElement").getValue();
                map.put(elementInfo, measureInfo);
            }
            this.ownFilterParam.setMeasureUnitInfoMap(map);
            this.setFilterObject(cp, NewBgCompareAndAnalysisSimpleObjFilterParam.getMeasureUnit(map), "BgMeasureUnitKey");
        } else {
            this.ownFilterParam.setMeasureUnitInfoMap(null);
        }
        if (this.chkIsSum.isSelected()) {
            this.ownFilterParam.setShowColRow(true);
        } else {
            this.ownFilterParam.setShowColRow(false);
        }
        this.setFilterObject(cp, Boolean.valueOf(this.ownFilterParam.isShowColRow()).toString(), "IsSum");
        if (this.chkIsDisplayZero.isSelected()) {
            this.ownFilterParam.setDisplayZero(true);
        } else {
            this.ownFilterParam.setDisplayZero(false);
        }
        this.setFilterObject(cp, Boolean.valueOf(this.ownFilterParam.isDisplayZero()).toString(), "IsDisplayZero");
        return cp;
    }

    @Override
    public void setFilterObject(CustomerParams cp, Object param, String key) {
        cp.addCustomerParam(key, param.toString());
    }

    private Map getAnalysisColsMap() {
        if ("".equals(this.analysisColumnF7.getText())) {
            BgCompareAndAnalysisFormProcessUI.setAnalysisColIndexMap(new HashMap());
        }
        return BgCompareAndAnalysisFormProcessUI.getAnalysisColIndexMap();
    }

    private Map getTitleColsMap() {
        if ("".equals(this.titleColumnF7.getText())) {
            BgCompareAndAnalysisFormForTitleProcessUI.setTitleColIndexMap(new HashMap());
        }
        return BgCompareAndAnalysisFormForTitleProcessUI.getTitleColIndexMap();
    }

    @Override
    public void clear() {
        this.prmtOrgUnit.setData((Object)this.currCCOrgUnit);
        this.analysisColumnF7.setData(null);
        this.titleColumnF7.setData(null);
        this.prmtBeginPeriod.setData(null);
        this.prmtEndPeriod.setData(null);
        this.currencyBox.setData(null);
        this.KDUnit.removeRows();
        this.chkIsDisplayZero.setSelected(false);
        this.chkIsSum.setSelected(false);
    }

    private boolean isDuplicateCols() {
        Map titleMap = this.getTitleColsMap();
        Map analysisMap = this.getAnalysisColsMap();
        if (titleMap != null && analysisMap != null) {
            ArrayList aKeyList = new ArrayList(analysisMap.keySet());
            int num = aKeyList.size();
            for (int i = 0; i < num; ++i) {
                Object key = aKeyList.get(i);
                Object tListObj = titleMap.get(key);
                Object aListObj = analysisMap.get(key);
                if (tListObj == null || aListObj == null) continue;
                List tList = (List)tListObj;
                List aList = (List)aListObj;
                int jNum = tList.size();
                for (int j = 0; j < jNum; ++j) {
                    Object val = tList.get(j);
                    if (!aList.contains(val)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean verify() {
        int rowNum;
        if (this.prmtOrgUnit.getValue() == null) {
            this.prmtOrgUnit.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"msgSelectUnit"));
            return false;
        }
        if (this.bgScheme.getSelectedItem() == null) {
            this.bgScheme.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"msgSelectBgScheme"));
            return false;
        }
        if (this.bgForm.getSelectedItem() == null) {
            this.bgForm.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"msgSelectBgForm"));
            return false;
        }
        if ("".equals(this.analysisColumnF7.getText()) || this.analysisColumnF7.getText() == null) {
            this.analysisColumnF7.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"BgFormAnalysisColNotNull"));
            return false;
        }
        String sPeriodStr = this.prmtBeginPeriod.getText();
        String ePeriodStr = this.prmtEndPeriod.getText();
        if ("".equals(sPeriodStr) && !"".equals(ePeriodStr)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"ruleForAnalysisPeriod"));
            return false;
        }
        if (!"".equals(sPeriodStr) && "".equals(ePeriodStr)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"ruleForAnalysisPeriod"));
            return false;
        }
        if (!"".equals(sPeriodStr) && !"".equals(ePeriodStr)) {
            BgClientHelper.verifyBgPeriodBegin2End((CoreUIObject)this, this.prmtBeginPeriod, this.prmtEndPeriod);
        } else if ("".equals(sPeriodStr) && "".equals(ePeriodStr)) {
            this.prmtBeginPeriod.setValue(null);
            this.prmtEndPeriod.setValue(null);
        }
        String currencyTxt = this.currencyBox.getText();
        if ("".equals(currencyTxt)) {
            this.currencyBox.setValue(null);
        }
        if ((rowNum = this.KDUnit.getRowCount()) > 0) {
            int i;
            HashSet<String> verifySet = new HashSet<String>();
            int size = 0;
            for (i = 0; i < rowNum; ++i) {
                IRow row = this.KDUnit.getRow(i);
                Object unitObj = row.getCell("AmountUnit").getValue();
                Object elementObj = row.getCell("BgElement").getValue();
                if (unitObj != null && elementObj != null) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"Make_Whole_MesureUnit"));
                return false;
            }
            for (i = 0; i < rowNum; ++i) {
                ICell elementCell = this.KDUnit.getCell(i, "BgElement");
                String elementNumber = ((BgElementInfo)elementCell.getValue()).getNumber();
                verifySet.add(elementNumber);
                ++size;
            }
            if (verifySet.size() < size) {
                MsgBox.showWarning((String)BgAnalyseHelper.getMessage("elementIsRepeat"));
                return false;
            }
        }
        if (!this.isDuplicateCols()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"ColsUnPermitDupliaction"));
            return false;
        }
        return true;
    }

    @Override
    public String getUITitle() {
        return EASResource.getString((String)resourcePath, (String)"AnalysisFilterUITitle");
    }

    public NewBgCompareAndAnalysisFilterParam getOwnFilterParam() {
        if (this.ownFilterParam == null) {
            this.ownFilterParam = (NewBgCompareAndAnalysisFilterParam)this.createNewFilterParam();
        }
        return this.ownFilterParam;
    }

    public void setOwnFilterParam(NewBgCompareAndAnalysisFilterParam ownFilterParam) {
        this.ownFilterParam = ownFilterParam;
    }

    @Override
    protected void unitAddLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.KDUnit.addRow();
        if (this.unitInfo != null) {
            row.getCell("AmountUnit").setValue((Object)this.unitInfo);
        }
    }

    @Override
    protected void unitRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        int index;
        if (this.KDUnit.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"238_BgFormAnalyseFilterUI"));
            SysUtil.abort();
        }
        if ((index = this.KDUnit.getSelectManager().getActiveRowIndex()) < 0) {
            return;
        }
        this.KDUnit.removeRow(index);
    }

    private void reInitOrgUnit(Set orgSet) throws Exception {
        BgOrgViewF7 orgView = new BgOrgViewF7((IUIObject)this);
        orgView.setTitle(BgAnalyseHelper.getMessage("orgUnitTitle"));
        orgView.setCuID(this.currCU.getId().toString());
        orgView.setMultiSelect(true);
        orgView.setReturnSuperior(true);
        orgView.setCheckedOrgIDs(orgSet);
        if (this.ui != null) {
            orgView.setUIActionPK((IMetaDataPK)new MetaDataPK(this.ui.getClass().getName()), (IMetaDataPK)new MetaDataPK("ActionOnLoad"));
        }
        this.prmtOrgUnit.setSelector((KDPromptSelector)orgView);
        this.prmtOrgUnit.setData((Object)this.currCCOrgUnit);
    }

    @Override
    protected FilterParam createNewFilterParam() {
        return new NewBgCompareAndAnalysisFilterParam();
    }
}

