/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.client.BgAnalyseFormProcessUI;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NewBgItemChooseProcessUI
extends BgAnalyseFormProcessUI {
    private static final long serialVersionUID = -5326134189931562249L;
    private Map itemUserObjectMap = new HashMap();
    public static final String SOURCEITEMINFO = "sourceItemInfo";
    private String sourceItemInfo = null;
    private IBgItem iBgItem = null;
    private IBgElement iBgElement = null;
    private ICurrency iCurrency = null;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.sourceItemInfo = (String)this.getUIContext().get(SOURCEITEMINFO);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.chooseItem();
    }

    @Override
    public void actionSelectItem_actionPerformed(ActionEvent e) throws Exception {
        this.chooseItem();
    }

    private void chooseItem() throws Exception {
        String formulaString = null;
        int num = this.getBook().getSheetCount();
        for (int sheetIndex = 0; sheetIndex < num; ++sheetIndex) {
            Sheet sheet = this.getBook().getSheet(sheetIndex);
            if (sheet == null) continue;
            Range range = sheet.getSelectionRange();
            int maxRow = sheet.getMaxRowIndex();
            int maxCol = sheet.getMaxColIndex();
            for (int i = 0; i < range.size(); ++i) {
                CellBlock block = range.getBlock(i);
                int rowBegin = block.getRow() > maxRow ? maxRow : block.getRow();
                int rowEnd = block.getRow2() > maxRow ? maxRow : block.getRow2();
                int colBegin = block.getCol() > maxCol ? maxCol : block.getCol();
                int colEnd = block.getCol2() > maxCol ? maxCol : block.getCol2();
                for (int j = rowBegin; j <= rowEnd; ++j) {
                    for (int k = colBegin; k <= colEnd; ++k) {
                        Cell cell = sheet.getCell(j, k, true);
                        if (!BgNFSHelper.checkHasItemFormula((Cell)cell) || (formulaString = BgNFSHelper.getFormulaOfCell((Cell)cell)).equalsIgnoreCase(this.sourceItemInfo) || formulaString == null || formulaString.trim().length() <= 0) continue;
                        this.formulaParse(formulaString);
                    }
                }
            }
        }
        if (this.itemUserObjectMap == null || this.itemUserObjectMap.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"350_NewBgItemChooseProcessUI"));
            SysUtil.abort();
        } else if (this.itemUserObjectMap != null || this.itemUserObjectMap.size() > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"submitSuccess"));
        }
        this.destroyWindow();
    }

    private void formulaParse(String formulas) throws EASBizException, BOSException {
        Expression exp;
        ArrayList<String> list = new ArrayList<String>();
        try {
            exp = ExcelFormulaPaserHelper.parse((String)formulas.substring(1));
        }
        catch (Exception e1) {
            return;
        }
        String[] valueString = null;
        List params = null;
        if (exp instanceof FunctionExpr) {
            FunctionExpr foo = (FunctionExpr)exp;
            params = foo.parameters;
            valueString = new String[params.size()];
            for (int i = 0; i < params.size(); ++i) {
                valueString[i] = params.get(i).toString().replaceAll("\"", "");
            }
        } else {
            return;
        }
        String itemcombin = valueString[0].toString();
        String[] item = itemcombin.split(",");
        String sql = "select id,name,number ";
        int length = item.length;
        for (int i = 0; i < length; ++i) {
            sql = i == 0 ? sql + " where number = '" + item[i] + "'" : sql + " or number = '" + item[i] + "'";
        }
        BgItemCollection itemCol = BgItemFactory.getRemoteInstance().getBgItemCollection(sql);
        HashMap<String, String> itemMap = new HashMap<String, String>();
        BgItemInfo info = null;
        int size = itemCol.size();
        for (int j = 0; j < size; ++j) {
            info = itemCol.get(j);
            itemMap.put(info.getNumber(), info.getName());
        }
        String itemName = null;
        int length2 = item.length;
        for (int i = 0; i < length2; ++i) {
            itemName = itemName == null ? (String)itemMap.get(item[i]) : itemName + "," + (String)itemMap.get(item[i]);
        }
        list.add(valueString[0].toString());
        list.add(itemName);
        BgElementInfo emenent = this.iBgElement().getBgElementInfo("select id,name,number where number='" + valueString[2].toString() + "'");
        if (emenent == null) {
            list.add("");
        } else {
            list.add(emenent.getName());
        }
        list.add(valueString[1].toString());
        String currNumb = null;
        currNumb = params.size() > 4 ? valueString[5].toString() : valueString[3].toString();
        CurrencyInfo currency = (CurrencyInfo)this.iCurrency().getValue("select id,name,number where number='" + currNumb + "'");
        list.add(currency.getName());
        this.itemUserObjectMap.put(formulas, list);
    }

    private IBgItem iBgItem() throws BOSException {
        if (this.iBgItem == null) {
            this.iBgItem = BgItemFactory.getRemoteInstance();
        }
        return this.iBgItem;
    }

    private IBgElement iBgElement() throws BOSException {
        if (this.iBgElement == null) {
            this.iBgElement = BgElementFactory.getRemoteInstance();
        }
        return this.iBgElement;
    }

    private ICurrency iCurrency() throws BOSException {
        if (this.iCurrency == null) {
            this.iCurrency = CurrencyFactory.getRemoteInstance();
        }
        return this.iCurrency;
    }

    public Map getItemUserObjectMap() {
        return this.itemUserObjectMap;
    }

    public void setItemUserObjectMap(Map itemUserObjectMap) {
        this.itemUserObjectMap = itemUserObjectMap;
    }
}

