/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemGroupInfo;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.client.BgItemGroupListUI;
import com.kingdee.eas.ma.budget.client.NewBgItemGroupListF7UI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class NewBgItemGroupListF7ForEnum
extends NewBgItemGroupListF7UI {
    private static final long serialVersionUID = -3117585418895489076L;
    private Object result = null;
    private boolean isMultiGroup = false;

    public void setSelectFirstRow(KDTable tb) {
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        Object obj = this.getUIContext().get("isMultiGroup");
        if (obj != null && ((Boolean)obj).booleanValue()) {
            this.isMultiGroup = true;
        } else {
            DefaultTreeSelectionModel sm = new DefaultTreeSelectionModel();
            sm.setSelectionMode(1);
            this.treeMain.setSelectionModel((TreeSelectionModel)sm);
        }
    }

    protected void selectFirstRow() {
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.isMultiGroup) {
            this.getBgItemGroupListF7ForConfig();
        } else {
            this.getBgItemGroupListF7ForEnum();
        }
    }

    protected void getBgItemGroupListF7ForConfig() throws Exception {
        List itemGroupList = this.getSelectedBgItems();
        if (itemGroupList == null || itemGroupList.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgEnumerateResource", (String)"leafGroup"));
            return;
        }
        IBgItem iItem = BgItemFactory.getRemoteInstance();
        KDTRange range = this.tblMain.getSelectManager().toRange();
        Vector<Object> resultVec = new Vector<Object>();
        for (int l = 0; l < itemGroupList.size(); ++l) {
            BgItemGroupInfo itemGroup = (BgItemGroupInfo)itemGroupList.get(l);
            String itemStrs = "";
            BgItemCollection coll = new BgItemCollection();
            if (itemGroup == null || !itemGroup.isIsLeaf()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgEnumerateResource", (String)"leafGroup"));
                return;
            }
            for (int i = 0; i < range.size(); ++i) {
                KDTSelectBlock block = (KDTSelectBlock)range.get(i);
                for (int j = block.getBeginRow(); j <= block.getEndRow(); ++j) {
                    String id = this.tblMain.getRow(j).getCell(this.getKeyFieldName()).getValue().toString();
                    BgItemInfo item = iItem.getBgItemInfo((IObjectPK)new ObjectUuidPK(id));
                    if (!itemGroup.getId().toString().equalsIgnoreCase(item.getBgItemGroup().getId().toString())) continue;
                    itemStrs = itemStrs + item.getNumber() + ",";
                    coll.add(item);
                }
            }
            itemStrs = coll == null || coll.size() == 0 ? itemGroup.getNumber() : itemGroup.getNumber() + ":" + itemStrs.substring(0, itemStrs.length() - 1);
            resultVec.add(itemStrs);
            resultVec.add(itemGroup);
            if (coll == null || coll.size() <= 0) continue;
            resultVec.add((Object)coll);
        }
        this.result = resultVec;
        this.setCancel(false);
        this.getUIWindow().close();
    }

    protected void getBgItemGroupListF7ForEnum() throws Exception {
        BgItemGroupInfo itemGroup = new BgItemGroupInfo();
        itemGroup = this.getSelectedBgItemGroupInfo();
        if (itemGroup == null || !itemGroup.isIsLeaf()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgEnumerateResource", (String)"leafGroup"));
            return;
        }
        IBgItem iItem = BgItemFactory.getRemoteInstance();
        String itemStrs = "";
        KDTRange range = this.tblMain.getSelectManager().toRange();
        BgItemCollection coll = new BgItemCollection();
        for (int i = 0; i < range.size(); ++i) {
            KDTSelectBlock block = (KDTSelectBlock)range.get(i);
            for (int j = block.getBeginRow(); j <= block.getEndRow(); ++j) {
                String id = this.tblMain.getRow(j).getCell(this.getKeyFieldName()).getValue().toString();
                BgItemInfo item = iItem.getBgItemInfo((IObjectPK)new ObjectUuidPK(id));
                if (!itemGroup.getId().toString().equalsIgnoreCase(item.getBgItemGroup().getId().toString())) continue;
                itemStrs = itemStrs + item.getNumber() + ",";
                coll.add(item);
            }
        }
        Vector<Object> result2 = new Vector<Object>();
        itemStrs = coll == null || coll.size() == 0 ? itemGroup.getNumber() : itemGroup.getNumber() + ":" + itemStrs.substring(0, itemStrs.length() - 1);
        result2.add(itemStrs);
        result2.add(itemGroup);
        if (coll != null && coll.size() > 0) {
            result2.add((Object)coll);
        }
        this.result = result2;
        this.setCancel(false);
        this.getUIWindow().close();
    }

    @Override
    public void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int clickCount = e.getClickCount();
        if (e.getColIndex() == 2) {
            if (clickCount == 1) {
                IRow row = this.tblMain.getRow(rowIndex);
                BgItemGroupListUI.NumberExpandInfo expandInfo = (BgItemGroupListUI.NumberExpandInfo)row.getCell("number").getValue();
                if (this.getRender().inRect(expandInfo, e.getX(), e.getY())) {
                    this.setTreeDisplayStyle(row, expandInfo);
                }
                String nexts = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ShowListDataCount_1") + this.tblMain.getRowCount() + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ShowListDataCount_2");
                this.setMessageBarText(nexts);
            } else if (clickCount == 2) {
                // empty if block
            }
        } else if (clickCount == 2) {
            // empty if block
        }
    }

    protected List getSelectedBgItems() {
        ArrayList<BgItemGroupInfo> returnList = new ArrayList<BgItemGroupInfo>();
        KDTreeNode treeNode = null;
        BgItemGroupInfo groupInfo = null;
        TreePath[] treePath = this.treeMain.getSelectionPaths();
        if (treePath != null && treePath.length > 0) {
            for (int i = 0; i < treePath.length; ++i) {
                TreePath tree = treePath[i];
                treeNode = (KDTreeNode)tree.getLastPathComponent();
                if (treeNode == null || !(treeNode.getUserObject() instanceof TreeBaseInfo)) continue;
                groupInfo = (BgItemGroupInfo)treeNode.getUserObject();
                returnList.add(groupInfo);
            }
        }
        return returnList;
    }
}

