/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.AssignSolutionCollection;
import com.kingdee.eas.ma.budget.AssignSolutionFactory;
import com.kingdee.eas.ma.budget.AssignSolutionInfo;
import com.kingdee.eas.ma.budget.AssignSolutionTypeEnum;
import com.kingdee.eas.ma.budget.BgPeriodHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.CalcuFilterParam;
import com.kingdee.eas.ma.budget.ReCalculateFacadeFactory;
import com.kingdee.eas.ma.budget.RecalculateObjInfo;
import com.kingdee.eas.ma.budget.client.AbstractReCalculateFilterUI;
import com.kingdee.eas.ma.budget.client.AssignSolutionInterface;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.budget.client.BgRecalculateReportUI;
import com.kingdee.eas.ma.budget.client.ProgressUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReCalculateFilterUI
extends AbstractReCalculateFilterUI
implements AssignSolutionInterface {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.client.ReCalculateFilterUI");
    private static final long serialVersionUID = -7677030206472649075L;
    private static final String resourcePath = "com.kingdee.eas.ma.budget.client.BgRptResource";
    private CalcuFilterParam filterParam;
    private List allBgFormInfoList;

    public void onLoad() throws Exception {
        super.onLoad();
        String orgUnitID = this.getUIContext().get("ORGUNIT_ID").toString();
        this.initBgScheme(orgUnitID);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnMoveLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnMoveRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveAllLeft.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnMoveAllRight.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
    }

    private void initBgScheme(String orgUnitID) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)orgUnitID));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("period"));
        selector.add(new SelectorItemInfo("dateFrom"));
        selector.add(new SelectorItemInfo("dateTo"));
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        SorterItemCollection sorts = viewInfo.getSorter();
        SorterItemInfo sort = new SorterItemInfo("number");
        sorts.add(sort);
        BgSchemeCollection bgSchemeCol = BgSchemeFactory.getRemoteInstance().getBgSchemeCollection(viewInfo);
        this.comboScheme.addItems(bgSchemeCol.toArray());
        if (this.comboScheme.getItemCount() != 0) {
            this.comboScheme.setSelectedIndex(0);
        }
    }

    @Override
    protected void comboScheme_actionPerformed(ActionEvent e) throws Exception {
        this.allElementList.removeAllElements();
        this.selectedElementList.removeAllElements();
        this.prmtPeriod.setValue(null);
        BgSchemeInfo info = (BgSchemeInfo)this.comboScheme.getSelectedItem();
        if (info == null) {
            return;
        }
        List templateList = ReCalculateFacadeFactory.getRemoteInstance().getTemplateBySchemeID(info.getId().toString());
        BgTemplateInfo tempInfo = null;
        int num = templateList.size();
        for (int i = 0; i < num; ++i) {
            tempInfo = (BgTemplateInfo)templateList.get(i);
            if (BgTemFormTypeEnum.VIEWFORM == tempInfo.getFormType()) continue;
            this.allElementList.addElement((Object)tempInfo);
        }
        BgPeriodDialog beginF7 = new BgPeriodDialog((CoreUIObject)this, true);
        beginF7.setBgPeriodBeginDate(info.getDateFrom());
        beginF7.setBgPeriodEndDate(info.getDateTo());
        this.prmtPeriod.setSelector((KDPromptSelector)beginF7);
        BgPeriodInfo bgPeriodInfo = BgPeriodHelper.getNextPeriodOfDate(info.getPeriod().getValue(), info.getDateFrom(), info.getDateTo(), null);
        if (bgPeriodInfo != null) {
            this.prmtPeriod.setValue((Object)new BgPeriodInfo[]{bgPeriodInfo});
        }
    }

    @Override
    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        int eleCount = this.selectedElementList.getElementCount();
        if (eleCount == 0 || eleCount == 1) {
            return;
        }
        int selectIndex = this.selectedElementList.getSelectedIndex();
        if (selectIndex == -1 || selectIndex == eleCount - 1) {
            return;
        }
        int targetIndex = selectIndex + 1;
        Object targetVal = this.selectedElementList.getElement(targetIndex);
        Object selectVal = this.selectedElementList.getElement(selectIndex);
        this.selectedElementList.setElement(targetVal, selectIndex);
        this.selectedElementList.setElement(selectVal, targetIndex);
        this.selectedElementList.setSelectedIndex(targetIndex);
    }

    @Override
    protected void btnUp_actionPerformed(ActionEvent e) throws Exception {
        int eleCount = this.selectedElementList.getElementCount();
        if (eleCount == 0 || eleCount == 1) {
            return;
        }
        int selectIndex = this.selectedElementList.getSelectedIndex();
        if (selectIndex == -1 || selectIndex == 0) {
            return;
        }
        int targetIndex = selectIndex - 1;
        Object targetVal = this.selectedElementList.getElement(targetIndex);
        Object selectVal = this.selectedElementList.getElement(selectIndex);
        this.selectedElementList.setElement(targetVal, selectIndex);
        this.selectedElementList.setElement(selectVal, targetIndex);
        this.selectedElementList.setSelectedIndex(targetIndex);
    }

    @Override
    protected void btnMoveRight_actionPerformed(ActionEvent e) throws Exception {
        Object[] objAry = this.allElementList.getSelectedValues();
        int length = objAry.length;
        if (length == 0) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            this.allElementList.removeElement(objAry[i]);
            this.selectedElementList.addElement(objAry[i]);
        }
    }

    @Override
    protected void btnMoveLeft_actionPerformed(ActionEvent e) throws Exception {
        Object[] objAry = this.selectedElementList.getSelectedValues();
        int length = objAry.length;
        if (length == 0) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            this.selectedElementList.removeElement(objAry[i]);
            this.allElementList.addElement(objAry[i]);
        }
    }

    @Override
    protected void btnMoveAllLeft_actionPerformed(ActionEvent e) throws Exception {
        int count = this.selectedElementList.getElementCount();
        if (count == 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            Object value = this.selectedElementList.getElement(i);
            this.allElementList.addElement(value);
        }
        this.selectedElementList.removeAllElements();
    }

    @Override
    protected void btnMoveAllRight_actionPerformed(ActionEvent e) throws Exception {
        int count = this.allElementList.getElementCount();
        if (count == 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            Object value = this.allElementList.getElement(i);
            this.selectedElementList.addElement(value);
        }
        this.allElementList.removeAllElements();
    }

    CalcuFilterParam getFilterParam() {
        if (this.filterParam == null) {
            this.filterParam = new CalcuFilterParam();
        }
        return this.filterParam;
    }

    @Override
    public void clear() throws Exception {
        this.prmtCurrency.setValue(null);
        this.prmtPeriod.setValue(null);
        this.allElementList.removeAllElements();
        this.selectedElementList.removeAllElements();
        this.comboScheme.setSelectedItem(null);
    }

    @Override
    public Object saveSolution() throws Exception {
        this.verifyData();
        this.filterParam = this.getFilterParam();
        BgSchemeInfo schemeInfo = (BgSchemeInfo)this.comboScheme.getSelectedItem();
        this.filterParam.setBgSchemeInfo(schemeInfo);
        CurrencyInfo currencyInfo = (CurrencyInfo)this.prmtCurrency.getValue();
        this.filterParam.setCurrencyInfo(currencyInfo);
        Object obj = this.prmtPeriod.getData();
        if (obj != null) {
            if (obj instanceof BgPeriodInfo[]) {
                this.filterParam.setPeriodInfo((BgPeriodInfo[])obj);
            } else if (obj instanceof BgPeriodInfo) {
                this.filterParam.setPeriodInfo(new BgPeriodInfo[]{(BgPeriodInfo)obj});
            } else {
                this.filterParam.setPeriodInfo(null);
            }
        } else {
            this.filterParam.setPeriodInfo(null);
        }
        this.filterParam.setSelectedElementList(this.selectedElementList);
        return this.filterParam;
    }

    @Override
    public void reloadSolution(Object o) throws Exception {
        if (o == null) {
            return;
        }
        this.filterParam = (CalcuFilterParam)o;
        this.comboScheme.setSelectedItem((Object)this.filterParam.getBgSchemeInfo());
        this.prmtCurrency.setValue((Object)this.filterParam.getCurrencyInfo());
        this.prmtPeriod.setValue((Object)this.filterParam.getPeriodInfo());
        KDList list = this.filterParam.getSelectedElementList();
        int num = list.getElementCount();
        for (int i = 0; i < num; ++i) {
            this.selectedElementList.addElement(list.getElement(i));
        }
        int size = this.selectedElementList.getElementCount();
        if (size != 0) {
            for (int i = 0; i < size; ++i) {
                Object obj = this.selectedElementList.getElement(i);
                this.allElementList.removeElement(obj);
            }
        }
    }

    @Override
    public void clearSolutionList() throws Exception {
    }

    @Override
    public AssignSolutionCollection solutionList(AssignSolutionTypeEnum typeEnum) throws Exception {
        StringBuffer oql = new StringBuffer("where solutionType=" + typeEnum.getValue());
        String objId = null;
        String operateType = null;
        Map uicontext = this.getUIContext();
        String uiName = (String)uicontext.get("selfPanelUiName");
        if (uicontext.get("ID") != null) {
            objId = (String)uicontext.get("ID");
        }
        if (uicontext.get("operateType") != null) {
            operateType = (String)uicontext.get("operateType");
        }
        if (typeEnum.getValue() == 0) {
            String cuid = (String)uicontext.get("ORGUNIT_CU");
            if (StringUtils.isEmpty((String)cuid)) {
                cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            }
            oql.append(" and cuid='" + cuid + "'");
        } else if (typeEnum.getValue() == 2) {
            String orgId = (String)uicontext.get("ORGUNIT_ID");
            if (StringUtils.isEmpty((String)orgId)) {
                orgId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            }
            oql.append(" and orgId='" + orgId + "'");
        } else if (typeEnum.getValue() == 1) {
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            oql.append(" and userId='" + userId + "' ");
        }
        if (objId != null) {
            oql.append(" and relativeObjId='" + objId + "' ");
        }
        if (operateType != null) {
            oql.append(" and oprateObjType='" + operateType + "' ");
        }
        if (uiName != null) {
            oql.append(" and uiName='" + uiName + "' ");
        }
        oql.append(" order by isDefaultsolution desc");
        AssignSolutionCollection asSolutionCol = AssignSolutionFactory.getRemoteInstance().getAssignSolutionCollection(oql.toString());
        return asSolutionCol;
    }

    @Override
    public void verifyData() throws Exception {
        if (this.comboScheme.getSelectedItem() == null) {
            this.comboScheme.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"msgSelectBgScheme"));
            SysUtil.abort();
        }
        if (this.selectedElementList.getElementCount() == 0) {
            this.selectedElementList.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"ReSelectBgTemplate"));
            SysUtil.abort();
        }
        if (this.prmtPeriod.getData() == null || !(this.prmtPeriod.getData() instanceof BgPeriodInfo) && !(this.prmtPeriod.getData() instanceof BgPeriodInfo[])) {
            this.prmtPeriod.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"BgPeriondNotNull"));
            SysUtil.abort();
        }
        if (this.prmtCurrency.getValue() == null) {
            this.prmtCurrency.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CurrencyNotNull"));
            SysUtil.abort();
        }
    }

    private void fillDataToCalcuFilterParam() {
        CalcuFilterParam param = this.getFilterParam();
        param.setCurrencyInfo((CurrencyInfo)this.prmtCurrency.getValue());
        param.setBgSchemeInfo((BgSchemeInfo)this.comboScheme.getSelectedItem());
        BgPeriodInfo[] periodInfos = null;
        periodInfos = this.prmtPeriod.getData() instanceof BgPeriodInfo ? new BgPeriodInfo[]{(BgPeriodInfo)this.prmtPeriod.getData()} : (BgPeriodInfo[])this.prmtPeriod.getData();
        param.setPeriodInfo(periodInfos);
        param.setSelectedElementList(this.selectedElementList);
    }

    @Override
    public boolean conferm(Object invokeUi) throws Exception {
        this.verifyData();
        this.fillDataToCalcuFilterParam();
        String schemeID = this.getFilterParam().getBgSchemeInfo().getId().toString();
        BgPeriodInfo[] periodInfoAry = this.getFilterParam().getPeriodInfo();
        String currencyID = this.getFilterParam().getCurrencyInfo().getId().toString();
        KDList list = this.getFilterParam().getSelectedElementList();
        ArrayList<BgTemplateInfo> templateList = new ArrayList<BgTemplateInfo>();
        int num = list.getElementCount();
        for (int i = 0; i < num; ++i) {
            BgTemplateInfo info = (BgTemplateInfo)list.getElement(i);
            templateList.add(info);
        }
        this.allBgFormInfoList = ReCalculateFacadeFactory.getRemoteInstance().getBgForm(currencyID, schemeID, periodInfoAry, templateList);
        if (!this.hasCalculateBgForm(this.allBgFormInfoList)) {
            HashMap<String, Object> ctx = new HashMap<String, Object>();
            ctx.put("Owner", this);
            ctx.put("bgFormList", this.allBgFormInfoList);
            ctx.put("beginTime", new Date(System.currentTimeMillis()).toLocaleString());
            try {
                IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                IUIWindow messageDialog = uiFactory.create(BgRecalculateReportUI.class.getName(), ctx);
                messageDialog.show();
            }
            catch (UIException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
        } else {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    ReCalculateFilterUI.this.createProcessUI(ReCalculateFilterUI.this.allBgFormInfoList);
                }
            };
            thread.start();
        }
        return true;
    }

    private void createProcessUI(List bgFormInfoList) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("Owner", this);
        ctx.put("allBgFormInfoList", bgFormInfoList);
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow messageDialog = uiFactory.create(ProgressUI.class.getName(), ctx);
            messageDialog.show();
            this.createReportUI(((ProgressUI)messageDialog.getUIObject()).getAllBgFormInfoList());
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
    }

    private void createReportUI(List bgFormList) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        Date beginTime = new Date(System.currentTimeMillis());
        ctx.put("Owner", this);
        ctx.put("bgFormList", bgFormList);
        ctx.put("beginTime", beginTime.toLocaleString());
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow messageDialog = uiFactory.create(BgRecalculateReportUI.class.getName(), ctx);
            messageDialog.show();
        }
        catch (UIException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
    }

    @Override
    public boolean cancel() throws Exception {
        return true;
    }

    @Override
    public Map getReturnData() throws Exception {
        return null;
    }

    @Override
    public String getNewConfermLabel() {
        return null;
    }

    @Override
    public AssignSolutionInfo getDefaultSoltuion() throws Exception {
        String objId = null;
        String operateType = null;
        Map uicontext = this.getUIContext();
        if (uicontext.get("ID") != null) {
            objId = (String)uicontext.get("ID");
        }
        if (uicontext.get("operateType") != null) {
            operateType = (String)uicontext.get("operateType");
        }
        StringBuffer oql = new StringBuffer("where issystemsolution =1 ");
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        oql.append(" and userId='" + userId + "' ");
        if (objId != null) {
            oql.append(" and relativeObjId='" + objId + "' ");
        }
        if (operateType != null) {
            oql.append(" and oprateObjType='" + operateType + "' ");
        }
        AssignSolutionInfo assignSolutionInfo = null;
        AssignSolutionCollection assignSolutionCol = AssignSolutionFactory.getRemoteInstance().getAssignSolutionCollection(oql.toString());
        if (assignSolutionCol.size() > 0) {
            assignSolutionInfo = assignSolutionCol.get(0);
        }
        return assignSolutionInfo;
    }

    private boolean hasCalculateBgForm(List allBgFormInfoList) {
        int num = allBgFormInfoList.size();
        for (int i = 0; i < num; ++i) {
            RecalculateObjInfo info = (RecalculateObjInfo)allBgFormInfoList.get(i);
            if (!info.getRecalculateResult().equals("cancel")) continue;
            return true;
        }
        return false;
    }
}

