/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.TextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.control.BgAlarmPersonEntryInfo;
import com.kingdee.eas.ma.control.BgAlarmPersonFactory;
import com.kingdee.eas.ma.control.BgAlarmPersonInfo;
import com.kingdee.eas.ma.control.client.AbstractBgAlarmPersonEditUI;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.MbgUserRoleBaseF7Dialog;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.common.MbgViewListResultData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgAlarmPersonEditUI
extends AbstractBgAlarmPersonEditUI {
    private static final long serialVersionUID = 2458819290208522672L;
    private static final Logger logger = CoreUIObject.getLogger(BgAlarmPersonEditUI.class);
    public static final String RESOURCE = "com.kingdee.eas.ma.control.BgAlarmResource";
    protected static final String COL_BGORGUNIT = "bgOrgUnit";
    protected static final String COL_USER = "users";
    private BgSchemeInfo bgSchemeInfo = null;
    private FullOrgUnitInfo orgUnitInfo = null;
    protected BgSchemeDimensionHelper schemeHelper = null;

    public BgSchemeInfo getBgSchemeInfo() {
        if (this.bgSchemeInfo == null && this.prmtBgScheme.getData() instanceof BgSchemeInfo) {
            this.bgSchemeInfo = (BgSchemeInfo)this.prmtBgScheme.getData();
        }
        return this.bgSchemeInfo;
    }

    public void setBgSchemeInfo(BgSchemeInfo bgSchemeInfo) {
        this.bgSchemeInfo = bgSchemeInfo;
    }

    public FullOrgUnitInfo getOrgUnitInfo() {
        if (this.orgUnitInfo == null && this.prmtOrgUnit.getData() instanceof OrgUnitInfo) {
            this.orgUnitInfo = ((OrgUnitInfo)this.prmtOrgUnit.getData()).castToFullOrgUnitInfo();
        }
        return this.orgUnitInfo;
    }

    public void setOrgUnitInfo(FullOrgUnitInfo orgUnitInfo) {
        this.orgUnitInfo = orgUnitInfo;
    }

    public BgSchemeDimensionHelper getSchemeHelper() {
        if (this.schemeHelper == null && this.getBgSchemeInfo() != null) {
            try {
                this.schemeHelper = new BgSchemeDimensionHelper(this.getBgSchemeInfo().getId().toString());
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
        return this.schemeHelper;
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.beforeOnLoad();
        super.onLoad();
        this.getDetailTable().checkParsed();
        this.getDetailTable().getColumn(COL_USER).setRenderer(new IBasicRender(){

            public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
                if (object != null && object instanceof Object[]) {
                    Object[] objUser = (Object[])object;
                    StringBuffer names = new StringBuffer();
                    for (int i = 0; i < objUser.length; ++i) {
                        UserInfo userInfo = (UserInfo)objUser[i];
                        if (i > 0) {
                            names.append(";");
                        }
                        names.append(userInfo.getName());
                    }
                    TextRender.sharedInstance().draw(graphics, clip, names.toString(), cellStyle);
                }
            }
        });
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.btnAddOneLine.setEnabled(false);
            this.btnCopyOneLine.setEnabled(false);
            this.btnDelSelectLine.setEnabled(false);
        } else {
            this.btnAddOneLine.setEnabled(true);
            this.btnCopyOneLine.setEnabled(true);
            this.btnDelSelectLine.setEnabled(true);
        }
    }

    public void afterShow() {
        this.txtNumber.requestFocus();
    }

    protected void beforeOnLoad() {
        if (this.getUIContext().get(BgBaseConstants.BGSCHEME_INFO) instanceof BgSchemeInfo) {
            this.setBgSchemeInfo((BgSchemeInfo)this.getUIContext().get(BgBaseConstants.BGSCHEME_INFO));
            this.prmtBgScheme.setData((Object)this.getBgSchemeInfo());
        }
        if (this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO) instanceof OrgUnitInfo) {
            this.setOrgUnitInfo(((OrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO)).castToFullOrgUnitInfo());
            this.prmtOrgUnit.setData((Object)this.getOrgUnitInfo());
        }
    }

    protected void loadData() throws Exception {
        super.loadData();
        if (this.editData != null) {
            List members = null;
            MbgViewListResultData data = null;
            if (this.editData.getEntry() != null && !this.editData.getEntry().isEmpty()) {
                int count = this.editData.getEntry().size();
                BgAlarmPersonEntryInfo entryInfo = null;
                IRow row = null;
                String columnKey = null;
                for (int i = 0; i < count; ++i) {
                    Object obj;
                    entryInfo = this.editData.getEntry().get(i);
                    if (entryInfo.getMembers() == null || !((obj = BgAnalyseHelper.getObject((byte[])entryInfo.getMembers())) instanceof Map)) continue;
                    Map membersMap = (Map)obj;
                    row = this.getDetailTable().addRow();
                    this.initRowDialog(row);
                    for (int colIndex = 0; colIndex < this.getDetailTable().getColumnCount(); ++colIndex) {
                        Object[] objUser;
                        columnKey = this.getDetailTable().getColumnKey(colIndex);
                        members = null;
                        if (COL_BGORGUNIT.equals(columnKey) && membersMap.get(DimensionConstants.DEF_ORGUNIT_NUMBER) != null) {
                            members = (List)membersMap.get(DimensionConstants.DEF_ORGUNIT_NUMBER);
                            if (members == null) continue;
                            data = new MbgViewListResultData();
                            data.setMembers(members);
                            row.getCell(colIndex).setValue((Object)data);
                            continue;
                        }
                        if (!COL_USER.equals(columnKey) || membersMap.get(COL_USER) == null || (objUser = (Object[])membersMap.get(COL_USER)) == null) continue;
                        row.getCell(colIndex).setValue((Object)objUser);
                    }
                }
            }
        }
    }

    @Override
    protected void btnDelSelectLine_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        BgCommCHelper.removeRows((KDTable)this.getDetailTable());
    }

    @Override
    protected void btnCopyOneLine_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int index = this.getDetailTable().getSelectManager().getActiveRowIndex();
        IRow sourceRow = this.getDetailTable().getRow(index);
        IRow row = this.getDetailTable().addRow();
        this.initRowDialog(row);
        for (int c = 0; c < this.getDetailTable().getColumnCount(); ++c) {
            row.getCell(c).setValue(sourceRow.getCell(c).getValue());
        }
    }

    public void checkSelected() {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    @Override
    protected void btnAddOneLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.getDetailTable().addRow();
        this.initRowDialog(row);
    }

    protected void initRowDialog(IRow row) throws EASBizException, BOSException {
        if (row == null) {
            return;
        }
        int count = this.getDetailTable().getColumnCount();
        IColumn column = null;
        String columnKey = null;
        for (int colIndex = 0; colIndex < count; ++colIndex) {
            column = this.getDetailTable().getColumn(colIndex);
            columnKey = column.getKey();
            if (StringUtils.isEmpty((String)columnKey)) continue;
            if (COL_BGORGUNIT.equals(columnKey)) {
                KDBizPromptBox memberPrmt = this.getMemberPrmt(DimensionConstants.DEF_ORGUNIT_NUMBER);
                row.getCell(colIndex).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)memberPrmt));
                continue;
            }
            if (!COL_USER.equals(columnKey)) continue;
            MbgUserRoleBaseF7Dialog userDialog = new MbgUserRoleBaseF7Dialog();
            userDialog.setOwner((Component)((Object)this));
            userDialog.setUserUI(true);
            userDialog.setOrgUnit((OrgUnitInfo)SysContext.getSysContext().getCurrentCtrlUnit());
            KDBizPromptBox prmtMember = new KDBizPromptBox();
            prmtMember.setEditable(false);
            prmtMember.setSelector((KDPromptSelector)userDialog);
            prmtMember.setDisplayFormat("$name$");
            row.getCell(colIndex).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtMember));
            prmtMember.addSelectorListener(new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    Object obj = e.getSource();
                    if (obj instanceof KDBizPromptBox && ((KDBizPromptBox)obj).getSelector() instanceof MbgUserRoleBaseF7Dialog) {
                        Object objUser = ((KDBizPromptBox)obj).getData();
                        UserCollection userColls = MbgPermissionHelper.getUserCollectionByObject((Object)objUser);
                        ((MbgUserRoleBaseF7Dialog)((KDBizPromptBox)obj).getSelector()).setSelectedData((IObjectCollection)userColls);
                    }
                }
            });
        }
    }

    protected KDBizPromptBox getMemberPrmt(String dimNumber) throws EASBizException, BOSException {
        DimensionMemberSelectDialog dimDialog = this.getDimensionMemberSelectDialog(dimNumber);
        final KDBizPromptBox prmtDim = new KDBizPromptBox();
        prmtDim.setEditable(false);
        prmtDim.setSelector((KDPromptSelector)dimDialog);
        prmtDim.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent selectorEvent) {
                KDPromptSelector selector = prmtDim.getSelector();
                if (selector instanceof DimensionMemberSelectDialog) {
                    DimensionMemberSelectDialog _selector = (DimensionMemberSelectDialog)selector;
                    _selector.reSetF7UI();
                    Object _obj = prmtDim.getData();
                    if (_obj instanceof MbgViewListResultData) {
                        ((DimensionMemberSelectDialog)selector).setCurSelectFunction((MbgViewListResultData)_obj);
                    }
                }
            }
        });
        return prmtDim;
    }

    protected DimensionMemberSelectDialog getDimensionMemberSelectDialog(String dimNumber) {
        DimensionMemberSelectDialog dialog = new DimensionMemberSelectDialog();
        dialog.setDimension((Object)this.getSchemeHelper().getDimension(dimNumber));
        dialog.setOwner((Component)((Object)this));
        dialog.setMulti(true);
        dialog.setOnlySelectItem(true);
        dialog.setSelectCombinItem(false);
        dialog.setOnlyRefDim(false);
        dialog.setQingAnalyse(false);
        dialog.setCanSelectType(false);
        dialog.setBgSchemeId(this.getBgSchemeInfo().getId().toString());
        if (dimNumber.equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) {
            String orgUnitid = ((OrgUnitInfo)this.prmtOrgUnit.getData()).castToFullOrgUnitInfo().getId().toString();
            dialog.setOrgUnit(((OrgUnitInfo)this.prmtOrgUnit.getData()).castToFullOrgUnitInfo());
            dialog.setOrgId(orgUnitid);
            try {
                BgOrgUnitInfo info = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitInfo("select longNumber where isVirtual =0 and  viewid='" + this.getSchemeHelper().getBgOrgViewId() + "' and orgUnitID='" + orgUnitid + "'");
                if (info != null) {
                    dialog.setOrgRootLongNumber(info.getLongNumber());
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        } else {
            dialog.setOrgUnit(this.getBgSchemeInfo().getOrgUnit());
            dialog.setOrgId(this.getBgSchemeInfo().getOrgUnit().getId().toString());
        }
        dialog.setBgPeriodBeginDate(this.getBgSchemeInfo().getDateFrom());
        dialog.setBgPeriodEndDate(this.getBgSchemeInfo().getDateTo());
        dialog.setFilterRollVersion(true);
        dialog.setShowOuSealup(false);
        return dialog;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.txtNumber.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("numberNotNull"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.txtName.getText())) {
            this.txtName.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("nameNotNull"));
            SysUtil.abort();
        }
        if (this.getDetailTable().getRowCount() > 0) {
            IRow row = null;
            int count = 0;
            for (int i = 0; i < this.getDetailTable().getRowCount(); ++i) {
                row = this.getDetailTable().getRow(i);
                if (row.getCell(COL_BGORGUNIT).getValue() == null && row.getCell(COL_USER).getValue() == null) {
                    ++count;
                    continue;
                }
                if (row.getCell(COL_BGORGUNIT).getValue() != null && row.getCell(COL_USER).getValue() != null) continue;
                MsgBox.showInfo((Component)((Object)this), (String)this.getString("orgAndUserNotNull", new String[]{i + 1 + ""}));
                SysUtil.abort();
            }
            if (count == this.getDetailTable().getRowCount()) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getString("notSetOrgAndUser"));
                SysUtil.abort();
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("notSetOrgAndUser"));
            SysUtil.abort();
        }
    }

    public void verifyData() throws Exception {
        super.verifyData();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        BgNFCHelper.refreshListUI((CoreUI)this);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        BgNFCHelper.refreshListUI((CoreUI)this);
    }

    public IObjectPK runSave() throws Exception {
        this.afterStoreFields();
        return super.runSave();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.afterStoreFields();
    }

    public void afterStoreFields() {
        if (this.editData != null) {
            this.editData.getEntry().clear();
            int rowCount = this.getDetailTable().getRowCount();
            int columnCount = this.getDetailTable().getColumnCount();
            if (rowCount > 0) {
                BgAlarmPersonEntryInfo entryInfo = null;
                HashMap<String, Object> membersMap = null;
                IRow row = null;
                IColumn column = null;
                String columnKey = null;
                MbgViewListResultData data = null;
                int seq = 1;
                for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    row = this.getDetailTable().getRow(rowIndex);
                    membersMap = new HashMap<String, Object>();
                    entryInfo = new BgAlarmPersonEntryInfo();
                    entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
                    for (int colIndex = 0; colIndex < columnCount; ++colIndex) {
                        column = this.getDetailTable().getColumn(colIndex);
                        columnKey = column.getKey();
                        if (row.getCell(colIndex).getValue() instanceof MbgViewListResultData && !((MbgViewListResultData)row.getCell(colIndex).getValue()).getMembers().isEmpty()) {
                            data = (MbgViewListResultData)row.getCell(colIndex).getValue();
                            if (!COL_BGORGUNIT.equals(columnKey)) continue;
                            membersMap.put(DimensionConstants.DEF_ORGUNIT_NUMBER, data.getMembers());
                            continue;
                        }
                        if (!(row.getCell(colIndex).getValue() instanceof Object[]) || ((Object[])row.getCell(colIndex).getValue()).length <= 0 || !COL_USER.equals(columnKey)) continue;
                        Object[] objUser = (Object[])row.getCell(colIndex).getValue();
                        membersMap.put(COL_USER, objUser);
                    }
                    if (membersMap.isEmpty()) continue;
                    entryInfo.setMembers(BgAnalyseHelper.getBytes(membersMap));
                    entryInfo.setBgAlarmPerson(this.editData);
                    entryInfo.setSeq(seq);
                    ++seq;
                    this.editData.getEntry().add(entryInfo);
                }
            }
        }
    }

    public boolean isModify() {
        return super.isModify();
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected IObjectValue createNewData() {
        BgAlarmPersonInfo info = new BgAlarmPersonInfo();
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser(info.getCreator());
        info.setLastUpdateTime(info.getCreateTime());
        if (this.getBgSchemeInfo() != null) {
            info.setBgScheme(this.getBgSchemeInfo());
        }
        if (this.getOrgUnitInfo() != null) {
            info.setOrgUnit(this.getOrgUnitInfo());
        }
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgAlarmPersonFactory.getRemoteInstance();
    }

    protected String getString(String key) {
        return EASResource.getString((String)RESOURCE, (String)key);
    }

    protected String getString(String key, String[] param) {
        return EASResource.getString((String)RESOURCE, (String)key, (Object[])param);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("orgUnit.id");
        sic.add("entry.*");
        return sic;
    }
}

