/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.CompareSignEnum;
import com.kingdee.eas.base.commonquery.LeftBracketSignEnum;
import com.kingdee.eas.base.commonquery.LogicSignEnum;
import com.kingdee.eas.base.commonquery.RightBracketSignEnum;
import com.kingdee.eas.base.commonquery.client.RowObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.client.utils.BgEntityUtil;
import com.kingdee.eas.ma.control.client.AbstractBgBaseConditionUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class BgBaseConditionUI
extends AbstractBgBaseConditionUI {
    protected static final long serialVersionUID = -7539183599987709108L;
    protected static final Logger logger = CoreUIObject.getLogger(BgBaseConditionUI.class);
    protected static final String RIGHT_BRACKET = ")";
    protected static final String LEFT_BRACKET = "(";
    protected static final String COL_LEFTSIGN = "leftBracketSign";
    protected static final String COL_CONDITION = "condition";
    protected static final String COL_COMPARESIGN = "compareSign";
    protected static final String COL_COMPAREVALUE = "compareValue";
    protected static final String COL_RIGHTSIGN = "rightBracketSign";
    protected static final String COL_LOGINSIGN = "loginSign";
    protected static final String[] FILTER_COLUMN_CODEs = new String[]{"leftBracketSign", "condition", "compareSign", "compareValue", "rightBracketSign", "loginSign"};
    protected static final int COL_LEFTSIGN_INDEX = 0;
    protected static final int COL_CONDITION_INDEX = 1;
    protected static final int COL_COMPARESIGN_INDEX = 2;
    protected static final int COL_COMPAREVALUE_INDEX = 3;
    protected static final int COL_RIGHTSIGN_INDEX = 4;
    protected static final int COL_LOGINSIGN_INDEX = 5;
    protected static final String commonEntityFilterRes = "com.kingdee.eas.base.commonquery.client.CommonEntityFilter";
    protected static final String EXTEND_CONDITION_SIGN = "%";
    protected static final String RES_MSG = "com.kingdee.eas.ma.control.client.BgControlResource";

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected void formateColumn() throws BOSException, EASBizException {
        this.formateLeftSign();
        this.formateCondition();
        this.formateCompareSing();
        this.formateCompareValue();
        this.formateRightSing();
        this.formateLoginSing();
    }

    protected void formateLeftSign() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(" ");
        Iterator it = LeftBracketSignEnum.iterator();
        while (it.hasNext()) {
            model.addElement((String)it.next());
        }
        this.mainTable.getColumn(COL_LEFTSIGN).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox(model)));
    }

    protected void formateCondition() throws BOSException, EASBizException {
    }

    protected void formateCompareSing() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        Iterator it = CompareSignEnum.iterator();
        while (it.hasNext()) {
            model.addElement(it.next());
        }
        KDComboBox comboBox = new KDComboBox(model);
        comboBox.removeItem((Object)CompareSignEnum.INCLUDESIGN);
        comboBox.removeItem((Object)CompareSignEnum.NOTINCLUDESIGN);
        comboBox.removeItem((Object)CompareSignEnum.YESTERDAY);
        comboBox.removeItem((Object)CompareSignEnum.TODAY);
        comboBox.removeItem((Object)CompareSignEnum.TOMORROW);
        comboBox.removeItem((Object)CompareSignEnum.LASTWEEK);
        comboBox.removeItem((Object)CompareSignEnum.THISWEEK);
        comboBox.removeItem((Object)CompareSignEnum.NEXTWEEK);
        comboBox.removeItem((Object)CompareSignEnum.LASTMONTH);
        comboBox.removeItem((Object)CompareSignEnum.THISMONTH);
        comboBox.removeItem((Object)CompareSignEnum.NEXTMONTH);
        comboBox.removeItem((Object)CompareSignEnum.BEFORETODAY);
        comboBox.removeItem((Object)CompareSignEnum.AFTERTODAY);
        comboBox.removeItem((Object)CompareSignEnum.FIELDEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLARGE);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLARGEEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLESS);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLESSEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDNOTEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.VAREQUAL);
        comboBox.removeItem((Object)CompareSignEnum.VARNOTEQUAL);
        this.mainTable.getColumn(COL_COMPARESIGN).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comboBox));
    }

    protected void formateCompareValue() {
    }

    protected void formateRightSing() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(" ");
        Iterator it = RightBracketSignEnum.iterator();
        while (it.hasNext()) {
            model.addElement((String)it.next());
        }
        this.mainTable.getColumn(COL_RIGHTSIGN).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox(model)));
    }

    protected void formateLoginSing() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(" ");
        Iterator it = LogicSignEnum.iterator();
        while (it.hasNext()) {
            model.addElement((String)it.next());
        }
        this.mainTable.getColumn(COL_LOGINSIGN).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox(model)));
    }

    @Override
    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        this.mainTable.addRow();
    }

    @Override
    public void actionDelRow_actionPerformed(ActionEvent e) throws Exception {
        KDTRange range = this.mainTable.getSelectManager().toRange();
        if (range.size() == 0) {
            return;
        }
        KDTSelectBlock block = null;
        for (int index = 0; index < range.size(); ++index) {
            block = (KDTSelectBlock)range.get(index);
            for (int r = block.getBeginRow(); r <= block.getEndRow(); ++r) {
                this.mainTable.removeRow(r);
            }
        }
    }

    @Override
    public void actionMoveUpRow_actionPerformed(ActionEvent e) throws Exception {
        boolean flag = false;
        int selectedRowIndex = this.mainTable.getSelectManager().getActiveRowIndex();
        int selectedColIndex = this.mainTable.getSelectManager().getActiveColumnIndex();
        flag = this.mainTable.exchangeRow(selectedRowIndex, selectedRowIndex - 1);
        if (flag) {
            this.mainTable.getSelectManager().select(selectedRowIndex - 1, selectedColIndex);
        }
    }

    @Override
    public void actionMoveDownRow_actionPerformed(ActionEvent e) throws Exception {
        boolean flag = false;
        int selectedRowIndex = this.mainTable.getSelectManager().getActiveRowIndex();
        int selectedColIndex = this.mainTable.getSelectManager().getActiveColumnIndex();
        flag = this.mainTable.exchangeRow(selectedRowIndex, selectedRowIndex + 1);
        if (flag) {
            this.mainTable.getSelectManager().select(selectedRowIndex + 1, selectedColIndex);
        }
    }

    @Override
    public void actionClearRow_actionPerformed(ActionEvent e) throws Exception {
        this.mainTable.removeRows();
    }

    protected boolean isBlankRow(int rowIndex) {
        int columnSize = FILTER_COLUMN_CODEs.length;
        if (this.mainTable.getRow(rowIndex).getCell(1).getValue() == null) {
            return true;
        }
        for (int i = 0; i < columnSize; ++i) {
            if (BgEntityUtil.getValue((Object)this.mainTable.getRow(rowIndex).getCell(i).getValue()).toString().trim().equalsIgnoreCase("")) continue;
            return false;
        }
        return true;
    }

    public void verifyData() throws Exception {
        super.verifyData();
        int rowCount = this.mainTable.getRowCount();
        IColumn column = this.mainTable.getColumn(COL_LOGINSIGN);
        IRow row = null;
        int loginsignCount = 0;
        int leftsignCount = 0;
        int rightsignCount = 0;
        int nullCount = 0;
        HashMap compareMsg = new HashMap();
        String leftTmp = null;
        String rightTmp = null;
        int emptyRowCount = 0;
        for (int i = 0; i < rowCount; ++i) {
            row = this.mainTable.getRow(i);
            if (row.getCell(COL_CONDITION).getValue() == null && row.getCell(COL_COMPARESIGN).getValue() == null && row.getCell(COL_COMPAREVALUE).getValue() == null) {
                ++emptyRowCount;
                continue;
            }
            if (row.getCell(COL_LOGINSIGN).getValue() != null && row.getCell(COL_LOGINSIGN).getValue() instanceof LogicSignEnum && row.getCell(COL_LOGINSIGN).getValue() != null || row.getCell(COL_LOGINSIGN).getValue() instanceof String && !StringUtils.isEmpty((String)row.getCell(COL_LOGINSIGN).getValue().toString())) {
                ++loginsignCount;
            }
            if (row.getCell(COL_LEFTSIGN).getValue() != null && row.getCell(COL_LEFTSIGN).getValue() instanceof String && !StringUtils.isEmpty((String)row.getCell(COL_LEFTSIGN).getValue().toString()) || row.getCell(COL_LEFTSIGN).getValue() instanceof LeftBracketSignEnum && !StringUtils.isEmpty((String)((LeftBracketSignEnum)row.getCell(COL_LEFTSIGN).getValue()).getValue())) {
                leftTmp = ((LeftBracketSignEnum)row.getCell(COL_LEFTSIGN).getValue()).getValue();
                leftsignCount += this.countToWord(leftTmp, LEFT_BRACKET);
            }
            if (row.getCell(COL_RIGHTSIGN).getValue() != null && row.getCell(COL_RIGHTSIGN).getValue() instanceof String && !StringUtils.isEmpty((String)row.getCell(COL_RIGHTSIGN).getValue().toString()) || row.getCell(COL_RIGHTSIGN).getValue() instanceof RightBracketSignEnum && !StringUtils.isEmpty((String)((RightBracketSignEnum)row.getCell(COL_RIGHTSIGN).getValue()).getValue())) {
                rightTmp = ((RightBracketSignEnum)row.getCell(COL_RIGHTSIGN).getValue()).getValue();
                rightsignCount += this.countToWord(rightTmp, RIGHT_BRACKET);
            }
            if (row.getCell(COL_CONDITION).getValue() == null) {
                ++nullCount;
            }
            if (row.getCell(COL_COMPARESIGN).getValue() == null) {
                ++nullCount;
            }
            if (row.getCell(COL_COMPAREVALUE).getValue() != null || CompareSignEnum.NOTNULLSIGN.equals(row.getCell(2).getValue()) || CompareSignEnum.NULLSIGN.equals(row.getCell(2).getValue())) continue;
            ++nullCount;
        }
        if (rowCount > 0) {
            if (rowCount - emptyRowCount - 1 != loginsignCount) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_MSG, (String)"logicSignException"));
                SysUtil.abort();
            }
            if (rightsignCount != leftsignCount) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_MSG, (String)"bracketNotFit"));
                SysUtil.abort();
            }
            if (nullCount != 0 && !CompareSignEnum.NOTNULLSIGN.equals(row.getCell(2).getValue()) && !CompareSignEnum.NULLSIGN.equals(row.getCell(2).getValue())) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_MSG, (String)"filterQuestion"));
                SysUtil.abort();
            }
        }
    }

    protected int countToWord(String str, String key) {
        int count = 0;
        int index = 0;
        while ((index = str.indexOf(key, index)) != -1) {
            index += key.length();
            ++count;
        }
        return count;
    }

    protected List<Map<String, String>> analysisEpress(String express) {
        if (express == null) {
            return new ArrayList<Map<String, String>>();
        }
        ArrayList<String> LogicSet = new ArrayList<String>();
        LogicSet.add("AND");
        LogicSet.add("OR");
        String upperExp = express.toUpperCase();
        ArrayList<String> expressList = new ArrayList<String>();
        expressList.add(upperExp);
        String logic = null;
        List<String> expressItems = null;
        for (int i = 0; i < LogicSet.size(); ++i) {
            logic = (String)LogicSet.get(i);
            if (logic == null) continue;
            expressItems = this.parseExpress(expressList, logic);
        }
        String expressItem = null;
        HashMap<String, String> bracketItemMap = null;
        ArrayList<Map<String, String>> returnList = new ArrayList<Map<String, String>>();
        if (expressItems == null || expressItems.isEmpty()) {
            return returnList;
        }
        for (int i = 0; i < expressItems.size(); ++i) {
            expressItem = expressItems.get(i).trim();
            bracketItemMap = new HashMap<String, String>();
            bracketItemMap.put(RIGHT_BRACKET, String.valueOf(expressItem.charAt(expressItem.length() - 1)));
            bracketItemMap.put(LEFT_BRACKET, String.valueOf(expressItem.charAt(0)));
            returnList.add(bracketItemMap);
        }
        return returnList;
    }

    protected List<String> parseExpress(List<String> expressList, String logic) {
        if (expressList.size() == 0) {
            return null;
        }
        if (StringUtils.isEmpty((String)expressList.get(0))) {
            return null;
        }
        if (StringUtils.isEmpty((String)logic)) {
            return expressList;
        }
        String expressItem = null;
        String[] splitItems = null;
        ArrayList arrayListTmp = null;
        for (int i = 0; i < expressList.size(); ++i) {
            expressItem = expressList.get(i);
            if (expressItem == null || expressItem.indexOf(logic) == -1) continue;
            splitItems = expressItem.split(logic);
            arrayListTmp = new ArrayList(splitItems.length);
            Collections.addAll(arrayListTmp, splitItems);
            expressList.remove(i);
            expressList.addAll(i, arrayListTmp);
            --i;
        }
        return expressList;
    }

    protected boolean isNullSign(String compare) {
        return compare.equalsIgnoreCase("IS") || compare.equalsIgnoreCase("IS NOT");
    }

    protected void loadLeftBracket(int rowIndex, RowObject rowObject) {
        BgEntityUtil.setEnumComboBoxField((KDTable)this.mainTable, (int)rowIndex, (int)0, (String)LeftBracketSignEnum.class.getName(), (String)rowObject.getLeftBracket());
    }

    protected void removeFieldCompare(KDComboBox comboBox) {
        comboBox.removeItem((Object)CompareSignEnum.FIELDEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLARGE);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLARGEEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLESS);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLESSEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDNOTEQUAL);
    }

    protected void loadRightBracket(int rowIndex, RowObject rowObject) {
        BgEntityUtil.setEnumComboBoxField((KDTable)this.mainTable, (int)rowIndex, (int)4, (String)RightBracketSignEnum.class.getName(), (String)rowObject.getRightBracket());
    }

    protected void loadLogicSign(int rowIndex, RowObject rowObject) {
        BgEntityUtil.setEnumComboBoxField((KDTable)this.mainTable, (int)rowIndex, (int)5, (String)LogicSignEnum.class.getName(), (String)rowObject.getLogic());
    }
}

