/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.control.client.AbstractBgControlDetailUI;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.control.utils.BgControlUtils;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class BgControlDetailUI
extends AbstractBgControlDetailUI {
    private static final long serialVersionUID = 1054413543138023883L;
    private static final Logger logger = CoreUIObject.getLogger(BgControlDetailUI.class);
    private String text_threadStack = "";

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadData();
        AbstractAction actionShowThreadStack = new AbstractAction(){
            private static final long serialVersionUID = 2579953743658686110L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BgControlDetailUI.this.actionShowThreadStack_actionPerformed(e);
                }
                catch (Exception ex) {
                    BgControlDetailUI.this.handleException(ex);
                }
            }
        };
        String strKey = "CTRL_SHIFT_F6";
        KeyStroke ks = KeyStroke.getKeyStroke(117, 192, false);
        this.getActionMap().put(strKey, actionShowThreadStack);
        this.getInputMap(2).put(ks, strKey);
    }

    protected void actionShowThreadStack_actionPerformed(ActionEvent e) {
        if (!StringUtils.isEmpty((String)this.text_threadStack)) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)"show thread stack", (String)this.text_threadStack, (int)1);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.getUIWindow() instanceof Dialog) {
            ((Dialog)this.getUIWindow()).setSize(Toolkit.getDefaultToolkit().getScreenSize());
        }
        this.kDSplitPane1.setDividerLocation(800);
    }

    protected void initListener() {
        super.initListener();
        this.tabDetail.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    BgControlDetailUI.this.tabDetail_tableClicked(e);
                }
                catch (Exception exc) {
                    BgControlDetailUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void tabDetail_tableClicked(KDTMouseEvent e) throws Exception {
        int rowIndex;
        if (e.getClickCount() == 2 && (rowIndex = e.getRowIndex()) >= 0) {
            IRow row = this.tabDetail.getRow(rowIndex);
            if (row.getUserObject() instanceof String) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)"show control log", (String)((String)row.getUserObject()), (int)1);
            } else if (row.getUserObject() instanceof BgControlParam) {
                BgControlParam param = (BgControlParam)row.getUserObject();
                MsgBox.showDetailAndOK((Component)((Object)this), (String)"show control log", (String)new JSONObject(BgControlUtils.toMap(param)).toString(), (int)1);
            }
        }
    }

    protected void loadData() throws Exception {
        List params;
        this.tabDetail.checkParsed();
        this.tabDetail.getStyleAttributes().setLocked(true);
        String text_condition = "";
        this.text_threadStack = "";
        Object objs = this.getUIContext().get(BgControlParam.class);
        if (objs instanceof List && (params = (List)objs) != null && !params.isEmpty()) {
            this.tabDetail.setRefresh(false);
            IRow row = null;
            BgControlParam param = null;
            Object _obj = null;
            int in = params.size();
            for (int i = 0; i < in; ++i) {
                _obj = params.get(i);
                if (_obj != null && _obj instanceof BgControlParam) {
                    if (param == null) continue;
                    row = this.tabDetail.addRow();
                    row.getCell("bgScheme").setValue((Object)param.getBgSchemeInfo().getName());
                    row.getCell("reqOrgUnit").setValue((Object)param.getReqOrgUnit().getName());
                    row.getCell("orgUnit").setValue((Object)param.getOrgUnit().getName());
                    row.getCell("dimItem").setValue((Object)(param.getDimItemNumber() + "(" + param.getDimItemName() + ")"));
                    row.getCell("bgPeriod").setValue((Object)param.getBgPeriodName());
                    row.getCell("bgElement").setValue((Object)param.getBgElement().getName());
                    row.getCell("currency").setValue((Object)param.getCurrency().getName());
                    row.getCell("bgScenario").setValue((Object)param.getBgScenario().getName());
                    row.getCell("acScenario").setValue((Object)param.getAcScenario().getName());
                    row.getCell("applyValue").setValue((Object)param.getReqAmount());
                    row.getCell("bgValue").setValue((Object)(param.getExtBudget() != null ? param.getExtBudget() : param.getBudgetValue()));
                    row.getCell("avValue").setValue((Object)(param.getExtActual() != null ? param.getExtActual() : param.getActualValue()));
                    row.setUserObject((Object)param);
                    continue;
                }
                if (!(_obj instanceof String)) continue;
                JSONObject json = new JSONObject((String)_obj);
                if (json.has("condition")) {
                    text_condition = text_condition + json.getString("condition") + "\r\n";
                    continue;
                }
                if (json.has("threadStack")) {
                    this.text_threadStack = this.text_threadStack + json.getString("threadStack") + "\r\n";
                    continue;
                }
                row = this.tabDetail.addRow();
                row.getCell("bgScheme").setValue((Object)json.getString("bgScheme.name"));
                row.getCell("reqOrgUnit").setValue((Object)json.getString("reqOrgUnit.name"));
                row.getCell("orgUnit").setValue((Object)json.getString("orgUnit.name"));
                row.getCell("dimItem").setValue((Object)(json.getString("dimItemNum") + "(" + json.getString("dimItemName") + ")"));
                row.getCell("bgPeriod").setValue((Object)json.getString("bgPeriod.name"));
                row.getCell("bgElement").setValue((Object)json.getString("bgElement.name"));
                row.getCell("currency").setValue((Object)json.getString("currency.name"));
                row.getCell("bgScenario").setValue((Object)json.getString("bgScenario.name"));
                row.getCell("acScenario").setValue((Object)json.getString("acScenario.name"));
                row.getCell("applyValue").setValue((Object)json.getString("reqAmount"));
                row.getCell("bgValue").setValue((Object)(json.getString("extBudget") != null && !json.getString("extBudget").equals("NULL") ? json.getString("extBudget") : json.getString("budgetValue")));
                row.getCell("avValue").setValue((Object)(json.getString("extActual") != null && !json.getString("extActual").equals("NULL") ? json.getString("extActual") : json.getString("actualValue")));
                row.setUserObject(_obj);
            }
            this.tabDetail.setRefresh(true);
        }
        this.textArea.setText(text_condition);
    }
}

