/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.AbstractBaseObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.base.utils.BgLocaleHelper;
import com.kingdee.eas.ma.control.BgControlDataCollection;
import com.kingdee.eas.ma.control.BgControlDataFactory;
import com.kingdee.eas.ma.control.BgControlDataInfo;
import com.kingdee.eas.ma.control.BgControlIsomerInfo;
import com.kingdee.eas.ma.control.BgControlSetFacadeFactory;
import com.kingdee.eas.ma.control.BgCtrlBizType;
import com.kingdee.eas.ma.control.IBgControlData;
import com.kingdee.eas.ma.control.IBgControlSetFacade;
import com.kingdee.eas.ma.control.client.BgControlBillBizSystemUI;
import com.kingdee.eas.ma.control.utils.BgIsomerTreeUtils;
import com.kingdee.eas.ma.control.utils.VirtualIsomerInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class BgControlIsomerBillFieldUI
extends BgControlBillBizSystemUI {
    private static final long serialVersionUID = 1L;
    public static final String RES = "com.kingdee.eas.ma.control.BgControlMsgResource";
    private BgControlDataInfo dataInfo;
    private BgControlIsomerInfo entity;
    private BgIsomerTreeUtils treeUtils = new BgIsomerTreeUtils();
    private DefaultKingdeeTreeNode rootNode;
    private DefaultKingdeeTreeNode orgUnitNode;
    private DefaultKingdeeTreeNode bizItemNode;
    private DefaultKingdeeTreeNode currencyNode;
    private DefaultKingdeeTreeNode bizDateNode;
    private DefaultKingdeeTreeNode budgetNode;
    private DefaultKingdeeTreeNode conditionNode;
    private List<BgControlDataInfo> addList = new ArrayList<BgControlDataInfo>();
    private BgControlDataCollection delColls = new BgControlDataCollection();
    private BgControlDataCollection cantDelColls = new BgControlDataCollection();
    private Set<String> cantDel = new HashSet<String>();

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    protected void init() throws EASBizException, BOSException {
        this.initLeftTree();
        this.initRightTree();
    }

    protected void initLeftTree() throws EASBizException, BOSException {
        if (!(this.getUIContext().get("info") instanceof BgControlDataInfo)) {
            return;
        }
        this.dataInfo = (BgControlDataInfo)this.getUIContext().get("info");
        this.entity = new BgControlIsomerInfo();
        this.entity.setId(BOSUuid.read((String)this.dataInfo.getBizUnit()));
        this.entity.setName(this.dataInfo.getBizUnitAlias());
        DefaultKingdeeTreeNode node = this.treeUtils.createRootTree(this.entity);
        DefaultTreeModel leftModel = new DefaultTreeModel((TreeNode)node);
        if (leftModel != null) {
            this.treeLeft.addTreeWillExpandListener(new TreeWillExpandListener(){

                @Override
                public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)e.getPath().getLastPathComponent();
                    try {
                        BgControlIsomerBillFieldUI.this.treeUtils.addDefaultChildNode(node);
                    }
                    catch (Exception ex) {
                        ExceptionHandler.handle((String)"", (Throwable)ex);
                    }
                }

                @Override
                public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
                }
            });
        }
        this.treeLeft.setModel((TreeModel)leftModel);
        this.treeLeft.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BgControlIsomerBillFieldUI.this.treeLeftClick(e);
            }
        });
    }

    protected void initRightTree() throws EASBizException, BOSException {
        this.rootNode = new DefaultKingdeeTreeNode();
        this.rootNode.setText(this.getResouceText("budgetControlField"));
        this.orgUnitNode = new DefaultKingdeeTreeNode();
        this.orgUnitNode.setText(this.getResouceText("bizOrgunit"));
        this.orgUnitNode.setUserObject((Object)1);
        this.orgUnitNode.setAllowsChildren(true);
        this.rootNode.add((MutableTreeNode)this.orgUnitNode);
        this.bizItemNode = new DefaultKingdeeTreeNode();
        this.bizItemNode.setText(this.getResouceText("bizItem"));
        this.bizItemNode.setUserObject((Object)2);
        this.rootNode.add((MutableTreeNode)this.bizItemNode);
        this.currencyNode = new DefaultKingdeeTreeNode();
        this.currencyNode.setText(this.getResouceText("currency"));
        this.currencyNode.setUserObject((Object)3);
        this.rootNode.add((MutableTreeNode)this.currencyNode);
        this.bizDateNode = new DefaultKingdeeTreeNode();
        this.bizDateNode.setText(this.getResouceText("bizDate"));
        this.bizDateNode.setUserObject((Object)4);
        this.rootNode.add((MutableTreeNode)this.bizDateNode);
        this.budgetNode = new DefaultKingdeeTreeNode();
        this.budgetNode.setText(this.getResouceText("budgetValue"));
        this.budgetNode.setUserObject((Object)5);
        this.rootNode.add((MutableTreeNode)this.budgetNode);
        this.conditionNode = new DefaultKingdeeTreeNode();
        this.conditionNode.setText(this.getResouceText("condition"));
        this.conditionNode.setUserObject((Object)6);
        this.rootNode.add((MutableTreeNode)this.conditionNode);
        this.loadDateToRightTree();
        DefaultTreeModel rightModel = new DefaultTreeModel((TreeNode)this.rootNode);
        this.treeRight.setModel((TreeModel)rightModel);
        this.treeRight.expandAllNodes(true, (TreeNode)this.rootNode);
        this.treeRight.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                BgControlIsomerBillFieldUI.this.treeRightClick(arg0);
            }
        });
    }

    protected void loadDateToRightTree() throws EASBizException, BOSException {
        Object ob = this.getInstance().getBizUnitBill(this.entity.getId().toString());
        if (ob instanceof BgControlDataCollection) {
            BgControlDataInfo info;
            BgControlDataCollection colls = (BgControlDataCollection)((Object)ob);
            for (int index = 0; index < colls.size(); ++index) {
                info = colls.get(index);
                DefaultKingdeeTreeNode pNode = this.getNodeByType(info.getBizType().getValue());
                if (pNode == null) continue;
                DefaultKingdeeTreeNode cNode = new DefaultKingdeeTreeNode();
                cNode.setUserObject((Object)info);
                cNode.setText(info.getBizAlias());
                pNode.add((MutableTreeNode)cNode);
            }
            Object obbb = this.getInstance().getCantDeleteColls((Object)colls);
            if (obbb instanceof BgControlDataCollection) {
                this.cantDelColls = (BgControlDataCollection)((Object)obbb);
                for (int index = 0; index < this.cantDelColls.size(); ++index) {
                    info = this.cantDelColls.get(index);
                    this.cantDel.add(info.getBiz());
                }
            }
        }
    }

    protected DefaultKingdeeTreeNode getNodeByType(int type) {
        switch (type) {
            case 1: {
                return this.orgUnitNode;
            }
            case 2: {
                return this.bizItemNode;
            }
            case 3: {
                return this.currencyNode;
            }
            case 4: {
                return this.bizDateNode;
            }
            case 5: {
                return this.budgetNode;
            }
            case 6: {
                return this.conditionNode;
            }
        }
        return null;
    }

    @Override
    protected void treeLeftClick(MouseEvent e) {
        if (e.getClickCount() < 2) {
            return;
        }
        this.addNodeToRight();
    }

    @Override
    protected void treeRightClick(MouseEvent e) {
        if (e.getClickCount() < 2) {
            return;
        }
        this.delNodeToRight();
    }

    protected void addNodeToRight() {
        DefaultKingdeeTreeNode lNode;
        TreePath rPath = this.treeRight.getSelectionPath();
        if (rPath == null || !(rPath.getLastPathComponent() instanceof DefaultKingdeeTreeNode)) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getResouceText("selectNode"));
            return;
        }
        Object ob = ((DefaultKingdeeTreeNode)rPath.getLastPathComponent()).getUserObject();
        if (!(ob instanceof Integer)) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getResouceText("selectNode"));
            return;
        }
        DefaultKingdeeTreeNode rNode = (DefaultKingdeeTreeNode)rPath.getLastPathComponent();
        TreePath lPath = this.treeLeft.getSelectionPath();
        if (lPath != null && lPath.getLastPathComponent() instanceof DefaultKingdeeTreeNode && (lNode = (DefaultKingdeeTreeNode)lPath.getLastPathComponent()).getUserObject() instanceof VirtualIsomerInfo) {
            VirtualIsomerInfo info = (VirtualIsomerInfo)((Object)lNode.getUserObject());
            if (StringUtils.isEmpty((String)info.getTableField())) {
                return;
            }
            if (this.isExist(rNode, info)) {
                return;
            }
            if (!this.isCanAdd(rNode, info)) {
                return;
            }
            MultiLangMetaInfo metaInfo = new MultiLangMetaInfo(info);
            DefaultKingdeeTreeNode cNode = new DefaultKingdeeTreeNode((Object)metaInfo);
            metaInfo.setAlias(this.getNodeName(lPath, LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            metaInfo.setAlias(this.getNodeName(lPath, LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            metaInfo.setAlias(this.getNodeName(lPath, LocaleUtils.locale_l3), LocaleUtils.locale_l3);
            cNode.setText(metaInfo.getAlias());
            rNode.add((MutableTreeNode)cNode);
            DefaultKingdeeTreeNode rootNode = (DefaultKingdeeTreeNode)this.treeRight.getModel().getRoot();
            ((DefaultTreeModel)this.treeRight.getModel()).setRoot((TreeNode)rootNode);
            this.treeRight.expandAllNodes(true, (TreeNode)rootNode);
            this.treeRight.setSelectionPath(rPath);
        }
    }

    private boolean isCanAdd(DefaultKingdeeTreeNode node, VirtualIsomerInfo info) {
        if (node.getUserObject() instanceof Integer) {
            int type = (Integer)node.getUserObject();
            String dataType = info.getDataType();
            if (dataType != null) {
                dataType = dataType.toUpperCase();
                if (4 == type) {
                    if (!(dataType.contains(DataType.DATE.getName().toUpperCase()) || dataType.contains(DataType.TIME.getName().toUpperCase()) || dataType.contains(DataType.TIMESTAMP.getName().toUpperCase()))) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"dateTypeError"));
                        return false;
                    }
                } else if (5 == type) {
                    if (!(dataType.contains("DECIMAL") || dataType.contains("NUMBER") || dataType.contains("INT") || dataType.contains("FLOAT") || dataType.contains("DOUBLE"))) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"bigdecimalError"));
                        return false;
                    }
                } else if ((1 == type || 2 == type || 3 == type) && (dataType.contains(DataType.DATE.getName().toUpperCase()) || dataType.contains(DataType.TIME.getName().toUpperCase()) || dataType.contains(DataType.TIMESTAMP.getName().toUpperCase()) || dataType.contains("DECIMAL"))) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"nodePropError"));
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isExist(DefaultKingdeeTreeNode node, VirtualIsomerInfo info) {
        if (node == null || info == null) {
            return false;
        }
        Enumeration ch = node.children();
        while (ch.hasMoreElements()) {
            Object ob = ((DefaultKingdeeTreeNode)ch.nextElement()).getUserObject();
            if (!(ob instanceof VirtualIsomerInfo ? ((VirtualIsomerInfo)((Object)ob)).getName().equals(info.getName()) : ob instanceof BgControlDataInfo && ((BgControlDataInfo)ob).getBiz().equals(info.getName()))) continue;
            return true;
        }
        return false;
    }

    protected String getNodeName(TreePath path, Locale locale) {
        ArrayList<String> names = new ArrayList<String>();
        this.getDisplayName(path, names, locale);
        if (names.isEmpty()) {
            return null;
        }
        StringBuffer name = new StringBuffer();
        for (int index = names.size() - 1; index >= 0; --index) {
            name.append((String)names.get(index));
            if (index == 0) continue;
            name.append(".");
        }
        return name.toString();
    }

    private void getDisplayName(TreePath path, List<String> name, Locale locale) {
        if (path == null || name == null) {
            return;
        }
        if (path.getLastPathComponent() instanceof DefaultKingdeeTreeNode) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            if (node.getUserObject() instanceof VirtualIsomerInfo) {
                name.add(node.getText());
            } else {
                name.add(node.getText());
            }
            if (path.getParentPath() != null && path.getParentPath().getParentPath() != null) {
                this.getDisplayName(path.getParentPath(), name, locale);
            }
        }
    }

    protected void delNodeToRight() {
        TreePath rPath = this.treeRight.getSelectionPath();
        if (rPath == null) {
            return;
        }
        if (rPath.getLastPathComponent() instanceof DefaultKingdeeTreeNode) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)rPath.getLastPathComponent();
            Object ob = node.getUserObject();
            if (ob instanceof Integer) {
                return;
            }
            if (ob instanceof BgControlDataInfo) {
                BgControlDataInfo dataInfo = (BgControlDataInfo)ob;
                if (this.cantDel.contains(dataInfo.getBiz())) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"fieldCantDel", (Object[])new String[]{dataInfo.getBizType().getAlias(), dataInfo.getBizAlias()}));
                    return;
                }
                this.delColls.add((BgControlDataInfo)ob);
            }
            node.removeFromParent();
            DefaultKingdeeTreeNode rootNode = (DefaultKingdeeTreeNode)this.treeRight.getModel().getRoot();
            ((DefaultTreeModel)this.treeRight.getModel()).setRoot((TreeNode)rootNode);
            this.treeRight.expandAllNodes(true, (TreeNode)rootNode);
        }
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        this.addNodeToRight();
    }

    @Override
    protected void btnRemove_actionPerformed(ActionEvent e) throws Exception {
        this.delNodeToRight();
    }

    protected String getResouceText(String resName) {
        return EASResource.getString((String)RES, (String)resName);
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        BgControlDataCollection c;
        Object ob;
        IBgControlData iData = BgControlDataFactory.getRemoteInstance();
        if (!this.delColls.isEmpty() && (ob = BgControlSetFacadeFactory.getRemoteInstance().deleteBatch((Object)this.delColls)) instanceof BgControlDataCollection && !(c = (BgControlDataCollection)((Object)ob)).isEmpty()) {
            StringBuffer msg = new StringBuffer();
            for (int index = 0; index < c.size(); ++index) {
                msg.append(EASResource.getString((String)RES, (String)"fieldCantDel", (Object[])new String[]{c.get(index).getBizType().getAlias(), c.get(index).getBizAlias()})).append("\n");
            }
            Object[] p = new Object[]{this.delColls.size(), c.size()};
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"deleteFiledFail", (Object[])p), (String)msg.toString(), (int)0);
        }
        BgControlDataCollection colls = new BgControlDataCollection();
        this.storeData(colls, this.orgUnitNode);
        this.storeData(colls, this.bizItemNode);
        this.storeData(colls, this.currencyNode);
        this.storeData(colls, this.bizDateNode);
        this.storeData(colls, this.budgetNode);
        this.storeData(colls, this.conditionNode);
        if (!colls.isEmpty()) {
            CoreBaseCollection saveColls = new CoreBaseCollection();
            saveColls.addObjectCollection((IObjectCollection)colls);
            iData.addnewBatchData(saveColls);
        }
        this.setCancel(false);
        this.getUIWindow().close();
    }

    private void storeData(BgControlDataCollection colls, DefaultKingdeeTreeNode currentnode) {
        if (currentnode == null || colls == null) {
            return;
        }
        int type = 0;
        if (!(currentnode.getUserObject() instanceof Integer)) {
            return;
        }
        type = (Integer)currentnode.getUserObject();
        Enumeration ch = currentnode.children();
        BgControlDataInfo dInfo = null;
        MultiLangMetaInfo mInfo = null;
        while (ch.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)ch.nextElement();
            if (!(node.getUserObject() instanceof MultiLangMetaInfo)) continue;
            mInfo = (MultiLangMetaInfo)((Object)node.getUserObject());
            VirtualIsomerInfo info = mInfo.info;
            dInfo = new BgControlDataInfo();
            dInfo.setBizType(BgCtrlBizType.getEnum(type));
            dInfo.setBizSystem(this.dataInfo.getBizSystem());
            BgLocaleHelper.copyMultiLangField((IObjectValue)dInfo, (IObjectValue)this.dataInfo, (String)"bizSystemAlias", (String)"bizSystemAlias");
            dInfo.setBizUnit(this.dataInfo.getBizUnit());
            BgLocaleHelper.copyMultiLangField((IObjectValue)dInfo, (IObjectValue)this.dataInfo, (String)"bizUnitAlias", (String)"bizUnitAlias");
            dInfo.setBiz(info.getName());
            BgLocaleHelper.copyMultiLangField((IObjectValue)dInfo, (IObjectValue)mInfo, (String)"alias", (String)"bizAlias");
            dInfo.setIsDefault(false);
            dInfo.setIsSystemDefault(false);
            dInfo.setIsomer(true);
            colls.add(dInfo);
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setCancel(true);
        this.getUIWindow().close();
    }

    protected IBgControlSetFacade getInstance() throws BOSException {
        return BgControlSetFacadeFactory.getRemoteInstance();
    }

    public BgControlIsomerInfo getEntity() {
        return this.entity;
    }

    public void setEntity(BgControlIsomerInfo entity) {
        this.entity = entity;
    }

    public DefaultKingdeeTreeNode getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(DefaultKingdeeTreeNode rootNode) {
        this.rootNode = rootNode;
    }

    public DefaultKingdeeTreeNode getOrgUnitNode() {
        return this.orgUnitNode;
    }

    public void setOrgUnitNode(DefaultKingdeeTreeNode orgUnitNode) {
        this.orgUnitNode = orgUnitNode;
    }

    public DefaultKingdeeTreeNode getBizItemNode() {
        return this.bizItemNode;
    }

    public void setBizItemNode(DefaultKingdeeTreeNode bizItemNode) {
        this.bizItemNode = bizItemNode;
    }

    public DefaultKingdeeTreeNode getCurrencyNode() {
        return this.currencyNode;
    }

    public void setCurrencyNode(DefaultKingdeeTreeNode currencyNode) {
        this.currencyNode = currencyNode;
    }

    public DefaultKingdeeTreeNode getBizDateNode() {
        return this.bizDateNode;
    }

    public void setBizDateNode(DefaultKingdeeTreeNode bizDateNode) {
        this.bizDateNode = bizDateNode;
    }

    public DefaultKingdeeTreeNode getBudgetNode() {
        return this.budgetNode;
    }

    public void setBudgetNode(DefaultKingdeeTreeNode budgetNode) {
        this.budgetNode = budgetNode;
    }

    public DefaultKingdeeTreeNode getConditionNode() {
        return this.conditionNode;
    }

    public void setConditionNode(DefaultKingdeeTreeNode conditionNode) {
        this.conditionNode = conditionNode;
    }

    public BgControlDataInfo getDataInfo() {
        return this.dataInfo;
    }

    public void setDataInfo(BgControlDataInfo dataInfo) {
        this.dataInfo = dataInfo;
    }

    public List getAddList() {
        return this.addList;
    }

    public void setAddList(List addList) {
        this.addList = addList;
    }

    public BgControlDataCollection getDelColls() {
        return this.delColls;
    }

    public void setDelColls(BgControlDataCollection delColls) {
        this.delColls = delColls;
    }

    private static class MultiLangMetaInfo
    extends AbstractBaseObjectValue {
        private VirtualIsomerInfo info = null;

        public MultiLangMetaInfo(VirtualIsomerInfo info) {
            this.info = info;
        }

        public String getAlias() {
            return this.getAlias(null);
        }

        public void setAlias(String alias) {
            this.setAlias(alias, null);
        }

        public String getAlias(Locale locale) {
            return (String)this.get("alias", locale);
        }

        public void setAlias(String alias, Locale locale) {
            this.put("alias", alias, locale);
        }

        public BOSObjectType getBOSType() {
            return null;
        }
    }
}

