/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.control.BgControlIsomerCollection;
import com.kingdee.eas.ma.control.BgControlIsomerConnectionCollection;
import com.kingdee.eas.ma.control.BgControlIsomerConnectionFactory;
import com.kingdee.eas.ma.control.BgControlIsomerConnectionInfo;
import com.kingdee.eas.ma.control.BgControlIsomerFactory;
import com.kingdee.eas.ma.control.BgControlIsomerInfo;
import com.kingdee.eas.ma.control.client.AbstractBgControlIsomerBillUI;
import com.kingdee.eas.ma.control.client.BgControlIsomerConnectDialog;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class BgControlIsomerBillUI
extends AbstractBgControlIsomerBillUI {
    private static final long serialVersionUID = -7914953066784251085L;
    private static final Logger logger = CoreUIObject.getLogger(BgControlIsomerBillUI.class);
    private boolean isCancel = true;
    private List<BgControlIsomerInfo> data;

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public List<BgControlIsomerInfo> getData() {
        return this.data;
    }

    public void setData(List<BgControlIsomerInfo> data) {
        this.data = data;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.leftTable.checkParsed();
        this.rightTable.checkParsed();
        this.init();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
    }

    protected void init() throws EASBizException, BOSException {
        this.initConnectF7();
        this.initLeftTable();
        this.initRightTable();
    }

    private void initLeftTable() throws EASBizException, BOSException {
        this.refreshLeftTable(this.getConnectInfo());
    }

    private void refreshLeftTable(BgControlIsomerConnectionInfo connectInfo) throws EASBizException, BOSException {
        if (connectInfo == null) {
            return;
        }
        BgControlIsomerCollection coll = BgControlIsomerFactory.getRemoteInstance().getBgControlIsomerCollection("Select name,number,id  where connection.id='" + connectInfo.getId() + "'");
        IRow row = null;
        this.leftTable.removeRows();
        for (int i = 0; i < coll.size(); ++i) {
            row = this.leftTable.addRow();
            row.getCell(0).setValue((Object)coll.get(i).getNumber());
            row.getCell(1).setValue((Object)coll.get(i).getName());
            row.getCell(2).setValue((Object)coll.get(i).getId());
        }
    }

    private void initRightTable() {
    }

    private BgControlIsomerConnectionInfo getConnectInfo() {
        if (this.prmtConnect.getData() != null) {
            return (BgControlIsomerConnectionInfo)this.prmtConnect.getData();
        }
        return null;
    }

    private void initConnectF7() throws EASBizException, BOSException {
        BgControlIsomerConnectionCollection coll = BgControlIsomerConnectionFactory.getRemoteInstance().getBgControlIsomerConnectionCollection();
        BgControlIsomerConnectDialog dialog = new BgControlIsomerConnectDialog();
        dialog.setUiOwner((IUIObject)this);
        this.prmtConnect.setSelector((KDPromptSelector)dialog);
        this.prmtConnect.setEditable(false);
        if (coll != null && !coll.isEmpty()) {
            this.prmtConnect.setData((Object)coll.get(0));
        }
        dialog.setOldData(this.prmtConnect.getData());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void prmtConnect_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtConnect_dataChanged(e);
        if (!(e.getNewValue() == null || e.getOldValue() != null && e.getOldValue().equals(e.getNewValue()))) {
            this.refreshLeftTable((BgControlIsomerConnectionInfo)e.getNewValue());
        }
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        super.btnAdd_actionPerformed(e);
        this.addRows();
    }

    @Override
    protected void btnRemove_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemove_actionPerformed(e);
        List rows = BgCommCHelper.getSelectRowIndexes((KDTable)this.rightTable);
        this.remove(rows);
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        if (this.rightTable.getRowCount() == 0) {
            this.btnCancel_actionPerformed(e);
            return;
        }
        this.data = new ArrayList<BgControlIsomerInfo>();
        this.setData();
        this.setCancel(false);
        this.getUIWindow().close();
    }

    private void setData() {
        BgControlIsomerInfo info = null;
        for (int i = 0; i < this.rightTable.getRowCount(); ++i) {
            info = new BgControlIsomerInfo();
            info.setNumber(this.rightTable.getRow(i).getCell(0).getValue().toString());
            info.setName(this.rightTable.getRow(i).getCell(1).getValue().toString());
            info.setId(BOSUuid.read((String)this.rightTable.getRow(i).getCell(2).getValue().toString()));
            info.setConnection(this.getConnectInfo());
            this.data.add(info);
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setCancel(true);
        this.getUIWindow().close();
    }

    @Override
    protected void leftTable_tableClicked(KDTMouseEvent e) throws Exception {
        super.leftTable_tableClicked(e);
        if (e.getClickCount() == 2) {
            this.addRows();
        }
    }

    @Override
    protected void rightTable_tableClicked(KDTMouseEvent e) throws Exception {
        super.rightTable_tableClicked(e);
        if (e.getClickCount() == 2) {
            List rows = BgCommCHelper.getSelectRowIndexes((KDTable)this.rightTable);
            this.remove(rows);
        }
    }

    protected void remove(List<Integer> rows) throws EASBizException, BOSException {
        if (rows == null || rows.isEmpty()) {
            return;
        }
        Collections.sort(rows);
        for (int i = rows.size() - 1; i >= 0; --i) {
            int rowIndex = rows.get(i);
            IRow row = this.rightTable.getRow(rowIndex);
            this.rightTable.removeRow(rowIndex);
        }
    }

    protected void addRows() throws Exception {
        List rows = BgCommCHelper.getSelectRowIndexes((KDTable)this.getLeftTable());
        this.add(rows);
    }

    protected KDTable getLeftTable() {
        return this.leftTable;
    }

    protected void add(List rows) {
        int i;
        if (rows == null || rows.isEmpty()) {
            return;
        }
        IRow row = null;
        IRow newRow = null;
        HashSet<String> selectedNumbers = new HashSet<String>();
        for (i = 0; i < this.rightTable.getRowCount(); ++i) {
            selectedNumbers.add(this.rightTable.getRow(i).getCell(0).getValue().toString());
        }
        for (i = 0; i < rows.size(); ++i) {
            int rowIndex = (Integer)rows.get(i);
            row = this.getLeftTable().getRow(rowIndex);
            if (selectedNumbers.contains(row.getCell(0).getValue().toString())) continue;
            newRow = this.rightTable.addRow();
            newRow.getCell(0).setValue(row.getCell(0).getValue());
            newRow.getCell(1).setValue(row.getCell(1).getValue());
            newRow.getCell(2).setValue(row.getCell(2).getValue());
        }
    }
}

