/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.BgAccountSortInfo;
import com.kingdee.eas.ma.base.client.BgAccountSortDialog;
import com.kingdee.eas.ma.base.client.BgOrgViewF7;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.control.BgControlOrgEntrustFactory;
import com.kingdee.eas.ma.control.BgControlOrgEntrustInfo;
import com.kingdee.eas.ma.control.client.AbstractBgControlOrgEntrustListUI;
import com.kingdee.eas.ma.control.client.BgControlOrgAllSelectF7;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgControlOrgEntrustListUI
extends AbstractBgControlOrgEntrustListUI {
    private static final Logger logger = CoreUIObject.getLogger(BgControlOrgEntrustListUI.class);
    private static final long serialVersionUID = 1L;
    protected static final String COL_ID = "id";
    protected static final String COL_BGINDEXSORTID = "bgIndexSort.id";
    protected static final String COL_BGINDEXSORTNUMBER = "bgIndexSort.number";
    protected static final String COL_BGINDEXSORTNAME = "bgIndexSort.name";
    protected static final String COL_BGORGUNITID = "bgOrgUnit.id";
    protected static final String COL_BGORGUNITNUMBER = "bgOrgUnit.number";
    protected static final String COL_BGORGUNITNAME = "bgOrgUnit.name";
    protected static final String COL_ENTRUSTORGUNITID = "bgEntrustOrgUnit.id";
    protected static final String COL_ENTRUSTORGUNITNUMBER = "bgEntrustOrgUnit.number";
    protected static final String COL_ENTRUSTORGUNITNAME = "bgEntrustOrgUnit.name";
    protected static final String COL_CREATEORGUNITID = "createOrgUnit.id";
    protected static final String COL_CREATEORGUNITNUMBER = "createOrgUnit.number";
    protected static final String COL_CREATEORGUNITNAME = "createOrgUnit.name";
    protected static final String COL_LASTUPDATEUSER = "lastUpdateUser.name";
    protected static final String COL_LASTUPDATETIME = "lastUpdateTime";
    protected static final String COL_BEGINTIME = "beginTime";
    protected static final String COL_ENDTIME = "endTime";
    public static String mbg_control_orgEntrust_update = "mbg_control_orgEntrust_update";
    public static String mbg_control_orgEntrust_delete = "mbg_control_setting_import";
    public static String mbg_control_orgEntrust_import = "mbg_control_setting_import";
    public static String mbg_control_orgEntrust_export = "mbg_control_orgEntrust_export";
    private static final String res = "com.kingdee.eas.ma.control.client.BgControlOrgEntrustResource";
    private static final String TEXT_SEARCH = EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlOrgEntrustResource", (String)"textTitle");
    private static final String BGINDEXSORTNUMBER_EMPTY = "  ";
    private HashMap<BOSUuid, String> txtMap = null;
    private CostCenterOrgUnitInfo unitInfo = SysContext.getSysContext().getCurrentCostUnit();
    private CtrlUnitInfo CU = SysContext.getSysContext().getCurrentCtrlUnit();
    private boolean isClose = true;

    public CostCenterOrgUnitInfo getUnitInfo() {
        return this.unitInfo;
    }

    public void setUnitInfo(CostCenterOrgUnitInfo unitInfo) {
        this.unitInfo = unitInfo;
    }

    public CtrlUnitInfo getCU() {
        return this.CU;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.txtQuickQueryInput.setText(TEXT_SEARCH);
    }

    public void onShow() throws Exception {
        this.initPrmt();
        super.onShow();
        BgCommHelper.removeEditHelper((KDTable)this.tblMain);
    }

    private void initPrmt() {
        this.initBgIndexSort();
        this.initBgOrgUnit();
        this.initEntrustOrgUnit();
    }

    private void initBgIndexSort() {
        KDBizPromptBox prmt = new KDBizPromptBox();
        prmt.setEditable(false);
        BgAccountSortDialog Dialog2 = new BgAccountSortDialog();
        Dialog2.setOldData(prmt.getData());
        prmt.setSelector((KDPromptSelector)Dialog2);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)prmt);
        this.tblMain.getColumn(COL_BGINDEXSORTNAME).setEditor((ICellEditor)editor);
    }

    private void initBgOrgUnit() {
        BgControlOrgAllSelectF7 orgView = new BgControlOrgAllSelectF7();
        orgView.setTitle(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgBaseResource", (String)"selectOrgUnit"));
        orgView.setRootUnitID(this.getCU().getId().toString());
        orgView.setMultiSelect(true);
        final KDBizPromptBox prmt = new KDBizPromptBox();
        this.formatPrmt(prmt);
        prmt.setData((Object)this.getUnitInfo());
        prmt.setSelector((KDPromptSelector)orgView);
        prmt.setEditable(false);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)prmt);
        this.tblMain.getColumn(COL_BGORGUNITNUMBER).setEditor((ICellEditor)editor);
        this.tblMain.getColumn(COL_BGORGUNITNAME).getStyleAttributes().setLocked(true);
        this.setBgOrgNameByNumber(prmt);
        prmt.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                String orgUnitNumber;
                Object source = e.getSource();
                if (source instanceof KDBizPromptBox && ((KDBizPromptBox)source).getData() instanceof String && !StringUtils.isEmpty((String)(orgUnitNumber = (String)((KDBizPromptBox)source).getData()))) {
                    try {
                        FullOrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo("select id,name,number where number='" + orgUnitNumber + "'");
                        prmt.setDataNoNotify((Object)orgUnitInfo);
                    }
                    catch (EASBizException e1) {
                        logger.error((Object)"", (Throwable)e1);
                    }
                    catch (BOSException e1) {
                        logger.error((Object)"", (Throwable)e1);
                    }
                }
            }
        });
    }

    private void initEntrustOrgUnit() {
        BgOrgViewF7 orgView = new BgOrgViewF7((IUIObject)this);
        orgView.setTitle(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgBaseResource", (String)"selectOrgUnit"));
        orgView.setRootUnitID(this.getCU().getId().toString());
        orgView.setMultiSelect(false);
        KDBizPromptBox prmt = new KDBizPromptBox();
        this.formatPrmt(prmt);
        prmt.setData((Object)this.getUnitInfo());
        prmt.setSelector((KDPromptSelector)orgView);
        prmt.setEditable(false);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)prmt);
        this.tblMain.getColumn(COL_ENTRUSTORGUNITNUMBER).setEditor((ICellEditor)editor);
        this.tblMain.getColumn(COL_ENTRUSTORGUNITNAME).getStyleAttributes().setLocked(true);
        this.setEntrustOrgNameByNumber(prmt);
    }

    private void formatPrmt(KDBizPromptBox prmt) {
        prmt.setEditFormat("$number$");
        prmt.setDisplayFormat("$number$");
        prmt.setCommitFormat("$number$");
    }

    private void setEntrustOrgNameByNumber(KDBizPromptBox prmt) {
        prmt.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                KDBizPromptBox box = (KDBizPromptBox)eventObj.getSource();
                Object obj = box.getData();
                int curRowIndex = BgControlOrgEntrustListUI.this.tblMain.getSelectManager().getActiveRowIndex();
                if (box.getData() == null) {
                    BgControlOrgEntrustListUI.this.tblMain.getCell(curRowIndex, BgControlOrgEntrustListUI.COL_ENTRUSTORGUNITNUMBER).setUserObject(null);
                    BgControlOrgEntrustListUI.this.tblMain.getCell(curRowIndex, BgControlOrgEntrustListUI.COL_ENTRUSTORGUNITNAME).setValue(null);
                    BgControlOrgEntrustListUI.this.tblMain.getCell(curRowIndex, BgControlOrgEntrustListUI.COL_ENTRUSTORGUNITNUMBER).setValue(null);
                    BgControlOrgEntrustListUI.this.tblMain.getCell(curRowIndex, BgControlOrgEntrustListUI.COL_ENTRUSTORGUNITID).setValue(null);
                    BgControlOrgEntrustListUI.this.tblMain.getCell(curRowIndex, BgControlOrgEntrustListUI.COL_ENTRUSTORGUNITNAME).getStyleAttributes().setLocked(true);
                }
                if (obj != null) {
                    CostCenterOrgUnitInfo orgUnit = null;
                    if (obj instanceof FullOrgUnitInfo) {
                        try {
                            orgUnit = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(((FullOrgUnitInfo)obj).getId()));
                        }
                        catch (EASBizException e) {
                            e.printStackTrace();
                            BgControlOrgEntrustListUI.this.handUIException(e);
                        }
                        catch (BOSException e) {
                            e.printStackTrace();
                            BgControlOrgEntrustListUI.this.handUIException(e);
                        }
                        if (orgUnit == null) {
                            return;
                        }
                        BgControlOrgEntrustListUI.this.tblMain.getCell(curRowIndex, BgControlOrgEntrustListUI.COL_ENTRUSTORGUNITNUMBER).setUserObject((Object)orgUnit);
                        BgControlOrgEntrustListUI.this.tblMain.getCell(curRowIndex, BgControlOrgEntrustListUI.COL_ENTRUSTORGUNITNAME).setValue((Object)orgUnit.getName());
                        if (BgControlOrgEntrustListUI.this.tblMain.getCell(curRowIndex, BgControlOrgEntrustListUI.COL_ENTRUSTORGUNITNUMBER).getValue() != null && BgControlOrgEntrustListUI.this.tblMain.getCell(curRowIndex, BgControlOrgEntrustListUI.COL_ENTRUSTORGUNITNUMBER).getValue().toString().equals(orgUnit.getNumber())) {
                            BgControlOrgEntrustListUI.this.tblMain.getCell(curRowIndex, BgControlOrgEntrustListUI.COL_ENTRUSTORGUNITNUMBER).setValue((Object)(orgUnit.getNumber() + " "));
                        }
                        BgControlOrgEntrustListUI.this.tblMain.getCell(curRowIndex, BgControlOrgEntrustListUI.COL_ENTRUSTORGUNITNUMBER).setValue((Object)orgUnit.getNumber());
                        BgControlOrgEntrustListUI.this.tblMain.getCell(curRowIndex, BgControlOrgEntrustListUI.COL_ENTRUSTORGUNITID).setValue((Object)orgUnit.getId());
                    }
                    BgControlOrgEntrustListUI.this.tblMain.getCell(curRowIndex, BgControlOrgEntrustListUI.COL_ENTRUSTORGUNITNAME).getStyleAttributes().setLocked(true);
                }
            }
        });
    }

    private void setBgOrgNameByNumber(KDBizPromptBox prmt) {
        prmt.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                KDBizPromptBox box = (KDBizPromptBox)eventObj.getSource();
                Object[] obj = null;
                int curRowIndex = BgControlOrgEntrustListUI.this.tblMain.getSelectManager().getActiveRowIndex();
                IRow row = BgControlOrgEntrustListUI.this.tblMain.getRow(curRowIndex);
                Object oldValue = eventObj.getOldValue();
                HashMap<Integer, OrgUnitInfo> map = new HashMap<Integer, OrgUnitInfo>();
                if (box.getData() instanceof Object[]) {
                    obj = (Object[])box.getData();
                }
                if (box.getData() == null) {
                    BgControlOrgEntrustListUI.this.tblMain.getCell(curRowIndex, BgControlOrgEntrustListUI.COL_BGORGUNITNUMBER).setUserObject(null);
                    BgControlOrgEntrustListUI.this.tblMain.getCell(curRowIndex, BgControlOrgEntrustListUI.COL_BGORGUNITNAME).setValue(null);
                    BgControlOrgEntrustListUI.this.tblMain.getCell(curRowIndex, BgControlOrgEntrustListUI.COL_BGORGUNITNUMBER).setValue(null);
                    BgControlOrgEntrustListUI.this.tblMain.getCell(curRowIndex, BgControlOrgEntrustListUI.COL_BGORGUNITID).setValue(null);
                }
                if (obj != null) {
                    for (int i = 0; i < obj.length; ++i) {
                        OrgUnitInfo orgUnit = (OrgUnitInfo)obj[i];
                        if (i > 0) {
                            IRow addRow = BgControlOrgEntrustListUI.this.copyRow(row);
                            map.put(curRowIndex + i, orgUnit);
                            continue;
                        }
                        map.put(curRowIndex, orgUnit);
                    }
                    for (Map.Entry entry : map.entrySet()) {
                        int key = (Integer)entry.getKey();
                        OrgUnitInfo value = (OrgUnitInfo)entry.getValue();
                        if (!(oldValue instanceof String && value.getNumber().equals(oldValue) || oldValue instanceof OrgUnitInfo && value.getNumber().equals(((OrgUnitInfo)oldValue).getNumber()))) {
                            if (curRowIndex != key) {
                                BgControlOrgEntrustListUI.this.tblMain.getCell(key, BgControlOrgEntrustListUI.COL_ID).setValue(null);
                            }
                        } else if (curRowIndex != key) {
                            BgControlOrgEntrustListUI.this.tblMain.getCell(key, BgControlOrgEntrustListUI.COL_ID).setValue(null);
                        }
                        BgControlOrgEntrustListUI.this.tblMain.getCell(key, BgControlOrgEntrustListUI.COL_BGORGUNITNUMBER).setUserObject((Object)value);
                        BgControlOrgEntrustListUI.this.tblMain.getCell(key, BgControlOrgEntrustListUI.COL_BGORGUNITNAME).setValue((Object)value.getName());
                        if (BgControlOrgEntrustListUI.this.tblMain.getCell(key, BgControlOrgEntrustListUI.COL_BGORGUNITNUMBER).getValue() != null && BgControlOrgEntrustListUI.this.tblMain.getCell(key, BgControlOrgEntrustListUI.COL_BGORGUNITNUMBER).getValue().toString().equals(value.getNumber())) {
                            BgControlOrgEntrustListUI.this.tblMain.getCell(key, BgControlOrgEntrustListUI.COL_BGORGUNITNUMBER).setValue((Object)(value.getNumber() + " "));
                        }
                        BgControlOrgEntrustListUI.this.tblMain.getCell(key, BgControlOrgEntrustListUI.COL_BGORGUNITNUMBER).setValue((Object)value.getNumber());
                        BgControlOrgEntrustListUI.this.tblMain.getCell(key, BgControlOrgEntrustListUI.COL_BGORGUNITID).setValue((Object)value.getId());
                    }
                }
            }
        });
    }

    @Override
    public void actionAddNewRow_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNewRow_actionPerformed(e);
        IRow row = this.tblMain.addRow();
        this.tblMain.setRowCount(this.tblMain.getRowCount() + 1);
        row.getCell(COL_CREATEORGUNITNAME).setValue((Object)this.getUnitInfo().toString());
        String year = new SimpleDateFormat("yyyy").format(new Date());
        row.getCell(COL_BEGINTIME).setValue((Object)new SimpleDateFormat("yyyy-MM-dd").parse(year + "-01-01"));
        row.getCell(COL_ENDTIME).setValue((Object)new SimpleDateFormat("yyyy-MM-dd").parse("2099-12-31"));
        row.getCell(COL_LASTUPDATETIME).setValue((Object)new Date());
        row.getCell(COL_LASTUPDATEUSER).setValue((Object)SysContext.getSysContext().getCurrentUserInfo());
    }

    @Override
    public void actionDelRow_actionPerformed(ActionEvent e) throws Exception {
        this.actionRemove_actionPerformed(e);
        super.actionDelRow_actionPerformed(e);
    }

    protected void checkPermission(String permissionItem) throws EASBizException, BOSException {
        OrgUnitInfo currentOrgUnit = SysContext.getSysContext().getCurrentOrgUnit();
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        ObjectUuidPK currentOrgPK = new ObjectUuidPK(currentOrgUnit.getId());
        IPermission iPermisstion = PermissionFactory.getRemoteInstance();
        iPermisstion.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)currentOrgPK, permissionItem);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission(this.getActionRemovePermissionItem());
        this.checkSelected();
        List<Integer> indexs = this.getSelectRowIndex();
        ArrayList<String> list = new ArrayList<String>();
        if (this.confirmRemove()) {
            IRow row;
            int i;
            Boolean flag = false;
            for (i = indexs.size() - 1; i >= 0; --i) {
                row = this.tblMain.getRow(indexs.get(i).intValue());
                if (row.getCell(COL_CREATEORGUNITID).getValue() == null || this.getUnitInfo().getId().toString().equals(row.getCell(COL_CREATEORGUNITID).getValue())) continue;
                flag = true;
            }
            if (flag.booleanValue()) {
                MsgBox.showInfo((String)EASResource.getString((String)res, (String)"canntDelete"));
            }
            for (i = indexs.size() - 1; i >= 0; --i) {
                row = this.tblMain.getRow(indexs.get(i).intValue());
                if (row.getCell(COL_ID).getValue() == null) {
                    this.tblMain.removeRow(indexs.get(i).intValue());
                    continue;
                }
                if (row.getCell(COL_ID).getValue() == null || !this.getUnitInfo().getId().toString().equals(row.getCell(COL_CREATEORGUNITID).getValue())) continue;
                list.add(row.getCell(COL_ID).getValue().toString());
                this.tblMain.removeRow(indexs.get(i).intValue());
            }
            if (list.size() != 0) {
                ObjectUuidPK[] pks = new ObjectUuidPK[list.size()];
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    pks[i2] = new ObjectUuidPK(((String)list.get(i2)).toString());
                }
                BgControlOrgEntrustFactory.getRemoteInstance().deleteBatchData((IObjectPK[])pks);
                BgControlOrgEntrustListUI.addLog(null, mbg_control_orgEntrust_delete);
                MsgBox.showInfo((String)EASResource.getString((String)res, (String)"deleteSuc"));
            }
        }
    }

    protected String getActionRemovePermissionItem() {
        return "mbg_control_orgEntrust03_delete";
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    protected List<Integer> getSelectRowIndex() {
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range.size() == 0) {
            return null;
        }
        ArrayList<Integer> selectRowIndex = new ArrayList<Integer>();
        KDTSelectBlock block = null;
        for (int index = 0; index < range.size(); ++index) {
            block = (KDTSelectBlock)range.get(index);
            for (int r = block.getBeginRow(); r <= block.getEndRow(); ++r) {
                selectRowIndex.add(r);
            }
        }
        Collections.sort(selectRowIndex);
        return selectRowIndex;
    }

    @Override
    public void actionCopyRow_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyRow_actionPerformed(e);
        List<Integer> indexs = this.getSelectRowIndex();
        if (indexs == null || indexs.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        for (int i = 0; i < indexs.size(); ++i) {
            IRow row = this.tblMain.getRow(indexs.get(i).intValue());
            IRow addRow = this.copyRow(row);
            addRow.getCell(COL_ID).setValue(null);
        }
    }

    private IRow copyRow(IRow row) {
        if (row == null) {
            return null;
        }
        KDTRow kRow = (KDTRow)row.getKDTRow().clone();
        IRow addRow = this.tblMain.addRow(this.tblMain.getRowCount(), kRow);
        this.tblMain.setRowCount(this.tblMain.getRowCount() + 1);
        addRow.getStyleAttributes().setLocked(false);
        addRow.getCell(COL_CREATEORGUNITNAME).setValue((Object)this.getUnitInfo().toString());
        addRow.getCell(COL_CREATEORGUNITID).setValue((Object)this.getUnitInfo().getId().toString());
        addRow.getCell(COL_LASTUPDATETIME).setValue((Object)new Date());
        addRow.getCell(COL_LASTUPDATEUSER).setValue((Object)SysContext.getSysContext().getCurrentUserInfo());
        return addRow;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.tblMain.getEditManager().stopEditing();
        CoreBaseCollection colls = this.verifyOrgEntrustData();
        BgControlOrgEntrustInfo.beforeSave(colls);
        BgControlOrgEntrustFactory.getRemoteInstance().saveOrgEntrust((IObjectCollection)colls);
        BgControlOrgEntrustListUI.addLog(null, mbg_control_orgEntrust_update);
        this.tblMain.refresh();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)res, (String)"saveSuccess"));
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        BgControlOrgEntrustInfo info = null;
        BgAccountSortInfo bgAccountSortInfo = null;
        FullOrgUnitInfo fullOrgUnitInfo = null;
        CostCenterOrgUnitInfo ccInfo = null;
        IRow row = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        for (int index = e.getFirstRow(); index <= e.getLastRow(); ++index) {
            row = this.tblMain.getRow(index);
            info = new BgControlOrgEntrustInfo();
            bgAccountSortInfo = new BgAccountSortInfo();
            fullOrgUnitInfo = new FullOrgUnitInfo();
            ccInfo = new CostCenterOrgUnitInfo();
            if (row.getCell(COL_BGINDEXSORTNAME).getValue() != null) {
                bgAccountSortInfo.setId(BOSUuid.read((String)row.getCell(COL_BGINDEXSORTID).getValue().toString()));
                bgAccountSortInfo.setNumber(row.getCell(COL_BGINDEXSORTNUMBER).getValue().toString());
                bgAccountSortInfo.setName(row.getCell(COL_BGINDEXSORTNAME).getValue().toString());
            }
            if (row.getCell(COL_BGORGUNITNUMBER).getValue() != null) {
                fullOrgUnitInfo.setId(BOSUuid.read((String)row.getCell(COL_BGORGUNITID).getValue().toString()));
                fullOrgUnitInfo.setNumber(row.getCell(COL_BGORGUNITNUMBER).getValue().toString());
                fullOrgUnitInfo.setName(row.getCell(COL_BGORGUNITNAME).getValue().toString());
            }
            if (row.getCell(COL_ENTRUSTORGUNITNUMBER).getValue() != null) {
                ccInfo.setId(BOSUuid.read((String)row.getCell(COL_ENTRUSTORGUNITID).getValue().toString()));
                ccInfo.setNumber(row.getCell(COL_ENTRUSTORGUNITNUMBER).getValue().toString());
                ccInfo.setName(row.getCell(COL_ENTRUSTORGUNITNAME).getValue().toString());
            }
            try {
                Object date;
                if (row.getCell(COL_BEGINTIME).getValue() instanceof Date) {
                    date = (Date)row.getCell(COL_BEGINTIME).getValue();
                    date = format.parse(format.format((Date)date));
                    info.setBeginTime((Date)date);
                } else if (row.getCell(COL_BEGINTIME).getValue() instanceof String) {
                    date = (String)row.getCell(COL_BEGINTIME).getValue();
                    info.setBeginTime(format.parse((String)date));
                }
                if (row.getCell(COL_ENDTIME).getValue() instanceof Date) {
                    date = (Date)row.getCell(COL_ENDTIME).getValue();
                    date = format.parse(format.format((Date)date));
                    info.setEndTime((Date)date);
                } else if (row.getCell(COL_ENDTIME).getValue() instanceof String) {
                    date = (String)row.getCell(COL_ENDTIME).getValue();
                    info.setEndTime(format.parse((String)date));
                }
            }
            catch (ParseException e1) {
                logger.debug((Object)e1);
            }
            info.setBgIndexSort(bgAccountSortInfo);
            info.setBgOrgUnit(fullOrgUnitInfo);
            info.setBgEntrustOrgUnit(ccInfo);
            info.setId(BOSUuid.read((String)row.getCell(COL_ID).getValue().toString()));
            row.setUserObject((Object)info);
            if (row.getCell(COL_CREATEORGUNITID).getValue() == null || this.getUnitInfo().getId().toString().equals(row.getCell(COL_CREATEORGUNITID).getValue())) continue;
            row.getStyleAttributes().setLocked(true);
        }
    }

    @Override
    public void actionImportExcel_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkIsModify()) {
            this.tblMain.refresh();
        }
        super.actionImportExcel_actionPerformed(e);
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"isImport", (Object)true);
        ctx.put((Object)"template", (Object)this.loadTempTblData());
        ctx.put((Object)"uiTitle", (Object)EASResource.getString((String)res, (String)"orgEntrustImport"));
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.control.client.BgControlOrgEntrustImportUI", (Map)ctx, null, OprtState.VIEW);
        window.getUIObject().setUITitle(EASResource.getString((String)res, (String)"orgEntrustImport"));
        window.show();
        BgControlOrgEntrustListUI.addLog(null, mbg_control_orgEntrust_import);
        this.refreshList();
    }

    private KDTable loadTempTable() throws EASBizException, BOSException {
        KDTable tbl = new KDTable();
        String[] tempHeadNumber = new String[]{"indexSortNumber", "indexSortName", "orgUnitNumber", "orgUnitName", "entrustOrgUnitNumber", "entrustOrgUnitName", COL_BEGINTIME, COL_ENDTIME, "createOrgUnit"};
        String[] tempHeadName = new String[]{EASResource.getString((String)res, (String)"indexSortNumber"), EASResource.getString((String)res, (String)"indexSortName"), EASResource.getString((String)res, (String)"orgUnitNumber"), EASResource.getString((String)res, (String)"orgUnitName"), EASResource.getString((String)res, (String)"entrustOrgUnitNumber"), EASResource.getString((String)res, (String)"entrustOrgUnitName"), EASResource.getString((String)res, (String)COL_BEGINTIME), EASResource.getString((String)res, (String)COL_ENDTIME), EASResource.getString((String)res, (String)"createOrgUnit")};
        IRow head = tbl.addHeadRow();
        for (int i = 0; i < tempHeadNumber.length; ++i) {
            IColumn column = tbl.addColumn();
            column.setKey(tempHeadNumber[i]);
            head.getCell(column.getColumnIndex()).setValue((Object)tempHeadName[i]);
        }
        return tbl;
    }

    private KDTable loadTempTblData() throws EASBizException, BOSException {
        KDTable tbl = this.loadTempTable();
        IRow row = null;
        for (int j = 0; j < this.tblMain.getRowCount(); ++j) {
            Date date;
            row = tbl.addRow();
            row.getCell("indexSortNumber").setValue(this.tblMain.getRow(j).getCell(COL_BGINDEXSORTNUMBER).getValue() == null ? null : this.tblMain.getRow(j).getCell(COL_BGINDEXSORTNUMBER).getValue().toString());
            row.getCell("indexSortName").setValue(this.tblMain.getRow(j).getCell(COL_BGINDEXSORTNAME).getValue() == null ? null : this.tblMain.getRow(j).getCell(COL_BGINDEXSORTNAME).getValue().toString());
            row.getCell("orgUnitNumber").setValue(this.tblMain.getRow(j).getCell(COL_BGORGUNITNUMBER).getValue() == null ? null : this.tblMain.getRow(j).getCell(COL_BGORGUNITNUMBER).getValue().toString());
            row.getCell("orgUnitName").setValue(this.tblMain.getRow(j).getCell(COL_BGORGUNITNAME).getValue() == null ? null : this.tblMain.getRow(j).getCell(COL_BGORGUNITNAME).getValue().toString());
            row.getCell("entrustOrgUnitNumber").setValue(this.tblMain.getRow(j).getCell(COL_ENTRUSTORGUNITNUMBER).getValue() == null ? null : this.tblMain.getRow(j).getCell(COL_ENTRUSTORGUNITNUMBER).getValue().toString());
            row.getCell("entrustOrgUnitName").setValue(this.tblMain.getRow(j).getCell(COL_ENTRUSTORGUNITNAME).getValue() == null ? null : this.tblMain.getRow(j).getCell(COL_ENTRUSTORGUNITNAME).getValue().toString());
            if (this.tblMain.getRow(j).getCell(COL_BEGINTIME).getValue() == null) {
                row.getCell(COL_BEGINTIME).setValue(null);
            } else if (this.tblMain.getRow(j).getCell(COL_BEGINTIME).getValue() instanceof Date) {
                date = (Date)this.tblMain.getRow(j).getCell(COL_BEGINTIME).getValue();
                row.getCell(COL_BEGINTIME).setValue((Object)new SimpleDateFormat("yyyy-MM-dd").format(date));
            } else {
                row.getCell(COL_BEGINTIME).setValue(this.tblMain.getRow(j).getCell(COL_BEGINTIME).getValue());
            }
            if (this.tblMain.getRow(j).getCell(COL_ENDTIME).getValue() == null) {
                row.getCell(COL_ENDTIME).setValue(null);
            } else if (this.tblMain.getRow(j).getCell(COL_ENDTIME).getValue() instanceof Date) {
                date = (Date)this.tblMain.getRow(j).getCell(COL_ENDTIME).getValue();
                row.getCell(COL_ENDTIME).setValue((Object)new SimpleDateFormat("yyyy-MM-dd").format(date));
            } else {
                row.getCell(COL_ENDTIME).setValue(this.tblMain.getRow(j).getCell(COL_ENDTIME).getValue());
            }
            row.getCell("createOrgUnit").setValue(this.tblMain.getRow(j).getCell(COL_CREATEORGUNITNAME).getValue() == null ? null : this.tblMain.getRow(j).getCell(COL_CREATEORGUNITNAME).getValue().toString());
            this.setNumberFormat(row.getCell("indexSortNumber"), "@");
            this.setNumberFormat(row.getCell("indexSortName"), "@");
            this.setNumberFormat(row.getCell("orgUnitNumber"), "@");
            this.setNumberFormat(row.getCell("orgUnitName"), "@");
            this.setNumberFormat(row.getCell("entrustOrgUnitNumber"), "@");
            this.setNumberFormat(row.getCell("entrustOrgUnitName"), "@");
            this.setNumberFormat(row.getCell(COL_BEGINTIME), "@");
            this.setNumberFormat(row.getCell(COL_ENDTIME), "@");
            this.setNumberFormat(row.getCell("createOrgUnit"), "@");
        }
        return tbl;
    }

    private void setNumberFormat(ICell iCell, String numFormat) {
        if (iCell == null) {
            return;
        }
        StyleAttributes sa = Styles.getEmptySA();
        sa.setNumberFormat(numFormat);
        iCell.setStyleAttributes(sa);
    }

    @Override
    public void actionExportExcel_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportExcel_actionPerformed(e);
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"isImport", (Object)false);
        ctx.put((Object)"template", (Object)this.loadTempTable());
        ctx.put((Object)"data", (Object)this.loadTempTblData());
        ctx.put((Object)"uiTitle", (Object)EASResource.getString((String)res, (String)"orgEntrustExport"));
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.control.client.BgControlOrgEntrustImportUI", (Map)ctx, null, OprtState.VIEW);
        window.getUIObject().setUITitle(EASResource.getString((String)res, (String)"orgEntrustExport"));
        window.show();
        BgControlOrgEntrustListUI.addLog(null, mbg_control_orgEntrust_export);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void txtQuickQueryInput_focusLost(FocusEvent e) throws Exception {
        super.txtQuickQueryInput_focusLost(e);
        if (this.txtMap == null) {
            this.txtMap = new HashMap();
            this.getAllText();
        }
        if (!this.txtQuickQueryInput.getText().equalsIgnoreCase(TEXT_SEARCH)) {
            this.filterWithTxt(this.txtQuickQueryInput.getText(), this.txtMap);
        }
        if (!(e.getOppositeComponent() instanceof KDTable)) {
            this.txtQuickQueryInput.requestFocus();
        }
    }

    private void filterWithTxt(String filter, HashMap<BOSUuid, String> txtMap) {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            BOSUuid id;
            String value;
            if (this.tblMain.getRow(i).getCell(COL_ID).getValue() == null || (value = txtMap.get(id = BOSUuid.read((String)this.tblMain.getRow(i).getCell(COL_ID).getValue().toString()))) == null) continue;
            if (value.indexOf(filter) >= 0) {
                this.tblMain.getRow(i).getStyleAttributes().setHided(false);
                continue;
            }
            this.tblMain.getRow(i).getStyleAttributes().setHided(true);
        }
    }

    private void getAllText() {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            BOSUuid id = BOSUuid.read((String)row.getCell(COL_ID).getValue().toString());
            String indexName = row.getCell(COL_BGINDEXSORTNAME).getValue() != null ? row.getCell(COL_BGINDEXSORTNAME).getValue().toString() : "";
            String orgNumber = row.getCell(COL_BGORGUNITNUMBER).getValue().toString();
            String orgName = row.getCell(COL_BGORGUNITNAME).getValue().toString();
            String entrustNumber = row.getCell(COL_ENTRUSTORGUNITNUMBER).getValue().toString();
            String entrustName = row.getCell(COL_ENTRUSTORGUNITNAME).getValue().toString();
            this.txtMap.put(id, indexName + "!" + orgNumber + "!" + orgName + "!" + entrustNumber + "!" + entrustName);
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgControlOrgEntrustFactory.getRemoteInstance();
    }

    private BgControlOrgEntrustInfo addCreator(BgControlOrgEntrustInfo info) {
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        if (info.getCreateOrgUnit() == null) {
            info.setCreateOrgUnit(this.getUnitInfo().castToFullOrgUnitInfo());
        }
        return info;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsModify();
        super.actionRefresh_actionPerformed(e);
    }

    private boolean checkIsModify() throws Exception {
        boolean modify = false;
        BgControlOrgEntrustInfo temInfo = null;
        BgAccountSortInfo accountSortTem = null;
        String rowAccountNumber = null;
        String rowBgOrgUnitNumber = null;
        String rowBgEntrustOrgunitNumber = null;
        String beginTime = null;
        String endTime = null;
        String infoBgIndexSortNumber = null;
        int rowCount = this.tblMain.getRowCount();
        if (rowCount > 0) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            for (int i = 0; i < rowCount; ++i) {
                Date date;
                IRow row = this.tblMain.getRow(i);
                temInfo = (BgControlOrgEntrustInfo)row.getUserObject();
                if (temInfo == null || row.getCell(COL_ID).getValue() == null) {
                    modify = true;
                    break;
                }
                if (row.getCell(COL_BGINDEXSORTNAME).getValue() instanceof BgAccountSortInfo) {
                    accountSortTem = (BgAccountSortInfo)row.getCell(COL_BGINDEXSORTNAME).getValue();
                    rowAccountNumber = accountSortTem.getNumber();
                } else {
                    rowAccountNumber = row.getCell(COL_BGINDEXSORTNAME).getValue() == null ? null : row.getCell(COL_BGINDEXSORTNUMBER).getValue().toString();
                }
                rowBgOrgUnitNumber = row.getCell(COL_BGORGUNITNUMBER).getValue() == null ? null : row.getCell(COL_BGORGUNITNUMBER).getValue().toString();
                rowBgEntrustOrgunitNumber = row.getCell(COL_ENTRUSTORGUNITNUMBER).getValue() == null ? null : row.getCell(COL_ENTRUSTORGUNITNUMBER).getValue().toString();
                infoBgIndexSortNumber = temInfo.getBgIndexSort() == null ? null : temInfo.getBgIndexSort().getNumber();
                if (infoBgIndexSortNumber == null && rowAccountNumber != null || infoBgIndexSortNumber != null && !infoBgIndexSortNumber.equals(rowAccountNumber)) {
                    modify = true;
                    break;
                }
                if (!temInfo.getBgOrgUnit().getNumber().equals(rowBgOrgUnitNumber)) {
                    modify = true;
                    break;
                }
                if (!temInfo.getBgEntrustOrgUnit().getNumber().equals(rowBgEntrustOrgunitNumber)) {
                    modify = true;
                    break;
                }
                if (row.getCell(COL_BEGINTIME).getValue() instanceof Date) {
                    date = (Date)row.getCell(COL_BEGINTIME).getValue();
                    beginTime = format.format(date);
                } else if (row.getCell(COL_BEGINTIME).getValue() instanceof String) {
                    beginTime = (String)row.getCell(COL_BEGINTIME).getValue();
                }
                if (!format.format(temInfo.getBeginTime()).equals(beginTime)) {
                    modify = true;
                    break;
                }
                if (row.getCell(COL_ENDTIME).getValue() instanceof Date) {
                    date = (Date)row.getCell(COL_ENDTIME).getValue();
                    endTime = format.format(date);
                } else if (row.getCell(COL_ENDTIME).getValue() instanceof String) {
                    endTime = (String)row.getCell(COL_ENDTIME).getValue();
                }
                if (format.format(temInfo.getEndTime()).equals(endTime)) continue;
                modify = true;
                break;
            }
            if (modify) {
                int rs = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)res, (String)"needSave"));
                if (rs == 0 || rs == 0) {
                    this.isClose = true;
                    this.actionSave_actionPerformed(null);
                    return !this.isClose;
                }
                return false;
            }
        }
        return modify;
    }

    protected boolean checkBeforeWindowClosing() {
        try {
            return !this.checkIsModify();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (!this.isClose) {
                return this.isClose;
            }
            return super.checkBeforeWindowClosing();
        }
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        super.tblMain_editStopped(e);
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        int begin = this.tblMain.getColumnIndex(COL_BEGINTIME);
        int end = this.tblMain.getColumnIndex(COL_ENDTIME);
        if (colIndex == begin || colIndex == end) {
            if (e.getValue() == null) {
                this.tblMain.getCell(rowIndex, colIndex).setValue(e.getOldValue());
            } else if (!e.getOldValue().equals(e.getValue())) {
                SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd");
                Object beginTime = this.tblMain.getCell(rowIndex, COL_BEGINTIME).getValue();
                Object endTime = this.tblMain.getCell(rowIndex, COL_ENDTIME).getValue();
                Date beginDate = null;
                Date endDate = null;
                if (beginTime instanceof Date) {
                    beginDate = formate.parse(formate.format((Date)beginTime));
                } else if (beginTime instanceof String) {
                    beginDate = formate.parse((String)beginTime);
                }
                if (endTime instanceof Date) {
                    endDate = formate.parse(formate.format((Date)endTime));
                } else if (endTime instanceof String) {
                    endDate = formate.parse((String)endTime);
                }
                if (beginDate != null && endDate != null && beginDate.getTime() > endDate.getTime()) {
                    this.tblMain.getCell(rowIndex, colIndex).setValue(e.getOldValue());
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)res, (String)"beginDateLargerEndDate"));
                    SysUtil.abort();
                }
            }
        }
    }

    private void init() {
        this.btnAddRow.setEnabled(true);
        this.btnAddRow.setVisible(true);
        this.btnAddRow.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnCopyRow.setEnabled(true);
        this.btnCopyRow.setVisible(true);
        this.btnCopyRow.setIcon(EASResource.getIcon((String)"imgTbtn_copyline"));
        this.btnDelRow.setEnabled(true);
        this.btnDelRow.setVisible(true);
        this.btnDelRow.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnSave.setEnabled(true);
        this.btnSave.setVisible(true);
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnImprotExcel.setEnabled(true);
        this.btnImprotExcel.setVisible(true);
        this.btnImprotExcel.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnExportExcel.setEnabled(true);
        this.btnExportExcel.setVisible(true);
        this.btnExportExcel.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.tblMain.setEditable(true);
        this.tblMain.setEnabled(true);
        this.tblMain.getStyleAttributes().setLocked(false);
        this.tblMain.getEditManager().setAlwaysUseUserEditor(true);
        this.menuEdit.setVisible(false);
        this.menuEdit.setEnabled(false);
        this.menuTable.setEnabled(true);
        this.menuTable.setVisible(true);
        this.menuItemAddRow.setEnabled(true);
        this.menuItemAddRow.setVisible(true);
        this.menuItemAddRow.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.menuItemCopyRow.setEnabled(true);
        this.menuItemCopyRow.setVisible(true);
        this.menuItemCopyRow.setIcon(EASResource.getIcon((String)"imgTbtn_copyline"));
        this.menuItemDelRow.setEnabled(true);
        this.menuItemDelRow.setVisible(true);
        this.menuItemDelRow.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.separatorFW1.setVisible(false);
        this.separatorFW2.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.btnAddNew.setEnabled(false);
        this.btnView.setVisible(false);
        this.btnView.setEnabled(false);
        this.btnEdit.setVisible(false);
        this.btnEdit.setEnabled(false);
        this.btnRemove.setVisible(false);
        this.btnRemove.setEnabled(false);
        this.btnQuery.setVisible(false);
        this.btnQuery.setEnabled(false);
        this.btnLocate.setVisible(false);
        this.btnLocate.setEnabled(false);
        this.btnPrint.setVisible(false);
        this.btnPrint.setEnabled(false);
        this.btnPrintPreview.setVisible(false);
        this.btnPrintPreview.setEnabled(false);
        this.menuItemAddNew.setVisible(false);
        this.menuItemAddNew.setEnabled(false);
        this.menuItemImportExel.setEnabled(true);
        this.menuItemExportExel.setEnabled(true);
        this.btnRefresh.setEnabled(false);
        this.btnRefresh.setVisible(false);
        this.btnAddLine.setEnabled(true);
        this.btnCopyLine.setEnabled(true);
        this.btnRemoveLine.setEnabled(true);
        this.btnImportExcel.setEnabled(true);
        this.btnExportExcel1.setEnabled(true);
    }

    private CoreBaseCollection verifyOrgEntrustData() {
        String sortOrg;
        CoreBaseCollection colls = new CoreBaseCollection();
        BgControlOrgEntrustInfo bgControlOrgEntrustInfo = null;
        BgAccountSortInfo bgAccountSortInfo = null;
        FullOrgUnitInfo fullOrgUnitInfo = null;
        CostCenterOrgUnitInfo ccInfo = null;
        BgControlOrgEntrustInfo temInfo = null;
        int rowSize = this.tblMain.getRowCount();
        IRow row = null;
        ArrayList<String> verify = new ArrayList<String>();
        ArrayList<String> verify1 = new ArrayList<String>();
        HashMap<String, String> orgUnitMap = new HashMap<String, String>();
        HashMap<String, String> accSortMap = new HashMap<String, String>();
        String bgIndexSortNumber = null;
        String bgIndexSortName = null;
        String bgOrgUnitMumber = null;
        String bgOrgEnNumber = null;
        String bgOrgUnitName = null;
        String beginTime = null;
        String endTime = null;
        Date begin = null;
        Date end = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        for (int index = 0; index < rowSize; ++index) {
            bgControlOrgEntrustInfo = new BgControlOrgEntrustInfo();
            bgAccountSortInfo = new BgAccountSortInfo();
            fullOrgUnitInfo = new FullOrgUnitInfo();
            ccInfo = new CostCenterOrgUnitInfo();
            row = this.tblMain.getRow(index);
            temInfo = (BgControlOrgEntrustInfo)row.getUserObject();
            if (row.getCell(COL_BGINDEXSORTNAME).getValue() instanceof BgAccountSortInfo) {
                bgAccountSortInfo = (BgAccountSortInfo)row.getCell(COL_BGINDEXSORTNAME).getValue();
                bgIndexSortNumber = bgAccountSortInfo.getNumber().toString();
                bgIndexSortName = bgAccountSortInfo.getName().toString();
            } else if (row.getCell(COL_BGINDEXSORTNAME).getValue() instanceof String) {
                bgAccountSortInfo.setId(BOSUuid.read((String)row.getCell(COL_BGINDEXSORTID).getValue().toString()));
                bgIndexSortNumber = row.getCell(COL_BGINDEXSORTNUMBER).getValue().toString();
                bgAccountSortInfo.setNumber(bgIndexSortNumber);
                bgIndexSortName = row.getCell(COL_BGINDEXSORTNAME).getValue().toString();
                bgAccountSortInfo.setName(bgIndexSortName);
            } else {
                bgIndexSortNumber = BGINDEXSORTNUMBER_EMPTY;
                bgIndexSortName = BGINDEXSORTNUMBER_EMPTY;
            }
            if (row.getCell(COL_BGORGUNITNUMBER).getValue() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)res, (String)"bgOrgIsNull"));
                this.isClose = false;
                SysUtil.abort();
            }
            if (row.getCell(COL_BGORGUNITNUMBER).getUserObject() instanceof OrgUnitInfo) {
                fullOrgUnitInfo = ((OrgUnitInfo)row.getCell(COL_BGORGUNITNUMBER).getUserObject()).castToFullOrgUnitInfo();
                bgOrgUnitMumber = fullOrgUnitInfo.getNumber().toString();
                bgOrgUnitName = row.getCell(COL_BGORGUNITNAME).getValue().toString();
            } else if (row.getCell(COL_BGORGUNITNUMBER).getValue() instanceof String) {
                fullOrgUnitInfo.setId(BOSUuid.read((String)row.getCell(COL_BGORGUNITID).getValue().toString()));
                bgOrgUnitMumber = row.getCell(COL_BGORGUNITNUMBER).getValue().toString();
                fullOrgUnitInfo.setNumber(bgOrgUnitMumber);
                bgOrgUnitName = row.getCell(COL_BGORGUNITNAME).getValue().toString();
                fullOrgUnitInfo.setName(bgOrgUnitName);
            }
            if (row.getCell(COL_ENTRUSTORGUNITNUMBER).getValue() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)res, (String)"entrustOrgIsNull"));
                this.isClose = false;
                SysUtil.abort();
            }
            if (row.getCell(COL_BEGINTIME).getValue() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)res, (String)"beginTimeIsNull"));
                SysUtil.abort();
            } else {
                try {
                    if (row.getCell(COL_BEGINTIME).getValue() instanceof Date) {
                        begin = (Date)row.getCell(COL_BEGINTIME).getValue();
                        begin = format.parse(format.format(begin));
                    } else {
                        beginTime = (String)row.getCell(COL_BEGINTIME).getValue();
                        begin = format.parse(beginTime);
                    }
                }
                catch (ParseException e) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)res, (String)"beginTimeError"));
                    SysUtil.abort();
                }
            }
            if (row.getCell(COL_ENDTIME).getValue() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)res, (String)"endTimeIsNull"));
                SysUtil.abort();
            } else {
                try {
                    if (row.getCell(COL_ENDTIME).getValue() instanceof Date) {
                        end = (Date)row.getCell(COL_ENDTIME).getValue();
                        end = format.parse(format.format(end));
                    } else {
                        endTime = (String)row.getCell(COL_ENDTIME).getValue();
                        end = format.parse(endTime);
                    }
                }
                catch (ParseException e) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)res, (String)"endTimeError"));
                    SysUtil.abort();
                }
            }
            if (row.getCell(COL_ENTRUSTORGUNITNUMBER).getUserObject() instanceof CostCenterOrgUnitInfo) {
                ccInfo = (CostCenterOrgUnitInfo)row.getCell(COL_ENTRUSTORGUNITNUMBER).getUserObject();
                bgOrgEnNumber = ccInfo.getNumber().toString();
            } else if (row.getCell(COL_ENTRUSTORGUNITNUMBER).getValue() instanceof String) {
                ccInfo.setId(BOSUuid.read((String)row.getCell(COL_ENTRUSTORGUNITID).getValue().toString()));
                bgOrgEnNumber = row.getCell(COL_ENTRUSTORGUNITNUMBER).getValue().toString();
                ccInfo.setNumber(bgOrgEnNumber);
                ccInfo.setName(row.getCell(COL_ENTRUSTORGUNITNAME).getValue().toString());
            }
            if (bgOrgUnitMumber != null && bgOrgUnitMumber.equalsIgnoreCase(ccInfo.getNumber().toString())) {
                if (bgIndexSortNumber == null || BGINDEXSORTNUMBER_EMPTY.equals(bgIndexSortNumber)) {
                    MsgBox.showWarning((String)EASResource.getString((String)res, (String)"hasSameUnit1", (Object[])new String[]{bgOrgUnitMumber, bgOrgUnitName}));
                } else {
                    MsgBox.showWarning((String)EASResource.getString((String)res, (String)"hasSameUnit", (Object[])new String[]{bgIndexSortNumber, bgIndexSortName, bgOrgUnitMumber, bgOrgUnitName}));
                }
                this.isClose = false;
                SysUtil.abort();
            }
            String verifyStr = bgIndexSortNumber + "!" + bgOrgUnitMumber + ":" + format.format(begin) + "!" + format.format(end);
            sortOrg = bgIndexSortNumber + "!" + bgOrgUnitMumber;
            String verifyStr1 = bgIndexSortNumber + "!" + bgOrgEnNumber + ":" + format.format(begin) + "!" + format.format(end);
            if (verify.size() > 0) {
                for (String key : verify) {
                    String sortKey = key.split(":")[0];
                    if (!sortOrg.equals(sortKey)) continue;
                    String period = key.split(":")[1];
                    String[] periods = period.split("!");
                    try {
                        Date beginDate = format.parse(periods[0]);
                        Date endDate = format.parse(periods[1]);
                        if (begin == null || end == null || !(begin.getTime() >= beginDate.getTime() && begin.getTime() <= endDate.getTime() || begin.getTime() >= beginDate.getTime() && begin.getTime() <= endDate.getTime() || beginDate.getTime() >= begin.getTime() && beginDate.getTime() <= end.getTime()) && (beginDate.getTime() < begin.getTime() || beginDate.getTime() > end.getTime())) continue;
                        if (bgIndexSortNumber == null || BGINDEXSORTNUMBER_EMPTY.equals(bgIndexSortNumber)) {
                            MsgBox.showWarning((String)EASResource.getString((String)res, (String)"hasOrgUnit1", (Object[])new String[]{bgOrgUnitMumber}));
                        } else {
                            MsgBox.showWarning((String)EASResource.getString((String)res, (String)"hasOrgUnit", (Object[])new String[]{bgIndexSortName, bgOrgUnitMumber}));
                        }
                        this.isClose = false;
                        SysUtil.abort();
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
            verify.add(verifyStr);
            verify1.add(verifyStr1);
            orgUnitMap.put(bgOrgUnitMumber, bgOrgUnitName);
            if (!accSortMap.containsKey(bgIndexSortNumber)) {
                accSortMap.put(bgIndexSortNumber, bgIndexSortName);
            }
            BOSUuid id = row.getCell(COL_ID).getValue() != null ? BOSUuid.read((String)row.getCell(COL_ID).getValue().toString()) : BOSUuid.create((BOSObjectType)bgControlOrgEntrustInfo.getBOSType());
            bgControlOrgEntrustInfo.setId(id);
            if (!bgAccountSortInfo.isEmpty()) {
                bgControlOrgEntrustInfo.setBgIndexSort(bgAccountSortInfo);
            } else {
                bgControlOrgEntrustInfo.setBgIndexSort(null);
            }
            if (!fullOrgUnitInfo.isEmpty()) {
                bgControlOrgEntrustInfo.setBgOrgUnit(fullOrgUnitInfo);
            }
            if (!ccInfo.isEmpty()) {
                bgControlOrgEntrustInfo.setBgEntrustOrgUnit(ccInfo);
            }
            if (row.getCell(COL_CREATEORGUNITID).getValue() instanceof String && !StringUtils.isEmpty((String)((String)row.getCell(COL_CREATEORGUNITID).getValue()))) {
                FullOrgUnitInfo createOrg = new FullOrgUnitInfo();
                try {
                    createOrg.setId(BOSUuid.read((String)((String)row.getCell(COL_CREATEORGUNITID).getValue())));
                    bgControlOrgEntrustInfo.setCreateOrgUnit(createOrg);
                }
                catch (Exception key) {
                    // empty catch block
                }
            }
            bgControlOrgEntrustInfo.setBeginTime(begin);
            bgControlOrgEntrustInfo.setEndTime(end);
            if (temInfo != null && !BgControlOrgEntrustInfo.checkHasChange(temInfo, bgControlOrgEntrustInfo)) continue;
            colls.add((CoreBaseInfo)bgControlOrgEntrustInfo);
            row.setUserObject((Object)bgControlOrgEntrustInfo);
            this.addCreator(bgControlOrgEntrustInfo);
        }
        try {
            for (int i = 0; i < verify.size(); ++i) {
                String verifyStr3 = (String)verify.get(i);
                sortOrg = verifyStr3.split(":")[0];
                bgIndexSortNumber = sortOrg.split("!")[0];
                bgOrgUnitMumber = sortOrg.split("!")[1];
                String period1 = verifyStr3.split(":")[1];
                String[] periods1 = period1.split("!");
                Date beginDate1 = format.parse(periods1[0]);
                Date endDate1 = format.parse(periods1[1]);
                for (int j = 0; j < verify1.size(); ++j) {
                    String verifyStr4 = (String)verify1.get(j);
                    String sortEorg = verifyStr4.split(":")[0];
                    if (!sortOrg.equals(sortEorg)) continue;
                    String period2 = verifyStr4.split(":")[1];
                    String[] periods2 = period2.split("!");
                    Date beginDate2 = format.parse(periods2[0]);
                    Date endDate2 = format.parse(periods2[1]);
                    if (!(beginDate1.getTime() >= beginDate2.getTime() && beginDate1.getTime() <= endDate2.getTime() || beginDate1.getTime() >= beginDate2.getTime() && beginDate1.getTime() <= endDate2.getTime() || beginDate2.getTime() >= beginDate1.getTime() && beginDate2.getTime() <= endDate1.getTime()) && (beginDate2.getTime() < beginDate1.getTime() || beginDate2.getTime() > endDate1.getTime())) continue;
                    if (bgIndexSortNumber == null || BGINDEXSORTNUMBER_EMPTY.equals(bgIndexSortNumber)) {
                        MsgBox.showWarning((String)EASResource.getString((String)res, (String)"hasSameUnit1", (Object[])new String[]{bgOrgUnitMumber, (String)orgUnitMap.get(bgOrgUnitMumber)}));
                    } else {
                        MsgBox.showWarning((String)EASResource.getString((String)res, (String)"hasSameUnit", (Object[])new String[]{bgIndexSortNumber, (String)accSortMap.get(bgIndexSortNumber), bgOrgUnitMumber, (String)orgUnitMap.get(bgOrgUnitMumber)}));
                    }
                    this.isClose = false;
                    SysUtil.abort();
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return colls;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() > 1) {
            return;
        }
        if (e.getType() == 0) {
            this.checkIsModify();
        }
        super.tblMain_tableClicked(e);
    }

    public static void addLog(Context ctx, String logItem) {
        String logName = " ";
        IObjectPK tempPK = LogUtil.beginLog((Context)ctx, (String)"updateInfo", (BOSObjectType)new BgControlOrgEntrustInfo().getBOSType(), null, (String)logName, (String)logItem);
        LogUtil.afterLog((Context)ctx, (IObjectPK)tempPK);
    }
}

