/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.FiscalYearEnum;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.ma.control.BgControlSetSchemeFactory;
import com.kingdee.eas.ma.control.BgControlSetSchemeInfo;
import com.kingdee.eas.ma.control.client.AbstractBgControlSetSchemeEditUI;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class BgControlSetSchemeEditUI
extends AbstractBgControlSetSchemeEditUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BgControlSetSchemeEditUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.fiscalYearComboBox.addItem((Object)FiscalYearEnum.STANDARDYEAR);
        this.fiscalYearComboBox.addItem((Object)FiscalYearEnum.STRIDEYEAR);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        BgSchemeInfo bgScheme;
        if (this.editData != null && this.editData.getBgScheme() != null && (bgScheme = this.editData.getBgScheme()) != null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("isFiling");
            bgScheme = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgScheme.getId()), selector);
            if (bgScheme.isIsFiling()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlSettingResource", (String)"bgSchemeFiling"));
                SysUtil.abort();
            }
        }
        super.actionSave_actionPerformed(e);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.checkCanEditBgScheme();
    }

    public void onShow() throws Exception {
        super.onShow();
        CalendarHelper helper = new CalendarHelper();
        int endYear = helper.getCurrentlyYear(this.editData.getEndTime());
        int beginYear = helper.getCurrentlyYear(this.editData.getBeginTime());
        if (beginYear == endYear) {
            this.kDSpinnerYear.setValue((Object)1);
        } else {
            int year = endYear - beginYear + 1;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.editData.getBeginTime());
            calendar.add(1, year);
            calendar.add(6, -1);
            if (calendar.getTime().getTime() == this.editData.getEndTime().getTime()) {
                this.kDSpinnerYear.setValue((Object)year);
            } else {
                this.kDSpinnerYear.setValue((Object)(year - 1));
            }
        }
        this.fiscalYearComboBox.setSelectedItem((Object)this.editData.getFiscalYear());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT)) {
            this.btnEdit.setEnabled(false);
        } else {
            this.btnEdit.setEnabled(true);
        }
        this.btnEdit.setVisible(true);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.btnFirst.setEnabled(false);
        } else {
            this.btnFirst.setEnabled(true);
        }
        this.btnPre.setEnabled(true);
        this.btnNext.setEnabled(true);
        this.btnLast.setEnabled(true);
        this.btnAddNew.setEnabled(true);
        this.btnAddNew.setVisible(true);
        SpinnerNumberModel model = new SpinnerNumberModel();
        model.setMaximum(Integer.valueOf(10));
        model.setMinimum(Integer.valueOf(1));
        this.kDSpinnerYear.setModel((SpinnerModel)model);
        this.schemePromt.setEnabled(false);
        this.getUIMenuBar().setVisible(false);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.txtNumber.setEnabled(true);
        } else {
            this.txtNumber.setEnabled(false);
        }
    }

    protected void checkCanEditBgScheme() {
        if (this.getOprtState().equals(OprtState.EDIT) && this.getUIContext().get("ID") != null) {
            try {
                boolean bl = BgControlSetSchemeFactory.getRemoteInstance().checkHasSetting(BOSUuid.read((String)this.getUIContext().get("ID").toString()));
            }
            catch (EASBizException e) {
                logger.error((Object)"checkHasSetting error", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"checkHasSetting error", (Throwable)e);
            }
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        if (StringUtils.isEmpty((String)((String)this.txtName.getSelectedItemData()))) {
            throw new EASBizException(EASBizException.CHECKNAMEBLANK);
        }
        if (this.schemePromt.getData() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.control.BgControlMsgResource", (String)"schemeCantBeNull"));
            SysUtil.abort();
        }
        if (this.beginDate.getValue() == null) {
            this.beginDate.requestFocus(true);
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"beginDateIsNull"));
            SysUtil.abort();
        }
    }

    protected IObjectValue createNewData() {
        Timestamp currDate = new Timestamp(System.currentTimeMillis());
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        CalendarHelper helper = new CalendarHelper();
        BgControlSetSchemeInfo info = new BgControlSetSchemeInfo();
        info.setCreateTime(currDate);
        info.setCreator(user);
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setLastUpdateTime(currDate);
        info.setLastUpdateUser(user);
        info.setBeginDate(helper.getCurrentlyYear());
        info.setEndDate(helper.getCurrentlyYear());
        info.setBeginTime(helper.getFirstDayOfYear(info.getBeginDate()));
        info.setEndTime(helper.getLastDayOfYear(info.getEndDate()));
        info.setFiscalYear((FiscalYearEnum)this.fiscalYearComboBox.getSelectedItem());
        info.setBgScheme((BgSchemeInfo)this.getUIContext().get("bgScheme"));
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgControlSetSchemeFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("beginTime");
        sic.add("endTime");
        sic.add("description");
        sic.add("fiscalYear");
        sic.add(new SelectorItemInfo("bgScheme.id"));
        sic.add(new SelectorItemInfo("bgScheme.number"));
        sic.add(new SelectorItemInfo("bgScheme.name"));
        return sic;
    }

    @Override
    protected void beginDate_dataChanged(DataChangeEvent e) throws Exception {
        super.beginDate_dataChanged(e);
        Object obj = this.kDSpinnerYear.getValue();
        Date beginTime = (Date)e.getNewValue();
        if (obj instanceof Integer && beginTime != null) {
            Integer year = (Integer)obj;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(beginTime);
            calendar.add(1, year);
            calendar.add(6, -1);
            this.endDate.setValue((Object)calendar.getTime());
        }
    }

    @Override
    protected void endDate_dataChanged(DataChangeEvent e) throws Exception {
        super.endDate_dataChanged(e);
    }

    @Override
    protected void kDSpinnerYear_stateChanged(ChangeEvent e) throws Exception {
        super.kDSpinnerYear_stateChanged(e);
        KDSpinner _spinner = (KDSpinner)e.getSource();
        Object obj = _spinner.getValue();
        if (obj instanceof Integer) {
            Integer year = (Integer)obj;
            Date beginTime = (Date)this.beginDate.getValue();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(beginTime);
            calendar.add(1, year);
            calendar.add(6, -1);
            this.endDate.setValue((Object)calendar.getTime());
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.contNumber.setEnabled(true);
        super.actionAddNew_actionPerformed(e);
    }
}

