/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.control.BgControlSetSchemeFactory;
import com.kingdee.eas.ma.control.BgControlSetSchemeInfo;
import com.kingdee.eas.ma.control.client.AbstractBgControlSetSchemeForSchemeF7;
import com.kingdee.eas.ma.control.client.BgControlSetSchemeEditUI;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.MbgPermissionTypeEnum;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class BgControlSetSchemeForSchemeF7
extends AbstractBgControlSetSchemeForSchemeF7 {
    private static final Logger logger = CoreUIObject.getLogger(BgControlSetSchemeForSchemeF7.class);
    public static final String BG_SCHEME = "bgScheme";
    BgControlSetSchemeInfo result = null;
    HashSet<String> existCols = null;

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.afterConfirm();
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.searchBtn.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    try {
                        BgControlSetSchemeForSchemeF7.this.refreshList();
                    }
                    catch (Exception e1) {
                        logger.error((Object)("error" + e));
                    }
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    try {
                        BgControlSetSchemeForSchemeF7.this.refreshList();
                    }
                    catch (Exception e1) {
                        logger.error((Object)("error" + e));
                    }
                }
            }
        });
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkBgSchemeIsFiling();
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkBgSchemeIsFiling();
        super.actionEdit_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkBgSchemeIsFiling();
        super.actionAddNew_actionPerformed(e);
    }

    protected void checkBgSchemeIsFiling() throws EASBizException, BOSException {
        BgSchemeInfo bgScheme;
        if (this.getUIContext().get(BG_SCHEME) != null && (bgScheme = (BgSchemeInfo)this.getUIContext().get(BG_SCHEME)) != null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("isFiling");
            bgScheme = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgScheme.getId()), selector);
            if (bgScheme.isIsFiling()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlSettingResource", (String)"bgSchemeFiling"));
                SysUtil.abort();
            }
        }
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    private void afterConfirm() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null) {
            return;
        }
        int currRow = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow iRow = this.tblMain.getRow(currRow);
        BgControlSetSchemeInfo controlSetSchemeInfo = new BgControlSetSchemeInfo();
        BgSchemeInfo schemeInfo = new BgSchemeInfo();
        String id = iRow.getCell("id").getValue().toString();
        String number = iRow.getCell("number").getValue().toString();
        String name = (String)iRow.getCell("name").getValue();
        String schemeId = iRow.getCell("bgScheme.id").getValue().toString();
        String orgUnitId = iRow.getCell("bgScheme.orgUnit.id").getValue().toString();
        schemeInfo.setId(BOSUuid.read((String)schemeId));
        if (iRow.getCell("bgScheme.name").getValue() != null) {
            schemeInfo.setName(iRow.getCell("bgScheme.name").getValue().toString());
        }
        FullOrgUnitInfo unitInfo = new FullOrgUnitInfo();
        unitInfo.setId(BOSUuid.read((String)orgUnitId));
        schemeInfo.setOrgUnit(unitInfo);
        controlSetSchemeInfo.setId(BOSUuid.read((String)id));
        controlSetSchemeInfo.setNumber(number);
        controlSetSchemeInfo.setName(name);
        controlSetSchemeInfo.setBgScheme(schemeInfo);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-M-dd");
        try {
            controlSetSchemeInfo.setBeginTime(format.parse(iRow.getCell("beginTime").getValue().toString()));
            controlSetSchemeInfo.setEndTime(format.parse(iRow.getCell("endTime").getValue().toString()));
        }
        catch (ParseException e) {
            logger.error((Object)"controlSetSchemeInfo error", (Throwable)e);
        }
        this.result = controlSetSchemeInfo;
        this.getUIWindow().close();
    }

    protected BgControlSetSchemeInfo getResult() {
        return this.result;
    }

    protected String getEditUIName() {
        return BgControlSetSchemeEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgControlSetSchemeFactory.getRemoteInstance();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        String filterText = this.kDTextField1.getText();
        viewInfo = (EntityViewInfo)viewInfo.clone();
        viewInfo.setFilter(new FilterInfo());
        if (this.getUIContext().get(BG_SCHEME) != null) {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)((BgSchemeInfo)this.getUIContext().get(BG_SCHEME)).getId().toString(), CompareType.EQUALS));
        }
        if (!StringUtils.isEmpty((String)filterText)) {
            if (viewInfo.getFilter() == null) {
                viewInfo.setFilter(new FilterInfo());
            }
            int filterSize = viewInfo.getFilter().getFilterItems().size();
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)("%" + filterText + "%"), CompareType.LIKE));
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("name", (Object)("%" + filterText + "%"), CompareType.LIKE));
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("description", (Object)("%" + filterText + "%"), CompareType.LIKE));
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.name", (Object)("%" + filterText + "%"), CompareType.LIKE));
            if (filterSize == 0) {
                viewInfo.getFilter().setMaskString(" #0 OR #1 OR #2 OR #3 ");
            } else {
                viewInfo.getFilter().setMaskString(" #0 AND (#" + filterSize + " OR #" + (filterSize + 1) + " OR #" + (filterSize + 2) + " OR #" + (filterSize + 3) + ")");
            }
            this.kDTextField1.setSelectAllOnFocus(true);
        }
        SorterItemCollection sic = new SorterItemCollection();
        SorterItemInfo sortorNum = new SorterItemInfo("number");
        sortorNum.setSortType(SortType.ASCEND);
        sic.add(sortorNum);
        viewInfo.setSorter(sic);
        try {
            MbgPermissionHelper.addFieldDataPermission((RptSrcTypeEnum)BgNFCHelper.getSourceType((IUIObject)this), (String)SysContext.getSysContext().getCurrentUserInfo().getId().toString(), (FilterInfo)viewInfo.getFilter(), (MbgPermissionTypeEnum)MbgPermissionTypeEnum.SCHEME, (String)"bgScheme.id", null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        IRow row = null;
        this.existCols = new HashSet();
        for (int index = e.getFirstRow(); index <= e.getLastRow(); ++index) {
            row = this.tblMain.getRow(index);
            this.existCols.add(row.getCell("id").getValue().toString());
        }
    }

    @Override
    protected void searchBtn_mouseClicked(MouseEvent e) throws Exception {
        super.refreshList();
    }

    @Override
    public void actionsearch_actionPerformed(ActionEvent e) throws Exception {
        super.refreshList();
    }

    @Override
    protected void bottonConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.afterConfirm();
    }

    @Override
    protected void bottonCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)BG_SCHEME, this.getUIContext().get(BG_SCHEME));
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO) != null) {
            return new ObjectUuidPK(((OrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO)).getId());
        }
        return super.getOrgPK(action);
    }
}

