/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.control.BgBaseFacadeFactory;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgControlFacadeFactory;
import com.kingdee.eas.ma.control.BgControlIsomerFacadeFactory;
import com.kingdee.eas.ma.control.BgControlLogCollection;
import com.kingdee.eas.ma.control.BgControlLogFactory;
import com.kingdee.eas.ma.control.BgControlLogInfo;
import com.kingdee.eas.ma.control.BgControlLogRuleFactory;
import com.kingdee.eas.ma.control.BgControlLogRuleInfo;
import com.kingdee.eas.ma.control.BgControlSchemeFacadeFactory;
import com.kingdee.eas.ma.control.IBgControlFacade;
import com.kingdee.eas.ma.control.IBgControlIsomerFacade;
import com.kingdee.eas.ma.control.IBgControlLog;
import com.kingdee.eas.ma.control.IBgControlSchemeFacade;
import com.kingdee.eas.ma.control.client.AbstractBgControlUI;
import com.kingdee.eas.ma.control.client.BgControlDetailUI;
import com.kingdee.eas.ma.control.client.MbgBalanceUI;
import com.kingdee.eas.ma.control.client.utils.BgViewBillUtils;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.ma.control.utils.BizDataObject;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.ExtFileFilter;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.nbudget.BgControlCaller;
import com.kingdee.eas.ma.nbudget.face.IBgControl;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgControlUI
extends AbstractBgControlUI {
    private static final long serialVersionUID = -4784776805089627173L;
    private static final Logger logger = Logger.getLogger((String)BgControlUI.class.getName());
    private IBgControl caller = null;
    private List<String[]> bizConnects = null;
    private boolean select = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnRequest.setEnabled(true);
        this.btnReturn.setEnabled(true);
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, -30);
        this.dateBegin.setValue((Object)calendar.getTime(), false);
        this.dateEnd.setValue((Object)date, false);
        this.kdQuery.getStyleAttributes().setLocked(true);
        this.initBizSystemData();
        this.initBgScheme();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.toolBar.setVisible(false);
    }

    protected IBgControlSchemeFacade getFacadeInterface() throws Exception {
        return BgControlSchemeFacadeFactory.getRemoteInstance();
    }

    protected void initListener() {
        super.initListener();
        AbstractAction actionexport = new AbstractAction(){
            private static final long serialVersionUID = 2750933550496592004L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BgControlUI.this.actionExport(e);
                }
                catch (Exception ex) {
                    BgControlUI.this.handleException(ex);
                }
            }
        };
        String strKey = "CTRL_SHIFT_F1";
        KeyStroke ks = KeyStroke.getKeyStroke(112, 192, false);
        this.kdQuery.getActionMap().put(strKey, actionexport);
        this.kdQuery.getInputMap(2).put(ks, strKey);
    }

    protected void actionExport(ActionEvent e) throws Exception {
        KDFileChooser fc = new KDFileChooser();
        fc.setDialogTitle(BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"fileExport"));
        fc.setFileFilter((FileFilter)new ExtFileFilter());
        fc.setAcceptAllFileFilterUsed(false);
        fc.setSelectedFile(new File(BgCommHelper.getDefaultDirtory() + "//controlData.ext"));
        if (fc.showSaveDialog((Component)((Object)this)) == 0) {
            IRow row;
            boolean hasSave = true;
            File file = fc.getSelectedFile();
            if (file.exists()) {
                int re = MsgBox.showConfirm3((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"existsFile"));
                if (re == 1 || re == 2) {
                    return;
                }
                hasSave = file.delete();
            }
            if (hasSave && (row = this.kdQuery.getRow(this.kdQuery.getSelectManager().getActiveRowIndex())) != null) {
                BgControlLogInfo log = (BgControlLogInfo)row.getUserObject();
                BgControlLogRuleInfo rule = BgControlLogRuleFactory.getRemoteInstance().getBgControlLogRuleInfo((IObjectPK)new ObjectUuidPK(log.getRule().getId()));
                if (rule != null) {
                    BgAnalyseHelper.saveToFile((String)fc.getSelectedFile().getPath(), (byte[])rule.getData(), (int)4096);
                }
            }
        }
    }

    @Override
    protected void kDTabbedPane_stateChanged(ChangeEvent e) throws Exception {
        super.kDTabbedPane_stateChanged(e);
        int pageIndex = this.kDTabbedPane.getSelectedIndex();
        if (pageIndex != 0 && pageIndex != 1) {
            if (pageIndex == 2) {
                this.queryReturnBillInfo();
            } else if (pageIndex == 3) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onShow() throws Exception {
        IRowSet rs;
        ISQLExecutor executor;
        block8: {
            super.onShow();
            executor = null;
            rs = null;
            try {
                executor = SQLExecutorFactory.getRemoteInstance((String)"select FValue from T_MBG_BgParam where FKey = 'C0001'");
                rs = executor.executeSQL();
                if (rs.next()) {
                    BgNFCHelper.setSelectObject((KDComboBox)this.comBgConLevel, (Object)rs.getString("FValue"), (boolean)false);
                    break block8;
                }
                this.comBgConLevel.setSelectedIndex(0);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        try {
            executor = SQLExecutorFactory.getRemoteInstance((String)"select FValue from T_MBG_BgParam where FKey = 'C0002'");
            rs = executor.executeSQL();
            if (rs.next()) {
                this.comBgConDetail.setSelectedIndex(Integer.valueOf(rs.getString("FValue")).intValue());
            } else {
                this.comBgConDetail.setSelectedIndex(0);
            }
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
    }

    protected IBgControl getCaller() throws Exception {
        if (this.caller == null) {
            this.caller = new BgControlCaller();
        }
        return this.caller;
    }

    private boolean isomer() {
        return this.isomer.isSelected();
    }

    @Override
    protected void btnRequest_actionPerformed(ActionEvent e) throws Exception {
        super.btnRequest_actionPerformed(e);
        String billId = this.billIds.getText();
        if (StringUtils.isEmpty((String)billId)) {
            return;
        }
        if (!this.isomer()) {
            this.checkBOSUuid();
        }
        if (billId.indexOf(",") > 0) {
            this.showDialog(billId, true);
        } else if (this.isomer()) {
            BizDataObject billType = (BizDataObject)this.comBizIsomer.getSelectedItem();
            if (this.specialBudget.isSelected()) {
                BgControlIsomerFacadeFactory.getRemoteInstance().bgControlToGuiHandle(billId.trim(), billType.getValue(), 3);
            } else {
                BgControlIsomerFacadeFactory.getRemoteInstance().bgControlToGuiHandle(billId.trim(), billType.getValue(), 0);
            }
        } else if (this.specialBudget.isSelected()) {
            this.getCaller().specialBudget(BOSUuid.read((String)billId.trim()));
        } else {
            this.getCaller().requestBudget(BOSUuid.read((String)billId.trim()));
        }
        MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"batchRequest"));
    }

    private void checkBOSUuid() throws Exception {
        String billId = this.billIds.getText();
        if (StringUtils.isEmpty((String)billId)) {
            return;
        }
        String[] ids = billId.split(",");
        try {
            for (String id : ids) {
                BOSUuid.read((String)id.trim());
            }
        }
        catch (Exception e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new BgControlException(BgControlException.ERRORBILLID);
        }
    }

    @Override
    public void actionShowBalance_actionPerformed(ActionEvent e) throws Exception {
        String[] tmpStrs;
        super.actionShowBalance_actionPerformed(e);
        String billId = this.billIds.getText();
        if (StringUtils.isEmpty((String)billId)) {
            return;
        }
        if (!this.isomer()) {
            this.checkBOSUuid();
        }
        if ((tmpStrs = billId.split(",")) != null && tmpStrs.length > 0) {
            if (!this.isomer()) {
                BgControlCaller.showBudget((Component)((Object)this), (BOSUuid)BOSUuid.read((String)tmpStrs[0].trim()));
            } else {
                BizDataObject billType = (BizDataObject)this.comBizIsomer.getSelectedItem();
                UIContext ctx = new UIContext((Object)this);
                ctx.put((Object)"billNumber", (Object)tmpStrs[0].trim());
                ctx.put((Object)"isomerID", (Object)billType.getValue());
                UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MbgBalanceUI.class.getName(), (Map)ctx).show();
            }
        }
    }

    @Override
    protected void btnReturn_actionPerformed(ActionEvent e) throws Exception {
        super.btnReturn_actionPerformed(e);
        String billId = this.billIds.getText();
        if (StringUtils.isEmpty((String)billId)) {
            return;
        }
        if (!this.isomer()) {
            this.checkBOSUuid();
        }
        if (billId.indexOf(",") > 0) {
            this.showDialog(billId, false);
        } else {
            try {
                if (!this.isomer()) {
                    BgControlFacadeFactory.getRemoteInstance().returnBudget(BOSUuid.read((String)billId.trim()));
                } else {
                    BizDataObject billType = (BizDataObject)this.comBizIsomer.getSelectedItem();
                    BgControlIsomerFacadeFactory.getRemoteInstance().bgControlToGuiHandle(billId.trim(), billType.getValue(), 1);
                }
                MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"batchReturn"));
            }
            catch (IllegalArgumentException ex) {
                logger.error((Object)"", (Throwable)ex);
                throw new BgControlException(BgControlException.ERRORBILLID);
            }
        }
    }

    private void showDialog(String billIds, final boolean hasRequest) {
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        final String[] _billIds = billIds.split(",");
        if (_billIds == null) {
            return;
        }
        final BizDataObject billType = (BizDataObject)this.comBizIsomer.getSelectedItem();
        final boolean isCon = this.isomer();
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                String _billId = null;
                boolean re = true;
                int in = _billIds.length;
                for (int i = 0; i < in; ++i) {
                    _billId = _billIds[i].trim();
                    try {
                        if (hasRequest) {
                            if (isCon) {
                                if (BgControlUI.this.specialBudget.isSelected()) {
                                    BgControlIsomerFacadeFactory.getRemoteInstance().bgControlToGuiHandle(_billId, billType.getValue(), 3);
                                    continue;
                                }
                                BgControlIsomerFacadeFactory.getRemoteInstance().bgControlToGuiHandle(_billId, billType.getValue(), 0);
                                continue;
                            }
                            if (BgControlUI.this.specialBudget.isSelected()) {
                                BgControlUI.this.getCaller().specialBudget(BOSUuid.read((String)_billId));
                                continue;
                            }
                            BgControlUI.this.getCaller().requestBudget(BOSUuid.read((String)_billId));
                            continue;
                        }
                        if (isCon) {
                            BgControlIsomerFacadeFactory.getRemoteInstance().bgControlToGuiHandle(_billId, billType.getValue(), 1);
                            continue;
                        }
                        BgControlUI.this.getCaller().returnBudget(BOSUuid.read((String)_billId));
                        continue;
                    }
                    catch (IllegalArgumentException ex) {
                        re = false;
                    }
                }
                return re;
            }

            public void afterExec(Object result) throws Exception {
                Boolean re = (Boolean)result;
                if (re.booleanValue()) {
                    if (hasRequest) {
                        MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"batchRequest"));
                    } else {
                        MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"batchReturn"));
                    }
                } else {
                    throw new BgControlException(BgControlException.ERRORBILLID);
                }
            }
        });
        dialog.show();
    }

    protected IBgControlLog getLogInterface() throws BOSException {
        return BgControlLogFactory.getRemoteInstance();
    }

    @Override
    protected void txtBill_keyReleased(KeyEvent e) throws Exception {
        super.txtBill_keyReleased(e);
    }

    @Override
    protected void txtBill_focusLost(FocusEvent e) throws Exception {
        super.txtBill_focusLost(e);
        if (e.getOppositeComponent() != this.kDTabbedPane) {
            this.queryBgControlLog();
        }
    }

    @Override
    protected void dateBegin_dataChanged(DataChangeEvent e) throws Exception {
        super.dateBegin_dataChanged(e);
        this.queryBgControlLog();
    }

    @Override
    protected void dateEnd_dataChanged(DataChangeEvent e) throws Exception {
        super.dateEnd_dataChanged(e);
        this.queryBgControlLog();
    }

    @Override
    protected void chkIsomer_itemStateChanged(ItemEvent e) throws Exception {
        super.chkIsomer_itemStateChanged(e);
        this.queryBgControlLog();
    }

    protected void queryBgControlLog() throws Exception {
        BOSUuid uuid = null;
        Timestamp begin = null;
        Timestamp end = null;
        Calendar calendar = Calendar.getInstance();
        String txt = this.txtBill.getText();
        if (!StringUtils.isEmpty((String)txt)) {
            try {
                if (!this.chkIsomer.isSelected()) {
                    uuid = BOSUuid.read((String)txt.trim());
                    txt = uuid.toString();
                }
            }
            catch (Exception ex) {
                throw new BgControlException(BgControlException.ERRORBILLID);
            }
        }
        begin = this.dateBegin.getTimestamp();
        calendar.setTime(begin);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        begin = new Timestamp(calendar.getTimeInMillis());
        end = this.dateEnd.getTimestamp();
        calendar.setTime(end);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        end = new Timestamp(calendar.getTimeInMillis());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (!StringUtils.isEmpty((String)txt)) {
            filter.getFilterItems().add(new FilterItemInfo("billId", (Object)txt.toString(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("operTime", (Object)begin, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("operTime", (Object)end, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isomer", (Object)false, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("billId");
        sic.add("billNumber");
        sic.add("operTime");
        sic.add("operType");
        sic.add("operResult");
        sic.add("operDetail");
        sic.add("rule.id");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        SorterItemInfo sort = new SorterItemInfo("operTime");
        sort.setSortType(SortType.DESCEND);
        view.getSorter().add(sort);
        this.kdQuery.removeRows();
        BgControlLogCollection colls = null;
        colls = !this.chkIsomer.isSelected() ? this.getLogInterface().getBgControlLogCollection(view) : this.getLogInterface().getCollectionByIsomer(txt, begin, end);
        if (colls != null) {
            BgControlLogInfo log = null;
            IRow row = null;
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                log = colls.get(i);
                row = this.kdQuery.addRow();
                row.setUserObject((Object)log);
                row.getCell("billId").setValue((Object)log.getBillId());
                row.getCell("billNumber").setValue((Object)log.getBillAlias());
                row.getCell("operTime").setValue((Object)log.getOperTime());
                row.getCell("operType").setValue((Object)log.getOperType());
                row.getCell("operResult").setValue((Object)this.getLogResult(log));
                if (log.getRule() == null) continue;
                row.getCell("operDetail").setValue((Object)BgCommCHelper.getMessageStr((String)BgControlConstants.CONTROL_SOURCE, (String)"logdetail"));
            }
            if (!this.kdQuery.getViewManager().isFreeze()) {
                this.kdQuery.getViewManager().freeze(-1, 2);
            }
        }
    }

    private String getLogResult(BgControlLogInfo logInfo) {
        String logTxt = null;
        if (logInfo == null) {
            return logTxt;
        }
        int type = logInfo.getOperType().getValue();
        if (type == 1) {
            logTxt = BgCommCHelper.getMessageStr((String)BgControlConstants.CONTROL_SOURCE, (String)String.valueOf(logInfo.getOperResult()));
        } else if (type == 2) {
            logTxt = BgCommCHelper.getMessageStr((String)BgControlConstants.CONTROL_SOURCE, (String)String.valueOf(logInfo.getOperResult()));
        }
        return logTxt;
    }

    @Override
    protected void kdQuery_tableClicked(KDTMouseEvent e) throws Exception {
        super.kdQuery_tableClicked(e);
        if (e.getClickCount() == 2) {
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            if (rowIndex >= 0) {
                BOSUuid billId;
                if (colIndex == 1 && (billId = (BOSUuid)this.kdQuery.getRow(rowIndex).getCell("billId").getValue()) != null) {
                    BgViewBillUtils.viewBill((CoreUIObject)this, billId.toString());
                }
                if (colIndex == 5) {
                    IRow row = this.kdQuery.getRow(rowIndex);
                    BgControlLogInfo log = (BgControlLogInfo)row.getUserObject();
                    this.loadLogDetailInfo(log);
                }
            }
        }
    }

    @Override
    protected void comBgConLevel_itemStateChanged(ItemEvent e) throws Exception {
        Object obj;
        super.comBgConLevel_itemStateChanged(e);
        if (e.getStateChange() == 1 && (obj = e.getItem()) instanceof String) {
            String tmpStr = (String)obj;
            Pattern pattern = Pattern.compile("[0-9]*");
            Matcher isNum = pattern.matcher(tmpStr);
            if (isNum.matches()) {
                BgBaseFacadeFactory.getRemoteInstance().updateControlLevel(tmpStr);
            }
        }
    }

    @Override
    protected void comBgConDetail_itemStateChanged(ItemEvent e) throws Exception {
        super.comBgConDetail_itemStateChanged(e);
        if (e.getStateChange() == 1) {
            KDComboBox combox = (KDComboBox)e.getSource();
            BgBaseFacadeFactory.getRemoteInstance().updateControlDetail(String.valueOf(combox.getSelectedIndex()));
        }
    }

    protected void loadLogDetailInfo(BgControlLogInfo logInfo) throws Exception {
        List params;
        if (logInfo == null || logInfo.getRule() == null) {
            return;
        }
        BgControlLogRuleInfo rule = BgControlLogRuleFactory.getRemoteInstance().getBgControlLogRuleInfo((IObjectPK)new ObjectUuidPK(logInfo.getRule().getId()));
        if (rule.getData() != null && rule.getData().length > 0 && (params = (List)BgAnalyseHelper.getObject((byte[])rule.getData())) != null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put(BgControlParam.class, (Object)params);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgControlDetailUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    protected void initBizSystemData() throws Exception {
        List bizSystems = this.getFacadeInterface().getBizSys();
        Collections.reverse(bizSystems);
        this.comBizSystem.addItems(BizDataObject.transData(bizSystems).toArray());
        this.bizConnects = new ArrayList<String[]>();
        for (String[] strings : bizSystems) {
            if (!Boolean.valueOf(strings[2]).booleanValue()) continue;
            this.bizConnects.add(strings);
        }
        this.comBizCon.addItems(BizDataObject.transData(this.bizConnects).toArray());
    }

    protected void initBizUnitData(String bizSystem) throws Exception {
        List bizUnits = this.getFacadeInterface().getBizUnit(bizSystem);
        this.comBizUnit.removeAllItems();
        this.comBizUnit.addItems(BizDataObject.transData(bizUnits).toArray());
    }

    protected void initBgScheme() throws Exception {
        BgNFCHelper.setDefaultBgScheme((KDBizPromptBox)this.prmtScheme, null, (BOSUuid)null);
    }

    @Override
    protected void comBizSystem_itemStateChanged(ItemEvent e) throws Exception {
        super.comBizSystem_itemStateChanged(e);
        if (e == null || e.getStateChange() != 1) {
            return;
        }
        if (new Integer(this.comBizSystem.getSelectedIndex()).equals(this.comBizSystem.getUserObject())) {
            return;
        }
        BizDataObject bizSystem = (BizDataObject)this.comBizSystem.getSelectedItem();
        this.initBizUnitData(bizSystem.getValue());
    }

    @Override
    protected void comBizUnit_itemStateChanged(ItemEvent e) throws Exception {
        super.comBizUnit_itemStateChanged(e);
        if (e == null || e.getStateChange() != 1) {
            return;
        }
        if (Integer.valueOf(this.comBizUnit.getSelectedIndex()).equals(this.comBizUnit.getUserObject())) {
            return;
        }
        this.queryReturnBillInfo();
    }

    @Override
    protected void prmtScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtScheme_dataChanged(e);
        if (e.getNewValue() != null && !e.getNewValue().equals(e.getOldValue())) {
            this.queryReturnBillInfo((BgSchemeInfo)e.getNewValue());
        }
    }

    protected void queryReturnBillInfo() throws Exception {
        if (this.prmtScheme.getData() instanceof BgSchemeInfo) {
            BgSchemeInfo bgScheme = (BgSchemeInfo)this.prmtScheme.getData();
            this.queryReturnBillInfo(bgScheme);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queryReturnBillInfo(BgSchemeInfo bgScheme) throws Exception {
        this.kdBill.removeRows();
        if (bgScheme == null || bgScheme.getRefCube() == null || this.comBizUnit.getSelectedItem() == null) {
            return;
        }
        String controlCube = BgCubeUtils.getControlCubeName((String)bgScheme.getRefCube());
        String bizTable = null;
        String bosType = null;
        String sql = null;
        BizDataObject billType = (BizDataObject)this.comBizUnit.getSelectedItem();
        String local = SysContext.getSysContext().getLocale().toString();
        if (this.kdBill.getColumn("connection") == null) {
            this.kdBill.checkParsed();
        }
        if (billType.isIsomer()) {
            this.kdBill.getColumn("connection").getStyleAttributes().setHided(false);
            bosType = BOSUuid.read((String)billType.getValue()).getType().toString();
            sql = "select t.FBillId, t.FBillNumber, t.FCreateTime, cc.FName_" + local + " AS FOrgUnitName, m.fName_" + local + " AS FConnectionName from " + controlCube + " t left join T_ORG_CostCenter cc on t.FBizOrgUnitID = cc.FID left join T_MBG_BgControlIsomerConnect m on t.FConnectionID =  m.FID where t.FBillType = '" + bosType + "' and t.FIsomerID ='" + billType.getValue() + "'";
        } else {
            this.kdBill.getColumn("connection").getStyleAttributes().setHided(true);
            EntityObjectInfo entity = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)MetaDataPK.create((String)billType.getValue()));
            if (entity == null || entity.getTable() == null) {
                return;
            }
            bizTable = entity.getTable().getName();
            IObjectValue value = (IObjectValue)Class.forName(entity.getObjectValueClass()).newInstance();
            if (value == null) {
                return;
            }
            bosType = value.getBOSType().toString();
            sql = "select t.FBillId, t.FBillNumber, t.FCreateTime, cc.FName_" + local + " AS FOrgUnitName from " + controlCube + " t left join T_ORG_CostCenter cc on t.FBizOrgUnitID = cc.FID where not exists (select FID from " + bizTable + " where t.FBillId = FID) and t.FBillType = '" + bosType + "'";
        }
        IRow row = null;
        ISQLExecutor executor = null;
        IRowSet rst = null;
        try {
            executor = SQLExecutorFactory.getRemoteInstance((String)sql);
            rst = executor.executeSQL();
            while (rst.next()) {
                row = this.kdBill.addRow();
                row.getCell("select").setValue((Object)Boolean.FALSE);
                row.getCell("id").setValue((Object)rst.getString("FBillId"));
                row.getCell("number").setValue((Object)rst.getString("FBillNumber"));
                row.getCell("time").setValue((Object)rst.getTimestamp("FCreateTime"));
                row.getCell("orgUnit").setValue((Object)rst.getString("FOrgUnitName"));
                if (!billType.isIsomer()) continue;
                row.getCell("connection").setValue((Object)rst.getString("FConnectionName"));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
    }

    @Override
    protected void kdBill_tableClicked(KDTMouseEvent e) throws Exception {
        super.kdBill_tableClicked(e);
        if (e.getClickCount() == 2 && e.getColIndex() == 0) {
            IRow row = null;
            if (this.select) {
                int in = this.kdBill.getRowCount();
                for (int i = 0; i < in; ++i) {
                    row = this.kdBill.getRow(i);
                    row.getCell("select").setValue((Object)Boolean.FALSE);
                }
                this.select = false;
            } else {
                int in = this.kdBill.getRowCount();
                for (int i = 0; i < in; ++i) {
                    row = this.kdBill.getRow(i);
                    row.getCell("select").setValue((Object)Boolean.TRUE);
                }
                this.select = true;
            }
        }
    }

    @Override
    protected void btnReturn2_actionPerformed(ActionEvent e) throws Exception {
        super.btnReturn2_actionPerformed(e);
        if (this.kdBill.getRowCount() == 0) {
            return;
        }
        IRow row = null;
        Boolean select = null;
        ArrayList<String> billIds = new ArrayList<String>();
        int in = this.kdBill.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.kdBill.getRow(i);
            if (!(row.getCell("select").getValue() instanceof Boolean) || !(select = (Boolean)row.getCell("select").getValue()).booleanValue()) continue;
            billIds.add((String)row.getCell("id").getValue());
        }
        BizDataObject billType = (BizDataObject)this.comBizUnit.getSelectedItem();
        if (!billIds.isEmpty()) {
            if (billType.isIsomer()) {
                IBgControlIsomerFacade facade = BgControlIsomerFacadeFactory.getRemoteInstance();
                for (String billId : billIds) {
                    facade.bgControlToGuiHandle(billId, billType.getValue(), 1);
                }
            } else {
                IBgControlFacade facade = BgControlFacadeFactory.getRemoteInstance();
                for (String billId : billIds) {
                    facade.returnBudget(BOSUuid.read((String)billId.trim()));
                }
            }
            MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"batchReturn"));
            this.queryReturnBillInfo();
        }
    }

    @Override
    protected void isomer_itemStateChanged(ItemEvent e) throws Exception {
        super.isomer_itemStateChanged(e);
        if (this.isomer()) {
            if (this.bizConnects.isEmpty()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"noBizSys"));
                SysUtil.abort();
            }
            this.kDLabelContainer3.setVisible(true);
            this.kDLabelContainer4.setVisible(true);
        } else {
            this.kDLabelContainer3.setVisible(false);
            this.kDLabelContainer4.setVisible(false);
        }
    }

    @Override
    protected void comBizCon_itemStateChanged(ItemEvent e) throws Exception {
        super.comBizCon_itemStateChanged(e);
        if (e == null || e.getStateChange() != 1) {
            return;
        }
        if (new Integer(this.comBizCon.getSelectedIndex()).equals(this.comBizCon.getUserObject())) {
            return;
        }
        BizDataObject bizSystem = (BizDataObject)this.comBizCon.getSelectedItem();
        this.initBizIsomerData(bizSystem.getValue());
    }

    protected void initBizIsomerData(String bizSystem) throws Exception {
        List bizUnits = this.getFacadeInterface().getBizUnit(bizSystem);
        this.comBizIsomer.removeAllItems();
        this.comBizIsomer.addItems(BizDataObject.transData(bizUnits).toArray());
    }
}

