/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.IUserCellDisplayParser;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.client.progress.IProgressMonitor;
import com.kingdee.eas.fi.newrpt.client.progress.IRunnableWithProgress;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialog;
import com.kingdee.eas.ma.base.client.utils.BgBaseHelper;
import com.kingdee.eas.ma.control.BgControlSetSchemeFactory;
import com.kingdee.eas.ma.control.BgControlSetSchemeInfo;
import com.kingdee.eas.ma.control.IBgControlSetScheme;
import com.kingdee.eas.ma.control.client.AbstractBgCtrlDistributeUI;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeDispatchFacadeFactory;
import com.kingdee.eas.ma.mbg.client.utils.BgNSchemeDispatchClientHelper;
import com.kingdee.eas.ma.mbg.common.BgDispatchHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgTreeHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitUtils;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.orgunit.OrgUnitBaseUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class BgCtrlDistributeUI
extends AbstractBgCtrlDistributeUI
implements IUserCellDisplayParser {
    private static final Logger logger = CoreUIObject.getLogger(BgCtrlDistributeUI.class);
    private TreeModel initTreeModel;
    protected static final String COL_ID = "id";
    protected static final String COL_NUMBER = "number";
    protected static final String COL_NAME = "name";
    protected static final String COL_SELECT = "select";
    private static final Color NOFINANCE = Color.GRAY;
    private static final Color NO_DISPATCHED = Color.BLACK;
    private Set financeOrgSet;
    private Set costCenterIDSet;
    private String orgId;
    private boolean isTableMuliSelect;
    private boolean isCancel;
    private Set<BOSUuid> companyIds = null;
    private Map<String, Set<String>> dispatchMap = new HashMap<String, Set<String>>();
    private ProgressDialog progressDialog;
    private KDPopupMenu popMenu = new KDPopupMenu();

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.mainTable.checkParsed();
        this.mainTable.setUserCellDisplayParser((IUserCellDisplayParser)this);
    }

    public Object parse(int rowIndex, int colIndex, ICell cell, Object value) {
        if (cell.getUserObject() != null) {
            return (String)cell.getUserObject();
        }
        return value;
    }

    protected void init() throws Exception {
        this.btncancel.setEnabled(true);
        this.btnok.setEnabled(true);
        this.btnSearch.setEnabled(true);
        this.isModifyStatus.setVisible(false);
        this.isModifyScheme.setVisible(false);
        this.btnSelectAllTree.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnCancelAllTree.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.setTableMuliSelect(true);
        this.initTreeOrgunit();
        this.initPoppMenu();
        this.tableFullData();
        this.fillOrgUnitColor(true);
    }

    public Map<String, Set<String>> getDispatchMap() {
        return this.dispatchMap;
    }

    protected void initDispatchData(String id) throws Exception {
        this.getDispatchMap().clear();
        Map tmpMap = this.getDispatchInterface().queryDispatchInfo(BOSUuid.read((String)this.getBgSchemeId()), id);
        if (tmpMap != null) {
            this.getDispatchMap().putAll(tmpMap);
        }
    }

    protected String getBgSchemeId() {
        return ((BgControlSetSchemeInfo)this.getUIContext().get("info")).getId().toString();
    }

    protected IBgControlSetScheme getDispatchInterface() throws BOSException {
        return BgControlSetSchemeFactory.getRemoteInstance();
    }

    protected String getRootOrgId() {
        if (this.orgId == null && this.getUIContext().get("orgId") instanceof String) {
            this.orgId = (String)this.getUIContext().get("orgId");
        }
        return this.orgId;
    }

    protected void tableFullData() throws EASBizException, BOSException {
        this.reflushTable(null);
    }

    protected void reflushTable(String filterItem) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)this.getRootOrgId())) {
            return;
        }
        Map ctx = this.getUIContext();
        if (!(ctx.get("info") instanceof BgControlSetSchemeInfo)) {
            return;
        }
        BgControlSetSchemeInfo info = (BgControlSetSchemeInfo)ctx.get("info");
        KDTable table = this.getTable();
        table.checkParsed();
        table.removeRows();
        this.formatTable();
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("orgId", this.getRootOrgId());
        parameter.put("info", info);
        parameter.put("filterItem", filterItem);
        Map data = BgControlSetSchemeFactory.getRemoteInstance().getDistributeData(parameter);
        if (data == null || data.size() == 0) {
            return;
        }
        if (data.get("data") instanceof List) {
            int selectedRowIndex = -1;
            ArrayList selectedIndexes = (ArrayList)this.getUIContext().get("IDList");
            this.getUIContext().remove("IDList");
            if (selectedIndexes == null) {
                selectedIndexes = new ArrayList();
            }
            List rows = (List)data.get("data");
            Map row = null;
            IRow kdRow = null;
            HashSet<String> numbers = new HashSet<String>();
            for (int index = 0; index < rows.size(); ++index) {
                row = (Map)rows.get(index);
                if (this.isHide(row) || numbers.contains((String)row.get(COL_NUMBER))) continue;
                numbers.add((String)row.get(COL_NUMBER));
                if (!selectedIndexes.contains(row.get(COL_NUMBER))) {
                    kdRow = table.addRow();
                    kdRow.getCell(COL_SELECT).setValue((Object)false);
                } else {
                    kdRow = selectedRowIndex == -1 ? table.addRow(0) : table.addRow(selectedRowIndex + 1);
                    selectedRowIndex = kdRow.getRowIndex();
                    kdRow.getCell(COL_SELECT).setValue((Object)true);
                }
                kdRow.getCell(COL_ID).setValue(row.get(COL_ID));
                kdRow.getCell(COL_NUMBER).setValue(row.get(COL_NUMBER));
                String number = (String)row.get(COL_NUMBER);
                String name = (String)row.get(COL_NAME);
                kdRow.getCell(COL_NAME).setValue((Object)name);
                if (number == null || !number.startsWith("Acc:")) continue;
                number = DimensionFormulaHelper.getMemberNumber((String)number);
                kdRow.getCell(COL_NUMBER).setUserObject((Object)number);
                number = "[" + number + "]";
                if (name == null || !name.startsWith(number)) continue;
                name = name.substring(number.length(), name.length());
                kdRow.getCell(COL_NAME).setUserObject((Object)name);
            }
            table.setRowCount(rows.size());
        }
    }

    protected boolean isHide(Map row) {
        return false;
    }

    private void formatTable() {
        if (this.isTableMuliSelect()) {
            KDCheckBox box = new KDCheckBox();
            box.setSelected(true);
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JCheckBox)box);
            this.getTable().getColumn(COL_SELECT).setEditor((ICellEditor)editor);
        } else {
            this.getTable().getColumn(COL_SELECT).getStyleAttributes().setHided(true);
        }
    }

    protected void initTreeOrgunit() throws Exception {
        String orgViewId = this.getUIContext().get("viewId").toString();
        BgControlSetSchemeInfo info = (BgControlSetSchemeInfo)this.getUIContext().get("info");
        String schemeOrgId = info.getBgScheme().getOrgUnit().getId().toString();
        if (!schemeOrgId.equals(this.getRootOrgId())) {
            String bgOrgId = BgOrgUnitUtils.getBgOrgUnitIdByOrgUnitId((String)this.getRootOrgId(), (String)orgViewId, (boolean)false);
            this.initTreeModel = BgOrgUnitUtils.loadBgOrgTreeModel((KDTree)this.treeOrgunit, (String)bgOrgId, null, (String)orgViewId, (Boolean)true, null, (boolean)false);
        } else {
            this.initTreeModel = BgOrgUnitUtils.loadBgOrgTreeModel((KDTree)this.treeOrgunit, null, null, (String)orgViewId, (Boolean)true, null, (boolean)false);
        }
        this.treeOrgunit.setRootVisible(false);
        this.treeOrgunit.setShowCheckBox(true);
        BgBaseHelper.setRootCannotClose((KDTree)this.treeOrgunit);
        this.treeOrgunit.setModel(this.initTreeModel);
        BgOrgTreeHelper.setOrgTreeVisibleAndEnable((DefaultKingdeeTreeNode)((DefaultKingdeeTreeNode)this.treeOrgunit.getModel().getRoot()), (boolean)true, (boolean)true, (String)this.getRootOrgId(), null);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.initTreeModel.getRoot();
        if (root != null) {
            root.setCheckBoxEnabled(false);
            root.setCheckBoxVisible(false);
            root.setChecked(false);
        }
        this.treeOrgunit.addTreeNodeStateChangeListener((TreeNodeStateChangeListener)new treeCheckBoxChange());
        this.treeOrgunit.updateUI();
        if (root != null && root.getChildCount() > 0) {
            int in = root.getChildCount();
            for (int i = 0; i < in; ++i) {
                DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)root.getChildAt(i);
                OrgUnitBaseUtils.expandNode((KDTree)this.treeOrgunit, (DefaultKingdeeTreeNode)child);
            }
        }
    }

    protected KDTable getTable() {
        return this.mainTable;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        this.setCancel(false);
        KDTable table = this.getTable();
        HashSet<String> numbers = new HashSet<String>();
        for (int index = 0; index < table.getRowCount(); ++index) {
            IRow row = table.getRow(index);
            if (!Boolean.valueOf(row.getCell(COL_SELECT).getValue().toString()).booleanValue()) continue;
            numbers.add(row.getCell(COL_NUMBER).getValue().toString());
        }
        if (numbers.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgunit.getModel().getRoot();
        ArrayList selectNode = new ArrayList();
        this.getSelectNode(root, selectNode);
        if (selectNode.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlSettingResource", (String)"selectDisOrgunit"));
            return;
        }
        BgControlSetSchemeInfo info = (BgControlSetSchemeInfo)this.getUIContext().get("info");
        final HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("numbers", numbers);
        parameter.put("rootOrgId", this.getRootOrgId());
        parameter.put("distributeOrg", selectNode);
        parameter.put("schemeInfo", info);
        if (this.progressDialog == null) {
            this.progressDialog = ProgressDialog.createProgressDialog((Component)((Object)this), (boolean)true);
        }
        if (this.progressDialog.isVisible()) {
            return;
        }
        try {
            this.progressDialog.run(false, true, new IRunnableWithProgress(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(IProgressMonitor monitor) {
                    Object obj = null;
                    try {
                        monitor.beginTask(BgCtrlDistributeUI.this.getUITitle(), -1);
                        monitor.subTaskBegin(BgCtrlDistributeUI.this.getUITitle());
                        obj = BgControlSetSchemeFactory.getRemoteInstance().distribute(parameter);
                        if (obj instanceof Map) {
                            int index;
                            Map rs = (Map)obj;
                            String success = EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlSettingResource", (String)"success");
                            String fail = EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlSettingResource", (String)"fail");
                            StringBuffer msg = new StringBuffer();
                            CostCenterOrgUnitCollection sorg = (CostCenterOrgUnitCollection)rs.get("successOrg");
                            CostCenterOrgUnitCollection forg = (CostCenterOrgUnitCollection)rs.get("failOrg");
                            for (index = 0; index < forg.size(); ++index) {
                                msg.append(forg.get(index).getName()).append("-").append(fail).append("\n");
                            }
                            for (index = 0; index < sorg.size(); ++index) {
                                msg.append(sorg.get(index).getName()).append("-").append(success).append("\n");
                            }
                            MsgBox.showDetailAndOK((Component)((Object)BgCtrlDistributeUI.this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlSettingResource", (String)"operatorSuccess"), (String)msg.toString(), (int)1);
                        } else if (obj instanceof List) {
                            List li = (List)obj;
                            if (!li.isEmpty()) {
                                StringBuffer msg = new StringBuffer();
                                for (int i = 0; i < li.size(); ++i) {
                                    msg.append(li.get(i)).append("\n");
                                }
                                MsgBox.showDetailAndOK((Component)((Object)BgCtrlDistributeUI.this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlSettingResource", (String)"operatorSuccess"), (String)msg.toString(), (int)1);
                            } else {
                                MsgBox.showInfo((Component)((Object)BgCtrlDistributeUI.this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlSettingResource", (String)"distributeSuccess"));
                            }
                        } else {
                            MsgBox.showInfo((Component)((Object)BgCtrlDistributeUI.this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlSettingResource", (String)"distributeSuccess"));
                        }
                    }
                    catch (Exception e) {
                        BgCtrlDistributeUI.this.handUIExceptionAndAbort(e);
                        return;
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setCancel(true);
        this.disposeUIWindow();
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        if (this.cBoxFilterType.getSelectedIndex() == 0) {
            this.reflushTable(this.filterText.getText().trim());
        } else if (this.cBoxFilterType.getSelectedIndex() == 1) {
            TreeModel model = null;
            model = BgOrgUnitUtils.clipAndCloneTreeModel((TreeModel)this.initTreeModel, (String[])new String[]{COL_NUMBER}, (String)this.filterText.getText().trim(), (boolean)true);
            ((DefaultKingdeeTreeNode)model.getRoot()).setCheckBoxVisible(false);
            this.treeOrgunit.setModel(model);
            BgOrgTreeHelper.setOrgTreeVisibleAndEnable((DefaultKingdeeTreeNode)((DefaultKingdeeTreeNode)this.treeOrgunit.getModel().getRoot()), (boolean)true, (boolean)true, (String)this.getRootOrgId(), null);
            boolean isFinalOrg = this.cBoxFilterCompany.isSelected();
            if (isFinalOrg) {
                this.selectedFinanceOrg((DefaultKingdeeTreeNode)this.treeOrgunit.getModel().getRoot());
            }
            this.treeOrgunit.expandOnLevel(7);
        } else {
            TreeModel model = null;
            model = BgOrgUnitUtils.clipAndCloneTreeModel((TreeModel)this.initTreeModel, (String[])new String[]{COL_NAME}, (String)this.filterText.getText().trim(), (boolean)true);
            ((DefaultKingdeeTreeNode)model.getRoot()).setCheckBoxVisible(false);
            this.treeOrgunit.setModel(model);
            BgOrgTreeHelper.setOrgTreeVisibleAndEnable((DefaultKingdeeTreeNode)((DefaultKingdeeTreeNode)this.treeOrgunit.getModel().getRoot()), (boolean)true, (boolean)true, (String)this.getRootOrgId(), null);
            boolean isFinalOrg = this.cBoxFilterCompany.isSelected();
            if (isFinalOrg) {
                this.selectedFinanceOrg((DefaultKingdeeTreeNode)this.treeOrgunit.getModel().getRoot());
            }
            this.treeOrgunit.expandOnLevel(7);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.getTable().getColumn(COL_NAME).getStyleAttributes().setLocked(true);
        this.getTable().getColumn(COL_NUMBER).getStyleAttributes().setLocked(true);
        this.filterText.setFocusTraversalKeysEnabled(false);
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    try {
                        BgCtrlDistributeUI.this.actionFilter_actionPerformed(null);
                    }
                    catch (Exception e1) {
                        BgCtrlDistributeUI.this.handUIExceptionAndAbort(e1);
                    }
                }
            }
        });
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    public boolean isTableMuliSelect() {
        return this.isTableMuliSelect;
    }

    public void setTableMuliSelect(boolean isTableMuliSelect) {
        this.isTableMuliSelect = isTableMuliSelect;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    protected List getSelectNode(DefaultKingdeeTreeNode root, List list) throws Exception {
        if (list == null) {
            list = new ArrayList<String>();
        }
        if (root.isChecked()) {
            if (root.getUserObject() instanceof BgOrgUnitInfo) {
                BgOrgUnitInfo bgOrgUnitInfo = (BgOrgUnitInfo)root.getUserObject();
                list.add(bgOrgUnitInfo.getOrgUnitID());
            } else if (root.getUserObject() instanceof OrgStructureInfo) {
                OrgStructureInfo oui = (OrgStructureInfo)root.getUserObject();
                FullOrgUnitInfo info = oui.getUnit();
                info.setLongNumber(oui.getLongNumber());
                list.add(info.getId().toString());
            }
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.getSelectNode(node, list);
        }
        return list;
    }

    protected List<String> getSelectedIds() {
        ArrayList<String> selBgControlSetIds = new ArrayList<String>();
        Object obj = null;
        IRow row = null;
        int in = this.mainTable.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.mainTable.getRow(i);
            obj = row.getCell(COL_SELECT).getValue();
            if (!(obj instanceof Boolean) || !((Boolean)obj).booleanValue()) continue;
            selBgControlSetIds.add((String)this.mainTable.getRow(i).getCell(COL_ID).getValue());
        }
        return selBgControlSetIds;
    }

    @Override
    protected void mainTable_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.fillOrgUnitColor(true);
    }

    protected void fillOrgUnitColor(Object value) throws Exception {
        int rowIndex = this.mainTable.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        String id = (String)this.mainTable.getRow(rowIndex).getCell(COL_ID).getValue();
        boolean state = (Boolean)value;
        if (id != null) {
            this.fillOrgUnitColor(id, state);
            this.treeOrgunit.repaint();
        }
    }

    protected void fillOrgUnitColor() throws Exception {
        List<String> selectedIds = this.getSelectedIds();
        if (selectedIds.isEmpty()) {
            return;
        }
        for (String id : selectedIds) {
            this.fillOrgUnitColor(id, true);
        }
    }

    protected void fillOrgUnitColor(String id, boolean state) throws Exception {
        if (id == null || this.treeOrgunit.getModel() == null) {
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgunit.getModel().getRoot();
        this.fillOrgUnitColor(id, state, root);
    }

    protected void fillOrgUnitColor(String id, boolean state, DefaultKingdeeTreeNode root) throws Exception {
        if (id == null || root == null) {
            return;
        }
        this.initDispatchData(id);
        Set<String> orgUnitIds = this.getDispatchMap().get(id);
        if (orgUnitIds == null) {
            orgUnitIds = new HashSet<String>();
        }
        BgDispatchHelper.fillOrgUnitColor((DefaultKingdeeTreeNode)root, orgUnitIds, (boolean)state);
    }

    @Override
    protected void btnSelectAllTree_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgunit.getModel().getRoot();
        BgNSchemeDispatchClientHelper.setNodeSelect((boolean)true, (DefaultKingdeeTreeNode)root, (boolean)true, (KDTree)this.treeOrgunit);
        root.setChecked(false);
    }

    @Override
    protected void btnCancelAllTree_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgunit.getModel().getRoot();
        BgNSchemeDispatchClientHelper.setNodeSelect((boolean)false, (DefaultKingdeeTreeNode)root, (boolean)true, (KDTree)this.treeOrgunit);
    }

    @Override
    protected void btnTableSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.isTableSelectAll(true);
    }

    @Override
    protected void btnTableClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.isTableSelectAll(false);
    }

    private void isTableSelectAll(boolean isSelect) {
        int rowSize = this.mainTable.getRowCount();
        for (int index = 0; index < rowSize; ++index) {
            this.mainTable.getCell(index, COL_SELECT).setValue((Object)isSelect);
        }
    }

    protected void btnConfirmSelect_actionPerformed(ActionEvent e) throws Exception {
        ArrayList list = this.mainTable.getSelectManager().getBlocks();
        KDTSelectBlock block = null;
        ArrayList<Integer> rowIndexs = new ArrayList<Integer>();
        for (int index = 0; index < list.size(); ++index) {
            block = (KDTSelectBlock)list.get(index);
            for (int r = block.getTop(); r <= block.getBottom(); ++r) {
                rowIndexs.add(r);
            }
        }
        if (rowIndexs.size() == 0) {
            return;
        }
        for (int r = 0; r < rowIndexs.size(); ++r) {
            this.mainTable.getCell(((Integer)rowIndexs.get(r)).intValue(), COL_SELECT).setValue((Object)true);
        }
    }

    @Override
    protected void cBoxFilterCompany_actionPerformed(ActionEvent e) throws Exception {
        boolean isFinalOrg = ((KDCheckBox)e.getSource()).isSelected();
        if (isFinalOrg) {
            this.selectedFinanceOrg((DefaultKingdeeTreeNode)this.treeOrgunit.getModel().getRoot());
        } else {
            this.selectedAllOrg((DefaultKingdeeTreeNode)this.treeOrgunit.getModel().getRoot());
        }
        this.treeOrgunit.repaint();
    }

    private void selectedFinanceOrg(DefaultKingdeeTreeNode root) throws BOSException {
        if (root == null) {
            return;
        }
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
            if (!this.getFinanceOrgSet().contains(oui.getUnit().getId().toString())) {
                node.setTextColor(NOFINANCE);
                node.setCheckBoxVisible(false);
                node.setCheckBoxEnabled(false);
            }
            if (node.getChildCount() <= 0) continue;
            this.selectedFinanceOrg(node);
        }
    }

    private void selectedAllOrg(DefaultKingdeeTreeNode root) {
        if (root == null) {
            return;
        }
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            node.setTextColor(NO_DISPATCHED);
            node.setCheckBoxVisible(true);
            node.setCheckBoxEnabled(true);
            if (node.getChildCount() <= 0) continue;
            this.selectedAllOrg(node);
        }
    }

    private Set getFinanceOrgSet() throws BOSException {
        if (this.financeOrgSet == null) {
            this.costCenterIDSet = new HashSet();
            BgNFSHelper.getAllCostCenterIDs((Set)this.costCenterIDSet, (DefaultKingdeeTreeNode)((DefaultKingdeeTreeNode)this.treeOrgunit.getModel().getRoot()));
            this.financeOrgSet = BgNFSHelper.getFinanceOrgID((Set)this.costCenterIDSet);
        }
        return this.financeOrgSet;
    }

    @Override
    protected void treeOrgunit_valueChanged(TreeSelectionEvent e) throws Exception {
    }

    public KDPopupMenu getPopMenu() {
        return this.popMenu;
    }

    protected void initPoppMenu() {
        KDMenuItem menu = null;
        this.treeOrgunit.addMouseListener((MouseListener)new TreePopupMenuListener());
        menu = new KDMenuItem();
        menu.setText(BgOrgUnitHelper.getBgOrgMsg((String)"selectSon"));
        menu.addActionListener((ActionListener)new TreeMenuListener());
        this.getPopMenu().add((JMenuItem)menu);
        menu = new KDMenuItem();
        menu.setText(BgOrgUnitHelper.getBgOrgMsg((String)"selectAllSubOrgUnit"));
        menu.addActionListener((ActionListener)new AllOrgMenuListener());
        this.getPopMenu().add((JMenuItem)menu);
        menu = new KDMenuItem();
        menu.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgSchemeUnAssignResource", (String)"finOrg"));
        menu.addActionListener((ActionListener)new FinmenuListener());
        this.getPopMenu().add((JMenuItem)menu);
    }

    public Set<BOSUuid> getCompanyIds() {
        if (this.companyIds == null) {
            this.companyIds = new HashSet<BOSUuid>();
            try {
                Set<BOSUuid> idSet = this.queryCompanyIds();
                for (BOSUuid id : idSet) {
                    this.companyIds.add(id);
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return this.companyIds;
    }

    protected Set<BOSUuid> queryCompanyIds() throws Exception {
        return BgSchemeDispatchFacadeFactory.getRemoteInstance().queryCompanyIds();
    }

    class FinmenuListener
    implements ActionListener {
        FinmenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode selectNode = (DefaultKingdeeTreeNode)BgCtrlDistributeUI.this.treeOrgunit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectOrgUnitByIds((DefaultKingdeeTreeNode)selectNode, BgCtrlDistributeUI.this.getCompanyIds());
            BgCtrlDistributeUI.this.treeOrgunit.repaint();
        }
    }

    class AllOrgMenuListener
    implements ActionListener {
        AllOrgMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgCtrlDistributeUI.this.treeOrgunit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectOrgUnit((DefaultKingdeeTreeNode)node, (boolean)true);
            BgCtrlDistributeUI.this.treeOrgunit.repaint();
        }
    }

    class TreeMenuListener
    implements ActionListener {
        TreeMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgCtrlDistributeUI.this.treeOrgunit.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            BgOrgUnitUtils.selectDirectOrgUnit((DefaultKingdeeTreeNode)node, (boolean)true);
            BgCtrlDistributeUI.this.treeOrgunit.repaint();
        }
    }

    class TreePopupMenuListener
    extends MouseAdapter {
        TreePopupMenuListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                BgCtrlDistributeUI.this.getPopMenu().show((Component)BgCtrlDistributeUI.this.treeOrgunit, e.getX(), e.getY());
            }
        }
    }

    class treeCheckBoxChange
    implements TreeNodeStateChangeListener {
        treeCheckBoxChange() {
        }

        public void nodeStateChange(TreeNodeStateChangeEvent event) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)event.getNode();
            if (!node.isCheckBoxEnabled() || !node.isCheckBoxVisible()) {
                return;
            }
            if (!BgCtrlDistributeUI.this.includeChild.isSelected()) {
                return;
            }
            try {
                BgNSchemeDispatchClientHelper.setNodeSelect((boolean)node.isChecked(), (DefaultKingdeeTreeNode)node, (boolean)BgCtrlDistributeUI.this.includeChild.isSelected(), (KDTree)BgCtrlDistributeUI.this.treeOrgunit, (boolean)false);
            }
            catch (Exception e) {
                logger.error(null, (Throwable)e);
            }
        }
    }
}

