/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.control.client.AbstractBgCtrlSchemeBaseUI;
import com.kingdee.eas.ma.mbg.BgSchemeDispatchFacadeFactory;
import com.kingdee.eas.ma.mbg.client.utils.BgNSchemeDispatchClientHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class BgCtrlSchemeBaseUI
extends AbstractBgCtrlSchemeBaseUI {
    private static final long serialVersionUID = 3600657146461542357L;
    private static final Logger logger = CoreUIObject.getLogger(BgCtrlSchemeBaseUI.class);
    protected TreeModel initTreeModel;
    protected boolean isCancel = true;
    protected List orgList;
    private static final Color NOFINANCE = Color.GRAY;
    private static final Color NO_DISPATCHED = Color.BLACK;
    private Set financeOrgSet;
    private Set costCenterIDSet;
    private Set<BOSUuid> companyIds = null;
    private KDPopupMenu popMenu = new KDPopupMenu();

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnOk.setEnabled(true);
        this.btnOk.setVisible(true);
        this.btnCancel.setEnabled(true);
        this.btnCancel.setVisible(true);
        Object ob = this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
        String orgid = null;
        if (ob instanceof OrgUnitInfo) {
            orgid = ((OrgUnitInfo)ob).getId().toString();
        }
        this.initTreeModel = BgNFSHelper.getFullTreeModel(orgid);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.initTreeModel.getRoot();
        root.setCheckBoxVisible(false);
        this.orgTree.setModel(this.initTreeModel);
        this.orgTree.setShowCheckBox(true);
        this.orgTree.addTreeNodeStateChangeListener((TreeNodeStateChangeListener)new treeCheckBoxChange());
        this.filterText.setFocusTraversalKeysEnabled(false);
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    try {
                        BgCtrlSchemeBaseUI.this.btnSearchResult();
                    }
                    catch (Exception e1) {
                        BgCtrlSchemeBaseUI.this.handUIExceptionAndAbort(e1);
                    }
                }
            }
        });
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.initPoppMenu();
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.orgTree.getModel().getRoot();
        ArrayList selectNode = new ArrayList();
        this.getSelectNode(root, selectNode);
        if (selectNode.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlSettingResource", (String)"selectDisOrgunit"));
            return;
        }
        this.setOrgList(selectNode);
        this.setCancel(false);
        this.disposeUIWindow();
    }

    protected List getSelectNode(DefaultKingdeeTreeNode root, List list) throws Exception {
        if (list == null) {
            list = new ArrayList<String>();
        }
        if (root.isChecked()) {
            OrgStructureInfo oui = (OrgStructureInfo)root.getUserObject();
            FullOrgUnitInfo info = oui.getUnit();
            info.setLongNumber(oui.getLongNumber());
            list.add(info.getId().toString());
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.getSelectNode(node, list);
        }
        return list;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setCancel(true);
        this.disposeUIWindow();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public List getOrgList() {
        return this.orgList;
    }

    public void setOrgList(List orgList) {
        this.orgList = orgList;
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        this.btnSearchResult();
    }

    protected void btnSearchResult() {
        if (this.cBoxFilterType.getSelectedIndex() == 0) {
            TreeModel model = null;
            model = NewOrgUtils.clipAndCloneTreeModel((TreeModel)this.initTreeModel, (String)"name", (String)this.filterText.getText().trim(), (boolean)true);
            ((DefaultKingdeeTreeNode)model.getRoot()).setCheckBoxVisible(false);
            this.orgTree.setModel(model);
        } else {
            TreeModel model = null;
            model = NewOrgUtils.clipAndCloneTreeModel((TreeModel)this.initTreeModel, (String)"number", (String)this.filterText.getText().trim(), (boolean)true);
            ((DefaultKingdeeTreeNode)model.getRoot()).setCheckBoxVisible(false);
            this.orgTree.setModel(model);
        }
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.orgTree.getModel().getRoot();
        BgNSchemeDispatchClientHelper.setNodeSelect((boolean)true, (DefaultKingdeeTreeNode)root, (boolean)true, (KDTree)this.orgTree);
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.orgTree.getModel().getRoot();
        BgNSchemeDispatchClientHelper.setNodeSelect((boolean)false, (DefaultKingdeeTreeNode)root, (boolean)true, (KDTree)this.orgTree);
    }

    protected void cbFilterCompany_actionPerformed(ActionEvent e) throws Exception {
        boolean isFinalOrg = ((KDCheckBox)e.getSource()).isSelected();
        if (isFinalOrg) {
            this.selectedFinanceOrg((DefaultKingdeeTreeNode)this.orgTree.getModel().getRoot());
        } else {
            this.selectedAllOrg((DefaultKingdeeTreeNode)this.orgTree.getModel().getRoot());
        }
        this.orgTree.repaint();
    }

    private void selectedFinanceOrg(DefaultKingdeeTreeNode root) throws BOSException {
        if (root == null) {
            return;
        }
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
            if (!this.getFinanceOrgSet().contains(oui.getUnit().getId().toString())) {
                node.setTextColor(NOFINANCE);
                node.setCheckBoxVisible(false);
                node.setCheckBoxEnabled(false);
            }
            if (node.getChildCount() <= 0) continue;
            this.selectedFinanceOrg(node);
        }
    }

    private void selectedAllOrg(DefaultKingdeeTreeNode root) {
        if (root == null) {
            return;
        }
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            node.setTextColor(NO_DISPATCHED);
            node.setCheckBoxVisible(true);
            node.setCheckBoxEnabled(true);
            if (node.getChildCount() <= 0) continue;
            this.selectedAllOrg(node);
        }
    }

    private Set getFinanceOrgSet() throws BOSException {
        if (this.financeOrgSet == null) {
            this.costCenterIDSet = new HashSet();
            BgNFSHelper.getAllCostCenterIDs((Set)this.costCenterIDSet, (DefaultKingdeeTreeNode)((DefaultKingdeeTreeNode)this.orgTree.getModel().getRoot()));
            this.financeOrgSet = BgNFSHelper.getFinanceOrgID((Set)this.costCenterIDSet);
        }
        return this.financeOrgSet;
    }

    public KDPopupMenu getPopMenu() {
        return this.popMenu;
    }

    protected void initPoppMenu() {
        KDMenuItem menu = null;
        this.orgTree.addMouseListener((MouseListener)new TreePopupMenuListener());
        menu = new KDMenuItem();
        menu.setText(BgOrgUnitHelper.getBgOrgMsg((String)"selectSon"));
        menu.addActionListener((ActionListener)new TreeMenuListener());
        this.getPopMenu().add((JMenuItem)menu);
        menu = new KDMenuItem();
        menu.setText(BgOrgUnitHelper.getBgOrgMsg((String)"selectAllSubOrgUnit"));
        menu.addActionListener((ActionListener)new AllOrgMenuListener());
        this.getPopMenu().add((JMenuItem)menu);
        menu = new KDMenuItem();
        menu.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgSchemeUnAssignResource", (String)"finOrg"));
        menu.addActionListener((ActionListener)new FinmenuListener());
        this.getPopMenu().add((JMenuItem)menu);
    }

    public Set<BOSUuid> getCompanyIds() {
        if (this.companyIds == null) {
            this.companyIds = new HashSet<BOSUuid>();
            try {
                Set<BOSUuid> idSet = this.queryCompanyIds();
                for (BOSUuid id : idSet) {
                    this.companyIds.add(id);
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return this.companyIds;
    }

    protected Set<BOSUuid> queryCompanyIds() throws Exception {
        return BgSchemeDispatchFacadeFactory.getRemoteInstance().queryCompanyIds();
    }

    @Override
    protected void filterText_focusGained(FocusEvent e) throws Exception {
        super.filterText_focusGained(e);
    }

    @Override
    protected void filterText_focusLost(FocusEvent e) throws Exception {
        super.filterText_focusLost(e);
    }

    class FinmenuListener
    implements ActionListener {
        FinmenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode selectNode = (DefaultKingdeeTreeNode)BgCtrlSchemeBaseUI.this.orgTree.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectOrgUnitByIds((DefaultKingdeeTreeNode)selectNode, BgCtrlSchemeBaseUI.this.getCompanyIds());
            BgCtrlSchemeBaseUI.this.orgTree.repaint();
        }
    }

    class AllOrgMenuListener
    implements ActionListener {
        AllOrgMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgCtrlSchemeBaseUI.this.orgTree.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectOrgUnit((DefaultKingdeeTreeNode)node, (boolean)true);
            BgCtrlSchemeBaseUI.this.orgTree.repaint();
        }
    }

    class TreeMenuListener
    implements ActionListener {
        TreeMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgCtrlSchemeBaseUI.this.orgTree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            BgOrgUnitUtils.selectDirectOrgUnit((DefaultKingdeeTreeNode)node, (boolean)true);
            BgCtrlSchemeBaseUI.this.orgTree.repaint();
        }
    }

    class TreePopupMenuListener
    extends MouseAdapter {
        TreePopupMenuListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                BgCtrlSchemeBaseUI.this.getPopMenu().show((Component)BgCtrlSchemeBaseUI.this.orgTree, e.getX(), e.getY());
            }
        }
    }

    class treeCheckBoxChange
    implements TreeNodeStateChangeListener {
        treeCheckBoxChange() {
        }

        public void nodeStateChange(TreeNodeStateChangeEvent event) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)event.getNode();
            if (!node.isCheckBoxEnabled() || !node.isCheckBoxVisible()) {
                return;
            }
        }
    }
}

