/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.control.BgCurrencyMappingInfo;
import com.kingdee.eas.ma.control.BgExchangeRateSourceEnum;
import com.kingdee.eas.ma.control.client.AbstractBgCurrencyMappingDetailUI;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import java.awt.event.ActionEvent;
import java.util.List;
import org.apache.log4j.Logger;

public class BgCurrencyMappingDetailUI
extends AbstractBgCurrencyMappingDetailUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BgCurrencyMappingDetailUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadCurrencyMapping();
    }

    protected void loadCurrencyMapping() {
        BgControlParam param = (BgControlParam)this.getUIContext().get(BgControlParam.class);
        List<BgCurrencyMappingInfo> infos = param.getCurrencyMappings();
        if (!infos.isEmpty()) {
            BgCurrencyMappingInfo info = infos.get(0);
            this.kDTFBillCurrency.setText(info.getBillCurrency().getName());
            this.kDTFBgCurrency.setText(info.getBgCurrency().getName());
            if (info.getBgExchangeRateSource().equals((Object)BgExchangeRateSourceEnum.ExchangeRateTable)) {
                if (info.get("EXCHANGETABLE") != null) {
                    this.kDTFSource.setText(info.get("EXCHANGETABLE").toString());
                } else {
                    this.kDTFSource.setText(info.getBgExchangeRateSource().getAlias());
                }
            } else {
                this.kDTFSource.setText(info.getBgExchangeRateSource().getAlias());
            }
            this.kDTFRate.setText(info.getBgExchangeRate().toString());
            if (info.get("DETAIL") != null) {
                this.kDTFDetail.setText(info.get("DETAIL").toString());
            }
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.kDTFBillCurrency.setEnabled(false);
        this.kDTFBgCurrency.setEnabled(false);
        this.kDTFSource.setEnabled(false);
        this.kDTFRate.setEnabled(false);
        this.kDTFDetail.setEnabled(false);
    }

    @Override
    protected void btnClose_actionPerformed(ActionEvent e) throws Exception {
        super.btnClose_actionPerformed(e);
        this.getUIWindow().close();
    }
}

