/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.MbgDimFactory;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.control.client.AbstractBgDimSelectF7UI;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.ma.control.utils.BizDataObject;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class BgDimSelectF7UI
extends AbstractBgDimSelectF7UI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BgDimSelectF7UI.class);
    public static String BIZPROPS = "BIZPROPS";
    private String COL_NUMBER = "number";
    private String COL_NAME = "name";
    private boolean isCanceled = true;
    private Object data = null;

    public void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        super.onLoad();
        this.fillData();
    }

    protected void fillData() throws BOSException {
        this.tblMain.removeRows();
        if (this.getUIContext().get(BIZPROPS) instanceof List) {
            List bizProps = (List)this.getUIContext().get(BIZPROPS);
            MbgDimCollection colls = MbgDimFactory.getRemoteInstance().getMbgDimCollection("select id, number, name, srcNumber");
            HashMap<String, MbgDimInfo> mbgDimMap = new HashMap<String, MbgDimInfo>();
            if (colls != null && !colls.isEmpty()) {
                for (int i = 0; i < colls.size(); ++i) {
                    mbgDimMap.put(colls.get(i).getSrcNumber(), colls.get(i));
                }
            }
            BizDataObject bizObj = null;
            IRow row = null;
            if (bizProps != null && !bizProps.isEmpty()) {
                for (int i = 0; i < bizProps.size(); ++i) {
                    bizObj = (BizDataObject)bizProps.get(i);
                    if (bizObj == null) continue;
                    row = this.tblMain.addRow();
                    row.setUserObject((Object)bizObj);
                    row.getCell(this.COL_NAME).setValue((Object)bizObj.getDisplay());
                    if (bizObj.getValue() == null) continue;
                    if (bizObj.getValue().equals(DimensionConstants.DEF_INDEX_SRCNUMBER)) {
                        row.getCell(this.COL_NUMBER).setValue((Object)DimensionConstants.DEF_ACCOUNT_NUMBER);
                        continue;
                    }
                    if (!mbgDimMap.containsKey(bizObj.getValue())) continue;
                    row.getCell(this.COL_NUMBER).setValue((Object)((MbgDimInfo)mbgDimMap.get(bizObj.getValue())).getNumber());
                }
            }
        }
        if (this.tblMain.getRowCount() > 0) {
            this.tblMain.getSelectManager().setActiveRowIndex(0);
            this.tblMain.getSelectManager().select(0, 0);
        }
    }

    @Override
    protected void txtMbgDimSearch_focusLost(FocusEvent e) throws Exception {
        this.doSearch();
    }

    @Override
    protected void btnMbgDimSearch_actionPerformed(ActionEvent e) throws Exception {
        this.doSearch();
    }

    protected void doSearch() {
        String text = this.txtMbgDimSearch.getText();
        IRow row = null;
        String number = "";
        String name = "";
        if (!StringUtils.isEmpty((String)text)) {
            for (int rowIndex = 0; rowIndex < this.tblMain.getRowCount(); ++rowIndex) {
                row = this.tblMain.getRow(rowIndex);
                if (row.getCell(this.COL_NUMBER).getValue() != null) {
                    number = row.getCell(this.COL_NUMBER).getValue().toString();
                }
                if (row.getCell(this.COL_NAME).getValue() != null) {
                    name = row.getCell(this.COL_NAME).getValue().toString();
                }
                if (number.indexOf(text) < 0 && name.indexOf(text) < 0) {
                    row.getStyleAttributes().setHided(true);
                    continue;
                }
                row.getStyleAttributes().setHided(false);
            }
        } else {
            for (int rowIndex = 0; rowIndex < this.tblMain.getRowCount(); ++rowIndex) {
                row = this.tblMain.getRow(rowIndex);
                if (!row.getStyleAttributes().isHided()) continue;
                row.getStyleAttributes().setHided(false);
            }
        }
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        this.confirm();
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 1) {
            return;
        }
        if (e.getType() == 1 && e.getClickCount() == 2) {
            this.confirm();
        }
    }

    protected void confirm() {
        int index = this.tblMain.getSelectManager().getActiveRowIndex();
        if (index >= 0 && !this.tblMain.getRow(index).getStyleAttributes().isHided()) {
            this.setData(this.tblMain.getRow(index).getUserObject());
        } else {
            this.setData(null);
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"dimNull"));
            SysUtil.abort();
        }
        this.isCanceled = false;
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setCanceled(true);
        this.getUIWindow().close();
    }
}

