/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.FilterParam;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.client.BgOrgViewF7;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.control.MBgAnalyseFacadeFactory;
import com.kingdee.eas.ma.control.client.AbstractMBgAnalyseExeFilterUI;
import com.kingdee.eas.ma.control.client.MBgAnalyseExeUI;
import com.kingdee.eas.ma.control.client.MbgAnalyseExeBlockSetUI;
import com.kingdee.eas.ma.control.client.MbgAnalyseExeHelper;
import com.kingdee.eas.ma.control.query.ExeFilterParam;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.common.BgViewOrgDimensionF7;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgViewClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.NewDimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.query.AnalyseMember;
import com.kingdee.eas.ma.mbg.query.BaseFilterParam;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.BgCellRenderHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MBgAnalyseExeFilterUI
extends AbstractMBgAnalyseExeFilterUI {
    private static final long serialVersionUID = 3598113800665987785L;
    private static final Logger logger = CoreUIObject.getLogger(MBgAnalyseExeFilterUI.class);
    protected static final String COL_INDEX_MEMBERS = "bgIndex";
    protected static final String COL_REF_MEMBERS = "dimMember";
    private String ANALYSE_SCHEME_ID = "ANALYSE_SCHEME_ID";
    private String ANALYSE_MEMBER = "ANALYSE_MEMBER";
    private String ANALYSE_SHOWDETAILTYPE = "ANALYSE_SHOWDETAILTYPE";
    private String ANALYSE_BEGIN_PERIOD_ID = "ANALYSE_BEGIN_PERIOD_ID";
    private String ANALYSE_END_PERIOD_ID = "ANALYSE_END_PERIOD_ID";
    private String ANALYSE_BGPERIOD_IDS = "ANALYSE_BGPERIOD_IDS";
    private String ANALYSE_CURRENCY_ID = "ANALYSE_CURRENCY_ID";
    private String ANALYSE_ELEMENT_ID = "ANALYSE_ELEMENT_ID";
    private String ANALYSE_BGSCENARIO_ID = "ANALYSE_BGSCENARIO_ID";
    protected boolean isContainSealUp = false;
    protected boolean isOnlySelf = false;
    private OrgUnitInfo unitInfo = SysContext.getSysContext().getCurrentOrgUnit();
    private CtrlUnitInfo CU = SysContext.getSysContext().getCurrentCtrlUnit();
    private CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
    private BgCellRenderHelper cellHelper = new BgCellRenderHelper();
    String accountViewId = null;

    public BgCellRenderHelper getCellHelper() {
        return this.cellHelper;
    }

    public MBgAnalyseExeFilterUI() throws Exception {
        this.init();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initResponsibilityCenter();
        this.initBgScheme();
        this.getCellHelper().init();
        this.kDMember.getColumn(COL_REF_MEMBERS).setRenderer((IBasicRender)BgCellRenderHelper.getMemberComRender());
    }

    private void initBgScenario() throws Exception {
        this.prmtScenario.setRequired(false);
        Set<String> scenarioID = MbgAnalyseExeHelper.getBgScenarioID((BgSchemeInfo)this.prmtScheme.getData());
        EntityViewInfo view = this.prmtScenario.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", scenarioID, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtScenario.setEntityViewInfo(view);
    }

    private void initResponsibilityCenter() {
        BgOrgViewF7 orgView = new BgOrgViewF7((IUIObject)this);
        orgView.setTitle(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgBaseResource", (String)"selectOrgUnit"));
        orgView.setRootUnitID(this.CU.getId().toString());
        orgView.setMultiSelect(false);
        orgView.setContainSealUp(true);
        if (this.getOwnerUi() instanceof MBgAnalyseExeUI) {
            MBgAnalyseExeUI ui = (MBgAnalyseExeUI)this.getOwnerUi();
            orgView.setUIActionPK(ui.getMetaDataPK(), (IMetaDataPK)MetaDataPK.create((String)"ActionOnLoad"));
        }
        this.prmtOrgUnit.setData((Object)this.unitInfo);
        this.prmtOrgUnit.setSelector((KDPromptSelector)orgView);
    }

    @Override
    protected void prmtOrgUnit_willShow(SelectorEvent e) throws Exception {
        super.prmtOrgUnit_willShow(e);
        BgOrgViewF7 f7 = (BgOrgViewF7)this.prmtOrgUnit.getSelector();
        Set<BOSUuid> selectedOrgIds = this.getSelectedOrgIds();
        f7.setSelectedOrgIds(selectedOrgIds);
    }

    private Set<BOSUuid> getSelectedOrgIds() {
        HashSet<BOSUuid> selectedOrgIds;
        block3: {
            Object data;
            block4: {
                block2: {
                    data = this.prmtOrgUnit.getData();
                    selectedOrgIds = new HashSet<BOSUuid>();
                    if (data == null || !(data instanceof OrgUnitInfo)) break block2;
                    OrgUnitInfo orgUnit = (OrgUnitInfo)data;
                    selectedOrgIds.add(orgUnit.getId());
                    break block3;
                }
                if (data == null || !(data instanceof OrgUnitInfo[])) break block4;
                OrgUnitInfo[] orgUnits = (OrgUnitInfo[])data;
                for (int i = 0; i < orgUnits.length; ++i) {
                    selectedOrgIds.add(orgUnits[i].getId());
                }
                break block3;
            }
            if (data == null || !(data instanceof List)) break block3;
            List orgUnits = (List)data;
            for (OrgUnitInfo orgUnitInfo : orgUnits) {
                selectedOrgIds.add(orgUnitInfo.getId());
            }
        }
        return selectedOrgIds;
    }

    protected void setBgSchemeFilter() throws Exception {
        Object data = this.prmtOrgUnit.getData();
        if (data != null && data instanceof OrgUnitInfo) {
            OrgUnitInfo orgUnit = (OrgUnitInfo)data;
            try {
                BgNFCHelper.initPrmpPermitedBgschemeInfo((KDBizPromptBox)this.prmtScheme, (OrgUnitInfo)orgUnit, (boolean)this.isOnlySelf, (RptSrcTypeEnum)BgNFCHelper.getSourceType((IUIObject)this), (boolean)false, (boolean)false, (boolean)true);
                if (this.prmtScheme.getData() == null) {
                    this.prmtBgOrgUnit.setDataNoNotify(null);
                }
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else if (data != null && data instanceof OrgUnitInfo[]) {
            OrgUnitInfo[] orgUnits = (OrgUnitInfo[])data;
            BOSUuid[] orgUnitIds = new BOSUuid[orgUnits.length];
            for (int i = 0; i < orgUnits.length; ++i) {
                orgUnitIds[i] = orgUnits[i].getId();
            }
            try {
                BgNFCHelper.initPrmpPermitedBgschemeInfo((KDBizPromptBox)this.prmtScheme, (OrgUnitInfo[])orgUnits, (boolean)this.isOnlySelf, (RptSrcTypeEnum)BgNFCHelper.getSourceType((IUIObject)this), (boolean)false, (boolean)false, (boolean)true);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else if (data == null || data instanceof BgOrgUnitInfo) {
            // empty if block
        }
    }

    public RptSrcTypeEnum getSourceType() {
        return RptSrcTypeEnum.PT_BUDGET_REPORT;
    }

    protected void init() {
        this.kDMember.checkParsed();
        this.kDMember.addRow();
        this.initBgScheme();
    }

    protected void initBgScheme() {
        this.prmtScheme.setEditable(false);
        this.prmtScheme.setEnabledMultiSelection(false);
        this.prmtScheme.setHistoryRecordEnabled(false);
    }

    protected void initDimMember() {
        KDBizPromptBox prmt = new KDBizPromptBox();
        prmt.setEditable(false);
        prmt.setSelector((KDPromptSelector)this.initMBgIndexF7());
        this.kDMember.getColumn(0).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmt));
        prmt = new KDBizPromptBox();
        prmt.setEditable(false);
        prmt.setSelector((KDPromptSelector)this.initDimensionMemberSelectDialog());
        this.kDMember.getColumn(COL_REF_MEMBERS).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmt));
    }

    protected NewDimensionMemberSelectDialog initMBgIndexF7() {
        BgDimensionInfo dimension = new BgDimensionInfo(null);
        dimension.setNumber(DimensionConstants.DEF_INDEX_NUMBER);
        NewDimensionMemberSelectDialog dialog = new NewDimensionMemberSelectDialog();
        if (this.prmtScheme.getData() instanceof BgSchemeInfo) {
            dialog.setBgSchemeId(((BgSchemeInfo)this.prmtScheme.getData()).getId().toString());
        } else {
            dialog.setBgSchemeId("#");
        }
        dialog.setDimension((Object)dimension);
        dialog.setMulti(true);
        return dialog;
    }

    protected NewDimensionMemberSelectDialog initDimensionMemberSelectDialog() {
        String[] orgUnitIds = null;
        Object obj = this.prmtOrgUnit.getData();
        if (obj != null) {
            Object[] objs = DimensionCommonHelper.getValues((Object)obj);
            orgUnitIds = new String[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                if (objs[i] instanceof BgOrgUnitInfo) {
                    orgUnitIds[i] = ((BgOrgUnitInfo)obj).getId().toString();
                    continue;
                }
                if (!(objs[i] instanceof OrgUnitInfo)) continue;
                orgUnitIds[i] = ((OrgUnitInfo)objs[i]).getId().toString();
            }
        }
        if (orgUnitIds == null) {
            return null;
        }
        NewDimensionMemberSelectDialog dialog = null;
        if (orgUnitIds.length > 1) {
            dialog = new NewDimensionMemberSelectDialog((Component)((Object)this), (BgDimensionBaseInfo)((BgDimensionInfo)null), null, false, true);
            dialog.setCanntFilterOrg(true);
        } else {
            dialog = new NewDimensionMemberSelectDialog((Component)((Object)this), (BgDimensionBaseInfo)((BgDimensionInfo)null), orgUnitIds[0], false, true);
        }
        dialog.setOrgUnitIds(orgUnitIds);
        dialog.setOnlyRefDim(true);
        dialog.setOnlySelectItem(true);
        dialog.setMustAllDim(false);
        if (this.prmtScheme.getData() instanceof BgSchemeInfo) {
            dialog.setBgSchemeId(((BgSchemeInfo)this.prmtScheme.getData()).getId().toString());
        } else {
            dialog.setBgSchemeId("#");
        }
        return dialog;
    }

    protected void initPeriod() {
        if (this.prmtBgPeriod.getSelector() instanceof DataChangeListener) {
            this.prmtBgPeriod.removeDataChangeListener((DataChangeListener)this.prmtBgPeriod.getSelector());
        }
        this.prmtBgPeriod.setEditable(false);
        BgPeriodDialog dialog = new BgPeriodDialog((CoreUIObject)this);
        dialog.setBgPeriodBeginDate(((BgSchemeInfo)this.prmtScheme.getData()).getDateFrom());
        dialog.setBgPeriodEndDate(((BgSchemeInfo)this.prmtScheme.getData()).getDateTo());
        dialog.setMultiSelect(true);
        dialog.setBgSchemeID(((BgSchemeInfo)this.prmtScheme.getData()).getId().toString());
        this.prmtBgPeriod.setSelector((KDPromptSelector)dialog);
        this.prmtBgPeriod.addDataChangeListener((DataChangeListener)dialog);
    }

    protected void initCurrency() throws Exception {
        this.prmtCurrency.setEditable(false);
        Set<String> currencyID = MbgAnalyseExeHelper.getCurrencyID((BgSchemeInfo)this.prmtScheme.getData());
        EntityViewInfo view = this.prmtCurrency.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", currencyID, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtCurrency.setEntityViewInfo(view);
    }

    protected void initMbgElement() throws Exception {
        this.prmtBgElement.setEditable(false);
        Set<String> elementID = MbgAnalyseExeHelper.getElementID((BgSchemeInfo)this.prmtScheme.getData());
        EntityViewInfo view = this.prmtBgElement.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", elementID, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtBgElement.setEntityViewInfo(view);
    }

    protected boolean isMultiSelect() {
        return true;
    }

    @Override
    protected void kDMember_editStopped(KDTEditEvent e) throws Exception {
        List indexMembers;
        Object value = e.getValue();
        if (COL_INDEX_MEMBERS.equals(this.kDMember.getColumnKey(e.getColIndex())) && value instanceof List && (indexMembers = (List)value) != null && indexMembers.size() > 1) {
            IRow sourceRow = this.kDMember.getRow(e.getRowIndex());
            IRow row = null;
            ArrayList<BgDimensionMember> newMembers = null;
            for (int i = 0; i < indexMembers.size(); ++i) {
                if (i != 0) {
                    row = this.kDMember.addRow(e.getRowIndex() + i);
                    this.copyRow(sourceRow, row);
                } else {
                    row = sourceRow;
                }
                newMembers = new ArrayList<BgDimensionMember>();
                newMembers.add((BgDimensionMember)indexMembers.get(i));
                this.setIndexMember(row, newMembers);
            }
        }
    }

    private void setIndexMember(IRow row, List<BgDimensionMember> newMembers) {
        row.getCell(COL_INDEX_MEMBERS).setValue((Object)this.displayMembers(newMembers));
        row.getCell(COL_INDEX_MEMBERS).setUserObject(newMembers);
    }

    private String displayMembers(List<BgDimensionMember> members) {
        if (members == null || members.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (BgDimensionMember bgDimensionMember : members) {
            if (this.accountViewId == null && this.prmtScheme.getData() instanceof BgSchemeInfo) {
                this.accountViewId = BgCellRenderHelper.getAccountViewIdByBgScheme((BgSchemeInfo)((BgSchemeInfo)this.prmtScheme.getData()));
            }
            if (this.accountViewId != null) {
                sb.append(this.getCellHelper().getIndexDisplayName(this.accountViewId, bgDimensionMember)).append(",");
                continue;
            }
            sb.append(bgDimensionMember.getNumber()).append("(").append(bgDimensionMember.getName()).append(")").append(",");
        }
        sb = sb.deleteCharAt(sb.toString().lastIndexOf(","));
        return sb.toString();
    }

    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtOrgUnit.getData() == null) {
            this.prmtOrgUnit.setDataNoNotify(e.getOldValue());
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"isNullCostCenter"));
        } else if (!DimensionCommonHelper.isEqualsPrmt((Object)e.getNewValue(), (Object)e.getOldValue())) {
            this.setBgSchemeFilter();
            this.initDimMember();
        }
    }

    @Override
    protected void prmtScheme_willShow(SelectorEvent e) throws Exception {
        super.prmtScheme_willShow(e);
        BgViewClientHelper.prmtScheme_willShow((Component)((Object)this), (KDBizPromptBox)this.prmtOrgUnit);
    }

    @Override
    protected void prmtScheme_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() != null && e.getOldValue() != null && e.getNewValue() instanceof BgSchemeInfo && ((BgSchemeInfo)e.getNewValue()).getId().equals((Object)((BgSchemeInfo)e.getOldValue()).getId())) {
            return;
        }
        if (e.getNewValue() == null && e.getOldValue() != null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"isNullBgScheme"));
            this.prmtScheme.setDataNoNotify(e.getOldValue());
            return;
        }
        this.kDMember.removeRows();
        if (this.prmtScheme.getData() != null) {
            this.resetDisplayFormatter();
            FilterInfo filter = MbgPermissionHelper.addBgSchemePermission((RptSrcTypeEnum)BgNFCHelper.getSourceType((IUIObject)this), (String)SysContext.getSysContext().getCurrentUserInfo().getId().toString(), (FilterInfo)this.prmtScheme.getEntityViewInfo().getFilter());
            this.prmtScheme.getEntityViewInfo().setFilter(filter);
            this.initDimMember();
            this.initBgScenario();
            this.initPeriod();
            this.initCurrency();
            this.initMbgElement();
        }
        this.prmtBgPeriod.setData(null);
        this.prmtCurrency.setData(null);
        this.prmtBgElement.setData(null);
        this.prmtScenario.setData(null);
        this.accountViewId = null;
        if (e.getNewValue() instanceof BgSchemeInfo) {
            this.accountViewId = BgCellRenderHelper.getAccountViewIdByBgScheme((BgSchemeInfo)((BgSchemeInfo)e.getNewValue()));
        }
        this.kDMember.getColumn(COL_INDEX_MEMBERS).setRenderer((IBasicRender)this.getCellHelper().getOVRender(this.accountViewId));
        this.prmtBgOrgUnit.setData(null);
        this.setOrgUnitFilter();
    }

    private void resetDisplayFormatter() {
        this.prmtBgPeriod.setData(null);
        this.prmtBgPeriod.setDisplayFormat("$name$");
    }

    public BgSchemeInfo getSelectBgScheme() {
        if (this.prmtScheme.getData() instanceof BgSchemeInfo) {
            return (BgSchemeInfo)this.prmtScheme.getData();
        }
        return null;
    }

    protected String getBgOrgUnitViewId() throws Exception {
        String bgOrgViewId = null;
        if (this.prmtScheme.getData() instanceof BgSchemeInfo) {
            BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.prmtScheme.getData();
            bgOrgViewId = MbgAnalyseExeHelper.getBudgetViewID(bgSchemeInfo);
        }
        return bgOrgViewId;
    }

    protected BgPeriodInfo[] getSchemePeriod(BgSchemeInfo bgSchemeInfo) throws Exception {
        if (bgSchemeInfo == null) {
            return null;
        }
        return (BgPeriodInfo[])this.getInterface().getSchemePeriod(bgSchemeInfo.getId());
    }

    @Override
    protected void btnAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddLine_actionPerformed(e);
        this.checkBgScheme();
        this.kDMember.addRow();
    }

    @Override
    protected void btnCopyLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnCopyLine_actionPerformed(e);
        int rowIndex = this.kDMember.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0) {
            IRow srcRow = this.kDMember.getRow(rowIndex);
            IRow row = this.kDMember.addRow(rowIndex + 1);
            this.copyRow(srcRow, row);
        }
    }

    protected void copyRow(IRow srcRow, IRow row) {
        if (row != null && srcRow != null) {
            if (srcRow.getCell(COL_INDEX_MEMBERS).getValue() != null) {
                row.getCell(COL_INDEX_MEMBERS).setValue(srcRow.getCell(COL_INDEX_MEMBERS).getValue());
                row.getCell(COL_INDEX_MEMBERS).setUserObject(srcRow.getCell(COL_INDEX_MEMBERS).getUserObject());
            }
            if (srcRow.getCell(COL_REF_MEMBERS).getValue() != null) {
                row.getCell(COL_REF_MEMBERS).setValue(srcRow.getCell(COL_REF_MEMBERS).getValue());
            }
        }
    }

    @Override
    protected void btnDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnDeleteLine_actionPerformed(e);
        ArrayList blocks = this.kDMember.getSelectManager().getBlocks();
        if (blocks != null) {
            KDTSelectBlock _block = null;
            int in = blocks.size();
            for (int i = 0; i < in; ++i) {
                _block = (KDTSelectBlock)blocks.get(i);
                if (_block == null) continue;
                int jn = _block.getBeginRow();
                for (int j = _block.getEndRow(); j >= jn; --j) {
                    this.kDMember.removeRow(j);
                }
            }
        }
    }

    @Override
    protected void btnFromSelect_actionPerformed(ActionEvent e) throws Exception {
        List<String> formulas;
        String bgSchemeRootId;
        this.checkBgScheme();
        super.btnFromSelect_actionPerformed(e);
        List<OrgUnitInfo> orgUnits = this.getBgOrgUnit();
        if (orgUnits.isEmpty()) {
            this.prmtOrgUnit.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)this.getResourceStr(), (String)"selectOrgUnit"));
            return;
        }
        String string = bgSchemeRootId = this.getSelectBgScheme() != null ? this.getSelectBgScheme().getId().toString() : null;
        if (StringUtils.isEmpty((String)bgSchemeRootId)) {
            this.prmtScheme.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)this.getResourceStr(), (String)"selectBgScheme"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)BgBaseConstants.ORGUNIT_IDS, orgUnits);
        uiContext.put((Object)BgBaseConstants.BGSCHEME_ID, (Object)bgSchemeRootId);
        uiContext.put((Object)"BGSCHEME_ORGUNIT_ID", (Object)this.getBgOrgUnitViewId());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getFormSelectUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        MbgAnalyseExeBlockSetUI ui = (MbgAnalyseExeBlockSetUI)uiWindow.getUIObject();
        if (!ui.isHasCancel() && (formulas = ui.getData()) != null) {
            String[] params = null;
            HashSet<String> dimItemSet = new HashSet<String>();
            for (String formulaStr : formulas) {
                params = BgNFSHelper.parseFormulaPara((String)formulaStr);
                dimItemSet.add(params[0]);
            }
            ArrayList dimItems = new ArrayList(dimItemSet);
            List result = MBgAnalyseFacadeFactory.getRemoteInstance().getAnalyseMember(bgSchemeRootId, orgUnits.get(0).getId(), dimItems);
            if (result != null) {
                IRow row = null;
                String key = null;
                BgDimensionMember _bgMember = null;
                List<BgDimensionMember> tmpList = null;
                HashSet<String> keySet = new HashSet<String>();
                int in = this.kDMember.getRowCount();
                for (int i = 0; i < in; ++i) {
                    row = this.kDMember.getRow(i);
                    key = "";
                    tmpList = this.getIndexMember(row);
                    if (tmpList != null && !tmpList.isEmpty()) {
                        _bgMember = tmpList.get(0);
                        key = key + _bgMember.getSrcNumber() + ":" + _bgMember.getNumber();
                    }
                    if (row.getCell(COL_REF_MEMBERS) != null && row.getCell(COL_REF_MEMBERS).getValue() != null) {
                        _bgMember = (BgDimensionMember)row.getCell(COL_REF_MEMBERS).getValue();
                        key = key + "," + _bgMember.getSrcNumber() + ":" + _bgMember.getNumber();
                    }
                    keySet.add(key);
                }
                for (AnalyseMember member : result) {
                    key = member.getBgIndex().getSrcNumber() + ":" + member.getBgIndex().getNumber();
                    if (member.getDimMember() != null) {
                        key = key + "," + member.getDimMember().getSrcNumber() + ":" + member.getDimMember().getNumber();
                    }
                    if (keySet.contains(key)) continue;
                    row = this.kDMember.addRow();
                    if (member.getBgIndex() != null) {
                        tmpList = new ArrayList<BgDimensionMember>();
                        tmpList.add(member.getBgIndex());
                        row.getCell(COL_INDEX_MEMBERS).setValue(tmpList);
                    }
                    if (member.getDimMember() == null) continue;
                    row.getCell(COL_REF_MEMBERS).setValue((Object)member.getDimMember());
                }
            }
        }
    }

    protected List<OrgUnitInfo> getBgOrgUnit() {
        ArrayList<OrgUnitInfo> orgUnits = new ArrayList<OrgUnitInfo>();
        if (this.prmtBgOrgUnit.getData() instanceof BgOrgUnitInfo[]) {
            BgOrgUnitInfo[] _orgUnits = (BgOrgUnitInfo[])this.prmtBgOrgUnit.getData();
            int in = _orgUnits.length;
            for (int i = 0; i < in; ++i) {
                orgUnits.add((OrgUnitInfo)_orgUnits[i].castToFullOrgUnitInfo());
            }
        } else if (this.prmtBgOrgUnit.getData() instanceof BgOrgUnitInfo) {
            BgOrgUnitInfo _orgUnit = (BgOrgUnitInfo)this.prmtBgOrgUnit.getData();
            orgUnits.add((OrgUnitInfo)_orgUnit.castToFullOrgUnitInfo());
        }
        return orgUnits;
    }

    protected String getFormSelectUIName() {
        return MbgAnalyseExeBlockSetUI.class.getName();
    }

    @Override
    protected void prmtCurrency_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCurrency_dataChanged(e);
    }

    @Override
    protected void prmtBgElement_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgElement_dataChanged(e);
    }

    public boolean verify() {
        boolean re = super.verify();
        if (re) {
            if (this.prmtScheme.getData() == null) {
                this.prmtScheme.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)this.getResourceStr(), (String)"selectBgScheme"));
                re = false;
            }
            if (re && this.prmtBgOrgUnit.getData() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgDataQueryResource", (String)"msgCheckSelect", (Object[])new Object[]{this.contBgOrgUnit.getBoundLabelText()}));
                re = false;
            }
            if (re && this.kDMember.getRowCount() != 0) {
                ICell cell = null;
                int in = this.kDMember.getRowCount();
                for (int i = 0; i < in; ++i) {
                    cell = this.kDMember.getCell(i, COL_INDEX_MEMBERS);
                    if (cell.getValue() != null) continue;
                    this.kDMember.getEditManager().editCellAt(i, this.kDMember.getColumnIndex(COL_INDEX_MEMBERS));
                    MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)this.getResourceStr(), (String)"selectBgIndex"));
                    re = false;
                    break;
                }
            }
            if (re && this.prmtBgPeriod.getData() == null) {
                this.prmtBgPeriod.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)this.getResourceStr(), (String)"selectBgPeriod"));
                re = false;
            }
        }
        return re;
    }

    protected FilterParam createFilterParam() {
        return new ExeFilterParam();
    }

    protected void loadCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.loadCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof ExeFilterParam)) {
            return;
        }
        String id = null;
        List members = null;
        ArrayList bgPeriodIds = new ArrayList();
        ExeFilterParam _filterParam = (ExeFilterParam)filterParam;
        id = cp.getCustomerParam(this.ANALYSE_SCHEME_ID);
        if (!StringUtils.isEmpty((String)id)) {
            _filterParam.setBgScheme(new BgSchemeInfo());
            _filterParam.getBgScheme().setId(BOSUuid.read((String)id));
        } else {
            _filterParam.setBgScheme(null);
        }
        members = (List)BgAnalyseHelper.getObject((byte[])BgAnalyseHelper.decode((String)cp.getCustomerParam(this.ANALYSE_MEMBER)));
        if (members != null) {
            _filterParam.getMembers().addAll(members);
        } else {
            _filterParam.getMembers().clear();
        }
        id = cp.getCustomerParam(this.ANALYSE_SHOWDETAILTYPE);
        if (!StringUtils.isEmpty((String)id)) {
            _filterParam.setShowDetailOfEmptyMember(Boolean.parseBoolean(id));
        } else {
            _filterParam.setShowDetailOfEmptyMember(true);
        }
        bgPeriodIds = (ArrayList)BgAnalyseHelper.decodeObject((String)cp.getCustomerParam("ANALYSE_BGPERIOD_IDS"));
        if (bgPeriodIds != null && !bgPeriodIds.isEmpty()) {
            BgPeriodInfo[] bgPeriodInfos = new BgPeriodInfo[bgPeriodIds.size()];
            for (int i = 0; i < bgPeriodIds.size(); ++i) {
                bgPeriodInfos[i] = new BgPeriodInfo();
                bgPeriodInfos[i].setId(BOSUuid.read((String)((String)bgPeriodIds.get(i))));
            }
            _filterParam.setBgPeriods(bgPeriodInfos);
        } else {
            _filterParam.setBgPeriods(null);
        }
        id = cp.getCustomerParam(this.ANALYSE_BEGIN_PERIOD_ID);
        if (!StringUtils.isEmpty((String)id)) {
            _filterParam.setBeginPeriod(new BgPeriodInfo());
            _filterParam.getBeginPeriod().setId(BOSUuid.read((String)id));
        } else {
            _filterParam.setBeginPeriod(null);
        }
        id = cp.getCustomerParam(this.ANALYSE_END_PERIOD_ID);
        if (!StringUtils.isEmpty((String)id)) {
            _filterParam.setEndPeriod(new BgPeriodInfo());
            _filterParam.getEndPeriod().setId(BOSUuid.read((String)id));
        } else {
            _filterParam.setEndPeriod(null);
        }
        id = cp.getCustomerParam(this.ANALYSE_CURRENCY_ID);
        if (!StringUtils.isEmpty((String)id)) {
            _filterParam.setCurrency(new CurrencyInfo());
            _filterParam.getCurrency().setId(BOSUuid.read((String)id));
        } else {
            _filterParam.setCurrency(null);
        }
        id = cp.getCustomerParam(this.ANALYSE_ELEMENT_ID);
        if (!StringUtils.isEmpty((String)id)) {
            _filterParam.setBgElement(new BgElementInfo());
            _filterParam.getBgElement().setId(BOSUuid.read((String)id));
        } else {
            _filterParam.setBgElement(null);
        }
        id = cp.getCustomerParam(this.ANALYSE_BGSCENARIO_ID);
        if (!StringUtils.isEmpty((String)id)) {
            _filterParam.setBgScenario(new BgScenarioInfo());
            _filterParam.getBgScenario().setId(BOSUuid.read((String)id));
        } else {
            _filterParam.setBgScenario(null);
        }
    }

    protected void saveCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.saveCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof ExeFilterParam)) {
            return;
        }
        ArrayList<String> bgPeriodIds = null;
        ExeFilterParam _filterParam = (ExeFilterParam)filterParam;
        if (_filterParam.getBgScheme() != null) {
            cp.addCustomerParam(this.ANALYSE_SCHEME_ID, _filterParam.getBgScheme().getId().toString());
        } else {
            cp.removeCustomerParam(this.ANALYSE_SCHEME_ID);
        }
        if (_filterParam.getBgOrgUnits() != null) {
            cp.addCustomerParam(this.ANALYSE_SCHEME_ID, _filterParam.getBgScheme().getId().toString());
        } else {
            cp.removeCustomerParam(this.ANALYSE_SCHEME_ID);
        }
        cp.addCustomerParam(this.ANALYSE_SHOWDETAILTYPE, Boolean.toString(_filterParam.isShowDetailOfEmptyMember()));
        if (_filterParam.getBgPeriods().length != 0) {
            bgPeriodIds = new ArrayList<String>();
            for (BgPeriodInfo bg : _filterParam.getBgPeriods()) {
                bgPeriodIds.add(bg.getId().toString());
            }
            cp.addCustomerParam(this.ANALYSE_BGPERIOD_IDS, BgAnalyseHelper.encode((byte[])BgAnalyseHelper.getBytes(bgPeriodIds)));
        } else {
            cp.removeCustomerParam(this.ANALYSE_BGPERIOD_IDS);
        }
        if (!_filterParam.getMembers().isEmpty()) {
            cp.addCustomerParam(this.ANALYSE_MEMBER, BgAnalyseHelper.encode((byte[])BgAnalyseHelper.getBytes(_filterParam.getMembers())));
        } else {
            cp.removeCustomerParam(this.ANALYSE_MEMBER);
        }
        if (_filterParam.getBeginPeriod() != null) {
            cp.addCustomerParam(this.ANALYSE_BEGIN_PERIOD_ID, _filterParam.getBeginPeriod().getId().toString());
        } else {
            cp.removeCustomerParam(this.ANALYSE_BEGIN_PERIOD_ID);
        }
        if (_filterParam.getEndPeriod() != null) {
            cp.addCustomerParam(this.ANALYSE_END_PERIOD_ID, _filterParam.getEndPeriod().getId().toString());
        } else {
            cp.removeCustomerParam(this.ANALYSE_END_PERIOD_ID);
        }
        if (_filterParam.getCurrency() != null) {
            cp.addCustomerParam(this.ANALYSE_CURRENCY_ID, _filterParam.getCurrency().getId().toString());
        } else {
            cp.removeCustomerParam(this.ANALYSE_CURRENCY_ID);
        }
        if (_filterParam.getBgElement() != null) {
            cp.addCustomerParam(this.ANALYSE_ELEMENT_ID, _filterParam.getBgElement().getId().toString());
        } else {
            cp.removeCustomerParam(this.ANALYSE_ELEMENT_ID);
        }
        if (_filterParam.getBgScenario() != null) {
            cp.addCustomerParam(this.ANALYSE_BGSCENARIO_ID, _filterParam.getBgScenario().getId().toString());
        } else {
            cp.removeCustomerParam(this.ANALYSE_BGSCENARIO_ID);
        }
    }

    @Override
    protected void prmtBgPeriod_dataChanged(DataChangeEvent e) throws Exception {
        this.setBgPeriodAliasDisp();
    }

    private void setBgPeriodAliasDisp() throws EASBizException, BOSException {
        if (this.prmtOrgUnit.getData() != null && this.prmtScheme.getData() != null && this.prmtBgPeriod.getData() != null && this.prmtOrgUnit.getData() instanceof OrgUnitInfo[] && ((OrgUnitInfo[])this.prmtOrgUnit.getData()).length == 1) {
            OrgUnitInfo _orgUnit = ((OrgUnitInfo[])this.prmtOrgUnit.getData())[0];
            String orgUnitId = _orgUnit.getId().toString();
            MbgAnalyseExeHelper.addDispNameForPeriods((Object[])this.prmtBgPeriod.getData(), (BgSchemeInfo)this.prmtScheme.getData());
            BgNFCHelper.setBgPeriodF7Display(null, (KDBizPromptBox)this.prmtBgPeriod, (KDBizPromptBox)this.prmtScheme, (String)orgUnitId);
        }
    }

    protected void loadFromParams(FilterParam filterParam) {
        super.loadFromParams(filterParam);
        if (!(filterParam instanceof BaseFilterParam)) {
            return;
        }
        BaseFilterParam _filterParam1 = (BaseFilterParam)filterParam;
        if (!_filterParam1.getOrgUnits().isEmpty()) {
            OrgUnitInfo[] orgUnits = new OrgUnitInfo[_filterParam1.getOrgUnits().size()];
            int in = _filterParam1.getOrgUnits().size();
            for (int i = 0; i < in; ++i) {
                orgUnits[i] = (OrgUnitInfo)_filterParam1.getOrgUnits().get(i);
            }
            this.prmtOrgUnit.setData((Object)orgUnits);
        } else {
            this.prmtOrgUnit.setData(null);
        }
        if (!(filterParam instanceof ExeFilterParam)) {
            return;
        }
        ExeFilterParam _filterParam = (ExeFilterParam)filterParam;
        this.prmtScheme.setData((Object)_filterParam.getBgScheme());
        if (_filterParam.isShowDetailOfEmptyMember()) {
            this.rdoShowDetail.setSelected(true);
        } else {
            this.rdoShowSum.setSelected(true);
        }
        IRow row = null;
        AnalyseMember member = null;
        ArrayList<BgDimensionMember> members = null;
        this.kDMember.removeRows();
        int in = _filterParam.getMembers().size();
        for (int i = 0; i < in; ++i) {
            member = _filterParam.getMembers().get(i);
            row = this.kDMember.addRow();
            if (member.getBgIndex() != null) {
                members = new ArrayList<BgDimensionMember>();
                members.add(member.getBgIndex());
                row.getCell(COL_INDEX_MEMBERS).setValue(members);
            }
            if (member.getDimMember() == null) continue;
            row.getCell(COL_REF_MEMBERS).setValue((Object)member.getDimMember());
        }
        if (_filterParam.getBgOrgUnits() != null) {
            BgOrgUnitInfo[] bgOrgUnitsTemp = _filterParam.getBgOrgUnits();
            BgOrgUnitInfo[] bgOrgUnits = new BgOrgUnitInfo[_filterParam.getBgOrgUnits().length];
            int in2 = _filterParam.getBgOrgUnits().length;
            for (int i = 0; i < in2; ++i) {
                bgOrgUnits[i] = bgOrgUnitsTemp[i];
            }
            this.prmtBgOrgUnit.setDataNoNotify((Object)bgOrgUnits);
        } else {
            this.prmtBgOrgUnit.setDataNoNotify(null);
        }
        this.prmtBgPeriod.setData((Object)_filterParam.getBgPeriods());
        this.prmtCurrency.setData((Object)_filterParam.getCurrency());
        this.prmtBgElement.setData((Object)_filterParam.getBgElement());
        this.prmtScenario.setData((Object)_filterParam.getBgScenario());
    }

    protected void saveToParams(FilterParam filterParam) {
        super.saveToParams(filterParam);
        if (!(filterParam instanceof ExeFilterParam)) {
            return;
        }
        ExeFilterParam _filterParam = (ExeFilterParam)filterParam;
        if (this.prmtScheme.getData() instanceof BgSchemeInfo) {
            _filterParam.setBgScheme((BgSchemeInfo)this.prmtScheme.getData());
        } else {
            _filterParam.setBgScheme(null);
        }
        _filterParam.setShowDetailOfEmptyMember(this.rdoShowDetail.isSelected());
        _filterParam.getMembers().clear();
        if (this.kDMember.getRowCount() > 0) {
            IRow row = null;
            AnalyseMember member = null;
            List<BgDimensionMember> members = null;
            int in = this.kDMember.getRowCount();
            for (int i = 0; i < in; ++i) {
                row = this.kDMember.getRow(i);
                member = new AnalyseMember();
                members = this.getIndexMember(row);
                if (members != null && !members.isEmpty()) {
                    member.setBgIndex(members.get(0));
                } else {
                    member.setBgIndex(null);
                }
                if (row.getCell(COL_REF_MEMBERS).getValue() != null) {
                    member.setDimMember((BgDimensionMember)row.getCell(COL_REF_MEMBERS).getValue());
                }
                _filterParam.getMembers().add(member);
            }
        }
        if (this.prmtBgOrgUnit.getData() instanceof BgOrgUnitInfo[]) {
            BgOrgUnitInfo[] orgUnits = (BgOrgUnitInfo[])this.prmtBgOrgUnit.getData();
            _filterParam.setBgOrgUnits(orgUnits);
        } else if (this.prmtBgOrgUnit.getData() instanceof BgOrgUnitInfo) {
            BgOrgUnitInfo _orgUnit = (BgOrgUnitInfo)this.prmtBgOrgUnit.getData();
            BgOrgUnitInfo[] orgUnits = new BgOrgUnitInfo[]{_orgUnit};
            _filterParam.setBgOrgUnits(orgUnits);
        }
        if (this.prmtBgPeriod.getData() instanceof BgPeriodInfo[]) {
            _filterParam.setBgPeriods((BgPeriodInfo[])this.prmtBgPeriod.getData());
        } else {
            _filterParam.setEndPeriod(null);
        }
        if (this.prmtCurrency.getData() instanceof CurrencyInfo) {
            _filterParam.setCurrency((CurrencyInfo)this.prmtCurrency.getData());
        } else {
            _filterParam.setCurrency(null);
        }
        if (this.prmtBgElement.getData() instanceof BgElementInfo) {
            _filterParam.setBgElement((BgElementInfo)this.prmtBgElement.getData());
        } else {
            _filterParam.setBgElement(null);
        }
        if (this.prmtScenario.getData() instanceof BgScenarioInfo) {
            _filterParam.setBgScenario((BgScenarioInfo)this.prmtScenario.getData());
        } else {
            _filterParam.setBgScenario(null);
        }
    }

    protected List<BgDimensionMember> getIndexMember(IRow row) {
        List members = row.getCell(COL_INDEX_MEMBERS).getValue() instanceof List ? (List)row.getCell(COL_INDEX_MEMBERS).getValue() : (row.getCell(COL_INDEX_MEMBERS).getUserObject() instanceof List ? (List)row.getCell(COL_INDEX_MEMBERS).getUserObject() : null);
        return members;
    }

    public void clear() {
        super.clear();
        this.prmtScheme.setDataNoNotify(null);
        this.prmtOrgUnit.setData((Object)SysContext.getSysContext().getCurrentCostUnit());
        try {
            this.setBgSchemeFilter();
            this.setOrgUnitFilter();
        }
        catch (Exception e1) {
            logger.error((Object)"", (Throwable)e1);
        }
        this.kDMember.removeRows();
        this.rdoShowDetail.setSelected(true);
        this.prmtBgPeriod.setData(null);
        this.prmtCurrency.setData(null);
        this.prmtBgElement.setData(null);
        this.prmtScenario.setData(null);
    }

    @Override
    protected void prmtScenario_willShow(SelectorEvent e) throws Exception {
        this.checkBgScheme();
    }

    @Override
    protected void prmtBgPeriod_willShow(SelectorEvent e) throws Exception {
        this.checkBgScheme();
    }

    @Override
    protected void prmtCurrency_willShow(SelectorEvent e) throws Exception {
        this.checkBgScheme();
    }

    @Override
    protected void prmtBgElement_willShow(SelectorEvent e) throws Exception {
        this.checkBgScheme();
    }

    private void checkBgScheme() {
        if (this.prmtScheme.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)this.getResourceStr(), (String)"selectBgScheme"));
            SysUtil.abort();
        }
    }

    @Override
    protected void prmtBgOrgUnit_willShow(SelectorEvent e) throws Exception {
        super.prmtBgOrgUnit_willShow(e);
        Object data = this.prmtScheme.getData();
        if (data == null) {
            this.prmtScheme.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)this.getResourceStr(), (String)"selectBgScheme"));
            e.setCanceled(true);
            return;
        }
        KDPromptSelector selector = this.prmtBgOrgUnit.getSelector();
        if (selector instanceof BgViewOrgDimensionF7) {
            BgViewOrgDimensionF7 f7 = (BgViewOrgDimensionF7)selector;
            HashSet<BgOrgUnitInfo> orgs = new HashSet<BgOrgUnitInfo>();
            if (this.prmtBgOrgUnit.getData() instanceof Object[]) {
                Object[] bgOrgUnits = (Object[])this.prmtBgOrgUnit.getData();
                if (bgOrgUnits != null) {
                    BgOrgUnitInfo info = null;
                    for (int i = 0; i < bgOrgUnits.length; ++i) {
                        info = (BgOrgUnitInfo)bgOrgUnits[i];
                        if (info == null) continue;
                        orgs.add(info);
                    }
                }
            } else if (this.prmtBgOrgUnit.getData() instanceof BgOrgUnitInfo) {
                orgs.add((BgOrgUnitInfo)this.prmtBgOrgUnit.getData());
            }
            f7.setSelectOrgInfos(orgs);
        }
    }

    @Override
    protected void prmtBgOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgOrgUnit_dataChanged(e);
    }

    protected void setOrgUnitFilter() throws Exception {
        BgSchemeInfo bgScheme = this.getSelectBgScheme();
        if (bgScheme == null) {
            return;
        }
        bgScheme = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo("select id, number, name, orgUnit.id where id = '" + bgScheme.getId().toString() + "'");
        BgViewOrgDimensionF7 orgDialog = new BgViewOrgDimensionF7((IUIObject)this);
        orgDialog.setPermissionFilter(true);
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(bgScheme.getId().toString());
        orgDialog.setBgOrgViewId(schemeHelper.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId());
        orgDialog.setOrgUnitId(bgScheme.getOrgUnit().getId().toString());
        orgDialog.setShowVirtualOrg(false);
        orgDialog.setOnlyNoLeaf(false);
        orgDialog.setOnlyLeaf(false);
        orgDialog.setMultipleSelect(true);
        this.prmtBgOrgUnit.setSelector((KDPromptSelector)orgDialog);
        this.setDefaultOrgUnit(orgDialog.getBgOrgViewId());
    }

    private void setDefaultOrgUnit(String bgOrgViewId) throws EASBizException, BOSException {
        if (DimensionCommonHelper.isEmpty((Object)this.prmtOrgUnit.getData())) {
            return;
        }
        String costOrgId = null;
        costOrgId = this.prmtOrgUnit.getData() instanceof OrgUnitInfo[] ? SysContext.getSysContext().getCurrentOrgUnit().getId().toString() : ((OrgUnitInfo)this.prmtOrgUnit.getData()).getId().toString();
        String selectOrgUnitId = null;
        if (this.prmtBgOrgUnit.getData() instanceof BgOrgUnitInfo) {
            BgOrgUnitInfo o = (BgOrgUnitInfo)this.prmtBgOrgUnit.getData();
            if (StringUtils.isEmpty((String)o.getOrgUnitID())) {
                o = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitInfo("select id, orgUnitId where id = '" + o.getId() + "'");
            }
            selectOrgUnitId = o.getOrgUnitID();
        } else if (this.prmtBgOrgUnit.getData() instanceof OrgUnitInfo) {
            selectOrgUnitId = ((OrgUnitInfo)this.prmtBgOrgUnit.getData()).getId().toString();
        }
        if (selectOrgUnitId == null) {
            selectOrgUnitId = "000000000000000000000000000=";
        }
        BgOrgUnitCollection defaultOrg = null;
        defaultOrg = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection("select * where isVirtual = 0  and viewId = '" + bgOrgViewId + "' and (orgUnitId = '" + costOrgId + "' or orgUnitId = '" + selectOrgUnitId + "')");
        if (defaultOrg == null || defaultOrg.size() == 0) {
            this.prmtBgOrgUnit.setData(null);
        } else if (defaultOrg.size() == 1) {
            this.prmtBgOrgUnit.setData((Object)defaultOrg.get(0));
        } else {
            for (int i = 0; i < defaultOrg.size(); ++i) {
                if (!costOrgId.equals(defaultOrg.get(i).getOrgUnitID())) continue;
                this.prmtBgOrgUnit.setData((Object)defaultOrg.get(i));
                break;
            }
        }
    }
}

