/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.FilterParam;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.popup.PopupMenuManager;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.control.IMBgAnalyseFacade;
import com.kingdee.eas.ma.control.MBgAnalyseFacadeFactory;
import com.kingdee.eas.ma.control.client.AbstractMBgAnalyseExeUI;
import com.kingdee.eas.ma.control.client.MBgAnalyseExeFilterUI;
import com.kingdee.eas.ma.control.client.MbgAnalyseExeHelper;
import com.kingdee.eas.ma.control.client.utils.BgViewBillUtils;
import com.kingdee.eas.ma.control.query.ExeFilterParam;
import com.kingdee.eas.ma.mbg.BgActualRecordInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.query.AnalyseMember;
import com.kingdee.eas.ma.mbg.query.BgAnalyseConstants;
import com.kingdee.eas.ma.mbg.query.MbgExpressParam;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateHelper;
import com.kingdee.eas.ma.mbg.utils.BgCellRenderHelper;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public class MBgAnalyseExeUI
extends AbstractMBgAnalyseExeUI {
    private static final long serialVersionUID = 479833658155427210L;
    private static final Logger logger = CoreUIObject.getLogger(MBgAnalyseExeUI.class);
    public static final String MULTI_FILTER = "MULTI_FILTER";
    private static final String COL_ORGUNIT_INDEX = "orgUnit";
    private static final String COL_BGINDEX_INDEX = "bgIndex";
    private static final String COL_EXTITEM_INDEX = "dimMember";
    private static final String COL_SCENARIO_INDEX = "bgScenario";
    private static final String COL_VERSION_INDEX = "bgVersion";
    private static final String COL_PERIOD_INDEX = "bgPeriod";
    private static final String COL_ELEMENT_INDEX = "bgElement";
    private static final String COL_CURRENCY_INDEX = "currency";
    private static final String COL_ISOMER_INDEX = "isomer";
    private static final String COL_BILLTYPE_INDEX = "billType";
    private static final String COL_BILLNUMBER_INDEX = "billNumber";
    private static final String COL_REQUNIT_INDEX = "srcOrgUnit";
    private static final String COL_BIZDATE_INDEX = "bizDate";
    private static final String COL_CTRLDATE_INDEX = "ctrlDate";
    private static final String COL_AMOUNT_INDEX = "amount";
    private Map<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
    private String accountViewId = null;
    private BgCellRenderHelper cellHelper = new BgCellRenderHelper();
    private Map<String, OrgUnitInfo> orgUnitMap = new HashMap<String, OrgUnitInfo>();

    public Map<String, CurrencyInfo> getCurrencyMap() {
        return this.currencyMap;
    }

    public BgCellRenderHelper getCellHelper() {
        return this.cellHelper;
    }

    public MBgAnalyseExeUI() throws Exception {
        this.getCellHelper().init();
        this.kDTable.checkParsed();
        this.kDTable.getStyleAttributes().setLocked(true);
    }

    public void registerPopupMenuManager(JComponent comp, PopupMenuManager mgr) {
        mgr = new PopupMenuManager();
    }

    public void onLoad() throws Exception {
        CurrencyCollection colls = CurrencyFactory.getRemoteInstance().getCurrencyCollection();
        if (colls != null) {
            CurrencyInfo currency = null;
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                currency = colls.get(i);
                this.getCurrencyMap().put(currency.getNumber(), currency);
            }
        }
        super.onLoad();
        MbgUpdateHelper.checkUpdate();
        this.kDTable.getSelectManager().setSelectMode(2);
        this.kDTable.getColumn(0).setMergeable(true);
        this.kDTable.getColumn(COL_EXTITEM_INDEX).setMergeable(true);
        this.kDTable.getMergeManager().setDataMode(2);
        if (this.getDetailFilterParam() != null && this.getUIContext().get("MbgExpressParam") == null) {
            this.btnQuery.setVisible(false);
            this.btnDetailQuery.setVisible(false);
            this.menuBar.setVisible(false);
        }
        if (this.getUIContext().get("MbgExpressParam") != null) {
            this.btnQuery.setVisible(false);
        }
        if (this.getUIContext().containsKey(MULTI_FILTER)) {
            List paramList = (List)this.getUIContext().get(MULTI_FILTER);
            if (paramList.size() == 1) {
                this.btnDetailQuery.setVisible(false);
            } else {
                this.btnDetailQuery.setVisible(true);
            }
        }
        if (this.getDetailFilterParam() != null && this.getUIContext().get("BgExcuteAnalysis") != null) {
            this.btnQuery.setVisible(true);
            this.btnDetailQuery.setVisible(true);
            this.menuBar.setVisible(true);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    protected String getExportFileName() {
        return EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlResource", (String)"exeAnalyseExport");
    }

    public String getFilterUIName() {
        return MBgAnalyseExeFilterUI.class.getName();
    }

    protected boolean hasDefaultQuery() throws Exception {
        if (this.getDetailFilterParam() != null) {
            return true;
        }
        return super.hasDefaultQuery();
    }

    public FilterParam getFilterParam() {
        if (this.getDetailFilterParam() != null) {
            return this.getDetailFilterParam();
        }
        return super.getFilterParam();
    }

    public ExeFilterParam getDetailFilterParam() {
        return (ExeFilterParam)((Object)this.getUIContext().get("InitDataObject"));
    }

    protected String getQueryMainName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected int getWidthOfDialog() {
        return 500;
    }

    protected int getHeightOfDialog() {
        return 530;
    }

    public KDTable getTable() {
        return this.kDTable;
    }

    protected boolean isShowSum() {
        return true;
    }

    protected IMBgAnalyseFacade getInterface() throws BOSException {
        return MBgAnalyseFacadeFactory.getRemoteInstance();
    }

    protected void executeQuery() throws Exception {
        List querys = null;
        querys = this.getUIContext().containsKey(MULTI_FILTER) ? this.getInterface().queryExecute((List)this.getUIContext().get(MULTI_FILTER)) : this.getInterface().queryExecute(this.getFilterParam());
        this.fillData(querys);
    }

    protected void fillData(List<Object[]> querys) throws Exception {
        this.kDTable.removeRows();
        if (querys == null || querys.isEmpty()) {
            return;
        }
        IRow row = null;
        String key = null;
        String oldKey = null;
        String extKey = null;
        String oldExtKey = null;
        BigDecimal value = null;
        Object[] tmpObjs = null;
        HashMap<String, BigDecimal> keyMap = new HashMap<String, BigDecimal>();
        HashMap<String, Integer> mergeMap = new HashMap<String, Integer>();
        HashMap<String, Integer> extMap = new HashMap<String, Integer>();
        if (this.getFilterParam() instanceof ExeFilterParam && this.accountViewId == null) {
            ExeFilterParam _param = (ExeFilterParam)this.getFilterParam();
            this.accountViewId = BgCellRenderHelper.getAccountViewIdByBgScheme((BgSchemeInfo)_param.getBgScheme());
        }
        String bgOrgViewId = MbgAnalyseExeHelper.getBudgetViewID(((ExeFilterParam)this.getFilterParam()).getBgScheme());
        this.initOrgUnitMap(bgOrgViewId, querys);
        BigDecimal totalValue = BigDecimal.ZERO;
        this.sortQuerys(querys);
        boolean isomer = false;
        for (Object[] objs : querys) {
            if (objs[BgAnalyseConstants.ANALYSE_ISOMER_CONNAME] == null) continue;
            isomer = true;
            break;
        }
        if (isomer) {
            this.kDTable.getColumn(COL_ISOMER_INDEX).getStyleAttributes().setHided(false);
        } else {
            this.kDTable.getColumn(COL_ISOMER_INDEX).getStyleAttributes().setHided(true);
        }
        for (Object[] objs : querys) {
            int bottom;
            int top;
            totalValue = totalValue.add((BigDecimal)objs[BgAnalyseConstants.ANALYSE_AMOUNT]);
            key = this.getQueryDataKey(objs);
            extKey = this.getextDataKey(key, (String)objs[BgAnalyseConstants.ANALYSE_EXTITEM_NUMBER]);
            if (!keyMap.containsKey(key)) {
                keyMap.put(key, (BigDecimal)objs[BgAnalyseConstants.ANALYSE_AMOUNT]);
                if (tmpObjs != null) {
                    if (row != null) {
                        top = (Integer)mergeMap.get(oldKey);
                        bottom = row.getRowIndex();
                        this.mergeTable(top, bottom);
                    }
                    if (this.isShowSum()) {
                        row = this.getTotalRow(tmpObjs);
                        oldKey = this.getQueryDataKey(tmpObjs);
                        row.getCell(COL_AMOUNT_INDEX).setValue(keyMap.get(oldKey));
                    }
                }
            } else {
                value = (BigDecimal)keyMap.get(key);
                value = value.add((BigDecimal)objs[BgAnalyseConstants.ANALYSE_AMOUNT]);
                keyMap.put(key, value);
            }
            row = this.kDTable.addRow();
            if (extKey.equals(oldExtKey) && extMap.containsKey(oldExtKey) && (top = ((Integer)extMap.get(oldExtKey)).intValue()) != (bottom = row.getRowIndex())) {
                this.mergeExtTable(top, bottom);
            }
            row.setUserObject((Object)objs);
            if (this.getOrgUnitMap().containsKey(objs[BgAnalyseConstants.ANALYSE_ORGUNIT_ID])) {
                row.getCell(COL_ORGUNIT_INDEX).setValue((Object)this.getCellHelper().getOrgUnitString((Object)this.getOrgUnitMap().get(objs[BgAnalyseConstants.ANALYSE_ORGUNIT_ID])));
            } else {
                row.getCell(COL_ORGUNIT_INDEX).setValue(objs[BgAnalyseConstants.ANALYSE_ORGUNIT_NAME]);
            }
            row.getCell(COL_BGINDEX_INDEX).setValue((Object)this.getCellHelper().getIndexDisplayName(this.accountViewId, objs[BgAnalyseConstants.ANALYSE_BGINDEX_NUMBER].toString(), objs[BgAnalyseConstants.ANALYSE_BGINDEX_NAME].toString()));
            if (objs[BgAnalyseConstants.ANALYSE_EXTITEM_NUMBER] != null) {
                row.getCell(COL_EXTITEM_INDEX).setValue((Object)this.getCellHelper().getIndexDisplayName(null, (String)objs[BgAnalyseConstants.ANALYSE_EXTITEM_NUMBER], (String)objs[BgAnalyseConstants.ANALYSE_EXTITEM_NAME]));
            }
            row.getCell(COL_PERIOD_INDEX).setValue(objs[BgAnalyseConstants.ANALYSE_PERIOD_NAME]);
            row.getCell(COL_ELEMENT_INDEX).setValue(objs[BgAnalyseConstants.ANALYSE_ELEMENT_NAME]);
            row.getCell(COL_CURRENCY_INDEX).setValue(objs[BgAnalyseConstants.ANALYSE_CURRENCY_NAME]);
            row.getCell(COL_ISOMER_INDEX).setValue(objs[BgAnalyseConstants.ANALYSE_ISOMER_CONNAME]);
            row.getCell(COL_SCENARIO_INDEX).setValue(objs[BgAnalyseConstants.ANALYSE_SCENARIO_NAME]);
            row.getCell(COL_VERSION_INDEX).setValue(objs[BgAnalyseConstants.ANALYSE_VERSION_NAME]);
            row.getCell(COL_BILLTYPE_INDEX).setValue(objs[BgAnalyseConstants.ANALYSE_BILL_TYPE]);
            row.getCell(COL_BILLNUMBER_INDEX).setValue(objs[BgAnalyseConstants.ANALYSE_BILL_NUMBER]);
            if (this.getOrgUnitMap().containsKey(objs[BgAnalyseConstants.ANALYSE_REQORGUNIT_ID])) {
                row.getCell(COL_REQUNIT_INDEX).setValue((Object)this.getCellHelper().getOrgUnitString((Object)this.getOrgUnitMap().get(objs[BgAnalyseConstants.ANALYSE_REQORGUNIT_ID])));
            } else {
                row.getCell(COL_REQUNIT_INDEX).setValue(objs[BgAnalyseConstants.ANALYSE_REQORGUNIT_NAME]);
            }
            row.getCell(COL_AMOUNT_INDEX).setValue(objs[BgAnalyseConstants.ANALYSE_AMOUNT]);
            this.setNumberFormat(row, objs);
            row.getCell(COL_BIZDATE_INDEX).setValue(objs[BgAnalyseConstants.ANALYSE_BIZDATE_TIME]);
            row.getCell(COL_CTRLDATE_INDEX).setValue(objs[BgAnalyseConstants.ANALYSE_CONTROL_TIME]);
            if (!mergeMap.containsKey(key)) {
                mergeMap.put(key, row.getRowIndex());
            }
            if (!extMap.containsKey(extKey)) {
                extMap.put(extKey, row.getRowIndex());
            }
            tmpObjs = objs;
            oldKey = key;
            oldExtKey = extKey;
        }
        if (null == row) {
            return;
        }
        int top = (Integer)mergeMap.get(oldKey);
        int bottom = row.getRowIndex();
        this.mergeTable(top, bottom);
        this.setBizRow(tmpObjs, totalValue);
        if (this.isShowSum()) {
            row = this.getTotalRow(tmpObjs);
            oldKey = this.getQueryDataKey(tmpObjs);
            row.getCell(COL_AMOUNT_INDEX).setValue(keyMap.get(oldKey));
        }
        this.setAllTotalRow(tmpObjs, totalValue);
    }

    protected void setAllTotalRow(Object[] objs, BigDecimal totalValue) {
        if (this.getUIContext().get("isShowAllTotal") == null) {
            return;
        }
        IRow row = this.kDTable.addRow();
        row.getStyleAttributes().setBackground(BgNConstants.LOCK_COLOR);
        row.getCell(COL_AMOUNT_INDEX).setValue((Object)totalValue);
        row.getCell(COL_ORGUNIT_INDEX).setValue((Object)BgCommCHelper.getMessageStr((String)BgAnalyseConstants.ANALYSE_RESOURCESTR, (String)"allTotal"));
        row.getCell(COL_ORGUNIT_INDEX).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        int startcolumnIndex = this.kDTable.getColumnIndex(COL_ORGUNIT_INDEX);
        int endcolumnIndex = this.kDTable.getColumnIndex(COL_CTRLDATE_INDEX);
        this.kDTable.getMergeManager().mergeBlock(row.getRowIndex(), startcolumnIndex, row.getRowIndex(), endcolumnIndex);
        this.setNumberFormat(row, objs);
    }

    private void initOrgUnitMap(String bgOrgViewId, List<Object[]> querys) {
        HashSet<String> ids = new HashSet<String>();
        if (querys != null) {
            for (Object[] objs : querys) {
                ids.add(String.valueOf(objs[BgAnalyseConstants.ANALYSE_ORGUNIT_ID]));
            }
        }
        if (!ids.isEmpty()) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("id");
            evi.getSelector().add("orgUnitId");
            evi.getSelector().add("number");
            evi.getSelector().add("name");
            evi.getSelector().add("displayName");
            evi.getSelector().add("longNumber");
            evi.getSelector().add("level");
            evi.getSelector().add("isLeaf");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("viewId", (Object)bgOrgViewId));
            if (this.getCellHelper() == null || !this.getCellHelper().getBgOrgUnitNameStyle().equals("2")) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnitId", ids, CompareType.INCLUDE));
            }
            evi.getFilter().getFilterItems().add(new FilterItemInfo("isVirtual", (Object)0, CompareType.EQUALS));
            try {
                BgOrgUnitCollection orgCol = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(evi);
                if (orgCol != null) {
                    for (int i = 0; i < orgCol.size(); ++i) {
                        this.getOrgUnitMap().put(orgCol.get(i).getOrgUnitID(), (OrgUnitInfo)orgCol.get(i).castToFullOrgUnitInfo());
                    }
                }
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
    }

    public Map<String, OrgUnitInfo> getOrgUnitMap() {
        Map superOrgMap = super.getOrgUnitMap();
        if (superOrgMap != null) {
            for (String key : superOrgMap.keySet()) {
                if (this.orgUnitMap.containsKey(key)) continue;
                this.orgUnitMap.put(key, (OrgUnitInfo)superOrgMap.get(key));
            }
        }
        return this.orgUnitMap;
    }

    private void setNumberFormat(IRow row, Object[] objs) {
        if (row != null && objs != null) {
            int p = 2;
            CurrencyInfo currency = this.getCurrencyMap().get(objs[BgAnalyseConstants.ANALYSE_CURRENCY_NUMBER]);
            if (currency != null) {
                p = currency.getPrecision();
            }
            row.getCell(COL_AMOUNT_INDEX).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getFormatStringForTable((int)p));
        }
    }

    protected String getQueryDataKey(Object[] objs) {
        return objs[BgAnalyseConstants.ANALYSE_ORGUNIT_ID] + "_" + objs[BgAnalyseConstants.ANALYSE_BGINDEX_NUMBER] + "_" + objs[BgAnalyseConstants.ANALYSE_SCENARIO_NAME] + "_" + objs[BgAnalyseConstants.ANALYSE_VERSION_NAME] + "_" + objs[BgAnalyseConstants.ANALYSE_PERIOD_NUMBER] + "_" + objs[BgAnalyseConstants.ANALYSE_ELEMENT_NUMBER] + "_" + objs[BgAnalyseConstants.ANALYSE_CURRENCY_NUMBER];
    }

    protected String getextDataKey(String key, String extNumber) {
        return key + "_" + extNumber;
    }

    protected void setBizRow(Object[] objs, BigDecimal totalValue) {
        BigDecimal calcValue;
        BigDecimal diffValue = null;
        MbgExpressParam expressParam = null;
        if (this.getUIContext().get("MbgExpressParam") instanceof MbgExpressParam) {
            expressParam = (MbgExpressParam)this.getUIContext().get("MbgExpressParam");
            BigDecimal bigDecimal = calcValue = expressParam.getValue() == null ? BgNConstants.ZERO : expressParam.getValue();
            if (calcValue.compareTo(totalValue) == 0) {
                return;
            }
        } else {
            return;
        }
        diffValue = calcValue.subtract(totalValue);
        if (this.getFilterParam() instanceof ExeFilterParam && this.accountViewId == null) {
            ExeFilterParam _param = (ExeFilterParam)this.getFilterParam();
            this.accountViewId = BgCellRenderHelper.getAccountViewIdByBgScheme((BgSchemeInfo)_param.getBgScheme());
        }
        IRow row = this.kDTable.addRow();
        row.getCell(COL_AMOUNT_INDEX).setValue((Object)diffValue);
        if (this.getOrgUnitMap().containsKey(objs[BgAnalyseConstants.ANALYSE_ORGUNIT_ID])) {
            row.getCell(COL_ORGUNIT_INDEX).setValue((Object)this.getCellHelper().getOrgUnitString((Object)this.getOrgUnitMap().get(objs[BgAnalyseConstants.ANALYSE_ORGUNIT_ID])));
        } else {
            row.getCell(COL_ORGUNIT_INDEX).setValue(objs[BgAnalyseConstants.ANALYSE_ORGUNIT_NAME]);
        }
        row.getCell(COL_BGINDEX_INDEX).setValue((Object)this.getCellHelper().getIndexDisplayName(this.accountViewId, objs[BgAnalyseConstants.ANALYSE_BGINDEX_NUMBER].toString(), objs[BgAnalyseConstants.ANALYSE_BGINDEX_NAME].toString()));
        row.getCell(COL_SCENARIO_INDEX).setValue(objs[BgAnalyseConstants.ANALYSE_SCENARIO_NAME]);
        row.getCell(COL_VERSION_INDEX).setValue(objs[BgAnalyseConstants.ANALYSE_VERSION_NAME]);
        row.getCell(COL_PERIOD_INDEX).setValue(objs[BgAnalyseConstants.ANALYSE_PERIOD_NAME]);
        row.getCell(COL_ELEMENT_INDEX).setValue(objs[BgAnalyseConstants.ANALYSE_ELEMENT_NAME]);
        row.getCell(COL_CURRENCY_INDEX).setValue(objs[BgAnalyseConstants.ANALYSE_CURRENCY_NAME]);
        row.getCell(COL_BILLTYPE_INDEX).setValue((Object)BgCommCHelper.getMessageStr((String)BgAnalyseConstants.ANALYSE_RESOURCESTR, (String)"bizCalcDiff"));
        row.getCell(COL_BGINDEX_INDEX).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        row.getCell(COL_BILLTYPE_INDEX).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        this.kDTable.getMergeManager().mergeBlock(row.getRowIndex(), 1, row.getRowIndex(), 2);
        int startcolumnIndex = this.kDTable.getColumnIndex(COL_BILLTYPE_INDEX);
        int endcolumnIndex = this.kDTable.getColumnIndex(COL_CTRLDATE_INDEX);
        this.kDTable.getMergeManager().mergeBlock(row.getRowIndex(), startcolumnIndex, row.getRowIndex(), endcolumnIndex);
        this.setNumberFormat(row, objs);
    }

    protected IRow getTotalRow(Object[] objs) {
        if (this.getFilterParam() instanceof ExeFilterParam && this.accountViewId == null) {
            ExeFilterParam _param = (ExeFilterParam)this.getFilterParam();
            this.accountViewId = BgCellRenderHelper.getAccountViewIdByBgScheme((BgSchemeInfo)_param.getBgScheme());
        }
        IRow row = this.kDTable.addRow();
        row.getStyleAttributes().setBackground(BgNConstants.LOCK_COLOR);
        if (this.getOrgUnitMap().containsKey(objs[BgAnalyseConstants.ANALYSE_ORGUNIT_ID])) {
            row.getCell(COL_ORGUNIT_INDEX).setValue((Object)this.getCellHelper().getOrgUnitString((Object)this.getOrgUnitMap().get(objs[BgAnalyseConstants.ANALYSE_ORGUNIT_ID])));
        } else {
            row.getCell(COL_ORGUNIT_INDEX).setValue(objs[BgAnalyseConstants.ANALYSE_ORGUNIT_NAME]);
        }
        row.getCell(COL_BGINDEX_INDEX).setValue((Object)this.getCellHelper().getIndexDisplayName(this.accountViewId, objs[BgAnalyseConstants.ANALYSE_BGINDEX_NUMBER].toString(), objs[BgAnalyseConstants.ANALYSE_BGINDEX_NAME].toString()));
        row.getCell(COL_SCENARIO_INDEX).setValue(objs[BgAnalyseConstants.ANALYSE_SCENARIO_NAME]);
        row.getCell(COL_VERSION_INDEX).setValue(objs[BgAnalyseConstants.ANALYSE_VERSION_NAME]);
        row.getCell(COL_PERIOD_INDEX).setValue(objs[BgAnalyseConstants.ANALYSE_PERIOD_NAME]);
        row.getCell(COL_ELEMENT_INDEX).setValue(objs[BgAnalyseConstants.ANALYSE_ELEMENT_NAME]);
        row.getCell(COL_CURRENCY_INDEX).setValue(objs[BgAnalyseConstants.ANALYSE_CURRENCY_NAME]);
        row.getCell(COL_ISOMER_INDEX).setValue((Object)BgCommCHelper.getMessageStr((String)BgAnalyseConstants.ANALYSE_RESOURCESTR, (String)"total"));
        row.getCell(COL_BGINDEX_INDEX).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        row.getCell(COL_ISOMER_INDEX).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        this.kDTable.getMergeManager().mergeBlock(row.getRowIndex(), 1, row.getRowIndex(), 2);
        int startcolumnIndex = this.kDTable.getColumnIndex(COL_ISOMER_INDEX);
        int endcolumnIndex = this.kDTable.getColumnIndex(COL_CTRLDATE_INDEX);
        this.kDTable.getMergeManager().mergeBlock(row.getRowIndex(), startcolumnIndex, row.getRowIndex(), endcolumnIndex);
        this.setNumberFormat(row, objs);
        return row;
    }

    protected void mergeTable(int topIndex, int botIndex) {
        int colIndex = this.kDTable.getColumnIndex(COL_ORGUNIT_INDEX);
        this.kDTable.getMergeManager().mergeBlock(topIndex, colIndex, botIndex, colIndex);
        colIndex = this.kDTable.getColumnIndex(COL_BGINDEX_INDEX);
        this.kDTable.getMergeManager().mergeBlock(topIndex, colIndex, botIndex, colIndex);
        colIndex = this.kDTable.getColumnIndex(COL_PERIOD_INDEX);
        this.kDTable.getMergeManager().mergeBlock(topIndex, colIndex, botIndex, colIndex);
        colIndex = this.kDTable.getColumnIndex(COL_ELEMENT_INDEX);
        this.kDTable.getMergeManager().mergeBlock(topIndex, colIndex, botIndex, colIndex);
        colIndex = this.kDTable.getColumnIndex(COL_CURRENCY_INDEX);
        this.kDTable.getMergeManager().mergeBlock(topIndex, colIndex, botIndex, colIndex);
        colIndex = this.kDTable.getColumnIndex(COL_SCENARIO_INDEX);
        this.kDTable.getMergeManager().mergeBlock(topIndex, colIndex, botIndex, colIndex);
        colIndex = this.kDTable.getColumnIndex(COL_VERSION_INDEX);
        this.kDTable.getMergeManager().mergeBlock(topIndex, colIndex, botIndex, colIndex);
    }

    protected void mergeExtTable(int topIndex, int botIndex) {
        int colIndex = this.kDTable.getColumnIndex(COL_EXTITEM_INDEX);
        this.kDTable.getMergeManager().mergeBlock(topIndex, colIndex, botIndex, colIndex);
    }

    @Override
    protected void kDTable_tableClicked(KDTMouseEvent e) throws Exception {
        super.kDTable_tableClicked(e);
        Object[] objs = this.getSelectedQueryData();
        if (objs != null && objs[BgAnalyseConstants.ANALYSE_ISOMER_CONNAME] != null) {
            BgCommCHelper.disableAction((JButton)this.btnViewBill, null, (ItemAction)this.actionViewBill);
        } else {
            boolean canViewBill;
            boolean bl = canViewBill = objs != null && objs[BgAnalyseConstants.ANALYSE_BILL_ID] != null && !BOSUuid.read((String)((String)objs[BgAnalyseConstants.ANALYSE_BILL_ID])).getType().equals((Object)new BgActualRecordInfo().getBOSType());
            if (canViewBill) {
                BgCommCHelper.enableAction((JButton)this.btnViewBill, null, (ItemAction)this.actionViewBill);
            } else {
                BgCommCHelper.disableAction((JButton)this.btnViewBill, null, (ItemAction)this.actionViewBill);
            }
        }
    }

    @Override
    public void actionViewBill_actionPerformed(ActionEvent e) throws Exception {
        String billId;
        this.checkSelected();
        super.actionViewBill_actionPerformed(e);
        Object[] objs = this.getSelectedQueryData();
        if (objs != null && !StringUtils.isEmpty((String)(billId = (String)objs[BgAnalyseConstants.ANALYSE_BILL_ID]))) {
            BgViewBillUtils.viewBill((CoreUIObject)this, billId);
        }
    }

    @Override
    public void actionDetailQuery_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionDetailQuery_actionPerformed(e);
        Object[] objs = this.getSelectedQueryData();
        if (objs == null) {
            if (this.isSumRow()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlResource", (String)"selectDetailRow"));
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            }
        } else {
            ExeFilterParam filterParam = new ExeFilterParam();
            BgPeriodInfo bgPeriod = new BgPeriodInfo();
            bgPeriod.setId(BOSUuid.read((String)((String)objs[BgAnalyseConstants.ANALYSE_PERIOD_ID])));
            bgPeriod.setNumber((String)objs[BgAnalyseConstants.ANALYSE_PERIOD_NUMBER]);
            bgPeriod.setName((String)objs[BgAnalyseConstants.ANALYSE_PERIOD_NUMBER]);
            filterParam.setBgPeriods(new BgPeriodInfo[]{bgPeriod});
            BgElementInfo bgElement = new BgElementInfo();
            bgElement.setId(BOSUuid.read((String)((String)objs[BgAnalyseConstants.ANALYSE_ELEMENT_ID])));
            bgElement.setNumber((String)objs[BgAnalyseConstants.ANALYSE_ELEMENT_NUMBER]);
            bgElement.setName((String)objs[BgAnalyseConstants.ANALYSE_ELEMENT_NAME]);
            filterParam.setBgElement(bgElement);
            BgScenarioInfo bgScenario = BgScenarioFactory.getRemoteInstance().getBgScenarioInfo("Select id, number, name where scenarioId = " + objs[BgAnalyseConstants.ANALYSE_SCENARIO_ID]);
            filterParam.setBgScenario(bgScenario);
            filterParam.setBgScheme(((ExeFilterParam)this.getFilterParam()).getBgScheme());
            CurrencyInfo currency = new CurrencyInfo();
            currency.setId(BOSUuid.read((String)((String)objs[BgAnalyseConstants.ANALYSE_CURRENCY_ID])));
            currency.setNumber((String)objs[BgAnalyseConstants.ANALYSE_CURRENCY_NUMBER]);
            currency.setName((String)objs[BgAnalyseConstants.ANALYSE_CURRENCY_NAME]);
            filterParam.setCurrency(currency);
            filterParam.getOrgUnits().add(this.getOrgUnitMap().get((String)objs[BgAnalyseConstants.ANALYSE_ORGUNIT_ID]));
            BgOrgUnitInfo bgOrgUnitInfo = (BgOrgUnitInfo)this.getBgOrgUnitMap().get((String)objs[BgAnalyseConstants.ANALYSE_ORGUNIT_ID]);
            if (bgOrgUnitInfo != null) {
                BgOrgUnitInfo[] bgOrgUnitInfos = new BgOrgUnitInfo[]{bgOrgUnitInfo};
                filterParam.setBgOrgUnits(bgOrgUnitInfos);
            }
            filterParam.setShowDetailOfEmptyMember(true);
            filterParam.setShowDetailOfQuery(true);
            if (objs[BgAnalyseConstants.ANALYSE_BILL_NUMBER] == null && objs[BgAnalyseConstants.ANALYSE_BILL_TYPE] != null) {
                filterParam.setOnlyAddActual(true);
            }
            AnalyseMember member = new AnalyseMember();
            BgDimensionMember bgIndex = new BgDimensionMember(DimensionConstants.DEF_INDEX_NUMBER, DimensionConstants.DEF_BGINDEX_FIELD, (String)objs[BgAnalyseConstants.ANALYSE_BGINDEX_NAME], DimensionFormulaHelper.getMemberNumber((String)((String)objs[BgAnalyseConstants.ANALYSE_BGINDEX_NUMBER])));
            bgIndex.setSrcNumber(DimensionConstants.DEF_INDEX_SRCNUMBER);
            member.setBgIndex(bgIndex);
            if (objs[BgAnalyseConstants.ANALYSE_EXTITEM_NUMBER] != null) {
                String[] combins = DimensionFormulaHelper.splitCombinations((String)((String)objs[BgAnalyseConstants.ANALYSE_EXTITEM_NUMBER]));
                StringBuffer srcNumbers = new StringBuffer();
                StringBuffer numbers = new StringBuffer();
                for (String combin : combins) {
                    if (srcNumbers.length() > 0) {
                        srcNumbers.append(",");
                        numbers.append(",");
                    }
                    srcNumbers.append(DimensionFormulaHelper.getSrcNumber((String)combin));
                    numbers.append(DimensionFormulaHelper.getMemberNumber((String)combin));
                }
                BgDimensionMember otherMember = new BgDimensionMember(srcNumbers.toString(), srcNumbers.toString(), null, numbers.toString());
                otherMember.setSrcNumber(srcNumbers.toString());
                otherMember.setName((String)objs[BgAnalyseConstants.ANALYSE_EXTITEM_NUMBER]);
                member.setDimMember(otherMember);
            }
            filterParam.getMembers().add(member);
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"checkKey", (Object)String.valueOf((Object)filterParam));
            uiContext.put((Object)"InitDataObject", (Object)filterParam);
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(((Object)((Object)this)).getClass().getName(), (Map)uiContext, null, OprtState.VIEW, 66);
            if (window instanceof JFrame) {
                ((JFrame)window).setExtendedState(6);
            }
            window.getUIObject().setUITitle(this.btnDetailQuery.getText());
            window.getUIObject().onLoad();
            window.show();
        }
    }

    protected Object[] getSelectedQueryData() {
        Object[] objs = null;
        int rowIndex = this.kDTable.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0) {
            IRow row = this.kDTable.getRow(rowIndex);
            objs = (Object[])row.getUserObject();
        }
        return objs;
    }

    protected boolean isSumRow() {
        IRow row;
        boolean isSumRow = false;
        int rowIndex = this.kDTable.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0 && (row = this.kDTable.getRow(rowIndex)).getCell(COL_BILLTYPE_INDEX).getValue() != null && row.getCell(COL_BILLTYPE_INDEX).getValue().toString().indexOf(BgCommCHelper.getMessageStr((String)BgAnalyseConstants.ANALYSE_RESOURCESTR, (String)"total")) >= 0) {
            isSumRow = true;
        }
        return isSumRow;
    }

    private void sortQuerys(List<Object[]> querys) {
        if (querys == null || querys.isEmpty()) {
            return;
        }
        try {
            final HashMap<String, Integer> orgMap = new HashMap<String, Integer>();
            int index = -1;
            for (Object[] obj : querys) {
                if (orgMap.containsKey(obj[BgAnalyseConstants.ANALYSE_ORGUNIT_ID])) continue;
                orgMap.put((String)obj[BgAnalyseConstants.ANALYSE_ORGUNIT_ID], ++index);
            }
            Collections.sort(querys, new Comparator<Object[]>(){

                @Override
                public int compare(Object[] o1, Object[] o2) {
                    String orgId1 = (String)o1[BgAnalyseConstants.ANALYSE_ORGUNIT_ID];
                    String orgId2 = (String)o2[BgAnalyseConstants.ANALYSE_ORGUNIT_ID];
                    String account1 = (String)o1[BgAnalyseConstants.ANALYSE_BGINDEX_NUMBER];
                    String account2 = (String)o2[BgAnalyseConstants.ANALYSE_BGINDEX_NUMBER];
                    String scenario1 = (String)o1[BgAnalyseConstants.ANALYSE_SCENARIO_NAME];
                    String scenario2 = (String)o2[BgAnalyseConstants.ANALYSE_SCENARIO_NAME];
                    String period1 = (String)o1[BgAnalyseConstants.ANALYSE_PERIOD_NAME];
                    String period2 = (String)o2[BgAnalyseConstants.ANALYSE_PERIOD_NAME];
                    String element1 = (String)o1[BgAnalyseConstants.ANALYSE_ELEMENT_NAME];
                    String element2 = (String)o2[BgAnalyseConstants.ANALYSE_ELEMENT_NAME];
                    String currency1 = (String)o1[BgAnalyseConstants.ANALYSE_CURRENCY_NAME];
                    String currency2 = (String)o2[BgAnalyseConstants.ANALYSE_CURRENCY_NAME];
                    if (((Integer)orgMap.get(orgId1)).compareTo((Integer)orgMap.get(orgId2)) == 0) {
                        if (account1.compareTo(account2) == 0) {
                            if (scenario1.compareTo(scenario2) == 0) {
                                if (period1.compareTo(period2) == 0) {
                                    if (element1.compareTo(element2) == 0) {
                                        return currency1.compareTo(currency2);
                                    }
                                    return element1.compareTo(element2);
                                }
                                return period1.compareTo(period2);
                            }
                            return scenario1.compareTo(scenario2);
                        }
                        return account1.compareTo(account2);
                    }
                    return ((Integer)orgMap.get(orgId1)).compareTo((Integer)orgMap.get(orgId2));
                }
            });
        }
        catch (Exception e) {
            logger.error((Object)"MBgAnalyseExeUI sortQuerys error: ", (Throwable)e);
        }
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK orgPK = null;
        if (this.getUIContext().get("InitDataObject") instanceof ExeFilterParam) {
            ExeFilterParam extParam = (ExeFilterParam)((Object)this.getUIContext().get("InitDataObject"));
            orgPK = new ObjectUuidPK(((OrgUnitInfo)extParam.getOrgUnits().get(0)).getId());
        }
        if (orgPK == null) {
            super.getOrgPK(action);
        }
        return orgPK;
    }

    protected boolean isExportHideCols() {
        return true;
    }
}

