/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.FilterParam;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgAccountCollection;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgElementCollection;
import com.kingdee.eas.ma.base.BgElementFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.base.BgVersionCollection;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.IBgAccount;
import com.kingdee.eas.ma.base.IMbgMember;
import com.kingdee.eas.ma.base.MbgMemberCollection;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.client.BgOrgViewF7;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.control.MBgAnalyseFacadeFactory;
import com.kingdee.eas.ma.control.client.AbstractMBgDataAnalyseFilter1UI;
import com.kingdee.eas.ma.control.client.MBgDataAnalyseListUI;
import com.kingdee.eas.ma.control.client.MbgAnalyseExeBlockSetUI;
import com.kingdee.eas.ma.control.client.MbgAnalyseExeHelper;
import com.kingdee.eas.ma.control.query.DataAnalyseFilterParam;
import com.kingdee.eas.ma.mbg.BgDataAnalyseLayoutSettingCollection;
import com.kingdee.eas.ma.mbg.BgDataAnalyseLayoutSettingFactory;
import com.kingdee.eas.ma.mbg.BgDataAnalyseLayoutSettingInfo;
import com.kingdee.eas.ma.mbg.BgDimSettingsInfo;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.IBgDataAnalyseLayoutSetting;
import com.kingdee.eas.ma.mbg.IMBGViewListFormFacade;
import com.kingdee.eas.ma.mbg.MBGViewListFormFacadeFactory;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseFacadeFactory;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.ViewDimensionMemberDialog;
import com.kingdee.eas.ma.mbg.client.common.BgViewOrgDimensionF7;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgViewClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.client.utils.MBGViewListFormClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.NewDimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.common.BgAnalyseObjConstants;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListResultData;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.query.AnalyseEleUnit;
import com.kingdee.eas.ma.mbg.query.AnalyseMember;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.BgCellRenderHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeUtils;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class MBgDataAnalyseFilter1UI
extends AbstractMBgDataAnalyseFilter1UI {
    private static final long serialVersionUID = 3598113800665987785L;
    private static final Logger logger = CoreUIObject.getLogger(MBgDataAnalyseFilter1UI.class);
    private static final String RES_PATH = "com.kingdee.eas.ma.mbg.BudgetResource";
    protected static final String COL_INDEX_MEMBERS = "bgIndex";
    protected static final String COL_REF_MEMBERS = "dimMember";
    protected static final String COL_ELEMENTS = "BgElement";
    protected static final String COL_MEASURES = "AmountUnit";
    private static final Object OrgUnitInfo = null;
    private String ANALYSE_SCHEME_ID = "ANALYSE_SCHEME_ID";
    private String ANALYSE_MEMBER = "ANALYSE_MEMBER";
    private String ANALYSE_SHOWDETAILTYPE = "ANALYSE_SHOWDETAILTYPE";
    private String ANALYSE_BEGIN_PERIOD_ID = "ANALYSE_BEGIN_PERIOD_ID";
    private String ANALYSE_END_PERIOD_ID = "ANALYSE_END_PERIOD_ID";
    private String ANALYSE_BGPERIOD_IDS = "ANALYSE_BGPERIOD_IDS";
    private String ANALYSE_CURRENCY_ID = "ANALYSE_CURRENCY_ID";
    private String ANALYSE_ELEMENT_ID = "ANALYSE_ELEMENT_ID";
    private String ANALYSE_BGSCENARIO_ID = "ANALYSE_BGSCENARIO_ID";
    private String ANALYSE_BGVERSION_ID = "ANALYSE_BGVERSION_ID";
    private String ANALYSE_ELE_UNIT = "ANALYSE_ELE_UNIT";
    private String ANALYSE_BGPROCESS = "ANALYSE_BGPROCESS";
    private String ANALYSE_VIEW = "ANALYSE_VIEW";
    private String ANALYSE_AUDIT_BUDGETDATA = "ANALYSE_AUDIT_BUDGETDATA";
    private String ANALYSE_HIDE_MBGDIM = "ANALYSE_HIDE_MBGDIM";
    protected boolean isContainSealUp = false;
    protected boolean isOnlySelf = false;
    private OrgUnitInfo unitInfo = SysContext.getSysContext().getCurrentOrgUnit();
    private CtrlUnitInfo CU = SysContext.getSysContext().getCurrentCtrlUnit();
    private CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
    private BgCellRenderHelper cellHelper = new BgCellRenderHelper();
    protected BgSchemeDimensionHelper helper = null;
    private boolean isDefaultQuery = false;
    private BgProcessEnum processType = BgProcessEnum.C01;
    String accountViewId = null;
    private String bgSchemeId = null;
    private Map<String, Map<String, String>> cacheLongNumberMap = new HashMap<String, Map<String, String>>();
    private BgSchemeDimensionHelper schemeDimensionHelper = null;
    private BgSchemeInfo schemeInfo = null;
    private DimensionMemberSelectHelper selectHelper = null;

    public BgCellRenderHelper getCellHelper() {
        return this.cellHelper;
    }

    public MBgDataAnalyseFilter1UI() throws Exception {
        this.init();
    }

    public BgSchemeDimensionHelper getSchemeHelper() throws BOSException {
        if (this.helper == null) {
            try {
                BgSchemeInfo bgShemeInfo = (BgSchemeInfo)this.prmtScheme.getData();
                if (bgShemeInfo != null) {
                    this.helper = new BgSchemeDimensionHelper(bgShemeInfo.getId().toString());
                }
            }
            catch (Exception ex) {
                logger.error((Object)"getSchemeHelper error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
        }
        return this.helper;
    }

    public boolean isDefaultQuery() {
        return this.isDefaultQuery;
    }

    public void setDefaultQuery(boolean isDefaultQuery) {
        this.isDefaultQuery = isDefaultQuery;
    }

    public BgProcessEnum getProcessType() {
        if (this.getFilterParam() != null && ((DataAnalyseFilterParam)this.getFilterParam()).getProcessType() != null && this.isDefaultQuery()) {
            this.setProcessType(((DataAnalyseFilterParam)this.getFilterParam()).getProcessType());
        } else {
            ButtonModel selection = this.btnGroupProcessType.getSelection();
            if (this.btnRdBudget.getModel().equals(selection)) {
                this.setProcessType(BgProcessEnum.C01);
            } else if (this.btnRdDecompose.getModel().equals(selection)) {
                this.setProcessType(BgProcessEnum.C02);
            } else if (this.btnRdDecomposeSend.getModel().equals(selection)) {
                this.setProcessType(BgProcessEnum.C03);
            } else if (this.btnRdDecomposeGather.getModel().equals(selection)) {
                this.setProcessType(BgProcessEnum.C04);
            }
        }
        return this.processType;
    }

    private void setProcessType(BgProcessEnum processType) {
        this.processType = processType;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initToolTipText();
        this.initResponsibilityCenter();
        this.initBgScheme();
        this.getCellHelper().init();
        this.getUnitTable().getColumn(COL_MEASURES).setRequired(true);
    }

    private void initToolTipText() {
        this.btnAddLine1.setToolTipText(EASResource.getString((String)RES_PATH, (String)"btnAddLine"));
        this.btnDeleteLine1.setToolTipText(EASResource.getString((String)RES_PATH, (String)"btnDeleteLine"));
        this.btnInsert.setToolTipText(EASResource.getString((String)RES_PATH, (String)"btnInsert"));
        this.btnAddLine.setToolTipText(EASResource.getString((String)RES_PATH, (String)"btnAddLine"));
        this.btnCopyLine.setToolTipText(EASResource.getString((String)RES_PATH, (String)"btnCopyLine"));
        this.btnDeleteLine.setToolTipText(EASResource.getString((String)RES_PATH, (String)"btnDeleteLine"));
        this.btnFromSelect.setToolTipText(EASResource.getString((String)RES_PATH, (String)"btnFromSelect"));
    }

    private void initBgScenario() throws Exception {
        EntityViewInfo view;
        if (this.getBgSchemeDimensionHelper() == null) {
            return;
        }
        ViewDimensionMemberDialog dialog = new ViewDimensionMemberDialog((CoreUI)this.getOwnerUi(), (BgDimensionBaseInfo)this.getBgSchemeDimensionHelper().getDimensionOnCheck(DimensionConstants.DEF_SCENARIO_NUMBER), SysContext.getSysContext().getCurrentOrgUnit().getId().toString(), true);
        dialog.setSchemeHelper(this.getBgSchemeDimensionHelper());
        dialog.setLayout("row");
        dialog.setShowVariate(false);
        dialog.setOnlyLeaf(true);
        dialog.setMemberValueType(DimensionMemberValueModeEnum.SelectMember);
        dialog.setCanMember(this.getScenarioFilter(this.getBgSchemeDimensionHelper(), DimensionConstants.DEF_SCENARIO_NUMBER));
        this.prmtScenario.setRequired(true);
        this.prmtScenario.setSelector((KDPromptSelector)dialog);
        if (dialog instanceof DataChangeListener) {
            this.prmtScenario.addDataChangeListener((DataChangeListener)dialog);
        }
        if ((view = this.prmtScenario.getEntityViewInfo()) == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.setSelector(new SelectorItemCollection());
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("type"));
        this.prmtScenario.setEntityViewInfo(view);
    }

    public Set<String> getBudgetScenario(BgSchemeDimensionHelper schemeHelper) throws Exception {
        if (schemeHelper != null) {
            try {
                HashSet<String> numbers = new HashSet<String>();
                List bgScenario = BgScenarioHelper.getAllScenario();
                HashSet<String> bgScenarioNums = new HashSet<String>();
                for (BgScenarioInfo s : bgScenario) {
                    if (this.isNotC01()) {
                        if (!s.getType().equals((Object)BgScenarioType.BudgetData)) continue;
                        bgScenarioNums.add(s.getNumber());
                        continue;
                    }
                    bgScenarioNums.add(s.getNumber());
                }
                BgDimSettingsInfo info = (BgDimSettingsInfo)schemeHelper.getDimSettingMap().get(DimensionConstants.DEF_SCENARIO_NUMBER);
                for (int i = 0; i < info.getMembers().size(); ++i) {
                    if (!bgScenarioNums.contains(info.getMembers().get(i).getNumber())) continue;
                    numbers.add(info.getMembers().get(i).getNumber());
                }
                return numbers;
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return null;
    }

    public Map<String, Set<String>> getScenarioFilter(BgSchemeDimensionHelper schemeHelper, String keyStr) throws Exception {
        Set<String> bgSceNarioNumbers = this.getBudgetScenario(schemeHelper);
        if (bgSceNarioNumbers != null && !bgSceNarioNumbers.isEmpty()) {
            HashMap<String, Set<String>> filterMap = new HashMap<String, Set<String>>();
            filterMap.put(keyStr, bgSceNarioNumbers);
            return filterMap;
        }
        return null;
    }

    private boolean isNotC01() {
        return !BgProcessEnum.C01.equals((Object)this.getProcessType());
    }

    protected void initBgVersion() throws Exception {
        this.prmtBgVersion.setEditable(false);
        Set<String> versionID = MbgAnalyseExeHelper.getBgVersionID((BgSchemeInfo)this.prmtScheme.getData());
        EntityViewInfo view = this.prmtBgVersion.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", versionID, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtBgVersion.setEntityViewInfo(view);
        this.prmtBgVersion.getQueryAgent().setEnabledMultiSelection(true);
        this.prmtBgVersion.setRequired(true);
    }

    private void initResponsibilityCenter() {
        BgOrgViewF7 orgView = new BgOrgViewF7((IUIObject)this);
        orgView.setTitle(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgBaseResource", (String)"selectOrgUnit"));
        orgView.setRootUnitID(this.CU.getId().toString());
        orgView.setMultiSelect(false);
        orgView.setContainSealUp(true);
        if (this.getOwnerUi() instanceof MBgDataAnalyseListUI) {
            MBgDataAnalyseListUI ui = this.getOwnerUi();
            orgView.setUIActionPK(ui.getMetaDataPK(), (IMetaDataPK)MetaDataPK.create((String)"ActionOnLoad"));
        }
        this.prmtOrgUnit.setData((Object)this.unitInfo);
        this.prmtOrgUnit.setSelector((KDPromptSelector)orgView);
    }

    @Override
    protected void prmtOrgUnit_willShow(SelectorEvent e) throws Exception {
        super.prmtOrgUnit_willShow(e);
        BgOrgViewF7 f7 = (BgOrgViewF7)this.prmtOrgUnit.getSelector();
        Set<BOSUuid> selectedOrgIds = this.getSelectedOrgIds();
        f7.setSelectedOrgIds(selectedOrgIds);
    }

    private Set<BOSUuid> getSelectedOrgIds() {
        HashSet<BOSUuid> selectedOrgIds;
        block3: {
            Object data;
            block4: {
                block2: {
                    data = this.prmtOrgUnit.getData();
                    selectedOrgIds = new HashSet<BOSUuid>();
                    if (data == null || !(data instanceof OrgUnitInfo)) break block2;
                    OrgUnitInfo orgUnit = (OrgUnitInfo)data;
                    selectedOrgIds.add(orgUnit.getId());
                    break block3;
                }
                if (data == null || !(data instanceof OrgUnitInfo[])) break block4;
                OrgUnitInfo[] orgUnits = (OrgUnitInfo[])data;
                for (int i = 0; i < orgUnits.length; ++i) {
                    selectedOrgIds.add(orgUnits[i].getId());
                }
                break block3;
            }
            if (data == null || !(data instanceof List)) break block3;
            List orgUnits = (List)data;
            for (OrgUnitInfo orgUnitInfo : orgUnits) {
                selectedOrgIds.add(orgUnitInfo.getId());
            }
        }
        return selectedOrgIds;
    }

    protected void setBgSchemeFilter() throws Exception {
        Object data = this.prmtOrgUnit.getData();
        if (data != null && data instanceof OrgUnitInfo) {
            OrgUnitInfo orgUnit = (OrgUnitInfo)data;
            try {
                BgNFCHelper.initPrmpPermitedBgschemeInfo((KDBizPromptBox)this.prmtScheme, (OrgUnitInfo)orgUnit, (boolean)this.isOnlySelf, (RptSrcTypeEnum)BgNFCHelper.getSourceType((IUIObject)this), (boolean)false, (boolean)false, (boolean)true);
                if (this.prmtScheme.getData() == null) {
                    this.prmtBgOrgUnit.setDataNoNotify(null);
                }
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else if (data != null && data instanceof OrgUnitInfo[]) {
            OrgUnitInfo[] orgUnits = (OrgUnitInfo[])data;
            BOSUuid[] orgUnitIds = new BOSUuid[orgUnits.length];
            for (int i = 0; i < orgUnits.length; ++i) {
                orgUnitIds[i] = orgUnits[i].getId();
            }
            try {
                BgNFCHelper.initPrmpPermitedBgschemeInfo((KDBizPromptBox)this.prmtScheme, (OrgUnitInfo[])orgUnits, (boolean)this.isOnlySelf, (RptSrcTypeEnum)BgNFCHelper.getSourceType((IUIObject)this), (boolean)false, (boolean)false, (boolean)true);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else if (data == null || data instanceof BgOrgUnitInfo) {
            // empty if block
        }
    }

    public RptSrcTypeEnum getSourceType() {
        return RptSrcTypeEnum.PT_BUDGET_REPORT;
    }

    protected void init() {
        this.kDMember.checkParsed();
        this.kDMember.addRow();
        this.getUnitTable().checkParsed();
        this.getUnitTable().addRow();
        this.initBgScheme();
    }

    protected void initBgScheme() {
        this.prmtScheme.setEditable(false);
        this.prmtScheme.setEnabledMultiSelection(false);
        this.prmtScheme.setHistoryRecordEnabled(false);
    }

    protected void initDimMember() throws BOSException {
        OrgUnitInfo orgUnitInfo = null;
        if (this.prmtOrgUnit.getData() instanceof OrgUnitInfo[]) {
            orgUnitInfo = ((OrgUnitInfo[])this.prmtOrgUnit.getData())[0];
        } else if (this.prmtOrgUnit.getData() instanceof OrgUnitInfo) {
            orgUnitInfo = (OrgUnitInfo)this.prmtOrgUnit.getData();
        }
        if (this.getSchemeHelper() != null && orgUnitInfo != null) {
            DimensionMemberSelectDialog indexdia = new DimensionMemberSelectDialog((Component)((Object)this), (BgDimensionBaseInfo)this.getSchemeHelper().getDimension(DimensionBaseConstants.DEF_ACCOUNT_NUMBER), orgUnitInfo.getId().toString(), true, true);
            KDBizPromptBox prmtBgIndex = new KDBizPromptBox();
            prmtBgIndex.setEditFormat("$number$");
            prmtBgIndex.setDisplayFormat("$name$");
            prmtBgIndex.setCommitFormat("$number$");
            BgCommHelper.removeUndo((KDBizPromptBox)prmtBgIndex);
            prmtBgIndex.setEditable(false);
            indexdia.setDimension((Object)this.getSchemeHelper().getDimension(DimensionBaseConstants.DEF_ACCOUNT_NUMBER));
            indexdia.setOrgId(orgUnitInfo.getId().toString());
            indexdia.setBgSchemeId(this.getBgScehemeId());
            prmtBgIndex.setSelector((KDPromptSelector)indexdia);
            prmtBgIndex.addDataChangeListener((DataChangeListener)indexdia);
            prmtBgIndex.setRequired(true);
            this.kDMember.getColumn(0).setRequired(true);
            this.kDMember.getColumn(0).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtBgIndex));
        }
        KDBizPromptBox prmt = new KDBizPromptBox();
        prmt.setEditable(false);
        prmt.setSelector((KDPromptSelector)this.initDimensionMemberSelectDialog());
        this.kDMember.getColumn(COL_REF_MEMBERS).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmt));
    }

    @Override
    protected void kDMember_tableClicked(KDTMouseEvent e) throws Exception {
        KDBizPromptBox curPrompt;
        int selectedIndex = this.kDMember.getSelectManager().getActiveColumnIndex();
        if (selectedIndex == 0 && (curPrompt = (KDBizPromptBox)this.kDMember.getColumn(COL_INDEX_MEMBERS).getEditor().getComponent()).getSelector() instanceof DimensionMemberSelectDialog) {
            ((DimensionMemberSelectDialog)curPrompt.getSelector()).reSetF7UI();
            ((DimensionMemberSelectDialog)curPrompt.getSelector()).setCurSelectFunction(this.getCurDimFunctionList());
        }
    }

    public MbgViewListResultData getCurDimFunctionList() {
        int selectedIndex = this.kDMember.getSelectManager().getActiveRowIndex();
        if (selectedIndex < 0) {
            return null;
        }
        ICell iCell = this.kDMember.getCell(selectedIndex, COL_INDEX_MEMBERS);
        MbgViewListResultData resultData = new MbgViewListResultData();
        Object dimValues = null;
        if (iCell != null && iCell.getValue() != null && (dimValues = iCell.getValue()) instanceof List) {
            List members = (List)dimValues;
            resultData.setMembers(members);
            resultData.setMemberType(BgMemberSelectTypeEnum.Member);
        }
        return resultData;
    }

    protected void initElementColumn() throws BOSException {
        KDTable unitTable = this.getUnitTable();
        unitTable.removeRows();
        IRow addRow = this.getUnitTable().addRow();
        MeasureUnitInfo defaultMeasure = this.getDefaultMeasure();
        if (defaultMeasure != null) {
            addRow.getCell(COL_MEASURES).setValue((Object)defaultMeasure);
        }
        KDBizPromptBox prmt = new KDBizPromptBox();
        prmt.setEditable(false);
        prmt.setSelector((KDPromptSelector)this.initElementF7());
        prmt.setRequired(true);
        unitTable.getColumn(0).setRequired(true);
        unitTable.getColumn(0).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmt));
        prmt.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                MBgDataAnalyseFilter1UI.this.checkBgScheme();
            }
        });
    }

    protected void initMeasureColumn() {
        KDTable unitTable = this.getUnitTable();
        KDBizPromptBox prmtSelect2 = null;
        prmtSelect2 = new KDBizPromptBox();
        prmtSelect2.setEditable(false);
        prmtSelect2.setDisplayFormat("$name$");
        prmtSelect2.setEnabledMultiSelection(false);
        prmtSelect2.setQueryInfo("com.kingdee.eas.ma.control.BgMeasureUnitQuery");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = null;
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isDisabled", (Object)false, CompareType.EQUALS));
        view.setFilter(filterInfo);
        view.getSorter().add(new SorterItemInfo("coefficient"));
        prmtSelect2.setEntityViewInfo(view);
        prmtSelect2.setRequired(true);
        unitTable.getColumn(0).setRequired(true);
        unitTable.getColumn(1).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect2));
    }

    protected NewDimensionMemberSelectDialog initElementF7() {
        BgDimensionInfo dimension = new BgDimensionInfo(null);
        dimension.setNumber(DimensionConstants.DEF_ELEMENT_NUMBER);
        NewDimensionMemberSelectDialog dialog = new NewDimensionMemberSelectDialog();
        if (this.prmtScheme.getData() instanceof BgSchemeInfo) {
            dialog.setBgSchemeId(((BgSchemeInfo)this.prmtScheme.getData()).getId().toString());
        } else {
            dialog.setBgSchemeId("#");
        }
        dialog.setDimension((Object)dimension);
        dialog.setMulti(true);
        return dialog;
    }

    protected NewDimensionMemberSelectDialog initDimensionMemberSelectDialog() {
        String[] orgUnitIds = null;
        Object obj = this.prmtOrgUnit.getData();
        if (obj != null) {
            Object[] objs = DimensionCommonHelper.getValues((Object)obj);
            orgUnitIds = new String[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                if (objs[i] instanceof BgOrgUnitInfo) {
                    orgUnitIds[i] = ((BgOrgUnitInfo)obj).getId().toString();
                    continue;
                }
                if (!(objs[i] instanceof OrgUnitInfo)) continue;
                orgUnitIds[i] = ((OrgUnitInfo)objs[i]).getId().toString();
            }
        }
        if (orgUnitIds == null) {
            return null;
        }
        NewDimensionMemberSelectDialog dialog = null;
        if (orgUnitIds.length > 1) {
            dialog = new NewDimensionMemberSelectDialog((Component)((Object)this), (BgDimensionBaseInfo)((BgDimensionInfo)null), null, false, true);
            dialog.setCanntFilterOrg(true);
        } else {
            dialog = new NewDimensionMemberSelectDialog((Component)((Object)this), (BgDimensionBaseInfo)((BgDimensionInfo)null), orgUnitIds[0], false, true);
        }
        dialog.setOrgUnitIds(orgUnitIds);
        dialog.setOnlyRefDim(true);
        dialog.setOnlySelectItem(true);
        dialog.setMustAllDim(false);
        if (this.prmtScheme.getData() instanceof BgSchemeInfo) {
            dialog.setBgSchemeId(((BgSchemeInfo)this.prmtScheme.getData()).getId().toString());
        } else {
            dialog.setBgSchemeId("#");
        }
        return dialog;
    }

    protected void initPeriod() {
        if (this.prmtBgPeriod.getSelector() instanceof DataChangeListener) {
            this.prmtBgPeriod.removeDataChangeListener((DataChangeListener)this.prmtBgPeriod.getSelector());
        }
        this.prmtBgPeriod.setEditable(false);
        BgPeriodDialog dialog = new BgPeriodDialog((CoreUIObject)this);
        dialog.setBgPeriodBeginDate(((BgSchemeInfo)this.prmtScheme.getData()).getDateFrom());
        dialog.setBgPeriodEndDate(((BgSchemeInfo)this.prmtScheme.getData()).getDateTo());
        dialog.setMultiSelect(true);
        dialog.setBgSchemeID(((BgSchemeInfo)this.prmtScheme.getData()).getId().toString());
        this.prmtBgPeriod.setSelector((KDPromptSelector)dialog);
        this.prmtBgPeriod.addDataChangeListener((DataChangeListener)dialog);
        this.prmtBgPeriod.setRequired(true);
    }

    protected void initCurrency() throws Exception {
        this.prmtCurrency.setEditable(false);
        this.prmtCurrency.setRequired(true);
        Set<String> currencyID = MbgAnalyseExeHelper.getCurrencyID((BgSchemeInfo)this.prmtScheme.getData());
        EntityViewInfo view = this.prmtCurrency.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", currencyID, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtCurrency.setEntityViewInfo(view);
    }

    protected boolean isMultiSelect() {
        return true;
    }

    @Override
    protected void kDMember_editStopped(KDTEditEvent e) throws Exception {
        Object value = e.getValue();
        if (COL_INDEX_MEMBERS.equals(this.kDMember.getColumnKey(e.getColIndex())) && value instanceof MbgViewListResultData) {
            MbgViewListResultData data = (MbgViewListResultData)value;
            List indexMembers = MbgQingAnalyseFacadeFactory.getRemoteInstance().queryAccMember(this.bgSchemeId, data.getMemberType().getValue(), data.getMembers());
            IRow sourceRow = this.kDMember.getRow(e.getRowIndex());
            if (indexMembers != null && indexMembers.size() > 1) {
                IRow row = null;
                ArrayList<BgDimensionMember> newMembers = null;
                for (int i = 0; i < indexMembers.size(); ++i) {
                    if (i != 0) {
                        row = this.kDMember.addRow(e.getRowIndex() + i);
                        this.copyRow(sourceRow, row);
                    } else {
                        row = sourceRow;
                    }
                    newMembers = new ArrayList<BgDimensionMember>();
                    newMembers.add((BgDimensionMember)indexMembers.get(i));
                    this.setIndexMember(row, newMembers);
                }
            } else {
                this.setIndexMember(sourceRow, indexMembers);
            }
        }
    }

    private void setIndexMember(IRow row, List<BgDimensionMember> newMembers) {
        row.getCell(COL_INDEX_MEMBERS).setValue(newMembers);
    }

    private String displayMembers(List<BgDimensionMember> members) {
        if (members == null || members.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (BgDimensionMember bgDimensionMember : members) {
            if (this.accountViewId == null && this.prmtScheme.getData() instanceof BgSchemeInfo) {
                this.accountViewId = BgCellRenderHelper.getAccountViewIdByBgScheme((BgSchemeInfo)((BgSchemeInfo)this.prmtScheme.getData()));
            }
            if (this.accountViewId != null) {
                sb.append(this.getCellHelper().getIndexDisplayName(this.accountViewId, bgDimensionMember)).append(",");
                continue;
            }
            sb.append(bgDimensionMember.getNumber()).append("(").append(bgDimensionMember.getName()).append(")").append(",");
        }
        sb = sb.deleteCharAt(sb.toString().lastIndexOf(","));
        return sb.toString();
    }

    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtOrgUnit.getData() == null) {
            this.prmtOrgUnit.setDataNoNotify(e.getOldValue());
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"isNullCostCenter"));
        } else if (!DimensionCommonHelper.isEqualsPrmt((Object)e.getNewValue(), (Object)e.getOldValue())) {
            this.setBgSchemeFilter();
            this.initDimMember();
            this.initElementColumn();
            this.initMeasureColumn();
        }
    }

    @Override
    protected void prmtScheme_willShow(SelectorEvent e) throws Exception {
        super.prmtScheme_willShow(e);
        BgViewClientHelper.prmtScheme_willShow((Component)((Object)this), (KDBizPromptBox)this.prmtOrgUnit);
    }

    @Override
    protected void prmtScheme_dataChanged(DataChangeEvent e) throws Exception {
        Map<String, String> bgSchemeDefaultMember;
        if (e.getNewValue() != null && e.getOldValue() != null && e.getNewValue() instanceof BgSchemeInfo && ((BgSchemeInfo)e.getNewValue()).getId().equals((Object)((BgSchemeInfo)e.getOldValue()).getId())) {
            return;
        }
        if (e.getNewValue() == null && e.getOldValue() != null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"isNullBgScheme"));
            this.prmtScheme.setDataNoNotify(e.getOldValue());
            return;
        }
        if (this.getBgScehemeId() != null) {
            this.helper = new BgSchemeDimensionHelper(this.getBgScehemeId());
        }
        this.kDMember.removeRows();
        if (this.prmtScheme.getData() != null) {
            this.resetDisplayFormatter();
            FilterInfo filter = MbgPermissionHelper.addBgSchemePermission((RptSrcTypeEnum)BgNFCHelper.getSourceType((IUIObject)this), (String)SysContext.getSysContext().getCurrentUserInfo().getId().toString(), (FilterInfo)this.prmtScheme.getEntityViewInfo().getFilter());
            this.prmtScheme.getEntityViewInfo().setFilter(filter);
            this.initDimMember();
            this.initBgScenario();
            this.initPeriod();
            this.initCurrency();
            this.initBgVersion();
            this.initElementColumn();
            this.initMeasureColumn();
        }
        if ((bgSchemeDefaultMember = MbgAnalyseExeHelper.getBgSchemeDefaultMember(this.getBgScehemeId())).containsKey(DimensionConstants.DEF_VERSION_NUMBER)) {
            String bgversionId = bgSchemeDefaultMember.get(DimensionConstants.DEF_VERSION_NUMBER);
            if (!StringUtils.isEmpty((String)bgversionId)) {
                BgVersionInfo bgVersionInfo = BgVersionFactory.getRemoteInstance().getBgVersionInfo("select * where id = '" + bgversionId + "'");
                Object[] bgversions = new Object[]{bgVersionInfo};
                this.prmtBgVersion.setData((Object)bgversions);
            } else {
                this.prmtBgVersion.setData(null);
            }
        }
        if (bgSchemeDefaultMember.containsKey(DimensionConstants.DEF_CURRENCY_NUMBER)) {
            String currencyId = bgSchemeDefaultMember.get(DimensionConstants.DEF_CURRENCY_NUMBER);
            if (!StringUtils.isEmpty((String)currencyId)) {
                CurrencyInfo currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectStringPK(currencyId));
                this.prmtCurrency.setData((Object)currencyInfo);
            } else {
                this.prmtCurrency.setData(null);
            }
        }
        this.prmtBgPeriod.setData(null);
        this.prmtScenario.setData(null);
        this.accountViewId = null;
        if (e.getNewValue() instanceof BgSchemeInfo) {
            this.accountViewId = BgCellRenderHelper.getAccountViewIdByBgScheme((BgSchemeInfo)((BgSchemeInfo)e.getNewValue()));
        }
        this.kDMember.getColumn(COL_INDEX_MEMBERS).setRenderer((IBasicRender)this.getCellHelper().getOVRender(this.accountViewId));
        this.prmtBgOrgUnit.setData(null);
        this.setOrgUnitFilter();
        this.kDMember.addRow();
    }

    private void resetDisplayFormatter() {
        this.prmtBgPeriod.setData(null);
        this.prmtBgPeriod.setDisplayFormat("$name$");
    }

    protected String getBgScehemeId() {
        if (this.prmtScheme.getData() instanceof BgSchemeInfo) {
            BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.prmtScheme.getData();
            this.bgSchemeId = bgSchemeInfo.getId().toString();
        } else if (this.getFilterParam() != null && ((DataAnalyseFilterParam)this.getFilterParam()).getBgScheme() != null) {
            this.bgSchemeId = ((DataAnalyseFilterParam)this.getFilterParam()).getBgScheme().getId().toString();
        }
        return this.bgSchemeId;
    }

    protected String getBgOrgUnitViewId() throws Exception {
        String bgOrgViewId = null;
        if (this.prmtScheme.getData() instanceof BgSchemeInfo) {
            BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.prmtScheme.getData();
            bgOrgViewId = MbgAnalyseExeHelper.getBudgetViewID(bgSchemeInfo);
        }
        return bgOrgViewId;
    }

    public List<BgOrgUnitInfo> getOrgUnits(boolean isOrgOnRow) throws EASBizException, BOSException, Exception {
        List<BgOrgUnitInfo> bgOrgUnits = null;
        BgOrgUnitCollection bgOrgUnitCollection = null;
        List<OrgUnitInfo> orgUnits = this.getOrgs();
        if (orgUnits != null && !orgUnits.isEmpty()) {
            HashSet<String> ids = new HashSet<String>();
            for (int i = 0; i < orgUnits.size(); ++i) {
                ids.add(orgUnits.get(i).getId().toString());
            }
            bgOrgUnitCollection = this.getOrgColls(ids);
        }
        if (isOrgOnRow) {
            bgOrgUnits = this.removeChildOrg(bgOrgUnitCollection);
        } else if (bgOrgUnitCollection != null && !bgOrgUnitCollection.isEmpty()) {
            bgOrgUnits = new ArrayList<BgOrgUnitInfo>();
            for (int i = 0; i < bgOrgUnitCollection.size(); ++i) {
                bgOrgUnits.add(bgOrgUnitCollection.get(i));
            }
        }
        return bgOrgUnits;
    }

    public Set<String> getCostOrgUnits(MbgViewListManager _view) throws EASBizException, BOSException, Exception {
        int i;
        boolean isOrgOnRow;
        List<BgOrgUnitInfo> bgOrgUnits = null;
        BgOrgUnitCollection bgOrgUnitCollection = null;
        List<OrgUnitInfo> orgUnits = this.getOrgs();
        HashSet<String> ids = new HashSet<String>();
        if (orgUnits != null && !orgUnits.isEmpty()) {
            for (int i2 = 0; i2 < orgUnits.size(); ++i2) {
                ids.add(orgUnits.get(i2).getId().toString());
            }
            bgOrgUnitCollection = this.getOrgColls(ids);
        }
        if (isOrgOnRow = MBGViewListFormClientHelper.isOrgOnRow((MbgViewListDimensionManager)((MbgViewListSheetManager)_view.getSheetManagers().get(0)).getDimensionManager())) {
            bgOrgUnits = this.removeChildOrg(bgOrgUnitCollection);
        } else if (bgOrgUnitCollection != null && !bgOrgUnitCollection.isEmpty()) {
            bgOrgUnits = new ArrayList<BgOrgUnitInfo>();
            for (i = 0; i < bgOrgUnitCollection.size(); ++i) {
                bgOrgUnits.add(bgOrgUnitCollection.get(i));
            }
        }
        if (bgOrgUnits != null && !bgOrgUnits.isEmpty()) {
            ids.clear();
            for (i = 0; i < bgOrgUnits.size(); ++i) {
                ids.add(bgOrgUnits.get(i).get("orgUnitId").toString());
            }
        }
        return ids;
    }

    public Set<BgOrgUnitInfo> getBgOrgUnits(MbgViewListManager _view) throws EASBizException, BOSException, Exception {
        int i;
        boolean isOrgOnRow;
        List<BgOrgUnitInfo> bgOrgUnits = null;
        BgOrgUnitCollection bgOrgUnitCollection = null;
        List<OrgUnitInfo> orgUnits = this.getOrgs();
        HashSet<String> ids = new HashSet<String>();
        HashSet<BgOrgUnitInfo> orgs = new HashSet<BgOrgUnitInfo>();
        if (orgUnits != null && !orgUnits.isEmpty()) {
            for (int i2 = 0; i2 < orgUnits.size(); ++i2) {
                ids.add(orgUnits.get(i2).getId().toString());
            }
            bgOrgUnitCollection = this.getOrgColls(ids);
        }
        if (isOrgOnRow = MBGViewListFormClientHelper.isOrgOnRow((MbgViewListDimensionManager)((MbgViewListSheetManager)_view.getSheetManagers().get(0)).getDimensionManager())) {
            bgOrgUnits = this.removeChildOrg(bgOrgUnitCollection);
        } else if (bgOrgUnitCollection != null && !bgOrgUnitCollection.isEmpty()) {
            bgOrgUnits = new ArrayList<BgOrgUnitInfo>();
            for (i = 0; i < bgOrgUnitCollection.size(); ++i) {
                bgOrgUnits.add(bgOrgUnitCollection.get(i));
            }
        }
        if (bgOrgUnits != null && !bgOrgUnits.isEmpty()) {
            for (i = 0; i < bgOrgUnits.size(); ++i) {
                orgs.add(bgOrgUnits.get(i));
            }
        }
        return orgs;
    }

    private List<BgOrgUnitInfo> removeChildOrg(BgOrgUnitCollection bgOrgUnitCollection) {
        ArrayList<BgOrgUnitInfo> bgOrgUnits = null;
        if (bgOrgUnitCollection != null && !bgOrgUnitCollection.isEmpty()) {
            HashSet<String> deleteNumbers = new HashSet<String>();
            for (int i = 0; i < bgOrgUnitCollection.size(); ++i) {
                BgOrgUnitInfo bgOrgUnitInfo = bgOrgUnitCollection.get(i);
                String longNumber = bgOrgUnitInfo.getLongNumber();
                for (int j = 0; j < bgOrgUnitCollection.size(); ++j) {
                    BgOrgUnitInfo bgOrgUnitInfo2 = bgOrgUnitCollection.get(j);
                    String longNumber2 = bgOrgUnitInfo2.getLongNumber();
                    if (longNumber2.indexOf(longNumber) == -1 || longNumber2.equals(longNumber)) continue;
                    deleteNumbers.add(longNumber2);
                }
            }
            Iterator iterator = bgOrgUnitCollection.iterator();
            while (iterator.hasNext()) {
                BgOrgUnitInfo org = (BgOrgUnitInfo)iterator.next();
                if (!deleteNumbers.contains(org.getLongNumber())) continue;
                iterator.remove();
            }
            if (!bgOrgUnitCollection.isEmpty()) {
                bgOrgUnits = new ArrayList<BgOrgUnitInfo>();
                for (int i = 0; i < bgOrgUnitCollection.size(); ++i) {
                    bgOrgUnits.add(bgOrgUnitCollection.get(i));
                }
            }
        }
        return bgOrgUnits;
    }

    private BgOrgUnitCollection getOrgColls(Set<String> ids) throws Exception, EASBizException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("orgUnitId");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("displayName");
        evi.getSelector().add("longNumber");
        evi.getSelector().add("level");
        evi.getSelector().add("isLeaf");
        evi.getSelector().add("polAlgorithm");
        evi.getSelector().add("isOUSealUp");
        evi.getSelector().add("isVirtual");
        evi.getSelector().add("parent");
        evi.getSelector().add("parent.longNumber");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("viewId", (Object)MbgAnalyseExeHelper.getBudgetViewID(this.getBgScheme())));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnitId", ids, CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)0));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isVirtual", (Object)0));
        BgOrgUnitCollection bgOrgUnitCollection = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(evi);
        return bgOrgUnitCollection;
    }

    protected BgPeriodInfo[] getSchemePeriod(BgSchemeInfo bgSchemeInfo) throws Exception {
        if (bgSchemeInfo == null) {
            return null;
        }
        return (BgPeriodInfo[])this.getInterface().getSchemePeriod(bgSchemeInfo.getId());
    }

    @Override
    protected void btnAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddLine_actionPerformed(e);
        this.checkBgScheme();
        this.kDMember.addRow();
    }

    @Override
    protected void btnAddLine1_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddLine1_actionPerformed(e);
        IRow addRow = this.kDTable.addRow();
        MeasureUnitInfo defaultMeasure = this.getDefaultMeasure();
        if (defaultMeasure != null) {
            addRow.getCell(COL_MEASURES).setValue((Object)defaultMeasure);
        }
    }

    private MeasureUnitInfo getDefaultMeasure() throws BOSException {
        MeasureUnitInfo measureUnitInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = null;
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET"));
        filterInfo.getFilterItems().add(new FilterItemInfo("isDisabled", (Object)false));
        filterInfo.getFilterItems().add(new FilterItemInfo("isBaseUnit", (Object)true));
        view.setFilter(filterInfo);
        MeasureUnitCollection measureUnitCollection = MeasureUnitFactory.getRemoteInstance().getMeasureUnitCollection(view);
        if (measureUnitCollection != null && measureUnitCollection.size() > 0) {
            measureUnitInfo = measureUnitCollection.get(0);
        }
        return measureUnitInfo;
    }

    @Override
    protected void btnDeleteLine1_actionPerformed(ActionEvent e) throws Exception {
        super.btnDeleteLine1_actionPerformed(e);
        this.deleteRow(this.kDTable);
    }

    @Override
    protected void btnInsert_actionPerformed(ActionEvent e) throws Exception {
        super.btnInsert_actionPerformed(e);
        int rowIndex = this.kDTable.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0) {
            this.kDTable.addRow(rowIndex + 1);
        }
    }

    @Override
    protected void btnCopyLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnCopyLine_actionPerformed(e);
        int rowIndex = this.kDMember.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0) {
            IRow srcRow = this.kDMember.getRow(rowIndex);
            IRow row = this.kDMember.addRow(rowIndex + 1);
            this.copyRow(srcRow, row);
        }
    }

    protected void copyRow(IRow srcRow, IRow row) {
        if (row != null && srcRow != null) {
            if (srcRow.getCell(COL_INDEX_MEMBERS).getValue() != null) {
                row.getCell(COL_INDEX_MEMBERS).setValue(srcRow.getCell(COL_INDEX_MEMBERS).getValue());
                row.getCell(COL_INDEX_MEMBERS).setUserObject(srcRow.getCell(COL_INDEX_MEMBERS).getUserObject());
            }
            if (srcRow.getCell(COL_REF_MEMBERS).getValue() != null) {
                row.getCell(COL_REF_MEMBERS).setValue(srcRow.getCell(COL_REF_MEMBERS).getValue());
            }
        }
    }

    @Override
    protected void btnDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnDeleteLine_actionPerformed(e);
        this.deleteRow(this.kDMember);
    }

    private void deleteRow(KDTable tbl) {
        ArrayList blocks = tbl.getSelectManager().getBlocks();
        if (blocks != null) {
            KDTSelectBlock _block = null;
            int in = blocks.size();
            for (int i = 0; i < in; ++i) {
                _block = (KDTSelectBlock)blocks.get(i);
                if (_block == null) continue;
                int jn = _block.getBeginRow();
                for (int j = _block.getEndRow(); j >= jn; --j) {
                    tbl.removeRow(j);
                }
            }
        }
    }

    @Override
    protected void btnFromSelect_actionPerformed(ActionEvent e) throws Exception {
        List<String> formulas;
        String bgSchemeRootId;
        this.checkBgScheme();
        super.btnFromSelect_actionPerformed(e);
        List<OrgUnitInfo> orgUnits = this.getBgOrgUnit();
        if (orgUnits.isEmpty()) {
            this.prmtOrgUnit.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)this.getResourceStr(), (String)"selectOrgUnit"));
            return;
        }
        String string = bgSchemeRootId = this.getSelectBgScheme() != null ? this.getSelectBgScheme().getId().toString() : null;
        if (StringUtils.isEmpty((String)bgSchemeRootId)) {
            this.prmtScheme.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)this.getResourceStr(), (String)"selectBgScheme"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)BgBaseConstants.ORGUNIT_IDS, orgUnits);
        uiContext.put((Object)BgBaseConstants.BGSCHEME_ID, (Object)bgSchemeRootId);
        uiContext.put((Object)"BGSCHEME_ORGUNIT_ID", (Object)this.getBgOrgUnitViewId());
        uiContext.put((Object)"PROCESS", (Object)this.getProcessType().getValue());
        uiContext.put((Object)"EDIT", (Object)Boolean.TRUE);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getFormSelectUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        MbgAnalyseExeBlockSetUI ui = (MbgAnalyseExeBlockSetUI)uiWindow.getUIObject();
        if (!ui.isHasCancel() && (formulas = ui.getData()) != null) {
            IRow row;
            int i;
            String[] params = null;
            LinkedHashSet<String> dimItemSet = new LinkedHashSet<String>();
            LinkedHashSet<String> scenarioSet = new LinkedHashSet<String>();
            LinkedHashSet<String> elementSet = new LinkedHashSet<String>();
            LinkedHashSet<String> periodSet = new LinkedHashSet<String>();
            for (String formulaStr : formulas) {
                params = BgNFSHelper.parseFormulaPara((String)formulaStr);
                dimItemSet.add(params[0]);
                scenarioSet.add(params[3]);
                elementSet.add(params[2]);
                periodSet.add(params[1]);
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", scenarioSet, CompareType.INCLUDE));
            view.setFilter(filter);
            BgScenarioCollection bgScenarioCol = BgScenarioFactory.getRemoteInstance().getBgScenarioCollection(view);
            if (this.prmtScenario.getData() != null && this.prmtScenario.getData() instanceof Object[]) {
                Object[] obj = (Object[])this.prmtScenario.getData();
                int in = obj.length;
                for (int i2 = 0; i2 < in; ++i2) {
                    bgScenarioCol.add((BgScenarioInfo)obj[i2]);
                }
            }
            MbgViewListResultData data = new MbgViewListResultData();
            data.setMemberType(BgMemberSelectTypeEnum.Member);
            ArrayList<BgDimensionMember> resultScen = new ArrayList<BgDimensionMember>();
            BgScenarioInfo memberInfo = null;
            for (int i3 = 0; i3 < bgScenarioCol.size(); ++i3) {
                memberInfo = bgScenarioCol.get(i3);
                BgDimensionMember smember = new BgDimensionMember(DimensionConstants.DEF_SCENARIO_NUMBER, DimensionConstants.DEF_SCENARIO_NUMBER, memberInfo.getName(), memberInfo.getNumber());
                smember.setFillType(0);
                resultScen.add(smember);
            }
            data.setMembers(resultScen);
            this.prmtScenario.setData((Object)data);
            view.getFilter().getFilterItems().clear();
            filter.getFilterItems().add(new FilterItemInfo("number", elementSet, CompareType.INCLUDE));
            BgElementCollection bgElementColl = BgElementFactory.getRemoteInstance().getBgElementCollection(view);
            ArrayList<BgDimensionMember> elementList = new ArrayList<BgDimensionMember>();
            int in = bgElementColl.size();
            for (int i4 = 0; i4 < in; ++i4) {
                BgDimensionMember member = new BgDimensionMember(DimensionBaseConstants.DEF_ELEMENT_NUMBER, DimensionBaseConstants.DEF_ELEMENT_FIELD, bgElementColl.get(i4).getName(), bgElementColl.get(i4).getNumber());
                elementList.add(member);
            }
            List<BgDimensionMember> elements = this.getElements();
            elementList.removeAll(elements);
            for (i = this.kDTable.getRowCount() - 1; i >= 0; --i) {
                IRow row2 = this.kDTable.getRow(i);
                if (row2.getCell(COL_ELEMENTS) == null || row2.getCell(COL_ELEMENTS).getValue() != null) continue;
                this.kDTable.removeRow(i);
            }
            if (!elementList.isEmpty()) {
                int in2 = elementList.size();
                for (i = 0; i < in2; ++i) {
                    BgDimensionMember eleMember = (BgDimensionMember)elementList.get(i);
                    IRow addRow = this.kDTable.addRow();
                    addRow.getCell(COL_ELEMENTS).setValue((Object)eleMember);
                    MeasureUnitInfo defaultMeasure = this.getDefaultMeasure();
                    if (defaultMeasure == null) continue;
                    addRow.getCell(COL_MEASURES).setValue((Object)defaultMeasure);
                }
            }
            if (this.kDTable.getRowCount() == 1 && (row = this.kDTable.getRow(0)).getCell(COL_MEASURES) != null && row.getCell(COL_MEASURES).getValue() == null) {
                row.getCell(COL_MEASURES).setValue((Object)this.getDefaultMeasure());
            }
            ArrayList<BgPeriodInfo> periods = new ArrayList<BgPeriodInfo>();
            HashSet<String> periodIds = new HashSet<String>();
            if (this.prmtBgPeriod.getData() != null) {
                if (this.prmtBgPeriod.getData() instanceof BgPeriodInfo[]) {
                    for (BgPeriodInfo bgPeriodInfo : (BgPeriodInfo[])this.prmtBgPeriod.getData()) {
                        periods.add(bgPeriodInfo);
                        periodIds.add(bgPeriodInfo.getId().toString());
                    }
                } else if (this.prmtBgPeriod.getData() instanceof Object[]) {
                    Object[] periodInfo = (Object[])this.prmtBgPeriod.getData();
                    int in3 = periodInfo.length;
                    for (int i5 = 0; i5 < in3; ++i5) {
                        BgPeriodInfo bgPeriodInfo;
                        bgPeriodInfo = (BgPeriodInfo)periodInfo[i5];
                        periods.add(bgPeriodInfo);
                        periodIds.add(bgPeriodInfo.getId().toString());
                    }
                }
            }
            BgPeriodInfo[] periodInfos = MbgAnalyseExeHelper.getPeriodInfoByNumber(bgSchemeRootId, periodSet);
            int in4 = periodInfos.length;
            for (int i6 = 0; i6 < in4; ++i6) {
                if (periodIds.contains(periodInfos[i6].getId().toString())) continue;
                periods.add(periodInfos[i6]);
            }
            this.prmtBgPeriod.setData((Object)periods.toArray(new BgPeriodInfo[periods.size()]));
            ArrayList dimItems = new ArrayList(dimItemSet);
            List result = MBgAnalyseFacadeFactory.getRemoteInstance().getAnalyseMember(bgSchemeRootId, orgUnits.get(0).getId(), dimItems);
            if (result != null) {
                IRow row3 = null;
                String key = null;
                BgDimensionMember _bgMember = null;
                List<BgDimensionMember> tmpList = null;
                HashSet<String> keySet = new HashSet<String>();
                int in5 = this.kDMember.getRowCount();
                for (int i7 = 0; i7 < in5; ++i7) {
                    row3 = this.kDMember.getRow(i7);
                    key = "";
                    tmpList = this.getIndexMember(row3);
                    if (tmpList != null && !tmpList.isEmpty()) {
                        _bgMember = tmpList.get(0);
                        key = key + _bgMember.getSrcNumber() + ":" + _bgMember.getNumber();
                    }
                    if (row3.getCell(COL_REF_MEMBERS) != null && row3.getCell(COL_REF_MEMBERS).getValue() != null) {
                        _bgMember = (BgDimensionMember)row3.getCell(COL_REF_MEMBERS).getValue();
                        key = key + "," + _bgMember.getSrcNumber() + ":" + _bgMember.getNumber();
                    }
                    keySet.add(key);
                }
                for (AnalyseMember member : result) {
                    key = member.getBgIndex().getSrcNumber() + ":" + member.getBgIndex().getNumber();
                    if (member.getDimMember() != null) {
                        key = key + "," + member.getDimMember().getSrcNumber() + ":" + member.getDimMember().getNumber();
                    }
                    if (keySet.contains(key)) continue;
                    row3 = this.kDMember.addRow();
                    if (member.getBgIndex() != null) {
                        tmpList = new ArrayList<BgDimensionMember>();
                        tmpList.add(member.getBgIndex());
                        row3.getCell(COL_INDEX_MEMBERS).setValue(tmpList);
                    }
                    if (member.getDimMember() == null) continue;
                    row3.getCell(COL_REF_MEMBERS).setValue((Object)member.getDimMember());
                }
            }
        }
    }

    protected String getFormSelectUIName() {
        return MbgAnalyseExeBlockSetUI.class.getName();
    }

    @Override
    protected void prmtCurrency_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCurrency_dataChanged(e);
    }

    public boolean verify() {
        boolean re = super.verify();
        if (re) {
            try {
                return this.check();
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
                this.handUIException(e);
            }
        }
        return re;
    }

    protected FilterParam createFilterParam() {
        return new DataAnalyseFilterParam();
    }

    protected void loadCustomerParams(CustomerParams cp, FilterParam filterParam) {
        int i;
        super.loadCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof DataAnalyseFilterParam)) {
            return;
        }
        String id = null;
        List members = null;
        ArrayList ids = new ArrayList();
        DataAnalyseFilterParam _filterParam = (DataAnalyseFilterParam)filterParam;
        id = cp.getCustomerParam(this.ANALYSE_SCHEME_ID);
        if (!StringUtils.isEmpty((String)id)) {
            _filterParam.setBgScheme(new BgSchemeInfo());
            _filterParam.getBgScheme().setId(BOSUuid.read((String)id));
        } else {
            _filterParam.setBgScheme(null);
        }
        members = (List)BgAnalyseHelper.getObject((byte[])BgAnalyseHelper.decode((String)cp.getCustomerParam(this.ANALYSE_MEMBER)));
        if (members != null) {
            _filterParam.getMembers().addAll(members);
        } else {
            _filterParam.getMembers().clear();
        }
        id = cp.getCustomerParam(this.ANALYSE_SHOWDETAILTYPE);
        if (!StringUtils.isEmpty((String)id)) {
            _filterParam.setShowDetailOfEmptyMember(Boolean.parseBoolean(id));
        } else {
            _filterParam.setShowDetailOfEmptyMember(false);
        }
        ids = (ArrayList)BgAnalyseHelper.decodeObject((String)cp.getCustomerParam("ANALYSE_BGPERIOD_IDS"));
        if (ids != null && !ids.isEmpty()) {
            BgPeriodInfo[] bgPeriodInfos = new BgPeriodInfo[ids.size()];
            for (i = 0; i < ids.size(); ++i) {
                bgPeriodInfos[i] = new BgPeriodInfo();
                bgPeriodInfos[i].setId(BOSUuid.read((String)((String)ids.get(i))));
            }
            _filterParam.setBgPeriods(bgPeriodInfos);
        } else {
            _filterParam.setBgPeriods(null);
        }
        id = cp.getCustomerParam(this.ANALYSE_CURRENCY_ID);
        if (!StringUtils.isEmpty((String)id)) {
            _filterParam.setCurrency(new CurrencyInfo());
            _filterParam.getCurrency().setId(BOSUuid.read((String)id));
        } else {
            _filterParam.setCurrency(null);
        }
        ids = (ArrayList)BgAnalyseHelper.decodeObject((String)cp.getCustomerParam("ANALYSE_BGSCENARIO_ID"));
        if (ids != null && !ids.isEmpty()) {
            BgScenarioInfo[] bgScenarioInfos = new BgScenarioInfo[ids.size()];
            for (i = 0; i < ids.size(); ++i) {
                bgScenarioInfos[i] = new BgScenarioInfo();
                bgScenarioInfos[i].setId(BOSUuid.read((String)((String)ids.get(i))));
            }
            _filterParam.setBgScenarios(bgScenarioInfos);
        } else {
            _filterParam.setBgScenarios(null);
        }
        ids = (ArrayList)BgAnalyseHelper.decodeObject((String)cp.getCustomerParam("ANALYSE_BGVERSION_ID"));
        if (ids != null && !ids.isEmpty()) {
            BgVersionInfo[] bgVersionInfos = new BgVersionInfo[ids.size()];
            for (i = 0; i < ids.size(); ++i) {
                bgVersionInfos[i] = new BgVersionInfo();
                bgVersionInfos[i].setId(BOSUuid.read((String)((String)ids.get(i))));
            }
            _filterParam.setBgVersions(bgVersionInfos);
        } else {
            _filterParam.setBgVersions(null);
        }
        BgProcessEnum process = (BgProcessEnum)BgAnalyseHelper.decodeObject((String)cp.getCustomerParam("ANALYSE_BGPROCESS"));
        if (process != null) {
            _filterParam.setProcessType(process);
        } else {
            _filterParam.setProcessType(null);
        }
        List eleUnitMembers = (List)BgAnalyseHelper.getObject((byte[])BgAnalyseHelper.decode((String)cp.getCustomerParam(this.ANALYSE_ELE_UNIT)));
        if (eleUnitMembers != null) {
            _filterParam.getEleUnitMembers().addAll(eleUnitMembers);
        } else {
            _filterParam.getEleUnitMembers().clear();
        }
        MbgViewListManager view = (MbgViewListManager)BgAnalyseHelper.getObject((byte[])BgAnalyseHelper.decode((String)cp.getCustomerParam(this.ANALYSE_VIEW)));
        if (view != null) {
            _filterParam.setView(view);
        } else {
            _filterParam.setView(null);
        }
        Boolean auditBudgetData = (Boolean)BgAnalyseHelper.decodeObject((String)cp.getCustomerParam("ANALYSE_AUDIT_BUDGETDATA"));
        _filterParam.setOnlyShowAuditBudgetData(auditBudgetData != null ? auditBudgetData : true);
        Boolean hideMbgDim = (Boolean)BgAnalyseHelper.decodeObject((String)cp.getCustomerParam("ANALYSE_HIDE_MBGDIM"));
        _filterParam.setHideMbgDim(hideMbgDim != null ? hideMbgDim : false);
    }

    protected void saveCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.saveCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof DataAnalyseFilterParam)) {
            return;
        }
        ArrayList<String> bgPeriodIds = null;
        DataAnalyseFilterParam _filterParam = (DataAnalyseFilterParam)filterParam;
        if (_filterParam.getBgScheme() != null) {
            cp.addCustomerParam(this.ANALYSE_SCHEME_ID, _filterParam.getBgScheme().getId().toString());
        } else {
            cp.removeCustomerParam(this.ANALYSE_SCHEME_ID);
        }
        cp.addCustomerParam(this.ANALYSE_SHOWDETAILTYPE, Boolean.toString(_filterParam.isShowDetailOfEmptyMember()));
        if (_filterParam.getBgPeriods().length != 0) {
            bgPeriodIds = new ArrayList<String>();
            for (BgPeriodInfo bg : _filterParam.getBgPeriods()) {
                bgPeriodIds.add(bg.getId().toString());
            }
            cp.addCustomerParam(this.ANALYSE_BGPERIOD_IDS, BgAnalyseHelper.encode((byte[])BgAnalyseHelper.getBytes(bgPeriodIds)));
        } else {
            cp.removeCustomerParam(this.ANALYSE_BGPERIOD_IDS);
        }
        if (!_filterParam.getMembers().isEmpty()) {
            cp.addCustomerParam(this.ANALYSE_MEMBER, BgAnalyseHelper.encode((byte[])BgAnalyseHelper.getBytes(_filterParam.getMembers())));
        } else {
            cp.removeCustomerParam(this.ANALYSE_MEMBER);
        }
        if (!_filterParam.getEleUnitMembers().isEmpty()) {
            cp.addCustomerParam(this.ANALYSE_ELE_UNIT, BgAnalyseHelper.encode((byte[])BgAnalyseHelper.getBytes(_filterParam.getEleUnitMembers())));
        } else {
            cp.removeCustomerParam(this.ANALYSE_ELE_UNIT);
        }
        if (_filterParam.getCurrency() != null) {
            cp.addCustomerParam(this.ANALYSE_CURRENCY_ID, _filterParam.getCurrency().getId().toString());
        } else {
            cp.removeCustomerParam(this.ANALYSE_CURRENCY_ID);
        }
        BgScenarioInfo[] bgScenarios = _filterParam.getBgScenarios();
        ArrayList<String> bgScenariosArray = new ArrayList<String>();
        for (int i = 0; i < bgScenarios.length; ++i) {
            bgScenariosArray.add(bgScenarios[i].getId().toString());
        }
        if (_filterParam.getBgScenarios() != null) {
            cp.addCustomerParam(this.ANALYSE_BGSCENARIO_ID, BgAnalyseHelper.encode((byte[])BgAnalyseHelper.getBytes(bgScenariosArray)));
        } else {
            cp.removeCustomerParam(this.ANALYSE_BGSCENARIO_ID);
        }
        BgVersionInfo[] bgVersion = _filterParam.getBgVersions();
        ArrayList<String> bgVersions = new ArrayList<String>();
        for (int i = 0; i < bgVersion.length; ++i) {
            bgVersions.add(bgVersion[i].getId().toString());
        }
        if (_filterParam.getBgVersions() != null) {
            cp.addCustomerParam(this.ANALYSE_BGVERSION_ID, BgAnalyseHelper.encode((byte[])BgAnalyseHelper.getBytes(bgVersions)));
        } else {
            cp.removeCustomerParam(this.ANALYSE_BGVERSION_ID);
        }
        if (_filterParam.getProcessType() != null) {
            cp.addCustomerParam(this.ANALYSE_BGPROCESS, BgAnalyseHelper.encode((byte[])BgAnalyseHelper.getBytes((Object)_filterParam.getProcessType())));
        } else {
            cp.removeCustomerParam(this.ANALYSE_BGPROCESS);
        }
        if (_filterParam.getView() != null) {
            cp.addCustomerParam(this.ANALYSE_VIEW, BgAnalyseHelper.encode((byte[])BgAnalyseHelper.getBytes((Object)_filterParam.getView())));
        } else {
            cp.removeCustomerParam(this.ANALYSE_VIEW);
        }
        cp.addCustomerParam(this.ANALYSE_HIDE_MBGDIM, BgAnalyseHelper.encode((byte[])BgAnalyseHelper.getBytes((Object)_filterParam.isHideMbgDim())));
        cp.addCustomerParam(this.ANALYSE_AUDIT_BUDGETDATA, BgAnalyseHelper.encode((byte[])BgAnalyseHelper.getBytes((Object)_filterParam.isOnlyShowAuditBudgetData())));
    }

    @Override
    protected void prmtBgPeriod_dataChanged(DataChangeEvent e) throws Exception {
        this.setBgPeriodAliasDisp();
    }

    private void setBgPeriodAliasDisp() throws EASBizException, BOSException {
        if (this.prmtOrgUnit.getData() != null && this.prmtScheme.getData() != null && this.prmtBgPeriod.getData() != null && this.prmtOrgUnit.getData() instanceof OrgUnitInfo[] && ((OrgUnitInfo[])this.prmtOrgUnit.getData()).length == 1) {
            OrgUnitInfo _orgUnit = ((OrgUnitInfo[])this.prmtOrgUnit.getData())[0];
            String orgUnitId = _orgUnit.getId().toString();
            MbgAnalyseExeHelper.addDispNameForPeriods((Object[])this.prmtBgPeriod.getData(), (BgSchemeInfo)this.prmtScheme.getData());
            BgNFCHelper.setBgPeriodF7Display(null, (KDBizPromptBox)this.prmtBgPeriod, (KDBizPromptBox)this.prmtScheme, (String)orgUnitId);
        }
    }

    protected void loadFromParams(FilterParam filterParam) {
        int i;
        super.loadFromParams(filterParam);
        if (!(filterParam instanceof DataAnalyseFilterParam)) {
            return;
        }
        DataAnalyseFilterParam _filterParam1 = (DataAnalyseFilterParam)filterParam;
        if (!_filterParam1.getOrgUnits().isEmpty()) {
            OrgUnitInfo[] orgUnits = new OrgUnitInfo[_filterParam1.getOrgUnits().size()];
            int in = _filterParam1.getOrgUnits().size();
            for (int i2 = 0; i2 < in; ++i2) {
                orgUnits[i2] = (OrgUnitInfo)_filterParam1.getOrgUnits().get(i2);
            }
            this.prmtOrgUnit.setData((Object)orgUnits);
        } else {
            this.prmtOrgUnit.setData(null);
        }
        if (!(filterParam instanceof DataAnalyseFilterParam)) {
            return;
        }
        DataAnalyseFilterParam _filterParam = (DataAnalyseFilterParam)filterParam;
        this.prmtScheme.setData((Object)_filterParam.getBgScheme());
        IRow row = null;
        AnalyseMember member = null;
        ArrayList<BgDimensionMember> members = null;
        this.kDMember.removeRows();
        int in = _filterParam.getMembers().size();
        for (int i3 = 0; i3 < in; ++i3) {
            member = _filterParam.getMembers().get(i3);
            row = this.kDMember.addRow();
            if (member.getBgIndex() != null) {
                members = new ArrayList<BgDimensionMember>();
                members.add(member.getBgIndex());
                row.getCell(COL_INDEX_MEMBERS).setValue(members);
            }
            if (member.getDimMember() == null) continue;
            row.getCell(COL_REF_MEMBERS).setValue((Object)member.getDimMember());
        }
        this.getUnitTable().removeRows();
        AnalyseEleUnit eleUnitMember = null;
        int in2 = _filterParam.getEleUnitMembers().size();
        for (int i4 = 0; i4 < in2; ++i4) {
            eleUnitMember = _filterParam.getEleUnitMembers().get(i4);
            row = this.getUnitTable().addRow();
            if (eleUnitMember.getDimMember() != null) {
                row.getCell(0).setValue((Object)eleUnitMember.getDimMember());
            }
            if (eleUnitMember.getUnit() == null) continue;
            row.getCell(1).setValue((Object)eleUnitMember.getUnit());
        }
        this.prmtBgPeriod.setData((Object)_filterParam.getBgPeriods());
        this.prmtCurrency.setData((Object)_filterParam.getCurrency());
        if (_filterParam.getBgScenarios() != null) {
            MbgViewListResultData data = new MbgViewListResultData();
            data.setMemberType(BgMemberSelectTypeEnum.Member);
            ArrayList<BgDimensionMember> result = new ArrayList<BgDimensionMember>();
            BgScenarioInfo memberInfo = null;
            for (i = 0; i < _filterParam.getBgScenarios().length; ++i) {
                memberInfo = _filterParam.getBgScenarios()[i];
                BgDimensionMember smember = new BgDimensionMember(DimensionConstants.DEF_SCENARIO_NUMBER, DimensionConstants.DEF_SCENARIO_NUMBER, memberInfo.getName(), memberInfo.getNumber());
                smember.setFillType(0);
                result.add(smember);
            }
            data.setMembers(result);
            this.prmtScenario.setData((Object)data);
        } else {
            this.prmtScenario.setData((Object)_filterParam.getBgScenarios());
        }
        this.prmtBgVersion.setData((Object)_filterParam.getBgVersions());
        BgProcessEnum processType = _filterParam.getProcessType();
        this.loadProcessType(processType);
        this.cbxAuditBudgetData.setSelected(_filterParam.isOnlyShowAuditBudgetData());
        this.chxHideMbgDim.setSelected(_filterParam.isHideMbgDim());
        if (_filterParam.getBgOrgUnits() != null) {
            BgOrgUnitInfo[] bgOrgUnitsTemp = _filterParam.getBgOrgUnits();
            BgOrgUnitInfo[] bgOrgUnits = new BgOrgUnitInfo[_filterParam.getBgOrgUnits().length];
            int in3 = _filterParam.getBgOrgUnits().length;
            for (i = 0; i < in3; ++i) {
                bgOrgUnits[i] = bgOrgUnitsTemp[i];
            }
            this.prmtBgOrgUnit.setDataNoNotify((Object)bgOrgUnits);
        } else {
            this.prmtBgOrgUnit.setDataNoNotify(null);
        }
    }

    private void loadProcessType(BgProcessEnum processType) {
        if (processType != null) {
            this.setProcessType(processType);
            if (processType.equals((Object)BgProcessEnum.C01)) {
                this.btnRdBudget.setSelected(true);
            } else if (processType.equals((Object)BgProcessEnum.C02)) {
                this.btnRdDecompose.setSelected(true);
            } else if (processType.equals((Object)BgProcessEnum.C03)) {
                this.btnRdDecomposeSend.setSelected(true);
            } else if (processType.equals((Object)BgProcessEnum.C04)) {
                this.btnRdDecomposeGather.setSelected(true);
            }
        }
    }

    protected void saveToParams(FilterParam filterParam) {
        try {
            BgScenarioInfo[] bgScenarioInfos;
            Object[] tmpArr;
            int i;
            int in;
            List<BgDimensionMember> members;
            AnalyseMember member;
            IRow row;
            this.check();
            super.saveToParams(filterParam);
            if (!(filterParam instanceof DataAnalyseFilterParam)) {
                return;
            }
            DataAnalyseFilterParam _filterParam = (DataAnalyseFilterParam)filterParam;
            if (this.prmtScheme.getData() instanceof BgSchemeInfo) {
                _filterParam.setBgScheme((BgSchemeInfo)this.prmtScheme.getData());
            } else {
                _filterParam.setBgScheme(null);
            }
            _filterParam.getMembers().clear();
            if (this.kDMember.getRowCount() > 0) {
                row = null;
                member = null;
                members = null;
                in = this.kDMember.getRowCount();
                for (i = 0; i < in; ++i) {
                    row = this.kDMember.getRow(i);
                    member = new AnalyseMember();
                    members = this.getIndexMember(row);
                    if (members != null && !members.isEmpty()) {
                        member.setBgIndex(members.get(0));
                    } else {
                        member.setBgIndex(null);
                    }
                    if (row.getCell(COL_REF_MEMBERS).getValue() != null) {
                        member.setDimMember((BgDimensionMember)row.getCell(COL_REF_MEMBERS).getValue());
                    }
                    _filterParam.getMembers().add(member);
                }
            }
            _filterParam.getEleUnitMembers().clear();
            if (this.getUnitTable().getRowCount() > 0) {
                row = null;
                member = null;
                members = null;
                in = this.getUnitTable().getRowCount();
                for (i = 0; i < in; ++i) {
                    row = this.getUnitTable().getRow(i);
                    member = new AnalyseEleUnit();
                    if (row.getCell(0).getValue() instanceof BgDimensionMember) {
                        member.setDimMember((BgDimensionMember)row.getCell(0).getValue());
                    } else {
                        member.setDimMember(null);
                    }
                    if (row.getCell(1).getValue() instanceof MeasureUnitInfo) {
                        member.setUnit((MeasureUnitInfo)row.getCell(1).getValue());
                    } else {
                        member.setUnit(null);
                    }
                    _filterParam.getEleUnitMembers().add((AnalyseEleUnit)member);
                }
            }
            if (this.prmtBgPeriod.getData() instanceof BgPeriodInfo[]) {
                _filterParam.setBgPeriods((BgPeriodInfo[])this.prmtBgPeriod.getData());
            } else {
                _filterParam.setBgPeriods(null);
            }
            if (this.prmtCurrency.getData() instanceof CurrencyInfo) {
                _filterParam.setCurrency((CurrencyInfo)this.prmtCurrency.getData());
            } else {
                _filterParam.setCurrency(null);
            }
            if (this.prmtScenario.getData() instanceof Object[]) {
                tmpArr = (Object[])this.prmtScenario.getData();
                bgScenarioInfos = new BgScenarioInfo[((Object[])this.prmtScenario.getData()).length];
                for (int i2 = 0; i2 < bgScenarioInfos.length; ++i2) {
                    bgScenarioInfos[i2] = (BgScenarioInfo)tmpArr[i2];
                }
                _filterParam.setBgScenarios(bgScenarioInfos);
            } else if (this.prmtScenario.getData() instanceof MbgViewListResultData) {
                MbgViewListResultData data = (MbgViewListResultData)this.prmtScenario.getData();
                bgScenarioInfos = this.getScenarios().toArray(new BgScenarioInfo[data.getMembers().size()]);
                _filterParam.setBgScenarios(bgScenarioInfos);
            } else {
                _filterParam.setBgScenarios(null);
            }
            if (this.prmtBgVersion.getData() instanceof Object[]) {
                tmpArr = (Object[])this.prmtBgVersion.getData();
                BgVersionInfo[] bgVersionInfos = new BgVersionInfo[((Object[])this.prmtBgVersion.getData()).length];
                for (int i3 = 0; i3 < bgVersionInfos.length; ++i3) {
                    bgVersionInfos[i3] = (BgVersionInfo)tmpArr[i3];
                }
                _filterParam.setBgVersions(bgVersionInfos);
            } else if (this.prmtBgVersion.getData() instanceof BgVersionInfo) {
                BgVersionInfo[] bgVersionInfos = new BgVersionInfo[]{(BgVersionInfo)this.prmtBgVersion.getData()};
                _filterParam.setBgVersions(bgVersionInfos);
            } else {
                _filterParam.setBgVersions(null);
            }
            _filterParam.setProcessType(this.getProcessType());
            _filterParam.setOnlyShowAuditBudgetData(this.cbxAuditBudgetData.isSelected());
            _filterParam.setHideMbgDim(this.chxHideMbgDim.isSelected());
            _filterParam.setView(this.getView());
            if (this.prmtBgOrgUnit.getData() instanceof BgOrgUnitInfo[]) {
                BgOrgUnitInfo[] orgUnits = (BgOrgUnitInfo[])this.prmtBgOrgUnit.getData();
                _filterParam.setBgOrgUnits(orgUnits);
            } else if (this.prmtBgOrgUnit.getData() instanceof BgOrgUnitInfo) {
                BgOrgUnitInfo _orgUnit = (BgOrgUnitInfo)this.prmtBgOrgUnit.getData();
                BgOrgUnitInfo[] orgUnits = new BgOrgUnitInfo[]{_orgUnit};
                _filterParam.setBgOrgUnits(orgUnits);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            this.handUIException(e);
        }
    }

    public boolean check() throws BOSException {
        IRow row;
        int i;
        int in;
        if (this.prmtOrgUnit.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"costNorNull"));
            return false;
        }
        if (this.prmtScheme.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"schemeNotNull"));
            return false;
        }
        if (this.prmtBgOrgUnit.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgDataQueryResource", (String)"msgCheckSelect", (Object[])new Object[]{this.contBgOrgUnit.getBoundLabelText()}));
            return false;
        }
        List<BgDimensionMember> members = null;
        if (this.kDMember.getRowCount() > 0) {
            in = this.kDMember.getRowCount();
            for (i = 0; i < in; ++i) {
                row = this.kDMember.getRow(i);
                members = this.getIndexMember(row);
                if (members != null && !members.isEmpty()) continue;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"accountNotNull"));
                return false;
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"accountNotNull"));
            return false;
        }
        if (this.getUnitTable().getRowCount() > 0) {
            in = 0;
            for (i = this.getUnitTable().getRowCount() - 1; i >= in; --i) {
                row = this.getUnitTable().getRow(i);
                if (row.getCell(0).getValue() == null) {
                    if (this.getUnitTable().getRowCount() != 1) {
                        this.getUnitTable().removeRow(i);
                        continue;
                    }
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"eleNotNull"));
                    return false;
                }
                if (row.getCell(1).getValue() != null) continue;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"measureUnitNotNull"));
                return false;
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"measureUnitOrEleNotNull"));
            return false;
        }
        List<BgScenarioInfo> bgScenarioInfos = this.getScenarios();
        if (bgScenarioInfos == null || bgScenarioInfos.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"scenNotNull"));
            return false;
        }
        if (this.getPeriods() == null || this.getPeriods().isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"periodNotNull"));
            return false;
        }
        if (this.getVersions() == null || this.getVersions().isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"versionNotNull"));
            return false;
        }
        if (this.getCurrencys() == null || this.getCurrencys().isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"CurrencyNotNull"));
            return false;
        }
        return this.checkAnalyseObj();
    }

    private boolean checkAnalyseObj() throws BOSException {
        List<String> analyseObjTexts = this.getAnalyseObjs();
        if (analyseObjTexts == null || analyseObjTexts.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"lessThanOne"));
            return false;
        }
        boolean onlyOneScenType = this.isOnlyOneType();
        boolean onlyActDataType = this.isOnlyActDataType();
        boolean onlyBgDataType = this.isOnlyBgDataType();
        boolean isExists = false;
        boolean isSelectCurData = false;
        for (int i = 0; i < analyseObjTexts.size(); ++i) {
            String analyseObj = analyseObjTexts.get(i);
            int scenType = BgAnalyseObjConstants.getScenType((String)analyseObj);
            if (BgAnalyseObjConstants.r15.equals(analyseObj)) {
                isSelectCurData = true;
            }
            if (onlyActDataType && 0 == scenType) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"onlyActDataType"));
                return false;
            }
            if (onlyActDataType && BgAnalyseObjConstants.r15.equals(analyseObj) && !this.isOnlyExeVe()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"onlyExeVeByAct"));
                return false;
            }
            if (onlyBgDataType && 1 == scenType) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"onlyBgDataType"));
                return false;
            }
            if (BgAnalyseObjConstants.isSelectedExe((String)analyseObj)) {
                isExists = true;
            }
            if (!this.isOnlyExeVe() && 2 == scenType) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"onlyExeVeByExe"));
                return false;
            }
            if (this.isOnlyExeVe() || 1 != scenType) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"onlyExeVeByAct"));
            return false;
        }
        if (isExists && !onlyOneScenType) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"onlyScenType"));
            return false;
        }
        if (isExists && !isSelectCurData) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"selectCurData"));
            return false;
        }
        return true;
    }

    private boolean isOnlyExeVe() throws BOSException {
        BgVersionCollection bgVersionCollection;
        List<BgVersionInfo> versions = this.getVersions();
        if (versions == null || versions.isEmpty() || versions.size() != 1) {
            return false;
        }
        BgVersionInfo bgVersionInfo = versions.get(0);
        return bgVersionInfo != null && (bgVersionCollection = BgVersionFactory.getRemoteInstance().getBgVersionCollection("select id, number, name, isSysData where id='" + bgVersionInfo.getId().toString() + "'")) != null && bgVersionCollection.get(0).getIsSysData() == 1;
    }

    private List<String> getAnalyseObjs() {
        return this.getOwnerUi().getAnalyseObjs();
    }

    protected List<BgDimensionMember> getIndexMember(IRow row) {
        List members = row.getCell(COL_INDEX_MEMBERS).getValue() instanceof List ? (List)row.getCell(COL_INDEX_MEMBERS).getValue() : (row.getCell(COL_INDEX_MEMBERS).getUserObject() instanceof List ? (List)row.getCell(COL_INDEX_MEMBERS).getUserObject() : null);
        return members;
    }

    public void clear() {
        super.clear();
        this.prmtScheme.setDataNoNotify(null);
        this.prmtOrgUnit.setData((Object)SysContext.getSysContext().getCurrentCostUnit());
        try {
            this.setBgSchemeFilter();
            this.setOrgUnitFilter();
        }
        catch (Exception e1) {
            logger.error((Object)"", (Throwable)e1);
        }
        this.kDMember.removeRows();
        this.prmtBgPeriod.setData(null);
        this.prmtScenario.setData(null);
        try {
            this.getUnitTable().removeRows();
            IRow addRow = this.getUnitTable().addRow();
            MeasureUnitInfo defaultMeasure = this.getDefaultMeasure();
            if (defaultMeasure != null) {
                addRow.getCell(COL_MEASURES).setValue((Object)defaultMeasure);
            }
            BgSchemeUtils.setDefualtMembers((BgSchemeDimensionHelper)this.getSchemeHelper(), (JComponent)this.prmtBgVersion, null, (JComponent)this.prmtCurrency, (boolean)false, (boolean)false);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.error((Object)"", (Throwable)e);
        }
        this.btnRdBudget.setSelected(true);
    }

    @Override
    protected void prmtScenario_willShow(SelectorEvent e) throws Exception {
        this.checkBgScheme();
    }

    @Override
    protected void prmtBgVersion_willShow(SelectorEvent e) throws Exception {
        this.checkBgScheme();
    }

    @Override
    protected void prmtBgPeriod_willShow(SelectorEvent e) throws Exception {
        if (this.prmtBgPeriod.getSelector() instanceof BgPeriodDialog) {
            BgPeriodDialog bgPeriodDialog = (BgPeriodDialog)this.prmtBgPeriod.getSelector();
            BgPeriodInfo periodInfo = null;
            Object objPeriod = this.prmtBgPeriod.getData();
            if (objPeriod != null && objPeriod instanceof BgPeriodInfo) {
                periodInfo = (BgPeriodInfo)objPeriod;
                BgPeriodInfo[] periodArray = new BgPeriodInfo[]{periodInfo};
                bgPeriodDialog.setBgPeriods(periodArray);
            } else if (objPeriod != null && objPeriod instanceof BgPeriodInfo[]) {
                bgPeriodDialog.setBgPeriods((BgPeriodInfo[])objPeriod);
            } else {
                bgPeriodDialog.setBgPeriods(null);
            }
        }
        this.checkBgScheme();
    }

    @Override
    protected void prmtCurrency_willShow(SelectorEvent e) throws Exception {
        this.checkBgScheme();
    }

    private void checkBgScheme() {
        if (this.prmtScheme.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)this.getResourceStr(), (String)"selectBgScheme"));
            SysUtil.abort();
        }
    }

    @Override
    protected void kDTable_editStopped(KDTEditEvent e) throws Exception {
        KDTable KDUnit = this.getUnitTable();
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String colName = KDUnit.getColumnKey(colIndex);
        if (COL_ELEMENTS.equals(colName)) {
            KDTRange range = KDUnit.getSelectManager().toRange();
            KDTSelectBlock block = (KDTSelectBlock)range.get(0);
            int firstInsertRow = block.getBeginRow();
            Object object = KDUnit.getCell(rowIndex, colIndex).getValue();
            if (object instanceof List) {
                int i;
                int maxRow;
                int leftRow;
                List result = (List)object;
                int size = result.size();
                if (size > (leftRow = (maxRow = KDUnit.getRowCount()) - (firstInsertRow + 1))) {
                    for (i = leftRow; i < size - 1; ++i) {
                        KDUnit.addRow();
                    }
                }
                for (i = 0; i < result.size(); ++i) {
                    BgDimensionMember info = (BgDimensionMember)result.get(i);
                    KDUnit.getCell(firstInsertRow, 0).setValue((Object)info);
                    KDUnit.getCell(firstInsertRow, 1).setValue((Object)this.getDefaultMeasure());
                    ++firstInsertRow;
                }
            }
        }
    }

    private KDTable getUnitTable() {
        return this.kDTable;
    }

    private KDTable getAccTable() {
        return this.kDMember;
    }

    public MbgViewListManager getView() throws Exception {
        long start = System.currentTimeMillis();
        MbgViewListManager view = null;
        try {
            view = this.getViewBySettings();
        }
        catch (Exception e) {
            logger.info((Object)("getView() cost time:" + (System.currentTimeMillis() - start)));
            this.deleteLayoutInfo();
            throw e;
        }
        return view;
    }

    private MbgViewListManager getViewBySettings() throws Exception {
        MbgViewListManager loaManagerForDataAnalyse = null;
        try {
            LinkedHashMap<String, MbgViewListDimensionInfo> dimMap = new LinkedHashMap<String, MbgViewListDimensionInfo>();
            this.getBgSchemeDimensionHelper();
            this.buildDimension(dimMap, this.schemeDimensionHelper);
            BgDataAnalyseLayoutSettingInfo layoutInfo = this.getLayoutInfo();
            MbgViewListManager viewManager = null;
            BgSchemeInfo bgSchemeInfo = this.getBgScheme();
            Set extDimNums = bgSchemeInfo.getExtDimNumsWithoutCsl();
            Map<String, BgDimensionMember> extSumMember = this.getExtSumMember(bgSchemeInfo);
            this.cacheLongNumber(bgSchemeInfo, extDimNums, extSumMember);
            if (layoutInfo == null) {
                viewManager = this.buildDefaultViewListManager(extDimNums, extSumMember);
                if (viewManager == null) {
                    return null;
                }
                this.buildViewListManager(viewManager, dimMap, this.schemeDimensionHelper);
                this.storeMember2DefaultView(viewManager, extDimNums, extSumMember);
            } else {
                List rowDimensionNumbers = layoutInfo.getRowDimensionNumbers();
                List colDimensionNumbers = layoutInfo.getColDimensionNumbers();
                viewManager = this.buildViewListManagerByLayout(this.schemeDimensionHelper, rowDimensionNumbers, colDimensionNumbers, extDimNums, extSumMember);
                this.buildViewListByLayout(viewManager, dimMap, this.schemeDimensionHelper, rowDimensionNumbers, colDimensionNumbers);
                this.storeMember2Dimension(this.schemeDimensionHelper, viewManager, rowDimensionNumbers, colDimensionNumbers, extDimNums, extSumMember);
            }
            loaManagerForDataAnalyse = this.getBizIntegerFace().loaManagerForDataAnalyse(viewManager, this.schemeDimensionHelper.getBgSchemeId());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return loaManagerForDataAnalyse;
    }

    private void cacheLongNumber(BgSchemeInfo bgSchemeInfo, Set<String> extDimNums, Map<String, BgDimensionMember> extSumMember) throws BOSException, EASBizException {
        HashSet<BgDimensionMember> accSet = new HashSet<BgDimensionMember>();
        HashSet<BgDimensionMember> extMemSet = new HashSet<BgDimensionMember>();
        for (int i = 0; i < this.kDMember.getRowCount3(); ++i) {
            ICell accCell = this.kDMember.getCell(i, 0);
            ICell memCell = this.kDMember.getCell(i, 1);
            Object memValue = memCell.getValue();
            Object accValue = accCell.getValue();
            if (!(accValue instanceof List)) continue;
            List accs = (List)accValue;
            if (accs != null && !accs.isEmpty()) {
                accSet.addAll(accs);
            }
            List<BgDimensionMember> mems = null;
            BgDimensionMember member = null;
            if (!(memValue instanceof BgDimensionMember) || (mems = this.convertMember(member = (BgDimensionMember)memValue, extDimNums, extSumMember)) == null || mems.isEmpty()) continue;
            extMemSet.addAll(mems);
        }
        this.dealExtLongNumber(bgSchemeInfo, extMemSet);
        this.dealAccLongNumber(bgSchemeInfo, accSet);
    }

    private void dealAccLongNumber(BgSchemeInfo bgSchemeInfo, Set<BgDimensionMember> extMemSet) throws BOSException {
        HashSet<String> accNumberSet = new HashSet<String>();
        for (BgDimensionMember bgDimensionMember : extMemSet) {
            accNumberSet.add(bgDimensionMember.getNumber());
        }
        String accViewId = bgSchemeInfo.getViewId(DimensionBaseConstants.DEF_ACCOUNT_NUMBER).toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.setSelector(new SelectorItemCollection());
        filter.getFilterItems().add(new FilterItemInfo("bgAccountView.id", (Object)accViewId, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("number", accNumberSet, CompareType.INCLUDE));
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("longNumber"));
        IBgAccount accInstance = BgAccountFactory.getRemoteInstance();
        BgAccountCollection bgAccountCollection = accInstance.getBgAccountCollection(view);
        if (bgAccountCollection != null && !bgAccountCollection.isEmpty()) {
            for (int i = 0; i < bgAccountCollection.size(); ++i) {
                Map<String, String> map;
                BgAccountInfo bgAccountInfo = bgAccountCollection.get(i);
                String srcNumber = DimensionBaseConstants.DEF_INDEX_SRCNUMBER;
                String number = bgAccountInfo.getNumber();
                String longNumber = bgAccountInfo.getLongNumber();
                if (!this.cacheLongNumberMap.containsKey(srcNumber)) {
                    this.cacheLongNumberMap.put(srcNumber, new HashMap());
                }
                if ((map = this.cacheLongNumberMap.get(srcNumber)).containsKey(number)) continue;
                map.put(number, longNumber);
            }
        }
    }

    private void dealExtLongNumber(BgSchemeInfo bgSchemeInfo, Set<BgDimensionMember> extMemSet) throws BOSException {
        HashSet<String> extNumberSet = new HashSet<String>();
        for (BgDimensionMember bgDimensionMember : extMemSet) {
            extNumberSet.add(bgDimensionMember.getNumber());
        }
        Set extDimViewIdSet = bgSchemeInfo.getExtDimViewIdSet();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.setSelector(new SelectorItemCollection());
        filter.getFilterItems().add(new FilterItemInfo("viewId", (Object)extDimViewIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("number", extNumberSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("mbgDim.number", (Object)DimensionBaseConstants.DEF_CSL_NUMBER, CompareType.NOTEQUALS));
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("longNumber"));
        view.getSelector().add(new SelectorItemInfo("mbgDim.id"));
        view.getSelector().add(new SelectorItemInfo("mbgDim.name"));
        view.getSelector().add(new SelectorItemInfo("mbgDim.number"));
        view.getSelector().add(new SelectorItemInfo("mbgDim.srcNumber"));
        IMbgMember memberFacafe = MbgMemberFactory.getRemoteInstance();
        MbgMemberCollection mbgMemberCollection = memberFacafe.getMbgMemberCollection(view);
        if (mbgMemberCollection != null && !mbgMemberCollection.isEmpty()) {
            for (int i = 0; i < mbgMemberCollection.size(); ++i) {
                Map<String, String> map;
                MbgMemberInfo mbgMemberInfo = mbgMemberCollection.get(i);
                String srcNumber = mbgMemberInfo.getMbgDim().getSrcNumber();
                String number = mbgMemberInfo.getNumber();
                String longNumber = mbgMemberInfo.getLongNumber();
                if (!this.cacheLongNumberMap.containsKey(srcNumber)) {
                    this.cacheLongNumberMap.put(srcNumber, new HashMap());
                }
                if ((map = this.cacheLongNumberMap.get(srcNumber)).containsKey(number)) continue;
                map.put(number, longNumber);
            }
        }
    }

    private void storeMember2Dimension(BgSchemeDimensionHelper schemeHelper, MbgViewListManager viewManager, List<String> rowNumbers, List<String> colNumbers, Set<String> extDimNums, Map<String, BgDimensionMember> extSumMember) throws Exception {
        MbgViewListDimensionManager dimensionManager = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(0)).getDimensionManager();
        HashSet<String> otherSet = new HashSet<String>(this.schemeDimensionHelper.getAccAndOtherDim(true));
        HashSet<String> accAndOtherSet = new HashSet<String>(this.schemeDimensionHelper.getAccAndOtherDim(false));
        HashMap<String, List<BgDimensionMember>> dimMemberMap = new HashMap<String, List<BgDimensionMember>>();
        boolean isOrgOnRow = MBGViewListFormClientHelper.isOrgOnRow((MbgViewListDimensionManager)dimensionManager);
        List<BgOrgUnitInfo> orgs = this.getOrgUnits(isOrgOnRow);
        ArrayList<BgDimensionMember> orgMembers = new ArrayList<BgDimensionMember>();
        for (int i = 0; i < orgs.size(); ++i) {
            BgDimensionMember convertMember = this.convertMember((DataBaseInfo)orgs.get(i), DimensionBaseConstants.DEF_ORGUNIT_NUMBER, orgs.get(i).getOrgUnitID().toString());
            convertMember.setSortValue((Comparable)((Object)orgs.get(i).getLongNumber()));
            orgMembers.add(convertMember);
        }
        dimMemberMap.put(DimensionBaseConstants.DEF_ORGUNIT_NUMBER, orgMembers);
        List<BgPeriodInfo> periods = this.getPeriods();
        ArrayList<BgDimensionMember> periodMembers = new ArrayList<BgDimensionMember>();
        for (int i = 0; i < periods.size(); ++i) {
            BgDimensionMember convertMember = this.convertMember((DataBaseInfo)periods.get(i), DimensionBaseConstants.DEF_PERIOD_NUMBER, null);
            convertMember.setSortValue((Comparable)((Object)periods.get(i).getNumber()));
            periodMembers.add(convertMember);
        }
        dimMemberMap.put(DimensionBaseConstants.DEF_PERIOD_NUMBER, periodMembers);
        List<CurrencyInfo> currencys = this.getCurrencys();
        ArrayList<BgDimensionMember> currMembers = new ArrayList<BgDimensionMember>();
        for (int i = 0; i < currencys.size(); ++i) {
            BgDimensionMember convertMember = this.convertMember((DataBaseInfo)currencys.get(i), DimensionBaseConstants.DEF_CURRENCY_NUMBER, null);
            convertMember.setSortValue((Comparable)((Object)currencys.get(i).getNumber()));
            currMembers.add(convertMember);
        }
        dimMemberMap.put(DimensionBaseConstants.DEF_CURRENCY_NUMBER, currMembers);
        List<BgScenarioInfo> scenarios = this.getScenarios();
        ArrayList<BgDimensionMember> scenMembers = new ArrayList<BgDimensionMember>();
        for (int i = 0; i < scenarios.size(); ++i) {
            BgDimensionMember convertMember = this.convertMember((DataBaseInfo)scenarios.get(i), DimensionBaseConstants.DEF_SCENARIO_NUMBER, null);
            convertMember.setSortValue((Comparable)((Object)scenarios.get(i).getNumber()));
            scenMembers.add(convertMember);
        }
        dimMemberMap.put(DimensionBaseConstants.DEF_SCENARIO_NUMBER, scenMembers);
        List<BgVersionInfo> versions = this.getVersions();
        ArrayList<BgDimensionMember> versionMembers = new ArrayList<BgDimensionMember>();
        for (int i = 0; i < versions.size(); ++i) {
            BgDimensionMember convertMember = this.convertMember((DataBaseInfo)versions.get(i), DimensionBaseConstants.DEF_VERSION_NUMBER, null);
            convertMember.setSortValue((Comparable)((Object)versions.get(i).getNumber()));
            versionMembers.add(convertMember);
        }
        dimMemberMap.put(DimensionBaseConstants.DEF_VERSION_NUMBER, versionMembers);
        List<BgDimensionMember> elementMembers = this.getElements();
        for (int i = 0; i < elementMembers.size(); ++i) {
            BgDimensionMember bgDimensionMember = elementMembers.get(i);
            bgDimensionMember.setSortValue((Comparable)((Object)bgDimensionMember.getNumber()));
        }
        dimMemberMap.put(DimensionBaseConstants.DEF_ELEMENT_NUMBER, elementMembers);
        this.dealAllDimensionWithoutAccAndOther(rowNumbers, colNumbers, dimensionManager, dimMemberMap, accAndOtherSet);
        if (this.isOnRowColForAccAndOther(rowNumbers, otherSet)) {
            this.processRowColForAccAndOther(rowNumbers, colNumbers, dimensionManager, otherSet, true, extDimNums, extSumMember);
        } else if (this.isOnRowColForAccAndOther(colNumbers, otherSet)) {
            this.processRowColForAccAndOther(rowNumbers, colNumbers, dimensionManager, otherSet, false, extDimNums, extSumMember);
        } else if (this.isOnRowForAcc(rowNumbers)) {
            this.processRowColForAccAndOther(rowNumbers, colNumbers, dimensionManager, otherSet, true, extDimNums, extSumMember);
        } else {
            this.processRowColForAccAndOther(rowNumbers, colNumbers, dimensionManager, otherSet, false, extDimNums, extSumMember);
        }
        this.sortDimManagerMembers(dimensionManager);
    }

    private void processRowColForAccAndOther(List<String> rowNumbers, List<String> colNumbers, MbgViewListDimensionManager dimensionManager, Set<String> otherSet, boolean isRowForAcc, Set<String> extDimNums, Map<String, BgDimensionMember> extSumMember) throws EASBizException, BOSException {
        HashMap allAccs = new HashMap();
        HashMap<String, Object> allsOthersMap = new HashMap<String, Object>();
        Set<String> groupOtherSet = null;
        groupOtherSet = isRowForAcc ? this.getGroupOtherSet(rowNumbers, otherSet) : this.getGroupOtherSet(colNumbers, otherSet);
        this.dealAccAndOtherMap(allAccs, allsOthersMap, groupOtherSet, true, extDimNums, extSumMember);
        List rowCols = null;
        MbgViewListRowCol rowCol = null;
        if (isRowForAcc) {
            rowCols = dimensionManager.getRows();
            this.setAccsAndOtherMems(dimensionManager, allAccs, allsOthersMap, rowCols, groupOtherSet, extDimNums, extSumMember);
            rowCol = (MbgViewListRowCol)dimensionManager.getColumns().get(0);
            this.dealOtherDim4NotGroup(allsOthersMap, groupOtherSet, rowCol);
        } else {
            rowCols = dimensionManager.getColumns();
            this.setAccsAndOtherMems(dimensionManager, allAccs, allsOthersMap, rowCols, groupOtherSet, extDimNums, extSumMember);
            rowCol = (MbgViewListRowCol)dimensionManager.getRows().get(0);
            this.dealOtherDim4NotGroup(allsOthersMap, groupOtherSet, rowCol);
        }
        this.sortRowCols(rowCols);
    }

    private void dealOtherDim4NotGroup(Map<String, Object> allsOthersMap, Set<String> groupOtherSet, MbgViewListRowCol rowCol) {
        List dimensions = rowCol.getDimensions();
        if (dimensions != null) {
            for (int i = 0; i < dimensions.size(); ++i) {
                Object object;
                MbgViewListDimensionInfo mbgViewListDimensionInfo = (MbgViewListDimensionInfo)dimensions.get(i);
                String type = mbgViewListDimensionInfo.getType();
                if (groupOtherSet.contains(type) || DimensionBaseConstants.necessary.contains(type) || !((object = allsOthersMap.get(type)) instanceof Map)) continue;
                Map otherMap = (Map)object;
                for (Map.Entry entry : otherMap.entrySet()) {
                    List value = (List)entry.getValue();
                    this.sortMems(value);
                    mbgViewListDimensionInfo.getSelectMembers().addAll(value);
                }
            }
        }
    }

    private void setAccsAndOtherMems(MbgViewListDimensionManager dimensionManager, Object allAccs, Map<String, Object> allsOthersMap, List<IMbgViewListObject> rowCols, Set<String> groupOtherSet, Set<String> extDimNums, Map<String, BgDimensionMember> extSumMember) throws EASBizException, BOSException {
        Map allAccMap = null;
        if (allAccs instanceof Map) {
            allAccMap = (Map)allAccs;
        }
        HashSet<String> keySet = new HashSet<String>();
        if (allAccMap != null) {
            int index = 0;
            List mems = null;
            for (int i = 0; i < this.kDMember.getRowCount3(); ++i) {
                IMbgViewListObject iMbgViewListObject;
                ICell memCell;
                ICell accCell = this.kDMember.getCell(i, 0);
                if (!this.isNotRepeatComb(accCell, memCell = this.kDMember.getCell(i, 1), keySet, groupOtherSet, extDimNums, extSumMember)) continue;
                List accs = (List)allAccMap.get(i);
                if (!((iMbgViewListObject = rowCols.get(index++)) instanceof MbgViewListRowCol)) continue;
                MbgViewListRowCol rowCol = (MbgViewListRowCol)iMbgViewListObject;
                this.setRowCol(dimensionManager, accs, rowCol, DimensionBaseConstants.DEF_ACCOUNT_NUMBER);
                for (Map.Entry<String, Object> entry : allsOthersMap.entrySet()) {
                    Map otherMap;
                    if (!groupOtherSet.contains(entry.getKey()) || !(entry.getValue() instanceof Map) || !(otherMap = (Map)entry.getValue()).containsKey(i)) continue;
                    mems = (List)otherMap.get(i);
                    this.setRowCol(dimensionManager, mems, rowCol, entry.getKey());
                }
            }
        }
    }

    private boolean isNotRepeatComb(ICell accCell, ICell memCell, Set<String> keySet, Set<String> groupOtherSet, Set<String> extDimNums, Map<String, BgDimensionMember> extSumMember) throws EASBizException, BOSException {
        Object memValue = memCell.getValue();
        Object accValue = accCell.getValue();
        String key = "";
        if (!(accValue instanceof List)) {
            return false;
        }
        List accs = (List)accValue;
        List<BgDimensionMember> mems = null;
        BgDimensionMember member = null;
        if (memValue instanceof BgDimensionMember) {
            member = (BgDimensionMember)memValue;
            mems = this.convertMember(member, extDimNums, extSumMember);
        }
        if (accs != null && !accs.isEmpty()) {
            key = key + ((BgDimensionMember)accs.get(0)).getSrcNumber() + ":" + ((BgDimensionMember)accs.get(0)).getNumber();
        }
        if (groupOtherSet != null) {
            if (mems != null) {
                for (int j = 0; j < mems.size(); ++j) {
                    if (!groupOtherSet.contains(mems.get(j).getType())) continue;
                    key = key + "," + mems.get(j).getSrcNumber() + ":" + mems.get(j).getNumber();
                }
            }
        } else if (member != null) {
            key = key + "," + member.getSrcNumber() + ":" + member.getNumber();
        }
        if (!keySet.contains(key)) {
            keySet.add(key);
            return true;
        }
        return false;
    }

    private Set<String> getGroupOtherSet(List<String> rowNumbers, Set<String> otherSet) {
        HashSet<String> groupOtherSet = new HashSet<String>();
        for (int i = 0; i < rowNumbers.size(); ++i) {
            String dimNumber = rowNumbers.get(i);
            if (!otherSet.contains(dimNumber)) continue;
            groupOtherSet.add(dimNumber);
        }
        return groupOtherSet;
    }

    private void dealAccAndOtherMembers(List<String> rowNumbers, MbgViewListDimensionManager dimensionManager, Set<String> otherSet, Set<String> extDimNums, Map<String, BgDimensionMember> extSumMember) throws EASBizException, BOSException {
        boolean isRowForAcc = this.isOnRowForAcc(rowNumbers);
        ArrayList allAccs = new ArrayList();
        HashMap<String, Object> allsOthersMap = new HashMap<String, Object>();
        this.dealAccAndOtherMapNotRelate(allAccs, allsOthersMap, extDimNums, extSumMember);
        if (isRowForAcc) {
            String dimNumber = DimensionBaseConstants.DEF_ACCOUNT_NUMBER;
            MbgViewListRowCol rowCol = (MbgViewListRowCol)dimensionManager.getRows().get(0);
            this.setMembers2Dim(rowCol, allAccs, dimNumber);
            rowCol = (MbgViewListRowCol)dimensionManager.getColumns().get(0);
            for (String dimNumberItem : otherSet) {
                this.setMembers2Dim(rowCol, (List)allsOthersMap.get(dimNumberItem), dimNumberItem);
            }
        } else {
            String dimNumber = DimensionBaseConstants.DEF_ACCOUNT_NUMBER;
            MbgViewListRowCol rowCol = (MbgViewListRowCol)dimensionManager.getColumns().get(0);
            this.setMembers2Dim(rowCol, allAccs, dimNumber);
            rowCol = (MbgViewListRowCol)dimensionManager.getRows().get(0);
            for (String dimNumberItem : otherSet) {
                this.setMembers2Dim(rowCol, (List)allsOthersMap.get(dimNumberItem), dimNumberItem);
            }
        }
    }

    private void dealAccAndOtherMapNotRelate(Object allAccs, Map<String, Object> allsOthersMap, Set<String> extDimNums, Map<String, BgDimensionMember> extSumMember) throws EASBizException, BOSException {
        HashSet<String> accKeySet = new HashSet<String>();
        HashSet<String> extKeySet = new HashSet<String>();
        for (int i = 0; i < this.kDMember.getRowCount3(); ++i) {
            String number;
            BgDimensionMember bgDimensionMember;
            String accKey = "";
            ICell accCell = this.kDMember.getCell(i, 0);
            ICell memCell = this.kDMember.getCell(i, 1);
            Object memValue = memCell.getValue();
            Object accValue = accCell.getValue();
            if (!(accValue instanceof List)) continue;
            List accs = (List)accValue;
            List<BgDimensionMember> mems = null;
            BgDimensionMember member = null;
            if (memValue instanceof BgDimensionMember) {
                member = (BgDimensionMember)memValue;
                mems = this.convertMember(member, extDimNums, extSumMember);
            }
            if (accs != null && !accs.isEmpty()) {
                accKey = accKey + ((BgDimensionMember)accs.get(0)).getSrcNumber() + ":" + ((BgDimensionMember)accs.get(0)).getNumber();
            }
            if (!accKeySet.contains(accKey)) {
                accKeySet.add(accKey);
                ((List)allAccs).addAll(accs);
            }
            if (mems != null) {
                for (int j = 0; j < mems.size(); ++j) {
                    String type = mems.get(j).getType();
                    bgDimensionMember = mems.get(j);
                    number = bgDimensionMember.getNumber();
                    if (extKeySet.contains(number)) continue;
                    extKeySet.add(number);
                    if (!allsOthersMap.containsKey(type)) {
                        allsOthersMap.put(type, new ArrayList());
                    }
                    ((List)allsOthersMap.get(type)).add(mems.get(j));
                }
                continue;
            }
            for (String dimType : extDimNums) {
                bgDimensionMember = extSumMember.get(dimType);
                number = bgDimensionMember.getNumber();
                if (extKeySet.contains(number)) continue;
                extKeySet.add(number);
                if (!allsOthersMap.containsKey(dimType)) {
                    allsOthersMap.put(dimType, new ArrayList());
                }
                ((List)allsOthersMap.get(dimType)).add(bgDimensionMember);
            }
        }
    }

    private void dealAccAndOtherMap(Object allAccs, Map<String, Object> allsOthersMap, Set<String> groupOtherSet, boolean isGroup, Set<String> extDimNums, Map<String, BgDimensionMember> extSumMember) throws EASBizException, BOSException {
        HashSet<String> groupKeySet = new HashSet<String>();
        HashSet<String> memKeySet = new HashSet<String>();
        for (int i = 0; i < this.kDMember.getRowCount3(); ++i) {
            int j;
            String key = "";
            ICell accCell = this.kDMember.getCell(i, 0);
            ICell memCell = this.kDMember.getCell(i, 1);
            Object memValue = memCell.getValue();
            Object accValue = accCell.getValue();
            if (!(accValue instanceof List)) continue;
            List accs = (List)accValue;
            List<BgDimensionMember> mems = null;
            BgDimensionMember member = null;
            if (memValue instanceof BgDimensionMember) {
                member = (BgDimensionMember)memValue;
                mems = this.convertMember(member, extDimNums, extSumMember);
            }
            if (accs != null && !accs.isEmpty()) {
                key = key + ((BgDimensionMember)accs.get(0)).getSrcNumber() + ":" + ((BgDimensionMember)accs.get(0)).getNumber();
            }
            if (groupOtherSet != null) {
                if (mems != null) {
                    for (j = 0; j < mems.size(); ++j) {
                        if (!groupOtherSet.contains(mems.get(j).getType())) continue;
                        key = key + "," + mems.get(j).getSrcNumber() + ":" + mems.get(j).getNumber();
                    }
                }
            } else if (member != null) {
                key = key + "," + member.getSrcNumber() + ":" + member.getNumber();
            }
            if (!groupKeySet.contains(key)) {
                groupKeySet.add(key);
                if (!isGroup) {
                    ((List)allAccs).addAll(accs);
                } else {
                    Map map = (Map)allAccs;
                    if (!map.containsKey(i)) {
                        map.put(i, new ArrayList());
                    }
                    ((List)map.get(i)).addAll(accs);
                }
            }
            if (mems != null) {
                for (j = 0; j < mems.size(); ++j) {
                    BgDimensionMember bgDimensionMember = mems.get(j);
                    String type = bgDimensionMember.getType();
                    if (memKeySet.contains(bgDimensionMember.getSrcNumber() + ":" + bgDimensionMember.getNumber())) continue;
                    if (!groupOtherSet.contains(type)) {
                        memKeySet.add(bgDimensionMember.getSrcNumber() + ":" + bgDimensionMember.getNumber());
                    }
                    this.dealAllOther(allsOthersMap, groupOtherSet, isGroup, i, bgDimensionMember, type);
                }
                continue;
            }
            for (String dimType : extDimNums) {
                BgDimensionMember bgDimensionMember = extSumMember.get(dimType);
                String type = bgDimensionMember.getType();
                if (memKeySet.contains(bgDimensionMember.getSrcNumber() + ":" + bgDimensionMember.getNumber())) continue;
                if (!groupOtherSet.contains(type)) {
                    memKeySet.add(bgDimensionMember.getSrcNumber() + ":" + bgDimensionMember.getNumber());
                }
                this.dealAllOther(allsOthersMap, groupOtherSet, isGroup, i, bgDimensionMember, dimType);
            }
        }
    }

    private void dealAllOther(Map<String, Object> allsOthersMap, Set<String> groupOtherSet, boolean isGroup, int i, BgDimensionMember bgDimensionMember, String type) {
        if (!allsOthersMap.containsKey(type)) {
            if (!isGroup) {
                allsOthersMap.put(type, new ArrayList());
            } else {
                allsOthersMap.put(type, new HashMap());
            }
        }
        if (groupOtherSet != null) {
            if (!isGroup) {
                ((List)allsOthersMap.get(type)).add(bgDimensionMember);
            } else {
                Map map = (Map)allsOthersMap.get(type);
                if (!map.containsKey(i)) {
                    map.put(i, new ArrayList());
                }
                ((List)map.get(i)).add(bgDimensionMember);
            }
        } else {
            ((List)allsOthersMap.get(type)).add(bgDimensionMember);
        }
    }

    private void setMembers2Dim(MbgViewListRowCol rowCol, List<BgDimensionMember> mems, String dimNumber) {
        if (mems == null) {
            return;
        }
        List dimensions = rowCol.getDimensions();
        MbgViewListDimensionInfo dimension = (MbgViewListDimensionInfo)DimensionCommonHelper.searchDimension((String)dimNumber, (List)dimensions);
        if (dimension != null) {
            dimension.setMemberType(BgMemberSelectTypeEnum.Member);
            this.sortMems(mems);
            dimension.getSelectMembers().addAll(mems);
        }
    }

    private void dealAllDimensionWithoutAccAndOther(List<String> rowNumbers, List<String> colNumbers, MbgViewListDimensionManager dimensionManager, Map<String, List<BgDimensionMember>> dimMemberMap, Set<String> accAndOtherSet) {
        MbgViewListDimensionInfo dimension = null;
        List allRowCols = dimensionManager.getRowCols();
        ArrayList<String> allNumberList = new ArrayList<String>();
        allNumberList.addAll(colNumbers);
        allNumberList.addAll(rowNumbers);
        int size = allRowCols.size();
        for (int i = 0; i < size; ++i) {
            MbgViewListRowCol rowCol = (MbgViewListRowCol)allRowCols.get(i);
            List dimensions = rowCol.getDimensions();
            for (int j = 0; j < allNumberList.size(); ++j) {
                List<BgDimensionMember> mems;
                String dimNumber = (String)allNumberList.get(j);
                if (accAndOtherSet.contains(dimNumber) || (mems = dimMemberMap.get(dimNumber)) == null) continue;
                if (!dimNumber.equals(DimensionBaseConstants.DEF_SCENARIO_NUMBER) && !dimNumber.equals(DimensionBaseConstants.DEF_PERIOD_NUMBER)) {
                    this.sortMems(mems);
                }
                if ((dimension = (MbgViewListDimensionInfo)DimensionCommonHelper.searchDimension((String)dimNumber, (List)dimensions)) == null) continue;
                dimension.setMemberType(BgMemberSelectTypeEnum.Member);
                dimension.getSelectMembers().addAll(mems);
            }
        }
    }

    private void sortMems(List<BgDimensionMember> mems) {
        if (mems == null || mems.isEmpty()) {
            return;
        }
        Collections.sort(mems, new Comparator<BgDimensionMember>(){

            @Override
            public int compare(BgDimensionMember a1, BgDimensionMember a2) {
                Comparable sortValue1 = a1.getSortValue();
                Comparable sortValue2 = a2.getSortValue();
                if (!(sortValue1 instanceof String) && !(sortValue2 instanceof String)) {
                    return 0;
                }
                return sortValue1.compareTo(sortValue2);
            }
        });
    }

    private MbgViewListManager buildViewListManagerByLayout(BgSchemeDimensionHelper schemeHelper, List<String> rowDimensionNumbers, List<String> colDimensionNumbers, Set<String> extDimNums, Map<String, BgDimensionMember> extSumMember) throws EASBizException, BOSException {
        MbgViewListManager viewManager = new MbgViewListManager();
        MbgViewListSheetManager sheetManager = new MbgViewListSheetManager(viewManager);
        viewManager.getSheetManagers().add(sheetManager);
        MbgViewListDimensionManager dimensionManager = new MbgViewListDimensionManager(sheetManager);
        sheetManager.setDimensionManager(dimensionManager);
        List otherDim = this.schemeDimensionHelper.getAccAndOtherDim(true);
        HashSet<String> otherSet = new HashSet<String>(otherDim);
        if (this.isOnRowColForAccAndOther(rowDimensionNumbers, otherSet)) {
            this.dealRowColByAccTable(dimensionManager, true, rowDimensionNumbers, extDimNums, extSumMember);
        } else if (this.isOnRowColForAccAndOther(colDimensionNumbers, otherSet)) {
            this.dealRowColByAccTable(dimensionManager, false, colDimensionNumbers, extDimNums, extSumMember);
        } else if (this.isOnRowForAcc(rowDimensionNumbers)) {
            this.dealRowColByAccTable(dimensionManager, true, rowDimensionNumbers, extDimNums, extSumMember);
        } else {
            this.dealRowColByAccTable(dimensionManager, false, rowDimensionNumbers, extDimNums, extSumMember);
        }
        return viewManager;
    }

    private void dealRowCol(MbgViewListDimensionManager dimensionManager) {
        MbgViewListRowCol colObject = new MbgViewListRowCol();
        colObject.setCombin(false);
        colObject.setIndex(0);
        colObject.setInitIndex(0);
        colObject.setRelationMaps(new ArrayList());
        dimensionManager.getColumns().add(colObject);
    }

    private void dealRowColByAccTable(MbgViewListDimensionManager dimensionManager, boolean isRow, List<String> dimensionNumbers, Set<String> extDimNums, Map<String, BgDimensionMember> extSumMember) throws EASBizException, BOSException {
        int i;
        HashSet<String> dimNumberSet = null;
        if (dimensionNumbers != null) {
            dimNumberSet = new HashSet<String>(dimensionNumbers);
        }
        MbgViewListRowCol colObject = new MbgViewListRowCol();
        colObject.setCombin(false);
        colObject.setIndex(0);
        colObject.setInitIndex(0);
        colObject.setRelationMaps(new ArrayList());
        if (isRow) {
            dimensionManager.getColumns().add(colObject);
        } else {
            dimensionManager.getRows().add(colObject);
        }
        KDTable accTable = this.getAccTable();
        if (accTable == null || accTable.getRowCount3() == 0) {
            return;
        }
        IRow row = null;
        HashSet<String> keySet = new HashSet<String>();
        HashSet<String> numberSet = new HashSet<String>();
        for (i = accTable.getRowCount3() - 1; i >= 0; --i) {
            row = accTable.getRow(i);
            List<BgDimensionMember> members = this.getIndexMember(row);
            if (members.get(0) == null || members.get(0).getNumber() == null) continue;
            numberSet.add(members.get(0).getNumber());
        }
        for (i = accTable.getRowCount3() - 1; i >= 0; --i) {
            BgDimensionMember memb;
            String key = "";
            row = accTable.getRow(i);
            List<BgDimensionMember> members = this.getIndexMember(row);
            if (members != null && !members.isEmpty()) {
                key = key + members.get(0).getSrcNumber() + ":" + members.get(0).getNumber();
                String existParentMember = this.isExistParentMember(members.get(0));
                if (existParentMember != null && numberSet.contains(existParentMember)) {
                    accTable.removeRow(i);
                    continue;
                }
            }
            if ((memb = (BgDimensionMember)row.getCell(COL_REF_MEMBERS).getValue()) != null) {
                List<BgDimensionMember> mems = this.convertMember(memb, extDimNums, extSumMember);
                if (dimNumberSet != null) {
                    if (mems != null) {
                        for (int j = 0; j < mems.size(); ++j) {
                            if (!dimNumberSet.contains(mems.get(j).getType())) continue;
                            key = key + "," + mems.get(j).getSrcNumber() + ":" + mems.get(j).getNumber();
                        }
                    }
                } else {
                    key = key + "," + memb.getSrcNumber() + ":" + memb.getNumber();
                }
            }
            if (keySet.contains(key)) continue;
            keySet.add(key);
            MbgViewListRowCol rowObject = new MbgViewListRowCol();
            rowObject.setCombin(false);
            rowObject.setRelationMaps(new ArrayList());
            rowObject.setIndex(i);
            rowObject.setInitIndex(i);
            if (isRow) {
                dimensionManager.getRows().add(rowObject);
                continue;
            }
            dimensionManager.getColumns().add(rowObject);
        }
    }

    private String isExistParentMember(BgDimensionMember bgDimensionMember) {
        Map<String, String> map;
        String longNumber;
        if (bgDimensionMember == null) {
            return null;
        }
        String srcNumber = bgDimensionMember.getSrcNumber();
        String number = bgDimensionMember.getNumber();
        if (this.cacheLongNumberMap != null && this.cacheLongNumberMap.get(srcNumber) != null && (longNumber = (map = this.cacheLongNumberMap.get(srcNumber)).get(number)) != null) {
            String[] split = longNumber.split("!");
            for (int i = 0; i < split.length - 1; ++i) {
                if (!map.containsKey(split[i])) continue;
                return split[i];
            }
        }
        return null;
    }

    private boolean isOnRowColForAccAndOther(List<String> dimensionNumbers, Set<String> otherSet) {
        boolean isContainsOther = false;
        boolean isContainsAcc = false;
        for (int i = 0; i < dimensionNumbers.size(); ++i) {
            String dimensionNumber = dimensionNumbers.get(i);
            if (otherSet.contains(dimensionNumber)) {
                isContainsOther = true;
                continue;
            }
            if (!DimensionBaseConstants.DEF_ACCOUNT_NUMBER.equals(dimensionNumber)) continue;
            isContainsAcc = true;
        }
        return isContainsOther && isContainsAcc;
    }

    private boolean isOnRowOfAcc(List<String> dimensionNumbers, Set<String> otherSet) {
        boolean isContainsOther = false;
        boolean isContainsAcc = false;
        for (int i = 0; i < dimensionNumbers.size(); ++i) {
            String dimensionNumber = dimensionNumbers.get(i);
            if (otherSet.contains(dimensionNumber)) {
                isContainsOther = true;
                continue;
            }
            if (!DimensionBaseConstants.DEF_ACCOUNT_NUMBER.equals(dimensionNumber)) continue;
            isContainsAcc = true;
        }
        return isContainsOther && isContainsAcc;
    }

    private boolean isOnRowForAcc(List<String> dimensionNumbers) {
        boolean isContainsAcc = false;
        for (int i = 0; i < dimensionNumbers.size(); ++i) {
            String dimensionNumber = dimensionNumbers.get(i);
            if (!DimensionBaseConstants.DEF_ACCOUNT_NUMBER.equals(dimensionNumber)) continue;
            isContainsAcc = true;
        }
        return isContainsAcc;
    }

    private BgDataAnalyseLayoutSettingInfo getLayoutInfo() throws BOSException, EASBizException {
        BgDataAnalyseLayoutSettingCollection bgDataAnalyseLayoutSettingCollection = BgDataAnalyseLayoutSettingFactory.getRemoteInstance().getBgDataAnalyseLayoutSettingCollection("select rows, cols where user.id = '" + this.getUserId() + "' and bgScheme.id = '" + this.getBgScehemeId() + "'");
        if (bgDataAnalyseLayoutSettingCollection != null && bgDataAnalyseLayoutSettingCollection.isEmpty()) {
            return null;
        }
        return bgDataAnalyseLayoutSettingCollection.get(0);
    }

    private void deleteLayoutInfo() {
        try {
            IBgDataAnalyseLayoutSetting remoteInstance = BgDataAnalyseLayoutSettingFactory.getRemoteInstance();
            BgDataAnalyseLayoutSettingInfo layoutInfo = this.getLayoutInfo();
            if (layoutInfo != null) {
                BOSUuid id = layoutInfo.getId();
                remoteInstance.delete((IObjectPK)new ObjectUuidPK(id));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
    }

    private String getUserId() {
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        return user.getId().toString();
    }

    public Object getBgDataMap(MbgViewListManager view, List<String> analyseObjTexts, boolean isAudit) throws EASBizException, BOSException, Exception {
        MbgViewListManager _view = null;
        _view = view == null ? this.getView() : view;
        Set<String> orgIds = this.getCostOrgUnits(_view);
        long start = System.currentTimeMillis();
        Object analyseData = this.getBizIntegerFace().getAnalyseData(_view, this.getBgSchemeDimensionHelper().getBgSchemeId(), this.getDefaultBgFormInfo(), orgIds, analyseObjTexts, isAudit);
        logger.info((Object)("getBgDataMap() cost time:" + (System.currentTimeMillis() - start)));
        return analyseData;
    }

    private BgFormInfo getDefaultBgFormInfo() throws EASBizException, BOSException {
        BgSchemeInfo bgSchemeInfo = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo("where id='" + this.getBgScehemeId() + "'");
        BgFormInfo bgFormInfo = new BgFormInfo();
        bgFormInfo.setState(BgFormStateEnum.Approved);
        bgFormInfo.setBgScheme(bgSchemeInfo);
        bgFormInfo.setOrgUnit(this.getOrgs().get(0).castToFullOrgUnitInfo());
        bgFormInfo.setBgTemplate(new BgTemplateInfo());
        bgFormInfo.getBgTemplate().setFormType(BgTemFormTypeEnum.VIEWLIST);
        bgFormInfo.setBgVersion(this.getVersions().get(0));
        bgFormInfo.setProcessType(this.getProcessType());
        return bgFormInfo;
    }

    private IMBGViewListFormFacade getBizIntegerFace() throws BOSException {
        return MBGViewListFormFacadeFactory.getRemoteInstance();
    }

    private BgSchemeDimensionHelper getBgSchemeDimensionHelper() throws EASBizException, BOSException {
        String bgScehemeId = this.getBgScehemeId();
        if (bgScehemeId != null && this.schemeDimensionHelper == null || bgScehemeId != null && !bgScehemeId.equals(this.schemeDimensionHelper.getBgSchemeId())) {
            this.schemeDimensionHelper = new BgSchemeDimensionHelper(bgScehemeId);
        }
        return this.schemeDimensionHelper;
    }

    public BgSchemeInfo getBgScheme() throws EASBizException, BOSException {
        String bgScehemeId = this.getBgScehemeId();
        if (this.schemeInfo == null || bgScehemeId != null && !bgScehemeId.equals(this.schemeInfo.getId().toString())) {
            this.schemeInfo = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo("select id, name, number, bgDimSettings.members.*, bgDimSettings.dimNumber where id='" + bgScehemeId + "'");
        }
        return this.schemeInfo;
    }

    protected DimensionMemberSelectHelper createSelectHelper(BgSchemeDimensionHelper schemeHelper) throws EASBizException, BOSException {
        return new DimensionMemberSelectHelper(schemeHelper);
    }

    private void storeMember2DefaultView(MbgViewListManager viewManager, Set<String> extDimNums, Map<String, BgDimensionMember> extSumMember) throws Exception {
        MbgViewListDimensionManager dimensionManager = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(0)).getDimensionManager();
        this.setDefaultRow(dimensionManager, extDimNums, extSumMember);
        this.setDefaultCol(dimensionManager);
        this.sortDimManagerMembers(dimensionManager);
        this.sortRowCols(dimensionManager.getRows());
    }

    private void sortDimManagerMembers(MbgViewListDimensionManager dimensionManager) {
        List rowCols = dimensionManager.getRowCols();
        for (int i = 0; i < rowCols.size(); ++i) {
            MbgViewListRowCol rowCol = (MbgViewListRowCol)rowCols.get(i);
            if (rowCol == null) continue;
            List dimensions = rowCol.getDimensions();
            this.sortForDimMems(dimensions);
        }
        List allDimensions = dimensionManager.getAllDimensions();
        this.sortForDimMems(allDimensions);
    }

    private void sortRowCols(List<IMbgViewListObject> rowCols) {
        if (rowCols == null || rowCols.isEmpty()) {
            return;
        }
        Collections.sort(rowCols, new Comparator<IMbgViewListObject>(){

            @Override
            public int compare(IMbgViewListObject rc1, IMbgViewListObject rc2) {
                BgDimensionMember accMem1 = MBgDataAnalyseFilter1UI.this.getAccByRowCol(rc1);
                BgDimensionMember accMem2 = MBgDataAnalyseFilter1UI.this.getAccByRowCol(rc2);
                if (accMem1 == null || accMem2 == null) {
                    return 0;
                }
                return accMem1.getSortValue().compareTo(accMem2.getSortValue());
            }
        });
    }

    private BgDimensionMember getAccByRowCol(IMbgViewListObject rc) {
        Object object;
        BgDimensionMember accMem = null;
        List dimensions = ((MbgViewListRowCol)rc).getDimensions();
        MbgViewListDimensionInfo mbgViewListDimensionInfo = null;
        for (int i = 0; i < dimensions.size() && !DimensionBaseConstants.DEF_ACCOUNT_NUMBER.equals((mbgViewListDimensionInfo = (MbgViewListDimensionInfo)dimensions.get(i)).getNumber()); ++i) {
        }
        if (mbgViewListDimensionInfo != null && mbgViewListDimensionInfo.getSelectMembers() != null && mbgViewListDimensionInfo.getSelectMembers().size() > 0 && (object = mbgViewListDimensionInfo.getSelectMembers().get(0)) instanceof BgDimensionMember) {
            accMem = (BgDimensionMember)object;
        }
        return accMem;
    }

    private void sortForDimMems(List<MbgViewListDimensionInfo> dimensions) {
        if (dimensions != null) {
            for (int j = 0; j < dimensions.size(); ++j) {
                MbgViewListDimensionInfo dim = dimensions.get(j);
                if (dim == null || dim.getNumber().equals(DimensionBaseConstants.DEF_SCENARIO_NUMBER) || dim.getNumber().equals(DimensionBaseConstants.DEF_PERIOD_NUMBER)) continue;
                this.sortMems(dim.getSelectMembers());
            }
        }
    }

    private void dealExtDimensionEmptyMember(MbgViewListDimensionManager dimensionManager) throws EASBizException, BOSException {
        List rowCols = dimensionManager.getRowCols();
        MbgViewListDimensionInfo mbgViewListDimensionInfo = null;
        List dimensions = null;
        MbgViewListRowCol rowCol = null;
        BgSchemeInfo bgSchemeInfo = this.getBgScheme();
        Set extDimNums = bgSchemeInfo.getExtDimNumsWithoutCsl();
        Map<String, BgDimensionMember> extSumMember = this.getExtSumMember(bgSchemeInfo);
        for (IMbgViewListObject item : rowCols) {
            if (!(item instanceof MbgViewListRowCol) || (dimensions = (rowCol = (MbgViewListRowCol)item).getDimensions()) == null || dimensions.isEmpty()) continue;
            for (int i = 0; i < dimensions.size(); ++i) {
                mbgViewListDimensionInfo = (MbgViewListDimensionInfo)dimensions.get(i);
                if (!extDimNums.contains(mbgViewListDimensionInfo.getNumber()) || !mbgViewListDimensionInfo.getSelectMembers().isEmpty()) continue;
                mbgViewListDimensionInfo.getSelectMembers().add(extSumMember.get(mbgViewListDimensionInfo.getNumber()));
            }
        }
    }

    public Map<String, BgDimensionMember> getExtSumMember(BgSchemeInfo bgSchemeInfo) throws BOSException, EASBizException {
        HashMap<String, BgDimensionMember> map = new HashMap<String, BgDimensionMember>();
        IMbgMember memberFacafe = MbgMemberFactory.getRemoteInstance();
        Set extDimViewIdSet = bgSchemeInfo.getExtDimViewIdSet();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.setSelector(new SelectorItemCollection());
        filter.getFilterItems().add(new FilterItemInfo("viewId", (Object)extDimViewIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("level", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("mbgDim.number", (Object)DimensionBaseConstants.DEF_CSL_NUMBER, CompareType.NOTEQUALS));
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("mbgDim.id"));
        view.getSelector().add(new SelectorItemInfo("mbgDim.name"));
        view.getSelector().add(new SelectorItemInfo("mbgDim.number"));
        view.getSelector().add(new SelectorItemInfo("longNumber"));
        MbgMemberCollection mbgMemberCollection = memberFacafe.getMbgMemberCollection(view);
        for (int i = 0; i < mbgMemberCollection.size(); ++i) {
            MbgMemberInfo mbgMemberInfo = mbgMemberCollection.get(i);
            BgDimensionMember member = this.convertMember(mbgMemberInfo.getMbgDim().getNumber(), mbgMemberInfo.getNumber(), mbgMemberInfo.getName());
            member.setSortValue((Comparable)((Object)mbgMemberInfo.getLongNumber()));
            map.put(mbgMemberInfo.getMbgDim().getNumber(), member);
        }
        return map;
    }

    private void setDefaultCol(MbgViewListDimensionManager dimensionManager) throws EASBizException, BOSException {
        BgDimensionMember convertMember;
        int i;
        List<BgPeriodInfo> periods = this.getPeriods();
        List<BgScenarioInfo> scenarios = this.getScenarios();
        List<BgVersionInfo> versions = this.getVersions();
        List<BgDimensionMember> elementMembers = this.getElements();
        ArrayList<BgDimensionMember> periodMembers = new ArrayList<BgDimensionMember>();
        ArrayList<BgDimensionMember> scenMembers = new ArrayList<BgDimensionMember>();
        ArrayList<BgDimensionMember> versionMembers = new ArrayList<BgDimensionMember>();
        for (i = 0; periods != null && i < periods.size(); ++i) {
            convertMember = this.convertMember((DataBaseInfo)periods.get(i), DimensionBaseConstants.DEF_PERIOD_NUMBER, null);
            convertMember.setSortValue((Comparable)((Object)periods.get(i).getNumber()));
            periodMembers.add(convertMember);
        }
        for (i = 0; scenarios != null && i < scenarios.size(); ++i) {
            convertMember = this.convertMember((DataBaseInfo)scenarios.get(i), DimensionBaseConstants.DEF_SCENARIO_NUMBER, null);
            scenMembers.add(convertMember);
        }
        for (i = 0; versions != null && i < versions.size(); ++i) {
            convertMember = this.convertMember((DataBaseInfo)versions.get(i), DimensionBaseConstants.DEF_VERSION_NUMBER, null);
            convertMember.setSortValue((Comparable)((Object)versions.get(i).getNumber()));
            versionMembers.add(convertMember);
        }
        List columns = dimensionManager.getColumns();
        IMbgViewListObject iMbgViewListObject = (IMbgViewListObject)columns.get(0);
        if (iMbgViewListObject instanceof MbgViewListRowCol) {
            MbgViewListRowCol rowCol = (MbgViewListRowCol)iMbgViewListObject;
            MbgViewListDimensionInfo scenBgDimension = rowCol.searchBgDimension((MbgViewListDimensionInfo)dimensionManager.searchDimension(DimensionBaseConstants.DEF_SCENARIO_NUMBER));
            MbgViewListDimensionInfo periodDimension = rowCol.searchBgDimension((MbgViewListDimensionInfo)dimensionManager.searchDimension(DimensionBaseConstants.DEF_PERIOD_NUMBER));
            MbgViewListDimensionInfo versionDimension = rowCol.searchBgDimension((MbgViewListDimensionInfo)dimensionManager.searchDimension(DimensionBaseConstants.DEF_VERSION_NUMBER));
            MbgViewListDimensionInfo elementDimension = rowCol.searchBgDimension((MbgViewListDimensionInfo)dimensionManager.searchDimension(DimensionBaseConstants.DEF_ELEMENT_NUMBER));
            scenBgDimension.setMemberType(BgMemberSelectTypeEnum.Member);
            periodDimension.setMemberType(BgMemberSelectTypeEnum.Member);
            versionDimension.setMemberType(BgMemberSelectTypeEnum.Member);
            elementDimension.setMemberType(BgMemberSelectTypeEnum.Member);
            scenBgDimension.getSelectMembers().addAll(scenMembers);
            periodDimension.getSelectMembers().addAll(periodMembers);
            versionDimension.getSelectMembers().addAll(versionMembers);
            elementDimension.getSelectMembers().addAll(elementMembers);
        }
    }

    private void setDefaultRow(MbgViewListDimensionManager dimensionManager, Set<String> extDimNums, Map<String, BgDimensionMember> extSumMember) throws Exception {
        List rows = dimensionManager.getRows();
        boolean isOrgOnRow = MBGViewListFormClientHelper.isOrgOnRow((MbgViewListDimensionManager)dimensionManager);
        List<BgOrgUnitInfo> orgs = this.getOrgUnits(isOrgOnRow);
        ArrayList<BgDimensionMember> orgMembers = new ArrayList<BgDimensionMember>();
        for (int i = 0; i < orgs.size(); ++i) {
            BgDimensionMember convertMember = this.convertMember((DataBaseInfo)orgs.get(i), DimensionBaseConstants.DEF_ORGUNIT_NUMBER, orgs.get(i).getOrgUnitID().toString());
            convertMember.setSortValue((Comparable)((Object)orgs.get(i).getLongNumber()));
            orgMembers.add(convertMember);
        }
        List<CurrencyInfo> currencys = this.getCurrencys();
        ArrayList<BgDimensionMember> currMembers = new ArrayList<BgDimensionMember>();
        for (int i = 0; i < currencys.size(); ++i) {
            BgDimensionMember convertMember = this.convertMember((DataBaseInfo)currencys.get(i), DimensionBaseConstants.DEF_CURRENCY_NUMBER, null);
            convertMember.setSortValue((Comparable)((Object)currencys.get(i).getNumber()));
            currMembers.add(convertMember);
        }
        HashSet<String> keySet = new HashSet<String>();
        int index = 0;
        for (int i = 0; i < this.kDMember.getRowCount3(); ++i) {
            String key = "";
            ICell accCell = this.kDMember.getCell(i, 0);
            ICell memCell = this.kDMember.getCell(i, 1);
            Object memValue = memCell.getValue();
            Object accValue = accCell.getValue();
            if (!(accValue instanceof List)) continue;
            List accs = (List)accValue;
            List<BgDimensionMember> mems = null;
            BgDimensionMember member = null;
            if (memValue instanceof BgDimensionMember) {
                member = (BgDimensionMember)memValue;
                mems = this.convertMember(member, extDimNums, extSumMember);
            }
            if (accs != null && !accs.isEmpty()) {
                key = key + ((BgDimensionMember)accs.get(0)).getSrcNumber() + ":" + ((BgDimensionMember)accs.get(0)).getNumber();
            }
            if (member != null) {
                key = key + "," + member.getSrcNumber() + ":" + member.getNumber();
            }
            if (keySet.contains(key)) continue;
            keySet.add(key);
            IMbgViewListObject iMbgViewListObject = (IMbgViewListObject)rows.get(index++);
            if (!(iMbgViewListObject instanceof MbgViewListRowCol)) continue;
            MbgViewListRowCol rowCol = (MbgViewListRowCol)iMbgViewListObject;
            this.setRowCol(dimensionManager, orgMembers, rowCol, DimensionBaseConstants.DEF_ORGUNIT_NUMBER);
            this.setRowCol(dimensionManager, accs, rowCol, DimensionBaseConstants.DEF_ACCOUNT_NUMBER);
            if (mems != null) {
                for (int j = 0; j < mems.size(); ++j) {
                    this.setRowCol(dimensionManager, mems.subList(j, j + 1), rowCol, mems.get(j).getType());
                }
            } else {
                ArrayList<BgDimensionMember> memsItem = new ArrayList<BgDimensionMember>();
                for (String dimType : extDimNums) {
                    memsItem.clear();
                    memsItem.add(extSumMember.get(dimType));
                    this.setRowCol(dimensionManager, memsItem, rowCol, dimType);
                }
            }
            this.setRowCol(dimensionManager, currMembers, rowCol, DimensionBaseConstants.DEF_CURRENCY_NUMBER);
        }
    }

    private List<BgDimensionMember> convertMember(BgDimensionMember member, Set<String> extDimNums, Map<String, BgDimensionMember> extSumMember) throws EASBizException, BOSException {
        ArrayList<BgDimensionMember> mems = new ArrayList<BgDimensionMember>();
        HashSet<String> otherDim = new HashSet<String>();
        if (member != null) {
            String attribute = member.getAttribute();
            String name = member.getName();
            String number = member.getNumber();
            String srcNumber = member.getSrcNumber();
            String type = member.getType();
            if (!StringUtils.isEmpty((String)number) && number.split(BgBaseConstants.SEP_THR_STR).length > 1) {
                String[] split = number.split(BgBaseConstants.SEP_THR_STR);
                String[] typeSplit = type.split(BgBaseConstants.SEP_THR_STR);
                String[] typeNumber = number.split(BgBaseConstants.SEP_THR_STR);
                String[] typeName = name.split(BgBaseConstants.SEP_THR_STR);
                for (int i = 0; i < split.length; ++i) {
                    if (!otherDim.contains(typeSplit[i])) {
                        otherDim.add(typeSplit[i]);
                    }
                    BgDimensionMember convertMember = this.convertMember(typeSplit[i], typeNumber[i], typeName[i]);
                    mems.add(convertMember);
                }
            } else {
                if (!otherDim.contains(type)) {
                    otherDim.add(type);
                }
                mems.add(member);
            }
        }
        if (extDimNums.size() != otherDim.size()) {
            for (String dimNumber : extDimNums) {
                BgDimensionMember bgDimensionMember;
                if (otherDim.contains(dimNumber) || !extSumMember.containsKey(dimNumber) || (bgDimensionMember = extSumMember.get(dimNumber)) == null) continue;
                mems.add(bgDimensionMember);
            }
        }
        return mems;
    }

    private void setRowCol(MbgViewListDimensionManager dimensionManager, List<BgDimensionMember> mems, MbgViewListRowCol rowCol, String dimNumber) {
        if (mems == null || mems.isEmpty()) {
            return;
        }
        MbgViewListDimensionInfo dimension = rowCol.searchBgDimension((MbgViewListDimensionInfo)dimensionManager.searchDimension(dimNumber));
        dimension.setMemberType(BgMemberSelectTypeEnum.Member);
        dimension.getSelectMembers().addAll(mems);
    }

    private BgDimensionMember convertMember(String dimNumber, String memberNumber, String memName) throws EASBizException, BOSException {
        BgDimensionMember member = null;
        member = new BgDimensionMember(dimNumber, this.getBgSchemeDimensionHelper().getRefField(dimNumber), memName, memberNumber);
        member.setFillType(0);
        member.setSrcNumber(this.getBgSchemeDimensionHelper().getSrcNumber(dimNumber));
        return member;
    }

    private BgDimensionMember convertMember(DataBaseInfo info, String dimNumber, String orgId) throws EASBizException, BOSException {
        BgDimensionMember member = null;
        member = DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(dimNumber) ? new BgDimensionMember(dimNumber, orgId, info.getName(), info.getNumber()) : new BgDimensionMember(dimNumber, this.getBgSchemeDimensionHelper().getRefField(dimNumber), info.getName(), info.getNumber());
        member.setFillType(0);
        member.setSrcNumber(this.getBgSchemeDimensionHelper().getSrcNumber(dimNumber));
        return member;
    }

    public List<OrgUnitInfo> getOrgs() {
        List orgs = this.getBgOrgUnit();
        if (orgs.isEmpty()) {
            orgs = ((DataAnalyseFilterParam)this.getFilterParam()).getOrgUnits();
        }
        return orgs;
    }

    public List<BgPeriodInfo> getPeriods() {
        Object obj = this.prmtBgPeriod.getData();
        ArrayList<BgPeriodInfo> periods = new ArrayList<BgPeriodInfo>();
        this.convertToList(obj, periods);
        return periods;
    }

    public List<BgScenarioInfo> getScenarios() {
        Object obj = this.prmtScenario.getData();
        ArrayList scenarios = new ArrayList();
        ArrayList<BgScenarioInfo> scenario = null;
        this.convertToList(obj, scenarios);
        LinkedHashSet<String> scenIds = new LinkedHashSet<String>();
        if (!scenarios.isEmpty()) {
            boolean isNumber = false;
            for (int i = 0; i < scenarios.size(); ++i) {
                if (scenarios.get(i) instanceof BgDimensionMember) {
                    scenIds.add(((BgDimensionMember)scenarios.get(i)).getNumber().toString());
                    isNumber = true;
                    continue;
                }
                scenIds.add(((BgScenarioInfo)scenarios.get(i)).getId().toString());
            }
            EntityViewInfo entityViewInfo = this.prmtScenario.getEntityViewInfo();
            EntityViewInfo clone = (EntityViewInfo)entityViewInfo.clone();
            FilterInfo filter = new FilterInfo();
            if (isNumber) {
                filter.getFilterItems().add(new FilterItemInfo("number", scenIds, CompareType.INCLUDE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("id", scenIds, CompareType.INCLUDE));
            }
            clone.setFilter(filter);
            try {
                BgScenarioCollection bgScenarioCollection = BgScenarioFactory.getRemoteInstance().getBgScenarioCollection(clone);
                scenario = new ArrayList<BgScenarioInfo>();
                for (String item : scenIds) {
                    for (int i = 0; i < bgScenarioCollection.size(); ++i) {
                        BgScenarioInfo bgScenarioInfo = bgScenarioCollection.get(i);
                        if (!bgScenarioInfo.getNumber().equals(item) && !bgScenarioInfo.getId().toString().equals(item)) continue;
                        scenario.add(bgScenarioInfo);
                    }
                }
            }
            catch (BOSException e) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"scenNotNull"));
                SysUtil.abort();
            }
        }
        return scenario;
    }

    public List<BgVersionInfo> getVersions() {
        Object obj = this.prmtBgVersion.getData();
        List<BgVersionInfo> versions = new ArrayList<BgVersionInfo>();
        this.convertToList(obj, versions);
        if (versions.isEmpty() && this.getFilterParam() != null) {
            versions = Arrays.asList(((DataAnalyseFilterParam)this.getFilterParam()).getBgVersions());
        }
        return versions;
    }

    public List<CurrencyInfo> getCurrencys() {
        Object obj = this.prmtCurrency.getData();
        ArrayList<CurrencyInfo> currencys = new ArrayList<CurrencyInfo>();
        this.convertToList(obj, currencys);
        return currencys;
    }

    public Map<String, CurrencyInfo> getCurrencyMap() {
        Object obj = this.prmtCurrency.getData();
        ArrayList currencys = new ArrayList();
        this.convertToList(obj, currencys);
        HashMap<String, CurrencyInfo> curMap = new HashMap<String, CurrencyInfo>();
        if (currencys != null && !currencys.isEmpty()) {
            for (int i = 0; i < currencys.size(); ++i) {
                curMap.put(((CurrencyInfo)currencys.get(i)).getNumber(), (CurrencyInfo)currencys.get(i));
            }
        }
        return curMap;
    }

    public Map<String, MeasureUnitInfo> getEleMeasureMap() {
        HashMap<String, MeasureUnitInfo> meaMap = new HashMap<String, MeasureUnitInfo>();
        if (this.getUnitTable().getRowCount() > 0) {
            int in = this.getUnitTable().getRowCount();
            for (int i = 0; i < in; ++i) {
                IRow row = this.getUnitTable().getRow(i);
                if (!(row.getCell(1).getValue() instanceof MeasureUnitInfo) || !(row.getCell(0).getValue() instanceof BgDimensionMember)) continue;
                BgDimensionMember ele = (BgDimensionMember)row.getCell(0).getValue();
                MeasureUnitInfo unit = (MeasureUnitInfo)row.getCell(1).getValue();
                meaMap.put(ele.getNumber(), unit);
            }
        }
        return meaMap;
    }

    private List<BgDimensionMember> getElements() throws EASBizException, BOSException {
        int i;
        KDTable unitTable = this.getUnitTable();
        ArrayList<BgDimensionMember> elements = new ArrayList<BgDimensionMember>();
        for (i = 0; i < unitTable.getRowCount3(); ++i) {
            ICell cell = unitTable.getCell(i, 0);
            Object value = cell.getValue();
            if (value == null) continue;
            this.convertToList(value, elements);
        }
        if (elements != null && !elements.isEmpty()) {
            for (i = 0; i < elements.size(); ++i) {
                BgDimensionMember bgDimensionMember = (BgDimensionMember)elements.get(i);
                bgDimensionMember.setSrcNumber(this.getBgSchemeDimensionHelper().getSrcNumber(DimensionBaseConstants.DEF_ELEMENT_NUMBER));
                bgDimensionMember.setFillType(0);
            }
        }
        return elements;
    }

    private void convertToList(Object obj, List orgs) {
        block2: {
            block3: {
                if (obj == null) break block2;
                if (!(obj instanceof MbgViewListResultData)) break block3;
                MbgViewListResultData data = (MbgViewListResultData)obj;
                for (int i = 0; i < data.getMembers().size(); ++i) {
                    orgs.add(data.getMembers().get(i));
                }
                break block2;
            }
            Object[] objs = DimensionCommonHelper.getValues((Object)obj);
            if (objs == null) break block2;
            for (int i = 0; i < objs.length; ++i) {
                if (objs[i] == null) continue;
                orgs.add(objs[i]);
            }
        }
    }

    public BgDimensionMember getMemberOfRow(String memberNumber, String memName, String dimNumber, String dimRefField) throws EASBizException, BOSException {
        BgDimensionMember member = new BgDimensionMember(dimNumber, dimRefField, memName, memberNumber);
        member.setFillType(0);
        member.setSrcNumber(this.getSelectHelper().getSrcNumber(dimNumber));
        return member;
    }

    protected final DimensionMemberSelectHelper getSelectHelper() throws EASBizException, BOSException {
        if (this.selectHelper == null) {
            this.selectHelper = this.createSelectHelper(this.getBgSchemeDimensionHelper());
        }
        return this.selectHelper;
    }

    private MbgViewListManager buildDefaultViewListManager(Set<String> extDimNums, Map<String, BgDimensionMember> extSumMember) throws EASBizException, BOSException {
        KDTable accTable = this.getAccTable();
        if (accTable == null || accTable.getRowCount3() == 0) {
            return null;
        }
        MbgViewListManager viewManager = new MbgViewListManager();
        MbgViewListSheetManager sheetManager = new MbgViewListSheetManager(viewManager);
        viewManager.getSheetManagers().add(sheetManager);
        MbgViewListDimensionManager dimensionManager = new MbgViewListDimensionManager(sheetManager);
        sheetManager.setDimensionManager(dimensionManager);
        this.dealRowColByAccTable(dimensionManager, true, null, extDimNums, extSumMember);
        return viewManager;
    }

    private void buildViewListByLayout(MbgViewListManager viewManager, Map<String, MbgViewListDimensionInfo> dimMap, BgSchemeDimensionHelper schemeHelper, List<String> rowNumbers, List<String> colNumbers) {
        int i;
        MbgViewListDimensionManager dimensionManager = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(0)).getDimensionManager();
        MbgViewListDimensionInfo dimension = null;
        for (String rowItem : rowNumbers) {
            dimension = dimMap.get(rowItem);
            dimension.setMemberValueType(DimensionMemberValueModeEnum.SelectMember);
            dimension.setMemberType(BgMemberSelectTypeEnum.Member);
            dimension.setLayout("row");
            List rows = dimensionManager.getRows();
            for (i = 0; i < rows.size(); ++i) {
                ((MbgViewListRowCol)rows.get(i)).getDimensions().add(dimension.clone());
            }
            dimensionManager.addDimensionInfo((BgDimensionBaseInfo)dimension);
        }
        for (String colItem : colNumbers) {
            dimension = dimMap.get(colItem);
            dimension.setMemberValueType(DimensionMemberValueModeEnum.SelectMember);
            dimension.setMemberType(BgMemberSelectTypeEnum.Member);
            dimension.setLayout("col");
            List cols = dimensionManager.getColumns();
            for (i = 0; i < cols.size(); ++i) {
                ((MbgViewListRowCol)cols.get(i)).getDimensions().add(dimension.clone());
            }
            dimensionManager.addDimensionInfo((BgDimensionBaseInfo)dimension);
        }
    }

    private void buildViewListManager(MbgViewListManager viewManager, Map<String, MbgViewListDimensionInfo> dimMap, BgSchemeDimensionHelper schemeHelper) {
        MbgViewListDimensionManager dimensionManager = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(0)).getDimensionManager();
        List accAndOtherDim = schemeHelper.getAccAndOtherDim(false);
        MbgViewListDimensionInfo dimension2 = null;
        for (MbgViewListDimensionInfo dimension2 : dimMap.values()) {
            dimension2.setMemberValueType(DimensionMemberValueModeEnum.SelectMember);
            dimension2.setMemberType(BgMemberSelectTypeEnum.Member);
            if (accAndOtherDim.contains(dimension2.getNumber()) || DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(dimension2.getNumber()) || DimensionBaseConstants.DEF_CURRENCY_NUMBER.equals(dimension2.getNumber())) {
                dimension2.setLayout("row");
                List rows = dimensionManager.getRows();
                for (int i = 0; i < rows.size(); ++i) {
                    ((MbgViewListRowCol)rows.get(i)).getDimensions().add(dimension2.clone());
                }
            } else {
                dimension2.setLayout("col");
                ((MbgViewListRowCol)dimensionManager.getColumns().get(0)).getDimensions().add(dimension2);
            }
            dimensionManager.addDimensionInfo((BgDimensionBaseInfo)dimension2);
        }
    }

    private void buildDimension(Map<String, MbgViewListDimensionInfo> dimMap, BgSchemeDimensionHelper schemeHelper) throws Exception {
        int i;
        LinkedHashSet<String> sortDimensionNumber = new LinkedHashSet<String>();
        sortDimensionNumber.add(DimensionConstants.DEF_ACCOUNT_NUMBER);
        sortDimensionNumber.add(DimensionConstants.DEF_VERSION_NUMBER);
        sortDimensionNumber.add(DimensionConstants.DEF_PERIOD_NUMBER);
        sortDimensionNumber.add(DimensionConstants.DEF_ELEMENT_NUMBER);
        sortDimensionNumber.add(DimensionConstants.DEF_SCENARIO_NUMBER);
        for (String dimNumber : sortDimensionNumber) {
            int in = schemeHelper.getSettings().size();
            for (int i2 = 0; i2 < in; ++i2) {
                BgDimSettingsInfo set = (BgDimSettingsInfo)schemeHelper.getSettings().get(i2);
                if (!dimNumber.equals(set.getDimNumber())) continue;
                this.buildDimension(set, dimMap, schemeHelper);
            }
        }
        int in = schemeHelper.getSettings().size();
        for (i = 0; i < in; ++i) {
            BgDimSettingsInfo set = (BgDimSettingsInfo)schemeHelper.getSettings().get(i);
            if (DimensionConstants.necessary.contains(set.getDimNumber())) continue;
            this.buildDimension(set, dimMap, schemeHelper);
        }
        in = schemeHelper.getSettings().size();
        for (i = 0; i < in; ++i) {
            BgDimSettingsInfo set = (BgDimSettingsInfo)schemeHelper.getSettings().get(i);
            if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(set.getDimNumber())) continue;
            this.buildDimension(set, dimMap, schemeHelper);
        }
        in = schemeHelper.getSettings().size();
        for (i = 0; i < in; ++i) {
            BgDimSettingsInfo set = (BgDimSettingsInfo)schemeHelper.getSettings().get(i);
            if (!DimensionConstants.DEF_CURRENCY_NUMBER.equals(set.getDimNumber())) continue;
            this.buildDimension(set, dimMap, schemeHelper);
        }
    }

    private void buildDimension(BgDimSettingsInfo dimSettingInfo, Map<String, MbgViewListDimensionInfo> dimMap, BgSchemeDimensionHelper schemeHelper) throws Exception {
        BgDimensionInfo dimension = schemeHelper.getDimension(dimSettingInfo.getDimNumber());
        MbgViewListDimensionInfo dimensionInfo = new MbgViewListDimensionInfo(null);
        dimension.cloneValue((BgDimensionBaseInfo)dimensionInfo);
        dimMap.put(dimension.getNumber(), dimensionInfo);
    }

    public boolean isOnlyOneType() {
        List<BgScenarioInfo> scenarios = this.getScenarios();
        if (scenarios != null && !scenarios.isEmpty()) {
            int bgdataCount = 0;
            int actCount = 0;
            for (BgScenarioInfo item : scenarios) {
                if (bgdataCount > 1 || actCount > 1) {
                    return false;
                }
                BgScenarioType type = item.getType();
                if (BgScenarioType.BudgetData.equals((Object)type)) {
                    ++bgdataCount;
                    continue;
                }
                if (!BgScenarioType.ActualData.equals((Object)type)) continue;
                ++actCount;
            }
            if (bgdataCount == 1 && actCount == 1) {
                return true;
            }
        }
        return false;
    }

    public boolean isOnlyBgDataType() {
        List<BgScenarioInfo> scenarios = this.getScenarios();
        if (scenarios != null && !scenarios.isEmpty()) {
            int bgdataCount = 0;
            int actCount = 0;
            for (BgScenarioInfo item : scenarios) {
                BgScenarioType type = item.getType();
                if (BgScenarioType.BudgetData.equals((Object)type)) {
                    ++bgdataCount;
                    continue;
                }
                if (!BgScenarioType.ActualData.equals((Object)type)) continue;
                ++actCount;
            }
            if (bgdataCount != 0 && actCount == 0) {
                return true;
            }
        }
        return false;
    }

    public boolean isOnlyActDataType() {
        List<BgScenarioInfo> scenarios = this.getScenarios();
        if (scenarios != null && !scenarios.isEmpty()) {
            int bgdataCount = 0;
            int actCount = 0;
            for (BgScenarioInfo item : scenarios) {
                BgScenarioType type = item.getType();
                if (BgScenarioType.BudgetData.equals((Object)type)) {
                    ++bgdataCount;
                    continue;
                }
                if (!BgScenarioType.ActualData.equals((Object)type)) continue;
                ++actCount;
            }
            if (bgdataCount == 0 && actCount != 0) {
                return true;
            }
        }
        return false;
    }

    public MBgDataAnalyseListUI getOwnerUi() {
        return (MBgDataAnalyseListUI)super.getOwnerUi();
    }

    @Override
    protected void btnRdDecompose_itemStateChanged(ItemEvent e) throws Exception {
        super.btnRdDecompose_itemStateChanged(e);
        this.setAnalyseObjByProcess();
    }

    @Override
    protected void btnRdBudget_itemStateChanged(ItemEvent e) throws Exception {
        super.btnRdBudget_itemStateChanged(e);
        this.setAnalyseObjByProcess();
    }

    @Override
    protected void btnRdDecomposeSend_itemStateChanged(ItemEvent e) throws Exception {
        super.btnRdDecomposeSend_itemStateChanged(e);
        this.setAnalyseObjByProcess();
    }

    @Override
    protected void btnRdDecomposeGather_itemStateChanged(ItemEvent e) throws Exception {
        super.btnRdDecomposeGather_itemStateChanged(e);
        this.setAnalyseObjByProcess();
    }

    private void setAnalyseObjByProcess() throws Exception {
        List<BgScenarioInfo> scenarios;
        BgProcessEnum processType = this.getProcessType();
        this.initBgScenario();
        if (this.isNotC01() && (scenarios = this.getScenarios()) != null && !scenarios.isEmpty()) {
            Iterator<BgScenarioInfo> iterator = scenarios.iterator();
            while (iterator.hasNext()) {
                BgScenarioInfo bgScenarioInfo = iterator.next();
                BgScenarioType type = bgScenarioInfo.getType();
                if (0 == type.getValue()) continue;
                iterator.remove();
            }
            this.prmtScenario.setDataNoNotify((Object)scenarios.toArray());
        }
        this.getOwnerUi().setAnalyseObjByProcess(processType);
    }

    public BgSchemeInfo getSelectBgScheme() {
        if (this.prmtScheme.getData() instanceof BgSchemeInfo) {
            return (BgSchemeInfo)this.prmtScheme.getData();
        }
        return null;
    }

    protected List<OrgUnitInfo> getBgOrgUnit() {
        ArrayList<OrgUnitInfo> orgUnits = new ArrayList<OrgUnitInfo>();
        if (this.prmtBgOrgUnit.getData() instanceof BgOrgUnitInfo[]) {
            BgOrgUnitInfo[] _orgUnits = (BgOrgUnitInfo[])this.prmtBgOrgUnit.getData();
            int in = _orgUnits.length;
            for (int i = 0; i < in; ++i) {
                orgUnits.add((OrgUnitInfo)_orgUnits[i].castToFullOrgUnitInfo());
            }
        } else if (this.prmtBgOrgUnit.getData() instanceof BgOrgUnitInfo) {
            BgOrgUnitInfo _orgUnit = (BgOrgUnitInfo)this.prmtBgOrgUnit.getData();
            orgUnits.add((OrgUnitInfo)_orgUnit.castToFullOrgUnitInfo());
        }
        return orgUnits;
    }

    @Override
    protected void prmtBgOrgUnit_willShow(SelectorEvent e) throws Exception {
        super.prmtBgOrgUnit_willShow(e);
        Object data = this.prmtScheme.getData();
        if (data == null) {
            this.prmtScheme.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)this.getResourceStr(), (String)"selectBgScheme"));
            e.setCanceled(true);
            return;
        }
        KDPromptSelector selector = this.prmtBgOrgUnit.getSelector();
        if (selector instanceof BgViewOrgDimensionF7) {
            BgViewOrgDimensionF7 f7 = (BgViewOrgDimensionF7)selector;
            HashSet<BgOrgUnitInfo> orgs = new HashSet<BgOrgUnitInfo>();
            if (this.prmtBgOrgUnit.getData() instanceof Object[]) {
                Object[] bgOrgUnits = (Object[])this.prmtBgOrgUnit.getData();
                if (bgOrgUnits != null) {
                    BgOrgUnitInfo info = null;
                    for (int i = 0; i < bgOrgUnits.length; ++i) {
                        info = (BgOrgUnitInfo)bgOrgUnits[i];
                        if (info == null) continue;
                        orgs.add(info);
                    }
                }
            } else if (this.prmtBgOrgUnit.getData() instanceof BgOrgUnitInfo) {
                orgs.add((BgOrgUnitInfo)this.prmtBgOrgUnit.getData());
            }
            f7.setSelectOrgInfos(orgs);
        }
    }

    @Override
    protected void prmtBgOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgOrgUnit_dataChanged(e);
    }

    protected void setOrgUnitFilter() throws Exception {
        BgSchemeInfo bgScheme = this.getSelectBgScheme();
        if (bgScheme == null) {
            return;
        }
        bgScheme = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo("select id, number, name, orgUnit.id where id = '" + bgScheme.getId().toString() + "'");
        BgViewOrgDimensionF7 orgDialog = new BgViewOrgDimensionF7((IUIObject)this);
        orgDialog.setPermissionFilter(true);
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(bgScheme.getId().toString());
        orgDialog.setBgOrgViewId(schemeHelper.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId());
        orgDialog.setOrgUnitId(bgScheme.getOrgUnit().getId().toString());
        orgDialog.setShowVirtualOrg(false);
        orgDialog.setOnlyNoLeaf(false);
        orgDialog.setOnlyLeaf(false);
        orgDialog.setMultipleSelect(true);
        this.prmtBgOrgUnit.setSelector((KDPromptSelector)orgDialog);
        this.setDefaultOrgUnit(orgDialog.getBgOrgViewId());
    }

    private void setDefaultOrgUnit(String bgOrgViewId) throws EASBizException, BOSException {
        if (DimensionCommonHelper.isEmpty((Object)this.prmtOrgUnit.getData())) {
            return;
        }
        String costOrgId = null;
        costOrgId = this.prmtOrgUnit.getData() instanceof OrgUnitInfo[] ? SysContext.getSysContext().getCurrentOrgUnit().getId().toString() : ((OrgUnitInfo)this.prmtOrgUnit.getData()).getId().toString();
        String selectOrgUnitId = null;
        if (this.prmtBgOrgUnit.getData() instanceof BgOrgUnitInfo) {
            BgOrgUnitInfo o = (BgOrgUnitInfo)this.prmtBgOrgUnit.getData();
            if (StringUtils.isEmpty((String)o.getOrgUnitID())) {
                o = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitInfo("select id, orgUnitId where id = '" + o.getId() + "'");
            }
            selectOrgUnitId = o.getOrgUnitID();
        } else if (this.prmtBgOrgUnit.getData() instanceof OrgUnitInfo) {
            selectOrgUnitId = ((OrgUnitInfo)this.prmtBgOrgUnit.getData()).getId().toString();
        }
        if (selectOrgUnitId == null) {
            selectOrgUnitId = "000000000000000000000000000=";
        }
        BgOrgUnitCollection defaultOrg = null;
        defaultOrg = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection("select * where isVirtual = 0  and viewId = '" + bgOrgViewId + "' and (orgUnitId = '" + costOrgId + "' or orgUnitId = '" + selectOrgUnitId + "')");
        if (defaultOrg == null || defaultOrg.size() == 0) {
            this.prmtBgOrgUnit.setData(null);
        } else if (defaultOrg.size() == 1) {
            this.prmtBgOrgUnit.setData((Object)defaultOrg.get(0));
        } else {
            for (int i = 0; i < defaultOrg.size(); ++i) {
                if (!costOrgId.equals(defaultOrg.get(i).getOrgUnitID())) continue;
                this.prmtBgOrgUnit.setData((Object)defaultOrg.get(i));
                break;
            }
        }
    }
}

