/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.IUserCellDisplayParser;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.commonquery.FilterParam;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.popup.PopupMenuManager;
import com.kingdee.eas.ma.base.BgAccountCollection;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgElementCollection;
import com.kingdee.eas.ma.base.BgElementFactory;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.IBgAccount;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.utils.BgParamCHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.control.IMBgAnalyseFacade;
import com.kingdee.eas.ma.control.MBgAnalyseFacadeFactory;
import com.kingdee.eas.ma.control.client.AbstractMBgDataAnalyseListUI;
import com.kingdee.eas.ma.control.client.BgDataAnalyseLayoutUI;
import com.kingdee.eas.ma.control.client.MBgAnalyseExeUI;
import com.kingdee.eas.ma.control.client.MBgDataAnalyseFilter1UI;
import com.kingdee.eas.ma.control.client.MbgDataAnalyseFilter2UI;
import com.kingdee.eas.ma.control.query.AnalyseObjFilterParam;
import com.kingdee.eas.ma.control.query.DataAnalyseFilterParam;
import com.kingdee.eas.ma.control.query.ExeFilterParam;
import com.kingdee.eas.ma.mbg.BgAdjustFacadaFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IBgOrgUnit;
import com.kingdee.eas.ma.mbg.MBGViewListFormFacadeFactory;
import com.kingdee.eas.ma.mbg.client.BgTransitBudgetDetailViewUI;
import com.kingdee.eas.ma.mbg.client.MbgDataAnalyseNumberExpendRender;
import com.kingdee.eas.ma.mbg.client.TraceParamSetUI;
import com.kingdee.eas.ma.mbg.client.utils.BgAnalyseDrillTableHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgAnalyseTableHelper;
import com.kingdee.eas.ma.mbg.client.utils.MBGViewListFormClientHelper;
import com.kingdee.eas.ma.mbg.common.BgAnalyseObjConstants;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.query.AnalyseEleUnit;
import com.kingdee.eas.ma.mbg.query.AnalyseMember;
import com.kingdee.eas.ma.mbg.query.BgAnalyseConstants;
import com.kingdee.eas.ma.mbg.utils.BgCellRenderHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MBgDataAnalyseListUI
extends AbstractMBgDataAnalyseListUI {
    private static final Logger logger = CoreUIObject.getLogger(MBgDataAnalyseListUI.class);
    private static final long serialVersionUID = 479833658155427210L;
    private static final String RES_PATH = "com.kingdee.eas.ma.mbg.BudgetResource";
    private BgAnalyseDrillTableHelper buildHelper = null;
    protected FilterParam filter2Param = null;
    private Map<String, CurrencyInfo> currencyMap = null;
    private Map<String, MeasureUnitInfo> eleMeasureMap = null;
    private String accountViewId = null;
    private BgCellRenderHelper cellHelper = new BgCellRenderHelper();
    private boolean isLoadTransitBudget;
    private BgSchemeInfo schemeInfo = null;
    private Map<String, Map<String, String>> orgMap = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> accountMap = new HashMap<String, Map<String, String>>();
    public static final String NUMBERANDNAME = "0";
    public static final String NAME = "1";
    public static final String LONGNAME = "2";
    private Map<String, OrgUnitInfo> orgUnitMap = new HashMap<String, OrgUnitInfo>();
    private MbgDataAnalyseFilter2UI filter2UI = null;

    private BgAnalyseDrillTableHelper getBuildHelper() {
        return this.buildHelper;
    }

    public void setFilter2Param(FilterParam filterParam) {
        this.filter2Param = filterParam;
    }

    public void setFilter2Param(CustomerParams cp) {
        this.setFilter2Param(this.getFilter2UI().getFilterParam(cp));
    }

    public FilterParam getFilter2Param() {
        return this.filter2Param;
    }

    private void setCurrencyMap(Map<String, CurrencyInfo> currencyMap) {
        this.currencyMap = currencyMap;
    }

    public Map<String, CurrencyInfo> getCurrencyMap() {
        return this.currencyMap;
    }

    private void setEleMeasureMap(Map<String, MeasureUnitInfo> eleMeasureMap) {
        this.eleMeasureMap = eleMeasureMap;
    }

    private Map<String, MeasureUnitInfo> getEleMeasureMap() {
        return this.eleMeasureMap;
    }

    public BgCellRenderHelper getCellHelper() {
        return this.cellHelper;
    }

    private void checkParsed() {
        this.tblMain.checkParsed();
    }

    public void onLoad() throws Exception {
        this.checkParsed();
        this.isLoadTransitBudget = BgParamCHelper.isLoadTransitBudget();
        this.tblMain.getScriptManager().setAutoRun(false);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getStyleAttributes().setWrapText(true);
        this.tblMain.setUserCellDisplayParser((IUserCellDisplayParser)new CellDisplayParser());
        super.onLoad();
        this.btnDesignSet.setEnabled(true);
        BgSchemeInfo bgScheme = this.getBgScheme();
        String accViewId = bgScheme.getViewId(DimensionBaseConstants.DEF_ACCOUNT_NUMBER).toString();
        this.getInitAccounts(accViewId);
        Set orgViewIds = bgScheme.getOrgViewIds();
        if (orgViewIds.size() == 1) {
            this.getInitOrgs(orgViewIds.toArray(new String[0])[0]);
        }
    }

    protected void initListener() {
        super.initListener();
        AbstractAction actionSetTraceParam = new AbstractAction(){
            private static final long serialVersionUID = 1200289984922587127L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MBgDataAnalyseListUI.this.actionSetTraceParam_actionPerformed(e);
                }
                catch (Exception ex) {
                    MBgDataAnalyseListUI.this.handleException(ex);
                }
            }
        };
        String strKey = "CTRL_SHIFT_P";
        KeyStroke ks = KeyStroke.getKeyStroke(80, 192, false);
        this.getActionMap().put(strKey, actionSetTraceParam);
        this.getInputMap(2).put(ks, strKey);
    }

    protected void actionSetTraceParam_actionPerformed(ActionEvent e) throws Exception {
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TraceParamSetUI.class.getName(), this.getUIContext());
        uiWindow.show();
    }

    public BgSchemeInfo getBgScheme() throws Exception {
        String bgScehemeId = this.getBgSchemeId();
        if (this.schemeInfo == null || !this.schemeInfo.getId().toString().equals(bgScehemeId)) {
            this.schemeInfo = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo("select id, name, number, bgDimSettings.members.*, bgDimSettings.dimNumber where id='" + bgScehemeId + "'");
        }
        return this.schemeInfo;
    }

    protected void dealOtherFilter() {
        this.setFilter2Param(this.getFilter2UI().getCustomerParams());
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    private void renderTable() {
        int headCols;
        for (int i = headCols = this.buildHelper.getHeadCols(); i < this.tblMain.getColumnCount(); ++i) {
            this.tblMain.getColumn(i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        CommonQueryDialog dialog = this.getDialog();
        if (dialog.show()) {
            this.setFilterParam(this.getFilterUI().getCustomerParams());
            this.dealOtherFilter();
            this.executeQuery();
        } else {
            SysUtil.abort();
        }
    }

    protected CommonQueryDialog createCommonQueryDialog() {
        CommonQueryDialog dialog = super.createCommonQueryDialog();
        dialog.addUserPanel((KDPanel)this.getFilter2UI());
        return dialog;
    }

    public boolean isOnlyShowAuditBudgetData() {
        DataAnalyseFilterParam param = (DataAnalyseFilterParam)this.getFilterParam();
        return param.isOnlyShowAuditBudgetData();
    }

    public boolean isHideMbgDim() {
        DataAnalyseFilterParam param = (DataAnalyseFilterParam)this.getFilterParam();
        return param.isHideMbgDim();
    }

    public boolean isOnlyOneScenType() throws BOSException {
        DataAnalyseFilterParam param = (DataAnalyseFilterParam)this.getFilterParam();
        List<BgScenarioInfo> scenarios = null;
        scenarios = param == null ? ((MBgDataAnalyseFilter1UI)this.getFilterUI()).getScenarios() : Arrays.asList((Object[])param.getBgScenarios());
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < scenarios.size(); ++i) {
            ids.add(scenarios.get(i).getId().toString());
        }
        BgScenarioCollection bgScenarioCollection = this.getScens(ids);
        if (bgScenarioCollection != null && !bgScenarioCollection.isEmpty()) {
            int bgdataCount = 0;
            int actCount = 0;
            for (int i = 0; i < bgScenarioCollection.size(); ++i) {
                if (bgdataCount > 1 || actCount > 1) {
                    return false;
                }
                BgScenarioType type = bgScenarioCollection.get(i).getType();
                if (BgScenarioType.BudgetData.equals((Object)type)) {
                    ++bgdataCount;
                    continue;
                }
                if (!BgScenarioType.ActualData.equals((Object)type)) continue;
                ++actCount;
            }
            if (bgdataCount == 1 && actCount == 1) {
                return true;
            }
        }
        return false;
    }

    public boolean isOnlyBgDataType() {
        return ((MBgDataAnalyseFilter1UI)this.getFilterUI()).isOnlyBgDataType();
    }

    public boolean isOnlyActDataType() {
        return ((MBgDataAnalyseFilter1UI)this.getFilterUI()).isOnlyActDataType();
    }

    public Map<String, Integer> getScenMap() throws BOSException {
        List<BgScenarioInfo> scenarios = null;
        DataAnalyseFilterParam param = (DataAnalyseFilterParam)this.getFilterParam();
        scenarios = param == null ? ((MBgDataAnalyseFilter1UI)this.getFilterUI()).getScenarios() : Arrays.asList((Object[])param.getBgScenarios());
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < scenarios.size(); ++i) {
            ids.add(scenarios.get(i).getId().toString());
        }
        BgScenarioCollection bgScenarioCollection = this.getScens(ids);
        HashMap<String, Integer> scenMap = new HashMap<String, Integer>();
        for (int i = 0; i < bgScenarioCollection.size(); ++i) {
            scenMap.put(bgScenarioCollection.get(i).getNumber(), bgScenarioCollection.get(i).getType().getValue());
        }
        return scenMap;
    }

    private BgScenarioCollection getScens(Set<String> ids) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("type");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        BgScenarioCollection bgScenarioCollection = BgScenarioFactory.getRemoteInstance().getBgScenarioCollection(evi);
        return bgScenarioCollection;
    }

    private void setDefaultQuery() {
        MBgDataAnalyseFilter1UI uiObject1 = (MBgDataAnalyseFilter1UI)this.getFilterUI();
        uiObject1.setDefaultQuery(this.isDefaultQuery);
    }

    protected void executeQuery() throws Exception {
        LongTimeDialog dialog = null;
        MBgDataAnalyseListUI com = this;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        dialog = win instanceof Frame ? new LongTimeDialog((Frame)win) : (win instanceof Dialog ? new LongTimeDialog((Dialog)win) : new LongTimeDialog((Frame)this.getUIContext().get("OwnerWindow")));
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask((Component)((Object)com)){
            final /* synthetic */ Component val$com;
            {
                this.val$com = component;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object exec() throws Exception {
                List<String> analyseObjTexts = MBgDataAnalyseListUI.this.getAnalyseObjs();
                MbgViewListManager view = MBgDataAnalyseListUI.this.getViewManager();
                if (view == null) {
                    return null;
                }
                MBgDataAnalyseListUI.this.setDefaultQuery();
                Map bgDataMap = MBgDataAnalyseListUI.this.getDataMap(view, analyseObjTexts);
                MBgDataAnalyseListUI.this.setEleMeasureMap(MBgDataAnalyseListUI.this.getRalationEleMeasureMap());
                MBgDataAnalyseListUI.this.setCurrencyMap(MBgDataAnalyseListUI.this.getCurMap());
                if (bgDataMap instanceof Map) {
                    Map dataMap = bgDataMap;
                    if (view != null && !analyseObjTexts.isEmpty()) {
                        String orgViewId = MBgDataAnalyseListUI.this.getOrgViewId();
                        if (MBgDataAnalyseListUI.this.buildHelper == null) {
                            MBgDataAnalyseListUI.this.buildHelper = new BgAnalyseDrillTableHelper();
                        }
                        MbgDataAnalyseNumberExpendRender render = new MbgDataAnalyseNumberExpendRender(MBgDataAnalyseListUI.this.getBgSchemeId());
                        MBgDataAnalyseListUI.this.buildHelper.setRender(render);
                        MBgDataAnalyseListUI.this.buildHelper.setTblMain(MBgDataAnalyseListUI.this.tblMain);
                        MBgDataAnalyseListUI.this.buildHelper.setView(view);
                        MBgDataAnalyseListUI.this.buildHelper.setDataMap(dataMap);
                        MBgDataAnalyseListUI.this.buildHelper.setAnalyseObjTexts(analyseObjTexts);
                        MBgDataAnalyseListUI.this.buildHelper.setOnlyBgDataType(MBgDataAnalyseListUI.this.isOnlyOneScenType());
                        MBgDataAnalyseListUI.this.buildHelper.setBgschemeId(MBgDataAnalyseListUI.this.getBgSchemeId());
                        MBgDataAnalyseListUI.this.buildHelper.setOrgViewId(orgViewId);
                        MBgDataAnalyseListUI.this.buildHelper.setScenMap(MBgDataAnalyseListUI.this.getScenMap());
                        MBgDataAnalyseListUI.this.buildHelper.setBgOrgUnits(MBgDataAnalyseListUI.this.getBgOrgUnits(orgViewId));
                        MBgDataAnalyseListUI.this.buildHelper.setShowAduitData(MBgDataAnalyseListUI.this.isOnlyShowAuditBudgetData());
                        MBgDataAnalyseListUI.this.buildHelper.setHideExtDim(MBgDataAnalyseListUI.this.isHideMbgDim());
                        MBgDataAnalyseListUI.this.buildHelper.setOwner(this.val$com);
                        MBgDataAnalyseListUI.this.buildHelper.setProcessType(MBgDataAnalyseListUI.this.getProcessType());
                        MBgDataAnalyseListUI.this.buildHelper.setOrgIds(MBgDataAnalyseListUI.this.getOrgIds());
                        MBgDataAnalyseListUI.this.buildHelper.setBgOrgs(MBgDataAnalyseListUI.this.getBgOrgUnits());
                        MBgDataAnalyseListUI.this.buildHelper.setPeriods(MBgDataAnalyseListUI.this.getPeriods());
                        try {
                            MBgDataAnalyseListUI.this.buildHelper.setFirst(true);
                            MBgDataAnalyseListUI.this.buildHelper.buildTable();
                        }
                        finally {
                            MBgDataAnalyseListUI.this.buildHelper.setFirst(false);
                        }
                        MBgDataAnalyseListUI.this.renderTable();
                    }
                }
                return null;
            }

            public void afterExec(Object createUI) throws Exception {
            }
        });
        dialog.show();
    }

    private BgProcessEnum getProcessType() {
        DataAnalyseFilterParam param = (DataAnalyseFilterParam)this.getFilterParam();
        return param.getProcessType();
    }

    public Map<String, Map<String, String>> getOrgMap() {
        return this.orgMap;
    }

    public void setOrgMap(Map<String, Map<String, String>> orgMap) {
        this.orgMap = orgMap;
    }

    private Map<String, String> getInitOrgs(String viewId) {
        HashMap<String, String> orgMap = new HashMap<String, String>();
        if (viewId == null) {
            return orgMap;
        }
        if (this.getOrgMap().containsKey(viewId)) {
            return this.getOrgMap().get(viewId);
        }
        try {
            IBgOrgUnit remoteInstance = BgOrgUnitFactory.getRemoteInstance();
            if (remoteInstance == null) {
                return orgMap;
            }
            BgOrgUnitCollection bgOrgUnitCollection = remoteInstance.getBgOrgUnitCollection("where viewID = '" + viewId + "'");
            if (bgOrgUnitCollection != null && bgOrgUnitCollection.size() > 0) {
                BgOrgUnitInfo info = null;
                int size = bgOrgUnitCollection.size();
                for (int index = 0; index < size; ++index) {
                    info = bgOrgUnitCollection.get(index);
                    if (info.getNumber() == null) continue;
                    if (!this.getOrgMap().containsKey(viewId)) {
                        this.getOrgMap().put(viewId, new HashMap());
                    }
                    if (!StringUtils.isEmpty((String)info.getDisplayName())) {
                        this.getOrgMap().get(viewId).put(info.getLongNumber(), info.getDisplayName());
                        continue;
                    }
                    this.getOrgMap().get(viewId).put(info.getLongNumber(), info.getName());
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)("MBgDataAnalyseListUI getInitOrgs error:" + e.getMessage()));
        }
        return orgMap;
    }

    public Map<String, Map<String, String>> getAccountMap() {
        return this.accountMap;
    }

    public void setAccountMap(Map<String, Map<String, String>> accountMap) {
        this.accountMap = accountMap;
    }

    private Map<String, String> getInitAccounts(String viewId) {
        HashMap<String, String> accountMap = new HashMap<String, String>();
        if (viewId == null) {
            return accountMap;
        }
        if (this.getAccountMap().containsKey(viewId)) {
            return this.getAccountMap().get(viewId);
        }
        try {
            IBgAccount iBgAccount = BgAccountFactory.getRemoteInstance();
            if (iBgAccount == null) {
                return accountMap;
            }
            BgAccountCollection colls = iBgAccount.getBgAccountCollection("select number, name, displayName where bgAccountView = '" + viewId + "'");
            if (colls != null && colls.size() > 0) {
                BgAccountInfo info = null;
                int size = colls.size();
                for (int index = 0; index < size; ++index) {
                    info = colls.get(index);
                    if (info.getNumber() == null) continue;
                    if (!this.getAccountMap().containsKey(viewId)) {
                        this.getAccountMap().put(viewId, new HashMap());
                    }
                    if (!StringUtils.isEmpty((String)info.getDisplayName())) {
                        this.getAccountMap().get(viewId).put(info.getNumber(), info.getDisplayName());
                        continue;
                    }
                    this.getAccountMap().get(viewId).put(info.getNumber(), info.getName());
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)("MBgDataAnalyseListUI getInitAccounts error:" + e.getMessage()));
        }
        return accountMap;
    }

    private Object formatCellDisplay(int rowIndex, int colIndex, ICell cell, Object value) {
        if (cell == null || value == null) {
            return null;
        }
        int headCols = this.buildHelper.getHeadCols();
        if (colIndex < headCols) {
            return value;
        }
        if (value instanceof BigDecimal) {
            BigDecimal dataValue = (BigDecimal)value;
            if (BigDecimal.ZERO.equals(value)) {
                return null;
            }
            Object userObject = cell.getUserObject();
            if (userObject instanceof Map) {
                String analyse;
                Map map = (Map)userObject;
                String string = analyse = map.get("ANALYSE") != null ? map.get("ANALYSE").toString() : null;
                if (BgAnalyseObjConstants.isRateType((String)analyse)) {
                    if (BigDecimal.ZERO.compareTo(dataValue) == 0) {
                        return null;
                    }
                    return new DecimalFormat("#,##0.00%").format(dataValue);
                }
                String eleNumber = map.get("element") != null ? map.get("element").toString() : null;
                String curNumber = map.get("currency") != null ? map.get("currency").toString() : null;
                CurrencyInfo currencyInfo = this.getCurrencyMap().get(curNumber);
                int precision = currencyInfo.getPrecision();
                MeasureUnitInfo measureUnitInfo = this.getEleMeasureMap().get(eleNumber);
                if (null == measureUnitInfo) {
                    return null;
                }
                BigDecimal coefficient = measureUnitInfo.getCoefficient();
                BigDecimal divide = dataValue.divide(coefficient, precision, 4);
                if (BigDecimal.ZERO.compareTo(divide) == 0) {
                    return null;
                }
                return new DecimalFormat(BgNationalFormatUIUtil.getNumberFormat((int)precision)).format(divide);
            }
        }
        return value;
    }

    private MbgViewListManager getViewManager() throws Exception {
        MBgDataAnalyseFilter1UI uiObject1 = (MBgDataAnalyseFilter1UI)this.getFilterUI();
        MbgViewListManager view = null;
        DataAnalyseFilterParam param = (DataAnalyseFilterParam)this.getFilterParam();
        view = this.isDefaultQuery && param != null && param.getView() != null ? param.getView() : uiObject1.getView();
        return view;
    }

    private List<BgOrgUnitInfo> getBgOrgUnits(String orgViewId) throws Exception {
        List<BgOrgUnitInfo> bgOrgUnits;
        block8: {
            BgOrgUnitCollection bgOrgUnitCollection;
            block9: {
                boolean isOrgOnRow;
                List orgUnits;
                DataAnalyseFilterParam param;
                block7: {
                    MBgDataAnalyseFilter1UI uiObject1 = (MBgDataAnalyseFilter1UI)this.getFilterUI();
                    param = (DataAnalyseFilterParam)this.getFilterParam();
                    orgUnits = null;
                    bgOrgUnits = null;
                    isOrgOnRow = MBGViewListFormClientHelper.isOrgOnRow((MbgViewListDimensionManager)((MbgViewListSheetManager)this.getViewManager().getSheetManagers().get(0)).getDimensionManager());
                    if (param != null) break block7;
                    bgOrgUnits = uiObject1.getOrgUnits(isOrgOnRow);
                    break block8;
                }
                orgUnits = param.getOrgUnits();
                if (orgUnits == null || orgUnits.isEmpty()) break block8;
                HashSet<String> ids = new HashSet<String>();
                for (int i = 0; i < orgUnits.size(); ++i) {
                    ids.add(((OrgUnitInfo)orgUnits.get(i)).getId().toString());
                }
                EntityViewInfo evi = new EntityViewInfo();
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add("id");
                evi.getSelector().add("orgUnitId");
                evi.getSelector().add("number");
                evi.getSelector().add("name");
                evi.getSelector().add("displayName");
                evi.getSelector().add("longNumber");
                evi.getSelector().add("level");
                evi.getSelector().add("isLeaf");
                evi.getSelector().add("polAlgorithm");
                evi.getSelector().add("isOUSealUp");
                evi.getSelector().add("isVirtual");
                evi.getSelector().add("parent");
                evi.getSelector().add("parent.longNumber");
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("viewId", (Object)orgViewId));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnitId", ids, CompareType.INCLUDE));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)0));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("isVirtual", (Object)0));
                bgOrgUnitCollection = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(evi);
                if (bgOrgUnitCollection == null || bgOrgUnitCollection.isEmpty()) break block8;
                if (!isOrgOnRow) break block9;
                HashSet<String> deleteNumbers = new HashSet<String>();
                for (int i = 0; i < bgOrgUnitCollection.size(); ++i) {
                    BgOrgUnitInfo bgOrgUnitInfo = bgOrgUnitCollection.get(i);
                    String longNumber = bgOrgUnitInfo.getLongNumber();
                    for (int j = 0; j < bgOrgUnitCollection.size(); ++j) {
                        BgOrgUnitInfo bgOrgUnitInfo2 = bgOrgUnitCollection.get(j);
                        String longNumber2 = bgOrgUnitInfo2.getLongNumber();
                        if (longNumber2.indexOf(longNumber) == -1 || longNumber.equals(longNumber2)) continue;
                        deleteNumbers.add(longNumber2);
                    }
                }
                Iterator iterator = bgOrgUnitCollection.iterator();
                while (iterator.hasNext()) {
                    BgOrgUnitInfo org = (BgOrgUnitInfo)iterator.next();
                    if (!deleteNumbers.contains(org.getLongNumber())) continue;
                    iterator.remove();
                }
                if (bgOrgUnitCollection.isEmpty()) break block8;
                bgOrgUnits = new ArrayList<BgOrgUnitInfo>();
                for (int i = 0; i < bgOrgUnitCollection.size(); ++i) {
                    bgOrgUnits.add(bgOrgUnitCollection.get(i));
                }
                break block8;
            }
            if (bgOrgUnitCollection != null && !bgOrgUnitCollection.isEmpty()) {
                bgOrgUnits = new ArrayList<BgOrgUnitInfo>();
                for (int i = 0; i < bgOrgUnitCollection.size(); ++i) {
                    bgOrgUnits.add(bgOrgUnitCollection.get(i));
                }
            }
        }
        return bgOrgUnits;
    }

    private Map<String, CurrencyInfo> getCurMap() throws Exception {
        MBgDataAnalyseFilter1UI uiObject1 = (MBgDataAnalyseFilter1UI)this.getFilterUI();
        HashMap<String, CurrencyInfo> map = null;
        map = new HashMap();
        DataAnalyseFilterParam param = (DataAnalyseFilterParam)this.getFilterParam();
        if (param == null) {
            map = uiObject1.getCurrencyMap();
        } else {
            CurrencyInfo currency = param.getCurrency();
            if (currency != null) {
                map.put(currency.getNumber(), currency);
            }
        }
        return map;
    }

    private Map<String, MeasureUnitInfo> getRalationEleMeasureMap() throws Exception {
        MBgDataAnalyseFilter1UI uiObject1 = (MBgDataAnalyseFilter1UI)this.getFilterUI();
        Map<String, MeasureUnitInfo> eleMeasureMap = null;
        DataAnalyseFilterParam param = (DataAnalyseFilterParam)this.getFilterParam();
        if (param == null) {
            eleMeasureMap = uiObject1.getEleMeasureMap();
        } else {
            List<AnalyseEleUnit> eleUnitMembers = param.getEleUnitMembers();
            if (eleUnitMembers != null) {
                eleMeasureMap = new HashMap<String, MeasureUnitInfo>();
                for (int i = 0; i < eleUnitMembers.size(); ++i) {
                    AnalyseEleUnit analyseEleUnit = eleUnitMembers.get(i);
                    eleMeasureMap.put(analyseEleUnit.getDimMember().getNumber(), analyseEleUnit.getUnit());
                }
            }
        }
        return eleMeasureMap;
    }

    private String getBgSchemeId() throws Exception {
        MBgDataAnalyseFilter1UI uiObject1 = (MBgDataAnalyseFilter1UI)this.getFilterUI();
        String schemeId = uiObject1.getBgScehemeId();
        return schemeId;
    }

    public String getOrgViewId() throws Exception {
        ISQLExecutor executor = null;
        IRowSet rowSet = null;
        String sql = "SELECT orgView.FID  FROM T_Mbg_BgScheme scheme  join T_Mbg_BgDimSettings dim on dim.FBgschemeID = scheme.FID  join T_Mbg_BgDimSettingsMember dimMember on dimMember.FBgDimsettingsID = dim.FID  join T_Mbg_BgOrgView orgView on orgView.FID = dimMember.FMemberID  where dim.FDimNumber = '" + DimensionConstants.DEF_ORGUNIT_NUMBER + "'  and scheme.FID = '" + this.getBgSchemeId() + "' and dimMember.FType =" + 2;
        executor = SQLExecutorFactory.getRemoteInstance((String)sql);
        rowSet = executor.executeSQL();
        if (rowSet.next()) {
            return rowSet.getString("FID");
        }
        return null;
    }

    public List<String> getAnalyseObjs() {
        ArrayList<String> analyseObjTexts = new ArrayList<String>();
        Map<String, Boolean> definedSelected2AnalyseObj = null;
        AnalyseObjFilterParam param = (AnalyseObjFilterParam)this.getFilter2Param();
        MbgDataAnalyseFilter2UI ui = this.getFilter2UI();
        definedSelected2AnalyseObj = ui.getDefinedSelected2AnalyseObj();
        if (param != null && (definedSelected2AnalyseObj == null || definedSelected2AnalyseObj.isEmpty())) {
            definedSelected2AnalyseObj = param.getDefinedSelected2AnalyseObj();
        }
        if (definedSelected2AnalyseObj != null) {
            for (Map.Entry entry : definedSelected2AnalyseObj.entrySet()) {
                Boolean isSelected = (Boolean)entry.getValue();
                if (!Boolean.TRUE.equals(isSelected)) continue;
                analyseObjTexts.add((String)entry.getKey());
            }
        }
        return analyseObjTexts;
    }

    private Map<String, Map<String, Map<String, BgNViewDataInfo>>> getDataMap(MbgViewListManager view, List<String> analyseObjTexts) throws Exception {
        return (Map)((MBgDataAnalyseFilter1UI)this.getFilterUI()).getBgDataMap(view, analyseObjTexts, this.isOnlyShowAuditBudgetData());
    }

    private Set<String> getOrgIds() throws Exception {
        return ((MBgDataAnalyseFilter1UI)this.getFilterUI()).getCostOrgUnits(this.getViewManager());
    }

    private Set<BgOrgUnitInfo> getBgOrgUnits() throws Exception {
        return ((MBgDataAnalyseFilter1UI)this.getFilterUI()).getBgOrgUnits(this.getViewManager());
    }

    private List<BgPeriodInfo> getPeriods() throws Exception {
        return ((MBgDataAnalyseFilter1UI)this.getFilterUI()).getPeriods();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (this.isLoadTransitBudget) {
            this.btnSearchTransit.setVisible(true);
            this.btnSearchTransit.setEnabled(true);
            this.menuItemSearchTransit.setVisible(true);
            this.menuItemSearchTransit.setEnabled(true);
        } else {
            this.btnSearchTransit.setVisible(false);
            this.btnSearchTransit.setEnabled(false);
            this.menuItemSearchTransit.setVisible(false);
            this.menuItemSearchTransit.setEnabled(false);
        }
    }

    protected String getExportFileName() {
        return EASResource.getString((String)RES_PATH, (String)"budgetDataExport");
    }

    public String getFilterUIName() {
        return MBgDataAnalyseFilter1UI.class.getName();
    }

    protected boolean hasDefaultQuery() throws Exception {
        QueryPanelCollection queryPanelInfos;
        QuerySolutionInfo ds = this.getQueryFacadeInterface().getDefaultSolution(this.getQueryMainName(), this.getMainQueryPk().getFullName());
        if (ds != null && ds.getSolutionType().equals((Object)SolutionTypeEnum.CUSTOMER_SOLUTION) && (queryPanelInfos = ds.getQueryPanelInfo()).size() > 0) {
            CustomerParams cp = null;
            String condition = EASResource.getString((String)RES_PATH, (String)"condition");
            String analyseObj = EASResource.getString((String)RES_PATH, (String)"analyseObj");
            String dimensionLayout = EASResource.getString((String)RES_PATH, (String)"dimensionLayout");
            for (int i = 0; i < queryPanelInfos.size(); ++i) {
                QueryPanelInfo queryPanelInfo = queryPanelInfos.get(i);
                if (queryPanelInfo == null) continue;
                if (condition.equals(queryPanelInfo.getPanelName())) {
                    cp = new CustomerParams().getCustomerParams(queryPanelInfo.getCustomerParams());
                    if (cp.getCustomerParamsHashMap().get("ANALYSE_SCHEME_ID") != null) {
                        String schemeId = cp.getCustomerParamsHashMap().get("ANALYSE_SCHEME_ID").toString();
                        if (!BgSchemeFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)schemeId)))) {
                            return false;
                        }
                    }
                    this.setFilterParam(cp);
                    continue;
                }
                if (analyseObj.equals(queryPanelInfo.getPanelName())) {
                    cp = new CustomerParams().getCustomerParams(queryPanelInfo.getCustomerParams());
                    this.setFilter2Param(cp);
                    continue;
                }
                if (!dimensionLayout.equals(queryPanelInfo.getPanelName())) continue;
            }
        }
        return this.getFilterParam() != null;
    }

    public FilterParam getFilterParam() {
        return super.getFilterParam();
    }

    protected String getQueryMainName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected int getWidthOfDialog() {
        return 500;
    }

    protected int getHeightOfDialog() {
        return 570;
    }

    public KDTable getTable() {
        return this.tblMain;
    }

    protected boolean isShowSum() {
        return false;
    }

    protected IMBgAnalyseFacade getInterface() throws BOSException {
        return MBgAnalyseFacadeFactory.getRemoteInstance();
    }

    public static String getBudgetViewID(BgSchemeInfo bgscheme) throws Exception {
        ISQLExecutor executor = null;
        IRowSet rowSet = null;
        String sql = "SELECT orgView.FID  FROM T_Mbg_BgScheme scheme  join T_Mbg_BgDimSettings dim on dim.FBgschemeID = scheme.FID  join T_Mbg_BgDimSettingsMember dimMember on dimMember.FBgDimsettingsID = dim.FID  join T_Mbg_BgOrgView orgView on orgView.FID = dimMember.FMemberID  where dim.FDimNumber = '" + DimensionConstants.DEF_ORGUNIT_NUMBER + "'  and scheme.FID = '" + bgscheme.getId().toString() + "' and dimMember.FType =" + 2;
        executor = SQLExecutorFactory.getRemoteInstance((String)sql);
        rowSet = executor.executeSQL();
        if (rowSet.next()) {
            return rowSet.getString("FID");
        }
        return null;
    }

    private void initOrgUnitMap(String bgOrgViewId, List<Object[]> querys) {
        HashSet<String> ids = new HashSet<String>();
        if (querys != null) {
            for (Object[] objs : querys) {
                ids.add(String.valueOf(objs[BgAnalyseConstants.ANALYSE_ORGUNIT_ID]));
            }
        }
        if (!ids.isEmpty()) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("id");
            evi.getSelector().add("orgUnitId");
            evi.getSelector().add("number");
            evi.getSelector().add("name");
            evi.getSelector().add("displayName");
            evi.getSelector().add("longNumber");
            evi.getSelector().add("level");
            evi.getSelector().add("isLeaf");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("viewId", (Object)bgOrgViewId));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnitId", ids, CompareType.INCLUDE));
            try {
                BgOrgUnitCollection orgCol = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(evi);
                if (orgCol != null) {
                    for (int i = 0; i < orgCol.size(); ++i) {
                        this.getOrgUnitMap().put(orgCol.get(i).getOrgUnitID(), (OrgUnitInfo)orgCol.get(i).castToFullOrgUnitInfo());
                    }
                }
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
    }

    public Map<String, OrgUnitInfo> getOrgUnitMap() {
        Map superOrgMap = super.getOrgUnitMap();
        if (superOrgMap != null) {
            this.orgUnitMap.putAll(superOrgMap);
        }
        return this.orgUnitMap;
    }

    protected Object[] getSelectedQueryData() {
        Object[] objs = null;
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0) {
            IRow row = this.tblMain.getRow(rowIndex);
            objs = (Object[])row.getUserObject();
        }
        return objs;
    }

    public MbgDataAnalyseFilter2UI getFilter2UI() {
        if (this.filter2UI != null) {
            return this.filter2UI;
        }
        try {
            this.filter2UI = (MbgDataAnalyseFilter2UI)((Object)Class.forName(this.getFilter2UIName()).newInstance());
            this.filter2UI.setOwnerUi((CoreUI)this);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            this.handleException(ex);
        }
        return this.filter2UI;
    }

    public String getFilter2UIName() {
        return MbgDataAnalyseFilter2UI.class.getName();
    }

    public MbgViewListManager getCurDimensionManager() throws Exception {
        return this.getViewManager();
    }

    @Override
    public void actionSearchTransit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected(EASResource.getString((String)RES_PATH, (String)"transitBudget"));
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"processType", (Object)BgProcessEnum.C01);
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(this.getBgSchemeId());
        uiContext.put((Object)"schemeHelper", (Object)schemeHelper);
        ICell cell = this.tblMain.getCell(this.tblMain.getSelectManager().getActiveRowIndex(), this.tblMain.getSelectManager().getActiveColumnIndex());
        HashSet<String> formulas = new HashSet<String>(1);
        formulas.add(BgAnalyseTableHelper.getFormula((ICell)cell));
        String version = BgAnalyseTableHelper.getVersion((ICell)cell);
        BgDimensionMember org = BgAnalyseTableHelper.getMem((ICell)cell);
        BgVersionInfo bgVersionInfo = null;
        if (!StringUtils.isEmpty((String)version)) {
            bgVersionInfo = BgVersionFactory.getRemoteInstance().getBgVersionInfo("select id,number,versionId where number = '" + version + "'");
        }
        List detailData = BgAdjustFacadaFactory.getRemoteInstance().transitDataView(formulas, this.getOrgUnitInfo(org.getNumber()), bgVersionInfo, schemeHelper);
        uiContext.put((Object)"data", (Object)detailData);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgTransitBudgetDetailViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private OrgUnitInfo getOrgUnitInfo(String number) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        return CostCenterOrgUnitFactory.getRemoteInstance().getOrgUnitInfo("select id,number where number = '" + number + "'");
    }

    @Override
    public void actionActDataQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionActDataQuery_actionPerformed(e);
        this.checkSelected(EASResource.getString((String)RES_PATH, (String)"actData"));
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"InitDataObject", (Object)this.getExeFilterParam());
        uiContext.put((Object)"isShowAllTotal", (Object)true);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getAnalyseUI(), (Map)uiContext, null, OprtState.VIEW);
        if (uiWindow instanceof UINewFrame) {
            UINewFrame frame = (UINewFrame)uiWindow;
            Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
            int width = (int)screensize.getWidth();
            int height = (int)screensize.getHeight();
            width = Math.min(width, 1013);
            height = Math.min(height, 800);
            frame.setSize(width, height);
            uiWindow.show();
            frame.setExtendedState(6);
        }
    }

    protected String getAnalyseUI() {
        return MBgAnalyseExeUI.class.getName();
    }

    public void checkSelected(String typeMsg) {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if (this.tblMain.getSelectManager().getBlocks() != null) {
            ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
            for (int i = 0; i < blocks.size(); ++i) {
                KDTSelectBlock kdtSelectBlock = (KDTSelectBlock)blocks.get(i);
                if (kdtSelectBlock.getBeginCol() == kdtSelectBlock.getEndCol() && kdtSelectBlock.getBeginRow() == kdtSelectBlock.getEndRow()) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"onlyOneQuery", (Object[])new Object[]{typeMsg}));
                SysUtil.abort();
            }
        }
        if (this.tblMain.getSelectManager().getActiveColumnIndex() < this.buildHelper.getHeadCols()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"enableArea", (Object[])new Object[]{typeMsg}));
            SysUtil.abort();
        }
    }

    private ExeFilterParam getExeFilterParam() throws Exception {
        ICell cell = this.tblMain.getCell(this.tblMain.getSelectManager().getActiveRowIndex(), this.tblMain.getSelectManager().getActiveColumnIndex());
        String formula = BgAnalyseTableHelper.getFormula((ICell)cell);
        BgDimensionMember orgMem = BgAnalyseTableHelper.getMem((ICell)cell);
        String[] params = BgNFSHelper.parseFormulaPara((String)formula);
        String periodNum = params[1];
        HashSet<String> periods = new HashSet<String>();
        periods.add(periodNum);
        String dimNumber = params[0];
        String curNumber = params[5];
        String eleNumber = params[2];
        String scenNumber = params[3];
        ExeFilterParam _filterParam = new ExeFilterParam();
        BgScenarioCollection bgScenarioCollection = BgScenarioFactory.getRemoteInstance().getBgScenarioCollection("where number = '" + scenNumber + "' and type =" + 1);
        BgScenarioInfo bgScenario = bgScenarioCollection.get(0);
        if (bgScenario == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"onlyActDataAnalyse"));
            SysUtil.abort();
        }
        OrgUnitInfo orgUnit = CostCenterOrgUnitFactory.getRemoteInstance().getOrgUnitInfo("where id = '" + orgMem.getAttribute() + "'");
        _filterParam.getOrgUnits().add(orgUnit);
        _filterParam.setBgScheme(new BgSchemeInfo());
        _filterParam.getBgScheme().setId(BOSUuid.read((String)this.getBgSchemeId()));
        ArrayList<AnalyseMember> memberList = new ArrayList<AnalyseMember>();
        AnalyseMember members = new AnalyseMember();
        BgAnalyseTableHelper.dealDimAndIndexMember((AnalyseMember)members, (String)dimNumber, (String)this.getBgSchemeId());
        memberList.add(members);
        _filterParam.getMembers().addAll(memberList);
        _filterParam.setShowDetailOfEmptyMember(true);
        _filterParam.setShowDetailOfQuery(true);
        _filterParam.setBgExcuteAnalysis(false);
        Set perNums = null;
        if (cell.getUserObject() != null) {
            String analyse;
            Map map = (Map)cell.getUserObject();
            String string = analyse = map.get("ANALYSE") != null ? map.get("ANALYSE").toString() : null;
            if (analyse != null && analyse.equals(BgAnalyseObjConstants.ACYT)) {
                Map periodForCurYear = MBGViewListFormFacadeFactory.getRemoteInstance().getPeriodForCurYear(periods, this.getBgSchemeId());
                perNums = (Set)periodForCurYear.get(periodNum);
            }
        }
        if (perNums != null) {
            perNums.add(periodNum);
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("id");
            evi.getSelector().add("number");
            evi.getSelector().add("name");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)perNums, CompareType.INCLUDE));
            SorterItemInfo sort = new SorterItemInfo("number");
            sort.setSortType(SortType.ASCEND);
            evi.getSorter().add(sort);
            BgPeriodCollection bgPeriodCollection = BgPeriodFactory.getRemoteInstance().getBgPeriodCollection(evi);
            BgPeriodInfo[] bgPeriodInfos = new BgPeriodInfo[bgPeriodCollection.size()];
            for (int i = 0; i < bgPeriodCollection.size(); ++i) {
                bgPeriodInfos[i] = bgPeriodCollection.get(i);
            }
            _filterParam.setBgPeriods(bgPeriodInfos);
        } else {
            BgPeriodInfo[] bgPeriodInfos = new BgPeriodInfo[1];
            BgPeriodCollection bgPeriodCollection = BgPeriodFactory.getRemoteInstance().getBgPeriodCollection("where number = '" + periodNum + "'");
            if (bgPeriodCollection.size() > 0) {
                bgPeriodInfos[0] = bgPeriodCollection.get(0);
                _filterParam.setBgPeriods(bgPeriodInfos);
            }
        }
        _filterParam.setBeginPeriod(null);
        _filterParam.setEndPeriod(null);
        CurrencyCollection currencyCollection = CurrencyFactory.getRemoteInstance().getCurrencyCollection("where number = '" + curNumber + "'");
        _filterParam.setCurrency(currencyCollection.get(0));
        BgElementCollection bgElementCollection = BgElementFactory.getRemoteInstance().getBgElementCollection("where number = '" + eleNumber + "'");
        _filterParam.setBgElement(bgElementCollection.get(0));
        _filterParam.setBgScenario(bgScenario);
        return _filterParam;
    }

    public void setAnalyseObjByProcess(BgProcessEnum processType) {
        this.getFilter2UI().setLockRows(processType);
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        this.getBuildHelper().buildForDrill(e);
    }

    public void registerPopupMenuManager(JComponent comp, PopupMenuManager mgr) {
        if (comp == this.tblMain) {
            this.getBuildHelper().initPop(mgr);
            super.registerPopupMenuManager(comp, mgr);
        }
    }

    protected void initUserConfig() {
        super.initUserConfig();
        PopupMenuManager mgr = this.getPopupMenuManager((JComponent)this.tblMain);
        if (mgr != null) {
            mgr.removeMenuSection("table");
        }
    }

    @Override
    public void actionDesignSet_actionPerformed(ActionEvent e) throws Exception {
        super.actionDesignSet_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgDataAnalyseLayoutUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionExpDirect_actionPerformed(ActionEvent e) throws Exception {
        this.getBuildHelper().expDirect();
    }

    @Override
    public void actionExpAll_actionPerformed(ActionEvent e) throws Exception {
        this.getBuildHelper().expAll();
    }

    private final class CellDisplayParser
    implements IUserCellDisplayParser {
        private CellDisplayParser() {
        }

        public Object parse(int rowIndex, int colIndex, ICell cell, Object value) {
            return MBgDataAnalyseListUI.this.formatCellDisplay(rowIndex, colIndex, cell, value);
        }
    }
}

