/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectSingleKey;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.FilterParam;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.IBgPeriod;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodDispHelper;
import com.kingdee.eas.ma.control.BgControlSettingInfo;
import com.kingdee.eas.ma.control.client.MBgAnalyseExeExtUI;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.control.impl.models.BgGroupData;
import com.kingdee.eas.ma.control.query.ExeFilterParam;
import com.kingdee.eas.ma.control.utils.BgControlTransitUtils;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.query.AnalyseMember;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.ViewlistCombinHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;

public class MbgActualDetailUI
extends MBgAnalyseExeExtUI {
    private static final long serialVersionUID = 1L;

    @Override
    protected boolean isShowSum() {
        return true;
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnDetailQuery.setVisible(false);
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.getUIWindow() instanceof KDDialog) {
            ((KDDialog)this.getUIWindow()).setResizable(true);
        }
    }

    @Override
    protected IObjectPK getOrgPK(ItemAction action) {
        BgControlParam bgControlParam = (BgControlParam)this.getUIContext().get(BgControlParam.class);
        if (bgControlParam != null && bgControlParam.getOrgUnit() != null) {
            return new ObjectUuidPK(bgControlParam.getOrgUnit().getId());
        }
        return super.getOrgPK(action);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onLoad() throws Exception {
        ExeFilterParam param = new ExeFilterParam();
        BgControlParam bgControlParam = (BgControlParam)this.getUIContext().get(BgControlParam.class);
        if (bgControlParam == null || bgControlParam.getBgSchemeInfo() == null) {
            if (this.getUIContext().get("InitDataObject") == null) return;
            super.onLoad();
            return;
        }
        OrgUnitInfo orgUnit = bgControlParam.getOrgUnit();
        ArrayList<OrgUnitInfo> orgUnits = new ArrayList<OrgUnitInfo>();
        orgUnits.add(orgUnit);
        param.setOrgUnits(orgUnits);
        LinkedHashSet<String> queryCombins = new LinkedHashSet<String>();
        queryCombins.add(bgControlParam.getDimItemNumber());
        HashSet<String> detailSet = new HashSet<String>();
        String[] tmpStrs = null;
        detailSet.addAll(bgControlParam.getBudgetDetail().keySet());
        detailSet.addAll(bgControlParam.getActualDetail().keySet());
        for (String string : detailSet) {
            tmpStrs = string.split("!");
            queryCombins.add(tmpStrs[0]);
        }
        if (bgControlParam.getBgGroupMap() != null) {
            for (List list : bgControlParam.getBgGroupMap().values()) {
                for (BgGroupData groupData : list) {
                    queryCombins.add(groupData.getBgDimNumber());
                }
            }
        }
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(bgControlParam.getBgSchemeInfo().getId().toString());
        ArrayList<AnalyseMember> arrayList = new ArrayList<AnalyseMember>();
        BgDimensionMember[] otherMembers = null;
        String[] otherCombins = null;
        String indexNumber = null;
        String otherNumber = null;
        String srcNumber = null;
        String number = null;
        String type = null;
        String refField = null;
        for (String combin : queryCombins) {
            AnalyseMember member = new AnalyseMember();
            if (combin.indexOf(",") > 0) {
                indexNumber = combin.substring(0, combin.indexOf(","));
                otherNumber = combin.substring(combin.indexOf(",") + 1);
            } else {
                indexNumber = combin;
                otherNumber = null;
            }
            BgDimensionMember bgIndex = new BgDimensionMember(DimensionConstants.DEF_ACCOUNT_NUMBER, DimensionConstants.DEF_BGINDEX_FIELD, DimensionFormulaHelper.getMemberNumber((String)indexNumber), DimensionFormulaHelper.getMemberNumber((String)indexNumber));
            bgIndex.setSrcNumber(DimensionConstants.DEF_INDEX_SRCNUMBER);
            member.setBgIndex(bgIndex);
            if (otherNumber != null) {
                otherCombins = DimensionFormulaHelper.splitCombinations((String)otherNumber);
                otherMembers = new BgDimensionMember[otherCombins.length];
                for (int i = 0; i < otherCombins.length; ++i) {
                    srcNumber = DimensionFormulaHelper.getSrcNumber((String)otherCombins[i]);
                    number = DimensionFormulaHelper.getMemberNumber((String)otherCombins[i]);
                    type = ((BgDimensionInfo)schemeHelper.getDimensionBySrcNumber().get(srcNumber)).getNumber();
                    refField = ((BgDimensionInfo)schemeHelper.getDimensionBySrcNumber().get(srcNumber)).getRefField();
                    otherMembers[i] = new BgDimensionMember(type, refField, number, number);
                    otherMembers[i].setSrcNumber(srcNumber);
                }
                member.setDimMember(ViewlistCombinHelper.getCombinMemberByDimMember((BgDimensionMember[])otherMembers));
            }
            arrayList.add(member);
        }
        param.setMembers(arrayList);
        BgPeriodInfo bgPeriod = null;
        Date beginDate = null;
        Date endDate = null;
        IBgPeriod iBgPeriod = BgPeriodFactory.getRemoteInstance();
        BgControlSettingInfo setting = bgControlParam.getControlSetting();
        if (setting != null) {
            int ctrlType = setting.getCtrlType().getValue();
            bgPeriod = iBgPeriod.getBgPeriodInfo((IObjectPK)new ObjectSingleKey((Object)bgControlParam.getBgPeriodId()));
            BgPeriodTypeInfo bgPeriodTypeInfo = BgPeriodDispHelper.getBgPeriodTypeInfo(null, (BOSUuid)bgControlParam.getBgPeriodGroup().getId());
            boolean onlySelfDefinedPeriod = BgNPeriodHelper.isOnlySelfDefinedPeriod((BgPeriodTypeInfo)bgPeriodTypeInfo);
            if (onlySelfDefinedPeriod) {
                BgSchemeInfo bgScheme = bgControlParam.getBgSchemeInfo();
                if (-1 == ctrlType || 10 == ctrlType) {
                    beginDate = bgPeriod.getBeginDate();
                    endDate = bgPeriod.getEndDate();
                } else if (11 == ctrlType) {
                    beginDate = bgScheme.getDateFrom();
                    endDate = bgPeriod.getEndDate();
                } else {
                    beginDate = bgScheme.getDateFrom();
                    endDate = bgScheme.getDateTo();
                }
            } else if (-1 == ctrlType || 10 == ctrlType) {
                beginDate = bgPeriod.getBeginDate();
                endDate = bgPeriod.getEndDate();
            } else if (11 == ctrlType || 12 == ctrlType) {
                BgSchemeInfo bgScheme = bgControlParam.getBgSchemeInfo();
                int periodType = setting.getPeriodType().getValue();
                if (BgPeriodDispHelper.checkNoIn((int)bgPeriod.getPeriodTypeEnum().getValue(), (int)periodType)) {
                    beginDate = bgPeriod.getBeginDate();
                    endDate = bgPeriod.getEndDate();
                } else if (0 == periodType) {
                    Date bTime = bgControlParam.getControlSetting().getScheme().getBeginTime();
                    Date eTime = bgControlParam.getControlSetting().getScheme().getEndTime();
                    Date fTime = bgScheme.getDateFrom();
                    Date tTime = bgScheme.getDateTo();
                    if (bTime.getTime() >= tTime.getTime() || fTime.getTime() >= eTime.getTime()) {
                        if (bTime.getTime() == new Date().getTime()) {
                            beginDate = bTime;
                            endDate = bTime;
                        } else {
                            if (fTime.getTime() != eTime.getTime()) return;
                            beginDate = eTime;
                            endDate = eTime;
                        }
                    } else {
                        beginDate = bTime.getTime() >= fTime.getTime() ? bTime : fTime;
                        endDate = eTime.getTime() >= tTime.getTime() ? tTime : eTime;
                    }
                } else if (1 == periodType) {
                    Date[] dates = BgControlTransitUtils.getYearTime(bgControlParam.getBizDate());
                    beginDate = dates[0];
                    endDate = dates[1];
                } else if (2 == periodType) {
                    Date[] dates = BgControlTransitUtils.getHalfYearTime(bgControlParam.getBizDate());
                    beginDate = dates[0];
                    endDate = dates[1];
                } else if (3 == periodType) {
                    Date[] dates = BgControlTransitUtils.getQuarterTime(bgControlParam.getBizDate());
                    beginDate = dates[0];
                    endDate = dates[1];
                } else if (4 == periodType) {
                    Date[] dates = BgControlTransitUtils.getMonthTime(bgControlParam.getBizDate());
                    beginDate = dates[0];
                    endDate = dates[1];
                }
                if (beginDate != null && beginDate.compareTo(bgScheme.getDateFrom()) < 0) {
                    beginDate = bgScheme.getDateFrom();
                }
                if (endDate != null && endDate.compareTo(bgScheme.getDateTo()) > 0) {
                    endDate = bgScheme.getDateTo();
                }
            }
        } else {
            bgPeriod = iBgPeriod.getBgPeriodInfo((IObjectPK)new ObjectSingleKey((Object)bgControlParam.getBgPeriodId()));
            beginDate = bgPeriod.getBeginDate();
            endDate = bgPeriod.getEndDate();
        }
        param.setBgPeriodType(bgControlParam.getBgPeriodGroup());
        param.setStart(beginDate);
        param.setBeover(endDate);
        param.setShowDetailOfQuery(true);
        param.setBeginPeriod(bgPeriod);
        BgSchemeInfo bgScheme = new BgSchemeInfo();
        bgScheme.setId(bgControlParam.getBgSchemeInfo().getId());
        param.setBgScheme(bgScheme);
        CurrencyInfo currency = bgControlParam.getCurrency();
        param.setCurrency(currency);
        BgElementInfo bgElement = bgControlParam.getBgElement();
        param.setBgElement(bgElement);
        param.setBgScenario(bgControlParam.getAcScenario());
        this.setFilterParam((FilterParam)param);
        super.onLoad();
    }

    @Override
    protected boolean hasDefaultQuery() throws Exception {
        return true;
    }
}

