/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.FiscalYearEnum;
import com.kingdee.eas.ma.mbg.BgDimSettingsCollection;
import com.kingdee.eas.ma.mbg.BgDimSettingsFactory;
import com.kingdee.eas.ma.mbg.BgDimSettingsInfo;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberFactory;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MbgAnalyseExeHelper {
    public static Set<String> getBgScenarioID(BgSchemeInfo bgscheme) throws Exception {
        HashSet<String> scenarioID = new HashSet<String>();
        if (bgscheme == null) {
            return scenarioID;
        }
        ISQLExecutor executor = null;
        IRowSet rowSet = null;
        String sql = "SELECT scenario.FID FROM T_Mbg_BgScheme scheme  join T_Mbg_BgDimSettings dim on dim.FBgschemeID = scheme.FID  join T_Mbg_BgDimSettingsMember dimMember on dimMember.FBgDimsettingsID = dim.FID  join T_Mbg_BgScenario scenario on scenario.FID = dimMember.FMemberID  where dim.FDimNumber = '" + DimensionConstants.DEF_SCENARIO_NUMBER + "' and scheme.FID = '" + bgscheme.getId().toString() + "'";
        executor = SQLExecutorFactory.getRemoteInstance((String)sql);
        rowSet = executor.executeSQL();
        while (rowSet.next()) {
            scenarioID.add(rowSet.getString("FID"));
        }
        return scenarioID;
    }

    public static Set<String> getCurrencyID(BgSchemeInfo bgscheme) throws Exception {
        HashSet<String> currencyID = new HashSet<String>();
        if (bgscheme == null) {
            return currencyID;
        }
        ISQLExecutor executor = null;
        IRowSet rowSet = null;
        String sql = "SELECT currency.FID FROM T_Mbg_BgScheme scheme  join T_Mbg_BgDimSettings dim on dim.FBgschemeID = scheme.FID  join T_Mbg_BgDimSettingsMember dimMember on dimMember.FBgDimsettingsID = dim.FID  join T_BD_Currency currency on currency.FID = dimMember.FMemberID   where dim.FDimNumber = '" + DimensionConstants.DEF_CURRENCY_NUMBER + "' and scheme.FID = '" + bgscheme.getId().toString() + "'";
        executor = SQLExecutorFactory.getRemoteInstance((String)sql);
        rowSet = executor.executeSQL();
        while (rowSet.next()) {
            currencyID.add(rowSet.getString("FID"));
        }
        return currencyID;
    }

    public static Set<String> getElementID(BgSchemeInfo bgscheme) throws Exception {
        HashSet<String> elementID = new HashSet<String>();
        if (bgscheme == null) {
            return elementID;
        }
        ISQLExecutor executor = null;
        IRowSet rowSet = null;
        String sql = "SELECT element.FID FROM T_Mbg_BgScheme scheme  join T_Mbg_BgDimSettings dim on dim.FBgschemeID = scheme.FID  join T_Mbg_BgDimSettingsMember dimMember on dimMember.FBgDimsettingsID = dim.FID  join T_MBG_BgElement element on element.FID = dimMember.FMemberID  where dim.FDimNumber = '" + DimensionConstants.DEF_ELEMENT_NUMBER + "' and scheme.FID = '" + bgscheme.getId().toString() + "'";
        executor = SQLExecutorFactory.getRemoteInstance((String)sql);
        rowSet = executor.executeSQL();
        while (rowSet.next()) {
            elementID.add(rowSet.getString("FID"));
        }
        return elementID;
    }

    public static String getBudgetViewID(BgSchemeInfo bgscheme) throws Exception {
        if (bgscheme != null) {
            return MbgAnalyseExeHelper.getBudgetViewID(bgscheme.getId().toString());
        }
        return null;
    }

    public static String getBudgetViewID(String bgSchemeId) throws Exception {
        if (StringUtils.isEmpty((String)bgSchemeId)) {
            return null;
        }
        ISQLExecutor executor = null;
        IRowSet rowSet = null;
        String sql = "SELECT orgView.FID  FROM T_Mbg_BgScheme scheme  join T_Mbg_BgDimSettings dim on dim.FBgschemeID = scheme.FID  join T_Mbg_BgDimSettingsMember dimMember on dimMember.FBgDimsettingsID = dim.FID  join T_Mbg_BgOrgView orgView on orgView.FID = dimMember.FMemberID  where dim.FDimNumber = '" + DimensionConstants.DEF_ORGUNIT_NUMBER + "'  and scheme.FID = '" + bgSchemeId + "' and dimMember.FType =" + 2;
        executor = SQLExecutorFactory.getRemoteInstance((String)sql);
        rowSet = executor.executeSQL();
        if (rowSet.next()) {
            return rowSet.getString("FID");
        }
        return null;
    }

    public static Set<String> getBgVersionID(BgSchemeInfo bgscheme) throws Exception {
        HashSet<String> versionID = new HashSet<String>();
        if (bgscheme == null) {
            return versionID;
        }
        ISQLExecutor executor = null;
        IRowSet rowSet = null;
        String sql = "SELECT version.FID FROM T_Mbg_BgScheme scheme  join T_Mbg_BgDimSettings dim on dim.FBgschemeID = scheme.FID  join T_Mbg_BgDimSettingsMember dimMember on dimMember.FBgDimsettingsID = dim.FID  join T_Mbg_BgVersion version on version.FID = dimMember.FMemberID  where dim.FDimNumber = '" + DimensionConstants.DEF_VERSION_NUMBER + "' and scheme.FID = '" + bgscheme.getId().toString() + "'";
        executor = SQLExecutorFactory.getRemoteInstance((String)sql);
        rowSet = executor.executeSQL();
        while (rowSet.next()) {
            versionID.add(rowSet.getString("FID"));
        }
        return versionID;
    }

    public static BgPeriodInfo[] getPeriodInfoByNumber(String bgSchemeId, Set<String> numbers) throws BOSException {
        String sql = "Select FMemberID from T_Mbg_BgDimSettings sett  join T_Mbg_BgDimSettingsMember member on member.FBgDimSettingsID = sett.FID where sett.FBgSchemeID = '" + bgSchemeId + "' and  sett.FDimNumber = '" + DimensionConstants.DEF_PERIOD_NUMBER + "'";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type.id", (Object)sql, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("type.fiscalYear", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
        view.setFilter(filter);
        SorterItemInfo sorterInfo = new SorterItemInfo("longNumber");
        sorterInfo.setSortType(SortType.ASCEND);
        view.getSorter().add(sorterInfo);
        CoreBaseCollection colls = BgPeriodDispFactory.getRemoteInstance().getCollection(view);
        BgPeriodInfo[] bgPeriods = new BgPeriodInfo[colls.size()];
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            BgPeriodDispInfo periodDisInfo = (BgPeriodDispInfo)colls.get(i);
            bgPeriods[i] = periodDisInfo.toBgPeriodInfo();
        }
        return bgPeriods;
    }

    public static Map<String, String> getBgSchemeDefaultMember(String bgSchemeId) throws BOSException {
        HashMap<String, String> result = new HashMap<String, String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
        view.setFilter(filter);
        BgDimSettingsCollection coll = BgDimSettingsFactory.getRemoteInstance().getBgDimSettingsCollection(view);
        for (BgDimSettingsInfo info : coll) {
            result.put(info.getDimNumber(), info.getDefMemberID());
        }
        return result;
    }

    public static void addDispNameForPeriods(Object[] periods, BgSchemeInfo bgScheme) throws EASBizException, BOSException {
        int i;
        if (periods == null || bgScheme == null) {
            return;
        }
        String sql = "Select FMemberID from T_Mbg_BgDimSettings sett  join T_Mbg_BgDimSettingsMember member on member.FBgDimSettingsID = sett.FID where sett.FBgSchemeID = '" + bgScheme.getId().toString() + "' and  sett.FDimNumber = '" + DimensionConstants.DEF_PERIOD_NUMBER + "'";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type.id", (Object)sql, CompareType.INNER));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("alias"));
        selector.add(new SelectorItemInfo("type.fiscalYear"));
        view.setSelector(selector);
        CoreBaseCollection colls = BgPeriodDispFactory.getRemoteInstance().getCollection(view);
        HashMap<String, String> dispNames = new HashMap<String, String>();
        for (i = 0; i < colls.size(); ++i) {
            BgPeriodDispInfo disp = (BgPeriodDispInfo)colls.get(i);
            if (!dispNames.containsKey(disp.getNumber())) {
                dispNames.put(disp.getNumber(), disp.getAlias());
                continue;
            }
            if (!disp.getType().getFiscalYear().equals((Object)FiscalYearEnum.STANDARDYEAR)) continue;
            dispNames.put(disp.getNumber(), disp.getAlias());
        }
        for (i = 0; i < periods.length; ++i) {
            BgPeriodInfo period = (BgPeriodInfo)periods[i];
            period.setDisplayName((String)dispNames.get(period.getNumber()));
        }
    }

    public static List<BgAccountInfo> getAccountForScheme(BgSchemeInfo bgScheme) throws EASBizException, BOSException {
        if (bgScheme == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgDimsettings.bgScheme.id", (Object)bgScheme.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgDimsettings.dimNumber", (Object)DimensionConstants.DEF_ACCOUNT_NUMBER, CompareType.EQUALS));
        view.setFilter(filter);
        CoreBaseCollection accountView = BgDimSettingsMemberFactory.getRemoteInstance().getCollection(view);
        if (accountView.size() == 0) {
            return null;
        }
        filter.getFilterItems().clear();
        filter.getFilterItems().add(new FilterItemInfo("bgAccountView.id", (Object)((BgDimSettingsMemberInfo)accountView.get(0)).getMemberID(), CompareType.EQUALS));
        CoreBaseCollection accounts = BgAccountFactory.getRemoteInstance().getCollection(view);
        ArrayList<BgAccountInfo> accountList = new ArrayList<BgAccountInfo>();
        for (int i = 0; i < accounts.size(); ++i) {
            accountList.add((BgAccountInfo)accounts.get(i));
        }
        return accountList;
    }
}

