/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.control.BgControlSettingInfo;
import com.kingdee.eas.ma.control.BgCtrlPeriodTypeEnum;
import com.kingdee.eas.ma.control.BgCtrlSetRuleEnum;
import com.kingdee.eas.ma.control.client.AbstractMbgAvlBalDetailUI;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.control.impl.models.BgGroupData;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.utils.BgCellRenderHelper;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MbgAvlBalDetailUI
extends AbstractMbgAvlBalDetailUI {
    private static final Logger logger = CoreUIObject.getLogger(MbgAvlBalDetailUI.class);
    private static final long serialVersionUID = 6140080475082428930L;
    public static final String bgDataId = "bgDataId";
    public static final String isCtrl = "isCtrl";
    public static final String formatStyle = "formatStyle";
    public static final String balTypeEnum = "balTypeEnum";
    public static final String COL_TRANSITVALUE = "transitValue";
    public static final String COL_COETRANSITVALUE = "coeTransitValue";
    protected static final String add = "+";
    protected static final String subtract = "-";
    protected static final String multiply = "*";
    protected static final String divide = "/";
    protected static final String equal = "=";
    protected static final String leftSmallBracket = "(";
    protected static final String rightSmallBracket = ")";
    protected static final String leftBigBracket = "[";
    protected static final String rightBigBracket = "]";
    protected static final String newLineSpliter = "\n";
    protected DecimalFormat floatFormater = BgNationalFormatUIUtil.getDecimalFormat((int)2);
    protected DecimalFormat longFormater = BgNationalFormatUIUtil.getDecimalFormat((int)2);
    private boolean isLoadTransitBudget = false;
    private BgCellRenderHelper cellHelper = new BgCellRenderHelper();

    public DecimalFormat getFloatFormater() {
        return this.floatFormater;
    }

    public BgCellRenderHelper getCellHelper() {
        return this.cellHelper;
    }

    public void onLoad() throws Exception {
        Object object;
        super.onLoad();
        this.getCellHelper().init();
        Object transit = this.getUIContext().get("isLoadTransitBudget");
        if (transit != null && transit instanceof Boolean) {
            this.isLoadTransitBudget = (Boolean)transit;
        }
        if ((object = this.getUIContext().get(BgControlParam.class)) == null || !(object instanceof BgControlParam)) {
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)BgControlConstants.CONTROL_SOURCE, (String)"controlParamIsNull"));
            SysUtil.abort();
        }
        BgControlParam controlParam = (BgControlParam)object;
        this._initHead(controlParam);
        this._initBody(controlParam);
    }

    private void _initHead(BgControlParam controlParam) {
        BgCtrlPeriodTypeEnum periodType = controlParam.getControlSetting().getPeriodType();
        this.txtPeriodRange.setText(periodType.getAlias());
        BigDecimal avlBal = controlParam.getExtBalance() != null ? controlParam.getExtBalance() : controlParam.getOrignBalance();
        this.txtBal.setText(this.getFloatFormater().format(avlBal));
        BgControlSettingInfo controlSetting = controlParam.getControlSetting();
        StringBuffer ctrlType = new StringBuffer(controlSetting.getCtrlType().getAlias());
        ctrlType.append(BgNFCHelper.getMessageStr((String)BgControlConstants.CONTROL_SOURCE, (String)"elastic"));
        if (controlSetting.isIsGroupCtrl()) {
            ctrlType.append(BgNFCHelper.getMessageStr((String)BgControlConstants.CONTROL_SOURCE, (String)"group"));
        }
        if (1 == controlSetting.getCtrlSetRule().getValue()) {
            ctrlType.append(", " + BgCtrlSetRuleEnum.Summary.getAlias());
        } else if (0 == controlSetting.getCtrlSetRule().getValue()) {
            ctrlType.append(", " + BgCtrlSetRuleEnum.Detail.getAlias());
        }
        this.txtCtrlType.setText(ctrlType.toString());
        StringBuilder str = new StringBuilder();
        BgScenarioInfo bgScenario = controlParam.getBgScenario();
        str.append(bgScenario.getName()).append(leftSmallBracket).append(bgScenario.getNumber()).append(rightSmallBracket);
        this.txtScenario.setText(str.toString());
        this.formula.setEnabled(true);
        this.formula.setEditable(false);
        this.formula.setAutoscrolls(true);
    }

    private void checkParsed() {
        this.tblMain.checkParsed();
        this.tblMain.getColumn(COL_TRANSITVALUE).getStyleAttributes().setHided(!this.isLoadTransitBudget);
        this.tblMain.getColumn(COL_COETRANSITVALUE).getStyleAttributes().setHided(!this.isLoadTransitBudget);
    }

    /*
     * WARNING - void declaration
     */
    private void _initBody(BgControlParam controlParam) throws BOSException, EASBizException {
        BigDecimal sumBgFlexTransitValue;
        BigDecimal sumBgTransitValue;
        if (controlParam == null) {
            return;
        }
        this.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getMergeManager().setMergeMode(3);
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn(0).setGroup(true);
        this.tblMain.getColumn(1).setGroup(true);
        this.tblMain.setRefresh(false);
        BigDecimal sumBgValue = new BigDecimal(BigInteger.ZERO);
        BigDecimal sumAcValue = new BigDecimal(BigInteger.ZERO);
        BigDecimal flexBgValue = null;
        BigDecimal pre_groupDataFlex = new BigDecimal(BigInteger.ZERO);
        BigDecimal flexBgTransitValue = null;
        HashMap<String, BigDecimal> sumBgValue_addup = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> sumAcValue_addup = new HashMap<String, BigDecimal>();
        Object flexBgValue_addup = null;
        HashMap<String, BigDecimal> sumBgTransitValue_addup = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> sumBgFlexTransitValue_addup = new HashMap<String, BigDecimal>();
        BigDecimal bgValue = null;
        BigDecimal acValue = null;
        BigDecimal bgTransitValue = null;
        BigDecimal bgFlexTransitValue = null;
        BgGroupData bgData = null;
        BgGroupData acData = null;
        Object bgTransitData = null;
        int index = 0;
        String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        String tmpKey22 = null;
        String tmpDimNum = null;
        String[] tmpStrs = null;
        HashSet<String> detailSet = new HashSet<String>();
        HashSet<String> bgPeriodSet = new HashSet<String>();
        for (String tmpKey22 : controlParam.getBudgetDetail().keySet()) {
            tmpStrs = tmpKey22.split("!");
            detailSet.add(tmpStrs[0]);
            bgPeriodSet.add(tmpStrs[1]);
        }
        for (String tmpKey22 : controlParam.getActualDetail().keySet()) {
            tmpStrs = tmpKey22.split("!");
            detailSet.add(tmpStrs[0]);
            bgPeriodSet.add(tmpStrs[1]);
        }
        Map.Entry<BOSUuid, List<BgGroupData>> entry22 = null;
        for (Map.Entry<BOSUuid, List<BgGroupData>> entry22 : controlParam.getBgGroupMap().entrySet()) {
            List<BgGroupData> _bgGroupDatas;
            if (controlParam.getControlSetting().getId().equals((Object)entry22.getKey()) || (_bgGroupDatas = entry22.getValue()) == null) continue;
            BgGroupData bgGroupData = null;
            int in = _bgGroupDatas.size();
            for (int i = 0; i < in; ++i) {
                bgGroupData = _bgGroupDatas.get(i);
                detailSet.add(bgGroupData.getBgDimNumber());
                bgPeriodSet.add(bgGroupData.getBgPeriodNumber());
            }
        }
        if (detailSet.isEmpty() || bgPeriodSet.isEmpty()) {
            return;
        }
        ArrayList detailNums = new ArrayList(detailSet);
        Collections.sort(detailNums);
        ArrayList bgPeriodNums = new ArrayList(bgPeriodSet);
        Collections.sort(bgPeriodNums);
        List<Object> tmpList = new ArrayList();
        Iterator<List<BgGroupData>> iter = controlParam.getBgGroupMap().values().iterator();
        while (iter.hasNext()) {
            tmpList.addAll((Collection)iter.next());
        }
        HashSet<String> querySet = new HashSet<String>();
        querySet.add(controlParam.getDimItemNumber());
        querySet.addAll(detailSet);
        for (BgGroupData bgGroupData : tmpList) {
            querySet.add(bgGroupData.getBgDimNumber());
        }
        String orgUnitId = controlParam.getOrgUnit().getId().toString();
        Map map = DimensionFormulaFacadeFactory.getRemoteInstance().getDimensionCombName(controlParam.getBgSchemeInfo().getId().toString(), querySet, orgUnitId);
        querySet.clear();
        BgControlSettingInfo setting = controlParam.getControlSetting();
        BigDecimal flexParam = setting.getFlexParam();
        String bgPeriodNum = null;
        String bgDimNumber = controlParam.getDimItemNumber();
        String bgDimName = controlParam.getDimItemName();
        if (map != null && map.containsKey(bgDimNumber)) {
            bgDimName = (String)map.get(bgDimNumber);
        }
        String bgIndexNumber = bgDimNumber.split(",")[0];
        String bgIndexName = bgDimName.split(",")[0];
        String accountViewId = BgCellRenderHelper.getAccountViewIdByBgScheme((BgSchemeInfo)controlParam.getBgSchemeInfo());
        String displayBgIndex = this.getCellHelper().getIndexDisplayName(accountViewId, bgIndexNumber, bgIndexName);
        String displayExtMember = this.getExtName(controlParam);
        String displayFlex = this.getFloatFormater().format(flexParam);
        String dispBgValue = null;
        String dispAcValue = null;
        String dispFlexValue = null;
        String dispBgTransitValue = null;
        String dispBgFlexTransitValue = null;
        String[] tmpNums = null;
        String[] tmpNames = null;
        ArrayList<IRow> rows = new ArrayList<IRow>();
        StringBuffer text = new StringBuffer(BgCommCHelper.getMessageStr((String)BgControlConstants.CONTROL_SOURCE, (String)"budget"));
        if (controlParam.isAddupCtrl()) {
            text = controlParam.getHasActualPeriods().size() > 1 ? new StringBuffer(BgCommCHelper.getMessageStr((String)BgControlConstants.CONTROL_SOURCE, (String)"addupCtrlDescription")) : new StringBuffer(BgCommCHelper.getMessageStr((String)BgControlConstants.CONTROL_SOURCE, (String)"addupCtrlDescriptionNoActual"));
        }
        StringBuffer bgIndexStr = new StringBuffer(displayBgIndex);
        StringBuffer amountStr = new StringBuffer();
        HashMap<String, StringBuffer> amountStr_addup = new HashMap<String, StringBuffer>();
        boolean hasSum = false;
        int in = detailNums.size();
        for (int i = 0; i < in; ++i) {
            tmpDimNum = (String)detailNums.get(i);
            sumBgValue = new BigDecimal(BigInteger.ZERO);
            sumAcValue = new BigDecimal(BigInteger.ZERO);
            sumBgTransitValue = new BigDecimal(BigInteger.ZERO);
            sumBgFlexTransitValue = new BigDecimal(BigInteger.ZERO);
            sumBgValue_addup.clear();
            sumAcValue_addup.clear();
            sumBgTransitValue_addup.clear();
            sumBgFlexTransitValue_addup.clear();
            tmpNums = tmpDimNum.split(",");
            bgDimName = (String)map.get(tmpDimNum);
            if (bgDimName == null) {
                logger.error((Object)("No Find tmpDimNum[" + tmpDimNum + "] orgUnitId:[" + controlParam.getOrgUnit().getId() + rightBigBracket));
                continue;
            }
            tmpNames = bgDimName.split(",");
            displayExtMember = this.getExtName(tmpNums, tmpNames);
            displayBgIndex = this.getCellHelper().getIndexDisplayName(accountViewId, tmpNums[0], tmpNames[0]);
            int jn = bgPeriodNums.size();
            for (int j = 0; j < jn; ++j) {
                bgPeriodNum = (String)bgPeriodNums.get(j);
                bgData = controlParam.getBudgetDetail().get(tmpDimNum + "!" + bgPeriodNum);
                acData = controlParam.getActualDetail().get(tmpDimNum + "!" + bgPeriodNum);
                if ((bgData == null || bgData.getBudgetValue() == null && (bgData.getTransitBudgetValue() == null || bgData.getTransitBudgetValue().compareTo(BigDecimal.ZERO) == 0)) && (acData == null || acData.getActualValue() == null)) continue;
                if (bgData != null) {
                    if (bgData.getBudgetValue() != null) {
                        sumBgValue = sumBgValue.add(bgData.getBudgetValue());
                        dispBgValue = this.getFloatFormater().format(bgData.getBudgetValue());
                        if (controlParam.isAddupCtrl()) {
                            for (String addPeriod : controlParam.getHasActualPeriods()) {
                                if (!controlParam.checkIsInPeriodForAddCtrl(bgPeriodNum, addPeriod)) continue;
                                sumBgValue_addup.put(addPeriod, BgNFSHelper.addBigDecimal((BigDecimal)((BigDecimal)sumBgValue_addup.get(addPeriod)), (BigDecimal)bgData.getBudgetValue()));
                            }
                        }
                    }
                    if (bgData.getTransitBudgetValue() != null && bgData.getTransitBudgetValue().compareTo(BigDecimal.ZERO) != 0) {
                        sumBgTransitValue = sumBgTransitValue.add(bgData.getTransitBudgetValue());
                        sumBgFlexTransitValue = sumBgFlexTransitValue.add(bgData.getTransitBudgetValue().multiply(flexParam));
                        dispBgTransitValue = this.getFloatFormater().format(bgData.getTransitBudgetValue());
                        dispBgFlexTransitValue = this.getFloatFormater().format(bgData.getTransitBudgetValue().multiply(flexParam));
                        if (controlParam.isAddupCtrl()) {
                            for (String addPeriod : controlParam.getHasActualPeriods()) {
                                if (!controlParam.checkIsInPeriodForAddCtrl(bgPeriodNum, addPeriod)) continue;
                                sumBgTransitValue_addup.put(addPeriod, BgNFSHelper.addBigDecimal((BigDecimal)((BigDecimal)sumBgTransitValue_addup.get(addPeriod)), (BigDecimal)bgData.getTransitBudgetValue()));
                                sumBgFlexTransitValue_addup.put(addPeriod, BgNFSHelper.addBigDecimal((BigDecimal)((BigDecimal)sumBgFlexTransitValue_addup.get(addPeriod)), (BigDecimal)bgData.getTransitBudgetValue().multiply(flexParam)));
                            }
                        }
                    } else {
                        dispBgTransitValue = null;
                        dispBgFlexTransitValue = null;
                    }
                } else {
                    dispBgValue = null;
                    dispBgTransitValue = null;
                    dispBgFlexTransitValue = null;
                }
                if (acData != null && acData.getActualValue() != null) {
                    sumAcValue = sumAcValue.add(acData.getActualValue());
                    dispAcValue = this.getFloatFormater().format(acData.getActualValue());
                    for (String addPeriod : controlParam.getHasActualPeriods()) {
                        if (!controlParam.checkIsInPeriodForAddCtrl(bgPeriodNum, addPeriod)) continue;
                        sumAcValue_addup.put(addPeriod, BgNFSHelper.addBigDecimal((BigDecimal)((BigDecimal)sumAcValue_addup.get(addPeriod)), (BigDecimal)acData.getActualValue()));
                    }
                } else {
                    dispAcValue = null;
                }
                IRow row = this.tblMain.addRow();
                row.getCell("dimCombine").setValue((Object)displayBgIndex);
                row.getCell("members").setValue((Object)displayExtMember);
                row.getCell("period").setValue((Object)bgPeriodNum);
                row.getCell("bgVal").setValue((Object)dispBgValue);
                if (!this.getFloatFormater().format(BigDecimal.ZERO).equals(dispBgTransitValue)) {
                    row.getCell(COL_TRANSITVALUE).setValue((Object)dispBgTransitValue);
                }
                if (!this.getFloatFormater().format(BigDecimal.ZERO).equals(dispBgFlexTransitValue)) {
                    row.getCell(COL_COETRANSITVALUE).setValue((Object)dispBgFlexTransitValue);
                }
                row.getCell("coe").setValue((Object)displayFlex);
                row.getCell("actVal").setValue((Object)dispAcValue);
                rows.add(row);
                hasSum = true;
            }
            if (!hasSum) continue;
            flexBgValue = sumBgValue.multiply(setting.getFlexParam());
            dispBgFlexTransitValue = this.getFloatFormater().format(sumBgFlexTransitValue);
            dispFlexValue = this.getFloatFormater().format(flexBgValue);
            this.addSumRow(this.tblMain, sumBgValue, flexBgValue, sumAcValue, sumBgTransitValue, sumBgFlexTransitValue);
            dispAcValue = this.getFloatFormater().format(sumAcValue);
            if (controlParam.isAddupCtrl()) {
                for (String addPeriod : controlParam.getHasActualPeriods()) {
                    flexBgValue = sumBgValue_addup.get(addPeriod) == null ? BgControlConstants.ZERO : ((BigDecimal)sumBgValue_addup.get(addPeriod)).multiply(setting.getFlexParam());
                    flexBgTransitValue = sumBgFlexTransitValue_addup.get(addPeriod) == null ? BgControlConstants.ZERO : (BigDecimal)sumBgFlexTransitValue_addup.get(addPeriod);
                    dispFlexValue = this.getFloatFormater().format(flexBgValue);
                    dispBgFlexTransitValue = this.getFloatFormater().format(flexBgTransitValue);
                    StringBuffer _amount = null;
                    if (amountStr_addup.containsKey(addPeriod)) {
                        _amount = (StringBuffer)amountStr_addup.get(addPeriod);
                    } else {
                        _amount = new StringBuffer();
                        amountStr_addup.put(addPeriod, _amount);
                    }
                    if (sumAcValue_addup.get(addPeriod) == null) {
                        this.addAmountText(_amount, dispFlexValue, this.getFloatFormater().format(BgControlConstants.ZERO), dispBgFlexTransitValue);
                        continue;
                    }
                    String disAcValue = ((BigDecimal)sumAcValue_addup.get(addPeriod)).compareTo(BgControlConstants.ZERO) < 0 ? leftSmallBracket + this.getFloatFormater().format(sumAcValue_addup.get(addPeriod)) + rightSmallBracket : this.getFloatFormater().format(sumAcValue_addup.get(addPeriod));
                    this.addAmountText(_amount, dispFlexValue, disAcValue, dispBgFlexTransitValue);
                }
            } else {
                String disAcValue = sumAcValue.compareTo(BgControlConstants.ZERO) < 0 ? leftSmallBracket + this.getFloatFormater().format(sumAcValue) + rightSmallBracket : this.getFloatFormater().format(sumAcValue);
                this.addAmountText(amountStr, dispFlexValue, disAcValue, dispBgFlexTransitValue);
            }
            hasSum = false;
        }
        String _char = "";
        if (amountStr.length() > 0) {
            _char = amountStr.substring(amountStr.length() - 1);
        }
        if (!_char.equals(rightSmallBracket) && !_char.equals(rightBigBracket) && amountStr.length() > 0) {
            amountStr = amountStr.delete(amountStr.length() - 1, amountStr.length());
        }
        if (setting.isIsGroupCtrl()) {
            void var65_80;
            ArrayList<Object> bgGroupDatas = new ArrayList<Object>();
            BOSUuid settingId = null;
            String lastDimNum = null;
            for (Map.Entry<BOSUuid, List<BgGroupData>> entry22 : controlParam.getBgGroupMap().entrySet()) {
                settingId = entry22.getKey();
                tmpList = entry22.getValue();
                if (controlParam.getControlSetting().getId().equals((Object)settingId)) {
                    for (BgGroupData bgGroupData : tmpList) {
                        if (bgGroupData.getBgDimNumber().equals(controlParam.getDimItemNumber())) continue;
                        bgGroupDatas.add(bgGroupData);
                    }
                    continue;
                }
                bgGroupDatas.addAll(tmpList);
            }
            int n = bgGroupDatas.size() - 1;
            boolean in2 = false;
            while (var65_80 >= in2) {
                BgGroupData firstGroupData = (BgGroupData)bgGroupDatas.get((int)var65_80);
                boolean jn = false;
                for (void j = var65_80 - true; j >= jn; --j) {
                    BgGroupData secondGroupData = (BgGroupData)bgGroupDatas.get((int)j);
                    if (!firstGroupData.getKey().equals(secondGroupData.getKey())) continue;
                    if (firstGroupData.getActualValue() != null) {
                        secondGroupData.setActualValue(firstGroupData.getActualValue());
                    }
                    if (firstGroupData.getBudgetValue() != null) {
                        secondGroupData.setBudgetValue(firstGroupData.getBudgetValue());
                    }
                    if (firstGroupData.getTransitBudgetValue() != null && firstGroupData.getTransitBudgetValue().compareTo(BigDecimal.ZERO) != 0) {
                        secondGroupData.setTransitBudgetValue(firstGroupData.getTransitBudgetValue());
                    }
                    bgGroupDatas.remove((int)var65_80);
                    break;
                }
                --var65_80;
            }
            if (!bgGroupDatas.isEmpty()) {
                boolean bl;
                Collections.sort(bgGroupDatas, new Comparator<BgGroupData>(){

                    @Override
                    public int compare(BgGroupData o1, BgGroupData o2) {
                        int re = o1.getBgDimNumber().compareTo(o2.getBgDimNumber());
                        if (re == 0) {
                            re = o1.getBgPeriodNumber().compareTo(o2.getBgPeriodNumber());
                        }
                        return re;
                    }
                });
                sumBgValue = new BigDecimal(BigInteger.ZERO);
                sumAcValue = new BigDecimal(BigInteger.ZERO);
                sumBgTransitValue = new BigDecimal(BigInteger.ZERO);
                sumBgFlexTransitValue = new BigDecimal(BigInteger.ZERO);
                sumBgValue_addup.clear();
                sumAcValue_addup.clear();
                sumBgTransitValue_addup.clear();
                sumBgFlexTransitValue_addup.clear();
                if (amountStr.length() > 0) {
                    amountStr.append(add);
                }
                boolean bl2 = true;
                BgGroupData bgGroupData = null;
                int in3 = bgGroupDatas.size();
                for (int i = 0; i < in3; ++i) {
                    bgGroupData = (BgGroupData)bgGroupDatas.get(i);
                    if (bgGroupData.getBudgetValue() == null && (bgGroupData.getTransitBudgetValue() == null || bgGroupData.getTransitBudgetValue().compareTo(BigDecimal.ZERO) == 0) && bgGroupData.getActualValue() == null) continue;
                    bl = false;
                    if (lastDimNum != null && !bgGroupData.getBgDimNumber().equals(lastDimNum)) {
                        flexBgValue = sumBgValue.multiply(pre_groupDataFlex);
                        flexBgTransitValue = sumBgTransitValue.multiply(pre_groupDataFlex);
                        dispFlexValue = this.getFloatFormater().format(flexBgValue);
                        dispBgFlexTransitValue = this.getFloatFormater().format(flexBgTransitValue);
                        this.addSumRow(this.tblMain, sumBgValue, flexBgValue, sumAcValue, sumBgTransitValue, sumBgFlexTransitValue);
                        if (controlParam.isAddupCtrl()) {
                            ArrayList<String> periods = new ArrayList<String>(controlParam.getHasActualPeriods());
                            Collections.sort(periods);
                            for (String addPeriod : controlParam.getHasActualPeriods()) {
                                flexBgValue = sumBgValue_addup.get(addPeriod) == null ? BgControlConstants.ZERO : ((BigDecimal)sumBgValue_addup.get(addPeriod)).multiply(pre_groupDataFlex);
                                flexBgTransitValue = sumBgTransitValue_addup.get(addPeriod) == null ? BgControlConstants.ZERO : ((BigDecimal)sumBgTransitValue_addup.get(addPeriod)).multiply(pre_groupDataFlex);
                                dispFlexValue = this.getFloatFormater().format(flexBgValue);
                                dispBgFlexTransitValue = this.getFloatFormater().format(flexBgTransitValue);
                                dispAcValue = sumAcValue_addup.get(addPeriod) == null ? this.getFloatFormater().format(BgControlConstants.ZERO) : (((BigDecimal)sumAcValue_addup.get(addPeriod)).compareTo(BgControlConstants.ZERO) < 0 ? leftSmallBracket + this.getFloatFormater().format(sumAcValue_addup.get(addPeriod)) + rightSmallBracket : this.getFloatFormater().format(sumAcValue_addup.get(addPeriod)));
                                StringBuffer _amount = null;
                                if (amountStr_addup.containsKey(addPeriod)) {
                                    _amount = (StringBuffer)amountStr_addup.get(addPeriod);
                                } else {
                                    _amount = new StringBuffer();
                                    amountStr_addup.put(addPeriod, _amount);
                                }
                                this.addAmountText(_amount, dispFlexValue, dispAcValue, dispBgFlexTransitValue);
                            }
                        } else {
                            dispAcValue = sumAcValue.compareTo(BgControlConstants.ZERO) < 0 ? leftSmallBracket + this.getFloatFormater().format(sumAcValue) + rightSmallBracket : this.getFloatFormater().format(sumAcValue);
                            this.addAmountText(amountStr, dispFlexValue, dispAcValue, dispBgFlexTransitValue);
                        }
                        sumBgValue = new BigDecimal(BigInteger.ZERO);
                        sumAcValue = new BigDecimal(BigInteger.ZERO);
                        sumBgTransitValue = new BigDecimal(BigInteger.ZERO);
                        sumBgFlexTransitValue = new BigDecimal(BigInteger.ZERO);
                        sumBgValue_addup.clear();
                        sumAcValue_addup.clear();
                        sumBgTransitValue_addup.clear();
                        sumBgFlexTransitValue_addup.clear();
                        if (!querySet.contains(displayBgIndex)) {
                            querySet.add(displayBgIndex);
                            bgIndexStr.append(add + displayBgIndex);
                        }
                        ++index;
                    }
                    lastDimNum = bgGroupData.getBgDimNumber();
                    pre_groupDataFlex = bgGroupData.getSetting().getFlexParam();
                    bgValue = bgGroupData.getBudgetValue();
                    acValue = bgGroupData.getActualValue();
                    bgTransitValue = bgGroupData.getTransitBudgetValue();
                    bgFlexTransitValue = bgGroupData.getTransitBudgetValue().multiply(pre_groupDataFlex);
                    dispBgTransitValue = bgTransitValue != null ? this.getFloatFormater().format(bgTransitValue) : null;
                    dispBgFlexTransitValue = bgFlexTransitValue != null ? this.getFloatFormater().format(bgFlexTransitValue) : null;
                    dispBgValue = bgValue != null ? this.getFloatFormater().format(bgValue) : null;
                    dispAcValue = acValue != null ? this.getFloatFormater().format(acValue) : null;
                    displayFlex = this.getFloatFormater().format(bgGroupData.getSetting().getFlexParam());
                    if (bgValue != null) {
                        sumBgValue = sumBgValue.add(bgValue);
                    }
                    if (acValue != null) {
                        sumAcValue = sumAcValue.add(acValue);
                    }
                    if (bgTransitValue != null) {
                        sumBgTransitValue = sumBgTransitValue.add(bgTransitValue);
                    }
                    if (bgFlexTransitValue != null) {
                        sumBgFlexTransitValue = sumBgFlexTransitValue.add(bgFlexTransitValue);
                    }
                    if (controlParam.isAddupCtrl()) {
                        for (String addPeriod : controlParam.getHasActualPeriods()) {
                            if (!controlParam.checkIsInPeriodForAddCtrl(bgGroupData.getBgPeriodNumber(), addPeriod)) continue;
                            if (bgValue != null) {
                                sumBgValue_addup.put(addPeriod, BgNFSHelper.addBigDecimal((BigDecimal)((BigDecimal)sumBgValue_addup.get(addPeriod)), (BigDecimal)bgValue));
                            }
                            if (bgTransitValue != null) {
                                sumBgTransitValue_addup.put(addPeriod, BgNFSHelper.addBigDecimal((BigDecimal)((BigDecimal)sumBgTransitValue_addup.get(addPeriod)), (BigDecimal)bgTransitValue));
                                sumBgFlexTransitValue_addup.put(addPeriod, BgNFSHelper.addBigDecimal((BigDecimal)((BigDecimal)sumBgFlexTransitValue_addup.get(addPeriod)), (BigDecimal)bgFlexTransitValue));
                            }
                            if (acValue == null) continue;
                            sumAcValue_addup.put(addPeriod, BgNFSHelper.addBigDecimal((BigDecimal)((BigDecimal)sumAcValue_addup.get(addPeriod)), (BigDecimal)acValue));
                        }
                    }
                    bgDimNumber = bgGroupData.getBgDimNumber();
                    bgDimName = (String)map.get(bgDimNumber);
                    tmpNums = bgDimNumber.split(",");
                    bgIndexNumber = tmpNums[0];
                    tmpNames = bgDimName.split(",");
                    bgIndexName = tmpNames[0];
                    displayBgIndex = this.getCellHelper().getIndexDisplayName(accountViewId, bgIndexNumber, bgIndexName);
                    displayExtMember = this.getExtName(tmpNums, tmpNames);
                    IRow row = this.tblMain.addRow();
                    row.getCell("dimCombine").setValue((Object)displayBgIndex);
                    row.getCell("members").setValue((Object)displayExtMember);
                    row.getCell("period").setValue((Object)bgGroupData.getBgPeriodNumber());
                    row.getCell("bgVal").setValue((Object)dispBgValue);
                    if (!this.getFloatFormater().format(BigDecimal.ZERO).equals(dispBgTransitValue)) {
                        row.getCell(COL_TRANSITVALUE).setValue((Object)dispBgTransitValue);
                    }
                    if (!this.getFloatFormater().format(BigDecimal.ZERO).equals(dispBgFlexTransitValue)) {
                        row.getCell(COL_COETRANSITVALUE).setValue((Object)dispBgFlexTransitValue);
                    }
                    row.getCell("coe").setValue((Object)displayFlex);
                    row.getCell("actVal").setValue((Object)dispAcValue);
                    rows.add(row);
                }
                if (bl && amountStr.toString().endsWith(add)) {
                    amountStr = new StringBuffer(amountStr.substring(0, amountStr.length() - 1));
                }
                if (!bl) {
                    if (!querySet.contains(displayBgIndex)) {
                        querySet.add(displayBgIndex);
                        bgIndexStr.append(add + displayBgIndex);
                    }
                    flexBgValue = bgGroupData != null ? sumBgValue.multiply(bgGroupData.getSetting().getFlexParam()) : sumBgValue;
                    dispFlexValue = this.getFloatFormater().format(flexBgValue);
                    dispBgFlexTransitValue = this.getFloatFormater().format(sumBgFlexTransitValue);
                    this.addSumRow(this.tblMain, sumBgValue, flexBgValue, sumAcValue, sumBgTransitValue, sumBgFlexTransitValue);
                    if (controlParam.isAddupCtrl()) {
                        for (String addPeriod : controlParam.getHasActualPeriods()) {
                            StringBuffer _amountStr = (StringBuffer)amountStr_addup.get(addPeriod);
                            if (_amountStr == null) {
                                _amountStr = new StringBuffer();
                                amountStr_addup.put(addPeriod, _amountStr);
                            }
                            if (_amountStr.length() > 0) {
                                _amountStr.append(add);
                            }
                            if (!sumBgValue_addup.containsKey(addPeriod)) {
                                sumBgValue_addup.put(addPeriod, BgControlConstants.ZERO);
                            }
                            if (!sumBgTransitValue_addup.containsKey(addPeriod)) {
                                sumBgTransitValue_addup.put(addPeriod, BgControlConstants.ZERO);
                            }
                            flexBgValue = bgGroupData != null ? ((BigDecimal)sumBgValue_addup.get(addPeriod)).multiply(bgGroupData.getSetting().getFlexParam()) : (BigDecimal)sumBgValue_addup.get(addPeriod);
                            flexBgTransitValue = bgGroupData != null ? ((BigDecimal)sumBgTransitValue_addup.get(addPeriod)).multiply(bgGroupData.getSetting().getFlexParam()) : (BigDecimal)sumBgTransitValue_addup.get(addPeriod);
                            dispBgFlexTransitValue = this.getFloatFormater().format(flexBgTransitValue);
                            dispFlexValue = this.getFloatFormater().format(flexBgValue);
                            dispAcValue = sumAcValue_addup.get(addPeriod) == null ? this.getFloatFormater().format(BgControlConstants.ZERO) : (((BigDecimal)sumAcValue_addup.get(addPeriod)).compareTo(BgControlConstants.ZERO) < 0 ? leftSmallBracket + this.getFloatFormater().format(sumAcValue_addup.get(addPeriod)) + rightSmallBracket : this.getFloatFormater().format(sumAcValue_addup.get(addPeriod)));
                            this.addAmountText(_amountStr, dispFlexValue, dispAcValue, dispBgFlexTransitValue);
                        }
                    } else {
                        dispAcValue = sumAcValue.compareTo(BgControlConstants.ZERO) < 0 ? leftSmallBracket + this.getFloatFormater().format(sumAcValue) + rightSmallBracket : this.getFloatFormater().format(sumAcValue);
                        this.addAmountText(amountStr, dispFlexValue, dispAcValue, dispBgFlexTransitValue);
                    }
                }
            }
        }
        this.tblMain.getGroupManager().group();
        this.tblMain.setRefresh(true);
        text.append("\r\n");
        if (controlParam.isAddupCtrl()) {
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(new SelectorItemCollection());
            view.getSelector().add("number");
            view.getSelector().add("name");
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("number", controlParam.getHasActualPeriods(), CompareType.INCLUDE));
            BgPeriodCollection col = BgPeriodFactory.getRemoteInstance().getBgPeriodCollection(view);
            Map periodMap = BgCommHelper.transeToMap((IObjectCollection)col, (String[])new String[]{"number"});
            boolean isFirst = true;
            ArrayList<String> periods = new ArrayList<String>(controlParam.getHasActualPeriods());
            Collections.sort(periods);
            for (String addPeriod : periods) {
                if (!isFirst) {
                    text.append("\r\n");
                }
                isFirst = false;
                if (controlParam.getBgPeriodNumber().equals(addPeriod)) {
                    text.append(bgIndexStr).append("  ").append(BgCommCHelper.getMessageStr((String)BgControlConstants.CONTROL_SOURCE, (String)"addupCtrlCurrPeriod"));
                } else {
                    text.append(bgIndexStr).append("  ").append(BgCommCHelper.getMessageStr((String)BgControlConstants.CONTROL_SOURCE, (String)"addupCtrlActualPeriod", (Object[])new String[]{((BgPeriodInfo)periodMap.get(addPeriod)).getName()}));
                }
                text.append("\r\n");
                amountStr = (StringBuffer)amountStr_addup.get(addPeriod);
                text.append(equal).append(amountStr);
                if (rows.size() <= 1 && amountStr.indexOf(subtract) <= 0 && amountStr.indexOf(add) <= 0) continue;
                text.append("\r\n");
                BigDecimal calcVale = BgNFSHelper.calcStr((String)amountStr.toString());
                if (calcVale != null && controlParam.getAddupBalance().get(addPeriod) != calcVale) {
                    text.append(equal).append(this.getFloatFormater().format(calcVale));
                    continue;
                }
                text.append(equal).append(this.getFloatFormater().format(controlParam.getAddupBalance().get(addPeriod) == null ? BgNConstants.ZERO : controlParam.getAddupBalance().get(addPeriod)));
            }
        } else if (rows.size() > 1 || amountStr.indexOf(subtract) > 0 || amountStr.indexOf(add) > 0) {
            text.append(equal).append(bgIndexStr);
            text.append("\r\n");
            text.append(equal).append(amountStr);
            text.append("\r\n");
            text.append(equal).append(this.getFloatFormater().format(controlParam.getExtBalance() != null ? controlParam.getExtBalance() : controlParam.getOrignBalance()));
        }
        this.formula.setText(text.toString());
    }

    private IRow addSumRow(KDTable table, BigDecimal sumBgValue, BigDecimal flexBgValue, BigDecimal sumAcValue, BigDecimal sumBgTransitValue, BigDecimal sumBgFlexTransitValue) {
        if (table == null || sumBgValue == null || sumAcValue == null) {
            return null;
        }
        IRow sumRow = table.addRow();
        sumRow.getStyleAttributes().setBackground(BgNConstants.LITILE_SUM_COROR);
        sumRow.getCell("dimCombine").setValue((Object)BgCommCHelper.getMessageStr((String)BgControlConstants.CONTROL_SOURCE, (String)"subtotal"));
        sumRow.getCell("dimCombine").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        sumRow.getCell("members").setValue(null);
        sumRow.getCell("period").setValue(null);
        if (sumBgValue.compareTo(BgControlConstants.ZERO) != 0) {
            sumRow.getCell("bgVal").setValue((Object)this.getFloatFormater().format(sumBgValue));
        }
        if (sumBgTransitValue.compareTo(BgControlConstants.ZERO) != 0) {
            sumRow.getCell(COL_TRANSITVALUE).setValue((Object)this.getFloatFormater().format(sumBgTransitValue));
        }
        if (sumBgFlexTransitValue.compareTo(BgControlConstants.ZERO) != 0) {
            sumRow.getCell(COL_COETRANSITVALUE).setValue((Object)this.getFloatFormater().format(sumBgFlexTransitValue));
        }
        if (flexBgValue != null) {
            sumRow.getCell("coe").setValue((Object)this.getFloatFormater().format(flexBgValue));
        } else {
            sumRow.getCell("coe").setValue((Object)subtract);
        }
        if (sumAcValue.compareTo(BgControlConstants.ZERO) != 0) {
            sumRow.getCell("actVal").setValue((Object)this.getFloatFormater().format(sumAcValue));
        }
        table.getMergeManager().mergeBlock(sumRow.getRowIndex(), 0, sumRow.getRowIndex(), 2);
        return sumRow;
    }

    private String getExtName(BgControlParam param) {
        if (param == null) {
            return null;
        }
        if (param.getControlSetting().getBgDimName() != null) {
            return param.getControlSetting().getBgDimName();
        }
        String dimNumber = param.getDimItemNumber();
        String dimName = param.getDimItemName();
        StringBuffer extName = new StringBuffer();
        String[] dimNums = dimNumber.split(",");
        String[] dimNames = dimName.split(",");
        int in = dimNums.length;
        for (int i = 0; i < in; ++i) {
            if (dimNums[i].equals(param.getBgIndexNumber()) || dimNums[i].equals(param.getBgIndexNumber())) continue;
            if (dimNums[i].contains(":")) {
                extName.append(dimNums[i].substring(dimNums[i].indexOf(":") + 1, dimNums[i].length()) + leftSmallBracket + dimNames[i] + "),");
                continue;
            }
            extName.append(dimNums[i] + leftSmallBracket + dimNames[i] + "),");
        }
        if (extName.length() > 0) {
            extName = extName.delete(extName.length() - 1, extName.length());
        }
        return extName.toString();
    }

    private String getExtName(String[] bgDimNums, String[] dimNames) {
        if (bgDimNums == null || bgDimNums.length <= 1) {
            return null;
        }
        StringBuffer extName = new StringBuffer();
        int in = bgDimNums.length;
        for (int i = 1; i < in; ++i) {
            if (bgDimNums[i].contains(":")) {
                extName.append(bgDimNums[i].substring(bgDimNums[i].indexOf(":") + 1, bgDimNums[i].length()) + leftSmallBracket + dimNames[i] + "),");
                continue;
            }
            extName.append(bgDimNums[i] + leftSmallBracket + dimNames[i] + "),");
        }
        if (extName.length() > 0) {
            extName = extName.delete(extName.length() - 1, extName.length());
        }
        return extName.toString();
    }

    private void addAmountText(StringBuffer text, String dispBgValue, String dispAcValue, String dispBgFlexTransitValue) {
        if (dispBgValue != null) {
            if (text.length() > 0 && !add.equals(String.valueOf(text.charAt(text.length() - 1)))) {
                text.append(add);
            }
            if (dispAcValue != null) {
                if (this.isLoadTransitBudget && dispBgFlexTransitValue != null) {
                    text.append(leftSmallBracket + dispBgValue + subtract + dispBgFlexTransitValue + subtract + dispAcValue + rightSmallBracket);
                } else {
                    text.append(leftSmallBracket + dispBgValue + subtract + dispAcValue + rightSmallBracket);
                }
            } else {
                text.append(dispBgValue);
            }
        } else {
            text.append(subtract + dispAcValue);
        }
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }
}

