/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.TextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectSingleKey;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.IBgPeriod;
import com.kingdee.eas.ma.base.utils.BgAdjustPastDataInfo;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgParamCHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodDispHelper;
import com.kingdee.eas.ma.control.BgControlFacadeFactory;
import com.kingdee.eas.ma.control.BgControlIsomerFacadeFactory;
import com.kingdee.eas.ma.control.BgControlSettingInfo;
import com.kingdee.eas.ma.control.BgGetPeriodTypeForGetBlanceEnum;
import com.kingdee.eas.ma.control.client.AbstractMbgBalanceUI;
import com.kingdee.eas.ma.control.client.BgCurrencyMappingDetailUI;
import com.kingdee.eas.ma.control.client.BgCurrencyMappingMultiDetailUI;
import com.kingdee.eas.ma.control.client.MbgActualDetailUI;
import com.kingdee.eas.ma.control.client.MbgAvlBalDetailUI;
import com.kingdee.eas.ma.control.client.MbgExpandDetialUI;
import com.kingdee.eas.ma.control.face.IBudgetBalance;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.control.impl.models.BgGroupData;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.ma.control.utils.BgControlTransitUtils;
import com.kingdee.eas.ma.control.utils.BgControlUtils;
import com.kingdee.eas.ma.mbg.BgAdjustFacadaFactory;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgSchemeTypeInfo;
import com.kingdee.eas.ma.mbg.client.BgTransitBudgetDetailViewUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.utils.BgCellRenderHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;
import org.apache.log4j.Logger;

public class MbgBalanceUI
extends AbstractMbgBalanceUI {
    private static final long serialVersionUID = -6519465686116993636L;
    private static final Logger logger = CoreUIObject.getLogger(MbgBalanceUI.class);
    protected static final String COL_ORGUNIT = "orgUnit";
    protected static final String COL_SCHEME = "scheme";
    protected static final String COL_INDEX = "index";
    protected static final String COL_MEMBER = "member";
    protected static final String COL_BGPERIOD = "bgPeriod";
    protected static final String COL_CURRENCY = "bgCurrency";
    protected static final String COL_BGELEMENT = "bgElement";
    protected static final String COL_BGSCENARIO = "bgScenario";
    protected static final String COL_ACSCENARIO = "acScenario";
    protected static final String COL_TYPE = "type";
    protected static final String COL_BUDGET = "budget";
    protected static final String COL_TRANSIT_BUDGET = "transitBudget";
    protected static final String COL_ACTUAL = "actual";
    protected static final String COL_APPLY = "apply";
    protected static final String COL_BALANCE = "balance";
    protected static final String COL_BGPERIODTYPE = "bgPeriodType";
    private boolean isLoadTransitBudget;
    private BgCellRenderHelper cellHelper = new BgCellRenderHelper();

    public BgCellRenderHelper getCellHelper() {
        return this.cellHelper;
    }

    public void onLoad() throws Exception {
        this.isLoadTransitBudget = BgParamCHelper.isLoadTransitBudget();
        super.onLoad();
        this.getCellHelper().init();
        this.initOrgCellStyle();
        this.showBalance();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblMain.getSelectManager().select(0, 0);
        this.tblMain.getColumn(COL_TRANSIT_BUDGET).getStyleAttributes().setHided(!this.isLoadTransitBudget);
        if (this.getUIWindow() instanceof KDDialog) {
            ((KDDialog)this.getUIWindow()).setResizable(true);
        }
    }

    protected void showBalance() throws EASBizException, BOSException {
        IBudgetBalance balance = this.queryBalance();
        Map<String, Map<String, String>> combinNames = this.queryCombinNames(balance);
        this.fillData(balance, combinNames);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getMergeManager().setMergeMode(5);
    }

    private void initOrgCellStyle() {
        this.tblMain.getColumn(COL_ORGUNIT).setRenderer(new IBasicRender(){

            /*
             * Enabled aggressive block sorting
             */
            public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
                if (object == null) return;
                if (!(object instanceof OrgUnitInfo)) return;
                OrgUnitInfo info = (OrgUnitInfo)object;
                String number = StringUtils.cnulls((String)info.getNumber());
                String name = StringUtils.cnulls((String)info.getName());
                String longName = StringUtils.cnulls((String)info.getDisplayName());
                if (MbgBalanceUI.this.getCellHelper().getBgOrgUnitNameStyle() != null) {
                    String string = MbgBalanceUI.this.getCellHelper().getBgOrgUnitNameStyle();
                    MbgBalanceUI.this.getCellHelper();
                    if (string.equals("1")) {
                        TextRender.sharedInstance().draw(graphics, clip, name, cellStyle);
                        return;
                    }
                }
                if (MbgBalanceUI.this.getCellHelper().getBgOrgUnitNameStyle() != null) {
                    String string = MbgBalanceUI.this.getCellHelper().getBgOrgUnitNameStyle();
                    MbgBalanceUI.this.getCellHelper();
                    if (string.equals("0")) {
                        TextRender.sharedInstance().draw(graphics, clip, number + "(" + name + ")", cellStyle);
                        return;
                    }
                }
                if (StringUtils.isEmpty((String)longName)) {
                    TextRender.sharedInstance().draw(graphics, clip, name, cellStyle);
                    return;
                }
                TextRender.sharedInstance().draw(graphics, clip, longName, cellStyle);
            }
        });
    }

    protected void fillData(IBudgetBalance balance, Map<String, Map<String, String>> combinNames) throws BOSException {
        this.tblMain.removeRows();
        if (balance == null || balance.getBalance().isEmpty() || combinNames == null) {
            this.setNoCurrencyMapping(false, false);
            this.setNoExpand();
            return;
        }
        boolean isZero = BgParamCHelper.isZeroIsNull();
        HashMap<String, String> companyMap = new HashMap<String, String>();
        String orgUnitId = null;
        String companyId = null;
        String bgSchemeId = null;
        BgControlParam param = null;
        IRow row = null;
        boolean hasExpand = false;
        boolean hasCurrencyMapping = false;
        for (int i = 0; i < balance.getBalance().size(); ++i) {
            param = balance.getBalance().get(i);
            if (!param.getNoMembers().isEmpty() || param.getOrgUnit() == null) continue;
            if (param.getBgPeriodGroup().isEmpty()) {
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"bgPeriodTypeNull"));
                SysUtil.abort();
            }
            int precision = 2;
            if (param.getCurrency() != null) {
                precision = param.getCurrency().getPrecision();
            }
            if (param.getExpandInfo() != null) {
                hasExpand = true;
            }
            if (!param.getCurrencyMappings().isEmpty()) {
                hasCurrencyMapping = true;
            }
            String numberFormat = BgNationalFormatUIUtil.getFormatStringForTable((int)precision);
            bgSchemeId = param.getBgSchemeInfo().getId().toString();
            DecimalFormat bigDecimalFormula = BgNationalFormatUIUtil.getDecimalFormat((int)precision);
            row = this.tblMain.addRow();
            row.getCell(COL_BUDGET).getStyleAttributes().setNumberFormat(numberFormat);
            row.getCell(COL_TRANSIT_BUDGET).getStyleAttributes().setNumberFormat(numberFormat);
            row.getCell(COL_ACTUAL).getStyleAttributes().setNumberFormat(numberFormat);
            row.getCell(COL_APPLY).getStyleAttributes().setNumberFormat(numberFormat);
            row.getCell(COL_BALANCE).getStyleAttributes().setNumberFormat(numberFormat);
            this.setControlSettingColor(param, row);
            row.setUserObject((Object)param);
            row.getCell(COL_ORGUNIT).setValue((Object)param.getOrgUnit());
            row.getCell(COL_SCHEME).setValue((Object)param.getBgSchemeInfo().getName());
            String bgIndexNumber = param.getBgIndexNumber();
            String indexName = BgControlParam.getName(bgSchemeId, combinNames, bgIndexNumber, param);
            orgUnitId = param.getOrgUnit().getId().toString();
            companyId = this.getCompanyId(companyMap, orgUnitId);
            String accountViewId = BgCellRenderHelper.getAccountViewIdByBgScheme((BgSchemeInfo)param.getBgSchemeInfo());
            if (accountViewId != null) {
                row.getCell(COL_INDEX).setValue((Object)this.getCellHelper().getIndexDisplayName(accountViewId, bgIndexNumber, indexName));
            } else {
                row.getCell(COL_INDEX).setValue((Object)(bgIndexNumber + "(" + indexName + ")"));
            }
            BgDimensionMember bgIndex = new BgDimensionMember(null, "F2", indexName, bgIndexNumber.split(":")[1]);
            String srcNumber = bgIndexNumber.split(":")[0];
            bgIndex.setSrcNumber(srcNumber);
            row.getCell(COL_INDEX).setUserObject((Object)bgIndex);
            String[] dimNums = param.getDimItemNumber().split(",");
            StringBuilder dimItemNames = new StringBuilder();
            int jn = dimNums.length;
            for (int j = 0; j < jn; ++j) {
                String dimItemName = BgControlParam.getName(bgSchemeId, combinNames, dimNums[j], param);
                dimItemNames.append(dimItemName).append(",");
            }
            dimItemNames.delete(dimItemNames.lastIndexOf(","), dimItemNames.length());
            param.setDimItemName(dimItemNames.toString());
            String extName = BgControlParam.getExtName(bgSchemeId, combinNames, param);
            if (param.getControlSetting().getBgDimName() != null && !StringUtils.isEmpty((String)extName)) {
                String extNumber = BgControlParam.getExtNumber(param);
                extName = MbgBalanceUI.getExtName(extNumber, extName);
            }
            String extRefField = BgControlParam.getExtRefField(param);
            String extNumber = BgControlParam.getExtNumber(param);
            if (!StringUtils.isEmpty((String)extNumber)) {
                String[] numbers = extNumber.split(",");
                StringBuilder srcnumbers = new StringBuilder();
                StringBuilder elementNumbers = new StringBuilder();
                for (int j = 0; j < numbers.length; ++j) {
                    String[] split = numbers[j].split(":");
                    if (split.length != 2) {
                        return;
                    }
                    srcnumbers.append(split[0]).append(",");
                    elementNumbers.append(split[1]).append(",");
                }
                String memberSrcNumber = srcnumbers.deleteCharAt(srcnumbers.lastIndexOf(",")).toString();
                String memberNumbers = elementNumbers.deleteCharAt(elementNumbers.lastIndexOf(",")).toString();
                BgDimensionMember combinNumbers = new BgDimensionMember(null, extRefField, extName, memberNumbers);
                combinNumbers.setSrcNumber(memberSrcNumber);
                if (param.getControlSetting().getBgDimName() != null && !StringUtils.isEmpty((String)extName)) {
                    row.getCell(COL_MEMBER).setValue((Object)extName);
                } else {
                    row.getCell(COL_MEMBER).setValue((Object)MbgBalanceUI.getExtName(extNumber, extName));
                }
                row.getCell(COL_MEMBER).setUserObject((Object)combinNumbers);
            }
            if (param.getCurrency() != null) {
                row.getCell(COL_CURRENCY).setValue((Object)this.displayNameAndNumber((DataBaseInfo)param.getCurrency()));
            }
            row.getCell(COL_BGPERIODTYPE).setValue((Object)param.getBgPeriodGroup().getName());
            row.getCell(COL_BGPERIOD).setValue((Object)param.getBgPeriodName());
            row.getCell(COL_BGELEMENT).setValue((Object)this.displayNameAndNumber((DataBaseInfo)param.getBgElement()));
            row.getCell(COL_BGSCENARIO).setValue((Object)this.displayNameAndNumber((DataBaseInfo)param.getBgScenario()));
            row.getCell(COL_ACSCENARIO).setValue((Object)this.displayNameAndNumber((DataBaseInfo)param.getAcScenario()));
            row.getCell(COL_TYPE).setValue((Object)param.getControlSetting().getCtrlType());
            BigDecimal displayBudget = BgControlUtils.getBudgetValue(param);
            if (displayBudget != null && isZero && displayBudget.compareTo(BigDecimal.ZERO) == 0) {
                displayBudget = null;
            }
            row.getCell(COL_BUDGET).setValue((Object)displayBudget);
            row.getCell(COL_TRANSIT_BUDGET).setValue((Object)BgControlUtils.getTransitBudgetValue(param));
            row.getCell(COL_ACTUAL).setValue((Object)BgControlUtils.getActualValue(param));
            row.getCell(COL_APPLY).setValue((Object)BgControlUtils.getRequestValue(param));
            if (this.checkRow(row)) {
                if (param.getExpandInfo() != null) {
                    if (param.getBalance() == null) {
                        row.getCell(COL_BALANCE).setValue(null);
                        continue;
                    }
                    row.getCell(COL_BALANCE).setValue((Object)((Object)((Object)param.getExpandInfo().getBgReqRule()) + " " + bigDecimalFormula.format(param.getBalance())));
                    continue;
                }
                if (param.getExtBalance() != null) {
                    row.getCell(COL_BALANCE).setValue((Object)param.getExtBalance());
                    continue;
                }
                row.getCell(COL_BALANCE).setValue((Object)param.getBalance());
                continue;
            }
            this.tblMain.removeRow(row.getRowIndex());
        }
        this.setNoCurrencyMapping(hasExpand, hasCurrencyMapping);
        if (!hasExpand) {
            this.setNoExpand();
        }
    }

    private String displayNameAndNumber(DataBaseInfo baseInfo) {
        if (baseInfo == null) {
            return "";
        }
        StringBuilder showName = new StringBuilder();
        showName.append(baseInfo.getName()).append("(").append(baseInfo.getNumber()).append(")");
        return showName.toString();
    }

    protected void setControlSettingColor(BgControlParam param, IRow row) {
        if (param.getControlSetting() != null && param.getControlSetting().getCtrlType() != null && param.getControlSetting().getCtrlType().getValue() == -1) {
            row.getStyleAttributes().setBackground(Color.GRAY);
        }
    }

    protected void setNoExpand() {
        if (this.btnActualDetail.getBounds().equals(this.btnShowExpand.getBounds())) {
            return;
        }
        this.btnShowExpand.setVisible(false);
        this.exchangeLocation(this.btnActualDetail, this.btnShowExpand);
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblMain.checkParsed();
        this.tblMain.getColumn(COL_TRANSIT_BUDGET).getStyleAttributes().setHided(!this.isLoadTransitBudget);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnTransitBudgetDetail.setVisible(this.isLoadTransitBudget);
    }

    private boolean checkRow(IRow row) {
        return true;
    }

    private String getCompanyId(Map<String, String> companyMap, String orgUnitId) {
        String companyId = null;
        if (companyMap.containsKey(orgUnitId)) {
            companyId = companyMap.get(orgUnitId);
        } else {
            try {
                CompanyOrgUnitInfo company = BgNFCHelper.getCompanyByOrgUnit((BOSUuid)BOSUuid.read((String)orgUnitId));
                if (company != null) {
                    companyId = company.getId().toString();
                    companyMap.put(orgUnitId, companyId);
                }
            }
            catch (Exception ex) {
                this.handUIExceptionAndAbort(ex);
            }
        }
        return companyId;
    }

    protected IBudgetBalance queryBalance() throws BOSException, EASBizException {
        IBudgetBalance balance = null;
        if (this.getUIContext().get("InitDataObject") instanceof IObjectValue) {
            balance = BgControlFacadeFactory.getRemoteInstance().queryBalance((IObjectValue)this.getUIContext().get("InitDataObject"));
        } else if (this.getUIContext().get("ID") != null) {
            balance = BgControlFacadeFactory.getRemoteInstance().queryBalance(BOSUuid.read((String)String.valueOf(this.getUIContext().get("ID"))));
        } else if (this.getUIContext().get("billNumber") != null && this.getUIContext().get("isomerID") != null) {
            balance = (IBudgetBalance)BgControlIsomerFacadeFactory.getRemoteInstance().bgControlToGuiHandle(String.valueOf(this.getUIContext().get("billNumber")), String.valueOf(this.getUIContext().get("isomerID")), 2);
        }
        return balance;
    }

    protected Map<String, Map<String, String>> queryCombinNames(IBudgetBalance balance) throws BOSException, EASBizException {
        return DimensionFormulaHelper.queryCombinNames(null, (IBudgetBalance)balance, (boolean)false);
    }

    @Override
    public void actionShowDetail_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.getSelectActiveRow();
        if (row == null) {
            return;
        }
        BgControlParam param = (BgControlParam)row.getUserObject();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put(BgControlParam.class, (Object)param);
        uiContext.put((Object)"isLoadTransitBudget", (Object)BgParamCHelper.isLoadTransitBudget());
        uiContext.put((Object)"isCtrl", (Object)Boolean.TRUE);
        uiContext.put((Object)"balTypeEnum", (Object)BgGetPeriodTypeForGetBlanceEnum.Is_Control);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MbgAvlBalDetailUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        if (uiWindow instanceof JDialog) {
            ((JDialog)uiWindow).setResizable(true);
        }
        uiWindow.show();
    }

    private IRow getSelectActiveRow() {
        if (this.tblMain.getRowCount() <= 0) {
            return null;
        }
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BUDGETAutoGenerateResource", (String)"128_BgBalanceViewUI"));
            SysUtil.abort();
        }
        IRow row = this.tblMain.getRow(rowIndex);
        return row;
    }

    @Override
    public void actionActualDetail_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.getSelectActiveRow();
        if (null == row) {
            return;
        }
        BgControlParam param = (BgControlParam)row.getUserObject();
        BgSchemeTypeInfo bgSchemeType = param.getBgSchemeType();
        if (bgSchemeType == null || bgSchemeType.getSchemeType() == null) {
            String _msg = EASResource.getString((String)BgControlConstants.CONTROL_RES, (String)"noCtrlSchemeOrType");
            MsgBox.showWarning((Component)((Object)this), (String)_msg);
            SysUtil.abort();
        }
        Object index = row.getCell(COL_INDEX).getUserObject();
        Object member = row.getCell(COL_MEMBER).getUserObject();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put(BgControlParam.class, (Object)param);
        uiContext.put((Object)COL_INDEX, index);
        uiContext.put((Object)COL_MEMBER, member);
        uiContext.put((Object)"isShowAllTotal", (Object)true);
        String orgId = SysContext.getSysContext().getCurrentCostUnit().getId().toString();
        String name = SysContext.getSysContext().getCurrentOrgUnit().getName();
        if (param.getOrgUnit() != null) {
            orgId = param.getOrgUnit().getId().toString();
            name = param.getOrgUnit().getName().toString();
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getActualDetailUIBySchemeType(orgId, name, bgSchemeType), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionTransitBudgetDetail_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.getSelectActiveRow();
        if (null == row) {
            return;
        }
        BgControlParam param = (BgControlParam)row.getUserObject();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"processType", (Object)BgProcessEnum.C01);
        BgSchemeInfo scheme = param.getBgSchemeInfo();
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(scheme.getId().toString());
        uiContext.put((Object)"schemeHelper", (Object)schemeHelper);
        uiContext.put((Object)"data", this.getTransitBudgetDetailData(param));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgTransitBudgetDetailViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private List<BgAdjustPastDataInfo> getTransitBudgetDetailData(BgControlParam bgControlParam) throws BOSException, EASBizException {
        if (bgControlParam == null || bgControlParam.getBgSchemeInfo() == null) {
            return null;
        }
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(bgControlParam.getBgSchemeInfo().getId().toString());
        OrgUnitInfo orgUnit = bgControlParam.getOrgUnit();
        LinkedHashSet<String> queryCombins = new LinkedHashSet<String>();
        queryCombins.add(bgControlParam.getDimItemNumber());
        HashSet<String> detailSet = new HashSet<String>();
        String[] tmpStrs = null;
        detailSet.addAll(bgControlParam.getBudgetDetail().keySet());
        detailSet.addAll(bgControlParam.getActualDetail().keySet());
        for (String string : detailSet) {
            tmpStrs = string.split("!");
            queryCombins.add(tmpStrs[0]);
        }
        if (bgControlParam.getBgGroupMap() != null) {
            for (List list : bgControlParam.getBgGroupMap().values()) {
                for (BgGroupData groupData : list) {
                    queryCombins.add(groupData.getBgDimNumber());
                }
            }
        }
        Set<String> periodNumbers = this.obtainPeriods(bgControlParam);
        BgScenarioInfo bgScenarioInfo = bgControlParam.getBgScenario();
        CurrencyInfo currency = bgControlParam.getCurrency();
        BgElementInfo bgElement = bgControlParam.getBgElement();
        HashSet<String> formulas = new HashSet<String>();
        for (String bgPeriodNumber : periodNumbers) {
            for (String dimItemNumber : queryCombins) {
                formulas.add(BgNFSHelper.getFormulaFromParam((String)dimItemNumber, (String)bgPeriodNumber, (String)bgElement.getNumber(), (String)currency.getNumber(), (String)bgScenarioInfo.getNumber()));
            }
        }
        return BgAdjustFacadaFactory.getRemoteInstance().transitDataView(formulas, orgUnit, bgControlParam.getVersion(), schemeHelper);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set<String> obtainPeriods(BgControlParam bgControlParam) throws BOSException, EASBizException {
        HashSet<String> periodNumbers = new HashSet<String>();
        BgPeriodInfo bgPeriod = null;
        Date beginDate = null;
        Date endDate = null;
        IBgPeriod iBgPeriod = BgPeriodFactory.getRemoteInstance();
        BgControlSettingInfo setting = bgControlParam.getControlSetting();
        if (setting != null) {
            BgSchemeInfo bgScheme;
            int ctrlType = setting.getCtrlType().getValue();
            bgPeriod = iBgPeriod.getBgPeriodInfo((IObjectPK)new ObjectSingleKey((Object)bgControlParam.getBgPeriodId()));
            BgPeriodTypeInfo bgPeriodTypeInfo = BgPeriodDispHelper.getBgPeriodTypeInfo(null, (BOSUuid)bgControlParam.getBgPeriodGroup().getId());
            boolean onlySelfDefinedPeriod = BgNPeriodHelper.isOnlySelfDefinedPeriod((BgPeriodTypeInfo)bgPeriodTypeInfo);
            if (onlySelfDefinedPeriod) {
                bgScheme = bgControlParam.getBgSchemeInfo();
                if (-1 == ctrlType || 10 == ctrlType) {
                    beginDate = bgPeriod.getBeginDate();
                    endDate = bgPeriod.getEndDate();
                } else if (11 == ctrlType) {
                    beginDate = bgScheme.getDateFrom();
                    endDate = bgPeriod.getEndDate();
                } else {
                    beginDate = bgScheme.getDateFrom();
                    endDate = bgScheme.getDateTo();
                }
            } else if (-1 == ctrlType || 10 == ctrlType) {
                beginDate = bgPeriod.getBeginDate();
                endDate = bgPeriod.getEndDate();
            } else if (11 == ctrlType || 12 == ctrlType) {
                Date[] dates;
                bgScheme = bgControlParam.getBgSchemeInfo();
                int periodType = setting.getPeriodType().getValue();
                if (BgPeriodDispHelper.checkNoIn((int)bgPeriod.getPeriodTypeEnum().getValue(), (int)periodType)) {
                    beginDate = bgPeriod.getBeginDate();
                    endDate = bgPeriod.getEndDate();
                } else if (0 == periodType) {
                    Date bTime = bgControlParam.getControlSetting().getScheme().getBeginTime();
                    Date eTime = bgControlParam.getControlSetting().getScheme().getEndTime();
                    Date fTime = bgScheme.getDateFrom();
                    Date tTime = bgScheme.getDateTo();
                    if (bTime.getTime() >= tTime.getTime() || fTime.getTime() >= eTime.getTime()) {
                        if (bTime.getTime() == new Date().getTime()) {
                            beginDate = bTime;
                            endDate = bTime;
                        } else {
                            if (fTime.getTime() != eTime.getTime()) return periodNumbers;
                            beginDate = eTime;
                            endDate = eTime;
                        }
                    } else {
                        beginDate = bTime.getTime() >= fTime.getTime() ? bTime : fTime;
                        endDate = eTime.getTime() >= tTime.getTime() ? tTime : eTime;
                    }
                } else if (1 == periodType) {
                    dates = BgControlTransitUtils.getYearTime(bgControlParam.getBizDate());
                    beginDate = dates[0];
                    endDate = dates[1];
                } else if (2 == periodType) {
                    dates = BgControlTransitUtils.getHalfYearTime(bgControlParam.getBizDate());
                    beginDate = dates[0];
                    endDate = dates[1];
                } else if (3 == periodType) {
                    dates = BgControlTransitUtils.getQuarterTime(bgControlParam.getBizDate());
                    beginDate = dates[0];
                    endDate = dates[1];
                } else if (4 == periodType) {
                    dates = BgControlTransitUtils.getMonthTime(bgControlParam.getBizDate());
                    beginDate = dates[0];
                    endDate = dates[1];
                }
                if (beginDate != null && beginDate.compareTo(bgPeriod.getBeginDate()) > 0) {
                    beginDate = bgPeriod.getBeginDate();
                }
                if (beginDate != null && beginDate.compareTo(bgScheme.getDateFrom()) < 0) {
                    beginDate = bgScheme.getDateFrom();
                }
                if (endDate != null && endDate.compareTo(bgScheme.getDateTo()) > 0) {
                    endDate = bgScheme.getDateTo();
                }
            }
        } else {
            bgPeriod = iBgPeriod.getBgPeriodInfo((IObjectPK)new ObjectSingleKey((Object)bgControlParam.getBgPeriodId()));
            beginDate = bgPeriod.getBeginDate();
            endDate = bgPeriod.getEndDate();
        }
        BgPeriodCollection cols = BgPeriodDispHelper.getPeriodColls(null, (BOSUuid)bgControlParam.getBgPeriodGroup().getId(), null, (Date)beginDate, (Date)endDate);
        int in = cols.size();
        for (int i = 0; i < in; ++i) {
            BgPeriodInfo periodInfo = cols.get(i);
            periodNumbers.add(periodInfo.getNumber());
        }
        return periodNumbers;
    }

    @Override
    public void actionShowExpand_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        BgControlParam param;
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BUDGETAutoGenerateResource", (String)"128_BgBalanceViewUI"));
            SysUtil.abort();
        }
        if ((param = (BgControlParam)(row = this.tblMain.getRow(rowIndex)).getUserObject()).getExpandInfo() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CONTROL_RES, (String)"checkHasExpand"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put(BgControlParam.class, (Object)param);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MbgExpandDetialUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected boolean verifyPermission(String orgID, String permission) {
        boolean verifyPermission = false;
        if (orgID == null) {
            orgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        }
        try {
            verifyPermission = this.verifyPermission(SysContext.getSysContext().getCurrentUserInfo().getId().toString(), orgID, permission);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return verifyPermission;
    }

    protected boolean verifyPermission(String userId, String orgUnitId, String permission) throws Exception {
        if (StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)orgUnitId)) {
            return false;
        }
        return PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(orgUnitId), permission);
    }

    protected String getActualDetailUIBySchemeType(String orgID, String name, BgSchemeTypeInfo bgSchemeType) {
        switch (bgSchemeType.getSchemeType().getValue()) {
            case 68: {
                if (this.verifyPermission(orgID, "exp_adjustExe_list")) break;
                String _msg = MessageFormat.format(BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"exp_adjustExe_list"), name);
                MsgBox.showWarning((Component)((Object)this), (String)_msg);
                SysUtil.abort();
                break;
            }
            case 69: {
                if (this.verifyPermission(orgID, "mbg_exeAnalyse_listUI")) break;
                String _msg = MessageFormat.format(BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"mbg_exeAnalyse_listUI"), name);
                MsgBox.showWarning((Component)((Object)this), (String)_msg);
                SysUtil.abort();
                break;
            }
            case 67: {
                if (this.verifyPermission(orgID, "fm_adjustExe_list")) break;
                String _msg = MessageFormat.format(BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"fm_adjustExe_list"), name);
                MsgBox.showWarning((Component)((Object)this), (String)_msg);
                SysUtil.abort();
                break;
            }
            default: {
                if (this.verifyPermission(orgID, "exp_adjustExe_list") || this.verifyPermission(orgID, "mbg_exeAnalyse_listUI") || this.verifyPermission(orgID, "fm_adjustExe_list")) break;
                String _msg = MessageFormat.format(BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"null_adjustExe_list"), name);
                MsgBox.showWarning((Component)((Object)this), (String)_msg);
                SysUtil.abort();
            }
        }
        return MbgActualDetailUI.class.getName();
    }

    @Override
    protected void btnClose_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = (RequestContext)handler.getRequestContext();
            Object obj = this.getUIContext().get("InitDataObject");
            if (obj != null) {
                request.put("ANALYSEINFO", obj);
            } else {
                request.put("ANALYSEINFO", this.getUIContext().get("ID"));
            }
        }
        return handler;
    }

    public static String getExtName(String extNumber, String extName) {
        if (extName == null || extNumber == null) {
            return extName;
        }
        String[] dimNums = extNumber.split(",");
        String[] dimNames = extName.split(",");
        StringBuffer name = new StringBuffer();
        int in = dimNums.length;
        for (int i = 0; i < in; ++i) {
            String srcAndNumber = dimNums[i];
            String number = srcAndNumber.substring(srcAndNumber.indexOf(":") + 1);
            if (StringUtils.isEmpty((String)number)) continue;
            name.append(number).append("(").append(dimNames[i]).append(")").append(",");
        }
        if (name.length() <= 0) {
            return extName;
        }
        name = name.deleteCharAt(name.length() - 1);
        return name.toString();
    }

    @Override
    public void actionCurrencyMappingDetail_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        BgControlParam param;
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BUDGETAutoGenerateResource", (String)"128_BgBalanceViewUI"));
            SysUtil.abort();
        }
        if ((param = (BgControlParam)(row = this.tblMain.getRow(rowIndex)).getUserObject()).getCurrencyMappings().isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CONTROL_RES, (String)"checkCurrencyMapping"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put(BgControlParam.class, (Object)param);
        String detailUI = null;
        detailUI = !param.getCurrencyMappings().isEmpty() && param.getCurrencyMappings().size() > 1 ? BgCurrencyMappingMultiDetailUI.class.getName() : BgCurrencyMappingDetailUI.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(detailUI, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected void setNoCurrencyMapping(boolean hasExpand, boolean hasCurrencyMapping) {
        if (hasExpand) {
            if (hasCurrencyMapping) {
                this.btnCurrencyMappingDetail.setVisible(true);
            } else {
                this.btnCurrencyMappingDetail.setVisible(false);
                this.exchangeLocation(this.btnTransitBudgetDetail, this.btnCurrencyMappingDetail);
            }
        } else if (hasCurrencyMapping) {
            this.exchangeLocation(this.btnTransitBudgetDetail, this.btnCurrencyMappingDetail);
            this.btnCurrencyMappingDetail.setVisible(true);
            this.exchangeLocation(this.btnCurrencyMappingDetail, this.btnActualDetail);
        } else {
            this.btnCurrencyMappingDetail.setVisible(false);
            if (!this.btnActualDetail.getBounds().equals(this.btnShowExpand.getBounds())) {
                this.exchangeLocation(this.btnTransitBudgetDetail, this.btnActualDetail);
            }
        }
    }

    private void exchangeLocation(KDButton next, KDButton prev) {
        next.setBounds(prev.getBounds());
        if (next.getClientProperty((Object)"KDLayoutConstraints") instanceof KDLayout.Constraints) {
            KDLayout.Constraints cons = (KDLayout.Constraints)next.getClientProperty((Object)"KDLayoutConstraints");
            cons.originalBounds = prev.getBounds();
        }
        next.putClientProperty((Object)"OriginalBounds", (Object)prev.getBounds());
    }
}

