/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.query.EntityExecutorFactory;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgVersionCollection;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.client.ProgressDialogUI;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgControlFacadeFactory;
import com.kingdee.eas.ma.control.BgControlIsomerBaseCollection;
import com.kingdee.eas.ma.control.BgControlIsomerBaseFactory;
import com.kingdee.eas.ma.control.BgControlIsomerFacadeFactory;
import com.kingdee.eas.ma.control.BgControlIsomerFactory;
import com.kingdee.eas.ma.control.BgControlIsomerInfo;
import com.kingdee.eas.ma.control.BgControlSchemeCollection;
import com.kingdee.eas.ma.control.BgControlSchemeFacadeFactory;
import com.kingdee.eas.ma.control.BgControlSchemeFactory;
import com.kingdee.eas.ma.control.BgControlSchemeInfo;
import com.kingdee.eas.ma.control.client.BgControlRecordProgressDialogUI;
import com.kingdee.eas.ma.control.client.utils.MyBgControlCaller;
import com.kingdee.eas.ma.control.utils.BgControlIsomerKSQLUtils;
import com.kingdee.eas.ma.control.utils.BgControlIsomerUtils;
import com.kingdee.eas.ma.control.utils.BgControlUtils;
import com.kingdee.eas.ma.control.utils.BizDataObject;
import com.kingdee.eas.ma.mbg.utils.SchemeAssignMsgObj;
import com.kingdee.eas.ma.nbudget.face.IControlResult;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Component;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgControlRecordClientHelper {
    private static Logger logger = Logger.getLogger((String)BgControlRecordClientHelper.class.getName());
    public static final String ID = "id";
    public static final String ORGUNIT = "orgUnit";
    public static final String CTRL_SCHEME = "ctrlScheme";
    public static final String BILL = "bill";
    public static final String RESULT = "result";
    public static final String DETAIL = "detail";

    public static void startControlRecord(CoreUI ownerUi, BizDataObject bizUnit, Date beginTime, Date endTime, String filter, Collection<String> orgUnitIds, boolean isCtrl, boolean isAllowAccess, String uiTitle) throws Exception {
        if (bizUnit == null || beginTime == null || beginTime == null || orgUnitIds == null || orgUnitIds.isEmpty()) {
            return;
        }
        beginTime = BgNPeriodHelper.getDayBegin((Date)beginTime);
        endTime = BgNPeriodHelper.getDayEnd((Date)endTime);
        HashSet<String> orgIds = new HashSet<String>(orgUnitIds);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add(ID);
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo(ID, orgIds, CompareType.INCLUDE));
        evi.setSorter(new SorterItemCollection());
        evi.getSorter().add(new SorterItemInfo("longNumber"));
        CostCenterOrgUnitCollection orgCol = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(evi);
        evi = new EntityViewInfo();
        evi.setBaseOnSelector(true);
        evi.setFilter(new FilterInfo());
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add(ID);
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("orgUnit.id");
        evi.getSelector().add("beginDate");
        evi.getSelector().add("endDate");
        evi.setSorter(new SorterItemCollection());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", orgIds, CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bizUnit", (Object)bizUnit.getValue(), CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isValid", (Object)Boolean.TRUE, CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isSysDefault", (Object)Boolean.FALSE, CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("beginDate", (Object)beginTime, CompareType.GREATER_EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("beginDate", (Object)endTime, CompareType.LESS_EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("endDate", (Object)beginTime, CompareType.GREATER_EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("endDate", (Object)endTime, CompareType.LESS_EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("beginDate", (Object)beginTime, CompareType.LESS_EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("endDate", (Object)beginTime, CompareType.GREATER_EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("beginDate", (Object)endTime, CompareType.LESS_EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("endDate", (Object)endTime, CompareType.GREATER_EQUALS));
        evi.getFilter().setMaskString("#0 AND #1 AND #2 AND #3 AND ((#4 AND #5) OR (#6 AND #7) OR (#8 AND #9) OR (#10 AND #11))");
        BgControlSchemeCollection ctrlSchemeCol = BgControlSchemeFactory.getRemoteInstance().getBgControlSchemeCollection(evi);
        BgControlSchemeInfo ctrlSchemeInfo = null;
        String orgUnitId = null;
        HashMap<String, BgControlSchemeCollection> ctrlSchemeMap = new HashMap<String, BgControlSchemeCollection>();
        for (int i = 0; i < ctrlSchemeCol.size(); ++i) {
            ctrlSchemeInfo = ctrlSchemeCol.get(i);
            orgUnitId = ctrlSchemeInfo.getOrgUnit().getId().toString();
            if (!ctrlSchemeMap.containsKey(orgUnitId)) {
                ctrlSchemeMap.put(orgUnitId, new BgControlSchemeCollection());
            }
            ((BgControlSchemeCollection)((Object)ctrlSchemeMap.get(orgUnitId))).add(ctrlSchemeInfo);
        }
        HashMap<String, BgVersionCollection> billMap = new HashMap<String, BgVersionCollection>();
        String bizDateField = BgControlSchemeFacadeFactory.getRemoteInstance().getDefaultBizUnit(bizUnit.getValue(), 4);
        if (StringUtils.isEmpty((String)bizDateField)) {
            throw new BgControlException(BgControlException.NOFOUNDDEFAULTBIZ);
        }
        boolean isomer = bizUnit.isIsomer();
        if (isomer) {
            BgControlRecordClientHelper.getBillInfoForIsomer(ownerUi, billMap, bizUnit, bizDateField, filter, orgCol, beginTime, endTime, orgUnitId);
        } else {
            BgControlRecordClientHelper.getBillInfo(ownerUi, billMap, bizUnit, bizDateField, filter, orgIds, beginTime, endTime, orgUnitId);
        }
        IObjectPK logPk = LogUtil.beginLog(null, (String)(isCtrl ? "_requestBudget" : "_returnBudget"), (BOSObjectType)new BOSObjectType("FF6BCC48"), null, (String)uiTitle, (String)"mbg_bgscheme_controlRecord");
        UIContext map = new UIContext((Object)ownerUi);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgControlRecordProgressDialogUI.class.getName(), (Map)map);
        if (window != null && window.getUIObject() instanceof ProgressDialogUI) {
            ProgressDialogUI ui = (ProgressDialogUI)window.getUIObject();
            ui.setShowTableMessage(true);
            ui.setUITitle(uiTitle);
            ui.setInvokeClass(BgControlRecordClientHelper.class.getName());
            ui.setInvokeMethod("invokeMethod");
            BgControlRecordClientHelper.initParameterValue(ui, orgCol, ctrlSchemeMap, billMap, isCtrl, isAllowAccess, bizDateField, isomer);
            ui.init();
            window.show();
        }
        LogUtil.afterLog(null, (IObjectPK)logPk);
    }

    private static void getBillInfo(CoreUI ownerUi, Map<String, BgVersionCollection> billMap, BizDataObject bizUnit, String bizDateField, String filter, Set<String> orgIds, Date beginTime, Date endTime, String orgUnitId) throws Exception {
        String OUFieldOQL = BgControlUtils.getBizUnitOUFieldOQL(null, bizUnit.getValue());
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add(ID);
        evi.getSelector().add("number");
        evi.getSelector().add(OUFieldOQL);
        evi.getSelector().add(bizDateField);
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo(OUFieldOQL, orgIds, CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo(bizDateField, (Object)beginTime, CompareType.GREATER_EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo(bizDateField, (Object)endTime, CompareType.LESS_EQUALS));
        if (!StringUtils.isEmpty((String)filter)) {
            filter = filter.replace("%", "");
            evi.getFilter().mergeFilter(new FilterInfo(filter), "AND");
        }
        evi.setSorter(new SorterItemCollection());
        evi.getSorter().add(new SorterItemInfo("number"));
        IDataProvider dataProvider = EntityExecutorFactory.getRemoteInstance((IMetaDataPK)MetaDataPK.create((String)bizUnit.getValue()));
        dataProvider.setObjectView(evi);
        IRowSet rst = dataProvider.executeQuery();
        HashSet<String> billId = new HashSet<String>();
        BgVersionInfo billInfo = null;
        while (rst.next()) {
            billInfo = new BgVersionInfo();
            orgUnitId = rst.getString(3);
            if (StringUtils.isEmpty((String)orgUnitId) || rst.getTimestamp(4) == null) continue;
            billInfo.setId(BOSUuid.read((String)rst.getString(1)));
            if (billId.contains(billInfo.getId().toString())) continue;
            billId.add(billInfo.getId().toString());
            billInfo.setNumber(rst.getString(2));
            billInfo.setCreateTime(rst.getTimestamp(4));
            if (!billMap.containsKey(orgUnitId)) {
                billMap.put(orgUnitId, new BgVersionCollection());
            }
            billMap.get(orgUnitId).add(billInfo);
        }
        if (billMap.isEmpty()) {
            MsgBox.showInfo((Component)ownerUi, (String)BgControlRecordClientHelper.getMsg("noFoundBill"));
            SysUtil.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getBillInfoForIsomer(CoreUI ownerUi, Map<String, BgVersionCollection> billMap, BizDataObject bizUnit, String bizDateField, String filter, CostCenterOrgUnitCollection orgCol, Date beginTime, Date endTime, String orgUnitId) throws Exception {
        String OUFieldOQL = BgControlIsomerUtils.getBizUnitOUFieldOQL(null, bizUnit.getValue());
        BgControlIsomerInfo isomerInfo = BgControlIsomerFactory.getRemoteInstance().getBgControlIsomerInfo("Select id,number,sets.*,maps.*,connection.*,name,pfiled where id='" + bizUnit.getValue() + "'");
        BgControlIsomerBaseCollection colls = BgControlIsomerBaseFactory.getRemoteInstance().getBgControlIsomerBaseCollection("select number,easNumber,TYPE where connection.id='" + isomerInfo.getConnection().getId() + "'");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put(isomerInfo.getPfiled(), 1);
        map.put(OUFieldOQL, 2);
        map.put(bizDateField, 3);
        FilterInfo filterInfo = null;
        if (StringUtils.isEmpty((String)filter)) {
            filterInfo = new FilterInfo();
        } else {
            try {
                filterInfo = new FilterInfo(filter, true);
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
        }
        HashSet<String> orgnumbers = new HashSet<String>();
        HashMap<String, String> maps = new HashMap<String, String>();
        block7: for (int i = 0; i < orgCol.size(); ++i) {
            for (int j = 0; j < colls.size(); ++j) {
                if (!colls.get(j).getEasNumber().equals(orgCol.get(i).getNumber())) continue;
                orgnumbers.add(colls.get(j).getNumber());
                maps.put(colls.get(j).getNumber(), orgCol.get(i).getId().toString());
                continue block7;
            }
        }
        if (orgnumbers.isEmpty()) {
            MsgBox.showInfo((Component)ownerUi, (String)BgControlRecordClientHelper.getMsg("noFoundBill"));
            SysUtil.abort();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo(OUFieldOQL, orgnumbers, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo(bizDateField, (Object)beginTime, CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo(bizDateField, (Object)endTime, CompareType.LESS_EQUALS));
        String queryBillSQL = BgControlIsomerUtils.parseSql(map, isomerInfo, filterInfo);
        BgControlIsomerKSQLUtils client = BgControlIsomerUtils.getKSQLCilent(null, isomerInfo.getConnection()).get(isomerInfo.getConnection().getId().toString());
        IRowSet rst = null;
        HashSet<String> billId = new HashSet<String>();
        try {
            rst = client.getTargetRowset(queryBillSQL);
            BgVersionInfo billInfo = null;
            while (rst.next()) {
                billInfo = new BgVersionInfo();
                String orgNumber = rst.getString(2);
                orgUnitId = (String)maps.get(orgNumber);
                if (StringUtils.isEmpty((String)orgUnitId) || rst.getTimestamp(3) == null) continue;
                billInfo.setId(BOSUuid.read((String)rst.getString(1)));
                if (billId.contains(billInfo.getId().toString())) continue;
                billId.add(billInfo.getId().toString());
                billInfo.setNumber(bizUnit.getValue());
                billInfo.setCreateTime(rst.getTimestamp(3));
                if (!billMap.containsKey(orgUnitId)) {
                    billMap.put(orgUnitId, new BgVersionCollection());
                }
                billMap.get(orgUnitId).add(billInfo);
            }
            if (billMap.isEmpty()) {
                MsgBox.showInfo((Component)ownerUi, (String)BgControlRecordClientHelper.getMsg("noFoundBill"));
                SysUtil.abort();
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"error", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst);
        }
    }

    private static void initParameterValue(ProgressDialogUI ui, CostCenterOrgUnitCollection orgCol, Map<String, BgControlSchemeCollection> ctrlSchemeMap, Map<String, BgVersionCollection> billMap, boolean isCtrl, boolean isAllowAccess, String bizDateField, boolean isomer) {
        Class[] cls = new Class[]{CostCenterOrgUnitInfo.class, CoreBaseInfo.class, BgControlSchemeInfo.class, Boolean.TYPE, Boolean.TYPE, CostCenterOrgUnitInfo.class, CoreBaseInfo.class, BgControlSchemeInfo.class, Boolean.TYPE};
        ui.setInvokeMethodParmeterType(cls);
        Vector<Object[]> paramValues = new Vector<Object[]>();
        Object[] param = null;
        Object[] lastParam = null;
        CostCenterOrgUnitInfo orgUnitInfo = null;
        BgControlSchemeInfo ctrlSchemeInfo = null;
        BgVersionInfo billInfo = null;
        BgControlSchemeCollection ctrlSchemeCol = null;
        BgVersionCollection billCol = null;
        String orgUnitId = null;
        Date bizDate = null;
        Timestamp obj = null;
        for (int o = 0; o < orgCol.size(); ++o) {
            orgUnitInfo = orgCol.get(o);
            orgUnitId = orgUnitInfo.getId().toString();
            ctrlSchemeCol = ctrlSchemeMap.get(orgUnitId);
            billCol = billMap.get(orgUnitId);
            if (billCol == null || billCol.isEmpty()) continue;
            block1: for (int b = 0; b < billCol.size(); ++b) {
                billInfo = billCol.get(b);
                lastParam = param;
                param = new Object[9];
                if (lastParam != null) {
                    param[0] = lastParam[5];
                    param[1] = lastParam[6];
                    param[2] = lastParam[7];
                }
                param[3] = isCtrl;
                param[4] = isAllowAccess;
                param[5] = orgUnitInfo;
                param[6] = billInfo;
                param[8] = isomer;
                paramValues.add(param);
                if (ctrlSchemeCol == null || ctrlSchemeCol.isEmpty() || !((obj = billInfo.getCreateTime()) instanceof Date)) continue;
                bizDate = obj;
                for (int s = 0; s < ctrlSchemeCol.size(); ++s) {
                    ctrlSchemeInfo = ctrlSchemeCol.get(s);
                    if (bizDate.compareTo(BgNPeriodHelper.getDayBegin((Date)ctrlSchemeInfo.getBeginDate())) < 0 || bizDate.compareTo(BgNPeriodHelper.getDayBegin((Date)ctrlSchemeInfo.getEndDate())) > 0) continue;
                    param[7] = ctrlSchemeInfo;
                    continue block1;
                }
            }
        }
        if (param != null) {
            lastParam = param;
            param = new Object[9];
            param[0] = lastParam[5];
            param[1] = lastParam[6];
            param[2] = lastParam[7];
            param[3] = isCtrl;
            param[4] = isAllowAccess;
            param[8] = isomer;
            paramValues.add(param);
        }
        int size = paramValues.size();
        Object[][] params = new Object[size][];
        for (int i = 0; i < size; ++i) {
            params[i] = (Object[])paramValues.get(i);
        }
        ui.setInvokeMethodParmeterValue(params);
        ui.setCountSum(size - 1);
    }

    public Object invokeMethod(CostCenterOrgUnitInfo curOrgUnit, CoreBaseInfo curBill, BgControlSchemeInfo curCtrlScheme, boolean isCtrl, boolean isAllowAccess, CostCenterOrgUnitInfo nextOrgUnit, CoreBaseInfo nextBill, BgControlSchemeInfo nextCtrlScheme, boolean isomer) {
        Object[] obj = new Object[3];
        com.kingdee.eas.ma.control.face.IControlResult ctrlResult = null;
        if (nextBill != null) {
            obj[0] = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.control.client.BgControlResource", (String)"batchControlRecord", (Object[])new String[]{nextOrgUnit.getName(), nextBill.getString("number")});
        }
        if (curOrgUnit != null && curBill != null) {
            try {
                if (isomer) {
                    int type = 0;
                    type = !isCtrl ? 1 : (isAllowAccess ? 3 : 0);
                    ctrlResult = (com.kingdee.eas.ma.control.face.IControlResult)BgControlIsomerFacadeFactory.getRemoteInstance().bgControlToGuiHandle(curBill.getId().toString(), curBill.getString("number"), type);
                } else {
                    ctrlResult = !isCtrl ? BgControlFacadeFactory.getRemoteInstance().returnBudget(curBill.getId()) : (isAllowAccess ? BgControlFacadeFactory.getRemoteInstance().specialBudgetHasWx(curBill.getId()) : BgControlFacadeFactory.getRemoteInstance().requestBudgetHasWX(curBill.getId()));
                }
                obj[1] = this.processReport(curOrgUnit, curBill, curCtrlScheme, ctrlResult);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                String exceptionMsg = null;
                if (e instanceof EASBizException) {
                    exceptionMsg = ((EASBizException)((Object)e)).getMessage();
                } else if (e instanceof BOSException) {
                    BOSException be = (BOSException)((Object)e);
                    exceptionMsg = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                } else {
                    exceptionMsg = e.getMessage();
                }
                obj[1] = this.processReport(curOrgUnit, curBill, curCtrlScheme, false, exceptionMsg);
            }
        }
        return obj;
    }

    private Map processReport(CostCenterOrgUnitInfo curOrgUnit, CoreBaseInfo curBill, BgControlSchemeInfo curCtrlScheme, com.kingdee.eas.ma.control.face.IControlResult ctrlResult) throws EASBizException {
        boolean isSucess = ctrlResult != null && ctrlResult.getResult() == 1;
        StringBuffer detail = new StringBuffer();
        if (ctrlResult != null && ctrlResult.getCause() != null && !ctrlResult.getCause().isEmpty()) {
            IControlResult result = new MyBgControlCaller().transResult(ctrlResult);
            for (int i = 0; i < result.getCause().size(); ++i) {
                if (detail.length() > 0) {
                    detail.append("\r\n");
                }
                detail.append((String)result.getCause().get(i));
            }
        }
        return this.processReport(curOrgUnit, curBill, curCtrlScheme, isSucess, detail.toString());
    }

    private Map processReport(CostCenterOrgUnitInfo curOrgUnit, CoreBaseInfo curBill, BgControlSchemeInfo curCtrlScheme, boolean isSuccess, String detail) {
        HashMap<SchemeAssignMsgObj, String> res = new HashMap<SchemeAssignMsgObj, String>();
        res.put(BgControlRecordClientHelper.getAssignKey(ORGUNIT, 1), curOrgUnit.getName());
        String schemeName = "";
        if (curCtrlScheme != null) {
            schemeName = curCtrlScheme.getName();
        }
        res.put(BgControlRecordClientHelper.getAssignKey(CTRL_SCHEME, 2), schemeName);
        res.put(BgControlRecordClientHelper.getAssignKey(BILL, 3), curBill.getString("number"));
        res.put(BgControlRecordClientHelper.getAssignKey(RESULT, 4), BgControlRecordClientHelper.getMsg(isSuccess ? "success" : "fail"));
        res.put(BgControlRecordClientHelper.getAssignKey(DETAIL, 5), detail);
        res.put(BgControlRecordClientHelper.getAssignKey(ID, 6), curBill.getId().toString());
        return res;
    }

    public static SchemeAssignMsgObj getAssignKey(String key, int order) {
        return new SchemeAssignMsgObj(key, BgControlRecordClientHelper.getMsg(key), order);
    }

    public static String getMsg(String key) {
        return BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.control.client.BgControlResource", (String)key);
    }
}

