/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client.utils;

import com.kingdee.bos.ctrl.common.util.UnitConverter;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.BookDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.wrapper.SXSSFExportWrapper;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.Rect;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.client.utils.BgFileUtil;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.base.utils.Excel2007FileFilter;
import com.kingdee.eas.ma.base.utils.ExcelFile;
import com.kingdee.eas.ma.base.utils.ReportUtils;
import com.kingdee.eas.ma.control.BgControlItemMapCollection;
import com.kingdee.eas.ma.control.BgControlItemMapEntryCollection;
import com.kingdee.eas.ma.control.BgControlItemMapEntryInfo;
import com.kingdee.eas.ma.control.BgControlItemMapInfo;
import com.kingdee.eas.ma.control.BgControlSchemeFacadeFactory;
import com.kingdee.eas.ma.control.BgControlSchemeInfo;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.ma.control.utils.BgEntryTreeUtils;
import com.kingdee.eas.ma.control.utils.BizDataObject;
import com.kingdee.eas.ma.control.utils.BizUnitUtils;
import com.kingdee.eas.ma.mbg.client.MbgMemberDialog;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.filechooser.FileFilter;

public class BgControlRelUtils {
    private static int DEF_COLUMN_WIDTH = 175;
    private static BgEntryTreeUtils treeUtils = new BgEntryTreeUtils();
    private static int INDEX_INDEX = 0;
    private static int INDEX_TYPE = 1;
    private static int INDEX_PROP_VALUE = 2;
    private static int INDEX_PROP_ALIAS = 3;
    private static int INDEX_NUMBER = 4;
    private static int INDEX_NAME = 5;
    public static int INDEX_COL_TYPE = 0;
    public static int INDEX_COL_VALUE = 1;
    public static int INDEX_COL_ALIAS = 2;

    public static void initBizItemMap(Component comp, BgControlSchemeInfo controlScheme, BizDataObject bizUnit, BizDataObject bizProp, int dimensionGroup, KDTable kdRel, boolean showNumber, Map<String, MbgDimInfo> sourceMap) throws Exception {
        if (kdRel == null || bizUnit == null) {
            return;
        }
        if (bizProp == null) {
            MsgBox.showWarning((Component)comp, (String)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"checkRule.dimItem"));
            SysUtil.abort();
        } else {
            String[] bizShow = bizProp.getDisplay().split("@");
            String[] bizVals = bizProp.getValue().split("@");
            if (bizShow == null || bizVals == null || bizVals.length == 0 || bizShow.length != bizVals.length) {
                MsgBox.showConfirm2((Component)comp, (String)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"checkRule.dimItem.error"));
                SysUtil.abort();
            }
            BgControlRelUtils.initBizItemTitle(bizUnit, kdRel, bizVals, bizShow, showNumber);
            BgControlRelUtils.loadBizItemData(comp, controlScheme, bizProp, dimensionGroup, kdRel, sourceMap);
        }
    }

    private static void initBizItemTitle(BizDataObject bizUnit, KDTable kdRel, String[] bizVals, String[] bizShow, boolean showNumber) throws Exception {
        if (kdRel == null || bizVals == null || bizShow == null) {
            return;
        }
        Object obj = null;
        String[] tmpShows = null;
        String[] tmpBizs = null;
        int bizValsNum = bizVals.length;
        ArrayList<String> newBizVals = new ArrayList<String>();
        ArrayList<String> newBizShow = new ArrayList<String>();
        int in = bizVals.length;
        for (int i = 0; i < in; ++i) {
            tmpShows = bizShow[i].split("\\|");
            tmpBizs = bizVals[i].split("\\|");
            if (tmpBizs[0].endsWith("mbgNumber") || tmpBizs[0].endsWith("mbgNumberIn") || tmpBizs[0].endsWith("mbgNumberOut") || tmpBizs[0].endsWith(".mbgNumber")) {
                --bizValsNum;
                continue;
            }
            newBizVals.add(bizVals[i]);
            newBizShow.add(bizShow[i]);
        }
        if (bizValsNum == 0) {
            kdRel.removeColumns();
            kdRel.setEditable(false);
            return;
        }
        bizVals = newBizVals.toArray(new String[newBizVals.size()]);
        bizShow = newBizShow.toArray(new String[newBizShow.size()]);
        int mbgItemIndex = bizValsNum * 2;
        IColumn column = null;
        kdRel.removeRows();
        kdRel.removeColumns();
        kdRel.addColumns(bizValsNum * 4);
        int in2 = kdRel.getColumnCount();
        for (int i = 0; i < in2; ++i) {
            kdRel.getColumn(i).setWidth(DEF_COLUMN_WIDTH);
        }
        IRow row = kdRel.addHeadRow();
        row.getCell(0).setValue((Object)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"bizItemMap.bizItem"));
        kdRel.getHeadMergeManager().mergeBlock(row.getRowIndex(), 0, row.getRowIndex(), kdRel.getColumnCount() / 2 - 1);
        row.getCell(mbgItemIndex).setValue((Object)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"bizItemMap.mbgItem"));
        kdRel.getHeadMergeManager().mergeBlock(row.getRowIndex(), mbgItemIndex, row.getRowIndex(), kdRel.getColumnCount() - 1);
        boolean hasBgIndex = false;
        String numberAlias = BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"num");
        String longNumberAlias = BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"longNum");
        String showName = null;
        row = kdRel.addHeadRow();
        int in3 = bizVals.length;
        for (int i = 0; i < in3; ++i) {
            tmpShows = bizShow[i].split("\\|");
            tmpBizs = bizVals[i].split("\\|");
            if (tmpBizs[0].endsWith("mbgNumber") || tmpBizs[0].endsWith("mbgNumberIn") || tmpBizs[0].endsWith("mbgNumberOut") || tmpBizs[0].endsWith(".mbgNumber")) continue;
            hasBgIndex = false;
            if (DimensionBaseConstants.DEF_INDEX_SRCNUMBER.equals(tmpBizs[1])) {
                hasBgIndex = true;
            }
            if (!bizUnit.isIsomer()) {
                obj = BgControlRelUtils.parseProperty(bizUnit.getValue(), tmpBizs[0]);
            }
            if (obj != null) {
                if (tmpBizs[0].endsWith("longNumber")) {
                    row.getCell(i * 2).setValue((Object)(obj + longNumberAlias));
                } else {
                    row.getCell(i * 2).setValue((Object)(obj + numberAlias));
                }
                row.getCell(i * 2 + 1).setValue(obj);
                tmpShows[0] = new String(obj.toString());
            } else {
                showName = tmpShows[0];
                if (!StringUtils.isEmpty((String)showName) && !StringUtils.isEmpty((String)numberAlias) && showName.endsWith(numberAlias)) {
                    showName = showName.substring(0, showName.length() - numberAlias.length());
                }
                row.getCell(i * 2).setValue((Object)(showName + numberAlias));
                row.getCell(i * 2 + 1).setValue((Object)showName);
            }
            column = kdRel.getColumn(i * 2);
            column.setKey(tmpBizs[0]);
            BgControlRelUtils.setColPropInfo(column, BgControlConstants.PROP_TYPE, BgControlConstants.PROP_NUMBER);
            BgControlRelUtils.setColPropInfo(column, BgControlConstants.PROP_VALUE, tmpBizs[0]);
            BgControlRelUtils.setColPropInfo(column, BgControlConstants.PROP_ALIAS, tmpShows[0]);
            BgControlRelUtils.setColPropInfo(column, BgControlConstants.PROP_BGINDEX, String.valueOf(hasBgIndex));
            column.getStyleAttributes().setHided(!showNumber);
            column = kdRel.getColumn(i * 2 + 1);
            column.setKey(tmpBizs[0]);
            BgControlRelUtils.setColPropInfo(column, BgControlConstants.PROP_TYPE, BgControlConstants.PROP_NAME);
            BgControlRelUtils.setColPropInfo(column, BgControlConstants.PROP_VALUE, tmpBizs[0]);
            BgControlRelUtils.setColPropInfo(column, BgControlConstants.PROP_ALIAS, tmpShows[0]);
            BgControlRelUtils.setColPropInfo(column, BgControlConstants.PROP_BGINDEX, String.valueOf(hasBgIndex));
            row.getCell(mbgItemIndex + i * 2).setValue((Object)(tmpShows[1] + BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"num")));
            row.getCell(mbgItemIndex + i * 2 + 1).setValue((Object)tmpShows[1]);
            column = kdRel.getColumn(mbgItemIndex + i * 2);
            column.setKey(tmpBizs[1]);
            BgControlRelUtils.setColPropInfo(column, BgControlConstants.PROP_TYPE, BgControlConstants.PROP_MBG_NUMBER);
            BgControlRelUtils.setColPropInfo(column, BgControlConstants.PROP_VALUE, tmpBizs[1]);
            BgControlRelUtils.setColPropInfo(column, BgControlConstants.PROP_ALIAS, tmpShows[1]);
            column.getStyleAttributes().setHided(!showNumber);
            column = kdRel.getColumn(mbgItemIndex + i * 2 + 1);
            column.setKey(tmpShows[1]);
            BgControlRelUtils.setColPropInfo(column, BgControlConstants.PROP_TYPE, BgControlConstants.PROP_MBG_NAME);
            BgControlRelUtils.setColPropInfo(column, BgControlConstants.PROP_VALUE, tmpBizs[1]);
            BgControlRelUtils.setColPropInfo(column, BgControlConstants.PROP_ALIAS, tmpShows[1]);
        }
    }

    private static Object parseProperty(String bizUnit, String bizProp) throws Exception {
        if (bizUnit == null || bizProp == null) {
            throw new EASBizException(EASBizException.CHECKBLANK);
        }
        String propName = null;
        LinkPropertyInfo linkProp = BizUnitUtils.lastLinkProperty(bizUnit, bizProp, treeUtils.getGenAssActTypeMap());
        if (linkProp != null) {
            propName = linkProp.getAlias();
        }
        return propName;
    }

    private static void setColPropInfo(IColumn column, String key, String value) {
        if (column == null || key == null) {
            return;
        }
        HashMap<String, String> tmpMap = (HashMap<String, String>)column.getUserObject();
        if (tmpMap == null) {
            tmpMap = new HashMap<String, String>();
            column.setUserObject(tmpMap);
        }
        tmpMap.put(key, value);
    }

    public static String getColPropInfo(IColumn column, String key) {
        if (column == null || key == null) {
            return null;
        }
        HashMap tmpMap = (HashMap)column.getUserObject();
        if (tmpMap == null) {
            tmpMap = new HashMap();
            column.setUserObject(tmpMap);
        }
        return (String)tmpMap.get(key);
    }

    private static void loadBizItemData(Component comp, BgControlSchemeInfo controlScheme, BizDataObject bizProp, int dimensionGroup, KDTable kdRel, Map<String, MbgDimInfo> sourceMap) {
        if (controlScheme == null || bizProp == null || kdRel == null || sourceMap == null) {
            return;
        }
        BgControlItemMapInfo itemMap = null;
        BgControlItemMapEntryInfo entry = null;
        BgControlItemMapEntryCollection entryColls = null;
        BgControlItemMapEntryCollection remove = new BgControlItemMapEntryCollection();
        String srcNumber = null;
        String[] bizItemNums = null;
        String[] bizItemAlias = null;
        String[] mbgItemNums = null;
        String[] mbgItemAlias = null;
        IRow row = null;
        ICell cell = null;
        int colCount = kdRel.getColumnCount();
        kdRel.removeRows();
        kdRel.setEditable(true);
        int in = kdRel.getColumns().size() / 2;
        for (int i = 0; i < in; ++i) {
            kdRel.getColumn(i).getStyleAttributes().setLocked(false);
        }
        int in2 = kdRel.getColumns().size();
        for (int i = in2 / 2; i < in2; i += 2) {
            kdRel.getColumn(i).getStyleAttributes().setLocked(false);
        }
        String[] combines = bizProp.getValue().split("\\@");
        int j = kdRel.getColumns().size() / 2;
        int jn = kdRel.getColumns().size();
        int k = 0;
        while (j < jn) {
            kdRel.getColumn(j).getStyleAttributes().setLocked(false);
            KDBizPromptBox prmt = new KDBizPromptBox();
            prmt.setEditable(false);
            srcNumber = combines[k].split("\\|")[1];
            MbgMemberDialog mbgMemberDialog = new MbgMemberDialog(comp, sourceMap.get(srcNumber));
            mbgMemberDialog.setOrgUnitId(controlScheme.getOrgUnit().getId());
            mbgMemberDialog.setMultiSelect(true);
            prmt.setSelector((KDPromptSelector)mbgMemberDialog);
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)prmt);
            kdRel.getColumn(j).setEditor((ICellEditor)editor);
            j += 2;
            ++k;
        }
        BgControlItemMapCollection colls = controlScheme.getItemMaps();
        int in3 = colls.size();
        for (int i = 0; i < in3; ++i) {
            int j2;
            itemMap = colls.get(i);
            if (!itemMap.getBizProp().equals(bizProp.getValue()) || itemMap.getDimensionGroup() != dimensionGroup) continue;
            entryColls = itemMap.getEntry();
            remove.clear();
            int jn2 = entryColls.size();
            for (j2 = 0; j2 < jn2; ++j2) {
                entry = entryColls.get(j2);
                if (entry == null || StringUtils.isEmpty((String)entry.getBizItemValue()) && StringUtils.isEmpty((String)entry.getMbgItemValue())) {
                    remove.add(entry);
                    continue;
                }
                bizItemNums = entry.getBizItemValue() != null ? entry.getBizItemValue().split("\\|") : null;
                bizItemAlias = entry.getBizItemAlias() != null ? entry.getBizItemAlias().split("\\|") : null;
                mbgItemNums = entry.getMbgItemValue() != null ? entry.getMbgItemValue().split("\\|") : null;
                String[] stringArray = mbgItemAlias = entry.getMbgItemAlias() != null ? entry.getMbgItemAlias().split("\\|") : null;
                if (bizItemNums == null || mbgItemNums == null || (bizItemNums.length + mbgItemNums.length) * 2 != colCount) continue;
                row = kdRel.addRow();
                row.setUserObject((Object)entry);
                int xn = bizItemNums.length;
                for (int x = 0; x < xn; ++x) {
                    cell = row.getCell(x * 2, true);
                    cell.setValue((Object)bizItemNums[x]);
                    cell = row.getCell(x * 2 + 1, true);
                    cell.setValue(null == bizItemAlias ? null : bizItemAlias[x]);
                }
                int yn = mbgItemNums.length;
                for (int y = 0; y < yn; ++y) {
                    cell = row.getCell((y + bizItemNums.length) * 2, true);
                    cell.setValue((Object)mbgItemNums[y]);
                    cell = row.getCell((y + bizItemNums.length) * 2 + 1, true);
                    cell.setValue(null == mbgItemAlias ? null : mbgItemAlias[y]);
                }
            }
            if (remove.isEmpty()) continue;
            jn2 = remove.size();
            for (j2 = 0; j2 < jn2; ++j2) {
                entryColls.remove(remove.get(j2));
            }
        }
    }

    public static void showColumnByNumber(KDTable kdRel, boolean hasShow) {
        if (kdRel == null) {
            return;
        }
        IColumn column = null;
        String colKey = null;
        int in = kdRel.getColumnCount();
        for (int i = 0; i < in; ++i) {
            column = kdRel.getColumn(i);
            colKey = BgControlRelUtils.getColPropInfo(column, BgControlConstants.PROP_TYPE);
            if (!BgControlConstants.PROP_NUMBER.equals(colKey) && !BgControlConstants.PROP_MBG_NUMBER.equals(colKey)) continue;
            column.getStyleAttributes().setHided(!hasShow);
        }
    }

    private static List<String[]> checkBizItemNumber(BizDataObject bizUnit, List<List<String[]>> bizItems, KDTable kdRel) throws Exception {
        ArrayList<String[]> chkItems = new ArrayList<String[]>();
        if (bizItems == null || bizItems.isEmpty() || kdRel == null) {
            return chkItems;
        }
        HashMap checkMaps = new HashMap();
        Set<String> numSets = null;
        List<String[]> items = null;
        String[] bizObjs = null;
        String[] itemObj = null;
        int in = bizItems.size();
        for (int i = 0; i < in; ++i) {
            items = bizItems.get(i);
            int jn = items.size();
            for (int j = 0; j < jn; ++j) {
                bizObjs = items.get(j);
                if (bizObjs == null || bizObjs[INDEX_NUMBER] == null) continue;
                if (checkMaps.containsKey(bizObjs[INDEX_PROP_VALUE])) {
                    numSets = (Set)checkMaps.get(bizObjs[INDEX_PROP_VALUE]);
                } else {
                    numSets = new HashSet();
                    checkMaps.put(bizObjs[INDEX_PROP_VALUE], numSets);
                }
                numSets.add(bizObjs[INDEX_NUMBER]);
            }
        }
        Map checkedMap = BgControlSchemeFacadeFactory.getRemoteInstance().checkBizItem(bizUnit, checkMaps);
        if (!checkedMap.isEmpty()) {
            ArrayList<List<String[]>> tmpList = new ArrayList<List<String[]>>();
            Map checkNums = null;
            String[] checkData = null;
            boolean ignoreRow = false;
            int in2 = bizItems.size();
            for (int i = 0; i < in2; ++i) {
                items = bizItems.get(i);
                ignoreRow = false;
                int jn = items.size();
                for (int j = 0; j < jn; ++j) {
                    Rect rect;
                    bizObjs = items.get(j);
                    if (bizObjs == null || bizObjs[INDEX_NUMBER] == null || !checkedMap.containsKey(bizObjs[INDEX_PROP_VALUE])) continue;
                    checkNums = (Map)checkedMap.get(bizObjs[INDEX_PROP_VALUE]);
                    if (!checkNums.containsKey(bizObjs[INDEX_NUMBER])) {
                        itemObj = new String[5];
                        itemObj[BgControlRelUtils.INDEX_INDEX] = bizObjs[INDEX_INDEX];
                        itemObj[1] = BgControlConstants.PROP_NUMBER;
                        itemObj[2] = BgControlConstants.NOEXISTS_VALUE;
                        itemObj[3] = bizObjs[INDEX_PROP_ALIAS];
                        itemObj[4] = bizObjs[INDEX_NUMBER];
                        chkItems.add(itemObj);
                        ignoreRow = true;
                        continue;
                    }
                    checkData = (String[])checkNums.get(bizObjs[INDEX_NUMBER]);
                    if (bizObjs[INDEX_NAME] != null && bizObjs[INDEX_NAME].equals(checkData[1]) || (rect = TableToolkit.range2xy((String)bizObjs[INDEX_INDEX])) == null) continue;
                    String number = (String)kdRel.getCell(rect.x1, rect.y1).getValue();
                    String name = (String)kdRel.getCell(rect.x1, rect.y1 + 1).getValue();
                    if (StringUtils.isEmpty((String)bizObjs[INDEX_NAME])) {
                        if (!number.endsWith("%") || bizObjs[INDEX_NAME].endsWith("%")) continue;
                        kdRel.getCell(rect.x1, rect.y1 + 1).setValue((Object)(bizObjs[INDEX_NAME] + "%"));
                        continue;
                    }
                    if (!StringUtils.isEmpty((String)name)) continue;
                    kdRel.getCell(rect.x1, rect.y1 + 1).setValue((Object)checkData[1]);
                }
                if (!ignoreRow) continue;
                tmpList.add(items);
            }
            if (!tmpList.isEmpty()) {
                bizItems.removeAll(tmpList);
            }
        }
        return chkItems;
    }

    private static String getValue(ICell cell) {
        String _value = null;
        if (cell != null && cell.getValue() != null && StringUtils.isEmpty((String)(_value = cell.getValue().toString().trim()))) {
            _value = null;
        }
        return _value;
    }

    public static boolean exportItem(Component comp, KDTable kdRel) throws Exception {
        boolean exportItem = false;
        if (kdRel == null) {
            return exportItem;
        }
        BgFileUtil bgFileUtil = new BgFileUtil();
        KDFileChooser fc = bgFileUtil.getFileChooserForExp((Object)(comp instanceof CoreUI ? (CoreUI)comp : null));
        fc.setDialogTitle(BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"fileExport"));
        ExcelFile ef = new ExcelFile();
        fc.addChoosableFileFilter((FileFilter)ef);
        fc.addChoosableFileFilter((FileFilter)new Excel2007FileFilter());
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter((FileFilter)ef);
        if (fc.showSaveDialog(comp) == 0) {
            FileFilter filter = fc.getFileFilter();
            File file = fc.getSelectedFile();
            if (file.getName().indexOf(".") == -1) {
                if (filter instanceof ExcelFile) {
                    file = new File(fc.getSelectedFile() + ".xls");
                } else if (filter instanceof Excel2007FileFilter) {
                    file = new File(fc.getSelectedFile() + ".xlsx");
                }
            }
            if (file.exists()) {
                int re = MsgBox.showConfirm3((Component)comp, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"existsFile"));
                if (re == 1 || re == 2) {
                    return exportItem;
                }
                if (!file.renameTo(new File(file.getPath()))) {
                    MsgBox.showWarning((Component)comp, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"existsFileCantWrite"));
                    return exportItem;
                }
            }
            if (filter instanceof ExcelFile) {
                KDSBook kdsBook = new KDSBook("Book");
                KDSSheet kdsSheet = kdRel.getIOManager().saveToKDSSheet(kdsBook, true, false, true, "Sheet1");
                for (int i = 0; i <= kdsSheet.getColumnCount(); ++i) {
                    if (kdsSheet.getColumn(i, false) == null || kdsSheet.getColumn(i, false).getWidth() != 0.0f) continue;
                    kdsSheet.setColumnWidth(i, (float)UnitConverter.px2mm((int)kdRel.getColumn(i).getKDTColumn().getWidth()));
                }
                kdsBook.addSheet(null, kdsSheet);
                ExportManager export = new ExportManager();
                export.exportToExcel(kdsBook, file.getPath());
                bgFileUtil.storeDefaultPathForEXP((Object)file.getPath(), (Object)(comp instanceof CoreUI ? (CoreUI)comp : null));
                kdsBook = null;
            } else if (filter instanceof Excel2007FileFilter) {
                Book book = ReportUtils.getInstance().tranToBook(kdRel, true);
                BookDataWrapper bookDataWrapper = new BookDataWrapper(book);
                bookDataWrapper.setExportFormula(false);
                bookDataWrapper.setExportCustomerFomulas(true);
                bookDataWrapper.setShowValue(true);
                bookDataWrapper.setExportHideCols(true);
                bookDataWrapper.setExportHideRows(true);
                SXSSFExportWrapper booksc = new SXSSFExportWrapper((AbstractDataWrapper)bookDataWrapper);
                booksc.write(file.getPath());
                bgFileUtil.storeDefaultPathForEXP((Object)file.getPath(), (Object)(comp instanceof CoreUI ? (CoreUI)comp : null));
                book = null;
            }
            exportItem = true;
        }
        return exportItem;
    }

    public static void removeItems(Component comp, BgControlSchemeInfo controlScheme, BizDataObject bizProp, int dimensionGroup, KDTable kdRel) {
        if (bizProp == null || kdRel == null) {
            return;
        }
        if (kdRel.getSelectManager().getActiveRowIndex() == -1 || kdRel.getSelectManager().getActiveColumnIndex() == -1) {
            MsgBox.showWarning((Component)comp, (String)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"selecBizItem"));
            return;
        }
        KDTRange range = kdRel.getSelectManager().toRange();
        if (range != null) {
            BgControlItemMapInfo bizItemMap;
            KDTSelectBlock block2 = null;
            IRow row = null;
            ArrayList<Integer> removeIndex = new ArrayList<Integer>();
            ArrayList<BgControlItemMapEntryInfo> entrys = new ArrayList<BgControlItemMapEntryInfo>();
            for (KDTSelectBlock block2 : range) {
                if (block2 == null) continue;
                int in = block2.getEndRow();
                for (int i = block2.getBeginRow(); i <= in; ++i) {
                    row = kdRel.getRow(i);
                    removeIndex.add(row.getRowIndex());
                    entrys.add((BgControlItemMapEntryInfo)row.getUserObject());
                }
            }
            if (!removeIndex.isEmpty()) {
                Collections.sort(removeIndex, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer o1, Integer o2) {
                        return o2.compareTo(o1);
                    }
                });
                for (Integer index : removeIndex) {
                    kdRel.removeRow(index.intValue());
                }
            }
            if (!entrys.isEmpty() && (bizItemMap = controlScheme.getItemMap(bizProp.getValue(), dimensionGroup)) != null) {
                for (BgControlItemMapEntryInfo entry : entrys) {
                    bizItemMap.getEntry().removeObject((IObjectValue)entry);
                }
            }
        }
    }

    public static void matchingItems(Component comp, BgControlSchemeInfo controlScheme, BizDataObject bizProp, int dimensionGroup, KDTable kdRel) {
        if (controlScheme == null || bizProp == null || kdRel == null) {
            return;
        }
        if (kdRel.getSelectManager().getActiveRowIndex() == -1 || kdRel.getSelectManager().getActiveColumnIndex() == -1) {
            MsgBox.showWarning((Component)comp, (String)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"selecBizItem"));
            return;
        }
        kdRel.getSelectManager().setSelectMode(15);
        BgControlItemMapEntryInfo entry = null;
        BgControlItemMapEntryInfo tmpEntry = null;
        BgControlItemMapInfo bizItemMap = controlScheme.getItemMap(bizProp.getValue(), dimensionGroup);
        if (bizItemMap == null || bizItemMap.getEntry().isEmpty()) {
            return;
        }
        HashMap<String, BgControlItemMapEntryInfo> entryMap = new HashMap<String, BgControlItemMapEntryInfo>();
        int in = bizItemMap.getEntry().size();
        for (int i = 0; i < in; ++i) {
            entry = bizItemMap.getEntry().get(i);
            entryMap.put(entry.getBizItemValue(), entry);
        }
        IColumn column = null;
        HashMap<Integer, String> colTypeMap = new HashMap<Integer, String>();
        HashMap<Integer, Boolean> hasBgIndexMap = new HashMap<Integer, Boolean>();
        int in2 = kdRel.getColumnCount();
        for (int i = 0; i < in2; ++i) {
            column = kdRel.getColumn(i);
            colTypeMap.put(i, BgControlRelUtils.getColPropInfo(column, BgControlConstants.PROP_TYPE));
            hasBgIndexMap.put(i, new Boolean(BgControlRelUtils.getColPropInfo(column, BgControlConstants.PROP_BGINDEX)));
        }
        KDTRange range = kdRel.getSelectManager().toRange();
        if (range != null) {
            KDTSelectBlock block2 = null;
            IRow row = null;
            ICell cell = null;
            ICell aCell = null;
            String colType = null;
            String value = null;
            String aValue = null;
            String bizNum = null;
            String bizAlias = null;
            boolean hasBgIndex = false;
            boolean isBudgetItem = false;
            for (KDTSelectBlock block2 : range) {
                if (block2 == null) continue;
                int in3 = block2.getEndRow();
                for (int i = block2.getBeginRow(); i <= in3; ++i) {
                    row = kdRel.getRow(i);
                    if (row == null || row.getUserObject() == null) continue;
                    entry = (BgControlItemMapEntryInfo)row.getUserObject();
                    tmpEntry = (BgControlItemMapEntryInfo)entryMap.get(entry.getBizItemValue());
                    bizNum = "";
                    bizAlias = "";
                    int jn = block2.getEndCol();
                    for (int j = block2.getBeginCol(); j <= jn; ++j) {
                        if (j >= kdRel.getColumnCount() / 2) {
                            isBudgetItem = true;
                            break;
                        }
                        colType = (String)colTypeMap.get(j);
                        if (BgControlConstants.PROP_NUMBER.equals(colType)) {
                            cell = kdRel.getCell(i, j);
                            hasBgIndex = (Boolean)hasBgIndexMap.get(j);
                            aCell = kdRel.getCell(i, j + 1);
                            value = BgControlRelUtils.getValue(cell);
                            aValue = BgControlRelUtils.getValue(aCell);
                            if (value != null) {
                                if (value.endsWith("%")) {
                                    value = value.substring(0, value.length() - 1);
                                    if (aValue.endsWith("%")) {
                                        aValue = aValue.substring(0, aValue.length() - 1);
                                    }
                                } else {
                                    value = value + "%";
                                    if (!aValue.endsWith("%")) {
                                        aValue = aValue + "%";
                                    }
                                }
                            } else {
                                MsgBox.showWarning((Component)comp, (String)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"accountIsNull"));
                                SysUtil.abort();
                            }
                            cell.setValue((Object)value);
                            aCell.setValue((Object)aValue);
                            continue;
                        }
                        if (j != block2.getBeginCol()) continue;
                        cell = kdRel.getCell(i, j - 1);
                        aCell = kdRel.getCell(i, j);
                        value = BgControlRelUtils.getValue(cell);
                        aValue = BgControlRelUtils.getValue(aCell);
                        if (value != null) {
                            if (value.endsWith("%")) {
                                value = value.substring(0, value.length() - 1);
                                if (aValue.endsWith("%")) {
                                    aValue = aValue.substring(0, aValue.length() - 1);
                                }
                            } else {
                                value = value + "%";
                                if (!aValue.endsWith("%")) {
                                    aValue = aValue + "%";
                                }
                            }
                        } else {
                            MsgBox.showWarning((Component)comp, (String)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"accountIsNull"));
                            SysUtil.abort();
                        }
                        cell.setValue((Object)value);
                        aCell.setValue((Object)aValue);
                    }
                    for (int col = 0; col < kdRel.getColumnCount() / 2; col += 2) {
                        cell = kdRel.getCell(i, col);
                        aCell = kdRel.getCell(i, col + 1);
                        value = (String)cell.getValue();
                        aValue = (String)aCell.getValue();
                        bizNum = bizNum + value + "|";
                        bizAlias = bizAlias + aValue + "|";
                    }
                    if (isBudgetItem) continue;
                    bizNum = bizNum.substring(0, bizNum.length() - 1);
                    bizAlias = bizAlias.substring(0, bizAlias.length() - 1);
                    entryMap.remove(entry.getBizItemValue());
                    entry.setBizItemValue(bizNum);
                    entry.setBizItemAlias(bizAlias);
                    tmpEntry.setBizItemValue(bizNum);
                    tmpEntry.setBizItemAlias(bizAlias);
                    if (bizNum.indexOf("%") > 0) {
                        entry.setMatching(true);
                        tmpEntry.setMatching(true);
                    } else {
                        entry.setMatching(false);
                        tmpEntry.setMatching(false);
                    }
                    entryMap.put(bizNum, tmpEntry);
                }
            }
        }
    }

    public static void addItems(BgControlSchemeInfo controlScheme, BizDataObject bizProp, int dimensionGroup, KDTable kdRel) {
        if (controlScheme == null || bizProp == null || kdRel == null) {
            return;
        }
        IRow row = null;
        BgControlItemMapInfo bizItemMap = null;
        if (bizProp != null && bizProp.getValue() != null) {
            bizItemMap = controlScheme.getItemMap(bizProp.getValue(), dimensionGroup);
        } else {
            MsgBox.showWarning((String)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"checkRule.dimItem"));
            SysUtil.abort();
        }
        BgControlItemMapEntryInfo entry = null;
        if (bizItemMap == null) {
            bizItemMap = new BgControlItemMapInfo();
            bizItemMap.setBizProp(bizProp.getValue());
            bizItemMap.setDimensionGroup(dimensionGroup);
            controlScheme.getItemMaps().add(bizItemMap);
        }
        row = kdRel.addRow();
        entry = new BgControlItemMapEntryInfo();
        StringBuffer mbgItemValue = new StringBuffer();
        StringBuffer mbgItemAlias = new StringBuffer();
        int jn = kdRel.getColumnCount();
        for (int j = jn / 2; j < jn; j += 2) {
            mbgItemValue.append(BgNConstants.BLANK_STR + "|");
            mbgItemAlias.append(BgNConstants.BLANK_STR + "|");
        }
        mbgItemValue.deleteCharAt(mbgItemValue.length() - 1);
        mbgItemAlias.deleteCharAt(mbgItemAlias.length() - 1);
        StringBuffer bizItemValue = new StringBuffer();
        StringBuffer bizItemAlias = new StringBuffer();
        int jn2 = kdRel.getColumnCount() / 2;
        for (int j = 0; j < jn2; j += 2) {
            bizItemValue.append(BgNConstants.BLANK_STR + "|");
            bizItemAlias.append(BgNConstants.BLANK_STR + "|");
        }
        bizItemValue.deleteCharAt(bizItemValue.length() - 1);
        bizItemAlias.deleteCharAt(bizItemAlias.length() - 1);
        entry.setMatching(false);
        entry.setMbgItemValue(mbgItemValue.toString());
        entry.setMbgItemAlias(mbgItemAlias.toString());
        entry.setBizItemValue(bizItemValue.toString());
        entry.setBizItemAlias(bizItemAlias.toString());
        bizItemMap.getEntry().add(entry);
        row.setUserObject((Object)entry);
    }

    public static boolean checkHasEmptyRow(IRow row, int colCount) {
        if (row == null) {
            return true;
        }
        ICell cell = null;
        boolean hasCell = true;
        for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
            cell = row.getCell(colIndex, false);
            if (BgControlRelUtils.getValue(cell) == null) continue;
            hasCell = false;
            break;
        }
        return hasCell;
    }

    public static boolean checkItemMap(Component comp, BgControlSchemeInfo controlScheme, BizDataObject bizUnit, BizDataObject bizProp, int dimensionGroup, KDTable kdRel, String tipSource) throws Exception {
        if (bizUnit == null || kdRel == null) {
            return false;
        }
        kdRel.getEditManager().stopEditing();
        String[] itemObj = null;
        String[] colSign = null;
        String[] mbgItem = null;
        ArrayList<List<String[]>> bizItems = new ArrayList<List<String[]>>();
        ArrayList<String[]> nullObjs = new ArrayList<String[]>();
        List<String[]> items = null;
        String number = null;
        String alias = null;
        int rowCount = 0;
        int colCount = 0;
        int bizCount = kdRel.getColumnCount() / 4;
        IRow row = null;
        rowCount = kdRel.getRowCount();
        colCount = kdRel.getColumnCount();
        HashMap<Integer, String[]> colSignMap = new HashMap<Integer, String[]>();
        HashMap<Integer, Boolean> hasBgIndexMap = new HashMap<Integer, Boolean>();
        IColumn column = null;
        int count = kdRel.getColumnCount();
        for (int colIndex = 0; colIndex < count; ++colIndex) {
            column = kdRel.getColumn(colIndex);
            colSign = new String[3];
            colSign[BgControlRelUtils.INDEX_COL_TYPE] = BgControlRelUtils.getColPropInfo(column, BgControlConstants.PROP_TYPE);
            colSign[BgControlRelUtils.INDEX_COL_VALUE] = BgControlRelUtils.getColPropInfo(column, BgControlConstants.PROP_VALUE);
            colSign[BgControlRelUtils.INDEX_COL_ALIAS] = BgControlRelUtils.getColPropInfo(column, BgControlConstants.PROP_ALIAS);
            colSignMap.put(colIndex, colSign);
            hasBgIndexMap.put(colIndex, new Boolean(BgControlRelUtils.getColPropInfo(column, BgControlConstants.PROP_BGINDEX)));
        }
        boolean hasBgIndex = false;
        boolean hasBizNull = false;
        boolean hasMbgNull = false;
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            row = kdRel.getRow(rowIndex);
            if (BgControlRelUtils.checkHasEmptyRow(row, colCount)) continue;
            items = new ArrayList();
            for (int colIndex = 0; colIndex <= colCount; colIndex += 2) {
                colSign = (String[])colSignMap.get(colIndex);
                if (colSign == null) continue;
                hasBgIndex = (Boolean)hasBgIndexMap.get(colIndex);
                number = BgControlRelUtils.getValue(kdRel.getCell(rowIndex, colIndex));
                alias = BgControlRelUtils.getValue(kdRel.getCell(rowIndex, colIndex + 1));
                if (number != null && number.endsWith("%")) {
                    number = number.substring(0, number.indexOf("%"));
                }
                itemObj = new String[6];
                itemObj[BgControlRelUtils.INDEX_INDEX] = TableToolkit.xy2range((int)rowIndex, (int)colIndex);
                itemObj[BgControlRelUtils.INDEX_TYPE] = colSign[INDEX_COL_TYPE];
                itemObj[BgControlRelUtils.INDEX_PROP_VALUE] = colSign[INDEX_COL_VALUE];
                itemObj[BgControlRelUtils.INDEX_PROP_ALIAS] = colSign[INDEX_COL_ALIAS];
                itemObj[BgControlRelUtils.INDEX_NUMBER] = number;
                itemObj[BgControlRelUtils.INDEX_NAME] = alias;
                items.add(itemObj);
                if (number != null && alias != null || !hasBgIndex) continue;
                itemObj = new String[6];
                itemObj[BgControlRelUtils.INDEX_INDEX] = TableToolkit.xy2range((int)rowIndex, (int)colIndex);
                if (number == null) {
                    itemObj[BgControlRelUtils.INDEX_TYPE] = BgControlConstants.PROP_NUMBER;
                } else if (alias == null) {
                    itemObj[BgControlRelUtils.INDEX_TYPE] = BgControlConstants.PROP_NAME;
                }
                itemObj[BgControlRelUtils.INDEX_PROP_VALUE] = BgControlConstants.NULL_VALUE;
                itemObj[BgControlRelUtils.INDEX_PROP_ALIAS] = colSign[INDEX_COL_ALIAS];
                if (colSign[INDEX_COL_TYPE].equals(BgControlConstants.PROP_NUMBER) || colSign[INDEX_COL_TYPE].equals(BgControlConstants.PROP_NAME)) {
                    itemObj[BgControlRelUtils.INDEX_NUMBER] = BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"bizItemMap.bizItem");
                    continue;
                }
                if (!colSign[INDEX_COL_TYPE].equals(BgControlConstants.PROP_MBG_NUMBER) && !colSign[INDEX_COL_TYPE].equals(BgControlConstants.PROP_MBG_NAME)) continue;
                itemObj[BgControlRelUtils.INDEX_NUMBER] = BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"bizItemMap.mbgItem");
            }
            int in = bizCount;
            for (int i = 0; i < in; ++i) {
                itemObj = (String[])items.get(i);
                mbgItem = (String[])items.get(i + bizCount);
                hasBizNull = itemObj[INDEX_NUMBER] == null || itemObj[INDEX_NAME] == null;
                boolean bl = hasMbgNull = mbgItem[INDEX_NUMBER] == null || mbgItem[INDEX_NAME] == null;
                if (hasBizNull == hasMbgNull) continue;
                if (hasBizNull) {
                    if (itemObj[INDEX_NUMBER] == null) {
                        itemObj[BgControlRelUtils.INDEX_TYPE] = BgControlConstants.PROP_NUMBER;
                    } else if (itemObj[INDEX_NAME] == null) {
                        itemObj[BgControlRelUtils.INDEX_TYPE] = BgControlConstants.PROP_NAME;
                    }
                    itemObj[BgControlRelUtils.INDEX_PROP_VALUE] = BgControlConstants.NULL_VALUE;
                    itemObj[BgControlRelUtils.INDEX_NUMBER] = BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"bizItemMap.bizItem");
                    nullObjs.add(itemObj);
                    items.set(i, null);
                    continue;
                }
                if (!hasMbgNull) continue;
                if (mbgItem[INDEX_NUMBER] == null) {
                    mbgItem[BgControlRelUtils.INDEX_TYPE] = BgControlConstants.PROP_NUMBER;
                } else if (mbgItem[INDEX_NAME] == null) {
                    mbgItem[BgControlRelUtils.INDEX_TYPE] = BgControlConstants.PROP_NAME;
                }
                mbgItem[BgControlRelUtils.INDEX_PROP_VALUE] = BgControlConstants.NULL_VALUE;
                mbgItem[BgControlRelUtils.INDEX_NUMBER] = BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"bizItemMap.mbgItem");
                nullObjs.add(mbgItem);
                items.set(i + bizCount, null);
            }
            bizItems.add(items);
        }
        ArrayList<String[]> repObjs = new ArrayList<String[]>();
        List<Object> chkObjs = new ArrayList();
        ArrayList<List<String[]>> repItems = new ArrayList<List<String[]>>();
        if (!bizItems.isEmpty()) {
            String xyrange = null;
            String tmpIndex = null;
            String bizKey = null;
            HashMap<String, String> bizKeyMap = new HashMap<String, String>();
            int in = bizItems.size();
            for (int i = 0; i < in; ++i) {
                items = (List)bizItems.get(i);
                bizKey = "";
                int jn = items.size();
                for (int j = 0; j < jn; ++j) {
                    itemObj = (String[])items.get(j);
                    if (itemObj == null) continue;
                    if (BgControlConstants.PROP_NUMBER.equals(itemObj[INDEX_TYPE])) {
                        bizKey = itemObj[INDEX_NUMBER] == null ? bizKey + BgNConstants.BLANK_STR + "|" : (itemObj[INDEX_NUMBER].endsWith("%") ? bizKey + itemObj[INDEX_NUMBER].substring(0, itemObj[INDEX_NUMBER].indexOf("%")) + "|" : bizKey + itemObj[INDEX_NUMBER] + "|");
                    }
                    xyrange = itemObj[INDEX_INDEX];
                }
                if (bizKey.length() > 0) {
                    bizKey = bizKey.substring(0, bizKey.length() - 1);
                }
                if (bizKeyMap.containsKey(bizKey)) {
                    tmpIndex = (String)bizKeyMap.get(bizKey);
                    itemObj = new String[4];
                    itemObj[BgControlRelUtils.INDEX_INDEX] = xyrange;
                    itemObj[1] = BgControlConstants.PROP_NAME;
                    itemObj[2] = BgControlConstants.REPEAT_VALUE;
                    itemObj[3] = tmpIndex;
                    repObjs.add(itemObj);
                    repItems.add(items);
                    continue;
                }
                bizKeyMap.put(bizKey, xyrange);
            }
            if (!repItems.isEmpty()) {
                bizItems.removeAll(repItems);
            }
            chkObjs = BgControlRelUtils.checkBizItemNumber(bizUnit, bizItems, kdRel);
        }
        if (!(nullObjs.isEmpty() && repItems.isEmpty() && chkObjs.isEmpty())) {
            ArrayList<Object> errObjs = new ArrayList<Object>();
            errObjs.addAll(nullObjs);
            errObjs.addAll(repObjs);
            errObjs.addAll(chkObjs);
            Collections.sort(errObjs, new Comparator<String[]>(){

                @Override
                public int compare(String[] o1, String[] o2) {
                    return o1[0].compareTo(o2[0]);
                }
            });
            Object[] tmpStrs = null;
            StringBuffer message = new StringBuffer();
            int in = errObjs.size();
            for (int i = 0; i < in; ++i) {
                itemObj = (String[])errObjs.get(i);
                if (itemObj[2].equals(BgControlConstants.NULL_VALUE)) {
                    tmpStrs = new String[3];
                    tmpStrs[BgControlRelUtils.INDEX_INDEX] = String.valueOf(TableToolkit.range2xy((String)itemObj[BgControlRelUtils.INDEX_INDEX]).x1 + 1);
                    tmpStrs[1] = itemObj[4];
                    tmpStrs[2] = itemObj[3];
                    if (itemObj[1].equals(BgControlConstants.PROP_NUMBER)) {
                        message.append(BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"save.error.numberisnull", (Object[])tmpStrs));
                    } else if (itemObj[1].equals(BgControlConstants.PROP_NAME)) {
                        message.append(BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"save.error.nameisnull", (Object[])tmpStrs));
                    }
                } else if (itemObj[2].equals(BgControlConstants.REPEAT_VALUE)) {
                    tmpStrs = new String[2];
                    tmpStrs[BgControlRelUtils.INDEX_INDEX] = String.valueOf(TableToolkit.range2xy((String)itemObj[BgControlRelUtils.INDEX_INDEX]).x1 + 1);
                    tmpStrs[1] = String.valueOf(TableToolkit.range2xy((String)itemObj[3]).x1 + 1);
                    message.append(BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"save.error.numberrepeat", (Object[])tmpStrs));
                } else if (itemObj[2].equals(BgControlConstants.REPEAT_EXIST_VALUE)) {
                    tmpStrs = new String[2];
                    tmpStrs[BgControlRelUtils.INDEX_INDEX] = String.valueOf(TableToolkit.range2xy((String)itemObj[BgControlRelUtils.INDEX_INDEX]).x1 + 1);
                    message.append(BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"save.error.numberexistrepeat", (Object[])tmpStrs));
                } else if (itemObj[2].equals(BgControlConstants.NOEXISTS_VALUE)) {
                    tmpStrs = new String[3];
                    tmpStrs[BgControlRelUtils.INDEX_INDEX] = String.valueOf(TableToolkit.range2xy((String)itemObj[BgControlRelUtils.INDEX_INDEX]).x1 + 1);
                    tmpStrs[1] = itemObj[3];
                    tmpStrs[2] = itemObj[4];
                    message.append(BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"save.error.numbernoexists", (Object[])tmpStrs));
                }
                message.append(";\n");
            }
            tmpStrs = message.toString().split("\n");
            MsgBox.showDetailAndOK((Component)comp, (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlSettingResource", (String)tipSource), (String)message.toString(), (int)1);
            return false;
        }
        return true;
    }

    public static void storeItemMap(BgControlSchemeInfo controlScheme, BizDataObject bizProp, int dimensionGroup, KDTable kdRel) {
        int rowIndex;
        if (controlScheme == null || bizProp == null || kdRel == null) {
            return;
        }
        BgControlItemMapInfo itemMap = controlScheme.getItemMap(bizProp.getValue(), dimensionGroup);
        if (itemMap == null) {
            return;
        }
        BgControlItemMapEntryCollection coll = itemMap.getEntry();
        BgControlItemMapEntryCollection remove = new BgControlItemMapEntryCollection();
        BgControlItemMapEntryInfo entry = null;
        int mbgItemIndex = kdRel.getColumnCount() / 2;
        int rowCount = kdRel.getRowCount();
        int colCount = kdRel.getColumnCount();
        IRow row = null;
        String bizNum = null;
        String bizAlias = null;
        String mbgNum = null;
        String mbgAlias = null;
        StringBuffer bizNumBuf = new StringBuffer();
        StringBuffer bizAliasBuf = new StringBuffer();
        StringBuffer mbgNumBuf = new StringBuffer();
        StringBuffer mbgAliasBuf = new StringBuffer();
        for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            row = kdRel.getRow(rowIndex);
            entry = row.getUserObject() instanceof BgControlItemMapEntryInfo ? (BgControlItemMapEntryInfo)row.getUserObject() : coll.get(rowIndex);
            if (BgControlRelUtils.checkHasEmptyRow(row, colCount)) {
                remove.add(entry);
                continue;
            }
            bizNumBuf.setLength(0);
            bizAliasBuf.setLength(0);
            mbgNumBuf.setLength(0);
            mbgAliasBuf.setLength(0);
            for (int bizIndex = 0; bizIndex < mbgItemIndex; bizIndex += 2) {
                bizNum = BgControlRelUtils.getValue(kdRel.getCell(rowIndex, bizIndex));
                bizNum = StringUtils.isEmpty((String)bizNum) ? BgNConstants.BLANK_STR : bizNum;
                bizAlias = BgControlRelUtils.getValue(kdRel.getCell(rowIndex, bizIndex + 1));
                bizAlias = StringUtils.isEmpty((String)bizAlias) ? BgNConstants.BLANK_STR : bizAlias;
                bizNumBuf.append(bizNum).append("|");
                bizAliasBuf.append(bizAlias).append("|");
            }
            bizNumBuf.deleteCharAt(bizNumBuf.length() - 1);
            bizAliasBuf.deleteCharAt(bizAliasBuf.length() - 1);
            if (bizAliasBuf.length() > 256) {
                MsgBox.showWarning((String)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"save.error.nameoverlength", (Object[])new Object[]{rowIndex + 1}));
                SysUtil.abort();
            }
            for (int mbgIndex = mbgItemIndex; mbgIndex < kdRel.getColumnCount(); mbgIndex += 2) {
                mbgNum = BgControlRelUtils.getValue(kdRel.getCell(rowIndex, mbgIndex));
                mbgNum = StringUtils.isEmpty((String)mbgNum) ? BgNConstants.BLANK_STR : mbgNum;
                mbgAlias = BgControlRelUtils.getValue(kdRel.getCell(rowIndex, mbgIndex + 1));
                mbgAlias = StringUtils.isEmpty((String)mbgAlias) ? BgNConstants.BLANK_STR : mbgAlias;
                mbgNumBuf.append(mbgNum).append("|");
                mbgAliasBuf.append(mbgAlias).append("|");
            }
            mbgNumBuf.deleteCharAt(mbgNumBuf.length() - 1);
            mbgAliasBuf.deleteCharAt(mbgAliasBuf.length() - 1);
            entry.setBizItemValue(bizNumBuf.toString());
            entry.setBizItemAlias(bizAliasBuf.toString());
            entry.setMbgItemValue(mbgNumBuf.toString());
            entry.setMbgItemAlias(mbgAliasBuf.toString());
        }
        if (!remove.isEmpty()) {
            int in = remove.size();
            for (int i = 0; i < in; ++i) {
                coll.remove(remove.get(i));
            }
        }
        for (rowIndex = kdRel.getRowCount() - 1; rowIndex >= 0; --rowIndex) {
            row = kdRel.getRow(rowIndex);
            if (!BgControlRelUtils.checkHasEmptyRow(row, colCount)) continue;
            kdRel.removeRow(rowIndex);
        }
    }

    public static void clearAss() {
        treeUtils.clearAss();
    }
}

