/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgControlSchemeInfo;
import com.kingdee.eas.ma.control.face.ICalcBalance;
import com.kingdee.eas.ma.control.face.IControlParameter;
import com.kingdee.eas.ma.control.face.IControlRecord;
import com.kingdee.eas.ma.control.impl.BgAfterBuildControlParamUtils;
import com.kingdee.eas.ma.control.impl.CalcBalance;
import com.kingdee.eas.ma.control.impl.ControlRecord;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.control.utils.BgControlIsomerUtils;
import com.kingdee.eas.ma.control.utils.BgControlParamUtils;
import com.kingdee.eas.ma.control.utils.BgControlUtils;
import com.kingdee.eas.ma.control.utils.BgCurrencyMappingUtils;
import com.kingdee.eas.ma.control.utils.ControlSchemeUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public abstract class AbstractControlImpl {
    protected void queryBalance(Context ctx, List<BgControlParam> params, IControlParameter parameter) throws Exception {
        ICalcBalance calc = CalcBalance.getIntance(true);
        calc.calcBalance(ctx, parameter, params);
    }

    protected List<BgControlParam> buildParam(Context ctx, BOSUuid billId, IControlParameter parameter) throws BOSException, EASBizException {
        List<BgControlParam> params = null;
        if (parameter.getBgControlIsomer() != null) {
            String bizUnit = BgControlIsomerUtils.getBizUnit(ctx, parameter);
            String OUID = BgControlIsomerUtils.getBillOUID(ctx, bizUnit, parameter);
            parameter.setBizUnit(bizUnit);
            parameter.setOUID(OUID);
            BgControlIsomerUtils.fillOUInfo(ctx, parameter);
            BgControlSchemeInfo schemeInfo = ControlSchemeUtils.getInstance().queryControlScheme(ctx, parameter, bizUnit, parameter.getOUInfo().getName(), true, parameter.getLogicParameter().isCheckBalance());
            if (schemeInfo == null) {
                parameter.getResult().setResult(3);
                return null;
            }
            parameter.setControlScheme(schemeInfo);
            params = this.builderControlParam(ctx, billId, schemeInfo, parameter);
        } else {
            String bizUnit = BgControlUtils.getBizUnit(ctx, billId);
            String OUID = BgControlUtils.getBillOUID(ctx, bizUnit, billId);
            parameter.setBizUnit(bizUnit);
            parameter.setOUID(OUID);
            BgControlUtils.fillOUInfo(ctx, parameter);
            BgControlSchemeInfo schemeInfo = ControlSchemeUtils.getInstance().queryControlScheme(ctx, billId, bizUnit, OUID, parameter.getOUInfo().getName(), true, parameter.getLogicParameter().isCheckBalance());
            if (schemeInfo == null) {
                parameter.getResult().setResult(3);
                return null;
            }
            parameter.setControlScheme(schemeInfo);
            params = this.builderControlParam(ctx, billId, schemeInfo, parameter);
        }
        return params;
    }

    protected List<BgControlParam> buildParam(Context ctx, IObjectValue model, IControlParameter parameter) throws BOSException, EASBizException {
        String bizUnit = BgControlUtils.getBizUnit(ctx, model);
        String OUID = BgControlUtils.getBillOUID(ctx, bizUnit, model);
        parameter.setBizUnit(bizUnit);
        parameter.setOUID(OUID);
        BgControlUtils.fillOUInfo(ctx, parameter);
        BgControlSchemeInfo schemeInfo = ControlSchemeUtils.getInstance().queryControlScheme(ctx, model, bizUnit, OUID, parameter.getOUInfo().getName(), true, parameter.getLogicParameter().isCheckBalance());
        if (schemeInfo == null || !schemeInfo.check()) {
            parameter.getResult().setResult(3);
            return null;
        }
        parameter.setControlScheme(schemeInfo);
        List<BgControlParam> params = this.builderControlParam(ctx, model, schemeInfo, parameter);
        return params;
    }

    protected List<BgControlParam> builderControlParam(Context ctx, BOSUuid billId, BgControlSchemeInfo controlScheme, IControlParameter parameter) throws BOSException, EASBizException {
        List<BgControlParam> params = null;
        params = parameter.getBgControlIsomer() != null ? BgControlParamUtils.getInterace().getControlParam(ctx, controlScheme, parameter) : BgControlParamUtils.getInterace().getControlParam(ctx, billId, controlScheme, parameter);
        this.queryOrgEntrust(ctx, params);
        BgCurrencyMappingUtils.transCurrency(ctx, params);
        this.afterBuildControlParam(ctx, params);
        return params;
    }

    protected void afterBuildControlParam(Context ctx, List<BgControlParam> params) {
        BgAfterBuildControlParamUtils.after(ctx, params);
        BgControlParamUtils.checkBizUnit(ctx, params);
    }

    protected List<BgControlParam> builderControlParam(Context ctx, IObjectValue model, BgControlSchemeInfo controlScheme, IControlParameter parameter) throws BOSException, EASBizException {
        List<BgControlParam> params = BgControlParamUtils.getInterace().getControlParam(ctx, model, controlScheme, parameter);
        this.queryOrgEntrust(ctx, params);
        BgCurrencyMappingUtils.transCurrency(ctx, params);
        this.afterBuildControlParam(ctx, params);
        return params;
    }

    protected List<BgControlParam> buildParam(Context ctx, BOSUuid bgSchemeId, BOSUuid orgUnitId, List<String> formulas, IControlParameter parameter, boolean isBgExcuteAnaly) throws BOSException, EASBizException {
        List<BgControlParam> params = this.builderControlParam(ctx, bgSchemeId, orgUnitId, formulas, parameter, isBgExcuteAnaly);
        return params;
    }

    protected List<BgControlParam> builderControlParam(Context ctx, BOSUuid bgSchemeId, BOSUuid orgUnitId, List<String> formulas, IControlParameter parameter, boolean isBgExcuteAnaly) throws BOSException, EASBizException {
        List<BgControlParam> params = BgControlParamUtils.getInterace().getControlParam(ctx, bgSchemeId, orgUnitId, formulas, parameter, isBgExcuteAnaly, true);
        return params;
    }

    protected List<BgControlParam> builderControlParam(Context ctx, BOSUuid bgSchemeId, List<String> formulas, IControlParameter parameter, boolean isBgExcuteAnaly) throws BOSException, EASBizException {
        List<BgControlParam> params = BgControlParamUtils.getInterace().getControlParam(ctx, bgSchemeId, null, formulas, parameter, isBgExcuteAnaly, false);
        return params;
    }

    protected List<BgControlParam> builderControlParam(Context ctx, BOSUuid bgSchemeId, List<String> formulas, IControlParameter parameter, boolean isBgExcuteAnaly, boolean isALarm) throws BOSException, EASBizException {
        List<BgControlParam> params = BgControlParamUtils.getInterace().getControlParam(ctx, bgSchemeId, null, formulas, parameter, isBgExcuteAnaly, false, isALarm);
        return params;
    }

    protected void writeControlRecord(Context ctx, IControlParameter parameter, List<BgControlParam> params) throws Exception {
        IControlRecord record = ControlRecord.getIntance();
        record.writeControlRecord(ctx, parameter, params);
    }

    protected void queryOrgEntrust(Context ctx, List<BgControlParam> params) throws BOSException, EASBizException {
        if (ctx == null || params == null) {
            throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        }
        if (params.isEmpty()) {
            return;
        }
        boolean hasEntrust = false;
        String orgUnitId = null;
        String dimNumber = null;
        String number = null;
        String sql = null;
        String[] tmpStrs = null;
        OrgUnitInfo orgUnitInfo = null;
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("select t.FBgEntrustOrgUnitID, cc.FNumber, cc.FName_" + ctx.getLocale() + ", cc.FLongNumber ,cc.fdisplayName_" + ctx.getLocale() + " displayName from T_MBG_BgControlOrgEntrust t join T_MBG_BgAccountSort s on t.FBgIndexSortID = s.FID join T_MBG_BgAccount c on s.FID = c.FBgAccountSortID join T_ORG_CostCenter cc on t.FBgEntrustOrgUnitID = cc.FID where t.FBgOrgUnitID = ? and c.FNumber = ? and t.FBeginTime <= ? and t.FEndTime >= ? ");
        sql = sqlStr.toString();
        String sql1 = "select t.FBgEntrustOrgUnitID, cc.FNumber, cc.FName_" + ctx.getLocale() + ", cc.FLongNumber ,cc.fdisplayName_" + ctx.getLocale() + " displayName from T_MBG_BgControlOrgEntrust t join T_ORG_CostCenter cc on t.FBgEntrustOrgUnitID = cc.FID where t.FBgOrgUnitID = ? and t.FBgIndexSortID is null and t.FBeginTime <= ? and t.FEndTime >= ? ";
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select top 1 FID from T_MBG_BgControlOrgEntrust");
            if (rst.next()) {
                hasEntrust = true;
            }
            SQLUtils.cleanup((ResultSet)rst);
            if (hasEntrust) {
                for (BgControlParam param : params) {
                    orgUnitId = param.getOrgUnit().getId().toString();
                    dimNumber = param.getBgIndexNumber();
                    tmpStrs = dimNumber.split(":");
                    if (tmpStrs == null || tmpStrs.length <= 1) continue;
                    number = tmpStrs[1];
                    try {
                        rst = BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new Object[]{orgUnitId, number, param.getBizDate(), param.getBizDate()});
                        if (rst.next()) {
                            orgUnitInfo = new OrgUnitInfo();
                            orgUnitInfo.setId(BOSUuid.read((String)rst.getString("FBgEntrustOrgUnitID")));
                            orgUnitInfo.setNumber(rst.getString("FNumber"));
                            orgUnitInfo.setName(rst.getString("FName_" + ctx.getLocale()));
                            orgUnitInfo.setLongNumber(rst.getString("FLongNumber"));
                            orgUnitInfo.setDisplayName(rst.getString("displayName"));
                            param.setOrgUnit(orgUnitInfo);
                            param.setQueryOrgEntrust(true);
                        } else {
                            orgUnitInfo = null;
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                        if (orgUnitInfo != null) continue;
                        rst = BgDBUtils.executeQuery((Connection)conn, (String)sql1, (Object[])new Object[]{orgUnitId, param.getBizDate(), param.getBizDate()});
                        if (rst.next()) {
                            orgUnitInfo = new OrgUnitInfo();
                            orgUnitInfo.setId(BOSUuid.read((String)rst.getString("FBgEntrustOrgUnitID")));
                            orgUnitInfo.setNumber(rst.getString("FNumber"));
                            orgUnitInfo.setName(rst.getString("FName_" + ctx.getLocale()));
                            orgUnitInfo.setLongNumber(rst.getString("FLongNumber"));
                            orgUnitInfo.setDisplayName(rst.getString("displayName"));
                            param.setOrgUnit(orgUnitInfo);
                            param.setQueryOrgEntrust(true);
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                    catch (SQLException ex) {
                        throw new BgControlException(BgControlException.DATABASEEXCEPTION, new Object[]{ex.getMessage()});
                    }
                    finally {
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgControlException(BgControlException.DATABASEEXCEPTION, new Object[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
    }
}

