/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.MbgMemberNodeCollection;
import com.kingdee.eas.ma.base.MbgMemberNodeFactory;
import com.kingdee.eas.ma.base.MbgViewCollection;
import com.kingdee.eas.ma.base.MbgViewFactory;
import com.kingdee.eas.ma.base.MbgViewInfo;
import com.kingdee.eas.ma.base.MemberSegregationRuleEnum;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgControlSetSchemeInfo;
import com.kingdee.eas.ma.control.BgControlSettingInfo;
import com.kingdee.eas.ma.control.BgCtrlPeriodTypeEnum;
import com.kingdee.eas.ma.control.BgCtrlSetRuleEnum;
import com.kingdee.eas.ma.control.BgCtrlTypeEnum;
import com.kingdee.eas.ma.control.face.ICalcBalance;
import com.kingdee.eas.ma.control.face.IControlParameter;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.control.impl.models.BgGroupData;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.ma.control.utils.BgControlTransitUtils;
import com.kingdee.eas.ma.control.utils.BgControlUtils;
import com.kingdee.eas.ma.control.utils.BizExpandUtils;
import com.kingdee.eas.ma.mbg.BgDimensionFacadeFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IBgDimensionFacade;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.common.IBgDimData;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimension;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionBase;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.impl.DimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.dimension.vo.DimensionObject;
import com.kingdee.eas.ma.mbg.dimension.vo.MemberObject;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CalcBalance
implements ICalcBalance {
    private static Logger logger = Logger.getLogger(CalcBalance.class);
    private boolean isControl = true;
    private Map<String, Map<BOSUuid, BgControlSettingInfo>> groupSetMap = new HashMap<String, Map<BOSUuid, BgControlSettingInfo>>();
    private Map<String, List<String>> bgPeriodCacheMap = new HashMap<String, List<String>>();
    private int KEY_INDEX_SCHEMEID = 0;
    private int KEY_INDEX_ORGUNITID = 1;
    private int KEY_INDEX_FISCALYEAR = 2;
    private int KEY_INDEX_TIME = 3;
    private Map<String, Boolean> equalsDimMap = new HashMap<String, Boolean>();

    @Override
    public void setControl(boolean isControl) {
        this.isControl = isControl;
    }

    @Override
    public boolean isControl() {
        return this.isControl;
    }

    public static synchronized ICalcBalance getIntance(boolean isControl) {
        CalcBalance face = new CalcBalance();
        face.setControl(isControl);
        return face;
    }

    protected Map<String, Map<BOSUuid, BgControlSettingInfo>> getGroupSetMap() {
        return this.groupSetMap;
    }

    protected Map<String, List<String>> getBgPeriodCacheMap() {
        return this.bgPeriodCacheMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void calcBalance(Context ctx, IControlParameter parameter, List<BgControlParam> params) throws Exception {
        if (ctx == null || parameter == null || params == null) {
            throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            BgControlUtils.queryBgScheme(ctx, parameter, params);
            if (parameter.getLogicParameter().isCheckBalance()) {
                BizExpandUtils bizExpandUtils = new BizExpandUtils(parameter.getControlScheme());
                bizExpandUtils.matchExandControl(params);
                this.queryControlSet(ctx, conn, parameter, params);
                bizExpandUtils.checkExpandGroup(ctx, conn, parameter, params);
                this.checkMember(ctx, conn, parameter, params);
                this.queryBalance(ctx, parameter, params);
                bizExpandUtils.expandControl(ctx, parameter, params);
                bizExpandUtils.removeExpandControl(params);
            }
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public static String getControlSetKey(BgControlSettingInfo controlSetting) {
        return controlSetting.getCtrlType().getValue() + "," + controlSetting.getPeriodType().getValue() + "," + controlSetting.getCtrlSetRule().getValue();
    }

    private BigDecimal addBigDecimal(BigDecimal result, BigDecimal value) {
        return BgNFSHelper.addBigDecimal((BigDecimal)result, (BigDecimal)value);
    }

    private void queryControlSet(Context ctx, Connection conn, IControlParameter parameter, List<BgControlParam> params) throws BOSException, EASBizException {
        if (ctx == null || parameter == null || params == null) {
            throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        }
        HashMap batchMap = new HashMap();
        List<BgControlParam> batchParams = null;
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            BgControlParam param = params.get(i);
            if (param.getBgSchemeInfo() == null) continue;
            String batchKey = this.getControlSchemeKey(param);
            if (batchMap.containsKey(batchKey)) {
                batchParams = (List)batchMap.get(batchKey);
            } else {
                batchParams = new ArrayList();
                batchMap.put(batchKey, batchParams);
            }
            batchParams.add(param);
        }
        for (Map.Entry entry : batchMap.entrySet()) {
            String[] keys = ((String)entry.getKey()).split("_");
            this.queryControlSet(ctx, conn, keys, (List<BgControlParam>)((List)entry.getValue()));
        }
    }

    private String getControlSchemeKey(BgControlParam param) {
        return new String(param.getBgSchemeInfo().getId() + "_" + param.getOrgUnit().getId() + "_" + param.getBgPeriodGroup().getFiscalYear().getValue() + "_" + param.getBizDate().getTime());
    }

    private void queryControlSet(Context ctx, Connection conn, String[] keyParams, List<BgControlParam> batchParams) throws BOSException, EASBizException {
        if (ctx == null || conn == null || StringUtils.isEmpty((String)keyParams[this.KEY_INDEX_SCHEMEID]) || StringUtils.isEmpty((String)keyParams[this.KEY_INDEX_ORGUNITID]) || StringUtils.isEmpty((String)keyParams[this.KEY_INDEX_FISCALYEAR]) || StringUtils.isEmpty((String)keyParams[this.KEY_INDEX_TIME]) || batchParams == null) {
            throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        }
        int size = batchParams.size();
        int count = (size - 1) / 50 + 1;
        int pos = 0;
        CalendarHelper helper = new CalendarHelper((java.util.Date)new Date(Long.parseLong(keyParams[this.KEY_INDEX_TIME])));
        helper.processClearTime();
        Date date = new Date(helper.getTime().getTime());
        int fiscalYear = Integer.parseInt(keyParams[this.KEY_INDEX_FISCALYEAR]);
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FID as TID,t.FBeginTime as bTime,t.FEndTime as eTime, s.FID, s.FBgIndexNumber, s.FBgIndexName, s.FBgDimNumber, s.FBgDimName, s.FBgScenNumber, s.FCtrlType, s.FIsAllowaccess, s.FPeriodType, s.FFlexParam, s.FIsGroupCtrl, s.FGroupNo, s.FCtrlSetRule from T_MBG_BgControlSetScheme t join T_MBG_BgControlSetting s on t.FID = s.FSchemeID where t.FSchemeId = ? and t.FiscalYear = ? and t.FBeginTime <= ? and t.FEndTime >= ? and s.FOrgUnitID = ? and s.FBgIndexNumber IN (");
        for (int i = 1; i < 50; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        HashMap conSetMap = new HashMap();
        List<BgControlSettingInfo> conSetList = null;
        BgControlSettingInfo setting = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            int i;
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, keyParams[this.KEY_INDEX_SCHEMEID]);
            pstmt.setInt(2, fiscalYear);
            pstmt.setDate(3, date);
            pstmt.setDate(4, date);
            pstmt.setString(5, keyParams[this.KEY_INDEX_ORGUNITID]);
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= 50) {
                    if (pos < size) {
                        pstmt.setString(x + 5, batchParams.get(pos).getBgIndexNumber());
                    } else {
                        pstmt.setString(x + 5, BgControlConstants.noFindStr);
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    setting = new BgControlSettingInfo();
                    setting.setScheme(new BgControlSetSchemeInfo());
                    setting.getScheme().setId(BOSUuid.read((String)rst.getString("TID")));
                    setting.getScheme().setBeginTime(rst.getTimestamp("bTime"));
                    setting.getScheme().setEndTime(rst.getTimestamp("eTime"));
                    setting.setId(BOSUuid.read((String)rst.getString("FID")));
                    setting.setBgIndexNumber(rst.getString("FBgIndexNumber"));
                    setting.setBgIndexName(rst.getString("FBgIndexName"));
                    setting.setBgDimNumber(rst.getString("FBgDimNumber"));
                    setting.setBgDimName(rst.getString("FBgDimName"));
                    setting.setBgScenNumber(rst.getString("FBgScenNumber"));
                    setting.setCtrlType(BgCtrlTypeEnum.getEnum(rst.getInt("FCtrlType")));
                    setting.setIsAllowAccess(rst.getBoolean("FIsAllowaccess"));
                    setting.setPeriodType(BgCtrlPeriodTypeEnum.getEnum(rst.getInt("FPeriodType")));
                    setting.setFlexParam(rst.getBigDecimal("FFlexParam"));
                    setting.setIsGroupCtrl(rst.getBoolean("FIsGroupCtrl"));
                    setting.setGroupNo(rst.getString("FGroupNo"));
                    setting.setCtrlSetRule(BgCtrlSetRuleEnum.getEnum(rst.getInt("FCtrlSetRule")));
                    setting.parseBgDimNumber();
                    setting.parsePriority();
                    if (conSetMap.containsKey(setting.getBgIndexNumber())) {
                        conSetList = (List)conSetMap.get(setting.getBgIndexNumber());
                    } else {
                        conSetList = new ArrayList();
                        conSetMap.put(setting.getBgIndexNumber(), conSetList);
                    }
                    conSetList.add(setting);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup(rst, (Statement)pstmt);
            BgControlParam param = null;
            if (!conSetMap.isEmpty()) {
                String[] tmpStrs = null;
                String[] tmpSrc = null;
                ArrayList<String> dimMember = new ArrayList<String>();
                ArrayList<String> src = new ArrayList<String>();
                int in = batchParams.size();
                for (int i2 = 0; i2 < in; ++i2) {
                    int j;
                    int jn;
                    param = batchParams.get(i2);
                    src.clear();
                    dimMember.clear();
                    tmpStrs = param.getDimItemNumber().split("\\,");
                    if (tmpStrs != null) {
                        jn = tmpStrs.length;
                        for (j = 0; j < jn; ++j) {
                            dimMember.add(tmpStrs[j]);
                            tmpSrc = tmpStrs[j].split(":");
                            if (tmpSrc == null) continue;
                            src.add(tmpSrc[0]);
                        }
                    }
                    if (conSetMap.containsKey(param.getBgIndexNumber())) {
                        conSetList = (ArrayList)conSetMap.get(param.getBgIndexNumber());
                        jn = conSetList.size();
                        for (j = 0; j < jn; ++j) {
                            setting = (BgControlSettingInfo)conSetList.get(j);
                            if (!StringUtils.isEmpty((String)setting.getBgScenNumber()) && !param.getBgScenario().getNumber().equals(setting.getBgScenNumber()) || !src.containsAll(setting.getDimSrcs())) continue;
                            if (dimMember.size() == setting.getDimMembers().size()) {
                                if (!dimMember.containsAll(setting.getDimMembers())) continue;
                                if (param.getControlSetting() == null) {
                                    param.setControlSetting(setting);
                                    continue;
                                }
                                if (setting.getPriority() <= param.getControlSetting().getPriority()) continue;
                                param.setControlSetting(setting);
                                continue;
                            }
                            if (!dimMember.containsAll(setting.getDimMembers())) continue;
                            if (param.getControlSetting() == null) {
                                param.setControlSetting(setting);
                                continue;
                            }
                            if (setting.getPriority() <= param.getControlSetting().getPriority()) continue;
                            param.setControlSetting(setting);
                        }
                    }
                    if (param.getControlSetting() != null) continue;
                    param.setControlSetting(BgControlSettingInfo.getNoCtrlSet());
                }
            } else {
                int in = batchParams.size();
                for (int i3 = 0; i3 < in; ++i3) {
                    param = batchParams.get(i3);
                    param.setControlSetting(BgControlSettingInfo.getNoCtrlSet());
                }
            }
            HashMap groupNoMap = new HashMap();
            Set<String> groupNoSet = null;
            int in = batchParams.size();
            for (i = 0; i < in; ++i) {
                param = batchParams.get(i);
                if (!param.getControlSetting().isIsGroupCtrl() || StringUtils.isEmpty((String)param.getControlSetting().getGroupNo())) continue;
                if (groupNoMap.containsKey(param.getControlSetting().getScheme().getId())) {
                    groupNoSet = (Set)groupNoMap.get(param.getControlSetting().getScheme().getId());
                } else {
                    groupNoSet = new HashSet();
                    groupNoMap.put(param.getControlSetting().getScheme().getId(), groupNoSet);
                }
                groupNoSet.add(param.getControlSetting().getGroupNo());
            }
            if (!groupNoMap.isEmpty()) {
                sql = new StringBuffer();
                sql.append("select t.FBeginTime as bTime,t.FEndTime as eTime, s.FID, s.FBgIndexNumber, s.FBgIndexName, s.FBgDimNumber, s.FBgDimName, s.FBgScenNumber, s.FCtrlType, s.FIsAllowaccess, s.FPeriodType, s.FFlexParam, s.FIsGroupCtrl, s.FGroupNo, s.FCtrlSetRule from T_MBG_BgControlSetScheme t join T_MBG_BgControlSetting s on t.FID = s.FSchemeID where s.FSchemeID = ? and s.FOrgUnitId = ?  and  s.FGroupNo IN (");
                for (i = 1; i < 50; ++i) {
                    sql.append("?,");
                }
                sql.append("?)");
                Map.Entry entry2 = null;
                BOSUuid setSchemeId = null;
                ArrayList tmpGroup = null;
                Map<Object, Object> tmpSetMap = null;
                String _setSchemeId = null;
                String groupKey = null;
                pstmt = conn.prepareStatement(sql.toString());
                for (Map.Entry entry2 : groupNoMap.entrySet()) {
                    setSchemeId = (BOSUuid)entry2.getKey();
                    groupNoSet = (Set)entry2.getValue();
                    _setSchemeId = setSchemeId.toString();
                    tmpGroup = new ArrayList(groupNoSet);
                    size = tmpGroup.size();
                    count = (size - 1) / 50 + 1;
                    pos = 0;
                    for (int index = 0; index < count; ++index) {
                        pstmt.setString(1, _setSchemeId);
                        pstmt.setString(2, keyParams[this.KEY_INDEX_ORGUNITID]);
                        int x = 1;
                        while (x <= 50) {
                            if (pos < size) {
                                pstmt.setString(x + 2, (String)tmpGroup.get(pos));
                            } else {
                                pstmt.setString(x + 2, BgControlConstants.noFindStr);
                            }
                            ++x;
                            ++pos;
                        }
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            setting = new BgControlSettingInfo();
                            setting.setScheme(new BgControlSetSchemeInfo());
                            setting.getScheme().setId(setSchemeId);
                            setting.getScheme().setBeginTime(rst.getTimestamp("bTime"));
                            setting.getScheme().setEndTime(rst.getTimestamp("eTime"));
                            setting.setId(BOSUuid.read((String)rst.getString("FID")));
                            setting.setBgIndexNumber(rst.getString("FBgIndexNumber"));
                            setting.setBgIndexName(rst.getString("FBgIndexName"));
                            setting.setBgDimNumber(rst.getString("FBgDimNumber"));
                            setting.setBgDimName(rst.getString("FBgDimName"));
                            setting.setCtrlType(BgCtrlTypeEnum.getEnum(rst.getInt("FCtrlType")));
                            setting.setIsAllowAccess(rst.getBoolean("FIsAllowaccess"));
                            setting.setPeriodType(BgCtrlPeriodTypeEnum.getEnum(rst.getInt("FPeriodType")));
                            setting.setFlexParam(rst.getBigDecimal("FFlexParam"));
                            setting.setIsGroupCtrl(rst.getBoolean("FIsGroupCtrl"));
                            setting.setGroupNo(rst.getString("FGroupNo"));
                            setting.setCtrlSetRule(BgCtrlSetRuleEnum.getEnum(rst.getInt("FCtrlSetRule")));
                            groupKey = BgControlParam.getControlGroupKey(_setSchemeId, keyParams[this.KEY_INDEX_ORGUNITID], setting.getGroupNo());
                            if (this.getGroupSetMap().containsKey(groupKey)) {
                                tmpSetMap = this.getGroupSetMap().get(groupKey);
                            } else {
                                tmpSetMap = new HashMap();
                                this.getGroupSetMap().put(groupKey, tmpSetMap);
                            }
                            if (tmpSetMap.containsKey(setting.getId())) continue;
                            tmpSetMap.put(setting.getId(), setting);
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"query ControlSet Error:", (Throwable)ex);
                throw new BgControlException(BgControlException.DATABASEEXCEPTION, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
    }

    private void checkMember(Context ctx, Connection conn, IControlParameter parameter, List<BgControlParam> params) throws Exception {
        if (ctx == null || conn == null || params == null) {
            return;
        }
        Map<String, MbgDimInfo> srcMap = null;
        if (parameter.getDataManager().getSrcDimMap() == null) {
            srcMap = DimUtils.getDimInfoMap((Context)ctx);
            parameter.getDataManager().setSrcDimMap(srcMap);
        } else {
            srcMap = parameter.getDataManager().getSrcDimMap();
        }
        String[] tmpStr = null;
        HashMap<BOSUuid, Map<BOSUuid, Map<String, Set<String>>>> members = new HashMap<BOSUuid, Map<BOSUuid, Map<String, Set<String>>>>();
        HashMap<BOSUuid, BgSchemeInfo> schemeMap = new HashMap<BOSUuid, BgSchemeInfo>();
        HashMap schemeNumMap = new HashMap();
        for (BgControlParam param : params) {
            if (!schemeMap.containsKey(param.getBgSchemeInfo().getId())) {
                schemeMap.put(param.getBgSchemeInfo().getId(), param.getBgSchemeInfo());
            }
            this.addMemberNums(members, param.getBgSchemeInfo().getId(), param.getOrgUnit().getId(), param.getBgIndexNumber());
            if (!StringUtils.isEmpty((String)param.getDimItemNumber()) && (tmpStr = param.getDimItemNumber().split(BgBaseConstants.SEP_THR_STR)) != null) {
                int in = tmpStr.length;
                for (int i = 0; i < in; ++i) {
                    this.addMemberNums(members, param.getBgSchemeInfo().getId(), param.getOrgUnit().getId(), tmpStr[i]);
                }
            }
            if (!param.getControlSetting().isIsGroupCtrl()) continue;
            String setSchemeId = param.getControlSetting().getScheme().getId().toString();
            String orgUnitId = param.getOrgUnit().getId().toString();
            String groupKey = BgControlParam.getControlGroupKey(setSchemeId, orgUnitId, param.getControlSetting().getGroupNo());
            if (!this.getGroupSetMap().containsKey(groupKey)) continue;
            Map<BOSUuid, BgControlSettingInfo> tmpSetMap = this.getGroupSetMap().get(groupKey);
            for (BgControlSettingInfo setting : tmpSetMap.values()) {
                this.addMemberNums(members, param.getBgSchemeInfo().getId(), param.getOrgUnit().getId(), setting.getBgIndexNumber());
                if (StringUtils.isEmpty((String)setting.getBgDimNumber()) || (tmpStr = setting.getBgDimNumber().split(BgBaseConstants.SEP_THR_STR)) == null) continue;
                int in = tmpStr.length;
                for (int i = 0; i < in; ++i) {
                    this.addMemberNums(members, param.getBgSchemeInfo().getId(), param.getOrgUnit().getId(), tmpStr[i]);
                }
            }
        }
        String srcNumber = null;
        BgSchemeInfo schemeInfo = null;
        Set numbers = null;
        Set exists = null;
        Set<String> noExists = null;
        Map orgNumMap = null;
        Map orgNums = null;
        Map dimNums = null;
        Map.Entry entry2 = null;
        Map.Entry oEntry2 = null;
        Map.Entry sEntry2 = null;
        BgSchemeDimensionHelper schemeHelper = null;
        for (Map.Entry entry2 : members.entrySet()) {
            schemeInfo = (BgSchemeInfo)schemeMap.get(entry2.getKey());
            schemeHelper = new BgSchemeDimensionHelper(ctx, schemeInfo.getId().toString());
            orgNums = (Map)entry2.getValue();
            for (Map.Entry oEntry2 : orgNums.entrySet()) {
                if (schemeNumMap.containsKey(schemeInfo.getId())) {
                    orgNumMap = (Map)schemeNumMap.get(schemeInfo.getId());
                    if (orgNumMap.containsKey(oEntry2.getKey())) {
                        noExists = (Set)orgNumMap.get(oEntry2.getKey());
                    } else {
                        noExists = new HashSet();
                        orgNumMap.put(oEntry2.getKey(), noExists);
                    }
                } else {
                    orgNumMap = new HashMap();
                    noExists = new HashSet();
                    schemeNumMap.put(schemeInfo.getId(), orgNumMap);
                    orgNumMap.put(oEntry2.getKey(), noExists);
                }
                dimNums = (Map)oEntry2.getValue();
                Map<String, Set<String>> dimNumMap = this.queryDimNumber(ctx, schemeHelper, (BOSUuid)oEntry2.getKey());
                for (Map.Entry sEntry2 : dimNums.entrySet()) {
                    srcNumber = (String)sEntry2.getKey();
                    numbers = (Set)sEntry2.getValue();
                    exists = DimUtils.queryItemNumber((Context)ctx, (Connection)conn, (BOSUuid)schemeInfo.getViewId(srcMap.get(srcNumber).getNumber()), (Collection)numbers);
                    if (dimNumMap.containsKey(srcNumber)) {
                        exists.retainAll((Collection)dimNumMap.get(srcNumber));
                    }
                    numbers.removeAll(exists);
                    if (numbers.isEmpty()) continue;
                    for (String number : numbers) {
                        noExists.add(DimUtils.getDimNumber((String)srcNumber, (String)number));
                    }
                }
            }
        }
        for (BgControlParam param : params) {
            noExists = (HashSet)((Map)schemeNumMap.get(param.getBgSchemeInfo().getId())).get(param.getOrgUnit().getId());
            if (noExists.isEmpty()) continue;
            if (noExists.contains(param.getBgIndexNumber())) {
                param.getNoMembers().add(param.getBgIndexNumber());
            }
            if (!StringUtils.isEmpty((String)param.getDimItemNumber()) && (tmpStr = param.getDimItemNumber().split(BgBaseConstants.SEP_THR_STR)) != null) {
                int in = tmpStr.length;
                for (int i = 0; i < in; ++i) {
                    if (!noExists.contains(tmpStr[i])) continue;
                    param.getNoMembers().add(tmpStr[i]);
                }
            }
            if (!param.getControlSetting().isIsGroupCtrl()) continue;
            ArrayList<BOSUuid> delSets = new ArrayList<BOSUuid>();
            String setSchemeId = param.getControlSetting().getScheme().getId().toString();
            String orgUnitId = param.getOrgUnit().getId().toString();
            String groupKey = BgControlParam.getControlGroupKey(setSchemeId, orgUnitId, param.getControlSetting().getGroupNo());
            if (!this.getGroupSetMap().containsKey(groupKey)) continue;
            Map<BOSUuid, BgControlSettingInfo> tmpSetMap = this.getGroupSetMap().get(groupKey);
            block10: for (BgControlSettingInfo setting : tmpSetMap.values()) {
                if (noExists.contains(setting.getBgIndexNumber())) {
                    delSets.add(setting.getId());
                    continue;
                }
                if (StringUtils.isEmpty((String)setting.getBgDimNumber()) || (tmpStr = setting.getBgDimNumber().split(BgBaseConstants.SEP_THR_STR)) == null) continue;
                int in = tmpStr.length;
                for (int i = 0; i < in; ++i) {
                    if (!noExists.contains(tmpStr[i])) continue;
                    delSets.add(setting.getId());
                    continue block10;
                }
            }
            if (delSets.isEmpty()) continue;
            for (BOSUuid uuid : delSets) {
                tmpSetMap.remove(uuid);
            }
        }
    }

    private void addMemberNums(Map<BOSUuid, Map<BOSUuid, Map<String, Set<String>>>> members, BOSUuid bgSchemeId, BOSUuid orgId, String dimNumber) {
        Map<Object, Object> orgMap = null;
        Map tmpMap = null;
        if (members.containsKey(bgSchemeId)) {
            orgMap = members.get(bgSchemeId);
            if (orgMap.containsKey(orgId)) {
                tmpMap = (Map)orgMap.get(orgId);
            } else {
                tmpMap = new HashMap();
                orgMap.put(orgId, tmpMap);
            }
        } else {
            orgMap = new HashMap();
            members.put(bgSchemeId, orgMap);
            tmpMap = new HashMap();
            orgMap.put(orgId, tmpMap);
        }
        String[] tmpStr = dimNumber.split(BgBaseConstants.SEP_FOUR_STR);
        if (tmpStr != null && tmpStr.length == 2) {
            String srcNumber = tmpStr[0];
            String number = tmpStr[1];
            Set<String> nums = null;
            if (tmpMap.containsKey(srcNumber)) {
                nums = (Set)tmpMap.get(srcNumber);
            } else {
                nums = new HashSet();
                tmpMap.put(srcNumber, nums);
            }
            nums.add(number);
        }
    }

    private void queryBalance(Context ctx, IControlParameter parameter, List<BgControlParam> params) throws Exception {
        if (ctx == null || parameter == null || params == null) {
            throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        }
        BgControlParam param = null;
        HashMap<String, List<BgControlParam>> batchMap = new HashMap<String, List<BgControlParam>>();
        List<BgControlParam> tmpParams2 = null;
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            param = params.get(i);
            if (param.getControlSetting() == null) {
                param.setControlSetting(BgControlSettingInfo.getNoCtrlSet());
            }
            if (this.checkQuery(param, parameter)) continue;
            String key = this.getControlParamCalcKey(param);
            if (batchMap.containsKey(key)) {
                tmpParams2 = (List)batchMap.get(key);
            } else {
                tmpParams2 = new ArrayList();
                batchMap.put(key, tmpParams2);
            }
            tmpParams2.add(param);
        }
        Map<String, MbgDimInfo> srcMap = null;
        if (parameter.getDataManager().getSrcDimMap() == null) {
            srcMap = DimUtils.getDimInfoMap((Context)ctx);
            parameter.getDataManager().setSrcDimMap(srcMap);
        } else {
            srcMap = parameter.getDataManager().getSrcDimMap();
        }
        IBgDimensionFacade facade = BgDimensionFacadeFactory.getLocalInstance((Context)ctx);
        for (List<BgControlParam> tmpParams2 : batchMap.values()) {
            Map<String, Map<String, Map<String, IBgDimData>>> bgDataMap = this.queryBgData(ctx, facade, tmpParams2, srcMap, parameter);
            BgControlTransitUtils.newInstance(ctx, tmpParams2.get(0).getBgSchemeInfo().getId().toString()).calcTransitBudgetValue(bgDataMap, tmpParams2, this.getGroupSetMap());
            this.calcControlParam(ctx, parameter, tmpParams2, bgDataMap);
        }
    }

    protected boolean checkQuery(BgControlParam param, IControlParameter parameter) {
        boolean check = true;
        if (param == null) {
            return check;
        }
        if (!param.getNoMembers().isEmpty()) {
            return check;
        }
        check = false;
        if (this.isControl() && param.getExpandInfo() == null && param.getReqAmount().compareTo(BgBaseConstants.ZERO) <= 0 && !param.getControlSetting().isIsGroupCtrl()) {
            check = true;
        }
        return check;
    }

    protected Map<String, Map<String, Map<String, IBgDimData>>> queryBgData(Context ctx, IBgDimensionFacade facade, List<BgControlParam> tmpParams, Map<String, MbgDimInfo> srcMap, IControlParameter parameter) throws Exception {
        HashMap sumParamMap = new HashMap();
        HashMap commonParamMap = new HashMap();
        ArrayList<BgControlParam> sumParam = new ArrayList<BgControlParam>();
        ArrayList<BgControlParam> commonParam = new ArrayList<BgControlParam>();
        if (tmpParams != null) {
            for (int i = 0; i < tmpParams.size(); ++i) {
                BgControlParam param = tmpParams.get(i);
                if (1 == param.getControlSetting().getCtrlSetRule().getValue()) {
                    if (!StringUtils.isEmpty((String)param.getControlSetting().getBgDimNumber())) {
                        boolean common = false;
                        String[] dimNums = param.getDimNumber().split(",");
                        String[] tmpItems = param.getControlSetting().getBgDimNumber().split(",");
                        if (tmpItems != null) {
                            int zn = tmpItems.length;
                            for (int z = 0; z < zn; ++z) {
                                String[] arr = tmpItems[z].split(":");
                                if (arr == null || arr.length <= 1) continue;
                                common = true;
                                break;
                            }
                        }
                        if (common) {
                            String key = param.getControlSetting().getBgDimNumber().concat(",").concat(param.getDimItemNumber());
                            if (!commonParamMap.containsKey(key)) {
                                commonParamMap.put(key, new ArrayList());
                            }
                            ((List)commonParamMap.get(key)).add(param);
                            continue;
                        }
                        if (!sumParamMap.containsKey(param.getControlSetting().getBgDimNumber())) {
                            sumParamMap.put(param.getControlSetting().getBgDimNumber(), new ArrayList());
                        }
                        ((List)sumParamMap.get(param.getControlSetting().getBgDimNumber())).add(param);
                        continue;
                    }
                    sumParam.add(param);
                    continue;
                }
                commonParam.add(param);
            }
        }
        HashMap<String, Map<String, Map<String, IBgDimData>>> bgDataMap = new HashMap<String, Map<String, Map<String, IBgDimData>>>();
        if (!((sumParam.isEmpty() && commonParamMap.isEmpty() || commonParam.isEmpty()) && sumParamMap.isEmpty())) {
            HashMap bgDataMap2;
            for (List tmp : commonParamMap.values()) {
                commonParam.addAll(tmp);
            }
            ArrayList<Map> sumList = new ArrayList<Map>();
            HashMap bgDataMap1 = sumParam.isEmpty() ? new HashMap() : (Map)facade.dimensionControl(this.getDimensionParameter(ctx, sumParam, srcMap, parameter));
            Map map = bgDataMap2 = commonParam.isEmpty() ? new HashMap() : (Map)facade.dimensionControl(this.getDimensionParameter(ctx, commonParam, srcMap, parameter));
            if (!bgDataMap2.isEmpty()) {
                sumList.add(bgDataMap2);
            }
            if (!sumParamMap.isEmpty()) {
                Map dataMap = null;
                Iterator ite = sumParamMap.values().iterator();
                while (ite.hasNext()) {
                    dataMap = (Map)facade.dimensionControl(this.getDimensionParameter(ctx, (List)ite.next(), srcMap, parameter));
                    if (dataMap.isEmpty()) continue;
                    sumList.add(dataMap);
                }
            }
            if (!bgDataMap1.isEmpty()) {
                bgDataMap.putAll(bgDataMap1);
            }
            Object orgUnitKey = null;
            Object tmpMap = null;
            for (int indx = 0; indx < sumList.size(); ++indx) {
                Map childData = (Map)sumList.get(indx);
                this.mergeChildDataToBgDataMap(bgDataMap, childData);
            }
        } else if (!commonParamMap.isEmpty()) {
            Iterator ite = commonParamMap.values().iterator();
            while (ite.hasNext()) {
                Map dataMap = (Map)facade.dimensionControl(this.getDimensionParameter(ctx, (List)ite.next(), srcMap, parameter));
                if (dataMap.isEmpty()) continue;
                this.mergeChildDataToBgDataMap(bgDataMap, dataMap);
            }
        } else {
            Map bgDataMap1 = (Map)facade.dimensionControl(this.getDimensionParameter(ctx, tmpParams, srcMap, parameter));
            bgDataMap.putAll(bgDataMap1);
        }
        return bgDataMap;
    }

    private void mergeChildDataToBgDataMap(Map<String, Map<String, Map<String, IBgDimData>>> bgDataMap, Map<String, Map<String, Map<String, IBgDimData>>> childDataMap) {
        if (childDataMap == null || childDataMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Map<String, Map<String, IBgDimData>>> entry : childDataMap.entrySet()) {
            String key1 = entry.getKey();
            Map<String, Map<String, IBgDimData>> tmpMap = entry.getValue();
            if (bgDataMap.containsKey(key1)) {
                if (tmpMap == null) continue;
                Map<String, Map<String, IBgDimData>> stringMapMap = bgDataMap.get(key1);
                for (Map.Entry<String, Map<String, IBgDimData>> mapEntry : tmpMap.entrySet()) {
                    String key2 = mapEntry.getKey();
                    Map<String, IBgDimData> value = mapEntry.getValue();
                    if (stringMapMap.containsKey(key2)) {
                        stringMapMap.get(key2).putAll(value);
                        continue;
                    }
                    stringMapMap.put(key2, value);
                }
                continue;
            }
            bgDataMap.put(key1, tmpMap);
        }
    }

    private String getControlParamCalcKey(BgControlParam param) {
        if (param == null || param.getBgSchemeInfo() == null) {
            return null;
        }
        return param.getBgSchemeInfo().getRefCube() + "_" + param.getDimNumber() + "_" + param.getBgPeriodGroup().getFiscalYear().getValue();
    }

    private IDimensionParameter getDimensionParameter(Context ctx, List<BgControlParam> params, Map<String, MbgDimInfo> mbgDimMap, IControlParameter ctrlParameter) throws Exception {
        if (ctx == null || params == null || mbgDimMap == null) {
            throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        }
        DimensionParameter parameter = new DimensionParameter();
        parameter.getControlManager().setControlData(true);
        parameter.getControlManager().setCheckNullMember(false);
        parameter.setValueType(8);
        parameter.setAuditBudgetData(ctrlParameter.isAuditBudgetData());
        MemberObject member = null;
        DimensionObject orgDimension = null;
        DimensionObject bgItemDim2 = null;
        DimensionObject periodDim = null;
        DimensionObject currencyDim = null;
        DimensionObject elementDim = null;
        DimensionObject scenarioDim = null;
        DimensionObject versionDim = null;
        IDimension bgIndexDim = null;
        IDimension tmpDim2 = null;
        MbgDimInfo dimInfo = null;
        BgControlSettingInfo setting = null;
        BgControlSettingInfo tmpSetting2 = null;
        HashMap<String, DimensionObject> dimItemMap = new HashMap<String, DimensionObject>();
        HashSet<String> scheme = new HashSet<String>();
        HashSet<String> orgSet = new HashSet<String>();
        HashSet<String> periodSet = new HashSet<String>();
        HashSet<String> currencySet = new HashSet<String>();
        HashSet<String> elementSet = new HashSet<String>();
        HashSet<String> scenarioSet = new HashSet<String>();
        HashMap<String, String> refFieldMap = new HashMap<String, String>();
        HashMap dimMdxMap = new HashMap();
        Set<String> mdxSet = null;
        orgDimension = new DimensionObject();
        orgDimension.setNumber(DimensionBaseConstants.DEF_ORGUNIT_NUMBER);
        orgDimension.setField(DimensionBaseConstants.DEF_ORGUNIT_FIELD);
        orgDimension.setSrcNumber(DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER);
        periodDim = new DimensionObject();
        periodDim.setNumber(DimensionBaseConstants.DEF_PERIOD_NUMBER);
        periodDim.setField(DimensionBaseConstants.DEF_PERIOD_FIELD);
        periodDim.setSrcNumber(DimensionBaseConstants.DEF_PERIOD_SRCNUMBER);
        currencyDim = new DimensionObject();
        currencyDim.setNumber(DimensionBaseConstants.DEF_CURRENCY_NUMBER);
        currencyDim.setField(DimensionBaseConstants.DEF_CURRENCY_FIELD);
        currencyDim.setSrcNumber(DimensionBaseConstants.DEF_CURRENCY_SRCNUMBER);
        elementDim = new DimensionObject();
        elementDim.setNumber(DimensionConstants.DEF_ELEMENT_NUMBER);
        elementDim.setField(DimensionBaseConstants.DEF_ELEMENT_FIELD);
        elementDim.setSrcNumber(DimensionBaseConstants.DEF_ELEMENT_SRCNUMBER);
        scenarioDim = new DimensionObject();
        scenarioDim.setNumber(DimensionConstants.DEF_SCENARIO_NUMBER);
        scenarioDim.setField(DimensionConstants.DEF_SCENARIO_FIELD);
        scenarioDim.setSrcNumber(DimensionConstants.DEF_SCENARIO_SRCNUMBER);
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            String bizTimeKey;
            BgControlParam param = params.get(i);
            if (parameter.getBgSchemeId() == null) {
                parameter.setBgSchemeId(param.getBgSchemeInfo().getId());
                if (param.getBgSchemeInfo().getBgDimSettings().isEmpty()) {
                    parameter.getDataManager().setBgScheme(BgViewServerHelper.getBgSchemeInfo((Context)ctx, (BOSUuid)parameter.getBgSchemeId()));
                } else {
                    parameter.getDataManager().setBgScheme(param.getBgSchemeInfo());
                }
                parameter.setBgOrgViewId(parameter.getDataManager().getBgScheme().getEditOrgViewId());
            }
            if (!orgSet.contains(param.getOrgUnit().getNumber())) {
                orgSet.add(param.getOrgUnit().getNumber());
                member = new MemberObject();
                member.setNumber(param.getOrgUnit().getNumber());
                member.setName(param.getOrgUnit().getName());
                orgDimension.getDimensionMember().add(member);
                parameter.getDataManager().getControlOrgUnitIds().add(param.getOrgUnit().getId().toString());
            }
            String itemNum2 = null;
            String[] srcNums = null;
            String[] tmpItems = null;
            if (!StringUtils.isEmpty((String)param.getDimItemNumber()) && (tmpItems = param.getDimItemNumber().split(",")) != null) {
                int xn = tmpItems.length;
                for (int x = 0; x < xn; ++x) {
                    itemNum2 = tmpItems[x];
                    srcNums = itemNum2.split(":");
                    if (srcNums == null) continue;
                    dimInfo = mbgDimMap.get(srcNums[0]);
                    if (!refFieldMap.containsKey(srcNums[0])) {
                        refFieldMap.put(srcNums[0], dimInfo.getRefField());
                    }
                    if (dimItemMap.containsKey(dimInfo.getRefField())) {
                        bgItemDim2 = (IDimension)dimItemMap.get(dimInfo.getRefField());
                    } else {
                        bgItemDim2 = new DimensionObject();
                        bgItemDim2.setField(dimInfo.getRefField());
                        bgItemDim2.setNumber(dimInfo.getNumber());
                        bgItemDim2.setSrcNumber(dimInfo.getSrcNumber());
                        dimItemMap.put(dimInfo.getRefField(), bgItemDim2);
                    }
                    if (dimMdxMap.containsKey(bgItemDim2.getNumber())) {
                        mdxSet = (Set)dimMdxMap.get(bgItemDim2.getNumber());
                    } else {
                        mdxSet = new HashSet();
                        dimMdxMap.put(bgItemDim2.getNumber(), mdxSet);
                    }
                    member = new MemberObject();
                    member.setSrcNumber(srcNums[0]);
                    member.setNumber(srcNums[1]);
                    if (mdxSet.contains(member.getDimNumber())) continue;
                    mdxSet.add(member.getDimNumber());
                    bgItemDim2.getDimensionMember().add(member);
                }
            }
            if ((setting = param.getControlSetting()).isIsGroupCtrl() && !StringUtils.isEmpty((String)setting.getGroupNo())) {
                Map<BOSUuid, BgControlSettingInfo> tmpSetMap;
                String groupKey = setting.getScheme().getId() + "_" + param.getOrgUnit().getId() + "_" + setting.getGroupNo();
                if (this.getGroupSetMap().containsKey(groupKey) && !(tmpSetMap = this.getGroupSetMap().get(groupKey)).isEmpty()) {
                    for (BgControlSettingInfo tmpSetting2 : tmpSetMap.values()) {
                        bgIndexDim = (IDimension)dimItemMap.get(DimensionConstants.DEF_BGINDEX_FIELD);
                        mdxSet = (Set)dimMdxMap.get(bgIndexDim.getNumber());
                        if (!mdxSet.contains(tmpSetting2.getBgIndexNumber())) {
                            mdxSet.add(tmpSetting2.getBgIndexNumber());
                            srcNums = tmpSetting2.getBgIndexNumber().split(":");
                            member = new MemberObject();
                            member.setSrcNumber(srcNums[0]);
                            member.setNumber(srcNums[1]);
                            bgIndexDim.getDimensionMember().add(member);
                        }
                        if (StringUtils.isEmpty((String)tmpSetting2.getBgDimNumber()) || (tmpItems = tmpSetting2.getBgDimNumber().split(",")) == null) continue;
                        int zn = tmpItems.length;
                        for (int z = 0; z < zn; ++z) {
                            itemNum2 = tmpItems[z];
                            srcNums = itemNum2.split(":");
                            if (srcNums == null) continue;
                            dimInfo = mbgDimMap.get(srcNums[0]);
                            bgItemDim2 = (IDimension)dimItemMap.get(dimInfo.getRefField());
                            mdxSet = (Set)dimMdxMap.get(bgItemDim2.getNumber());
                            if (srcNums.length > 1) {
                                if (mdxSet.contains(itemNum2)) continue;
                                mdxSet.add(itemNum2);
                                member = new MemberObject();
                                member.setSrcNumber(srcNums[0]);
                                member.setNumber(srcNums[1]);
                                bgItemDim2.getDimensionMember().add(member);
                                continue;
                            }
                            bgItemDim2.getDimensionMember().clear();
                        }
                    }
                }
            }
            if (1 == setting.getCtrlSetRule().getValue()) {
                if (!StringUtils.isEmpty((String)setting.getBgDimNumber())) {
                    tmpItems = setting.getBgDimNumber().split(",");
                    if (tmpItems != null) {
                        for (String itemNum2 : tmpItems) {
                            srcNums = itemNum2.split(":");
                            if (srcNums == null || srcNums.length > 1) continue;
                            dimInfo = mbgDimMap.get(srcNums[0]);
                            bgItemDim2 = (IDimension)dimItemMap.get(dimInfo.getRefField());
                            bgItemDim2.getDimensionMember().clear();
                            bgItemDim2.setMemberType(DimensionConstants.MEMBER_TYPE_LEAF);
                        }
                    }
                } else {
                    for (IDimension tmpDim2 : dimItemMap.values()) {
                        if (tmpDim2.getField().equals(DimensionConstants.DEF_BGINDEX_FIELD)) continue;
                        tmpDim2.getDimensionMember().clear();
                        tmpDim2.setMemberType(DimensionConstants.MEMBER_TYPE_LEAF);
                    }
                }
            }
            List bgSchemePeriodType = null;
            if (parameter.getDataManager().getBgScheme() != null) {
                bgSchemePeriodType = parameter.getDataManager().getBgScheme().getMemberNumber(DimensionConstants.DEF_PERIOD_NUMBER);
            }
            if (!scheme.contains(bizTimeKey = param.getBgSchemeInfo().getRefCube() + "_" + param.getBgPeriodType() + "_" + param.getControlSetting().getCtrlType().getValue() + "_" + param.getBizDate().getTime() + "_" + param.getControlSetting().getPeriodType().getValue() + "_" + param.getBgPeriodGroup().getId())) {
                scheme.add(bizTimeKey);
                List<String> bgPeriodNums = param.getBgPeirodBySetting(ctx, parameter.getValueType(), this.getBgPeriodCacheMap());
                int jn = bgPeriodNums.size();
                for (int j = 0; j < jn; ++j) {
                    String bgPeriodNumber = bgPeriodNums.get(j);
                    if (bgPeriodNumber == null || periodSet.contains(bgPeriodNumber)) continue;
                    if (bgSchemePeriodType != null && !bgSchemePeriodType.contains(bgPeriodNumber.split("\\.")[0])) {
                        throw new BgControlException(BgControlException.NOFOUNDBGPERIOD);
                    }
                    periodSet.add(bgPeriodNumber);
                    member = new MemberObject();
                    member.setNumber(bgPeriodNumber);
                    periodDim.getDimensionMember().add(member);
                }
            }
            if (!currencySet.contains(param.getCurrency().getNumber())) {
                currencySet.add(param.getCurrency().getNumber());
                member = new MemberObject();
                member.setNumber(param.getCurrency().getNumber());
                currencyDim.getDimensionMember().add(member);
            }
            if (!elementSet.contains(param.getBgElement().getNumber())) {
                elementSet.add(param.getBgElement().getNumber());
                member = new MemberObject();
                member.setNumber(param.getBgElement().getNumber());
                elementDim.getDimensionMember().add(member);
            }
            if (!scenarioSet.contains(param.getBgScenario().getNumber())) {
                scenarioSet.add(param.getBgScenario().getNumber());
                member = new MemberObject();
                member.setNumber(param.getBgScenario().getNumber());
                scenarioDim.getDimensionMember().add(member);
            }
            if (scenarioSet.contains(param.getAcScenario().getNumber())) continue;
            scenarioSet.add(param.getAcScenario().getNumber());
            member = new MemberObject();
            member.setNumber(param.getAcScenario().getNumber());
            scenarioDim.getDimensionMember().add(member);
        }
        versionDim = new DimensionObject();
        versionDim.setNumber(DimensionConstants.DEF_VERSION_NUMBER);
        versionDim.setField(DimensionBaseConstants.DEF_VERSION_FIELD);
        versionDim.setSrcNumber(DimensionBaseConstants.DEF_VERSION_SRCNUMBER);
        member = new MemberObject();
        member.setNumber("Ve");
        versionDim.getDimensionMember().add(member);
        if (parameter.getDataManager().getControlOrgUnitIds().size() == 1) {
            parameter.setOrgUnitId(BOSUuid.read((String)((String)parameter.getDataManager().getControlOrgUnitIds().get(0))));
            parameter.getDataManager().setOrgUnit(MbgDataHelper.getOrgUnitInfo((Context)ctx, (BOSUuid)parameter.getOrgUnitId()));
            parameter.getDataManager().setBgOrgUnit(MbgDataHelper.getBgOrgUnitInfo((Context)ctx, (BOSUuid)parameter.getBgOrgViewId(), (BOSUuid)parameter.getOrgUnitId()));
        } else {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("longNumber");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("viewId", (Object)parameter.getBgOrgViewId().toString()));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnitID", new HashSet(parameter.getDataManager().getControlOrgUnitIds()), CompareType.INCLUDE));
            BgOrgUnitCollection col = BgOrgUnitFactory.getLocalInstance((Context)ctx).getBgOrgUnitCollection(evi);
            ArrayList parentNumber = new ArrayList();
            HashSet pNumberSet = new HashSet();
            for (int i = 0; i < col.size(); ++i) {
                pNumberSet.clear();
                pNumberSet.addAll(Arrays.asList((Object[])col.get(i).getLongNumber().split("!")));
                if (i != 0 && parentNumber.isEmpty()) break;
                if (i == 0) {
                    parentNumber.addAll(pNumberSet);
                    continue;
                }
                parentNumber.retainAll(pNumberSet);
            }
            BOSUuid orgId = null;
            orgId = parentNumber.isEmpty() ? parameter.getDataManager().getBgScheme().getOrgUnit().getId() : CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo("select id where number = '" + (String)parentNumber.get(parentNumber.size() - 1) + "'").getId();
            parameter.getDataManager().setBgOrgUnit(MbgDataHelper.getBgOrgUnitInfo((Context)ctx, (BOSUuid)parameter.getBgOrgViewId(), (BOSUuid)orgId));
            parameter.setQeryOrgIds(new HashSet(parameter.getDataManager().getControlOrgUnitIds()));
        }
        DimUtils.queryItemLongNumber((Context)ctx, (IDimensionParameter)parameter, (IDimensionBase)orgDimension);
        DimUtils.transMdxMemberNumber((Context)ctx, (IDimensionParameter)parameter, (IDimension)orgDimension);
        DimUtils.transMdxMemberNumber((Context)ctx, (IDimensionParameter)parameter, (IDimension)periodDim);
        if (periodDim.getDimensionMember().isEmpty()) {
            throw new BgControlException(BgControlException.NOFOUNDBGPERIOD);
        }
        DimUtils.queryItemLongNumber((Context)ctx, (IDimensionParameter)parameter, (IDimensionBase)scenarioDim);
        DimUtils.transScenarioNumber((Context)ctx, (IDimension)scenarioDim);
        DimUtils.queryItemLongNumber((Context)ctx, (IDimensionParameter)parameter, (IDimensionBase)versionDim);
        DimUtils.transVersionNumber((Context)ctx, (IDimension)versionDim);
        for (DimensionObject bgItemDim2 : dimItemMap.values()) {
            DimUtils.queryItemLongNumber((Context)ctx, (IDimensionParameter)parameter, (IDimensionBase)bgItemDim2);
            parameter.getRowDims().add(bgItemDim2);
            parameter.getDimensionMap().put(bgItemDim2.getNumber(), bgItemDim2);
        }
        parameter.getColDims().add(orgDimension);
        parameter.getColDims().add(periodDim);
        parameter.getColDims().add(currencyDim);
        parameter.getColDims().add(elementDim);
        parameter.getColDims().add(scenarioDim);
        parameter.getColDims().add(versionDim);
        parameter.getDimensionMap().put(orgDimension.getNumber(), orgDimension);
        parameter.getDimensionMap().put(periodDim.getNumber(), periodDim);
        parameter.getDimensionMap().put(currencyDim.getNumber(), currencyDim);
        parameter.getDimensionMap().put(elementDim.getNumber(), elementDim);
        parameter.getDimensionMap().put(scenarioDim.getNumber(), scenarioDim);
        parameter.getDimensionMap().put(versionDim.getNumber(), versionDim);
        return parameter;
    }

    private void calcControlParam(Context ctx, IControlParameter parameter, List<BgControlParam> params, Map<String, Map<String, Map<String, IBgDimData>>> bgDataMap) throws Exception {
        if (ctx == null || parameter == null || params == null) {
            throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        }
        if (bgDataMap == null) {
            throw new BgControlException(BgControlException.AGGREGATIONCALCERROR);
        }
        this.calcHasActualPeriod(ctx, parameter, params, bgDataMap);
        BgControlParam controlParam = null;
        BgControlSettingInfo setting = null;
        BgControlSettingInfo tmpSetting2 = null;
        List<Object> bgGroupDatas = null;
        List<BgGroupData> tmpDatas = null;
        Map<String, Map<String, IBgDimData>> orgUnitMap = null;
        Map<BOSUuid, BgControlSettingInfo> tmpSetMap = null;
        int calcType = 0;
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            controlParam = params.get(i);
            controlParam.createGroupKey();
            if (!bgDataMap.containsKey(controlParam.getOrgUnit().getNumber()) || (orgUnitMap = bgDataMap.get(controlParam.getOrgUnit().getNumber())) == null || orgUnitMap.isEmpty()) continue;
            calcType = controlParam.getControlSetting().getCtrlSetRule().getValue();
            if (calcType == 0) {
                this.calcDetail(ctx, controlParam, orgUnitMap, false);
            } else if (calcType == 1) {
                this.calcSum(ctx, controlParam, orgUnitMap, false);
            }
            setting = controlParam.getControlSetting();
            if (!setting.isIsGroupCtrl() || StringUtils.isEmpty((String)setting.getGroupNo())) continue;
            String groupKey = controlParam.getControlGroupKey();
            if (!this.getGroupSetMap().containsKey(groupKey)) continue;
            tmpSetMap = this.getGroupSetMap().get(groupKey);
            tmpSetMap = this.sortTmpSettingMap(controlParam, tmpSetMap);
            for (BgControlSettingInfo tmpSetting2 : tmpSetMap.values()) {
                if (calcType == 0) {
                    tmpDatas = this.calcDetail(ctx, controlParam, tmpSetting2, orgUnitMap, false);
                } else if (calcType == 1) {
                    tmpDatas = this.calcSum(ctx, controlParam, tmpSetting2, orgUnitMap, false);
                }
                if (tmpDatas == null) {
                    tmpDatas = new ArrayList<BgGroupData>();
                    BgGroupData bgGroupData = new BgGroupData();
                    String bgdim = this.getGroupDimNum(controlParam, tmpSetting2);
                    bgGroupData.setBgDimNumber(bgdim);
                    bgGroupData.setBgPeriodNumber(controlParam.getBgPeriodNumber());
                    bgGroupData.setBudgetValue(BigDecimal.ZERO);
                    bgGroupData.setSetting(setting);
                    String key = bgGroupData.getKey();
                    if (controlParam.getBudgetDetail().isEmpty()) {
                        controlParam.getBudgetDetail().put(bgdim + "!" + controlParam.getBgPeriodNumber(), bgGroupData);
                    }
                    if (!controlParam.getBudgetDetail().isEmpty() && !controlParam.getBudgetDetail().containsKey(key)) {
                        tmpDatas.add(bgGroupData);
                        bgGroupData.setBudgetValue(null);
                    }
                }
                if (tmpDatas == null || tmpDatas.isEmpty()) continue;
                if (controlParam.getBgGroupMap().containsKey(tmpSetting2.getId())) {
                    bgGroupDatas = controlParam.getBgGroupMap().get(tmpSetting2.getId());
                } else {
                    bgGroupDatas = new ArrayList();
                    controlParam.getBgGroupMap().put(tmpSetting2.getId(), bgGroupDatas);
                }
                bgGroupDatas.addAll(tmpDatas);
            }
        }
    }

    private Map<BOSUuid, BgControlSettingInfo> sortTmpSettingMap(BgControlParam controlParam, Map<BOSUuid, BgControlSettingInfo> tmpSetMap) {
        LinkedHashMap<BOSUuid, BgControlSettingInfo> sortMap = new LinkedHashMap<BOSUuid, BgControlSettingInfo>();
        BOSUuid bosuuid2 = null;
        BgControlSettingInfo tmpSetting = null;
        for (BOSUuid bosuuid2 : tmpSetMap.keySet()) {
            tmpSetting = tmpSetMap.get(bosuuid2);
            if (!this.getGroupDimNum(controlParam, tmpSetting).equals(controlParam.getDimItemNumber())) continue;
            sortMap.put(bosuuid2, tmpSetting);
        }
        for (BOSUuid bosuuid2 : tmpSetMap.keySet()) {
            tmpSetting = tmpSetMap.get(bosuuid2);
            if (this.getGroupDimNum(controlParam, tmpSetting).equals(controlParam.getDimItemNumber())) continue;
            sortMap.put(bosuuid2, tmpSetting);
        }
        return sortMap;
    }

    private void calcHasActualPeriod(Context ctx, IControlParameter parameter, List<BgControlParam> params, Map<String, Map<String, Map<String, IBgDimData>>> bgDataMap) throws Exception {
        BgControlParam controlParam = null;
        BgControlSettingInfo setting = null;
        BgControlSettingInfo tmpSetting2 = null;
        Map<String, Map<String, IBgDimData>> orgUnitMap = null;
        Map<BOSUuid, BgControlSettingInfo> tmpSetMap = null;
        int calcType = 0;
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            controlParam = params.get(i);
            controlParam.createGroupKey();
            if (!bgDataMap.containsKey(controlParam.getOrgUnit().getNumber()) || (orgUnitMap = bgDataMap.get(controlParam.getOrgUnit().getNumber())) == null || orgUnitMap.isEmpty()) continue;
            calcType = controlParam.getControlSetting().getCtrlSetRule().getValue();
            if (calcType == 0) {
                this.calcDetail(ctx, controlParam, orgUnitMap, true);
            } else if (calcType == 1) {
                this.calcSum(ctx, controlParam, orgUnitMap, true);
            }
            setting = controlParam.getControlSetting();
            if (!setting.isIsGroupCtrl() || StringUtils.isEmpty((String)setting.getGroupNo())) continue;
            String groupKey = controlParam.getControlGroupKey();
            if (!this.getGroupSetMap().containsKey(groupKey)) continue;
            tmpSetMap = this.getGroupSetMap().get(groupKey);
            for (BgControlSettingInfo tmpSetting2 : tmpSetMap.values()) {
                if (calcType == 0) {
                    this.calcDetail(ctx, controlParam, tmpSetting2, orgUnitMap, true);
                    continue;
                }
                if (calcType != 1) continue;
                this.calcSum(ctx, controlParam, tmpSetting2, orgUnitMap, true);
            }
        }
    }

    protected void calcDetail(Context ctx, BgControlParam controlParam, Map<String, Map<String, IBgDimData>> allDimMap, boolean isCalcHasActPeriod) throws Exception {
        if (ctx == null || controlParam == null || allDimMap == null) {
            return;
        }
        if (!controlParam.checkNeedCalcActPeriod(isCalcHasActPeriod)) {
            return;
        }
        int ctrlType = controlParam.getControlSetting().getCtrlType().getValue();
        String dimNumber = controlParam.getDimItemNumber();
        String elementNum = controlParam.getBgElement().getNumber();
        String currencyNum = controlParam.getCurrency().getNumber();
        String bgScenarioNum = controlParam.getBgScenario().getNumber();
        String acScenarioNum = controlParam.getAcScenario().getNumber();
        String dimBgKey = BgControlUtils.getControlKey(dimNumber, elementNum, currencyNum, bgScenarioNum);
        String dimAcKey = BgControlUtils.getControlKey(dimNumber, elementNum, currencyNum, acScenarioNum);
        if (allDimMap.containsKey(dimBgKey) || allDimMap.containsKey(dimAcKey)) {
            Map<String, IBgDimData> bgDimMap = allDimMap.get(dimBgKey);
            Map<String, IBgDimData> acDimMap = allDimMap.get(dimAcKey);
            if (10 == ctrlType || -1 == ctrlType) {
                this.calcCurrPeriodOfBalance(ctx, controlParam, bgDimMap, acDimMap);
            } else if (11 == ctrlType) {
                this.calcTotalOfBalance(ctx, controlParam, bgDimMap, acDimMap, isCalcHasActPeriod);
            } else if (12 == ctrlType) {
                this.calcGrossOfBalance(ctx, controlParam, bgDimMap, acDimMap);
            }
        }
    }

    protected List<BgGroupData> calcDetail(Context ctx, BgControlParam controlParam, BgControlSettingInfo setting, Map<String, Map<String, IBgDimData>> allDimMap, boolean isCalcHasActPeriod) throws Exception {
        if (ctx == null || controlParam == null || setting == null || allDimMap == null) {
            return null;
        }
        if (!controlParam.checkNeedCalcActPeriod(isCalcHasActPeriod)) {
            return null;
        }
        List<BgGroupData> tmpDatas = null;
        String dimNumber = this.getGroupDimNum(controlParam, setting);
        String elementNum = controlParam.getBgElement().getNumber();
        String currencyNum = controlParam.getCurrency().getNumber();
        String bgScenarioNum = controlParam.getBgScenario().getNumber();
        String acScenarioNum = controlParam.getAcScenario().getNumber();
        String dimBgKey = BgControlUtils.getControlKey(dimNumber, elementNum, currencyNum, bgScenarioNum);
        String dimAcKey = BgControlUtils.getControlKey(dimNumber, elementNum, currencyNum, acScenarioNum);
        if (allDimMap.containsKey(dimBgKey) || allDimMap.containsKey(dimAcKey)) {
            Map<String, IBgDimData> bgDimMap = allDimMap.get(dimBgKey);
            Map<String, IBgDimData> acDimMap = allDimMap.get(dimAcKey);
            int ctrlType = controlParam.getControlSetting().getCtrlType().getValue();
            if (10 == ctrlType || -1 == ctrlType) {
                tmpDatas = this.calcCurrPeriodOfBalance(ctx, dimNumber, controlParam, setting, bgDimMap, acDimMap);
            } else if (11 == ctrlType) {
                tmpDatas = this.calcGrossOfBalance(ctx, dimNumber, controlParam, setting, bgDimMap, acDimMap, isCalcHasActPeriod);
            } else if (12 == ctrlType) {
                tmpDatas = this.calcTotalOfBalance(ctx, dimNumber, controlParam, setting, bgDimMap, acDimMap);
            }
        }
        return tmpDatas;
    }

    private String getGroupDimNum(BgControlParam controlParam, BgControlSettingInfo setting) {
        HashMap<String, String> dimNumMap = new HashMap<String, String>();
        String[] tmpStrs = null;
        String dimNumber2 = setting.getBgIndexNumber();
        String srcNumber = dimNumber2.substring(0, 3);
        dimNumMap.put(srcNumber, dimNumber2);
        if (!StringUtils.isEmpty((String)setting.getBgDimNumber()) && (tmpStrs = setting.getBgDimNumber().split(",")) != null) {
            for (String dimNumber2 : tmpStrs) {
                if (dimNumber2 == null || dimNumber2.length() <= 3) continue;
                srcNumber = dimNumber2.substring(0, 3);
                dimNumMap.put(srcNumber, dimNumber2);
            }
        }
        StringBuffer gDimNum = new StringBuffer();
        tmpStrs = controlParam.getDimItemNumber().split(",");
        if (tmpStrs != null) {
            for (String dimNumber2 : tmpStrs) {
                srcNumber = dimNumber2.substring(0, 3);
                if (dimNumMap.containsKey(srcNumber)) {
                    gDimNum.append((String)dimNumMap.get(srcNumber) + ",");
                    continue;
                }
                gDimNum.append(dimNumber2 + ",");
            }
            if (gDimNum.length() > 0) {
                gDimNum = gDimNum.delete(gDimNum.length() - 1, gDimNum.length());
            }
        }
        return gDimNum.toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, Set<String>> dealDimMap(Context ctx, BgControlParam controlParam, Map<String, Map<String, IBgDimData>> allDimMap) throws Exception {
        HashMap<String, Set<String>> rootKeyMap = new HashMap<String, Set<String>>();
        if (ctx == null) return rootKeyMap;
        if (controlParam == null) return rootKeyMap;
        if (allDimMap == null) {
            return rootKeyMap;
        }
        String dimKey2 = null;
        String mbgNumber = null;
        String srcNumber = null;
        String number = null;
        String[] tmpStrs = null;
        String[] dimNums = null;
        HashSet<String> srcNumbers = new HashSet<String>();
        Set<String> member = null;
        HashMap srcNum_Member = new HashMap();
        for (String dimKey2 : allDimMap.keySet()) {
            if (StringUtils.isEmpty((String)dimKey2) || (dimNums = (mbgNumber = (tmpStrs = dimKey2.split("_"))[0]).split(",")) == null || dimNums.length <= 1) continue;
            int in = dimNums.length;
            for (int i = 1; i < in; ++i) {
                String dimNumber = dimNums[i];
                tmpStrs = dimNumber.split(":");
                srcNumber = tmpStrs[0];
                srcNumbers.add(srcNumber);
                if (srcNum_Member.containsKey(srcNumber)) {
                    member = (Set)srcNum_Member.get(srcNumber);
                } else {
                    member = new HashSet();
                    srcNum_Member.put(srcNumber, member);
                }
                if (member == null) continue;
                member.add(tmpStrs[1]);
            }
        }
        if (srcNumbers.isEmpty()) {
            return rootKeyMap;
        }
        Connection conn = null;
        IRowSet rst = null;
        Set<String> querySet = null;
        StringBuffer sql = new StringBuffer("select m.fnumber, d.FSrcNumber from T_MBG_mbgmember m inner join T_MBG_mbgDIM d on m.fdimid=d.fid where  m.flevel=1 and d.FSrcNumber in (");
        for (String srcStr : srcNumbers) {
            sql.append("'" + srcStr + "',");
        }
        if (sql.length() > 0) {
            sql.delete(sql.length() - 1, sql.length());
        }
        sql.append(")");
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
            while (rst.next()) {
                number = rst.getString("fnumber");
                srcNumber = rst.getString("FSrcNumber");
                if (!((Set)srcNum_Member.get(srcNumber)).contains(number)) continue;
                if (rootKeyMap.containsKey(srcNumber)) {
                    querySet = (Set)rootKeyMap.get(srcNumber);
                } else {
                    querySet = new HashSet();
                    rootKeyMap.put(srcNumber, querySet);
                }
                if (querySet == null) continue;
                querySet.add(number);
            }
        }
        catch (BOSException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    logger.error((Object)"query dealDimMap Error:", (Throwable)ex2);
                    throw new BgControlException(BgControlException.DATABASEEXCEPTION, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return rootKeyMap;
    }

    protected void calcSum(Context ctx, BgControlParam controlParam, Map<String, Map<String, IBgDimData>> allDimMap, boolean isCalcHasActPeriod) throws Exception {
        if (ctx == null || controlParam == null || allDimMap == null) {
            return;
        }
        int ctrlType = controlParam.getControlSetting().getCtrlType().getValue();
        if (!controlParam.checkNeedCalcActPeriod(isCalcHasActPeriod)) {
            return;
        }
        Map<String, Set<String>> rootKeyMap = this.dealDimMap(ctx, controlParam, allDimMap);
        if (10 == ctrlType || -1 == ctrlType) {
            this.calcSumCurrPeriodOfBalance(ctx, controlParam, allDimMap, rootKeyMap);
        } else if (11 == ctrlType) {
            this.calcSumTotalOfBalance(ctx, controlParam, allDimMap, rootKeyMap, isCalcHasActPeriod);
        } else if (12 == ctrlType) {
            this.calcSumGrossOfBalance(ctx, controlParam, allDimMap, rootKeyMap);
        }
    }

    protected List<BgGroupData> calcSum(Context ctx, BgControlParam controlParam, BgControlSettingInfo setting, Map<String, Map<String, IBgDimData>> allDimMap, boolean isCalcHasActPeriod) throws Exception {
        if (ctx == null || controlParam == null || setting == null || allDimMap == null) {
            return null;
        }
        if (!controlParam.checkNeedCalcActPeriod(isCalcHasActPeriod)) {
            return null;
        }
        List<BgGroupData> tmpDatas = null;
        int ctrlType = controlParam.getControlSetting().getCtrlType().getValue();
        if (10 == ctrlType || -1 == ctrlType) {
            tmpDatas = this.calcSumCurrPeriodOfBalance(ctx, controlParam, setting, allDimMap);
        } else if (11 == ctrlType) {
            tmpDatas = this.calcSumGrossOfBalance(ctx, controlParam, setting, allDimMap, ctrlType, isCalcHasActPeriod);
        } else if (12 == ctrlType) {
            tmpDatas = this.calcSumGrossOfBalance(ctx, controlParam, setting, allDimMap, ctrlType, false);
        }
        return tmpDatas;
    }

    public Map<String, Boolean> getEqualsDimMap() {
        return this.equalsDimMap;
    }

    private boolean equalsDim(String dimNumber, BgControlSettingInfo setting) {
        if (dimNumber == null || setting == null) {
            return false;
        }
        if (dimNumber.equals(setting.getBgIndexNumber()) && StringUtils.isEmpty((String)setting.getBgDimNumber())) {
            return true;
        }
        boolean re = false;
        String checkKey = dimNumber + "!" + setting.getBgIndexNumber() + "_" + setting.getBgDimNumber();
        if (this.getEqualsDimMap().containsKey(checkKey)) {
            re = this.getEqualsDimMap().get(checkKey);
        } else {
            String[] destNums;
            String[] tmpStrs = null;
            HashSet<String> srcMember = new HashSet<String>();
            HashSet<String> srcSrc = new HashSet<String>();
            HashSet<String> destMember = new HashSet<String>();
            HashSet<String> destSrc = new HashSet<String>();
            String[] srcNums = dimNumber.split(",");
            if (srcNums != null) {
                int in = srcNums.length;
                for (int i = 0; i < in; ++i) {
                    srcMember.add(srcNums[i]);
                    srcSrc.add(srcNums[i].substring(0, 3));
                }
            }
            destMember.add(setting.getBgIndexNumber());
            destSrc.add(setting.getBgIndexNumber().substring(0, 3));
            if (!StringUtils.isEmpty((String)setting.getBgDimNumber()) && (destNums = setting.getBgDimNumber().split(",")) != null) {
                int in = destNums.length;
                for (int i = 0; i < in; ++i) {
                    tmpStrs = destNums[i].split(":");
                    if (tmpStrs == null) continue;
                    destSrc.add(tmpStrs[0]);
                    if (tmpStrs.length <= 1) continue;
                    destMember.add(destNums[i]);
                }
            }
            if (srcMember.containsAll(destMember) && srcSrc.containsAll(destSrc)) {
                re = true;
            }
            this.getEqualsDimMap().put(checkKey, re);
        }
        return re;
    }

    private boolean equalsDim(String dimNumber, BgControlSettingInfo setting, BgControlParam controlParam) {
        if (dimNumber == null || setting == null || controlParam == null) {
            return false;
        }
        if (dimNumber.equals(setting.getBgIndexNumber()) && StringUtils.isEmpty((String)setting.getBgDimNumber())) {
            return true;
        }
        boolean re = false;
        String checkKey = dimNumber + "!" + setting.getBgIndexNumber() + "_" + setting.getBgDimNumber();
        if (this.getEqualsDimMap().containsKey(checkKey)) {
            re = this.getEqualsDimMap().get(checkKey);
        } else {
            String[] destNums;
            String[] tmpStrs = null;
            HashSet<String> srcMember = new HashSet<String>();
            HashSet<String> srcSrc = new HashSet<String>();
            HashSet<String> destMember = new HashSet<String>();
            HashSet<String> destSrc = new HashSet<String>();
            String[] srcNums = dimNumber.split(",");
            if (srcNums != null) {
                int in = srcNums.length;
                for (int i = 0; i < in; ++i) {
                    srcMember.add(srcNums[i]);
                    srcSrc.add(srcNums[i].substring(0, 3));
                }
            }
            destMember.add(setting.getBgIndexNumber());
            destSrc.add(setting.getBgIndexNumber().substring(0, 3));
            if (!StringUtils.isEmpty((String)setting.getBgDimNumber()) && (destNums = setting.getBgDimNumber().split(",")) != null) {
                int in = destNums.length;
                for (int i = 0; i < in; ++i) {
                    tmpStrs = destNums[i].split(":");
                    if (tmpStrs == null) continue;
                    destSrc.add(tmpStrs[0]);
                    if (tmpStrs.length <= 1) continue;
                    destMember.add(destNums[i]);
                }
            }
            if (srcMember.containsAll(destMember) && srcSrc.containsAll(destSrc)) {
                re = true;
            }
            this.getEqualsDimMap().put(checkKey, re);
        }
        return re;
    }

    protected void calcCurrPeriodOfBalance(Context ctx, BgControlParam controlParam, Map<String, IBgDimData> bgDimMap, Map<String, IBgDimData> acDimMap) {
        if (controlParam == null || bgDimMap == null && acDimMap == null) {
            return;
        }
        IBgDimData bgDimData = null;
        BgGroupData bgGroupData = null;
        if (bgDimMap != null && bgDimMap.containsKey(controlParam.getBgPeriodNumber())) {
            bgDimData = bgDimMap.get(controlParam.getBgPeriodNumber());
            controlParam.setBudgetValue(bgDimData.getBudgetValue());
            controlParam.setTransitBudgetValue(bgDimData.getTransitBudgetValue());
            bgGroupData = new BgGroupData();
            bgGroupData.setBgDimNumber(bgDimData.getDimItemNumber());
            bgGroupData.setBgPeriodNumber(controlParam.getBgPeriodNumber());
            bgGroupData.setBudgetValue(bgDimData.getBudgetValue());
            bgGroupData.setTransitBudgetValue(bgDimData.getTransitBudgetValue());
            controlParam.getBudgetDetail().put(bgGroupData.getKey(), bgGroupData);
        }
        if (acDimMap != null && acDimMap.containsKey(controlParam.getBgPeriodNumber())) {
            bgDimData = acDimMap.get(controlParam.getBgPeriodNumber());
            controlParam.setActualValue(bgDimData.getActualValue());
            bgGroupData = new BgGroupData();
            bgGroupData.setBgDimNumber(bgDimData.getDimItemNumber());
            bgGroupData.setBgPeriodNumber(controlParam.getBgPeriodNumber());
            bgGroupData.setActualValue(bgDimData.getActualValue());
            controlParam.getActualDetail().put(bgGroupData.getKey(), bgGroupData);
        }
    }

    protected boolean checkMemberIsRoot(String[] tmpStrs, Map<String, Set<String>> rootKeyMap) {
        boolean isRoot = true;
        if (tmpStrs == null || tmpStrs.length <= 0) {
            return isRoot;
        }
        if (rootKeyMap != null && !rootKeyMap.isEmpty()) {
            String[] dimNums = tmpStrs[0].split(",");
            String[] _tmpStrs = null;
            Set<String> dimNumSet = null;
            if (dimNums != null && dimNums.length > 1) {
                for (int i = 1; i < dimNums.length; ++i) {
                    _tmpStrs = dimNums[i].split(":");
                    dimNumSet = rootKeyMap.get(_tmpStrs[0]);
                    if (dimNumSet == null || dimNumSet.contains(_tmpStrs[1])) continue;
                    isRoot = false;
                    break;
                }
            }
        }
        return isRoot;
    }

    protected void calcSumCurrPeriodOfBalance(Context ctx, BgControlParam controlParam, Map<String, Map<String, IBgDimData>> allDimMap, Map<String, Set<String>> rootKeyMap) {
        if (controlParam == null || allDimMap == null) {
            return;
        }
        Map<String, IBgDimData> bgDimMap = null;
        Map.Entry<String, Map<String, IBgDimData>> entry2 = null;
        String dimKey = null;
        String groupKey = null;
        String dimNumber = null;
        String elementNum = null;
        String currencyNum = null;
        String scenarioNum = null;
        String[] tmpStrs = null;
        IBgDimData bgDimData = null;
        BigDecimal budgetValue = null;
        BigDecimal actualValue = null;
        BigDecimal transitBudgetValue = null;
        BgGroupData bgGroupData = null;
        HashMap<String, BgGroupData> tmpGroupMap = new HashMap<String, BgGroupData>();
        for (Map.Entry<String, Map<String, IBgDimData>> entry2 : allDimMap.entrySet()) {
            dimKey = entry2.getKey();
            tmpStrs = dimKey.split("_");
            boolean isRoot = this.checkMemberIsRoot(tmpStrs, rootKeyMap);
            if (tmpStrs == null || tmpStrs.length != 4) continue;
            dimNumber = tmpStrs[0];
            elementNum = tmpStrs[1];
            currencyNum = tmpStrs[2];
            scenarioNum = tmpStrs[3];
            if (!this.equalsDim(dimNumber, controlParam.getControlSetting()) || !elementNum.equals(controlParam.getBgElement().getNumber()) || !currencyNum.equals(controlParam.getCurrency().getNumber())) continue;
            bgDimMap = entry2.getValue();
            if (scenarioNum.equals(controlParam.getBgScenario().getNumber())) {
                if (!bgDimMap.containsKey(controlParam.getBgPeriodNumber()) || (bgDimData = bgDimMap.get(controlParam.getBgPeriodNumber())).getBudgetValue() == null && (bgDimData.getTransitBudgetValue() == null || bgDimData.getTransitBudgetValue().compareTo(BigDecimal.ZERO) == 0)) continue;
                if (budgetValue == null) {
                    budgetValue = BgControlConstants.ZERO;
                }
                if (transitBudgetValue == null) {
                    transitBudgetValue = BgControlConstants.ZERO;
                }
                if (isRoot && budgetValue != null) {
                    budgetValue = this.addBigDecimal(budgetValue, bgDimData.getBudgetValue());
                    transitBudgetValue = this.addBigDecimal(transitBudgetValue, bgDimData.getTransitBudgetValue());
                }
                if (tmpGroupMap.containsKey(groupKey = BgGroupData.getKey(bgDimData.getDimItemNumber(), controlParam.getBgPeriodNumber()))) {
                    bgGroupData = (BgGroupData)tmpGroupMap.get(groupKey);
                } else {
                    bgGroupData = new BgGroupData();
                    bgGroupData.setBgDimNumber(bgDimData.getDimItemNumber());
                    bgGroupData.setBgPeriodNumber(controlParam.getBgPeriodNumber());
                    tmpGroupMap.put(groupKey, bgGroupData);
                }
                bgGroupData.setBudgetValue(bgDimData.getBudgetValue());
                bgGroupData.setTransitBudgetValue(bgDimData.getTransitBudgetValue());
                controlParam.getBudgetDetail().put(bgGroupData.getKey(), bgGroupData);
                continue;
            }
            if (!scenarioNum.equals(controlParam.getAcScenario().getNumber()) || !bgDimMap.containsKey(controlParam.getBgPeriodNumber()) || (bgDimData = bgDimMap.get(controlParam.getBgPeriodNumber())).getActualValue() == null) continue;
            if (actualValue == null) {
                actualValue = BgControlConstants.ZERO;
            }
            actualValue = actualValue.add(bgDimData.getActualValue());
            groupKey = BgGroupData.getKey(bgDimData.getDimItemNumber(), controlParam.getBgPeriodNumber());
            if (tmpGroupMap.containsKey(groupKey)) {
                bgGroupData = (BgGroupData)tmpGroupMap.get(groupKey);
            } else {
                bgGroupData = new BgGroupData();
                bgGroupData.setBgDimNumber(bgDimData.getDimItemNumber());
                bgGroupData.setBgPeriodNumber(controlParam.getBgPeriodNumber());
                tmpGroupMap.put(groupKey, bgGroupData);
            }
            bgGroupData.setActualValue(bgDimData.getActualValue());
            controlParam.getActualDetail().put(bgGroupData.getKey(), bgGroupData);
        }
        controlParam.setBudgetValue(budgetValue);
        controlParam.setTransitBudgetValue(transitBudgetValue);
        controlParam.setActualValue(actualValue);
    }

    protected void calcTotalOfBalance(Context ctx, BgControlParam controlParam, Map<String, IBgDimData> bgDimMap, Map<String, IBgDimData> acDimMap, boolean isCalcHasActPeriod) throws Exception {
        int i;
        int in;
        if (controlParam == null) {
            return;
        }
        IBgDimData bgDimData = null;
        BigDecimal budgetValue = null;
        BigDecimal actualValue = null;
        BigDecimal transitBudgetValue = null;
        HashMap<String, BigDecimal> addupBudgetValue = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> addupTransitBudgetValue = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> addupActualValue = new HashMap<String, BigDecimal>();
        String bgPeriodNum = null;
        String groupKey = null;
        BgGroupData bgGroupData = null;
        HashMap<String, BgGroupData> tmpGroupMap = new HashMap<String, BgGroupData>();
        List<String> refPeriods = null;
        if (!isCalcHasActPeriod) {
            refPeriods = controlParam.getRefBgPeriods(ctx, this.getBgPeriodCacheMap());
            in = refPeriods.size();
            for (i = 0; i < in; ++i) {
                bgPeriodNum = refPeriods.get(i);
                if (controlParam.isAddupCtrl() && !controlParam.checkIsInPeriodForAddCtrl(bgPeriodNum, controlParam.getMaxHasActualPeriod()) || bgDimMap == null || !bgDimMap.containsKey(bgPeriodNum) || (bgDimData = bgDimMap.get(bgPeriodNum)).getBudgetValue() == null && (bgDimData.getTransitBudgetValue() == null || bgDimData.getTransitBudgetValue().compareTo(BigDecimal.ZERO) == 0)) continue;
                if (!controlParam.isAddupCtrl()) {
                    budgetValue = this.addBigDecimal(budgetValue, bgDimData.getBudgetValue());
                    transitBudgetValue = this.addBigDecimal(transitBudgetValue, bgDimData.getTransitBudgetValue());
                } else {
                    for (String addPeriod : controlParam.getHasActualPeriods()) {
                        if (!controlParam.checkIsInPeriodForAddCtrl(bgPeriodNum, addPeriod)) continue;
                        addupBudgetValue.put(addPeriod, this.addBigDecimal((BigDecimal)addupBudgetValue.get(addPeriod), bgDimData.getBudgetValue()));
                        addupTransitBudgetValue.put(addPeriod, this.addBigDecimal((BigDecimal)addupTransitBudgetValue.get(addPeriod), bgDimData.getTransitBudgetValue()));
                    }
                }
                bgGroupData = new BgGroupData();
                bgGroupData.setBgDimNumber(bgDimData.getDimItemNumber());
                bgGroupData.setBgPeriodNumber(bgPeriodNum);
                bgGroupData.setBudgetValue(bgDimData.getBudgetValue());
                bgGroupData.setTransitBudgetValue(bgDimData.getTransitBudgetValue());
                tmpGroupMap.put(bgGroupData.getKey(), bgGroupData);
                if (controlParam.isOnlyExpandControl() && controlParam.isExpandCtrlParam()) {
                    if (bgPeriodNum.compareTo(controlParam.getBgPeriodNumber()) > 0) continue;
                    controlParam.getBudgetDetail().put(bgGroupData.getKey(), bgGroupData);
                    continue;
                }
                controlParam.getBudgetDetail().put(bgGroupData.getKey(), bgGroupData);
            }
        }
        refPeriods = controlParam.getRefAcPeriods(ctx, this.getBgPeriodCacheMap());
        in = refPeriods.size();
        for (i = 0; i < in; ++i) {
            bgPeriodNum = refPeriods.get(i);
            if (acDimMap == null || !acDimMap.containsKey(bgPeriodNum) || (bgDimData = acDimMap.get(bgPeriodNum)).getActualValue() == null) continue;
            if (actualValue == null) {
                actualValue = BgControlConstants.ZERO;
            }
            if (isCalcHasActPeriod) {
                if (BgControlConstants.ZERO.compareTo(bgDimData.getActualValue()) == 0) continue;
                controlParam.addHasActualPeriod(bgPeriodNum);
                continue;
            }
            if (controlParam.isAddupCtrl()) {
                if (!controlParam.checkIsInPeriodForAddCtrl(bgPeriodNum, controlParam.getMaxHasActualPeriod())) continue;
                for (String addPeriod : controlParam.getHasActualPeriods()) {
                    if (!controlParam.checkIsInPeriodForAddCtrl(bgPeriodNum, addPeriod)) continue;
                    addupActualValue.put(addPeriod, this.addBigDecimal((BigDecimal)addupActualValue.get(addPeriod), bgDimData.getActualValue()));
                }
            } else {
                actualValue = this.addBigDecimal(actualValue, bgDimData.getActualValue());
            }
            if (tmpGroupMap.containsKey(groupKey = BgGroupData.getKey(bgDimData.getDimItemNumber(), bgPeriodNum))) {
                bgGroupData = (BgGroupData)tmpGroupMap.get(groupKey);
            } else {
                bgGroupData = new BgGroupData();
                bgGroupData.setBgDimNumber(bgDimData.getDimItemNumber());
                bgGroupData.setBgPeriodNumber(bgPeriodNum);
                tmpGroupMap.put(groupKey, bgGroupData);
            }
            bgGroupData.setActualValue(bgDimData.getActualValue());
            if (controlParam.isOnlyExpandControl() && controlParam.isExpandCtrlParam()) {
                if (bgPeriodNum.compareTo(controlParam.getBgPeriodNumber()) > 0) continue;
                controlParam.getActualDetail().put(bgGroupData.getKey(), bgGroupData);
                continue;
            }
            controlParam.getActualDetail().put(bgGroupData.getKey(), bgGroupData);
        }
        if (!isCalcHasActPeriod) {
            this.calcMinBalance(controlParam, budgetValue, actualValue, transitBudgetValue, addupBudgetValue, addupActualValue, addupTransitBudgetValue);
        }
    }

    protected void calcMinBalance(BgControlParam controlParam, BigDecimal budgetValue, BigDecimal actualValue, BigDecimal transitBudgetValue, Map<String, BigDecimal> addupBudgetValue, Map<String, BigDecimal> addupActualValue, Map<String, BigDecimal> addupTransitBudgetValue) {
        if (!controlParam.isAddupCtrl()) {
            controlParam.setBudgetValue(budgetValue);
            controlParam.setActualValue(actualValue);
            controlParam.setTransitBudgetValue(transitBudgetValue);
        } else if (controlParam.isAddupCtrl() && controlParam.isOnlyExpandControl() && controlParam.isExpandCtrlParam()) {
            budgetValue = addupBudgetValue.get(controlParam.getBgPeriodNumber());
            transitBudgetValue = addupTransitBudgetValue.get(controlParam.getBgPeriodNumber());
            actualValue = addupActualValue.get(controlParam.getBgPeriodNumber());
            controlParam.setBudgetValue(budgetValue);
            controlParam.setActualValue(actualValue);
            controlParam.setTransitBudgetValue(transitBudgetValue);
        } else {
            BigDecimal _balance = null;
            BigDecimal _minBalance = null;
            controlParam.getAddupBudgetValue().putAll(addupBudgetValue);
            controlParam.getAddupTransitBudgetValue().putAll(addupTransitBudgetValue);
            controlParam.getAddupActualValue().putAll(addupActualValue);
            for (String addPeriod : controlParam.getHasActualPeriods()) {
                budgetValue = addupBudgetValue.get(addPeriod);
                BigDecimal _budgetValue = budgetValue == null ? BgControlConstants.ZERO : budgetValue;
                transitBudgetValue = addupTransitBudgetValue.get(addPeriod);
                if (transitBudgetValue == null) {
                    transitBudgetValue = BgControlConstants.ZERO;
                }
                if ((actualValue = addupActualValue.get(addPeriod)) == null) {
                    actualValue = BgControlConstants.ZERO;
                }
                _balance = _budgetValue.multiply(controlParam.getControlSetting().getFlexParam()).subtract(transitBudgetValue.multiply(controlParam.getControlSetting().getFlexParam())).subtract(actualValue);
                controlParam.getAddupBalance().put(addPeriod, _balance);
                if (_minBalance != null && _minBalance.compareTo(_balance) <= 0) continue;
                _minBalance = _balance;
                controlParam.setBudgetValue(budgetValue);
                controlParam.setTransitBudgetValue(transitBudgetValue);
                controlParam.setActualValue(actualValue);
                controlParam.setAddupActualPeriod(addPeriod);
            }
        }
    }

    protected void calcSumTotalOfBalance(Context ctx, BgControlParam controlParam, Map<String, Map<String, IBgDimData>> allDimMap, Map<String, Set<String>> rootKeyMap, boolean isCalcHasActPeriod) throws Exception {
        if (ctx == null || controlParam == null || allDimMap == null) {
            return;
        }
        Map<String, IBgDimData> bgDimMap = null;
        Map.Entry<String, Map<String, IBgDimData>> entry2 = null;
        String dimKey = null;
        String bgPeriodNum = null;
        String groupKey = null;
        String dimNumber = null;
        String elementNum = null;
        String currencyNum = null;
        String scenarioNum = null;
        String[] tmpStrs = null;
        IBgDimData bgDimData = null;
        BigDecimal budgetValue = null;
        BigDecimal actualValue = null;
        BigDecimal transitBudgetValue = null;
        HashMap<String, BigDecimal> addupBudgetValue = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> addupTransitBudgetValue = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> addupActualValue = new HashMap<String, BigDecimal>();
        BgGroupData bgGroupData = null;
        HashMap<String, BgGroupData> tmpGroupMap = new HashMap<String, BgGroupData>();
        List<String> refBgPeriods = controlParam.getRefBgPeriods(ctx, this.getBgPeriodCacheMap());
        List<String> refAcPeriods = controlParam.getRefAcPeriods(ctx, this.getBgPeriodCacheMap());
        for (Map.Entry<String, Map<String, IBgDimData>> entry2 : allDimMap.entrySet()) {
            int i;
            int in;
            dimKey = entry2.getKey();
            tmpStrs = dimKey.split("_");
            boolean isRoot = this.checkMemberIsRoot(tmpStrs, rootKeyMap);
            if (tmpStrs == null || tmpStrs.length != 4) continue;
            dimNumber = tmpStrs[0];
            elementNum = tmpStrs[1];
            currencyNum = tmpStrs[2];
            scenarioNum = tmpStrs[3];
            if (!this.equalsDim(dimNumber, controlParam.getControlSetting()) || !elementNum.equals(controlParam.getBgElement().getNumber()) || !currencyNum.equals(controlParam.getCurrency().getNumber())) continue;
            bgDimMap = entry2.getValue();
            if (scenarioNum.equals(controlParam.getBgScenario().getNumber()) && !isCalcHasActPeriod) {
                in = refBgPeriods.size();
                for (i = 0; i < in; ++i) {
                    bgPeriodNum = refBgPeriods.get(i);
                    if (controlParam.isAddupCtrl() && !controlParam.checkIsInPeriodForAddCtrl(bgPeriodNum, controlParam.getMaxHasActualPeriod()) || !bgDimMap.containsKey(bgPeriodNum) || (bgDimData = bgDimMap.get(bgPeriodNum)).getBudgetValue() == null && (bgDimData.getTransitBudgetValue() == null || bgDimData.getTransitBudgetValue().compareTo(BigDecimal.ZERO) == 0)) continue;
                    if (isRoot || 1 == controlParam.getControlSetting().getCtrlSetRule().getValue()) {
                        if (!controlParam.isAddupCtrl()) {
                            budgetValue = this.addBigDecimal(budgetValue, bgDimData.getBudgetValue());
                            transitBudgetValue = this.addBigDecimal(transitBudgetValue, bgDimData.getTransitBudgetValue());
                        } else {
                            if (!controlParam.checkIsInPeriodForAddCtrl(bgPeriodNum, controlParam.getMaxHasActualPeriod())) continue;
                            for (String addPeriod : controlParam.getHasActualPeriods()) {
                                if (!controlParam.checkIsInPeriodForAddCtrl(bgPeriodNum, addPeriod)) continue;
                                addupBudgetValue.put(addPeriod, this.addBigDecimal((BigDecimal)addupBudgetValue.get(addPeriod), bgDimData.getBudgetValue()));
                                addupTransitBudgetValue.put(addPeriod, this.addBigDecimal((BigDecimal)addupTransitBudgetValue.get(addPeriod), bgDimData.getTransitBudgetValue()));
                            }
                        }
                    }
                    bgGroupData = new BgGroupData();
                    bgGroupData.setBgDimNumber(bgDimData.getDimItemNumber());
                    bgGroupData.setBgPeriodNumber(bgPeriodNum);
                    bgGroupData.setBudgetValue(bgDimData.getBudgetValue());
                    bgGroupData.setTransitBudgetValue(bgDimData.getTransitBudgetValue());
                    tmpGroupMap.put(bgGroupData.getKey(), bgGroupData);
                    if (controlParam.isOnlyExpandControl() && controlParam.isExpandCtrlParam()) {
                        if (bgPeriodNum.compareTo(controlParam.getBgPeriodNumber()) > 0) continue;
                        controlParam.getBudgetDetail().put(bgGroupData.getKey(), bgGroupData);
                        continue;
                    }
                    controlParam.getBudgetDetail().put(bgGroupData.getKey(), bgGroupData);
                }
                continue;
            }
            if (!scenarioNum.equals(controlParam.getAcScenario().getNumber())) continue;
            in = refAcPeriods.size();
            for (i = 0; i < in; ++i) {
                bgPeriodNum = refAcPeriods.get(i);
                if (!bgDimMap.containsKey(bgPeriodNum) || (bgDimData = bgDimMap.get(bgPeriodNum)).getActualValue() == null) continue;
                if (isCalcHasActPeriod) {
                    if (bgDimData.getActualValue().compareTo(BgControlConstants.ZERO) == 0) continue;
                    controlParam.addHasActualPeriod(bgPeriodNum);
                    continue;
                }
                if (isRoot || 1 == controlParam.getControlSetting().getCtrlSetRule().getValue()) {
                    if (!controlParam.isAddupCtrl()) {
                        actualValue = this.addBigDecimal(actualValue, bgDimData.getActualValue());
                    } else {
                        if (!controlParam.checkIsInPeriodForAddCtrl(bgPeriodNum, controlParam.getMaxHasActualPeriod())) continue;
                        for (String addPeriod : controlParam.getHasActualPeriods()) {
                            if (!controlParam.checkIsInPeriodForAddCtrl(bgPeriodNum, addPeriod)) continue;
                            addupActualValue.put(addPeriod, this.addBigDecimal((BigDecimal)addupActualValue.get(addPeriod), bgDimData.getActualValue()));
                        }
                    }
                }
                if (tmpGroupMap.containsKey(groupKey = BgGroupData.getKey(bgDimData.getDimItemNumber(), bgPeriodNum))) {
                    bgGroupData = (BgGroupData)tmpGroupMap.get(groupKey);
                } else {
                    bgGroupData = new BgGroupData();
                    bgGroupData.setBgDimNumber(bgDimData.getDimItemNumber());
                    bgGroupData.setBgPeriodNumber(bgPeriodNum);
                    tmpGroupMap.put(groupKey, bgGroupData);
                }
                bgGroupData.setActualValue(bgDimData.getActualValue());
                if (controlParam.isOnlyExpandControl() && controlParam.isExpandCtrlParam()) {
                    if (bgPeriodNum.compareTo(controlParam.getBgPeriodNumber()) > 0) continue;
                    controlParam.getActualDetail().put(bgGroupData.getKey(), bgGroupData);
                    continue;
                }
                controlParam.getActualDetail().put(bgGroupData.getKey(), bgGroupData);
            }
        }
        if (!isCalcHasActPeriod) {
            this.calcMinBalance(controlParam, budgetValue, actualValue, transitBudgetValue, addupBudgetValue, addupActualValue, addupTransitBudgetValue);
        }
    }

    protected void calcGrossOfBalance(Context ctx, BgControlParam controlParam, Map<String, IBgDimData> bgDimMap, Map<String, IBgDimData> acDimMap) throws Exception {
        if (controlParam == null) {
            return;
        }
        IBgDimData bgDimData = null;
        BigDecimal budgetValue = null;
        BigDecimal actualValue = null;
        BigDecimal transitBudgetValue = null;
        String bgPeriodNum = null;
        String groupKey = null;
        BgGroupData bgGroupData = null;
        HashMap<String, BgGroupData> tmpGroupMap = new HashMap<String, BgGroupData>();
        List<String> refPeriods = controlParam.getRefAcPeriods(ctx, this.getBgPeriodCacheMap());
        int in = refPeriods.size();
        for (int i = 0; i < in; ++i) {
            bgPeriodNum = refPeriods.get(i);
            if (bgDimMap != null && bgDimMap.containsKey(bgPeriodNum) && ((bgDimData = bgDimMap.get(bgPeriodNum)).getBudgetValue() != null || bgDimData.getTransitBudgetValue() != null && bgDimData.getTransitBudgetValue().compareTo(BigDecimal.ZERO) != 0)) {
                if (budgetValue == null) {
                    budgetValue = BgControlConstants.ZERO;
                }
                budgetValue = this.addBigDecimal(budgetValue, bgDimData.getBudgetValue());
                if (transitBudgetValue == null) {
                    transitBudgetValue = BgControlConstants.ZERO;
                }
                transitBudgetValue = this.addBigDecimal(transitBudgetValue, bgDimData.getTransitBudgetValue());
                bgGroupData = new BgGroupData();
                bgGroupData.setBgDimNumber(bgDimData.getDimItemNumber());
                bgGroupData.setBgPeriodNumber(bgPeriodNum);
                bgGroupData.setBudgetValue(bgDimData.getBudgetValue());
                bgGroupData.setTransitBudgetValue(bgDimData.getTransitBudgetValue());
                tmpGroupMap.put(bgGroupData.getKey(), bgGroupData);
                controlParam.getBudgetDetail().put(bgGroupData.getKey(), bgGroupData);
            }
            if (bgPeriodNum.compareTo(controlParam.getBgPeriodNumber()) > 0 && controlParam.isBgExcuteAnaly() || acDimMap == null || !acDimMap.containsKey(bgPeriodNum) || (bgDimData = acDimMap.get(bgPeriodNum)).getActualValue() == null) continue;
            if (actualValue == null) {
                actualValue = BgControlConstants.ZERO;
            }
            actualValue = actualValue.add(bgDimData.getActualValue());
            groupKey = BgGroupData.getKey(bgDimData.getDimItemNumber(), bgPeriodNum);
            if (tmpGroupMap.containsKey(groupKey)) {
                bgGroupData = (BgGroupData)tmpGroupMap.get(groupKey);
            } else {
                bgGroupData = new BgGroupData();
                bgGroupData.setBgDimNumber(bgDimData.getDimItemNumber());
                bgGroupData.setBgPeriodNumber(bgPeriodNum);
                tmpGroupMap.put(groupKey, bgGroupData);
            }
            bgGroupData.setActualValue(bgDimData.getActualValue());
            controlParam.getActualDetail().put(bgGroupData.getKey(), bgGroupData);
        }
        controlParam.setBudgetValue(budgetValue);
        controlParam.setTransitBudgetValue(transitBudgetValue);
        controlParam.setActualValue(actualValue);
    }

    protected void calcSumGrossOfBalance(Context ctx, BgControlParam controlParam, Map<String, Map<String, IBgDimData>> allDimMap, Map<String, Set<String>> rootKeyMap) throws Exception {
        if (ctx == null || controlParam == null || allDimMap == null || allDimMap.isEmpty()) {
            return;
        }
        Map<String, IBgDimData> bgDimMap = null;
        Map.Entry<String, Map<String, IBgDimData>> entry2 = null;
        String dimKey = null;
        String bgPeriodNum = null;
        String groupKey = null;
        String dimNumber = null;
        String elementNum = null;
        String currencyNum = null;
        String scenarioNum = null;
        String[] tmpStrs = null;
        IBgDimData bgDimData = null;
        BigDecimal budgetValue = null;
        BigDecimal actualValue = null;
        BigDecimal transitBudgetValue = null;
        BgGroupData bgGroupData = null;
        HashMap<String, BgGroupData> tmpGroupMap = new HashMap<String, BgGroupData>();
        List<String> refPeriods = controlParam.getRefAcPeriods(ctx, this.getBgPeriodCacheMap());
        for (Map.Entry<String, Map<String, IBgDimData>> entry2 : allDimMap.entrySet()) {
            int i;
            int in;
            dimKey = entry2.getKey();
            tmpStrs = dimKey.split("_");
            boolean isRoot = this.checkMemberIsRoot(tmpStrs, rootKeyMap);
            if (tmpStrs == null || tmpStrs.length != 4) continue;
            dimNumber = tmpStrs[0];
            elementNum = tmpStrs[1];
            currencyNum = tmpStrs[2];
            scenarioNum = tmpStrs[3];
            if (!this.equalsDim(dimNumber, controlParam.getControlSetting()) || !elementNum.equals(controlParam.getBgElement().getNumber()) || !currencyNum.equals(controlParam.getCurrency().getNumber())) continue;
            bgDimMap = entry2.getValue();
            if (scenarioNum.equals(controlParam.getBgScenario().getNumber())) {
                in = refPeriods.size();
                for (i = 0; i < in; ++i) {
                    bgPeriodNum = refPeriods.get(i);
                    if (!bgDimMap.containsKey(bgPeriodNum) || (bgDimData = bgDimMap.get(bgPeriodNum)).getBudgetValue() == null && (bgDimData.getTransitBudgetValue() == null || bgDimData.getTransitBudgetValue().compareTo(BigDecimal.ZERO) == 0)) continue;
                    if (budgetValue == null) {
                        budgetValue = BgControlConstants.ZERO;
                    }
                    if (transitBudgetValue == null) {
                        transitBudgetValue = BgControlConstants.ZERO;
                    }
                    if (isRoot && budgetValue != null) {
                        budgetValue = this.addBigDecimal(budgetValue, bgDimData.getBudgetValue());
                        transitBudgetValue = this.addBigDecimal(transitBudgetValue, bgDimData.getTransitBudgetValue());
                    }
                    bgGroupData = new BgGroupData();
                    bgGroupData.setBgDimNumber(bgDimData.getDimItemNumber());
                    bgGroupData.setBgPeriodNumber(bgPeriodNum);
                    bgGroupData.setBudgetValue(bgDimData.getBudgetValue());
                    bgGroupData.setTransitBudgetValue(bgDimData.getTransitBudgetValue());
                    tmpGroupMap.put(bgGroupData.getKey(), bgGroupData);
                    controlParam.getBudgetDetail().put(bgGroupData.getKey(), bgGroupData);
                }
                continue;
            }
            if (!scenarioNum.equals(controlParam.getAcScenario().getNumber())) continue;
            in = refPeriods.size();
            for (i = 0; i < in; ++i) {
                bgPeriodNum = refPeriods.get(i);
                if (!bgDimMap.containsKey(bgPeriodNum) || bgPeriodNum.compareTo(controlParam.getBgPeriodNumber()) > 0 && controlParam.isBgExcuteAnaly() || (bgDimData = bgDimMap.get(bgPeriodNum)).getActualValue() == null) continue;
                if (actualValue == null) {
                    actualValue = BgControlConstants.ZERO;
                }
                if (isRoot && actualValue != null) {
                    actualValue = actualValue.add(bgDimData.getActualValue());
                }
                if (tmpGroupMap.containsKey(groupKey = BgGroupData.getKey(bgDimData.getDimItemNumber(), bgPeriodNum))) {
                    bgGroupData = (BgGroupData)tmpGroupMap.get(groupKey);
                } else {
                    bgGroupData = new BgGroupData();
                    bgGroupData.setBgDimNumber(bgDimData.getDimItemNumber());
                    bgGroupData.setBgPeriodNumber(bgPeriodNum);
                    tmpGroupMap.put(groupKey, bgGroupData);
                }
                bgGroupData.setActualValue(bgDimData.getActualValue());
                controlParam.getActualDetail().put(bgGroupData.getKey(), bgGroupData);
            }
        }
        controlParam.setBudgetValue(budgetValue);
        controlParam.setTransitBudgetValue(transitBudgetValue);
        controlParam.setActualValue(actualValue);
    }

    protected List<BgGroupData> calcCurrPeriodOfBalance(Context ctx, String dimNumber, BgControlParam controlParam, BgControlSettingInfo setting, Map<String, IBgDimData> bgDimMap, Map<String, IBgDimData> acDimMap) {
        if (ctx == null || controlParam == null || setting == null) {
            return null;
        }
        String key = null;
        IBgDimData bgDimData = null;
        BgGroupData bgGroupData = null;
        ArrayList<BgGroupData> bgGroupDatas = new ArrayList<BgGroupData>();
        if (bgDimMap != null && bgDimMap.containsKey(controlParam.getBgPeriodNumber()) && ((bgDimData = bgDimMap.get(controlParam.getBgPeriodNumber())).getBudgetValue() != null || bgDimData.getTransitBudgetValue() != null && bgDimData.getTransitBudgetValue().compareTo(BigDecimal.ZERO) != 0)) {
            bgGroupData = new BgGroupData();
            bgGroupData.setBgDimNumber(dimNumber);
            bgGroupData.setBgPeriodNumber(controlParam.getBgPeriodNumber());
            bgGroupData.setBudgetValue(bgDimData.getBudgetValue());
            bgGroupData.setTransitBudgetValue(bgDimData.getTransitBudgetValue());
            bgGroupData.setSetting(setting);
            key = bgGroupData.getKey();
            if (!controlParam.getBudgetDetail().containsKey(key)) {
                bgGroupDatas.add(bgGroupData);
            }
        }
        if (acDimMap != null && acDimMap.containsKey(controlParam.getBgPeriodNumber()) && (bgDimData = acDimMap.get(controlParam.getBgPeriodNumber())).getActualValue() != null) {
            bgGroupData = new BgGroupData();
            bgGroupData.setBgDimNumber(dimNumber);
            bgGroupData.setBgPeriodNumber(controlParam.getBgPeriodNumber());
            bgGroupData.setActualValue(bgDimData.getActualValue());
            bgGroupData.setSetting(setting);
            key = bgGroupData.getKey();
            if (!controlParam.getActualDetail().containsKey(key)) {
                bgGroupDatas.add(bgGroupData);
            }
        }
        return bgGroupDatas;
    }

    protected List<BgGroupData> calcSumCurrPeriodOfBalance(Context ctx, BgControlParam controlParam, BgControlSettingInfo setting, Map<String, Map<String, IBgDimData>> allDimMap) {
        if (ctx == null || controlParam == null || setting == null || allDimMap == null || allDimMap.isEmpty()) {
            return null;
        }
        IBgDimData bgDimData = null;
        BgGroupData bgGroupData = null;
        String dimKey = null;
        String dimNumber = null;
        String elementNum = null;
        String currencyNum = null;
        String scenarioNum = null;
        String key = null;
        String[] tmpStrs = null;
        ArrayList<BgGroupData> bgGroupDatas = new ArrayList<BgGroupData>();
        Map<String, IBgDimData> bgDimMap = null;
        Map.Entry<String, Map<String, IBgDimData>> entry2 = null;
        for (Map.Entry<String, Map<String, IBgDimData>> entry2 : allDimMap.entrySet()) {
            dimKey = entry2.getKey();
            tmpStrs = dimKey.split("_");
            if (tmpStrs == null || tmpStrs.length != 4) continue;
            dimNumber = tmpStrs[0];
            elementNum = tmpStrs[1];
            currencyNum = tmpStrs[2];
            scenarioNum = tmpStrs[3];
            if (!this.equalsDim(dimNumber, setting, controlParam) || !elementNum.equals(controlParam.getBgElement().getNumber()) || !currencyNum.equals(controlParam.getCurrency().getNumber())) continue;
            bgDimMap = entry2.getValue();
            if (scenarioNum.equals(controlParam.getBgScenario().getNumber())) {
                if (!bgDimMap.containsKey(controlParam.getBgPeriodNumber()) || (bgDimData = bgDimMap.get(controlParam.getBgPeriodNumber())).getBudgetValue() == null && (bgDimData.getTransitBudgetValue() == null || bgDimData.getTransitBudgetValue().compareTo(BigDecimal.ZERO) == 0)) continue;
                bgGroupData = new BgGroupData();
                bgGroupData.setBgDimNumber(dimNumber);
                bgGroupData.setBgPeriodNumber(controlParam.getBgPeriodNumber());
                bgGroupData.setBudgetValue(bgDimData.getBudgetValue());
                bgGroupData.setTransitBudgetValue(bgDimData.getTransitBudgetValue());
                bgGroupData.setSetting(setting);
                key = bgGroupData.getKey();
                if (controlParam.getBudgetDetail().containsKey(key)) continue;
                bgGroupDatas.add(bgGroupData);
                continue;
            }
            if (!scenarioNum.equals(controlParam.getAcScenario().getNumber()) || !bgDimMap.containsKey(controlParam.getBgPeriodNumber()) || (bgDimData = bgDimMap.get(controlParam.getBgPeriodNumber())).getActualValue() == null) continue;
            bgGroupData = new BgGroupData();
            bgGroupData.setBgDimNumber(dimNumber);
            bgGroupData.setBgPeriodNumber(controlParam.getBgPeriodNumber());
            bgGroupData.setActualValue(bgDimData.getActualValue());
            bgGroupData.setSetting(setting);
            key = bgGroupData.getKey();
            if (controlParam.getActualDetail().containsKey(key)) continue;
            bgGroupDatas.add(bgGroupData);
        }
        return bgGroupDatas;
    }

    protected List<BgGroupData> calcTotalOfBalance(Context ctx, String dimNumber, BgControlParam controlParam, BgControlSettingInfo setting, Map<String, IBgDimData> bgDimMap, Map<String, IBgDimData> acDimMap) throws Exception {
        return this.calcBalance(ctx, dimNumber, controlParam, setting, bgDimMap, acDimMap, 12, false);
    }

    protected List<BgGroupData> calcGrossOfBalance(Context ctx, String dimNumber, BgControlParam controlParam, BgControlSettingInfo setting, Map<String, IBgDimData> bgDimMap, Map<String, IBgDimData> acDimMap, boolean isCalcHasActPeriod) throws Exception {
        return this.calcBalance(ctx, dimNumber, controlParam, setting, bgDimMap, acDimMap, 11, isCalcHasActPeriod);
    }

    protected List<BgGroupData> calcSumTotalOfBalance(Context ctx, BgControlParam controlParam, BgControlSettingInfo setting, Map<String, Map<String, IBgDimData>> allDimMap) throws Exception {
        return this.calcSumBalance(ctx, controlParam, setting, allDimMap, 12, false);
    }

    protected List<BgGroupData> calcSumGrossOfBalance(Context ctx, BgControlParam controlParam, BgControlSettingInfo setting, Map<String, Map<String, IBgDimData>> allDimMap, int ctrlType, boolean isCalcHasActPeriod) throws Exception {
        return this.calcSumBalance(ctx, controlParam, setting, allDimMap, ctrlType, isCalcHasActPeriod);
    }

    protected List<BgGroupData> calcBalance(Context ctx, String dimNumber, BgControlParam controlParam, BgControlSettingInfo setting, Map<String, IBgDimData> bgDimMap, Map<String, IBgDimData> acDimMap, int bgCtrlType, boolean isCalcHasActPeriod) throws Exception {
        int i;
        int in;
        if (ctx == null || controlParam == null || setting == null) {
            return null;
        }
        IBgDimData bgDimData = null;
        BgGroupData bgGroupData = null;
        String bgPeriodNum = null;
        String groupKey = null;
        HashMap<String, BgGroupData> bgGroupMap = new HashMap<String, BgGroupData>();
        ArrayList<BgGroupData> bgGroupDatas = new ArrayList<BgGroupData>();
        List<String> refPeriods = null;
        if (!isCalcHasActPeriod) {
            refPeriods = this.getBgPeriodNums(ctx, controlParam, bgCtrlType, true, null);
            if (bgDimMap != null) {
                in = refPeriods.size();
                for (i = 0; i < in; ++i) {
                    bgPeriodNum = refPeriods.get(i);
                    if (!bgDimMap.containsKey(bgPeriodNum) || (bgDimData = bgDimMap.get(bgPeriodNum)).getBudgetValue() == null && (bgDimData.getTransitBudgetValue() == null || bgDimData.getTransitBudgetValue().compareTo(BigDecimal.ZERO) == 0) || controlParam.isAddupCtrl() && !controlParam.checkIsInPeriodForAddCtrl(bgPeriodNum, controlParam.getMaxHasActualPeriod())) continue;
                    groupKey = BgGroupData.getKey(dimNumber, bgPeriodNum);
                    if (controlParam.getBudgetDetail().containsKey(groupKey)) continue;
                    if (bgGroupMap.containsKey(groupKey)) {
                        bgGroupData = (BgGroupData)bgGroupMap.get(groupKey);
                    } else {
                        bgGroupData = new BgGroupData();
                        bgGroupData.setBgDimNumber(dimNumber);
                        bgGroupData.setBgPeriodNumber(bgPeriodNum);
                        bgGroupData.setSetting(setting);
                        bgGroupDatas.add(bgGroupData);
                        bgGroupMap.put(groupKey, bgGroupData);
                    }
                    bgGroupData.setBudgetValue(bgDimData.getBudgetValue());
                    bgGroupData.setTransitBudgetValue(bgDimData.getTransitBudgetValue());
                }
            }
        }
        refPeriods = this.getBgPeriodNums(ctx, controlParam, bgCtrlType, false, refPeriods);
        if (acDimMap != null) {
            in = refPeriods.size();
            for (i = 0; i < in; ++i) {
                bgPeriodNum = refPeriods.get(i);
                if (!acDimMap.containsKey(bgPeriodNum) || bgPeriodNum.compareTo(controlParam.getBgPeriodNumber()) > 0 && controlParam.isBgExcuteAnaly() || (bgDimData = acDimMap.get(bgPeriodNum)).getActualValue() == null) continue;
                if (isCalcHasActPeriod) {
                    if (bgDimData.getActualValue().compareTo(BgControlConstants.ZERO) == 0) continue;
                    controlParam.addHasActualPeriod(bgPeriodNum);
                    continue;
                }
                if (controlParam.isAddupCtrl() && !controlParam.checkIsInPeriodForAddCtrl(bgPeriodNum, controlParam.getMaxHasActualPeriod())) continue;
                groupKey = BgGroupData.getKey(dimNumber, bgPeriodNum);
                if (controlParam.getActualDetail().containsKey(groupKey)) continue;
                if (bgGroupMap.containsKey(groupKey)) {
                    bgGroupData = (BgGroupData)bgGroupMap.get(groupKey);
                } else {
                    bgGroupData = new BgGroupData();
                    bgGroupData.setBgDimNumber(dimNumber);
                    bgGroupData.setBgPeriodNumber(bgPeriodNum);
                    bgGroupData.setSetting(setting);
                    bgGroupDatas.add(bgGroupData);
                    bgGroupMap.put(groupKey, bgGroupData);
                }
                bgGroupData.setActualValue(bgDimData.getActualValue());
            }
        }
        return bgGroupDatas;
    }

    protected List<BgGroupData> calcSumBalance(Context ctx, BgControlParam controlParam, BgControlSettingInfo setting, Map<String, Map<String, IBgDimData>> allDimMap, int bgCtrlType, boolean isCalcHasActPeriod) throws Exception {
        if (ctx == null || controlParam == null || setting == null || allDimMap == null || allDimMap.isEmpty()) {
            return null;
        }
        IBgDimData bgDimData = null;
        BgGroupData bgGroupData = null;
        String dimKey = null;
        String dimNumber = null;
        String bgPeriodNum = null;
        String elementNum = null;
        String currencyNum = null;
        String scenarioNum = null;
        String groupKey = null;
        String[] tmpStrs = null;
        ArrayList<BgGroupData> bgGroupDatas = new ArrayList<BgGroupData>();
        Map<String, IBgDimData> bgDimMap = null;
        Map.Entry<String, Map<String, IBgDimData>> entry2 = null;
        HashMap<String, BgGroupData> bgGroupMap = new HashMap<String, BgGroupData>();
        List<String> refBgPeriods = this.getBgPeriodNums(ctx, controlParam, bgCtrlType, true, null);
        List<String> refAcPeriods = this.getBgPeriodNums(ctx, controlParam, bgCtrlType, false, refBgPeriods);
        for (Map.Entry<String, Map<String, IBgDimData>> entry2 : allDimMap.entrySet()) {
            int i;
            int in;
            dimKey = entry2.getKey();
            tmpStrs = dimKey.split("_");
            if (tmpStrs == null || tmpStrs.length != 4) continue;
            dimNumber = tmpStrs[0];
            elementNum = tmpStrs[1];
            currencyNum = tmpStrs[2];
            scenarioNum = tmpStrs[3];
            if (!this.equalsDim(dimNumber, setting, controlParam) || !elementNum.equals(controlParam.getBgElement().getNumber()) || !currencyNum.equals(controlParam.getCurrency().getNumber())) continue;
            bgDimMap = entry2.getValue();
            if (scenarioNum.equals(controlParam.getBgScenario().getNumber()) && !isCalcHasActPeriod) {
                in = refBgPeriods.size();
                for (i = 0; i < in; ++i) {
                    bgPeriodNum = refBgPeriods.get(i);
                    if (!bgDimMap.containsKey(bgPeriodNum) || (bgDimData = bgDimMap.get(bgPeriodNum)).getBudgetValue() == null && (bgDimData.getTransitBudgetValue() == null || bgDimData.getTransitBudgetValue().compareTo(BigDecimal.ZERO) == 0) || controlParam.isAddupCtrl() && !controlParam.checkIsInPeriodForAddCtrl(bgPeriodNum, controlParam.getMaxHasActualPeriod())) continue;
                    groupKey = BgGroupData.getKey(dimNumber, bgPeriodNum);
                    if (controlParam.getBudgetDetail().containsKey(groupKey)) continue;
                    if (bgGroupMap.containsKey(groupKey)) {
                        bgGroupData = (BgGroupData)bgGroupMap.get(groupKey);
                    } else {
                        bgGroupData = new BgGroupData();
                        bgGroupData.setBgDimNumber(dimNumber);
                        bgGroupData.setBgPeriodNumber(bgPeriodNum);
                        bgGroupData.setSetting(setting);
                        bgGroupDatas.add(bgGroupData);
                        bgGroupMap.put(groupKey, bgGroupData);
                    }
                    bgGroupData.setBudgetValue(bgDimData.getBudgetValue());
                    bgGroupData.setTransitBudgetValue(bgDimData.getTransitBudgetValue());
                }
                continue;
            }
            if (!scenarioNum.equals(controlParam.getAcScenario().getNumber())) continue;
            in = refAcPeriods.size();
            for (i = 0; i < in; ++i) {
                bgPeriodNum = refAcPeriods.get(i);
                if (!bgDimMap.containsKey(bgPeriodNum) || (bgDimData = bgDimMap.get(bgPeriodNum)).getActualValue() == null || bgPeriodNum.compareTo(controlParam.getBgPeriodNumber()) > 0 && controlParam.isBgExcuteAnaly()) continue;
                if (isCalcHasActPeriod) {
                    if (bgDimData.getActualValue().compareTo(BgControlConstants.ZERO) == 0) continue;
                    controlParam.addHasActualPeriod(bgPeriodNum);
                    continue;
                }
                if (controlParam.isAddupCtrl() && !controlParam.checkIsInPeriodForAddCtrl(bgPeriodNum, controlParam.getMaxHasActualPeriod())) continue;
                groupKey = BgGroupData.getKey(dimNumber, bgPeriodNum);
                if (controlParam.getActualDetail().containsKey(groupKey)) continue;
                if (bgGroupMap.containsKey(groupKey)) {
                    bgGroupData = (BgGroupData)bgGroupMap.get(groupKey);
                } else {
                    bgGroupData = new BgGroupData();
                    bgGroupData.setBgDimNumber(dimNumber);
                    bgGroupData.setBgPeriodNumber(bgPeriodNum);
                    bgGroupData.setSetting(setting);
                    bgGroupDatas.add(bgGroupData);
                    bgGroupMap.put(groupKey, bgGroupData);
                }
                bgGroupData.setActualValue(bgDimData.getActualValue());
            }
        }
        return bgGroupDatas;
    }

    private List<String> getBgPeriodNums(Context ctx, BgControlParam controlParam, int bgCtrlType, boolean hasBudget, List<String> bgPeriodNums) throws Exception {
        List<String> _bgPeriodNums = new ArrayList<String>();
        if (bgCtrlType == 11) {
            _bgPeriodNums = hasBudget ? controlParam.getRefBgPeriods(ctx, this.getBgPeriodCacheMap()) : controlParam.getRefAcPeriods(ctx, this.getBgPeriodCacheMap());
        } else if (bgCtrlType == 12) {
            _bgPeriodNums = hasBudget ? controlParam.getRefAcPeriods(ctx, this.getBgPeriodCacheMap()) : bgPeriodNums;
        }
        return _bgPeriodNums;
    }

    private Map<String, Set<String>> queryDimNumber(Context ctx, BgSchemeDimensionHelper schemeHelper, BOSUuid orgUnitid) throws BOSException, EASBizException, SQLException {
        HashMap<String, Set<String>> dimNumMap = new HashMap<String, Set<String>>();
        List dimSrc = schemeHelper.getAccAndOtherDim(true);
        if (dimSrc.size() > 0) {
            int i;
            String viewId = null;
            String srcNum = null;
            EntityViewInfo viewInfo = new EntityViewInfo();
            HashSet<String> viewidSet = new HashSet<String>();
            HashMap<String, MbgViewInfo> viewMap = new HashMap<String, MbgViewInfo>();
            for (int i2 = 0; i2 < dimSrc.size(); ++i2) {
                viewId = schemeHelper.getDimension((String)dimSrc.get(i2)).getViewId();
                viewidSet.add(viewId);
            }
            viewInfo.setFilter(new FilterInfo());
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("id", viewidSet, CompareType.INCLUDE));
            MbgViewCollection colls = MbgViewFactory.getLocalInstance((Context)ctx).getMbgViewCollection(viewInfo);
            for (i = 0; i < colls.size(); ++i) {
                viewMap.put(colls.get(i).getId().toString(), colls.get(i));
            }
            for (i = 0; i < dimSrc.size(); ++i) {
                viewId = schemeHelper.getDimension((String)dimSrc.get(i)).getViewId();
                srcNum = schemeHelper.getSrcNumber((String)dimSrc.get(i));
                HashSet<String> dimNumSet = new HashSet<String>();
                IQueryExecutor provider = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.ma.base.MbgMemberQuery"));
                viewInfo = new EntityViewInfo();
                viewInfo.setFilter(new FilterInfo());
                FilterInfo filter = viewInfo.getFilter();
                FilterItemInfo viewItemInfo = null;
                viewItemInfo = new FilterItemInfo("viewId", (Object)viewId, CompareType.EQUALS);
                BgCommCHelper.replaceFilterItems((FilterInfo)filter, (FilterItemInfo)viewItemInfo);
                if (viewMap.containsKey(viewId) && ((MbgViewInfo)viewMap.get(viewId)).getSegregationRule().equals((Object)MemberSegregationRuleEnum.SEGREGATEEQUALS)) {
                    Set<String> orgUnitIds = this.getParentAndChildrenOrgUnitIds(ctx, orgUnitid);
                    FilterItemInfo orgItemInfo = null;
                    if (!orgUnitIds.isEmpty()) {
                        orgItemInfo = new FilterItemInfo("orgUnit.id", orgUnitIds, CompareType.INCLUDE);
                        BgCommCHelper.replaceFilterItems((FilterInfo)filter, (FilterItemInfo)orgItemInfo);
                    }
                } else if (viewMap.containsKey(viewId) && ((MbgViewInfo)viewMap.get(viewId)).getSegregationRule().equals((Object)MemberSegregationRuleEnum.SEGREGATEORG)) {
                    FilterItemInfo orgItemInfo = null;
                    EntityViewInfo evi = new EntityViewInfo();
                    evi.setFilter(new FilterInfo());
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("mbgMember.viewId", (Object)viewId, CompareType.EQUALS));
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitid, CompareType.EQUALS));
                    MbgMemberNodeCollection coll = null;
                    try {
                        coll = MbgMemberNodeFactory.getLocalInstance((Context)ctx).getMbgMemberNodeCollection(evi);
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                    orgItemInfo = new FilterItemInfo("orgUnit.id", (Object)orgUnitid, CompareType.EQUALS);
                    BgCommCHelper.replaceFilterItems((FilterInfo)filter, (FilterItemInfo)orgItemInfo);
                    filter.getFilterItems().add(new FilterItemInfo("isSystemDefault", (Object)1, CompareType.EQUALS));
                    if (coll != null && !coll.isEmpty()) {
                        HashSet<String> memberids = new HashSet<String>();
                        for (int k = 0; k < coll.size(); ++k) {
                            memberids.add(coll.get(k).getMbgMember().getId().toString());
                        }
                        orgItemInfo = new FilterItemInfo("id", memberids, CompareType.INCLUDE);
                        BgCommCHelper.replaceFilterItems((FilterInfo)filter, (FilterItemInfo)orgItemInfo);
                        viewInfo.getFilter().setMaskString("#0 and ( #1 OR #2 OR #3)");
                    } else {
                        viewInfo.getFilter().setMaskString("#0 and ( #1 OR #2 )");
                    }
                }
                provider.setObjectView(viewInfo);
                IRowSet rowSet = provider.executeQuery();
                while (rowSet.next()) {
                    dimNumSet.add(rowSet.getString("NUMBER"));
                }
                if (dimNumMap.containsKey(srcNum)) {
                    ((Set)dimNumMap.get(srcNum)).addAll(dimNumSet);
                    continue;
                }
                dimNumMap.put(srcNum, dimNumSet);
            }
        }
        return dimNumMap;
    }

    private Set<String> getParentAndChildrenOrgUnitIds(Context ctx, BOSUuid orgUnitid) {
        CostCenterOrgUnitCollection costCenterColls = null;
        HashSet<String> orgUnitIds = new HashSet<String>();
        try {
            OrgUnitInfo unitInfo = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitid));
            if (unitInfo == null) {
                return new HashSet<String>();
            }
            String longNumber = unitInfo.getLongNumber();
            String[] tmpLongNumbers = longNumber.split("!");
            if (tmpLongNumbers.length == 1) {
                return new HashSet<String>();
            }
            longNumber = unitInfo.getLongNumber();
            Object[] parentNumbers = longNumber.split("!");
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("name");
            sic.add("number");
            sic.add("longnumber");
            filter.getFilterItems().add(new FilterItemInfo("number", new HashSet(Arrays.asList((Object[])parentNumbers)), CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)(unitInfo.getLongNumber() + "!%"), CompareType.LIKE));
            filter.setMaskString("#0 or #1");
            evi.setFilter(filter);
            evi.setSelector(sic);
            costCenterColls = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitCollection(evi);
        }
        catch (BOSException e) {
            logger.error((Object)"getParentAndChildrenOrgUnitIds error");
        }
        catch (EASBizException e) {
            logger.error((Object)"getParentAndChildrenOrgUnitIds error");
        }
        if (costCenterColls == null) {
            return new HashSet<String>();
        }
        for (int i = 0; i < costCenterColls.size(); ++i) {
            orgUnitIds.add(costCenterColls.get(i).getId().toString());
        }
        return orgUnitIds;
    }
}

