/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgParamNHelper;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgControlFacadeFactory;
import com.kingdee.eas.ma.control.BgControlRecordObj;
import com.kingdee.eas.ma.control.face.IControlParameter;
import com.kingdee.eas.ma.control.face.IControlResult;
import com.kingdee.eas.ma.control.face.IReturnControl;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeAccIntHelper;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReturnControlImpl
implements IReturnControl {
    private static Logger logger = Logger.getLogger((String)ReturnControlImpl.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IControlResult returnBudget(Context ctx, BOSUuid billID, IControlParameter parameter) throws Exception {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        block29: {
            if (ctx == null || billID == null || parameter == null) {
                throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
            }
            boolean isomer = parameter.getBgControlIsomer() != null;
            String _billId = null;
            String sql = null;
            if (isomer) {
                _billId = parameter.getBillId();
                sql = "select FID, FRefCube FROM T_MBG_BgScheme Where FRefCube IN(Select FCubeName from T_MBG_BgControlRecordDetail where FBillID = ? and FIsomer = 1 and FConnectionID = ? and FIsomerID = ? )";
            } else {
                _billId = billID.toString();
                sql = "select FID, FRefCube FROM T_MBG_BgScheme Where FRefCube IN(select FCubeName from T_MBG_BgControlRecordDetail where FBillID = ? and FIsomer = 0 )";
            }
            HashMap<String, String> cubes = new HashMap<String, String>();
            HashMap<String, BgSchemeAccIntHelper> accIntMap = new HashMap<String, BgSchemeAccIntHelper>();
            conn = null;
            pstmt = null;
            rst = null;
            try {
                conn = BgDBUtils.getConnection((Context)ctx);
                try {
                    pstmt = conn.prepareStatement(sql);
                    if (isomer) {
                        pstmt.setString(1, _billId);
                        pstmt.setString(2, parameter.getBgControlIsomer().getConnection().getId().toString());
                        pstmt.setString(3, parameter.getBgControlIsomer().getId().toString());
                    } else {
                        pstmt.setString(1, _billId);
                    }
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        cubes.put(rst.getString("FRefCube"), rst.getString("FID"));
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, (Statement)pstmt);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                if (cubes.isEmpty()) break block29;
                String cubeName2 = null;
                String cubeActual2 = null;
                String cubeControl = null;
                HashMap valueMap = new HashMap();
                BOSUuid viewId = null;
                pstmt = conn.prepareStatement("Select FMemberId FROM T_MBG_BgDimSettingsMember Where FType = 2 AND FBgDimSettingsID IN(Select FID FROM T_MBG_BgDimSettings Where FBgSchemeId IN(Select FID FROM T_MBG_BgScheme Where FRefCube = ?))");
                pstmt.setString(1, (String)cubes.get(0));
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    viewId = BOSUuid.read((String)rst.getString(1));
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                if (viewId != null) {
                    HashSet<String> orgUnitIds = new HashSet<String>();
                    int in = cubes.size();
                    for (int i = 0; i < in; ++i) {
                        cubeName2 = (String)cubes.get(i);
                        cubeControl = BgCubeUtils.getControlCubeName((String)cubeName2);
                        pstmt = conn.prepareStatement("Select FReqOrgUnitId FROM " + cubeControl + " Where FBillId = ?");
                        pstmt.setString(1, _billId);
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            orgUnitIds.add(rst.getString(1));
                        }
                        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                    }
                    if (!orgUnitIds.isEmpty()) {
                        BgControlFacadeFactory.getLocalInstance(ctx).lockTransaction(viewId, orgUnitIds);
                    }
                }
                HashSet<String> accNumbers = new HashSet<String>();
                String[] tables = new String[1];
                for (String cubeName2 : cubes.keySet()) {
                    cubeActual2 = BgCubeUtils.getActualCubeName((String)cubeName2);
                    cubeControl = BgCubeUtils.getControlCubeName((String)cubeName2);
                    valueMap.clear();
                    String bgSchemeId = (String)cubes.get(cubeName2);
                    BgSchemeAccIntHelper accIntHelper = (BgSchemeAccIntHelper)accIntMap.get(bgSchemeId);
                    if (accIntHelper == null) {
                        accIntHelper = new BgSchemeAccIntHelper(ctx, bgSchemeId, cubeName2);
                        accIntMap.put(bgSchemeId, accIntHelper);
                    }
                    try {
                        pstmt = conn.prepareStatement("select FActualID, sum(FActaulAmount), FBgIndexNum from " + cubeControl + " where FBillID = ? group by FActualID, FBgIndexNum");
                        pstmt.setString(1, _billId);
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            accNumbers.clear();
                            accNumbers.add(rst.getString("FBgIndexNum"));
                            cubeActual2 = accIntHelper.getSplitTablesByAcc(accNumbers).toArray(tables)[0];
                            if (!valueMap.containsKey(cubeActual2)) {
                                valueMap.put(cubeActual2, new HashMap());
                            }
                            ((Map)valueMap.get(cubeActual2)).put(rst.getString(1), rst.getBigDecimal(2));
                        }
                    }
                    finally {
                        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                    }
                    if (valueMap.isEmpty()) continue;
                    int batchSize = 50;
                    int batchIndex = 0;
                    Map.Entry entry2 = null;
                    for (String cubeActual2 : valueMap.keySet()) {
                        pstmt = conn.prepareStatement("Update " + cubeActual2 + " Set FValue = FValue - ?, FTmpValue = FTmpValue - ? where FID = ?");
                        for (Map.Entry entry2 : ((Map)valueMap.get(cubeActual2)).entrySet()) {
                            pstmt.setBigDecimal(1, (BigDecimal)entry2.getValue());
                            pstmt.setBigDecimal(2, (BigDecimal)entry2.getValue());
                            pstmt.setString(3, (String)entry2.getKey());
                            pstmt.addBatch();
                            if (++batchIndex < batchSize) continue;
                            pstmt.executeBatch();
                            batchIndex = 0;
                        }
                        if (batchIndex > 0) {
                            pstmt.executeBatch();
                        }
                        SQLUtils.cleanup((Statement)pstmt);
                    }
                    if (BgParamNHelper.isRecordProcess((Context)ctx)) {
                        this.writeControlRecord(conn, _billId, cubeControl);
                        continue;
                    }
                    BgDBUtils.executeUpdate((Connection)conn, (String)("delete from " + cubeControl + " where FBillID = ?"), (Object[])new Object[]{_billId});
                }
                BgDBUtils.executeUpdate((Connection)conn, (String)"delete from T_MBG_BgControlRecordDetail where FBillID = ?", (Object[])new Object[]{_billId});
            }
            catch (SQLDataException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                    catch (SQLException ex2) {
                        logger.error((Object)"returnBudget", (Throwable)ex2);
                        throw new BgControlException(BgControlException.DATABASEEXCEPTION, new String[]{ex2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        parameter.getResult().setResult(1);
        return parameter.getResult();
    }

    protected void writeControlRecord(Connection conn, String _billId, String cubeControl) throws SQLException, BgControlException {
        StringBuffer querySql = new StringBuffer();
        querySql.append("select FBillID, FBillNumber, FBillType, sum(FActaulAmount) as FActaulAmount,FBizDate, FActualID, FBizOrgUnitID, FReqOrgUnitID, FControlType, FFormula, FBgIndexNum, FItemExtNumber, FBgPeriodID,FCurrencyID, FBgElementID, FScenario, FVersion, FBgSettingID, FCONNECTIONID, FISOMERID from  " + cubeControl + " where FBillID = ?  group by FBillID, FBillNumber, FBillType,FBizDate, FActualID, FBizOrgUnitID, FReqOrgUnitID, FControlType, FFormula, FBgIndexNum, FItemExtNumber, FBgPeriodID,FCurrencyID, FBgElementID, FScenario, FVersion, FBgSettingID, FCONNECTIONID, FISOMERID");
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into ").append(cubeControl).append(" (FID, FCreateTime, FBillID, FBillNumber, FBillType, FActaulAmount, FBizDate, FActualID, FBizOrgUnitID, FReqOrgUnitID, FControlType, FFormula, FBgIndexNum, FItemExtNumber, FBgPeriodID, FCurrencyID, FBgElementID, FScenario, FVersion, FBgSettingID, FCONNECTIONID, FISOMERID) Values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        int batchSize = 50;
        int batchIndex = 0;
        PreparedStatement pstmt = null;
        IRowSet rowSet = null;
        try {
            rowSet = BgDBUtils.executeQuery((Connection)conn, (String)querySql.toString(), (Object[])new Object[]{_billId});
            pstmt = conn.prepareStatement(sql.toString());
            while (rowSet.next()) {
                BgControlRecordObj recordInfo = new BgControlRecordObj();
                pstmt.setString(1, BOSUuid.create((BOSObjectType)recordInfo.getBOSType()).toString());
                pstmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                pstmt.setString(3, rowSet.getString("FBillID"));
                pstmt.setString(4, rowSet.getString("FBillNumber"));
                pstmt.setString(5, rowSet.getString("FBillType"));
                pstmt.setBigDecimal(6, rowSet.getBigDecimal("FActaulAmount").multiply(new BigDecimal(-1)));
                pstmt.setTimestamp(7, rowSet.getTimestamp("FBizDate"));
                pstmt.setString(8, rowSet.getString("FActualID"));
                pstmt.setString(9, rowSet.getString("FBizOrgUnitID"));
                pstmt.setString(10, rowSet.getString("FReqOrgUnitID"));
                pstmt.setInt(11, rowSet.getInt("FControlType"));
                pstmt.setString(12, rowSet.getString("FFormula"));
                pstmt.setString(13, rowSet.getString("FBgIndexNum"));
                pstmt.setString(14, rowSet.getString("FItemExtNumber"));
                pstmt.setString(15, rowSet.getString("FBgPeriodID"));
                pstmt.setString(16, rowSet.getString("FCurrencyID"));
                pstmt.setString(17, rowSet.getString("FBgElementID"));
                pstmt.setInt(18, rowSet.getInt("FScenario"));
                pstmt.setInt(19, rowSet.getInt("FVersion"));
                pstmt.setString(20, rowSet.getString("FBgSettingID"));
                pstmt.setString(21, rowSet.getString("FCONNECTIONID"));
                pstmt.setString(22, rowSet.getString("FISOMERID"));
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex > 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"returnBudget", (Throwable)ex);
                throw new BgControlException(BgControlException.DATABASEEXCEPTION, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rowSet, pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rowSet, (Statement)pstmt);
    }
}

