/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.impl.models;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgDimCacheUtils;
import com.kingdee.eas.ma.base.utils.BgPeriodDispHelper;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgControlExpendRuleInfo;
import com.kingdee.eas.ma.control.BgControlNotNullBudgetEnum;
import com.kingdee.eas.ma.control.BgControlNullBudgetEnum;
import com.kingdee.eas.ma.control.BgControlSettingInfo;
import com.kingdee.eas.ma.control.BgCtrlTypeEnum;
import com.kingdee.eas.ma.control.BgCurrencyMappingInfo;
import com.kingdee.eas.ma.control.BgReqRuleEnum;
import com.kingdee.eas.ma.control.impl.models.BgGroupData;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgSchemeTypeInfo;
import com.kingdee.eas.ma.mbg.common.ISplitData;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BgControlParam
implements Serializable,
Cloneable,
ISplitData {
    private static final long serialVersionUID = 6944269029418397342L;
    private BgSchemeInfo bgSchemeInfo = null;
    private BgSchemeTypeInfo bgSchemeType = null;
    private BigDecimal overBalance;
    private OrgUnitInfo orgUnit = null;
    private String bgIndexNumber = null;
    private String dimItemNumber = null;
    private String dimItemName = null;
    private String dimNumber = null;
    private BgPeriodTypeInfo bgPeriodGroup = null;
    private int bgPeriodType = 4;
    private int bgRealPeriodType = 4;
    private String bgRealPeriodId = null;
    private String bgRealPeriodNumber = null;
    private String bgPeriodId = null;
    private String bgPeriodNumber = null;
    private String bgPeriodName = null;
    private BgElementInfo bgElement = null;
    private CurrencyInfo currency = null;
    private BgScenarioInfo bgScenario = null;
    private BgScenarioInfo acScenario = null;
    private BgVersionInfo version = null;
    private String formula = null;
    private String billId = null;
    private String billNumber = null;
    private OrgUnitInfo reqOrgUnit = null;
    private Timestamp bizDate = null;
    private BigDecimal reqAmount = BgControlConstants.ZERO;
    private BigDecimal reqExtAmount = BgControlConstants.ZERO;
    private List<BigDecimal> reqAmounts = new ArrayList<BigDecimal>();
    private BgControlSettingInfo controlSetting = null;
    private boolean isAllowAccessOfBgScheme = false;
    private BgControlNullBudgetEnum nullBudget = BgControlNullBudgetEnum.NoPass;
    private BgControlNotNullBudgetEnum notNullBudget = BgControlNotNullBudgetEnum.Pass;
    private boolean allowAccess = false;
    private boolean overBudget = false;
    private boolean notBudget = false;
    private BigDecimal budgetValue = null;
    private BigDecimal actualValue = null;
    private BigDecimal transitBudgetValue = BigDecimal.ZERO;
    private boolean isCalcAddupBalance = false;
    private Map<String, BigDecimal> addupTransitBudgetValue = new HashMap<String, BigDecimal>();
    private Map<String, BigDecimal> addupBudgetValue = new HashMap<String, BigDecimal>();
    private Map<String, BigDecimal> addupActualValue = new HashMap<String, BigDecimal>();
    private BigDecimal balance = null;
    private Map<String, BigDecimal> addupBalance = new HashMap<String, BigDecimal>();
    private boolean isExpandCtrlParam = false;
    private boolean isUserExpand = false;
    private BigDecimal extBudget = null;
    private BigDecimal extTransitBudget = BigDecimal.ZERO;
    private BigDecimal extActual = null;
    private BigDecimal extBalance = null;
    private Map<String, BgGroupData> budgetDetail = new HashMap<String, BgGroupData>();
    private Map<String, BgGroupData> actualDetail = new HashMap<String, BgGroupData>();
    private Map<BOSUuid, List<BgGroupData>> bgGroupMap = new HashMap<BOSUuid, List<BgGroupData>>();
    private Set<String> noMembers = new HashSet<String>();
    private BigDecimal expandBalance = null;
    private boolean isOnlyExpandControl = false;
    private BgControlExpendRuleInfo expandInfo = null;
    private BgControlParam expandCtrlParam = null;
    private Map<String, BgControlParam> expandGroupParam = new HashMap<String, BgControlParam>();
    private Object[] calculateFormula = null;
    private boolean isBgExcuteAnaly = false;
    public String extGroupKey = null;
    private String addupActualPeriod = null;
    private Set<String> hasActualPeriods = new LinkedHashSet<String>();
    private String maxHasActualPeriod = null;
    private List<String> refBgPeriods = null;
    private List<String> refAcPeriods = null;
    public static final String TO_CURR = "TO_CURR";
    public static final String TO_ALL = "TO_ALL";
    private Set<String> groupDimItemNumbers = new LinkedHashSet<String>();
    private boolean isQueryOrgEntrust = false;
    private List<BgCurrencyMappingInfo> currencyMappings = new ArrayList<BgCurrencyMappingInfo>();
    private String billEntryId = null;
    private List<String> billEntryIds = new ArrayList<String>();
    private String assistRecordsId = null;
    private List<String> assistRecords = new ArrayList<String>();

    public BgControlParam clone() throws CloneNotSupportedException {
        BgControlParam clone = (BgControlParam)super.clone();
        clone.actualDetail = new HashMap<String, BgGroupData>(this.actualDetail);
        clone.bgGroupMap = new HashMap<BOSUuid, List<BgGroupData>>(this.bgGroupMap);
        clone.budgetDetail = new HashMap<String, BgGroupData>(this.budgetDetail);
        if (this.noMembers != null) {
            clone.noMembers = new HashSet<String>(this.noMembers);
        }
        if (this.refBgPeriods != null) {
            clone.refBgPeriods = new ArrayList<String>(this.refBgPeriods);
        }
        if (this.reqAmounts != null) {
            clone.reqAmounts = new ArrayList<BigDecimal>(this.reqAmounts);
        }
        clone.addupActualValue = new HashMap<String, BigDecimal>();
        clone.addupBudgetValue = new HashMap<String, BigDecimal>();
        clone.addupTransitBudgetValue = new HashMap<String, BigDecimal>();
        clone.addupBalance = new HashMap<String, BigDecimal>();
        clone.addupActualPeriod = null;
        clone.addupBalance = new HashMap<String, BigDecimal>();
        clone.isCalcAddupBalance = false;
        clone.hasActualPeriods = new HashSet<String>();
        return clone;
    }

    public void setBgSchemeInfo(BgSchemeInfo bgSchemeInfo) {
        this.bgSchemeInfo = bgSchemeInfo;
    }

    public BgSchemeInfo getBgSchemeInfo() {
        return this.bgSchemeInfo;
    }

    public void setBgSchemeType(BgSchemeTypeInfo bgSchemeType) {
        this.bgSchemeType = bgSchemeType;
    }

    public BgSchemeTypeInfo getBgSchemeType() {
        return this.bgSchemeType;
    }

    public BigDecimal getOverBalance() {
        return this.overBalance;
    }

    public void setOverBalance(BigDecimal overBalance) {
        this.overBalance = overBalance;
    }

    public void setOrgUnit(OrgUnitInfo orgUnit) {
        this.orgUnit = orgUnit;
    }

    public OrgUnitInfo getOrgUnit() {
        return this.orgUnit;
    }

    public void setBgIndexNumber(String bgIndexNumber) {
        this.bgIndexNumber = bgIndexNumber;
    }

    public String getBgIndexNumber() {
        return this.bgIndexNumber;
    }

    public void setDimItemNumber(String dimItemNumber) {
        this.dimItemNumber = dimItemNumber;
    }

    public String getDimItemNumber() {
        return this.dimItemNumber;
    }

    public void setDimItemName(String dimItemName) {
        this.dimItemName = dimItemName;
    }

    public String getDimItemName() {
        return this.dimItemName;
    }

    public void setDimNumber(String dimNumber) {
        this.dimNumber = dimNumber;
    }

    public String getDimNumber() {
        return this.dimNumber;
    }

    public void setBgPeriodGroup(BgPeriodTypeInfo bgPeriodGroup) {
        this.bgPeriodGroup = bgPeriodGroup;
    }

    public BgPeriodTypeInfo getBgPeriodGroup() {
        return this.bgPeriodGroup;
    }

    public void setBgPeriodType(int bgPeriodType) {
        this.bgPeriodType = bgPeriodType;
    }

    public int getBgPeriodType() {
        return this.bgPeriodType;
    }

    public int getBgRealPeriodType() {
        return this.bgRealPeriodType;
    }

    public void setBgRealPeriodType(int bgRealPeriodType) {
        this.bgRealPeriodType = bgRealPeriodType;
    }

    public String getBgRealPeriodId() {
        return this.bgRealPeriodId;
    }

    public void setBgRealPeriodId(String bgRealPeriodId) {
        this.bgRealPeriodId = bgRealPeriodId;
    }

    public String getBgRealPeriodNumber() {
        return this.bgRealPeriodNumber;
    }

    public void setBgRealPeriodNumber(String bgRealPeriodNumber) {
        this.bgRealPeriodNumber = bgRealPeriodNumber;
    }

    public void setBgPeriodId(String bgPeriodId) {
        this.bgPeriodId = bgPeriodId;
    }

    public String getBgPeriodId() {
        return this.bgPeriodId;
    }

    public void setBgPeriodNumber(String bgPeriodNumber) {
        this.bgPeriodNumber = bgPeriodNumber;
    }

    public String getBgPeriodNumber() {
        return this.bgPeriodNumber;
    }

    public void setBgPeriodName(String bgPeriodName) {
        this.bgPeriodName = bgPeriodName;
    }

    public String getBgPeriodName() {
        return this.bgPeriodName;
    }

    public BgElementInfo getBgElement() {
        return this.bgElement;
    }

    public void setBgElement(BgElementInfo bgElement) {
        this.bgElement = bgElement;
    }

    public void setCurrency(CurrencyInfo currency) {
        this.currency = currency;
    }

    public CurrencyInfo getCurrency() {
        return this.currency;
    }

    public void setBgScenario(BgScenarioInfo bgScenario) {
        this.bgScenario = bgScenario;
    }

    public BgScenarioInfo getBgScenario() {
        return this.bgScenario;
    }

    public void setAcScenario(BgScenarioInfo acScenario) {
        this.acScenario = acScenario;
    }

    public BgScenarioInfo getAcScenario() {
        return this.acScenario;
    }

    public BgVersionInfo getVersion() {
        return this.version;
    }

    public void setVersion(BgVersionInfo version) {
        this.version = version;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setBillId(String billId) {
        this.billId = billId;
    }

    public String getBillId() {
        return this.billId;
    }

    public void setBillNumber(String billNumber) {
        this.billNumber = billNumber;
    }

    public String getBillNumber() {
        return this.billNumber;
    }

    public void setReqOrgUnit(OrgUnitInfo reqOrgUnit) {
        this.reqOrgUnit = reqOrgUnit;
    }

    public OrgUnitInfo getReqOrgUnit() {
        return this.reqOrgUnit;
    }

    public void setBizDate(Timestamp bizDate) {
        this.bizDate = bizDate;
    }

    public Timestamp getBizDate() {
        return this.bizDate;
    }

    public void setReqAmount(BigDecimal reqAmount) {
        this.reqAmount = reqAmount;
    }

    public BigDecimal getReqAmount() {
        return this.reqAmount;
    }

    public void setReqExtAmount(BigDecimal reqExtAmount) {
        this.reqExtAmount = reqExtAmount;
    }

    public BigDecimal getReqExtAmount() {
        return this.reqExtAmount;
    }

    public List<BigDecimal> getReqAmounts() {
        return this.reqAmounts;
    }

    public void setControlSetting(BgControlSettingInfo controlSetting) {
        this.controlSetting = controlSetting;
    }

    public BgControlSettingInfo getControlSetting() {
        return this.controlSetting;
    }

    public void setIsAllowAccessOfBgScheme(boolean isAllowAccessOfBgScheme) {
        this.isAllowAccessOfBgScheme = isAllowAccessOfBgScheme;
    }

    public boolean isAllowAccessOfBgScheme() {
        return this.isAllowAccessOfBgScheme;
    }

    public boolean isCtrlOfEmpty() {
        return BgControlNullBudgetEnum.Pass.equals((Object)this.getNullBudget()) || BgControlNullBudgetEnum.PassWithNoCtrlSet.equals((Object)this.getNullBudget()) && BgCtrlTypeEnum.NoCtrl.equals((Object)this.getControlSetting().getCtrlType());
    }

    public void setNullBudget(BgControlNullBudgetEnum nullBudget) {
        this.nullBudget = nullBudget;
    }

    public BgControlNullBudgetEnum getNullBudget() {
        return this.nullBudget;
    }

    public void setNotNullBudget(BgControlNotNullBudgetEnum notNullBudget) {
        this.notNullBudget = notNullBudget;
    }

    public BgControlNotNullBudgetEnum getNotNullBudget() {
        return this.notNullBudget;
    }

    public void setAllowAccess(boolean allowAccess) {
        this.allowAccess = allowAccess;
    }

    public boolean isAllowAccess() {
        return this.allowAccess;
    }

    public void setOverBudget(boolean overBudget) {
        this.overBudget = overBudget;
    }

    public boolean isOverBudget() {
        return this.overBudget;
    }

    public void setNotBudget(boolean notBudget) {
        this.notBudget = notBudget;
    }

    public boolean isNotBudget() {
        return this.notBudget;
    }

    public void setBudgetValue(BigDecimal budgetValue) {
        this.budgetValue = budgetValue;
    }

    public BigDecimal getBudgetValue() {
        return this.budgetValue;
    }

    public void setActualValue(BigDecimal actualValue) {
        this.actualValue = actualValue;
    }

    public BigDecimal getActualValue() {
        return this.actualValue;
    }

    public BigDecimal getTransitBudgetValue() {
        return this.transitBudgetValue;
    }

    public void setTransitBudgetValue(BigDecimal transitBudgetValue) {
        this.transitBudgetValue = transitBudgetValue;
    }

    public void setCalcAddupBalance(boolean isCalcAddupBalance) {
        this.isCalcAddupBalance = isCalcAddupBalance;
    }

    public boolean isCalcAddupBalance() {
        return this.isCalcAddupBalance;
    }

    public Map<String, BigDecimal> getAddupTransitBudgetValue() {
        return this.addupTransitBudgetValue;
    }

    public Map<String, BigDecimal> getAddupBudgetValue() {
        return this.addupBudgetValue;
    }

    public Map<String, BigDecimal> getAddupActualValue() {
        return this.addupActualValue;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public Map<String, BigDecimal> getAddupBalance() {
        return this.addupBalance;
    }

    public boolean isExpandCtrlParam() {
        return this.isExpandCtrlParam;
    }

    public void setIsExpandCtrlParam(boolean isExpandCtrlParam) {
        this.isExpandCtrlParam = isExpandCtrlParam;
    }

    public BigDecimal getBalance() {
        if (this.balance == null && this.expandBalance == null) {
            return null;
        }
        BigDecimal _balance = this.balance;
        this.isUserExpand = false;
        if (this.getExpandInfo() != null) {
            BigDecimal _expBalance;
            this.isUserExpand = true;
            if (this.getExtBalance() != null) {
                _balance = this.getExtBalance();
            }
            if (_balance == null) {
                _balance = BgNConstants.ZERO;
            }
            if ((_expBalance = this.expandBalance) == null) {
                _expBalance = BgNConstants.ZERO;
            }
            if (BgReqRuleEnum.CTRLVAL.equals((Object)this.getExpandInfo().getBgReqRule())) {
                if (this.getExpandBalance() == null) {
                    return BgNConstants.ZERO;
                }
                return this.getExpandBalance();
            }
            if (BgReqRuleEnum.MINVAL.equals((Object)this.getExpandInfo().getBgReqRule())) {
                if (_balance.compareTo(_expBalance) <= 0) {
                    this.isUserExpand = false;
                }
                return _balance.min(_expBalance);
            }
            if (_balance.compareTo(_expBalance) >= 0) {
                this.isUserExpand = false;
            }
            return _balance.max(_expBalance);
        }
        return _balance;
    }

    public boolean isUserExpand() {
        return this.isUserExpand;
    }

    public BigDecimal getOrignBalance() {
        return this.balance;
    }

    public void setExtBudget(BigDecimal extBudget) {
        this.extBudget = extBudget;
    }

    public BigDecimal getExtBudget() {
        return this.extBudget;
    }

    public BigDecimal getExtTransitBudget() {
        return this.extTransitBudget;
    }

    public void setExtTransitBudget(BigDecimal extTransitBudget) {
        this.extTransitBudget = extTransitBudget;
    }

    public void setExtActual(BigDecimal extActual) {
        this.extActual = extActual;
    }

    public BigDecimal getExtActual() {
        return this.extActual;
    }

    public void setExtBalance(BigDecimal extBalance) {
        this.extBalance = extBalance;
    }

    public BigDecimal getOrignExtBalance() {
        return this.extBalance;
    }

    public BigDecimal getExtBalance() {
        return this.extBalance;
    }

    public Map<String, BgGroupData> getBudgetDetail() {
        return this.budgetDetail;
    }

    public Map<String, BgGroupData> getActualDetail() {
        return this.actualDetail;
    }

    public Map<BOSUuid, List<BgGroupData>> getBgGroupMap() {
        return this.bgGroupMap;
    }

    public Set<String> getNoMembers() {
        return this.noMembers;
    }

    public void setExpandBalance(BigDecimal expandBalance) {
        this.expandBalance = expandBalance;
    }

    public BigDecimal getExpandBalance() {
        return this.expandBalance;
    }

    public void setOnlyExpandControl(boolean isOnlyExpandControl) {
        this.isOnlyExpandControl = isOnlyExpandControl;
    }

    public boolean isOnlyExpandControl() {
        return this.isOnlyExpandControl;
    }

    public void setExpandInfo(BgControlExpendRuleInfo expandInfo) {
        this.expandInfo = expandInfo;
    }

    public BgControlExpendRuleInfo getExpandInfo() {
        return this.expandInfo;
    }

    public void setExpandCtrlParam(BgControlParam expandCtrlParam) {
        this.expandCtrlParam = expandCtrlParam;
    }

    public BgControlParam getExpandCtrlParam() {
        return this.expandCtrlParam;
    }

    public Map<String, BgControlParam> getExpandGroupAccs() {
        return this.expandGroupParam;
    }

    public Object[] getCalculateFormula() {
        return this.calculateFormula;
    }

    public void setCalculateFormula(Object[] calculateFormula) {
        this.calculateFormula = calculateFormula;
    }

    public boolean isBgExcuteAnaly() {
        return this.isBgExcuteAnaly;
    }

    public void setBgExcuteAnaly(boolean isBgExcuteAnaly) {
        this.isBgExcuteAnaly = isBgExcuteAnaly;
    }

    public String getControlParamKey() {
        StringBuffer key = new StringBuffer();
        key.append(this.getOrgUnit().getNumber() + "\\|" + this.getBgSchemeType().getNumber() + "\\|" + this.getDimItemNumber() + "\\|" + this.getBgPeriodNumber() + "\\|" + this.getBgElement().getNumber() + "\\|" + this.getCurrency().getNumber() + "\\|" + this.getBgScenario().getNumber() + "\\|" + this.getAcScenario().getNumber() + "\\|" + this.getBizDate());
        return key.toString();
    }

    public void createGroupKey() {
        if (this.getControlSetting() != null && this.getControlSetting().isIsGroupCtrl() && 0 == this.getControlSetting().getCtrlSetRule().getValue()) {
            HashMap<String, String> dimNumMap = new HashMap<String, String>();
            String[] tmpStrs = null;
            String dimNumber2 = this.getControlSetting().getBgIndexNumber();
            String srcNumber = dimNumber2.substring(0, 3);
            dimNumMap.put(srcNumber, dimNumber2);
            if (!StringUtils.isEmpty((String)this.getControlSetting().getBgDimNumber()) && (tmpStrs = this.getControlSetting().getBgDimNumber().split(",")) != null) {
                int in = tmpStrs.length;
                for (int i = 0; i < in; ++i) {
                    dimNumber2 = tmpStrs[i];
                    if (dimNumber2 == null || dimNumber2.length() <= 3) continue;
                    srcNumber = dimNumber2.substring(0, 3);
                    dimNumMap.put(srcNumber, dimNumber2);
                }
            }
            if ((tmpStrs = this.getDimItemNumber().split(",")) != null) {
                for (String dimNumber2 : tmpStrs) {
                    srcNumber = dimNumber2.substring(0, 3);
                    if (dimNumMap.containsKey(srcNumber)) continue;
                    if (this.extGroupKey == null) {
                        this.extGroupKey = dimNumber2;
                        continue;
                    }
                    if (this.extGroupKey.indexOf(dimNumber2) != -1) continue;
                    this.extGroupKey = this.extGroupKey + "," + dimNumber2;
                }
            }
        }
    }

    public String getControlGroupKey() {
        if (this.getControlSetting() == null || !this.getControlSetting().isIsGroupCtrl() || StringUtils.isEmpty((String)this.getControlSetting().getGroupNo())) {
            return null;
        }
        return this.getControlSetting().getScheme().getId() + "_" + this.getOrgUnit().getId() + "_" + this.getControlSetting().getGroupNo();
    }

    public static String getControlGroupKey(String controlSchemeId, String orgUnitId, String groupNo) {
        return controlSchemeId + "_" + orgUnitId + "_" + groupNo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> getBgPeirodByScheme(Context ctx) throws EASBizException, BOSException {
        ArrayList<String> bgPeriodNums = new ArrayList<String>();
        HashMap bgPeriodCacheMap = (HashMap)BgDimCacheUtils.getObject((Context)ctx, (String)"BudgetControlDataCache-Period");
        if (bgPeriodCacheMap == null) {
            bgPeriodCacheMap = new HashMap();
        }
        Date start = new Date();
        Date beover = new Date();
        Date bTime = this.getControlSetting().getScheme().getBeginTime();
        Date eTime = this.getControlSetting().getScheme().getEndTime();
        Date fTime = this.getBgSchemeInfo().getDateFrom();
        Date tTime = this.getBgSchemeInfo().getDateTo();
        if (bTime.getTime() >= tTime.getTime() || fTime.getTime() >= eTime.getTime()) {
            if (bTime.getTime() == beover.getTime()) {
                start = bTime;
                beover = bTime;
            } else {
                if (fTime.getTime() != eTime.getTime()) return bgPeriodNums;
                start = eTime;
                beover = eTime;
            }
        } else {
            start = bTime.getTime() >= fTime.getTime() ? bTime : fTime;
            beover = eTime.getTime() >= tTime.getTime() ? tTime : eTime;
        }
        String cacheKey = this.getBgPeriodGroup().getId() + "!" + this.getBgPeriodType() + "!" + start.getTime() + "!" + beover.getTime();
        if (bgPeriodCacheMap.containsKey(cacheKey)) {
            bgPeriodNums.addAll((Collection)bgPeriodCacheMap.get(cacheKey));
            return bgPeriodNums;
        } else {
            HashSet<String> cacheSet = new HashSet<String>();
            bgPeriodCacheMap.put(cacheKey, cacheSet);
            BgPeriodCollection colls = BgPeriodDispHelper.getPeriodColls((Context)ctx, (BOSUuid)this.getBgPeriodGroup().getId(), (int)this.getBgPeriodType(), (Date)start, (Date)beover);
            if (colls != null) {
                int in = colls.size();
                for (int i = 0; i < in; ++i) {
                    bgPeriodNums.add(colls.get(i).getNumber());
                }
                cacheSet.addAll(bgPeriodNums);
            }
            BgDimCacheUtils.putObject((Context)ctx, (String)"BudgetControlDataCache-Period", bgPeriodCacheMap);
        }
        return bgPeriodNums;
    }

    public List<String> getBgPeirodBySetting(Context ctx, int valueType, Map<String, List<String>> bgPeriodCacheMap) throws Exception {
        ArrayList<String> bgPeriodNums = new ArrayList<String>();
        if (this.getControlSetting() == null) {
            bgPeriodNums.add(this.getBgPeriodNumber());
        } else if (valueType == 1 || valueType == 2) {
            bgPeriodNums.addAll(this.getRefBgPeriods(ctx, bgPeriodCacheMap));
        } else if (valueType == 4) {
            bgPeriodNums.addAll(this.getRefAcPeriods(ctx, bgPeriodCacheMap));
        } else if (valueType == 8) {
            HashSet<String> tmpSet = new HashSet<String>();
            tmpSet.addAll(this.getRefBgPeriods(ctx, bgPeriodCacheMap));
            tmpSet.addAll(this.getRefAcPeriods(ctx, bgPeriodCacheMap));
            bgPeriodNums.addAll(tmpSet);
        }
        return bgPeriodNums;
    }

    public String getAddupActualPeriod() {
        return this.addupActualPeriod;
    }

    public void setAddupActualPeriod(String addupActualPeriod) {
        this.addupActualPeriod = addupActualPeriod;
    }

    public Set<String> getHasActualPeriods() {
        if (this.hasActualPeriods.isEmpty()) {
            this.hasActualPeriods.add(this.getBgPeriodNumber());
        }
        return this.hasActualPeriods;
    }

    public boolean addHasActualPeriod(String period) {
        if (this.getBgPeriodNumber().compareTo(period) < 0) {
            this.getHasActualPeriods().add(period);
            return true;
        }
        return false;
    }

    public String getMaxHasActualPeriod() {
        if (this.maxHasActualPeriod == null) {
            for (String addPeriod : this.getHasActualPeriods()) {
                if (this.maxHasActualPeriod == null) {
                    this.maxHasActualPeriod = addPeriod;
                    continue;
                }
                if (this.maxHasActualPeriod.compareTo(addPeriod) >= 0) continue;
                this.maxHasActualPeriod = addPeriod;
            }
        }
        return this.maxHasActualPeriod;
    }

    public boolean checkIsInPeriodForAddCtrl(String bgPeriodNumber, String addPeriodNumber) {
        if (!this.isAddupCtrl()) {
            return true;
        }
        return bgPeriodNumber.compareTo(addPeriodNumber) <= 0;
    }

    public boolean checkNeedCalcActPeriod(boolean isCalcHasActPeriod) {
        return !isCalcHasActPeriod || this.isAddupCtrl();
    }

    public boolean isAddupCtrl(int ctrlType) {
        return 11 == ctrlType;
    }

    public boolean isAddupCtrl() {
        return this.isAddupCtrl(this.getControlSetting().getCtrlType().getValue());
    }

    public List<String> getRefBgPeriods() {
        return this.refBgPeriods;
    }

    public List<String> getRefBgPeriods(Context ctx, Map<String, List<String>> bgPeriodCacheMap) throws EASBizException, BOSException {
        this.refBgPeriods = new ArrayList<String>();
        if (this.getControlSetting() == null || BgCtrlTypeEnum.NoCtrl.equals((Object)this.getControlSetting().getCtrlType()) || BgCtrlTypeEnum.PeriodCtrl.equals((Object)this.getControlSetting().getCtrlType())) {
            this.refBgPeriods.add(this.getBgPeriodNumber());
        } else {
            int refPeriodType = this.getControlSetting().getPeriodType().getValue();
            if (0 == refPeriodType || this.getBgPeriodType() == 19 || this.getBgPeriodType() == 20) {
                List<String> tmpList = this.getBgPeirodByScheme(ctx);
                if (tmpList != null) {
                    this.refBgPeriods.addAll(this.filterBgPeriodNumber(tmpList));
                }
            } else if (1 == refPeriodType) {
                this.refBgPeriods.addAll(this.getBgPeriodsByData(ctx, this.getBizDate(), 1, this.getBgPeriodType(), bgPeriodCacheMap));
            } else if (2 == refPeriodType) {
                this.refBgPeriods.addAll(this.getBgPeriodsByData(ctx, this.getBizDate(), 2, this.getBgPeriodType(), bgPeriodCacheMap));
            } else if (3 == refPeriodType) {
                this.refBgPeriods.addAll(this.getBgPeriodsByData(ctx, this.getBizDate(), 3, this.getBgPeriodType(), bgPeriodCacheMap));
            } else if (4 == refPeriodType) {
                if (this.getBgPeriodType() == 5) {
                    throw new BgControlException(BgControlException.NOFOUNDBGPERIOD);
                }
                this.refBgPeriods.addAll(this.getBgPeriodsByData(ctx, this.getBizDate(), 4, this.getBgPeriodType(), bgPeriodCacheMap));
            }
        }
        return this.refBgPeriods;
    }

    public List<String> getBgPeriodNums(int bgCtrlType, boolean hasBudget, List<String> bgPeriodNums) {
        List<String> _bgPeriodNums = new ArrayList<String>();
        if (bgCtrlType == 11) {
            _bgPeriodNums = hasBudget ? this.getRefBgPeriods() : this.getRefAcPeriods();
        } else if (bgCtrlType == 12) {
            _bgPeriodNums = hasBudget ? this.getRefAcPeriods() : bgPeriodNums;
        }
        return _bgPeriodNums;
    }

    public List<String> getRefAcPeriods() {
        return this.refAcPeriods;
    }

    public List<String> getRefAcPeriods(Context ctx, Map<String, List<String>> bgPeriodCacheMap) throws EASBizException, BOSException {
        this.refAcPeriods = new ArrayList<String>();
        if (this.getControlSetting() == null || -1 == this.getControlSetting().getCtrlType().getValue() || 10 == this.getControlSetting().getCtrlType().getValue()) {
            this.refAcPeriods.add(this.getBgPeriodNumber());
        } else {
            int refPeriodType = this.getControlSetting().getPeriodType().getValue();
            if (0 == refPeriodType || this.getBgPeriodType() == 19 || this.getBgPeriodType() == 20) {
                this.refAcPeriods.addAll(this.getBgPeirodByScheme(ctx));
            } else if (1 == refPeriodType) {
                this.refAcPeriods.addAll(this.getBgPeriodsByAllData(ctx, this.getBizDate(), 1, this.getBgPeriodType(), bgPeriodCacheMap));
            } else if (2 == refPeriodType) {
                this.refAcPeriods.addAll(this.getBgPeriodsByAllData(ctx, this.getBizDate(), 2, this.getBgPeriodType(), bgPeriodCacheMap));
            } else if (3 == refPeriodType) {
                this.refAcPeriods.addAll(this.getBgPeriodsByAllData(ctx, this.getBizDate(), 3, this.getBgPeriodType(), bgPeriodCacheMap));
            } else if (4 == refPeriodType) {
                if (this.getBgPeriodType() == 5) {
                    throw new BgControlException(BgControlException.NOFOUNDBGPERIOD);
                }
                this.refAcPeriods.addAll(this.getBgPeriodsByAllData(ctx, this.getBizDate(), 4, this.getBgPeriodType(), bgPeriodCacheMap));
            }
        }
        return this.refAcPeriods;
    }

    private List<String> filterBgPeriodNumber(List<String> bgPeriodNums) {
        return bgPeriodNums;
    }

    private List<String> getBgPeriodsByData(Context ctx, Date date, int periodCycle, int periodType, Map<String, List<String>> bgPeriodCacheMap) {
        ArrayList<String> bgPeriods = new ArrayList<String>();
        List tmpList = null;
        if (bgPeriodCacheMap != null) {
            String key = "" + date.getTime() + "!" + periodCycle + "!" + periodType + "!" + TO_CURR + "_" + this.getBgPeriodGroup().getId();
            if (bgPeriodCacheMap.containsKey(key)) {
                tmpList = bgPeriodCacheMap.get(key);
            } else {
                tmpList = BgPeriodDispHelper.getPeriodNums((Context)ctx, (Date)date, (Date)this.getBgSchemeInfo().getDateFrom(), (Date)this.getBgSchemeInfo().getDateTo(), (int)periodCycle, (int)periodType, (BOSUuid)this.getBgPeriodGroup().getId());
                bgPeriodCacheMap.put(key, tmpList);
            }
        } else {
            tmpList = BgPeriodDispHelper.getPeriodNums((Context)ctx, (Date)date, (Date)this.getBgSchemeInfo().getDateFrom(), (Date)this.getBgSchemeInfo().getDateTo(), (int)periodCycle, (int)periodType, (BOSUuid)this.getBgPeriodGroup().getId());
        }
        if (tmpList != null) {
            for (String bgPeriodNum : tmpList) {
                bgPeriods.add(bgPeriodNum);
            }
        }
        return bgPeriods;
    }

    private List<String> getBgPeriodsByAllData(Context ctx, Timestamp date, int periodCycle, int periodType, Map<String, List<String>> bgPeriodCacheMap) {
        List bgPeriods = null;
        if (bgPeriodCacheMap != null) {
            String key = "" + date.getTime() + "!" + periodCycle + "!" + periodType + "!" + TO_ALL + "_" + this.getBgPeriodGroup().getId();
            if (bgPeriodCacheMap.containsKey(key)) {
                bgPeriods = bgPeriodCacheMap.get(key);
            } else {
                bgPeriods = BgPeriodDispHelper.getPeriodNums((Context)ctx, (Date)date, (Date)this.getBgSchemeInfo().getDateFrom(), (Date)this.getBgSchemeInfo().getDateTo(), (int)periodCycle, (int)periodType, (BOSUuid)this.getBgPeriodGroup().getId());
                bgPeriodCacheMap.put(key, bgPeriods);
            }
        } else {
            bgPeriods = BgPeriodDispHelper.getPeriodNums((Context)ctx, (Date)date, (Date)this.getBgSchemeInfo().getDateFrom(), (Date)this.getBgSchemeInfo().getDateTo(), (int)periodCycle, (int)periodType, (BOSUuid)this.getBgPeriodGroup().getId());
        }
        return bgPeriods;
    }

    public static String getName(String bgSchemeId, Map<String, Map<String, String>> combinNames, String combinNumber, BgControlParam param) {
        Map<String, String> tmpMap;
        String name = null;
        if (combinNames != null && combinNames.containsKey(bgSchemeId) && (tmpMap = combinNames.get(bgSchemeId)).containsKey(combinNumber)) {
            name = tmpMap.get(combinNumber);
        }
        if (StringUtils.isEmpty(name) && !StringUtils.isEmpty((String)param.getDimItemName())) {
            String[] nums = param.getDimItemNumber().split(BgBaseConstants.SEP_THR_STR);
            String[] names = param.getDimItemName().split(BgBaseConstants.SEP_THR_STR);
            int in = nums.length;
            for (int i = 0; i < in; ++i) {
                if (nums[i] == null || !nums[i].equalsIgnoreCase(combinNumber)) continue;
                name = names[i];
            }
        }
        return name;
    }

    public static String getExtName(String bgSchemeId, Map<String, Map<String, String>> combinNames, BgControlParam param) {
        if (combinNames == null || param == null) {
            return null;
        }
        String dimNumber = param.getDimItemNumber();
        String dimName = param.getDimItemName();
        Map<String, String> nameMap = combinNames.get(bgSchemeId);
        StringBuffer extName = new StringBuffer();
        String[] dimNums = dimNumber.split(",");
        String[] dimNames = null;
        if (!StringUtils.isEmpty((String)dimName)) {
            dimNames = dimName.split(",");
        }
        int in = dimNums.length;
        for (int i = 0; i < in; ++i) {
            if (dimNums[i].equals(param.getBgIndexNumber())) continue;
            if (nameMap != null) {
                extName.append(nameMap.get(dimNums[i]) + ",");
                continue;
            }
            if (dimNames == null) continue;
            extName.append(dimNames[i] + ",");
        }
        if (extName.length() > 0) {
            extName = extName.delete(extName.length() - 1, extName.length());
        }
        if (extName.length() == 0 && param.getControlSetting().getBgDimName() != null) {
            return param.getControlSetting().getBgDimName();
        }
        return extName.toString();
    }

    public static String getExtRefField(BgControlParam param) {
        if (param == null) {
            return null;
        }
        if (param.getControlSetting().getBgDimName() != null) {
            return param.getControlSetting().getBgDimName();
        }
        String dimReffields = param.getDimNumber();
        StringBuffer extReffield = new StringBuffer();
        String[] dimNums = dimReffields.split(",");
        int in = dimNums.length;
        for (int i = 0; i < in; ++i) {
            if (dimNums[i].equals("F2")) continue;
            extReffield.append(dimNums[i] + ",");
        }
        if (extReffield.length() > 0) {
            extReffield = extReffield.delete(extReffield.length() - 1, extReffield.length());
        }
        return extReffield.toString();
    }

    public static String getExtNumber(BgControlParam param) {
        if (param == null) {
            return null;
        }
        String dimNumber = param.getDimItemNumber();
        StringBuffer extNumber = new StringBuffer();
        String[] dimNums = dimNumber.split(",");
        int in = dimNums.length;
        for (int i = 0; i < in; ++i) {
            if (dimNums[i].equals(param.getBgIndexNumber())) continue;
            extNumber.append(dimNums[i] + ",");
        }
        if (extNumber.length() > 0) {
            extNumber = extNumber.delete(extNumber.length() - 1, extNumber.length());
        }
        return extNumber.toString();
    }

    public Set<String> getGroupDimItemNumbers() {
        return this.groupDimItemNumbers;
    }

    public void setGroupDimItemNumbers(Set<String> groupDimItemNumbers) {
        this.groupDimItemNumbers = groupDimItemNumbers;
    }

    public boolean isQueryOrgEntrust() {
        return this.isQueryOrgEntrust;
    }

    public void setQueryOrgEntrust(boolean isQueryOrgEntrust) {
        this.isQueryOrgEntrust = isQueryOrgEntrust;
    }

    public BigDecimal getValue() {
        return this.getReqAmount();
    }

    public List<BgCurrencyMappingInfo> getCurrencyMappings() {
        return this.currencyMappings;
    }

    public String getBillEntryId() {
        return this.billEntryId;
    }

    public void setBillEntryId(String billEntryId) {
        this.billEntryId = billEntryId;
    }

    public List<String> getBillEntryIds() {
        return this.billEntryIds;
    }

    public String getAssistRecordsId() {
        return this.assistRecordsId;
    }

    public void setAssistRecordsId(String assistRecordsId) {
        this.assistRecordsId = assistRecordsId;
    }

    public List<String> getAssistRecords() {
        return this.assistRecords;
    }
}

