/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.SQLFacadeFactory;
import com.kingdee.eas.csinterface.utils.DataBaseType;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgControlIsomerBaseCollection;
import com.kingdee.eas.ma.control.BgControlIsomerBaseFactory;
import com.kingdee.eas.ma.control.BgControlIsomerConnectionInfo;
import com.kingdee.eas.ma.control.BgControlIsomerInfo;
import com.kingdee.eas.ma.control.BgControlIsomerSetCollection;
import com.kingdee.eas.ma.control.BgControlSchemeFacadeFactory;
import com.kingdee.eas.ma.control.face.IControlParameter;
import com.kingdee.eas.ma.control.impl.BudgetSupportBillLoader;
import com.kingdee.eas.ma.control.impl.models.BillOQLInfo;
import com.kingdee.eas.ma.control.utils.BgControlIsomerKSQLUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgControlIsomerUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.control.utils.BgControlIsomerUtils");
    private static Map<String, BgControlIsomerKSQLUtils> ksqlClient = null;

    public static String getBizUnit(Context ctx, IControlParameter parameter) {
        return parameter.getBgControlIsomer().getId().toString();
    }

    public static String getBizUnit(IControlParameter parameter) {
        return parameter.getBgControlIsomer().getId().toString();
    }

    public static void fillOUInfo(Context ctx, IControlParameter parameter) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)parameter.getOUID())) {
            BgControlIsomerBaseCollection colls = BgControlIsomerBaseFactory.getLocalInstance(ctx).getBgControlIsomerBaseCollection("select number,easNumber where connection.id='" + parameter.getBgControlIsomer().getConnection().getId() + "' and type=0 ");
            String orgNumber = parameter.getOUID();
            for (int i = 0; i < colls.size(); ++i) {
                if (!colls.get(i).getNumber().equals(parameter.getOUID())) continue;
                orgNumber = colls.get(i).getEasNumber();
                break;
            }
            try {
                FullOrgUnitInfo orgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo("select * where number='" + orgNumber + "'");
                if (orgUnit == null) {
                    throw new BgControlException(BgControlException.NOFOUNDORGUNIT, new Object[]{parameter.getOUID()});
                }
                parameter.setOUInfo(orgUnit);
                parameter.setOUID(orgUnit.getId().toString());
            }
            catch (Exception e) {
                throw new BgControlException(BgControlException.NOFOUNDORGUNIT, new Object[]{parameter.getOUID()});
            }
        }
    }

    public static Object getBillBizValue(Context ctx, String bizUnit, String bizProp, IControlParameter parameter) throws BOSException, EASBizException {
        Object bizValue;
        block8: {
            BgControlIsomerInfo isomerInfo = parameter.getBgControlIsomer();
            BgControlIsomerKSQLUtils client = BgControlIsomerUtils.getKSQLCilent(ctx, isomerInfo.getConnection()).get(isomerInfo.getConnection().getId().toString());
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put(bizProp, 1);
            String queryBizOQL = BgControlIsomerUtils.parseSql(map, parameter.getBillId(), isomerInfo);
            if (queryBizOQL == null) {
                throw new BgControlException(BgControlException.OUOQLEXECUTEFIELDERROR);
            }
            bizValue = null;
            IRowSet rst = null;
            try {
                rst = client.getTargetRowset(queryBizOQL);
                if (rst.next()) {
                    bizValue = rst.getObject(1);
                    break block8;
                }
                throw new BgControlException(BgControlException.BIZOROUIDERROR);
            }
            catch (SQLException ex) {
                logger.error((Object)"query OUOQL Error:", (Throwable)ex);
                logger.error((Object)queryBizOQL);
                throw new BgControlException(BgControlException.OUOQLEXECUTEFIELDERROR);
            }
            catch (BOSException ex) {
                logger.error((Object)"query OUOQL Error:", (Throwable)ex);
                logger.error((Object)queryBizOQL);
                throw new BOSException((Throwable)ex);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        return bizValue;
    }

    public static Map<String, BgControlIsomerKSQLUtils> getKSQLCilent(Context ctx, BgControlIsomerConnectionInfo conn) throws EASBizException, BOSException {
        if (ksqlClient == null) {
            ksqlClient = new HashMap<String, BgControlIsomerKSQLUtils>();
            BgControlIsomerKSQLUtils client = BgControlIsomerUtils.getKSQLClient(ctx, conn);
            ksqlClient.put(conn.getId().toString(), client);
        } else if (!ksqlClient.containsKey(conn.getId().toString())) {
            BgControlIsomerKSQLUtils client = BgControlIsomerUtils.getKSQLClient(ctx, conn);
            ksqlClient.put(conn.getId().toString(), client);
        } else if (ksqlClient.get(conn.getId().toString()) == null) {
            BgControlIsomerKSQLUtils client = BgControlIsomerUtils.getKSQLClient(ctx, conn);
            ksqlClient.put(conn.getId().toString(), client);
        }
        return ksqlClient;
    }

    public static BgControlIsomerKSQLUtils getKSQLClient(Context ctx, BgControlIsomerConnectionInfo conn) throws EASBizException, BOSException {
        DataBaseType dbType = DataBaseType.getInstance((String)conn.getDBType().getName());
        boolean result = false;
        result = ctx != null ? SQLFacadeFactory.getLocalInstance((Context)ctx).DBConnection(dbType.toString(), conn.getIP(), conn.getPort() + "", conn.getInstance(), conn.getUsername(), conn.getPassword()) : SQLFacadeFactory.getRemoteInstance().DBConnection(dbType.toString(), conn.getIP(), conn.getPort() + "", conn.getInstance(), conn.getUsername(), conn.getPassword());
        if (!result) {
            return null;
        }
        BgControlIsomerKSQLUtils ksqlFacadeUtil = new BgControlIsomerKSQLUtils(ctx, dbType, conn.getIP(), conn.getPort(), conn.getInstance(), conn.getUsername(), conn.getPassword());
        return ksqlFacadeUtil;
    }

    public static String getBillOUID(Context ctx, String bizUnit, IControlParameter parameter) throws BOSException, EASBizException {
        String OUID;
        block7: {
            String feild = BgControlIsomerUtils.getQueryOUOQL(ctx, bizUnit);
            if (feild == null) {
                throw new BgControlException(BgControlException.OUOQLEXECUTEFIELDERROR);
            }
            BgControlIsomerInfo isomerInfo = parameter.getBgControlIsomer();
            BgControlIsomerKSQLUtils client = BgControlIsomerUtils.getKSQLCilent(ctx, isomerInfo.getConnection()).get(isomerInfo.getConnection().getId().toString());
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put(feild, 1);
            String queryOUSQL = BgControlIsomerUtils.parseSql(map, parameter.getBillId(), isomerInfo);
            OUID = null;
            IRowSet rowset = null;
            try {
                rowset = client.getTargetRowset(queryOUSQL);
                if (rowset.next()) {
                    OUID = rowset.getString(1);
                    break block7;
                }
                throw new BgControlException(BgControlException.BIZOROUIDERROR);
            }
            catch (SQLException ex) {
                logger.error((Object)"query OUOQL Error:", (Throwable)ex);
                throw new BgControlException(BgControlException.OUOQLEXECUTEFIELDERROR);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rowset);
            }
        }
        return OUID;
    }

    public static String getQueryOUOQL(Context ctx, String bizUnit) throws BOSException, EASBizException {
        String OUFieldOQL = BgControlIsomerUtils.getBizUnitOUFieldOQL(ctx, bizUnit);
        return OUFieldOQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBizUnitOUFieldOQL(Context ctx, String boName) throws BOSException, EASBizException {
        String OUField = BudgetSupportBillLoader.getIntance().getBillOUFieldOQL(boName);
        String bizOUField = null;
        if (ctx != null) {
            IRowSet rst = null;
            try {
                rst = BgDBUtils.executeQuery((Context)ctx, (String)"select FBiz from T_MBG_BgControlData where FISDEFAULT = 1 and FBizType = ? and FBizUnit = ?", (Object[])new Object[]{1, boName});
                if (rst.next()) {
                    bizOUField = rst.getString(1);
                }
                if (bizOUField == null) {
                    throw new BgControlException(BgControlException.OUOQLEXECUTEFIELDERROR);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            catch (SQLException ex) {
                logger.error((Object)"query bizUnit sql errror:", (Throwable)ex);
            }
            finally {
                SQLUtils.cleanup(rst);
            }
        } else {
            bizOUField = BgControlSchemeFacadeFactory.getRemoteInstance().getDefaultBizUnit(boName, 1);
        }
        if (bizOUField != null) {
            OUField = bizOUField;
        }
        return OUField;
    }

    public static BillOQLInfo getQueryBillOQL(Context ctx, Object[] ruleParam, IControlParameter parameter) throws EASBizException {
        int i;
        String tmpStr = null;
        BillOQLInfo billOQL = new BillOQLInfo();
        billOQL.getField().setOrgUnit((String)ruleParam[0]);
        tmpStr = (String)ruleParam[2];
        String[] dimItems = BgControlIsomerUtils.splitCombin(tmpStr);
        int in = dimItems.length;
        for (int i2 = 0; i2 < in; ++i2) {
            dimItems[i2] = BgControlIsomerUtils.getField(BgControlIsomerUtils.splitField(dimItems[i2]));
        }
        String currency = (String)ruleParam[4];
        String bizDate = (String)ruleParam[7];
        String request = null;
        String limit = null;
        String[] requests = null;
        String[] reqExFields = null;
        request = (String)ruleParam[10];
        requests = BgControlIsomerUtils.splitField(request);
        billOQL.getField().setRequest(requests[0]);
        if (requests.length > 1) {
            billOQL.getField().setRequestEx(requests[1]);
        }
        if (!StringUtils.isEmpty((String)(tmpStr = (String)ruleParam[12]))) {
            reqExFields = tmpStr.split("\\,");
        }
        billOQL.condition = (String)ruleParam[13];
        limit = (String)ruleParam[15];
        if (!"com.kingdee.eas.fi.gl.app.Voucher".equals(parameter.getBizUnit())) {
            limit = null;
        }
        int fieldIndex = 1;
        fieldIndex = BgControlIsomerUtils.pushFieldIndex(billOQL, parameter.getBgControlIsomer().getPfiled(), fieldIndex);
        fieldIndex = BgControlIsomerUtils.pushFieldIndex(billOQL, billOQL.getField().getOrgUnit(), fieldIndex);
        StringBuffer oql = new StringBuffer();
        int in2 = dimItems.length;
        for (i = 0; i < in2; ++i) {
            fieldIndex = BgControlIsomerUtils.pushFieldIndex(billOQL, dimItems[i], fieldIndex);
        }
        fieldIndex = BgControlIsomerUtils.pushFieldIndex(billOQL, currency, fieldIndex);
        fieldIndex = BgControlIsomerUtils.pushFieldIndex(billOQL, bizDate, fieldIndex);
        fieldIndex = BgControlIsomerUtils.pushFieldIndex(billOQL, requests[0], fieldIndex);
        if (limit != null) {
            fieldIndex = BgControlIsomerUtils.pushFieldIndex(billOQL, limit, fieldIndex);
        }
        if (reqExFields != null) {
            in2 = reqExFields.length;
            for (i = 0; i < in2; ++i) {
                oql.append("," + reqExFields[i]);
                fieldIndex = BgControlIsomerUtils.pushFieldIndex(billOQL, reqExFields[i], fieldIndex);
            }
        }
        String queryOUSQL = null;
        if (billOQL.condition != null) {
            String maskString = (String)ruleParam[16];
            FilterInfo filterInfo = null;
            try {
                filterInfo = new FilterInfo(billOQL.condition, true);
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
            if (maskString != null) {
                filterInfo.setMaskString(maskString);
            }
            queryOUSQL = filterInfo != null && !filterInfo.getFilterItems().isEmpty() ? BgControlIsomerUtils.parseSql(billOQL.getFieldIndex(), parameter.getBillId(), parameter.getBgControlIsomer(), filterInfo) : BgControlIsomerUtils.parseSql(billOQL.getFieldIndex(), parameter.getBillId(), parameter.getBgControlIsomer());
        } else {
            queryOUSQL = BgControlIsomerUtils.parseSql(billOQL.getFieldIndex(), parameter.getBillId(), parameter.getBgControlIsomer());
        }
        billOQL.setBillOQL(queryOUSQL);
        billOQL.setBillSQL(queryOUSQL);
        billOQL.setItemFields(dimItems);
        billOQL.setReqExtFields(reqExFields);
        return billOQL;
    }

    public static String parseSql(Map<String, Integer> feilds, String billid, BgControlIsomerInfo isomerInfo) throws EASBizException {
        return BgControlIsomerUtils.parseSql(feilds, billid, isomerInfo, null);
    }

    public static String parseSql(Map<String, Integer> feilds, BgControlIsomerInfo isomerInfo, FilterInfo filterInfo) throws EASBizException {
        return BgControlIsomerUtils.parseSql(feilds, null, isomerInfo, filterInfo);
    }

    public static String parseSql(Map<String, Integer> feilds, String billid, BgControlIsomerInfo isomerInfo, FilterInfo filterInfo) throws EASBizException {
        boolean hasCondition = false;
        int size = 0;
        ArrayList<Map.Entry<String, Integer>> list = new ArrayList<Map.Entry<String, Integer>>(feilds.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        if (filterInfo != null) {
            hasCondition = true;
            FilterItemInfo filterItemInfo = null;
            size = filterInfo.getFilterItems().size();
            for (int i = 0; i < size; ++i) {
                filterItemInfo = filterInfo.getFilterItems().get(i);
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                map.put(filterItemInfo.getPropertyName().toUpperCase(), (Integer)((Map.Entry)list.get(list.size() - 1)).getValue() + 1);
                list.addAll(map.entrySet());
            }
        }
        StringBuffer sql = new StringBuffer("Select ");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        LinkedHashSet<String> posSet = new LinkedHashSet<String>();
        String start = null;
        String endTable = null;
        String endPos = "B";
        String condition = "";
        Object pos = null;
        int first = 0;
        int listIndex = 0;
        for (Map.Entry entry : list) {
            ++listIndex;
            String[] keys = ((String)entry.getKey()).split("\\.");
            if (keys.length == 1) {
                sql.append("A." + keys[0] + ",");
                if (list.size() - listIndex >= size) continue;
                int conditionIdex = size - (list.size() - listIndex);
                filterInfo.getFilterItems().get(conditionIdex - 1).setPropertyName("A." + keys[0]);
                continue;
            }
            BgControlIsomerSetCollection colls = isomerInfo.getSets();
            block2: for (int i = 0; i < keys.length; ++i) {
                if (!colls.isEmpty()) {
                    int j;
                    if (i == 0) {
                        for (j = 0; j < colls.size(); ++j) {
                            if (!colls.get(j).getCnumber().equals(isomerInfo.getNumber()) || !colls.get(j).getCField().equals(keys[0])) continue;
                            if (first == 0) {
                                if (colls.get(j).getConnectType().getValue().equals("1")) {
                                    start = isomerInfo.getNumber() + " A left join " + colls.get(j).getNumber() + " B on B." + colls.get(j).getMfield() + "=A." + keys[0];
                                } else if (colls.get(j).getConnectType().getValue().equals("0")) {
                                    start = isomerInfo.getNumber() + " A inner join " + colls.get(j).getNumber() + " B on B." + colls.get(j).getMfield() + "=A." + keys[0];
                                }
                                map.put(colls.get(j).getNumber(), endPos);
                                ++first;
                            } else if (!map.containsKey(colls.get(j).getNumber())) {
                                int index = TableToolkit.pos2int((String)endPos);
                                endPos = TableToolkit.int2pos((int)(index + 1));
                                if (colls.get(j).getConnectType().getValue().equals("1")) {
                                    start = start + " left join " + colls.get(j).getNumber() + " " + endPos + "  on " + endPos + "." + colls.get(j).getMfield() + "=A." + keys[0];
                                } else if (colls.get(j).getConnectType().getValue().equals("0")) {
                                    start = start + " inner join " + colls.get(j).getNumber() + " " + endPos + "  on " + endPos + "." + colls.get(j).getMfield() + "=A." + keys[0];
                                }
                                map.put(colls.get(j).getNumber(), endPos);
                            } else if (keys.length < 3) {
                                endPos = (String)map.get(colls.get(j).getNumber());
                            }
                            posSet.add(endPos);
                            endTable = colls.get(j).getNumber();
                            continue block2;
                        }
                        continue;
                    }
                    if (i == keys.length - 1) {
                        sql.append(endPos + "." + keys[keys.length - 1] + ",");
                        if (list.size() - listIndex >= size) continue;
                        int conditionIdex = size - (list.size() - listIndex);
                        filterInfo.getFilterItems().get(conditionIdex - 1).setPropertyName(endPos + "." + keys[keys.length - 1]);
                        continue;
                    }
                    for (j = 0; j < colls.size(); ++j) {
                        String startPos;
                        if (!colls.get(j).getCnumber().equals(endTable) || !colls.get(j).getCField().equals(keys[i])) continue;
                        if (!map.containsKey(colls.get(j).getNumber())) {
                            startPos = (String)map.get(colls.get(j).getCnumber());
                            int index = TableToolkit.pos2int((String)endPos);
                            if (posSet.contains(endPos = TableToolkit.int2pos((int)(index + 1)))) {
                                ArrayList result = new ArrayList(posSet);
                                index = TableToolkit.pos2int((String)((String)result.get(result.size() - 1)));
                                endPos = TableToolkit.int2pos((int)(index + 1));
                            }
                            if (colls.get(j).getConnectType().getValue().equals("1")) {
                                start = start + " left join " + colls.get(j).getNumber() + " " + endPos + "  on " + endPos + "." + colls.get(j).getMfield() + "=" + startPos + "." + keys[i];
                            } else if (colls.get(j).getConnectType().getValue().equals("0")) {
                                start = start + " inner join " + colls.get(j).getNumber() + " " + endPos + "  on " + endPos + "." + colls.get(j).getMfield() + "=" + startPos + "." + keys[i];
                            }
                            map.put(colls.get(j).getNumber(), endPos);
                        } else {
                            startPos = (String)map.get(colls.get(j).getCnumber());
                            ArrayList result = new ArrayList(posSet);
                            int index = TableToolkit.pos2int((String)((String)result.get(result.size() - 1)));
                            endPos = TableToolkit.int2pos((int)(index + 1));
                            if (colls.get(j).getConnectType().getValue().equals("1")) {
                                start = start + " left join " + colls.get(j).getNumber() + " " + endPos + "  on " + endPos + "." + colls.get(j).getMfield() + "=" + startPos + "." + keys[i];
                            } else if (colls.get(j).getConnectType().getValue().equals("0")) {
                                start = start + " inner join " + colls.get(j).getNumber() + " " + endPos + "  on " + endPos + "." + colls.get(j).getMfield() + "=" + startPos + "." + keys[i];
                            }
                        }
                        posSet.add(endPos);
                        endTable = colls.get(j).getNumber();
                        continue block2;
                    }
                    continue;
                }
                throw new BgControlException(BgControlException.BIZOROUIDERROR);
            }
        }
        start = start != null ? start : isomerInfo.getNumber() + " A ";
        String fieldSql = sql.substring(0, sql.length() - 1);
        if (hasCondition) {
            String[] stringArray = fieldSql.split(",");
            String subField = "";
            for (int k = 0; k < stringArray.length - size; ++k) {
                subField = k == 0 ? stringArray[0] : subField + "," + stringArray[k];
            }
            fieldSql = subField;
            condition = billid != null ? " and " + filterInfo.toSql() : filterInfo.toSql();
        }
        if (billid != null) {
            return fieldSql + " from " + start + " where A." + isomerInfo.getPfiled() + "='" + billid + "' " + condition;
        }
        return fieldSql + " from " + start + " where " + condition;
    }

    public static String[] splitField(String combin) {
        if (!StringUtils.isEmpty((String)combin)) {
            return combin.split("\\|");
        }
        return null;
    }

    public static String[] splitCombin(String rule) {
        if (!StringUtils.isEmpty((String)rule)) {
            return rule.split("\\@");
        }
        return null;
    }

    public static String getField(String[] oneCombin) {
        if (oneCombin != null && oneCombin.length > 0) {
            return oneCombin[0];
        }
        return null;
    }

    public static String getFieldName(String field) {
        if (!StringUtils.isEmpty((String)field)) {
            return BgControlIsomerUtils.getNameField(field);
        }
        return null;
    }

    public static String getFieldNumber(String[] oneCombin) {
        if (oneCombin != null && oneCombin.length > 1) {
            return oneCombin[1];
        }
        return null;
    }

    private static int pushFieldIndex(BillOQLInfo billOQLInfo, String fieldStr, int fieldIndex) {
        if (!billOQLInfo.getFieldIndex().containsKey(fieldStr)) {
            billOQLInfo.getFieldIndex().put(fieldStr, fieldIndex);
            ++fieldIndex;
        }
        return fieldIndex;
    }

    private static String getNameField(String itemNumber) {
        return itemNumber;
    }

    public static String transBillSQL(Context ctx, String sql, Object[] ruleParam, IControlParameter parameter) {
        String condition = (String)ruleParam[13];
        if (!StringUtils.isEmpty((String)condition)) {
            sql = sql.replaceAll("INNER JOIN", "LEFT OUTER JOIN");
        }
        return sql;
    }

    public static Date getDate(Date date, String type) {
        if (date == null) {
            return null;
        }
        Date initDate = date;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        if (type.contains(DataType.TIMESTAMP.getName().toUpperCase())) {
            initDate = new Timestamp(cal.getTime().getTime());
        } else if (type.contains(DataType.TIME.getName().toUpperCase())) {
            cal.set(13, 0);
            initDate = new Time(cal.getTime().getTime());
        } else if (type.contains(DataType.DATE.getName().toUpperCase())) {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            initDate = cal.getTime();
        }
        return initDate;
    }
}

