/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.gpgc.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.custom.gpgc.GpgcReportFacadeFactory;
import com.kingdee.eas.custom.gpgc.IGpgcReportFacade;
import com.kingdee.eas.custom.gpgc.client.AbstractAccountBankBalanceEditUI;
import com.kingdee.eas.custom.gpgc.client.BankItemInfo;
import com.kingdee.eas.custom.gpgc.client.ReportClientUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class AccountBankBalanceEditUI
extends AbstractAccountBankBalanceEditUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountBankBalanceEditUI.class);
    private static final String NUMBER_FORMATE = "#,###0.00";
    private String All_Account = "\u5168\u90e8";
    private int accountCount = 0;
    private static final String NONG_XIN = "20";
    private static final String OHTER_BANK = "21";
    private static final String CASH_BANK = "22";
    private static final String delimiter = "__";
    KDComboBox combAccount = new KDComboBox();
    KDComboBox combBank = new KDComboBox();
    private List lstXinYongShe = null;
    private List lstOtherBank = null;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        this.setUITitle("\u8d26\u6237\u4f59\u989d\u6c47\u603b\u8868\u5f55\u5165");
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSave.setEnabled(true);
        this.initTable();
        this.getAccounts();
        this.initComBoxAccount();
        this.setComBoxEditForBank();
        this.setNumberEditor();
        this.tblMain.getColumn(1).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.combAccount));
        this.addCombListener();
    }

    private void initTable() {
        this.tblMain.checkParsed();
        this.tblMain.addRow();
    }

    private void setComBoxEditForBank() {
        BankItemInfo item = new BankItemInfo();
        item.banktype = NONG_XIN;
        item.name = "\u519c\u6751\u4fe1\u7528\u793e";
        this.combBank.addItem((Object)item);
        item = new BankItemInfo();
        item.banktype = OHTER_BANK;
        item.name = "\u5176\u4ed6\u91d1\u878d\u673a\u6784";
        this.combBank.addItem((Object)item);
        item = new BankItemInfo();
        item.banktype = CASH_BANK;
        item.name = "\u73b0\u91d1";
        this.combBank.addItem((Object)item);
    }

    private void setNumberEditor() {
        KDFormattedTextField kft = new KDFormattedTextField();
        kft.setDataType(4);
        kft.setDataVerifierType(12);
        kft.setPrecision(6);
        for (int i = 2; i < 6; ++i) {
            IColumn col = this.tblMain.getColumn(i);
            col.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)kft));
            col.getStyleAttributes().setNumberFormat(NUMBER_FORMATE);
            col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            col.setWidth(150);
        }
        this.tblMain.getColumn(5).getStyleAttributes().setLocked(true);
    }

    private void getAccounts() throws Exception {
        this.lstXinYongShe = this.getAccount(NONG_XIN);
        this.lstOtherBank = this.getAccount(OHTER_BANK);
    }

    private void initComBoxAccount() {
        this.addAccountToCombox(NONG_XIN);
    }

    private void addAccountToCombox(String number) {
        this.combAccount.removeAllItems();
        if (number.equalsIgnoreCase(NONG_XIN)) {
            int size = this.lstXinYongShe.size();
            for (int i = 0; i < size; ++i) {
                this.combAccount.addItem(this.lstXinYongShe.get(i));
            }
        } else {
            int size = this.lstOtherBank.size();
            for (int i = 0; i < size; ++i) {
                this.combAccount.addItem(this.lstOtherBank.get(i));
            }
        }
    }

    private void addCombListener() {
        this.combBank.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item;
                if (e.getStateChange() == 1 && (item = AccountBankBalanceEditUI.this.combBank.getSelectedItem()) != null) {
                    String number = ((BankItemInfo)item).banktype;
                    AccountBankBalanceEditUI.this.addAccountToCombox(number);
                }
            }
        });
        this.tblMain.getColumn(0).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.combBank));
        this.combAccount.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && e.getItem().toString().equalsIgnoreCase(AccountBankBalanceEditUI.this.All_Account)) {
                    int rowIndex = KDTableUtil.getSelectedRow((KDTable)AccountBankBalanceEditUI.this.tblMain);
                    AccountBankBalanceEditUI.this.tblMain.getCell(rowIndex, 1).setValue(AccountBankBalanceEditUI.this.combAccount.getItemAt(1));
                    for (int i = 2; i < AccountBankBalanceEditUI.this.accountCount; ++i) {
                        IRow row = AccountBankBalanceEditUI.this.tblMain.addRow();
                        row.getCell(1).setValue(AccountBankBalanceEditUI.this.combAccount.getItemAt(i));
                    }
                }
            }
        });
    }

    private List getAccount(String bankNumber) throws Exception {
        return ReportClientUtil.getAccount(bankNumber);
    }

    @Override
    protected void btnAdd_mouseClicked(MouseEvent e) throws Exception {
        this.tblMain.addRow();
    }

    @Override
    protected void btnDelete_mouseClicked(MouseEvent e) throws Exception {
        int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (rowIndex != -1) {
            this.tblMain.removeRow(rowIndex);
        } else {
            this.tblMain.removeRow(this.tblMain.getRowCount() - 1);
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        HashMap mapValue = this.getDataFromTable();
        IGpgcReportFacade facade = GpgcReportFacadeFactory.getRemoteInstance();
        facade.saveAccountBalance(mapValue);
        MsgBox.showInfo((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    private HashMap getDataFromTable() {
        HashMap<String, double[]> map = new HashMap<String, double[]>(64);
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.getRow(i);
            String key = ((BankItemInfo)row.getCell((int)0).getValue()).banktype + delimiter + row.getCell(1).getValue();
            if (map.containsKey(key)) continue;
            double[] values = new double[]{this.getValueFromCell(i, 2), this.getValueFromCell(i, 3), this.getValueFromCell(i, 4)};
            map.put(key, values);
        }
        return map;
    }

    private double getValueFromCell(int row, int col) {
        return ReportClientUtil.getValueFromCell(this.tblMain, row, col);
    }
}

