/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.gpgc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.eas.custom.gpgc.client.ReportClientUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Date;

public class AccountBankBalanceHelper {
    public static final int HQ = 1;
    public static final int GDJ = 2;
    private int type = 1;
    private KDTable tblMain = null;
    private Date dateQuery = null;
    private int startRow = 0;
    private static final int END_COL_INDEX = 3;
    private static final int START_COL_INDEX = 1;
    private static final String NONG_XIN = "20";
    private static final String OHTER_BANK = "21";

    public AccountBankBalanceHelper(int type, Date dateQuery, KDTable tblMain) {
        this.type = type;
        this.dateQuery = dateQuery;
        this.tblMain = tblMain;
        if (type == 1) {
            this.startRow = 4;
        }
    }

    private String getQuerySql() throws BOSException {
        String dateSql = ReportClientUtil.getDatePeriodString("bizdate", this.dateQuery);
        return "select accountbank_number,bankinterfacetype,balance from v_be_accountbalance where  ( accountbank_number not like '00.01.%' and accountbank_number not like '00.02.%')  and " + dateSql;
    }

    private IRowSet getRowSet(String sql) throws BOSException {
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        return exec.executeSQL();
    }

    public void fillDataToTable() throws Exception {
        String sql = this.getQuerySql();
        System.out.println(sql);
        IRowSet rs = this.getRowSet(sql);
        while (rs.next()) {
            String accountNumber = rs.getString(1);
            char ch = accountNumber.charAt(6);
            int col = this.getColIndex(ch);
            int bankType = rs.getInt(2);
            int row = this.getRowIndex(bankType);
            ICell cell = this.tblMain.getCell(row, col);
            double value = this.getValueFromCell(row, col);
            cell.setValue((Object)new Double(value += rs.getDouble(3)));
        }
    }

    private int getRowIndex(int bankType) {
        int index = this.startRow;
        switch (bankType) {
            case 2: {
                index = this.startRow;
                break;
            }
            case 3: {
                index = this.startRow + 1;
                break;
            }
            case 4: {
                index = this.startRow + 2;
                break;
            }
            default: {
                index = this.startRow + 4;
            }
        }
        return index;
    }

    private int getColIndex(char type) {
        int index = 1;
        index = type == 'A' ? 1 : (type == 'B' ? 2 : 3);
        return index;
    }

    private Double getValueFromCell(int row, int col) {
        return ReportClientUtil.getValueFromCell(this.tblMain, row, col);
    }

    public void sum() {
        this.sumRow();
        this.sumCol();
    }

    public void sumRow() {
        int size = this.tblMain.getRowCount();
        for (int i = this.startRow; i < size; ++i) {
            double sum = 0.0;
            for (int j = 1; j <= 3; ++j) {
                sum += this.getValueFromCell(i, j).doubleValue();
            }
            this.tblMain.getCell(i, 4).setValue((Object)new Double(sum));
        }
    }

    public void sumCol() {
        int rowIndex = 4;
        if (this.type == 2) {
            rowIndex = this.tblMain.getRowCount();
        }
        int rowsize = this.tblMain.getRowCount();
        for (int i = 1; i <= 3; ++i) {
            double sum = 0.0;
            for (int j = this.startRow; j < rowsize; ++j) {
                sum += this.getValueFromCell(j, i).doubleValue();
            }
            this.tblMain.getCell(rowIndex - 1, i).setValue((Object)new Double(sum));
        }
    }

    public void getSelfValueFromDB() throws Exception {
        String strDate = ReportClientUtil.getFixedDataStr(this.dateQuery);
        String dateSql = " fdate = {ts'" + strDate + "'}";
        String sql = "select fbanktype,sum(finbalance),sum(foutbalance),sum(fspecbalance) from t_gpgc_accountbalance where " + dateSql + " group by fbanktype";
        System.out.println(sql);
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = exec.executeSQL();
        while (rs.next()) {
            IRow row = this.tblMain.addRow();
            String banktype = rs.getString("fbanktype");
            row.getCell(0).setValue((Object)this.getBankName(banktype));
            row.getCell(1).setValue((Object)new Double(rs.getDouble(2)));
            row.getCell(2).setValue((Object)new Double(rs.getDouble(3)));
            row.getCell(3).setValue((Object)new Double(rs.getDouble(4)));
        }
    }

    private String getBankName(String banktype) {
        String bankname = "";
        bankname = banktype.equalsIgnoreCase(NONG_XIN) ? "\u519c\u6751\u4fe1\u7528\u793e" : (banktype.equalsIgnoreCase(OHTER_BANK) ? "\u5176\u4ed6\u91d1\u878d\u673a\u6784" : "\u73b0\u91d1");
        return bankname;
    }
}

