/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.gpgc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.custom.gpgc.client.AbstractAccountBankBalanceUI;
import com.kingdee.eas.custom.gpgc.client.AccountBankBalanceEditUI;
import com.kingdee.eas.custom.gpgc.client.AccountBankBalanceHelper;
import com.kingdee.eas.custom.gpgc.client.ReportClientUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

public class AccountBankBalanceUI
extends AbstractAccountBankBalanceUI {
    private static final String NUMBER_FORMATE = "#,###0.00";
    private Date dateQuery = new Date();
    private AccountBankBalanceHelper helper = null;

    public void onLoad() throws Exception {
        this.btnRefresh.setEnabled(true);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnFilter.setEnabled(true);
        this.btnFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.helper = new AccountBankBalanceHelper(1, this.dateQuery, this.tblMain);
        this.setUITitle("\u8d26\u6237\u4f59\u989d\u6c47\u603b\u8868");
        this.initTable();
    }

    private void initTable() {
        for (int i = 0; i < 5; ++i) {
            this.tblMain.addColumn();
        }
        IRow row = this.tblMain.addRow();
        row.getCell(0).setValue((Object)"\u5355\u4f4d");
        row.getCell(1).setValue((Object)"\u8d27\u5e01\u8d44\u91d1\u671f\u672b\u4f59\u989d");
        row.getCell(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        row = this.tblMain.addRow();
        row.getCell(0).setValue((Object)"\u5408\u8ba1");
        row.getStyleAttributes().setBold(true);
        row.getCell(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        row = this.tblMain.addRow();
        row.getCell(0).setValue((Object)"\u603b\u90e8");
        row.getStyleAttributes().setBold(true);
        row.getCell(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        row = this.tblMain.addRow();
        row.getCell(0).setValue((Object)"\u4f9b\u7535\u5c40");
        row.getCell(0).getStyleAttributes().setBold(true);
        row.getCell(1).setValue((Object)"\u6536\u5165\u6237");
        row.getCell(2).setValue((Object)"\u652f\u51fa\u6237");
        row.getCell(3).setValue((Object)"\u4e13\u6237");
        row.getCell(4).setValue((Object)"\u5408\u8ba1");
        row = this.tblMain.addRow();
        row.getCell(0).setValue((Object)"\u5c0f\u8ba1");
        row.getStyleAttributes().setBold(true);
        row = this.tblMain.addRow();
        row.getCell(0).setValue((Object)"\u5de5\u5546\u94f6\u884c");
        row = this.tblMain.addRow();
        row.getCell(0).setValue((Object)"\u5efa\u8bbe\u94f6\u884c");
        row = this.tblMain.addRow();
        row.getCell(0).setValue((Object)"\u4e2d\u56fd\u94f6\u884c");
        row = this.tblMain.addRow();
        row.getCell(0).setValue((Object)"\u519c\u4e1a\u94f6\u884c");
        for (int i = 1; i < 5; ++i) {
            this.tblMain.getColumn(i).setWidth(200);
            this.tblMain.getColumn(i).getStyleAttributes().setNumberFormat(NUMBER_FORMATE);
        }
        KDTMergeManager merger = this.tblMain.getMergeManager();
        merger.mergeBlock(0, 1, 0, 4);
        merger.mergeBlock(1, 1, 1, 4);
        merger.mergeBlock(2, 1, 2, 4);
        this.tblMain.getStyleAttributes().setLocked(true);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.tblMain.removeRows();
        this.tblMain.removeColumns();
        this.initTable();
        this.getQueryResult();
    }

    private void getQueryResult() throws Exception {
        this.helper.fillDataToTable();
        this.helper.getSelfValueFromDB();
        BigDecimal bigValue = this.getHQBalance();
        this.tblMain.getCell(2, 1).setValue((Object)this.getHQBalance());
        this.helper.sum();
        double value = ReportClientUtil.getValueFromCell(this.tblMain, 4, 4);
        this.tblMain.getCell(1, 1).setValue((Object)new Double(value += bigValue.doubleValue()));
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        ReportClientUtil.showDateFilterUI(this);
        Map map = this.getUIContext();
        if (map.containsKey("QueryDate")) {
            this.dateQuery = (Date)map.get("QueryDate");
        }
        this.actionRefresh_actionPerformed(null);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        String className = AccountBankBalanceEditUI.class.getName();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        IUIWindow curDialog = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext, null, OprtState.VIEW);
        curDialog.show();
    }

    private BigDecimal getHQBalance() throws Exception {
        String dateSql = ReportClientUtil.getDatePeriodString("bizdate", this.dateQuery);
        String sql = "select sum(balance) as total from v_be_accountbalance where  ( accountbank_number like '00.01.%')  and " + dateSql;
        System.out.println(sql);
        IRowSet rs = this.getRowSet(sql);
        if (rs.next()) {
            double value = rs.getDouble(1);
            return new BigDecimal(value);
        }
        return new BigDecimal("0.00d");
    }

    private IRowSet getRowSet(String sql) throws BOSException {
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        return exec.executeSQL();
    }
}

