/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.gpgc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.custom.gpgc.client.AbstractAccountInOutUI;
import com.kingdee.eas.custom.gpgc.client.ReportClientUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AccountInOutUI
extends AbstractAccountInOutUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountInOutUI.class);
    private static final String NUMBER_FORMATE = "#,###0.00";
    private HashMap mapAccountNumber = new HashMap(1024);
    private HashMap mapCompanyValue = new HashMap(32);
    private Date startDate = new Date();
    private Date endDate = new Date();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnRefresh.setEnabled(true);
        this.btnFilter.setEnabled(true);
        this.setUITitle("\u6240\u6709\u8d26\u6237\u4ea4\u6613\u60c5\u51b5\u6c47\u603b\u8868");
        this.mapAccountNumber = ReportClientUtil.getAccountNumber();
        this.initTable();
        this.fillDateToTable();
    }

    private void initTable() {
        for (int i = 0; i < 3; ++i) {
            IColumn col = this.tblMain.addColumn();
            col.setWidth(150);
        }
        this.tblMain.getColumn(1).getStyleAttributes().setNumberFormat(NUMBER_FORMATE);
        this.tblMain.getColumn(2).getStyleAttributes().setNumberFormat(NUMBER_FORMATE);
        this.tblMain.getColumn(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(2).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        IRow row = this.tblMain.addRow();
        row.getCell(0).setValue((Object)"\u5355\u4f4d");
        row.getCell(1).setValue((Object)"\u5408\u8ba1");
        row.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        row = this.tblMain.addRow();
        row.getCell(1).setValue((Object)"\u6d41\u5165");
        row.getCell(2).setValue((Object)"\u6d41\u51fa");
        row.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        KDTMergeManager merge = this.tblMain.getMergeManager();
        merge.setMergeMode(1);
        merge.mergeBlock(0, 1, 0, 2);
        merge.setMergeMode(2);
        merge.mergeBlock(0, 0, 1, 0);
        row = this.tblMain.addRow();
        row.getCell(0).setValue((Object)"\u96c6\u56e2\u5408\u5e76");
        this.tblMain.getStyleAttributes().setLocked(true);
    }

    private IRowSet getRowSet(String sql) throws BOSException {
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        return exec.executeSQL();
    }

    private String getQuerySql() throws BOSException {
        String dateSql = " biztime >= {ts'" + ReportClientUtil.getFixedDataStr(this.startDate) + "'}";
        dateSql = dateSql + " and biztime <= {ts'" + ReportClientUtil.getFixedDataStr(this.endDate) + "'}";
        return "select company_name,oppbanknumber,debitAmount,creditAmount from v_be_transdetail where " + dateSql;
    }

    private void fillDateToTable() throws BOSException, SQLException {
        String sql = this.getQuerySql();
        System.out.println(sql);
        IRowSet rs = this.getRowSet(sql);
        IRow row = null;
        int rowIndex = 0;
        int currentIndex = 2;
        BigDecimal inSum = new BigDecimal("0.0");
        BigDecimal outSum = new BigDecimal("0.0");
        while (rs.next()) {
            String company = rs.getString(1).trim();
            String number = rs.getString(2);
            if (this.isInnerAccount(number)) continue;
            BigDecimal inEachValue = rs.getBigDecimal(3);
            BigDecimal outEachValue = rs.getBigDecimal(4);
            inSum = inSum.add(inEachValue);
            outSum = outSum.add(outEachValue);
            if (this.mapCompanyValue.containsKey(company)) {
                rowIndex = (Integer)this.mapCompanyValue.get(company);
                row = this.tblMain.getRow(rowIndex);
                BigDecimal inValue = (BigDecimal)row.getCell(1).getValue();
                BigDecimal outValue = (BigDecimal)row.getCell(2).getValue();
                inValue = inValue.add(inEachValue);
                outValue = outValue.add(outEachValue);
                row.getCell(1).setValue((Object)inValue);
                row.getCell(2).setValue((Object)outValue);
                continue;
            }
            row = this.tblMain.addRow();
            this.mapCompanyValue.put(company, new Integer(++currentIndex));
            row.getCell(0).setValue((Object)company);
            row.getCell(1).setValue((Object)inEachValue);
            row.getCell(2).setValue((Object)outEachValue);
        }
        this.tblMain.getCell(2, 1).setValue((Object)inSum);
        this.tblMain.getCell(2, 2).setValue((Object)outSum);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.clearData();
        this.fillDateToTable();
    }

    private void clearData() {
        for (int i = this.tblMain.getRowCount(); i >= 3; --i) {
            this.tblMain.removeRow(i);
        }
        this.mapCompanyValue.clear();
    }

    private boolean isInnerAccount(String number) {
        return this.mapAccountNumber.containsKey(number);
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        super.actionFilter_actionPerformed(e);
        ReportClientUtil.showDatePeriodFilterUI(this);
        Map map = this.getUIContext();
        if (map.containsKey("StartDate")) {
            this.startDate = (Date)map.get("StartDate");
        }
        if (map.containsKey("EndDate")) {
            this.endDate = (Date)map.get("EndDate");
        }
        this.actionRefresh_actionPerformed(null);
    }
}

