/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.gpgc.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.custom.gpgc.client.AbstractAccountOutTransDetailUI;
import com.kingdee.eas.custom.gpgc.client.ReportClientUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AccountOutTransDetailUI
extends AbstractAccountOutTransDetailUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountOutTransDetailUI.class);
    private List lstItemName = new ArrayList(32);
    private Map mapColPos = new HashMap(32);
    private Map mapCompany = new HashMap(32);
    private Date startDate = DateTimeUtils.addMonth((Date)new Date(), (int)-2);
    private Date endDate = new Date();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.tblMain.removeRows();
        this.mapCompany.clear();
        this.getQueryResult();
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        ReportClientUtil.showDatePeriodFilterUI(this);
        Map map = this.getUIContext();
        if (map.containsKey("StartDate")) {
            this.startDate = (Date)map.get("StartDate");
        }
        if (map.containsKey("EndDate")) {
            this.endDate = (Date)map.get("EndDate");
        }
        this.actionRefresh_actionPerformed(null);
    }

    private String getDateSql() {
        return ReportClientUtil.getQueryDateCondition("biztime", this.startDate, this.endDate);
    }

    public void onLoad() throws Exception {
        this.setUITitle("\u652f\u51fa\u6237\u4ea4\u6613\u660e\u7ec6\u6c47\u603b\u8868");
        this.btnRefresh.setEnabled(true);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnFilter.setEnabled(true);
        this.btnFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.init();
        this.getQueryResult();
    }

    private void init() {
        this.initItemNameList();
        this.initMapPos();
        this.initTable();
    }

    private void initItemNameList() {
        this.lstItemName.add("\u5355\u4f4d");
        this.lstItemName.add("\u5408\u8ba1\u6d41\u51fa");
        this.lstItemName.add("\u7535\u8d39");
        this.lstItemName.add("\u6750\u6599\u6b3e");
        this.lstItemName.add("\u7a0e\u6b3e");
        this.lstItemName.add("\u519c\u7535\u670d\u52a1\u8d39");
        this.lstItemName.add("\u4fee\u7406\u8d39");
        this.lstItemName.add("\u4e09\u5ce1\u57fa\u91d1");
        this.lstItemName.add("\u8fd8\u8d37");
        this.lstItemName.add("\u57ce\u5efa\u9644\u52a0\u8d39");
        this.lstItemName.add("\u5176\u4ed6\u4f9b\u7535\u6210\u672c");
        this.lstItemName.add("\u5176\u4ed6\u7ecf\u8425\u6027\u652f\u51fa");
        this.lstItemName.add("\u8d44\u672c\u6027\u652f\u51fa");
    }

    private void initTable() {
        int i;
        IRow row = this.tblMain.addHeadRow();
        int size = this.lstItemName.size();
        for (i = 0; i < size; ++i) {
            this.tblMain.addColumn();
        }
        for (i = 0; i < size; ++i) {
            row.getCell(i).setValue(this.lstItemName.get(i));
        }
    }

    private void initMapPos() {
        this.mapColPos.put("A01", new Integer(2));
        this.mapColPos.put("A02", new Integer(3));
        this.mapColPos.put("A06", new Integer(4));
        this.mapColPos.put("A04", new Integer(5));
        this.mapColPos.put("A03", new Integer(6));
        this.mapColPos.put("A08", new Integer(7));
        this.mapColPos.put("C01", new Integer(8));
        this.mapColPos.put("A07", new Integer(9));
        this.mapColPos.put("B06", new Integer(10));
        this.mapColPos.put("A11", new Integer(11));
        this.mapColPos.put("B07", new Integer(12));
    }

    private String getQuerySql() {
        return "select company_number,company_name,transcode,creditamount,debitamount from v_be_transdetail ";
    }

    private void getQueryResult() throws Exception {
        this.fillDataToTable();
        this.sumCol();
    }

    private void fillDataToTable() throws Exception {
        int rowIndex = 0;
        int currRowIndex = 0;
        int colIndex = 0;
        IRow row = null;
        String companyId = null;
        String sql = this.getQuerySql();
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = exec.executeSQL();
        while (rs.next()) {
            companyId = rs.getString("company_number");
            if (this.mapCompany.containsKey(companyId)) {
                rowIndex = (Integer)this.mapCompany.get(companyId);
                row = this.tblMain.getRow(rowIndex);
            } else {
                row = this.tblMain.addRow();
                this.mapCompany.put(companyId, new Integer(currRowIndex++));
            }
            if (row == null) continue;
            row.getCell(0).setValue((Object)rs.getString("company_name"));
            colIndex = this.getColIndex("transcode");
            row.getCell(colIndex).setValue((Object)new Double(rs.getDouble("creditamount")));
        }
    }

    private int getColIndex(String code) {
        if (!this.mapColPos.containsKey(code)) {
            return 12;
        }
        return (Integer)this.mapColPos.get(code);
    }

    private void sumCol() {
    }

    private double getCellValue(int row, int col) {
        return ReportClientUtil.getValueFromCell(this.tblMain, row, col);
    }
}

